[![Actions Status](https://github.com/pulumi/pulumi-aws-apigateway/actions/workflows/release.yml/badge.svg)](https://github.com/pulumi/pulumi-aws-apigateway/actions)
[![Slack](http://www.pulumi.com/images/docs/badges/slack.svg)](https://slack.pulumi.com)
[![NPM version](https://badge.fury.io/js/%40pulumi%2Faws-apigateway.svg)](https://www.npmjs.com/package/@pulumi/aws-apigateway)
[![Python version](https://badge.fury.io/py/pulumi-aws-apigateway.svg)](https://pypi.org/project/pulumi-aws-apigateway)
[![NuGet version](https://badge.fury.io/nu/pulumi.awsapigateway.svg)](https://badge.fury.io/nu/pulumi.awsapigateway)
[![PkgGoDev](https://pkg.go.dev/badge/github.com/pulumi/pulumi-aws-apigateway/sdk/go)](https://pkg.go.dev/github.com/pulumi/pulumi-aws-apigateway/sdk/go)
[![License](https://img.shields.io/github/license/pulumi/pulumi-aws-apigateway)](https://github.com/pulumi/pulumi-aws-apigateway/blob/master/LICENSE)

# Pulumi AWS API Gateway Component

The Pulumi AWS API Gateway library provides a Pulumi component that easily creates AWS API Gateway REST APIs. This component exposes the Crosswalk for AWS functionality documented in the [Pulumi AWS API Gateway guide](https://www.pulumi.com/docs/guides/crosswalk/aws/api-gateway/) as a package available in all Pulumi languages.

<div>
    <a href="https://www.pulumi.com/templates/serverless-application/aws/" title="Get Started">
       <img src="https://www.pulumi.com/images/get-started.svg?" width="120">
    </a>
</div>

## Installing

This package is available in many languages in the standard packaging formats.

### Node.js (JavaScript/TypeScript)

To use from JavaScript or TypeScript in Node.js, install using either `npm`:

    npm install @pulumi/aws-apigateway

or `yarn`:

    yarn add @pulumi/aws-apigateway

### Python

To use from Python, install using `pip`:

    pip install pulumi-aws-apigateway

### Go

To use from Go, use `go get` to grab the latest version of the library

    go get github.com/pulumi/pulumi-aws-apigateway/sdk

### .NET

To use from .NET, install using `dotnet add package`:

    dotnet add package Pulumi.AwsApiGateway

## References

* [Tutorial](https://www.pulumi.com/templates/serverless-application/aws/)
* [API Reference Documentation](https://www.pulumi.com/registry/packages/aws-apigateway/api-docs/)
* [Examples](./examples)
* [Crosswalk for AWS - API Gateway Guide](https://www.pulumi.com/docs/guides/crosswalk/aws/api-gateway/)