"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
class ExampleConstruct extends cdk.Construct {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        const role = new lib_1.Role(this, 'MyRole', {
            assumedBy: new lib_1.ServicePrincipal('sns.amazonaws.com')
        });
        role.addToPolicy(new lib_1.PolicyStatement({
            resources: ['*'],
            actions: ['lambda:InvokeFunction']
        }));
        /// !hide
    }
}
exports.ExampleConstruct = ExampleConstruct;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhhbXBsZS5yb2xlLmxpdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImV4YW1wbGUucm9sZS5saXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxvQ0FBcUM7QUFDckMsZ0NBQWlFO0FBRWpFLE1BQWEsZ0JBQWlCLFNBQVEsR0FBRyxDQUFDLFNBQVM7SUFDakQsWUFBWSxLQUFvQixFQUFFLEVBQVU7UUFDMUMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixTQUFTO1FBQ1QsTUFBTSxJQUFJLEdBQUcsSUFBSSxVQUFJLENBQUMsSUFBSSxFQUFFLFFBQVEsRUFBRTtZQUNwQyxTQUFTLEVBQUUsSUFBSSxzQkFBZ0IsQ0FBQyxtQkFBbUIsQ0FBQztTQUNyRCxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUkscUJBQWUsQ0FBQztZQUNuQyxTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7WUFDaEIsT0FBTyxFQUFFLENBQUMsdUJBQXVCLENBQUM7U0FBRSxDQUFDLENBQUMsQ0FBQztRQUN6QyxTQUFTO0lBQ1gsQ0FBQztDQUNGO0FBZEQsNENBY0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgY2RrID0gcmVxdWlyZSgnQGF3cy1jZGsvY2RrJyk7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQsIFJvbGUsIFNlcnZpY2VQcmluY2lwYWwgfSBmcm9tICcuLi9saWInO1xuXG5leHBvcnQgY2xhc3MgRXhhbXBsZUNvbnN0cnVjdCBleHRlbmRzIGNkay5Db25zdHJ1Y3Qge1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAvLy8gIXNob3dcbiAgICBjb25zdCByb2xlID0gbmV3IFJvbGUodGhpcywgJ015Um9sZScsIHtcbiAgICAgIGFzc3VtZWRCeTogbmV3IFNlcnZpY2VQcmluY2lwYWwoJ3Nucy5hbWF6b25hd3MuY29tJylcbiAgICB9KTtcblxuICAgIHJvbGUuYWRkVG9Qb2xpY3kobmV3IFBvbGljeVN0YXRlbWVudCh7XG4gICAgICByZXNvdXJjZXM6IFsnKiddLFxuICAgICAgYWN0aW9uczogWydsYW1iZGE6SW52b2tlRnVuY3Rpb24nXSB9KSk7XG4gICAgLy8vICFoaWRlXG4gIH1cbn1cbiJdfQ==