"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const app = new cdk_1.App();
const stack = new cdk_1.Stack(app, 'integ-iam-role-1');
const role = new lib_1.Role(stack, 'TestRole', {
    assumedBy: new lib_1.ServicePrincipal('sqs.amazonaws.com')
});
role.addToPolicy(new lib_1.PolicyStatement({ resources: ['*'], actions: ['sqs:SendMessage'] }));
const policy = new lib_1.Policy(stack, 'HelloPolicy', { policyName: 'Default' });
policy.addStatements(new lib_1.PolicyStatement({ actions: ['ec2:*'], resources: ['*'] }));
policy.attachToRole(role);
// Role with an external ID
new lib_1.Role(stack, 'TestRole2', {
    assumedBy: new lib_1.AccountRootPrincipal(),
    externalId: 'supply-me',
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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