"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const app = new cdk_1.App();
const stack = new cdk_1.Stack(app, 'integ-iam-role-1');
const g1 = new lib_1.Group(stack, 'MyGroup');
const g2 = new lib_1.Group(stack, 'YourGroup');
for (let i = 0; i < 5; ++i) {
    const user = new lib_1.User(stack, `User${i + 1}`);
    user.addToGroup(g1);
    g2.addUser(user);
}
const policy = new lib_1.Policy(stack, 'MyPolicy');
policy.attachToGroup(g1);
policy.addStatements(new lib_1.PolicyStatement({
    resources: [g2.groupArn],
    actions: ['iam:*']
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,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