# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class Codec(Model):
    """Describes the basic properties of all codecs.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Audio, Video, CopyVideo, CopyAudio

    All required parameters must be populated in order to send to Azure.

    :param label: An optional label for the codec. The label can be used to
     control muxing behavior.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.Audio': 'Audio', '#Microsoft.Media.Video': 'Video', '#Microsoft.Media.CopyVideo': 'CopyVideo', '#Microsoft.Media.CopyAudio': 'CopyAudio'}
    }

    def __init__(self, *, label: str=None, **kwargs) -> None:
        super(Codec, self).__init__(**kwargs)
        self.label = label
        self.odatatype = None


class Audio(Codec):
    """Defines the common properties for all audio codecs.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AacAudio

    All required parameters must be populated in order to send to Azure.

    :param label: An optional label for the codec. The label can be used to
     control muxing behavior.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param channels: The number of channels in the audio.
    :type channels: int
    :param sampling_rate: The sampling rate to use for encoding in hertz.
    :type sampling_rate: int
    :param bitrate: The bitrate, in bits per second, of the output encoded
     audio.
    :type bitrate: int
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'channels': {'key': 'channels', 'type': 'int'},
        'sampling_rate': {'key': 'samplingRate', 'type': 'int'},
        'bitrate': {'key': 'bitrate', 'type': 'int'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.AacAudio': 'AacAudio'}
    }

    def __init__(self, *, label: str=None, channels: int=None, sampling_rate: int=None, bitrate: int=None, **kwargs) -> None:
        super(Audio, self).__init__(label=label, **kwargs)
        self.channels = channels
        self.sampling_rate = sampling_rate
        self.bitrate = bitrate
        self.odatatype = '#Microsoft.Media.Audio'


class AacAudio(Audio):
    """Describes Advanced Audio Codec (AAC) audio encoding settings.

    All required parameters must be populated in order to send to Azure.

    :param label: An optional label for the codec. The label can be used to
     control muxing behavior.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param channels: The number of channels in the audio.
    :type channels: int
    :param sampling_rate: The sampling rate to use for encoding in hertz.
    :type sampling_rate: int
    :param bitrate: The bitrate, in bits per second, of the output encoded
     audio.
    :type bitrate: int
    :param profile: The encoding profile to be used when encoding audio with
     AAC. Possible values include: 'AacLc', 'HeAacV1', 'HeAacV2'
    :type profile: str or ~azure.mgmt.media.models.AacAudioProfile
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'channels': {'key': 'channels', 'type': 'int'},
        'sampling_rate': {'key': 'samplingRate', 'type': 'int'},
        'bitrate': {'key': 'bitrate', 'type': 'int'},
        'profile': {'key': 'profile', 'type': 'str'},
    }

    def __init__(self, *, label: str=None, channels: int=None, sampling_rate: int=None, bitrate: int=None, profile=None, **kwargs) -> None:
        super(AacAudio, self).__init__(label=label, channels=channels, sampling_rate=sampling_rate, bitrate=bitrate, **kwargs)
        self.profile = profile
        self.odatatype = '#Microsoft.Media.AacAudio'


class ClipTime(Model):
    """Base class for specifying a clip time. Use sub classes of this class to
    specify the time position in the media.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AbsoluteClipTime, UtcClipTime

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.AbsoluteClipTime': 'AbsoluteClipTime', '#Microsoft.Media.UtcClipTime': 'UtcClipTime'}
    }

    def __init__(self, **kwargs) -> None:
        super(ClipTime, self).__init__(**kwargs)
        self.odatatype = None


class AbsoluteClipTime(ClipTime):
    """Specifies the clip time as an absolute time position in the media file.
    The absolute time can point to a different position depending on whether
    the media file starts from a timestamp of zero or not.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param time: Required. The time position on the timeline of the input
     media. It is usually specified as an ISO8601 period. e.g PT30S for 30
     seconds.
    :type time: timedelta
    """

    _validation = {
        'odatatype': {'required': True},
        'time': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'time': {'key': 'time', 'type': 'duration'},
    }

    def __init__(self, *, time, **kwargs) -> None:
        super(AbsoluteClipTime, self).__init__(**kwargs)
        self.time = time
        self.odatatype = '#Microsoft.Media.AbsoluteClipTime'


class AccountEncryption(Model):
    """AccountEncryption.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of key used to encrypt the Account Key.
     Possible values include: 'SystemKey', 'CustomerKey'
    :type type: str or ~azure.mgmt.media.models.AccountEncryptionKeyType
    :param key_vault_properties: The properties of the key used to encrypt the
     account.
    :type key_vault_properties: ~azure.mgmt.media.models.KeyVaultProperties
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'KeyVaultProperties'},
    }

    def __init__(self, *, type, key_vault_properties=None, **kwargs) -> None:
        super(AccountEncryption, self).__init__(**kwargs)
        self.type = type
        self.key_vault_properties = key_vault_properties


class Resource(Model):
    """Resource.

    Common fields that are returned in the response for all Azure Resource
    Manager resources.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """Proxy Resource.

    The resource model definition for a Azure Resource Manager proxy resource.
    It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ProxyResource, self).__init__(**kwargs)


class AccountFilter(ProxyResource):
    """An Account Filter.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param presentation_time_range: The presentation time range.
    :type presentation_time_range:
     ~azure.mgmt.media.models.PresentationTimeRange
    :param first_quality: The first quality.
    :type first_quality: ~azure.mgmt.media.models.FirstQuality
    :param tracks: The tracks selection conditions.
    :type tracks: list[~azure.mgmt.media.models.FilterTrackSelection]
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'presentation_time_range': {'key': 'properties.presentationTimeRange', 'type': 'PresentationTimeRange'},
        'first_quality': {'key': 'properties.firstQuality', 'type': 'FirstQuality'},
        'tracks': {'key': 'properties.tracks', 'type': '[FilterTrackSelection]'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, presentation_time_range=None, first_quality=None, tracks=None, **kwargs) -> None:
        super(AccountFilter, self).__init__(**kwargs)
        self.presentation_time_range = presentation_time_range
        self.first_quality = first_quality
        self.tracks = tracks
        self.system_data = None


class AkamaiAccessControl(Model):
    """Akamai access control.

    :param akamai_signature_header_authentication_key_list: authentication key
     list
    :type akamai_signature_header_authentication_key_list:
     list[~azure.mgmt.media.models.AkamaiSignatureHeaderAuthenticationKey]
    """

    _attribute_map = {
        'akamai_signature_header_authentication_key_list': {'key': 'akamaiSignatureHeaderAuthenticationKeyList', 'type': '[AkamaiSignatureHeaderAuthenticationKey]'},
    }

    def __init__(self, *, akamai_signature_header_authentication_key_list=None, **kwargs) -> None:
        super(AkamaiAccessControl, self).__init__(**kwargs)
        self.akamai_signature_header_authentication_key_list = akamai_signature_header_authentication_key_list


class AkamaiSignatureHeaderAuthenticationKey(Model):
    """Akamai Signature Header authentication key.

    :param identifier: identifier of the key
    :type identifier: str
    :param base64_key: authentication key
    :type base64_key: str
    :param expiration: The expiration time of the authentication key.
    :type expiration: datetime
    """

    _attribute_map = {
        'identifier': {'key': 'identifier', 'type': 'str'},
        'base64_key': {'key': 'base64Key', 'type': 'str'},
        'expiration': {'key': 'expiration', 'type': 'iso-8601'},
    }

    def __init__(self, *, identifier: str=None, base64_key: str=None, expiration=None, **kwargs) -> None:
        super(AkamaiSignatureHeaderAuthenticationKey, self).__init__(**kwargs)
        self.identifier = identifier
        self.base64_key = base64_key
        self.expiration = expiration


class ApiError(Model):
    """The API error.

    :param error: The error properties.
    :type error: ~azure.mgmt.media.models.ODataError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ODataError'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(ApiError, self).__init__(**kwargs)
        self.error = error


class ApiErrorException(HttpOperationError):
    """Server responsed with exception of type: 'ApiError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ApiErrorException, self).__init__(deserialize, response, 'ApiError', *args)


class Asset(ProxyResource):
    """An Asset.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :ivar asset_id: The Asset ID.
    :vartype asset_id: str
    :ivar created: The creation date of the Asset.
    :vartype created: datetime
    :ivar last_modified: The last modified date of the Asset.
    :vartype last_modified: datetime
    :param alternate_id: The alternate ID of the Asset.
    :type alternate_id: str
    :param description: The Asset description.
    :type description: str
    :param container: The name of the asset blob container.
    :type container: str
    :param storage_account_name: The name of the storage account.
    :type storage_account_name: str
    :ivar storage_encryption_format: The Asset encryption format. One of None
     or MediaStorageEncryption. Possible values include: 'None',
     'MediaStorageClientEncryption'
    :vartype storage_encryption_format: str or
     ~azure.mgmt.media.models.AssetStorageEncryptionFormat
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'asset_id': {'readonly': True},
        'created': {'readonly': True},
        'last_modified': {'readonly': True},
        'storage_encryption_format': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'asset_id': {'key': 'properties.assetId', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'last_modified': {'key': 'properties.lastModified', 'type': 'iso-8601'},
        'alternate_id': {'key': 'properties.alternateId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'container': {'key': 'properties.container', 'type': 'str'},
        'storage_account_name': {'key': 'properties.storageAccountName', 'type': 'str'},
        'storage_encryption_format': {'key': 'properties.storageEncryptionFormat', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, alternate_id: str=None, description: str=None, container: str=None, storage_account_name: str=None, **kwargs) -> None:
        super(Asset, self).__init__(**kwargs)
        self.asset_id = None
        self.created = None
        self.last_modified = None
        self.alternate_id = alternate_id
        self.description = description
        self.container = container
        self.storage_account_name = storage_account_name
        self.storage_encryption_format = None
        self.system_data = None


class AssetContainerSas(Model):
    """The Asset Storage container SAS URLs.

    :param asset_container_sas_urls: The list of Asset container SAS URLs.
    :type asset_container_sas_urls: list[str]
    """

    _attribute_map = {
        'asset_container_sas_urls': {'key': 'assetContainerSasUrls', 'type': '[str]'},
    }

    def __init__(self, *, asset_container_sas_urls=None, **kwargs) -> None:
        super(AssetContainerSas, self).__init__(**kwargs)
        self.asset_container_sas_urls = asset_container_sas_urls


class AssetFileEncryptionMetadata(Model):
    """The Asset File Storage encryption metadata.

    All required parameters must be populated in order to send to Azure.

    :param initialization_vector: The Asset File initialization vector.
    :type initialization_vector: str
    :param asset_file_name: The Asset File name.
    :type asset_file_name: str
    :param asset_file_id: Required. The Asset File Id.
    :type asset_file_id: str
    """

    _validation = {
        'asset_file_id': {'required': True},
    }

    _attribute_map = {
        'initialization_vector': {'key': 'initializationVector', 'type': 'str'},
        'asset_file_name': {'key': 'assetFileName', 'type': 'str'},
        'asset_file_id': {'key': 'assetFileId', 'type': 'str'},
    }

    def __init__(self, *, asset_file_id: str, initialization_vector: str=None, asset_file_name: str=None, **kwargs) -> None:
        super(AssetFileEncryptionMetadata, self).__init__(**kwargs)
        self.initialization_vector = initialization_vector
        self.asset_file_name = asset_file_name
        self.asset_file_id = asset_file_id


class AssetFilter(ProxyResource):
    """An Asset Filter.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param presentation_time_range: The presentation time range.
    :type presentation_time_range:
     ~azure.mgmt.media.models.PresentationTimeRange
    :param first_quality: The first quality.
    :type first_quality: ~azure.mgmt.media.models.FirstQuality
    :param tracks: The tracks selection conditions.
    :type tracks: list[~azure.mgmt.media.models.FilterTrackSelection]
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'presentation_time_range': {'key': 'properties.presentationTimeRange', 'type': 'PresentationTimeRange'},
        'first_quality': {'key': 'properties.firstQuality', 'type': 'FirstQuality'},
        'tracks': {'key': 'properties.tracks', 'type': '[FilterTrackSelection]'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, presentation_time_range=None, first_quality=None, tracks=None, **kwargs) -> None:
        super(AssetFilter, self).__init__(**kwargs)
        self.presentation_time_range = presentation_time_range
        self.first_quality = first_quality
        self.tracks = tracks
        self.system_data = None


class AssetStreamingLocator(Model):
    """Properties of the Streaming Locator.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Streaming Locator name.
    :vartype name: str
    :ivar asset_name: Asset Name.
    :vartype asset_name: str
    :ivar created: The creation time of the Streaming Locator.
    :vartype created: datetime
    :ivar start_time: The start time of the Streaming Locator.
    :vartype start_time: datetime
    :ivar end_time: The end time of the Streaming Locator.
    :vartype end_time: datetime
    :ivar streaming_locator_id: StreamingLocatorId of the Streaming Locator.
    :vartype streaming_locator_id: str
    :ivar streaming_policy_name: Name of the Streaming Policy used by this
     Streaming Locator.
    :vartype streaming_policy_name: str
    :ivar default_content_key_policy_name: Name of the default
     ContentKeyPolicy used by this Streaming Locator.
    :vartype default_content_key_policy_name: str
    """

    _validation = {
        'name': {'readonly': True},
        'asset_name': {'readonly': True},
        'created': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'streaming_locator_id': {'readonly': True},
        'streaming_policy_name': {'readonly': True},
        'default_content_key_policy_name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'asset_name': {'key': 'assetName', 'type': 'str'},
        'created': {'key': 'created', 'type': 'iso-8601'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'streaming_locator_id': {'key': 'streamingLocatorId', 'type': 'str'},
        'streaming_policy_name': {'key': 'streamingPolicyName', 'type': 'str'},
        'default_content_key_policy_name': {'key': 'defaultContentKeyPolicyName', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(AssetStreamingLocator, self).__init__(**kwargs)
        self.name = None
        self.asset_name = None
        self.created = None
        self.start_time = None
        self.end_time = None
        self.streaming_locator_id = None
        self.streaming_policy_name = None
        self.default_content_key_policy_name = None


class Preset(Model):
    """Base type for all Presets, which define the recipe or instructions on how
    the input media files should be processed.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FaceDetectorPreset, AudioAnalyzerPreset,
    BuiltInStandardEncoderPreset, StandardEncoderPreset

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.FaceDetectorPreset': 'FaceDetectorPreset', '#Microsoft.Media.AudioAnalyzerPreset': 'AudioAnalyzerPreset', '#Microsoft.Media.BuiltInStandardEncoderPreset': 'BuiltInStandardEncoderPreset', '#Microsoft.Media.StandardEncoderPreset': 'StandardEncoderPreset'}
    }

    def __init__(self, **kwargs) -> None:
        super(Preset, self).__init__(**kwargs)
        self.odatatype = None


class AudioAnalyzerPreset(Preset):
    """The Audio Analyzer preset applies a pre-defined set of AI-based analysis
    operations, including speech transcription. Currently, the preset supports
    processing of content with a single audio track.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: VideoAnalyzerPreset

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param audio_language: The language for the audio payload in the input
     using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you
     know the language of your content, it is recommended that you specify it.
     The language must be specified explicitly for AudioAnalysisMode::Basic,
     since automatic language detection is not included in basic mode. If the
     language isn't specified or set to null, automatic language detection will
     choose the first language detected and process with the selected language
     for the duration of the file. It does not currently support dynamically
     switching between languages after the first language is detected. The
     automatic detection works best with audio recordings with clearly
     discernable speech. If automatic detection fails to find the language,
     transcription would fallback to 'en-US'." The list of supported languages
     is available here: https://go.microsoft.com/fwlink/?linkid=2109463
    :type audio_language: str
    :param mode: Determines the set of audio analysis operations to be
     performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
     Possible values include: 'Standard', 'Basic'
    :type mode: str or ~azure.mgmt.media.models.AudioAnalysisMode
    :param experimental_options: Dictionary containing key value pairs for
     parameters not exposed in the preset itself
    :type experimental_options: dict[str, str]
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'audio_language': {'key': 'audioLanguage', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'experimental_options': {'key': 'experimentalOptions', 'type': '{str}'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.VideoAnalyzerPreset': 'VideoAnalyzerPreset'}
    }

    def __init__(self, *, audio_language: str=None, mode=None, experimental_options=None, **kwargs) -> None:
        super(AudioAnalyzerPreset, self).__init__(**kwargs)
        self.audio_language = audio_language
        self.mode = mode
        self.experimental_options = experimental_options
        self.odatatype = '#Microsoft.Media.AudioAnalyzerPreset'


class Overlay(Model):
    """Base type for all overlays - image, audio or video.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AudioOverlay, VideoOverlay

    All required parameters must be populated in order to send to Azure.

    :param input_label: Required. The label of the job input which is to be
     used as an overlay. The Input must specify exactly one file. You can
     specify an image file in JPG, PNG, GIF or BMP format, or an audio file
     (such as a WAV, MP3, WMA or M4A file), or a video file. See
     https://aka.ms/mesformats for the complete list of supported audio and
     video file formats.
    :type input_label: str
    :param start: The start position, with reference to the input video, at
     which the overlay starts. The value should be in ISO 8601 format. For
     example, PT05S to start the overlay at 5 seconds into the input video. If
     not specified the overlay starts from the beginning of the input video.
    :type start: timedelta
    :param end: The end position, with reference to the input video, at which
     the overlay ends. The value should be in ISO 8601 format. For example,
     PT30S to end the overlay at 30 seconds into the input video. If not
     specified or the value is greater than the input video duration, the
     overlay will be applied until the end of the input video if the overlay
     media duration is greater than the input video duration, else the overlay
     will last as long as the overlay media duration.
    :type end: timedelta
    :param fade_in_duration: The duration over which the overlay fades in onto
     the input video. The value should be in ISO 8601 duration format. If not
     specified the default behavior is to have no fade in (same as PT0S).
    :type fade_in_duration: timedelta
    :param fade_out_duration: The duration over which the overlay fades out of
     the input video. The value should be in ISO 8601 duration format. If not
     specified the default behavior is to have no fade out (same as PT0S).
    :type fade_out_duration: timedelta
    :param audio_gain_level: The gain level of audio in the overlay. The value
     should be in the range [0, 1.0]. The default is 1.0.
    :type audio_gain_level: float
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'input_label': {'required': True},
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'input_label': {'key': 'inputLabel', 'type': 'str'},
        'start': {'key': 'start', 'type': 'duration'},
        'end': {'key': 'end', 'type': 'duration'},
        'fade_in_duration': {'key': 'fadeInDuration', 'type': 'duration'},
        'fade_out_duration': {'key': 'fadeOutDuration', 'type': 'duration'},
        'audio_gain_level': {'key': 'audioGainLevel', 'type': 'float'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.AudioOverlay': 'AudioOverlay', '#Microsoft.Media.VideoOverlay': 'VideoOverlay'}
    }

    def __init__(self, *, input_label: str, start=None, end=None, fade_in_duration=None, fade_out_duration=None, audio_gain_level: float=None, **kwargs) -> None:
        super(Overlay, self).__init__(**kwargs)
        self.input_label = input_label
        self.start = start
        self.end = end
        self.fade_in_duration = fade_in_duration
        self.fade_out_duration = fade_out_duration
        self.audio_gain_level = audio_gain_level
        self.odatatype = None


class AudioOverlay(Overlay):
    """Describes the properties of an audio overlay.

    All required parameters must be populated in order to send to Azure.

    :param input_label: Required. The label of the job input which is to be
     used as an overlay. The Input must specify exactly one file. You can
     specify an image file in JPG, PNG, GIF or BMP format, or an audio file
     (such as a WAV, MP3, WMA or M4A file), or a video file. See
     https://aka.ms/mesformats for the complete list of supported audio and
     video file formats.
    :type input_label: str
    :param start: The start position, with reference to the input video, at
     which the overlay starts. The value should be in ISO 8601 format. For
     example, PT05S to start the overlay at 5 seconds into the input video. If
     not specified the overlay starts from the beginning of the input video.
    :type start: timedelta
    :param end: The end position, with reference to the input video, at which
     the overlay ends. The value should be in ISO 8601 format. For example,
     PT30S to end the overlay at 30 seconds into the input video. If not
     specified or the value is greater than the input video duration, the
     overlay will be applied until the end of the input video if the overlay
     media duration is greater than the input video duration, else the overlay
     will last as long as the overlay media duration.
    :type end: timedelta
    :param fade_in_duration: The duration over which the overlay fades in onto
     the input video. The value should be in ISO 8601 duration format. If not
     specified the default behavior is to have no fade in (same as PT0S).
    :type fade_in_duration: timedelta
    :param fade_out_duration: The duration over which the overlay fades out of
     the input video. The value should be in ISO 8601 duration format. If not
     specified the default behavior is to have no fade out (same as PT0S).
    :type fade_out_duration: timedelta
    :param audio_gain_level: The gain level of audio in the overlay. The value
     should be in the range [0, 1.0]. The default is 1.0.
    :type audio_gain_level: float
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'input_label': {'required': True},
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'input_label': {'key': 'inputLabel', 'type': 'str'},
        'start': {'key': 'start', 'type': 'duration'},
        'end': {'key': 'end', 'type': 'duration'},
        'fade_in_duration': {'key': 'fadeInDuration', 'type': 'duration'},
        'fade_out_duration': {'key': 'fadeOutDuration', 'type': 'duration'},
        'audio_gain_level': {'key': 'audioGainLevel', 'type': 'float'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(self, *, input_label: str, start=None, end=None, fade_in_duration=None, fade_out_duration=None, audio_gain_level: float=None, **kwargs) -> None:
        super(AudioOverlay, self).__init__(input_label=input_label, start=start, end=end, fade_in_duration=fade_in_duration, fade_out_duration=fade_out_duration, audio_gain_level=audio_gain_level, **kwargs)
        self.odatatype = '#Microsoft.Media.AudioOverlay'


class TrackDescriptor(Model):
    """Base type for all TrackDescriptor types, which define the metadata and
    selection for tracks that should be processed by a Job.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AudioTrackDescriptor, VideoTrackDescriptor

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.AudioTrackDescriptor': 'AudioTrackDescriptor', '#Microsoft.Media.VideoTrackDescriptor': 'VideoTrackDescriptor'}
    }

    def __init__(self, **kwargs) -> None:
        super(TrackDescriptor, self).__init__(**kwargs)
        self.odatatype = None


class AudioTrackDescriptor(TrackDescriptor):
    """A TrackSelection to select audio tracks.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SelectAudioTrackByAttribute, SelectAudioTrackById

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param channel_mapping: Optional designation for single channel audio
     tracks.  Can be used to combine the tracks into stereo or multi-channel
     audio tracks. Possible values include: 'FrontLeft', 'FrontRight',
     'Center', 'LowFrequencyEffects', 'BackLeft', 'BackRight', 'StereoLeft',
     'StereoRight'
    :type channel_mapping: str or ~azure.mgmt.media.models.ChannelMapping
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'channel_mapping': {'key': 'channelMapping', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.SelectAudioTrackByAttribute': 'SelectAudioTrackByAttribute', '#Microsoft.Media.SelectAudioTrackById': 'SelectAudioTrackById'}
    }

    def __init__(self, *, channel_mapping=None, **kwargs) -> None:
        super(AudioTrackDescriptor, self).__init__(**kwargs)
        self.channel_mapping = channel_mapping
        self.odatatype = '#Microsoft.Media.AudioTrackDescriptor'


class AzureEntityResource(Resource):
    """Entity Resource.

    The resource model definition for an Azure Resource Manager resource with
    an etag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class BuiltInStandardEncoderPreset(Preset):
    """Describes a built-in preset for encoding the input video with the Standard
    Encoder.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param preset_name: Required. The built-in preset to be used for encoding
     videos. Possible values include: 'H264SingleBitrateSD',
     'H264SingleBitrate720p', 'H264SingleBitrate1080p', 'AdaptiveStreaming',
     'AACGoodQualityAudio', 'ContentAwareEncodingExperimental',
     'ContentAwareEncoding', 'CopyAllBitrateNonInterleaved',
     'H264MultipleBitrate1080p', 'H264MultipleBitrate720p',
     'H264MultipleBitrateSD', 'H265ContentAwareEncoding',
     'H265AdaptiveStreaming', 'H265SingleBitrate720p',
     'H265SingleBitrate1080p', 'H265SingleBitrate4K'
    :type preset_name: str or ~azure.mgmt.media.models.EncoderNamedPreset
    """

    _validation = {
        'odatatype': {'required': True},
        'preset_name': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'preset_name': {'key': 'presetName', 'type': 'str'},
    }

    def __init__(self, *, preset_name, **kwargs) -> None:
        super(BuiltInStandardEncoderPreset, self).__init__(**kwargs)
        self.preset_name = preset_name
        self.odatatype = '#Microsoft.Media.BuiltInStandardEncoderPreset'


class CbcsDrmConfiguration(Model):
    """Class to specify DRM configurations of CommonEncryptionCbcs scheme in
    Streaming Policy.

    :param fair_play: FairPlay configurations
    :type fair_play:
     ~azure.mgmt.media.models.StreamingPolicyFairPlayConfiguration
    :param play_ready: PlayReady configurations
    :type play_ready:
     ~azure.mgmt.media.models.StreamingPolicyPlayReadyConfiguration
    :param widevine: Widevine configurations
    :type widevine:
     ~azure.mgmt.media.models.StreamingPolicyWidevineConfiguration
    """

    _attribute_map = {
        'fair_play': {'key': 'fairPlay', 'type': 'StreamingPolicyFairPlayConfiguration'},
        'play_ready': {'key': 'playReady', 'type': 'StreamingPolicyPlayReadyConfiguration'},
        'widevine': {'key': 'widevine', 'type': 'StreamingPolicyWidevineConfiguration'},
    }

    def __init__(self, *, fair_play=None, play_ready=None, widevine=None, **kwargs) -> None:
        super(CbcsDrmConfiguration, self).__init__(**kwargs)
        self.fair_play = fair_play
        self.play_ready = play_ready
        self.widevine = widevine


class CencDrmConfiguration(Model):
    """Class to specify DRM configurations of CommonEncryptionCenc scheme in
    Streaming Policy.

    :param play_ready: PlayReady configurations
    :type play_ready:
     ~azure.mgmt.media.models.StreamingPolicyPlayReadyConfiguration
    :param widevine: Widevine configurations
    :type widevine:
     ~azure.mgmt.media.models.StreamingPolicyWidevineConfiguration
    """

    _attribute_map = {
        'play_ready': {'key': 'playReady', 'type': 'StreamingPolicyPlayReadyConfiguration'},
        'widevine': {'key': 'widevine', 'type': 'StreamingPolicyWidevineConfiguration'},
    }

    def __init__(self, *, play_ready=None, widevine=None, **kwargs) -> None:
        super(CencDrmConfiguration, self).__init__(**kwargs)
        self.play_ready = play_ready
        self.widevine = widevine


class CheckNameAvailabilityInput(Model):
    """The input to the check name availability request.

    :param name: The account name.
    :type name: str
    :param type: The account type. For a Media Services account, this should
     be 'MediaServices'.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, type: str=None, **kwargs) -> None:
        super(CheckNameAvailabilityInput, self).__init__(**kwargs)
        self.name = name
        self.type = type


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class CommonEncryptionCbcs(Model):
    """Class for CommonEncryptionCbcs encryption scheme.

    :param enabled_protocols: Representing supported protocols
    :type enabled_protocols: ~azure.mgmt.media.models.EnabledProtocols
    :param clear_tracks: Representing which tracks should not be encrypted
    :type clear_tracks: list[~azure.mgmt.media.models.TrackSelection]
    :param content_keys: Representing default content key for each encryption
     scheme and separate content keys for specific tracks
    :type content_keys: ~azure.mgmt.media.models.StreamingPolicyContentKeys
    :param drm: Configuration of DRMs for current encryption scheme
    :type drm: ~azure.mgmt.media.models.CbcsDrmConfiguration
    """

    _attribute_map = {
        'enabled_protocols': {'key': 'enabledProtocols', 'type': 'EnabledProtocols'},
        'clear_tracks': {'key': 'clearTracks', 'type': '[TrackSelection]'},
        'content_keys': {'key': 'contentKeys', 'type': 'StreamingPolicyContentKeys'},
        'drm': {'key': 'drm', 'type': 'CbcsDrmConfiguration'},
    }

    def __init__(self, *, enabled_protocols=None, clear_tracks=None, content_keys=None, drm=None, **kwargs) -> None:
        super(CommonEncryptionCbcs, self).__init__(**kwargs)
        self.enabled_protocols = enabled_protocols
        self.clear_tracks = clear_tracks
        self.content_keys = content_keys
        self.drm = drm


class CommonEncryptionCenc(Model):
    """Class for envelope encryption scheme.

    :param enabled_protocols: Representing supported protocols
    :type enabled_protocols: ~azure.mgmt.media.models.EnabledProtocols
    :param clear_tracks: Representing which tracks should not be encrypted
    :type clear_tracks: list[~azure.mgmt.media.models.TrackSelection]
    :param content_keys: Representing default content key for each encryption
     scheme and separate content keys for specific tracks
    :type content_keys: ~azure.mgmt.media.models.StreamingPolicyContentKeys
    :param drm: Configuration of DRMs for CommonEncryptionCenc encryption
     scheme
    :type drm: ~azure.mgmt.media.models.CencDrmConfiguration
    """

    _attribute_map = {
        'enabled_protocols': {'key': 'enabledProtocols', 'type': 'EnabledProtocols'},
        'clear_tracks': {'key': 'clearTracks', 'type': '[TrackSelection]'},
        'content_keys': {'key': 'contentKeys', 'type': 'StreamingPolicyContentKeys'},
        'drm': {'key': 'drm', 'type': 'CencDrmConfiguration'},
    }

    def __init__(self, *, enabled_protocols=None, clear_tracks=None, content_keys=None, drm=None, **kwargs) -> None:
        super(CommonEncryptionCenc, self).__init__(**kwargs)
        self.enabled_protocols = enabled_protocols
        self.clear_tracks = clear_tracks
        self.content_keys = content_keys
        self.drm = drm


class ContentKeyPolicy(ProxyResource):
    """A Content Key Policy resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :ivar policy_id: The legacy Policy ID.
    :vartype policy_id: str
    :ivar created: The creation date of the Policy
    :vartype created: datetime
    :ivar last_modified: The last modified date of the Policy
    :vartype last_modified: datetime
    :param description: A description for the Policy.
    :type description: str
    :param options: Required. The Key Policy options.
    :type options: list[~azure.mgmt.media.models.ContentKeyPolicyOption]
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'policy_id': {'readonly': True},
        'created': {'readonly': True},
        'last_modified': {'readonly': True},
        'options': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'policy_id': {'key': 'properties.policyId', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'last_modified': {'key': 'properties.lastModified', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'options': {'key': 'properties.options', 'type': '[ContentKeyPolicyOption]'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, options, description: str=None, **kwargs) -> None:
        super(ContentKeyPolicy, self).__init__(**kwargs)
        self.policy_id = None
        self.created = None
        self.last_modified = None
        self.description = description
        self.options = options
        self.system_data = None


class ContentKeyPolicyConfiguration(Model):
    """Base class for Content Key Policy configuration. A derived class must be
    used to create a configuration.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ContentKeyPolicyClearKeyConfiguration,
    ContentKeyPolicyUnknownConfiguration,
    ContentKeyPolicyWidevineConfiguration,
    ContentKeyPolicyPlayReadyConfiguration,
    ContentKeyPolicyFairPlayConfiguration

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration': 'ContentKeyPolicyClearKeyConfiguration', '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration': 'ContentKeyPolicyUnknownConfiguration', '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration': 'ContentKeyPolicyWidevineConfiguration', '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration': 'ContentKeyPolicyPlayReadyConfiguration', '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration': 'ContentKeyPolicyFairPlayConfiguration'}
    }

    def __init__(self, **kwargs) -> None:
        super(ContentKeyPolicyConfiguration, self).__init__(**kwargs)
        self.odatatype = None


class ContentKeyPolicyClearKeyConfiguration(ContentKeyPolicyConfiguration):
    """Represents a configuration for non-DRM keys.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ContentKeyPolicyClearKeyConfiguration, self).__init__(**kwargs)
        self.odatatype = '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration'


class ContentKeyPolicyFairPlayConfiguration(ContentKeyPolicyConfiguration):
    """Specifies a configuration for FairPlay licenses.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param ask: Required. The key that must be used as FairPlay Application
     Secret key.
    :type ask: bytearray
    :param fair_play_pfx_password: Required. The password encrypting FairPlay
     certificate in PKCS 12 (pfx) format.
    :type fair_play_pfx_password: str
    :param fair_play_pfx: Required. The Base64 representation of FairPlay
     certificate in PKCS 12 (pfx) format (including private key).
    :type fair_play_pfx: str
    :param rental_and_lease_key_type: Required. The rental and lease key type.
     Possible values include: 'Unknown', 'Undefined', 'DualExpiry',
     'PersistentUnlimited', 'PersistentLimited'
    :type rental_and_lease_key_type: str or
     ~azure.mgmt.media.models.ContentKeyPolicyFairPlayRentalAndLeaseKeyType
    :param rental_duration: Required. The rental duration. Must be greater
     than or equal to 0.
    :type rental_duration: long
    :param offline_rental_configuration: Offline rental policy
    :type offline_rental_configuration:
     ~azure.mgmt.media.models.ContentKeyPolicyFairPlayOfflineRentalConfiguration
    """

    _validation = {
        'odatatype': {'required': True},
        'ask': {'required': True},
        'fair_play_pfx_password': {'required': True},
        'fair_play_pfx': {'required': True},
        'rental_and_lease_key_type': {'required': True},
        'rental_duration': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'ask': {'key': 'ask', 'type': 'bytearray'},
        'fair_play_pfx_password': {'key': 'fairPlayPfxPassword', 'type': 'str'},
        'fair_play_pfx': {'key': 'fairPlayPfx', 'type': 'str'},
        'rental_and_lease_key_type': {'key': 'rentalAndLeaseKeyType', 'type': 'str'},
        'rental_duration': {'key': 'rentalDuration', 'type': 'long'},
        'offline_rental_configuration': {'key': 'offlineRentalConfiguration', 'type': 'ContentKeyPolicyFairPlayOfflineRentalConfiguration'},
    }

    def __init__(self, *, ask: bytearray, fair_play_pfx_password: str, fair_play_pfx: str, rental_and_lease_key_type, rental_duration: int, offline_rental_configuration=None, **kwargs) -> None:
        super(ContentKeyPolicyFairPlayConfiguration, self).__init__(**kwargs)
        self.ask = ask
        self.fair_play_pfx_password = fair_play_pfx_password
        self.fair_play_pfx = fair_play_pfx
        self.rental_and_lease_key_type = rental_and_lease_key_type
        self.rental_duration = rental_duration
        self.offline_rental_configuration = offline_rental_configuration
        self.odatatype = '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration'


class ContentKeyPolicyFairPlayOfflineRentalConfiguration(Model):
    """ContentKeyPolicyFairPlayOfflineRentalConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param playback_duration_seconds: Required. Playback duration
    :type playback_duration_seconds: long
    :param storage_duration_seconds: Required. Storage duration
    :type storage_duration_seconds: long
    """

    _validation = {
        'playback_duration_seconds': {'required': True},
        'storage_duration_seconds': {'required': True},
    }

    _attribute_map = {
        'playback_duration_seconds': {'key': 'playbackDurationSeconds', 'type': 'long'},
        'storage_duration_seconds': {'key': 'storageDurationSeconds', 'type': 'long'},
    }

    def __init__(self, *, playback_duration_seconds: int, storage_duration_seconds: int, **kwargs) -> None:
        super(ContentKeyPolicyFairPlayOfflineRentalConfiguration, self).__init__(**kwargs)
        self.playback_duration_seconds = playback_duration_seconds
        self.storage_duration_seconds = storage_duration_seconds


class ContentKeyPolicyRestriction(Model):
    """Base class for Content Key Policy restrictions. A derived class must be
    used to create a restriction.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ContentKeyPolicyOpenRestriction,
    ContentKeyPolicyUnknownRestriction, ContentKeyPolicyTokenRestriction

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.ContentKeyPolicyOpenRestriction': 'ContentKeyPolicyOpenRestriction', '#Microsoft.Media.ContentKeyPolicyUnknownRestriction': 'ContentKeyPolicyUnknownRestriction', '#Microsoft.Media.ContentKeyPolicyTokenRestriction': 'ContentKeyPolicyTokenRestriction'}
    }

    def __init__(self, **kwargs) -> None:
        super(ContentKeyPolicyRestriction, self).__init__(**kwargs)
        self.odatatype = None


class ContentKeyPolicyOpenRestriction(ContentKeyPolicyRestriction):
    """Represents an open restriction. License or key will be delivered on every
    request.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ContentKeyPolicyOpenRestriction, self).__init__(**kwargs)
        self.odatatype = '#Microsoft.Media.ContentKeyPolicyOpenRestriction'


class ContentKeyPolicyOption(Model):
    """Represents a policy option.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar policy_option_id: The legacy Policy Option ID.
    :vartype policy_option_id: str
    :param name: The Policy Option description.
    :type name: str
    :param configuration: Required. The key delivery configuration.
    :type configuration:
     ~azure.mgmt.media.models.ContentKeyPolicyConfiguration
    :param restriction: Required. The requirements that must be met to deliver
     keys with this configuration
    :type restriction: ~azure.mgmt.media.models.ContentKeyPolicyRestriction
    """

    _validation = {
        'policy_option_id': {'readonly': True},
        'configuration': {'required': True},
        'restriction': {'required': True},
    }

    _attribute_map = {
        'policy_option_id': {'key': 'policyOptionId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'configuration': {'key': 'configuration', 'type': 'ContentKeyPolicyConfiguration'},
        'restriction': {'key': 'restriction', 'type': 'ContentKeyPolicyRestriction'},
    }

    def __init__(self, *, configuration, restriction, name: str=None, **kwargs) -> None:
        super(ContentKeyPolicyOption, self).__init__(**kwargs)
        self.policy_option_id = None
        self.name = name
        self.configuration = configuration
        self.restriction = restriction


class ContentKeyPolicyPlayReadyConfiguration(ContentKeyPolicyConfiguration):
    """Specifies a configuration for PlayReady licenses.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param licenses: Required. The PlayReady licenses.
    :type licenses:
     list[~azure.mgmt.media.models.ContentKeyPolicyPlayReadyLicense]
    :param response_custom_data: The custom response data.
    :type response_custom_data: str
    """

    _validation = {
        'odatatype': {'required': True},
        'licenses': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'licenses': {'key': 'licenses', 'type': '[ContentKeyPolicyPlayReadyLicense]'},
        'response_custom_data': {'key': 'responseCustomData', 'type': 'str'},
    }

    def __init__(self, *, licenses, response_custom_data: str=None, **kwargs) -> None:
        super(ContentKeyPolicyPlayReadyConfiguration, self).__init__(**kwargs)
        self.licenses = licenses
        self.response_custom_data = response_custom_data
        self.odatatype = '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration'


class ContentKeyPolicyPlayReadyContentKeyLocation(Model):
    """Base class for content key ID location. A derived class must be used to
    represent the location.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader,
    ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader': 'ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader', '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier': 'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'}
    }

    def __init__(self, **kwargs) -> None:
        super(ContentKeyPolicyPlayReadyContentKeyLocation, self).__init__(**kwargs)
        self.odatatype = None


class ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader(ContentKeyPolicyPlayReadyContentKeyLocation):
    """Specifies that the content key ID is in the PlayReady header.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader, self).__init__(**kwargs)
        self.odatatype = '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader'


class ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier(ContentKeyPolicyPlayReadyContentKeyLocation):
    """Specifies that the content key ID is specified in the PlayReady
    configuration.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param key_id: Required. The content key ID.
    :type key_id: str
    """

    _validation = {
        'odatatype': {'required': True},
        'key_id': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'key_id': {'key': 'keyId', 'type': 'str'},
    }

    def __init__(self, *, key_id: str, **kwargs) -> None:
        super(ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier, self).__init__(**kwargs)
        self.key_id = key_id
        self.odatatype = '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'


class ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction(Model):
    """Configures the Explicit Analog Television Output Restriction control bits.
    For further details see the PlayReady Compliance Rules.

    All required parameters must be populated in order to send to Azure.

    :param best_effort: Required. Indicates whether this restriction is
     enforced on a Best Effort basis.
    :type best_effort: bool
    :param configuration_data: Required. Configures the restriction control
     bits. Must be between 0 and 3 inclusive.
    :type configuration_data: int
    """

    _validation = {
        'best_effort': {'required': True},
        'configuration_data': {'required': True},
    }

    _attribute_map = {
        'best_effort': {'key': 'bestEffort', 'type': 'bool'},
        'configuration_data': {'key': 'configurationData', 'type': 'int'},
    }

    def __init__(self, *, best_effort: bool, configuration_data: int, **kwargs) -> None:
        super(ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction, self).__init__(**kwargs)
        self.best_effort = best_effort
        self.configuration_data = configuration_data


class ContentKeyPolicyPlayReadyLicense(Model):
    """The PlayReady license.

    All required parameters must be populated in order to send to Azure.

    :param allow_test_devices: Required. A flag indicating whether test
     devices can use the license.
    :type allow_test_devices: bool
    :param begin_date: The begin date of license
    :type begin_date: datetime
    :param expiration_date: The expiration date of license.
    :type expiration_date: datetime
    :param relative_begin_date: The relative begin date of license.
    :type relative_begin_date: timedelta
    :param relative_expiration_date: The relative expiration date of license.
    :type relative_expiration_date: timedelta
    :param grace_period: The grace period of license.
    :type grace_period: timedelta
    :param play_right: The license PlayRight
    :type play_right:
     ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyPlayRight
    :param license_type: Required. The license type. Possible values include:
     'Unknown', 'NonPersistent', 'Persistent'
    :type license_type: str or
     ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyLicenseType
    :param content_key_location: Required. The content key location.
    :type content_key_location:
     ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyContentKeyLocation
    :param content_type: Required. The PlayReady content type. Possible values
     include: 'Unknown', 'Unspecified', 'UltraVioletDownload',
     'UltraVioletStreaming'
    :type content_type: str or
     ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyContentType
    """

    _validation = {
        'allow_test_devices': {'required': True},
        'license_type': {'required': True},
        'content_key_location': {'required': True},
        'content_type': {'required': True},
    }

    _attribute_map = {
        'allow_test_devices': {'key': 'allowTestDevices', 'type': 'bool'},
        'begin_date': {'key': 'beginDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'expirationDate', 'type': 'iso-8601'},
        'relative_begin_date': {'key': 'relativeBeginDate', 'type': 'duration'},
        'relative_expiration_date': {'key': 'relativeExpirationDate', 'type': 'duration'},
        'grace_period': {'key': 'gracePeriod', 'type': 'duration'},
        'play_right': {'key': 'playRight', 'type': 'ContentKeyPolicyPlayReadyPlayRight'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'content_key_location': {'key': 'contentKeyLocation', 'type': 'ContentKeyPolicyPlayReadyContentKeyLocation'},
        'content_type': {'key': 'contentType', 'type': 'str'},
    }

    def __init__(self, *, allow_test_devices: bool, license_type, content_key_location, content_type, begin_date=None, expiration_date=None, relative_begin_date=None, relative_expiration_date=None, grace_period=None, play_right=None, **kwargs) -> None:
        super(ContentKeyPolicyPlayReadyLicense, self).__init__(**kwargs)
        self.allow_test_devices = allow_test_devices
        self.begin_date = begin_date
        self.expiration_date = expiration_date
        self.relative_begin_date = relative_begin_date
        self.relative_expiration_date = relative_expiration_date
        self.grace_period = grace_period
        self.play_right = play_right
        self.license_type = license_type
        self.content_key_location = content_key_location
        self.content_type = content_type


class ContentKeyPolicyPlayReadyPlayRight(Model):
    """Configures the Play Right in the PlayReady license.

    All required parameters must be populated in order to send to Azure.

    :param first_play_expiration: The amount of time that the license is valid
     after the license is first used to play content.
    :type first_play_expiration: timedelta
    :param scms_restriction: Configures the Serial Copy Management System
     (SCMS) in the license. Must be between 0 and 3 inclusive.
    :type scms_restriction: int
    :param agc_and_color_stripe_restriction: Configures Automatic Gain Control
     (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
    :type agc_and_color_stripe_restriction: int
    :param explicit_analog_television_output_restriction: Configures the
     Explicit Analog Television Output Restriction in the license.
     Configuration data must be between 0 and 3 inclusive.
    :type explicit_analog_television_output_restriction:
     ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction
    :param digital_video_only_content_restriction: Required. Enables the Image
     Constraint For Analog Component Video Restriction in the license.
    :type digital_video_only_content_restriction: bool
    :param image_constraint_for_analog_component_video_restriction: Required.
     Enables the Image Constraint For Analog Component Video Restriction in the
     license.
    :type image_constraint_for_analog_component_video_restriction: bool
    :param image_constraint_for_analog_computer_monitor_restriction: Required.
     Enables the Image Constraint For Analog Component Video Restriction in the
     license.
    :type image_constraint_for_analog_computer_monitor_restriction: bool
    :param allow_passing_video_content_to_unknown_output: Required. Configures
     Unknown output handling settings of the license. Possible values include:
     'Unknown', 'NotAllowed', 'Allowed', 'AllowedWithVideoConstriction'
    :type allow_passing_video_content_to_unknown_output: str or
     ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyUnknownOutputPassingOption
    :param uncompressed_digital_video_opl: Specifies the output protection
     level for uncompressed digital video.
    :type uncompressed_digital_video_opl: int
    :param compressed_digital_video_opl: Specifies the output protection level
     for compressed digital video.
    :type compressed_digital_video_opl: int
    :param analog_video_opl: Specifies the output protection level for
     compressed digital audio.
    :type analog_video_opl: int
    :param compressed_digital_audio_opl: Specifies the output protection level
     for compressed digital audio.
    :type compressed_digital_audio_opl: int
    :param uncompressed_digital_audio_opl: Specifies the output protection
     level for uncompressed digital audio.
    :type uncompressed_digital_audio_opl: int
    """

    _validation = {
        'digital_video_only_content_restriction': {'required': True},
        'image_constraint_for_analog_component_video_restriction': {'required': True},
        'image_constraint_for_analog_computer_monitor_restriction': {'required': True},
        'allow_passing_video_content_to_unknown_output': {'required': True},
    }

    _attribute_map = {
        'first_play_expiration': {'key': 'firstPlayExpiration', 'type': 'duration'},
        'scms_restriction': {'key': 'scmsRestriction', 'type': 'int'},
        'agc_and_color_stripe_restriction': {'key': 'agcAndColorStripeRestriction', 'type': 'int'},
        'explicit_analog_television_output_restriction': {'key': 'explicitAnalogTelevisionOutputRestriction', 'type': 'ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction'},
        'digital_video_only_content_restriction': {'key': 'digitalVideoOnlyContentRestriction', 'type': 'bool'},
        'image_constraint_for_analog_component_video_restriction': {'key': 'imageConstraintForAnalogComponentVideoRestriction', 'type': 'bool'},
        'image_constraint_for_analog_computer_monitor_restriction': {'key': 'imageConstraintForAnalogComputerMonitorRestriction', 'type': 'bool'},
        'allow_passing_video_content_to_unknown_output': {'key': 'allowPassingVideoContentToUnknownOutput', 'type': 'str'},
        'uncompressed_digital_video_opl': {'key': 'uncompressedDigitalVideoOpl', 'type': 'int'},
        'compressed_digital_video_opl': {'key': 'compressedDigitalVideoOpl', 'type': 'int'},
        'analog_video_opl': {'key': 'analogVideoOpl', 'type': 'int'},
        'compressed_digital_audio_opl': {'key': 'compressedDigitalAudioOpl', 'type': 'int'},
        'uncompressed_digital_audio_opl': {'key': 'uncompressedDigitalAudioOpl', 'type': 'int'},
    }

    def __init__(self, *, digital_video_only_content_restriction: bool, image_constraint_for_analog_component_video_restriction: bool, image_constraint_for_analog_computer_monitor_restriction: bool, allow_passing_video_content_to_unknown_output, first_play_expiration=None, scms_restriction: int=None, agc_and_color_stripe_restriction: int=None, explicit_analog_television_output_restriction=None, uncompressed_digital_video_opl: int=None, compressed_digital_video_opl: int=None, analog_video_opl: int=None, compressed_digital_audio_opl: int=None, uncompressed_digital_audio_opl: int=None, **kwargs) -> None:
        super(ContentKeyPolicyPlayReadyPlayRight, self).__init__(**kwargs)
        self.first_play_expiration = first_play_expiration
        self.scms_restriction = scms_restriction
        self.agc_and_color_stripe_restriction = agc_and_color_stripe_restriction
        self.explicit_analog_television_output_restriction = explicit_analog_television_output_restriction
        self.digital_video_only_content_restriction = digital_video_only_content_restriction
        self.image_constraint_for_analog_component_video_restriction = image_constraint_for_analog_component_video_restriction
        self.image_constraint_for_analog_computer_monitor_restriction = image_constraint_for_analog_computer_monitor_restriction
        self.allow_passing_video_content_to_unknown_output = allow_passing_video_content_to_unknown_output
        self.uncompressed_digital_video_opl = uncompressed_digital_video_opl
        self.compressed_digital_video_opl = compressed_digital_video_opl
        self.analog_video_opl = analog_video_opl
        self.compressed_digital_audio_opl = compressed_digital_audio_opl
        self.uncompressed_digital_audio_opl = uncompressed_digital_audio_opl


class ContentKeyPolicyProperties(Model):
    """The properties of the Content Key Policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar policy_id: The legacy Policy ID.
    :vartype policy_id: str
    :ivar created: The creation date of the Policy
    :vartype created: datetime
    :ivar last_modified: The last modified date of the Policy
    :vartype last_modified: datetime
    :param description: A description for the Policy.
    :type description: str
    :param options: Required. The Key Policy options.
    :type options: list[~azure.mgmt.media.models.ContentKeyPolicyOption]
    """

    _validation = {
        'policy_id': {'readonly': True},
        'created': {'readonly': True},
        'last_modified': {'readonly': True},
        'options': {'required': True},
    }

    _attribute_map = {
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'created': {'key': 'created', 'type': 'iso-8601'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
        'description': {'key': 'description', 'type': 'str'},
        'options': {'key': 'options', 'type': '[ContentKeyPolicyOption]'},
    }

    def __init__(self, *, options, description: str=None, **kwargs) -> None:
        super(ContentKeyPolicyProperties, self).__init__(**kwargs)
        self.policy_id = None
        self.created = None
        self.last_modified = None
        self.description = description
        self.options = options


class ContentKeyPolicyRestrictionTokenKey(Model):
    """Base class for Content Key Policy key for token validation. A derived class
    must be used to create a token key.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ContentKeyPolicySymmetricTokenKey,
    ContentKeyPolicyRsaTokenKey, ContentKeyPolicyX509CertificateTokenKey

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.ContentKeyPolicySymmetricTokenKey': 'ContentKeyPolicySymmetricTokenKey', '#Microsoft.Media.ContentKeyPolicyRsaTokenKey': 'ContentKeyPolicyRsaTokenKey', '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey': 'ContentKeyPolicyX509CertificateTokenKey'}
    }

    def __init__(self, **kwargs) -> None:
        super(ContentKeyPolicyRestrictionTokenKey, self).__init__(**kwargs)
        self.odatatype = None


class ContentKeyPolicyRsaTokenKey(ContentKeyPolicyRestrictionTokenKey):
    """Specifies a RSA key for token validation.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param exponent: Required. The RSA Parameter exponent
    :type exponent: bytearray
    :param modulus: Required. The RSA Parameter modulus
    :type modulus: bytearray
    """

    _validation = {
        'odatatype': {'required': True},
        'exponent': {'required': True},
        'modulus': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'exponent': {'key': 'exponent', 'type': 'bytearray'},
        'modulus': {'key': 'modulus', 'type': 'bytearray'},
    }

    def __init__(self, *, exponent: bytearray, modulus: bytearray, **kwargs) -> None:
        super(ContentKeyPolicyRsaTokenKey, self).__init__(**kwargs)
        self.exponent = exponent
        self.modulus = modulus
        self.odatatype = '#Microsoft.Media.ContentKeyPolicyRsaTokenKey'


class ContentKeyPolicySymmetricTokenKey(ContentKeyPolicyRestrictionTokenKey):
    """Specifies a symmetric key for token validation.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param key_value: Required. The key value of the key
    :type key_value: bytearray
    """

    _validation = {
        'odatatype': {'required': True},
        'key_value': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'key_value': {'key': 'keyValue', 'type': 'bytearray'},
    }

    def __init__(self, *, key_value: bytearray, **kwargs) -> None:
        super(ContentKeyPolicySymmetricTokenKey, self).__init__(**kwargs)
        self.key_value = key_value
        self.odatatype = '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'


class ContentKeyPolicyTokenClaim(Model):
    """Represents a token claim.

    :param claim_type: Token claim type.
    :type claim_type: str
    :param claim_value: Token claim value.
    :type claim_value: str
    """

    _attribute_map = {
        'claim_type': {'key': 'claimType', 'type': 'str'},
        'claim_value': {'key': 'claimValue', 'type': 'str'},
    }

    def __init__(self, *, claim_type: str=None, claim_value: str=None, **kwargs) -> None:
        super(ContentKeyPolicyTokenClaim, self).__init__(**kwargs)
        self.claim_type = claim_type
        self.claim_value = claim_value


class ContentKeyPolicyTokenRestriction(ContentKeyPolicyRestriction):
    """Represents a token restriction. Provided token must match these
    requirements for successful license or key delivery.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param issuer: Required. The token issuer.
    :type issuer: str
    :param audience: Required. The audience for the token.
    :type audience: str
    :param primary_verification_key: Required. The primary verification key.
    :type primary_verification_key:
     ~azure.mgmt.media.models.ContentKeyPolicyRestrictionTokenKey
    :param alternate_verification_keys: A list of alternative verification
     keys.
    :type alternate_verification_keys:
     list[~azure.mgmt.media.models.ContentKeyPolicyRestrictionTokenKey]
    :param required_claims: A list of required token claims.
    :type required_claims:
     list[~azure.mgmt.media.models.ContentKeyPolicyTokenClaim]
    :param restriction_token_type: Required. The type of token. Possible
     values include: 'Unknown', 'Swt', 'Jwt'
    :type restriction_token_type: str or
     ~azure.mgmt.media.models.ContentKeyPolicyRestrictionTokenType
    :param open_id_connect_discovery_document: The OpenID connect discovery
     document.
    :type open_id_connect_discovery_document: str
    """

    _validation = {
        'odatatype': {'required': True},
        'issuer': {'required': True},
        'audience': {'required': True},
        'primary_verification_key': {'required': True},
        'restriction_token_type': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'audience': {'key': 'audience', 'type': 'str'},
        'primary_verification_key': {'key': 'primaryVerificationKey', 'type': 'ContentKeyPolicyRestrictionTokenKey'},
        'alternate_verification_keys': {'key': 'alternateVerificationKeys', 'type': '[ContentKeyPolicyRestrictionTokenKey]'},
        'required_claims': {'key': 'requiredClaims', 'type': '[ContentKeyPolicyTokenClaim]'},
        'restriction_token_type': {'key': 'restrictionTokenType', 'type': 'str'},
        'open_id_connect_discovery_document': {'key': 'openIdConnectDiscoveryDocument', 'type': 'str'},
    }

    def __init__(self, *, issuer: str, audience: str, primary_verification_key, restriction_token_type, alternate_verification_keys=None, required_claims=None, open_id_connect_discovery_document: str=None, **kwargs) -> None:
        super(ContentKeyPolicyTokenRestriction, self).__init__(**kwargs)
        self.issuer = issuer
        self.audience = audience
        self.primary_verification_key = primary_verification_key
        self.alternate_verification_keys = alternate_verification_keys
        self.required_claims = required_claims
        self.restriction_token_type = restriction_token_type
        self.open_id_connect_discovery_document = open_id_connect_discovery_document
        self.odatatype = '#Microsoft.Media.ContentKeyPolicyTokenRestriction'


class ContentKeyPolicyUnknownConfiguration(ContentKeyPolicyConfiguration):
    """Represents a ContentKeyPolicyConfiguration that is unavailable in the
    current API version.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ContentKeyPolicyUnknownConfiguration, self).__init__(**kwargs)
        self.odatatype = '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration'


class ContentKeyPolicyUnknownRestriction(ContentKeyPolicyRestriction):
    """Represents a ContentKeyPolicyRestriction that is unavailable in the current
    API version.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ContentKeyPolicyUnknownRestriction, self).__init__(**kwargs)
        self.odatatype = '#Microsoft.Media.ContentKeyPolicyUnknownRestriction'


class ContentKeyPolicyWidevineConfiguration(ContentKeyPolicyConfiguration):
    """Specifies a configuration for Widevine licenses.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param widevine_template: Required. The Widevine template.
    :type widevine_template: str
    """

    _validation = {
        'odatatype': {'required': True},
        'widevine_template': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'widevine_template': {'key': 'widevineTemplate', 'type': 'str'},
    }

    def __init__(self, *, widevine_template: str, **kwargs) -> None:
        super(ContentKeyPolicyWidevineConfiguration, self).__init__(**kwargs)
        self.widevine_template = widevine_template
        self.odatatype = '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration'


class ContentKeyPolicyX509CertificateTokenKey(ContentKeyPolicyRestrictionTokenKey):
    """Specifies a certificate for token validation.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param raw_body: Required. The raw data field of a certificate in PKCS 12
     format (X509Certificate2 in .NET)
    :type raw_body: bytearray
    """

    _validation = {
        'odatatype': {'required': True},
        'raw_body': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'raw_body': {'key': 'rawBody', 'type': 'bytearray'},
    }

    def __init__(self, *, raw_body: bytearray, **kwargs) -> None:
        super(ContentKeyPolicyX509CertificateTokenKey, self).__init__(**kwargs)
        self.raw_body = raw_body
        self.odatatype = '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'


class CopyAudio(Codec):
    """A codec flag, which tells the encoder to copy the input audio bitstream.

    All required parameters must be populated in order to send to Azure.

    :param label: An optional label for the codec. The label can be used to
     control muxing behavior.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(self, *, label: str=None, **kwargs) -> None:
        super(CopyAudio, self).__init__(label=label, **kwargs)
        self.odatatype = '#Microsoft.Media.CopyAudio'


class CopyVideo(Codec):
    """A codec flag, which tells the encoder to copy the input video bitstream
    without re-encoding.

    All required parameters must be populated in order to send to Azure.

    :param label: An optional label for the codec. The label can be used to
     control muxing behavior.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(self, *, label: str=None, **kwargs) -> None:
        super(CopyVideo, self).__init__(label=label, **kwargs)
        self.odatatype = '#Microsoft.Media.CopyVideo'


class CrossSiteAccessPolicies(Model):
    """The client access policy.

    :param client_access_policy: The content of clientaccesspolicy.xml used by
     Silverlight.
    :type client_access_policy: str
    :param cross_domain_policy: The content of crossdomain.xml used by
     Silverlight.
    :type cross_domain_policy: str
    """

    _attribute_map = {
        'client_access_policy': {'key': 'clientAccessPolicy', 'type': 'str'},
        'cross_domain_policy': {'key': 'crossDomainPolicy', 'type': 'str'},
    }

    def __init__(self, *, client_access_policy: str=None, cross_domain_policy: str=None, **kwargs) -> None:
        super(CrossSiteAccessPolicies, self).__init__(**kwargs)
        self.client_access_policy = client_access_policy
        self.cross_domain_policy = cross_domain_policy


class DefaultKey(Model):
    """Class to specify properties of default content key for each encryption
    scheme.

    :param label: Label can be used to specify Content Key when creating a
     Streaming Locator
    :type label: str
    :param policy_name: Policy used by Default Key
    :type policy_name: str
    """

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
    }

    def __init__(self, *, label: str=None, policy_name: str=None, **kwargs) -> None:
        super(DefaultKey, self).__init__(**kwargs)
        self.label = label
        self.policy_name = policy_name


class Deinterlace(Model):
    """Describes the de-interlacing settings.

    :param parity: The field parity for de-interlacing, defaults to Auto.
     Possible values include: 'Auto', 'TopFieldFirst', 'BottomFieldFirst'
    :type parity: str or ~azure.mgmt.media.models.DeinterlaceParity
    :param mode: The deinterlacing mode. Defaults to AutoPixelAdaptive.
     Possible values include: 'Off', 'AutoPixelAdaptive'
    :type mode: str or ~azure.mgmt.media.models.DeinterlaceMode
    """

    _attribute_map = {
        'parity': {'key': 'parity', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(self, *, parity=None, mode=None, **kwargs) -> None:
        super(Deinterlace, self).__init__(**kwargs)
        self.parity = parity
        self.mode = mode


class EdgePolicies(Model):
    """EdgePolicies.

    :param usage_data_collection_policy:
    :type usage_data_collection_policy:
     ~azure.mgmt.media.models.EdgeUsageDataCollectionPolicy
    """

    _attribute_map = {
        'usage_data_collection_policy': {'key': 'usageDataCollectionPolicy', 'type': 'EdgeUsageDataCollectionPolicy'},
    }

    def __init__(self, *, usage_data_collection_policy=None, **kwargs) -> None:
        super(EdgePolicies, self).__init__(**kwargs)
        self.usage_data_collection_policy = usage_data_collection_policy


class EdgeUsageDataCollectionPolicy(Model):
    """EdgeUsageDataCollectionPolicy.

    :param data_collection_frequency: Usage data collection frequency in ISO
     8601 duration format e.g. PT10M , PT5H.
    :type data_collection_frequency: str
    :param data_reporting_frequency: Usage data reporting frequency in ISO
     8601 duration format e.g. PT10M , PT5H.
    :type data_reporting_frequency: str
    :param max_allowed_unreported_usage_duration: Maximum time for which the
     functionality of the device will not be hampered for not reporting the
     usage data.
    :type max_allowed_unreported_usage_duration: str
    :param event_hub_details: Details of Event Hub where the usage will be
     reported.
    :type event_hub_details: ~azure.mgmt.media.models.EdgeUsageDataEventHub
    """

    _attribute_map = {
        'data_collection_frequency': {'key': 'dataCollectionFrequency', 'type': 'str'},
        'data_reporting_frequency': {'key': 'dataReportingFrequency', 'type': 'str'},
        'max_allowed_unreported_usage_duration': {'key': 'maxAllowedUnreportedUsageDuration', 'type': 'str'},
        'event_hub_details': {'key': 'eventHubDetails', 'type': 'EdgeUsageDataEventHub'},
    }

    def __init__(self, *, data_collection_frequency: str=None, data_reporting_frequency: str=None, max_allowed_unreported_usage_duration: str=None, event_hub_details=None, **kwargs) -> None:
        super(EdgeUsageDataCollectionPolicy, self).__init__(**kwargs)
        self.data_collection_frequency = data_collection_frequency
        self.data_reporting_frequency = data_reporting_frequency
        self.max_allowed_unreported_usage_duration = max_allowed_unreported_usage_duration
        self.event_hub_details = event_hub_details


class EdgeUsageDataEventHub(Model):
    """EdgeUsageDataEventHub.

    :param name: Name of the Event Hub where usage will be reported.
    :type name: str
    :param namespace: Namespace of the Event Hub where usage will be reported.
    :type namespace: str
    :param token: SAS token needed to interact with Event Hub.
    :type token: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, namespace: str=None, token: str=None, **kwargs) -> None:
        super(EdgeUsageDataEventHub, self).__init__(**kwargs)
        self.name = name
        self.namespace = namespace
        self.token = token


class EnabledProtocols(Model):
    """Class to specify which protocols are enabled.

    All required parameters must be populated in order to send to Azure.

    :param download: Required. Enable Download protocol or not
    :type download: bool
    :param dash: Required. Enable DASH protocol or not
    :type dash: bool
    :param hls: Required. Enable HLS protocol or not
    :type hls: bool
    :param smooth_streaming: Required. Enable SmoothStreaming protocol or not
    :type smooth_streaming: bool
    """

    _validation = {
        'download': {'required': True},
        'dash': {'required': True},
        'hls': {'required': True},
        'smooth_streaming': {'required': True},
    }

    _attribute_map = {
        'download': {'key': 'download', 'type': 'bool'},
        'dash': {'key': 'dash', 'type': 'bool'},
        'hls': {'key': 'hls', 'type': 'bool'},
        'smooth_streaming': {'key': 'smoothStreaming', 'type': 'bool'},
    }

    def __init__(self, *, download: bool, dash: bool, hls: bool, smooth_streaming: bool, **kwargs) -> None:
        super(EnabledProtocols, self).__init__(**kwargs)
        self.download = download
        self.dash = dash
        self.hls = hls
        self.smooth_streaming = smooth_streaming


class EntityNameAvailabilityCheckOutput(Model):
    """The response from the check name availability request.

    All required parameters must be populated in order to send to Azure.

    :param name_available: Required. Specifies if the name is available.
    :type name_available: bool
    :param reason: Specifies the reason if the name is not available.
    :type reason: str
    :param message: Specifies the detailed reason if the name is not
     available.
    :type message: str
    """

    _validation = {
        'name_available': {'required': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, name_available: bool, reason: str=None, message: str=None, **kwargs) -> None:
        super(EntityNameAvailabilityCheckOutput, self).__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class EnvelopeEncryption(Model):
    """Class for EnvelopeEncryption encryption scheme.

    :param enabled_protocols: Representing supported protocols
    :type enabled_protocols: ~azure.mgmt.media.models.EnabledProtocols
    :param clear_tracks: Representing which tracks should not be encrypted
    :type clear_tracks: list[~azure.mgmt.media.models.TrackSelection]
    :param content_keys: Representing default content key for each encryption
     scheme and separate content keys for specific tracks
    :type content_keys: ~azure.mgmt.media.models.StreamingPolicyContentKeys
    :param custom_key_acquisition_url_template: Template for the URL of the
     custom service delivering keys to end user players.  Not required when
     using Azure Media Services for issuing keys.  The template supports
     replaceable tokens that the service will update at runtime with the value
     specific to the request.  The currently supported token values are
     {AlternativeMediaId}, which is replaced with the value of
     StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is
     replaced with the value of identifier of the key being requested.
    :type custom_key_acquisition_url_template: str
    """

    _attribute_map = {
        'enabled_protocols': {'key': 'enabledProtocols', 'type': 'EnabledProtocols'},
        'clear_tracks': {'key': 'clearTracks', 'type': '[TrackSelection]'},
        'content_keys': {'key': 'contentKeys', 'type': 'StreamingPolicyContentKeys'},
        'custom_key_acquisition_url_template': {'key': 'customKeyAcquisitionUrlTemplate', 'type': 'str'},
    }

    def __init__(self, *, enabled_protocols=None, clear_tracks=None, content_keys=None, custom_key_acquisition_url_template: str=None, **kwargs) -> None:
        super(EnvelopeEncryption, self).__init__(**kwargs)
        self.enabled_protocols = enabled_protocols
        self.clear_tracks = clear_tracks
        self.content_keys = content_keys
        self.custom_key_acquisition_url_template = custom_key_acquisition_url_template


class FaceDetectorPreset(Preset):
    """Describes all the settings to be used when analyzing a video in order to
    detect (and optionally redact) all the faces present.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param resolution: Specifies the maximum resolution at which your video is
     analyzed. The default behavior is "SourceResolution," which will keep the
     input video at its original resolution when analyzed. Using
     "StandardDefinition" will resize input videos to standard definition while
     preserving the appropriate aspect ratio. It will only resize if the video
     is of higher resolution. For example, a 1920x1080 input would be scaled to
     640x360 before processing. Switching to "StandardDefinition" will reduce
     the time it takes to process high resolution video. It may also reduce the
     cost of using this component (see
     https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics
     for details). However, faces that end up being too small in the resized
     video may not be detected. Possible values include: 'SourceResolution',
     'StandardDefinition'
    :type resolution: str or ~azure.mgmt.media.models.AnalysisResolution
    :param mode: This mode provides the ability to choose between the
     following settings: 1) Analyze - For detection only.This mode generates a
     metadata JSON file marking appearances of faces throughout the video.Where
     possible, appearances of the same person are assigned the same ID. 2)
     Combined - Additionally redacts(blurs) detected faces. 3) Redact - This
     enables a 2-pass process, allowing for selective redaction of a subset of
     detected faces.It takes in the metadata file from a prior analyze pass,
     along with the source video, and a user-selected subset of IDs that
     require redaction. Possible values include: 'Analyze', 'Redact',
     'Combined'
    :type mode: str or ~azure.mgmt.media.models.FaceRedactorMode
    :param blur_type: Blur type. Possible values include: 'Box', 'Low', 'Med',
     'High', 'Black'
    :type blur_type: str or ~azure.mgmt.media.models.BlurType
    :param experimental_options: Dictionary containing key value pairs for
     parameters not exposed in the preset itself
    :type experimental_options: dict[str, str]
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'resolution': {'key': 'resolution', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'blur_type': {'key': 'blurType', 'type': 'str'},
        'experimental_options': {'key': 'experimentalOptions', 'type': '{str}'},
    }

    def __init__(self, *, resolution=None, mode=None, blur_type=None, experimental_options=None, **kwargs) -> None:
        super(FaceDetectorPreset, self).__init__(**kwargs)
        self.resolution = resolution
        self.mode = mode
        self.blur_type = blur_type
        self.experimental_options = experimental_options
        self.odatatype = '#Microsoft.Media.FaceDetectorPreset'


class Filters(Model):
    """Describes all the filtering operations, such as de-interlacing, rotation
    etc. that are to be applied to the input media before encoding.

    :param deinterlace: The de-interlacing settings.
    :type deinterlace: ~azure.mgmt.media.models.Deinterlace
    :param rotation: The rotation, if any, to be applied to the input video,
     before it is encoded. Default is Auto. Possible values include: 'Auto',
     'None', 'Rotate0', 'Rotate90', 'Rotate180', 'Rotate270'
    :type rotation: str or ~azure.mgmt.media.models.Rotation
    :param crop: The parameters for the rectangular window with which to crop
     the input video.
    :type crop: ~azure.mgmt.media.models.Rectangle
    :param overlays: The properties of overlays to be applied to the input
     video. These could be audio, image or video overlays.
    :type overlays: list[~azure.mgmt.media.models.Overlay]
    """

    _attribute_map = {
        'deinterlace': {'key': 'deinterlace', 'type': 'Deinterlace'},
        'rotation': {'key': 'rotation', 'type': 'str'},
        'crop': {'key': 'crop', 'type': 'Rectangle'},
        'overlays': {'key': 'overlays', 'type': '[Overlay]'},
    }

    def __init__(self, *, deinterlace=None, rotation=None, crop=None, overlays=None, **kwargs) -> None:
        super(Filters, self).__init__(**kwargs)
        self.deinterlace = deinterlace
        self.rotation = rotation
        self.crop = crop
        self.overlays = overlays


class FilterTrackPropertyCondition(Model):
    """The class to specify one track property condition.

    All required parameters must be populated in order to send to Azure.

    :param property: Required. The track property type. Possible values
     include: 'Unknown', 'Type', 'Name', 'Language', 'FourCC', 'Bitrate'
    :type property: str or ~azure.mgmt.media.models.FilterTrackPropertyType
    :param value: Required. The track property value.
    :type value: str
    :param operation: Required. The track property condition operation.
     Possible values include: 'Equal', 'NotEqual'
    :type operation: str or
     ~azure.mgmt.media.models.FilterTrackPropertyCompareOperation
    """

    _validation = {
        'property': {'required': True},
        'value': {'required': True},
        'operation': {'required': True},
    }

    _attribute_map = {
        'property': {'key': 'property', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(self, *, property, value: str, operation, **kwargs) -> None:
        super(FilterTrackPropertyCondition, self).__init__(**kwargs)
        self.property = property
        self.value = value
        self.operation = operation


class FilterTrackSelection(Model):
    """Representing a list of FilterTrackPropertyConditions to select a track.
    The filters are combined using a logical AND operation.

    All required parameters must be populated in order to send to Azure.

    :param track_selections: Required. The track selections.
    :type track_selections:
     list[~azure.mgmt.media.models.FilterTrackPropertyCondition]
    """

    _validation = {
        'track_selections': {'required': True},
    }

    _attribute_map = {
        'track_selections': {'key': 'trackSelections', 'type': '[FilterTrackPropertyCondition]'},
    }

    def __init__(self, *, track_selections, **kwargs) -> None:
        super(FilterTrackSelection, self).__init__(**kwargs)
        self.track_selections = track_selections


class FirstQuality(Model):
    """Filter First Quality.

    All required parameters must be populated in order to send to Azure.

    :param bitrate: Required. The first quality bitrate.
    :type bitrate: int
    """

    _validation = {
        'bitrate': {'required': True},
    }

    _attribute_map = {
        'bitrate': {'key': 'bitrate', 'type': 'int'},
    }

    def __init__(self, *, bitrate: int, **kwargs) -> None:
        super(FirstQuality, self).__init__(**kwargs)
        self.bitrate = bitrate


class Format(Model):
    """Base class for output.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ImageFormat, MultiBitrateFormat

    All required parameters must be populated in order to send to Azure.

    :param filename_pattern: Required. The pattern of the file names for the
     generated output files. The following macros are supported in the file
     name: {Basename} - An expansion macro that will use the name of the input
     video file. If the base name(the file suffix is not included) of the input
     video file is less than 32 characters long, the base name of input video
     files will be used. If the length of base name of the input video file
     exceeds 32 characters, the base name is truncated to the first 32
     characters in total length. {Extension} - The appropriate extension for
     this format. {Label} - The label assigned to the codec/layer. {Index} - A
     unique index for thumbnails. Only applicable to thumbnails. {Bitrate} -
     The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type
     of the audio/video codec. {Resolution} - The video resolution. Any
     unsubstituted macros will be collapsed and removed from the filename.
    :type filename_pattern: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'filename_pattern': {'required': True},
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'filename_pattern': {'key': 'filenamePattern', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.ImageFormat': 'ImageFormat', '#Microsoft.Media.MultiBitrateFormat': 'MultiBitrateFormat'}
    }

    def __init__(self, *, filename_pattern: str, **kwargs) -> None:
        super(Format, self).__init__(**kwargs)
        self.filename_pattern = filename_pattern
        self.odatatype = None


class InputDefinition(Model):
    """Base class for defining an input. Use sub classes of this class to specify
    tracks selections and related metadata.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FromAllInputFile, FromEachInputFile, InputFile

    All required parameters must be populated in order to send to Azure.

    :param included_tracks: The list of TrackDescriptors which define the
     metadata and selection of tracks in the input.
    :type included_tracks: list[~azure.mgmt.media.models.TrackDescriptor]
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'included_tracks': {'key': 'includedTracks', 'type': '[TrackDescriptor]'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.FromAllInputFile': 'FromAllInputFile', '#Microsoft.Media.FromEachInputFile': 'FromEachInputFile', '#Microsoft.Media.InputFile': 'InputFile'}
    }

    def __init__(self, *, included_tracks=None, **kwargs) -> None:
        super(InputDefinition, self).__init__(**kwargs)
        self.included_tracks = included_tracks
        self.odatatype = None


class FromAllInputFile(InputDefinition):
    """An InputDefinition that looks across all of the files provided to select
    tracks specified by the IncludedTracks property. Generally used with the
    AudioTrackByAttribute and VideoTrackByAttribute to allow selection of a
    single track across a set of input files.

    All required parameters must be populated in order to send to Azure.

    :param included_tracks: The list of TrackDescriptors which define the
     metadata and selection of tracks in the input.
    :type included_tracks: list[~azure.mgmt.media.models.TrackDescriptor]
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'included_tracks': {'key': 'includedTracks', 'type': '[TrackDescriptor]'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(self, *, included_tracks=None, **kwargs) -> None:
        super(FromAllInputFile, self).__init__(included_tracks=included_tracks, **kwargs)
        self.odatatype = '#Microsoft.Media.FromAllInputFile'


class FromEachInputFile(InputDefinition):
    """An InputDefinition that looks at each input file provided to select tracks
    specified by the IncludedTracks property. Generally used with the
    AudioTrackByAttribute and VideoTrackByAttribute to select tracks from each
    file given.

    All required parameters must be populated in order to send to Azure.

    :param included_tracks: The list of TrackDescriptors which define the
     metadata and selection of tracks in the input.
    :type included_tracks: list[~azure.mgmt.media.models.TrackDescriptor]
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'included_tracks': {'key': 'includedTracks', 'type': '[TrackDescriptor]'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(self, *, included_tracks=None, **kwargs) -> None:
        super(FromEachInputFile, self).__init__(included_tracks=included_tracks, **kwargs)
        self.odatatype = '#Microsoft.Media.FromEachInputFile'


class Layer(Model):
    """The encoder can be configured to produce video and/or images (thumbnails)
    at different resolutions, by specifying a layer for each desired
    resolution. A layer represents the properties for the video or image at a
    resolution.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: H265VideoLayer, VideoLayer, JpgLayer, PngLayer

    All required parameters must be populated in order to send to Azure.

    :param width: The width of the output video for this layer. The value can
     be absolute (in pixels) or relative (in percentage). For example 50% means
     the output video has half as many pixels in width as the input.
    :type width: str
    :param height: The height of the output video for this layer. The value
     can be absolute (in pixels) or relative (in percentage). For example 50%
     means the output video has half as many pixels in height as the input.
    :type height: str
    :param label: The alphanumeric label for this layer, which can be used in
     multiplexing different video and audio layers, or in naming the output
     file.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'width': {'key': 'width', 'type': 'str'},
        'height': {'key': 'height', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.H265VideoLayer': 'H265VideoLayer', '#Microsoft.Media.VideoLayer': 'VideoLayer', '#Microsoft.Media.JpgLayer': 'JpgLayer', '#Microsoft.Media.PngLayer': 'PngLayer'}
    }

    def __init__(self, *, width: str=None, height: str=None, label: str=None, **kwargs) -> None:
        super(Layer, self).__init__(**kwargs)
        self.width = width
        self.height = height
        self.label = label
        self.odatatype = None


class VideoLayer(Layer):
    """Describes the settings to be used when encoding the input video into a
    desired output bitrate layer.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: H264Layer

    All required parameters must be populated in order to send to Azure.

    :param width: The width of the output video for this layer. The value can
     be absolute (in pixels) or relative (in percentage). For example 50% means
     the output video has half as many pixels in width as the input.
    :type width: str
    :param height: The height of the output video for this layer. The value
     can be absolute (in pixels) or relative (in percentage). For example 50%
     means the output video has half as many pixels in height as the input.
    :type height: str
    :param label: The alphanumeric label for this layer, which can be used in
     multiplexing different video and audio layers, or in naming the output
     file.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param bitrate: Required. The average bitrate in bits per second at which
     to encode the input video when generating this layer. This is a required
     field.
    :type bitrate: int
    :param max_bitrate: The maximum bitrate (in bits per second), at which the
     VBV buffer should be assumed to refill. If not specified, defaults to the
     same value as bitrate.
    :type max_bitrate: int
    :param b_frames: The number of B-frames to be used when encoding this
     layer.  If not specified, the encoder chooses an appropriate number based
     on the video profile and level.
    :type b_frames: int
    :param frame_rate: The frame rate (in frames per second) at which to
     encode this layer. The value can be in the form of M/N where M and N are
     integers (For example, 30000/1001), or in the form of a number (For
     example, 30, or 29.97). The encoder enforces constraints on allowed frame
     rates based on the profile and level. If it is not specified, the encoder
     will use the same frame rate as the input video.
    :type frame_rate: str
    :param slices: The number of slices to be used when encoding this layer.
     If not specified, default is zero, which means that encoder will use a
     single slice for each frame.
    :type slices: int
    :param adaptive_bframe: Whether or not adaptive B-frames are to be used
     when encoding this layer. If not specified, the encoder will turn it on
     whenever the video profile permits its use.
    :type adaptive_bframe: bool
    """

    _validation = {
        'odatatype': {'required': True},
        'bitrate': {'required': True},
    }

    _attribute_map = {
        'width': {'key': 'width', 'type': 'str'},
        'height': {'key': 'height', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'bitrate': {'key': 'bitrate', 'type': 'int'},
        'max_bitrate': {'key': 'maxBitrate', 'type': 'int'},
        'b_frames': {'key': 'bFrames', 'type': 'int'},
        'frame_rate': {'key': 'frameRate', 'type': 'str'},
        'slices': {'key': 'slices', 'type': 'int'},
        'adaptive_bframe': {'key': 'adaptiveBFrame', 'type': 'bool'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.H264Layer': 'H264Layer'}
    }

    def __init__(self, *, bitrate: int, width: str=None, height: str=None, label: str=None, max_bitrate: int=None, b_frames: int=None, frame_rate: str=None, slices: int=None, adaptive_bframe: bool=None, **kwargs) -> None:
        super(VideoLayer, self).__init__(width=width, height=height, label=label, **kwargs)
        self.bitrate = bitrate
        self.max_bitrate = max_bitrate
        self.b_frames = b_frames
        self.frame_rate = frame_rate
        self.slices = slices
        self.adaptive_bframe = adaptive_bframe
        self.odatatype = '#Microsoft.Media.VideoLayer'


class H264Layer(VideoLayer):
    """Describes the settings to be used when encoding the input video into a
    desired output bitrate layer with the H.264 video codec.

    All required parameters must be populated in order to send to Azure.

    :param width: The width of the output video for this layer. The value can
     be absolute (in pixels) or relative (in percentage). For example 50% means
     the output video has half as many pixels in width as the input.
    :type width: str
    :param height: The height of the output video for this layer. The value
     can be absolute (in pixels) or relative (in percentage). For example 50%
     means the output video has half as many pixels in height as the input.
    :type height: str
    :param label: The alphanumeric label for this layer, which can be used in
     multiplexing different video and audio layers, or in naming the output
     file.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param bitrate: Required. The average bitrate in bits per second at which
     to encode the input video when generating this layer. This is a required
     field.
    :type bitrate: int
    :param max_bitrate: The maximum bitrate (in bits per second), at which the
     VBV buffer should be assumed to refill. If not specified, defaults to the
     same value as bitrate.
    :type max_bitrate: int
    :param b_frames: The number of B-frames to be used when encoding this
     layer.  If not specified, the encoder chooses an appropriate number based
     on the video profile and level.
    :type b_frames: int
    :param frame_rate: The frame rate (in frames per second) at which to
     encode this layer. The value can be in the form of M/N where M and N are
     integers (For example, 30000/1001), or in the form of a number (For
     example, 30, or 29.97). The encoder enforces constraints on allowed frame
     rates based on the profile and level. If it is not specified, the encoder
     will use the same frame rate as the input video.
    :type frame_rate: str
    :param slices: The number of slices to be used when encoding this layer.
     If not specified, default is zero, which means that encoder will use a
     single slice for each frame.
    :type slices: int
    :param adaptive_bframe: Whether or not adaptive B-frames are to be used
     when encoding this layer. If not specified, the encoder will turn it on
     whenever the video profile permits its use.
    :type adaptive_bframe: bool
    :param profile: We currently support Baseline, Main, High, High422,
     High444. Default is Auto. Possible values include: 'Auto', 'Baseline',
     'Main', 'High', 'High422', 'High444'
    :type profile: str or ~azure.mgmt.media.models.H264VideoProfile
    :param level: We currently support Level up to 6.2. The value can be Auto,
     or a number that matches the H.264 profile. If not specified, the default
     is Auto, which lets the encoder choose the Level that is appropriate for
     this layer.
    :type level: str
    :param buffer_window: The VBV buffer window length. The value should be in
     ISO 8601 format. The value should be in the range [0.1-100] seconds. The
     default is 5 seconds (for example, PT5S).
    :type buffer_window: timedelta
    :param reference_frames: The number of reference frames to be used when
     encoding this layer. If not specified, the encoder determines an
     appropriate number based on the encoder complexity setting.
    :type reference_frames: int
    :param entropy_mode: The entropy mode to be used for this layer. If not
     specified, the encoder chooses the mode that is appropriate for the
     profile and level. Possible values include: 'Cabac', 'Cavlc'
    :type entropy_mode: str or ~azure.mgmt.media.models.EntropyMode
    """

    _validation = {
        'odatatype': {'required': True},
        'bitrate': {'required': True},
    }

    _attribute_map = {
        'width': {'key': 'width', 'type': 'str'},
        'height': {'key': 'height', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'bitrate': {'key': 'bitrate', 'type': 'int'},
        'max_bitrate': {'key': 'maxBitrate', 'type': 'int'},
        'b_frames': {'key': 'bFrames', 'type': 'int'},
        'frame_rate': {'key': 'frameRate', 'type': 'str'},
        'slices': {'key': 'slices', 'type': 'int'},
        'adaptive_bframe': {'key': 'adaptiveBFrame', 'type': 'bool'},
        'profile': {'key': 'profile', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'buffer_window': {'key': 'bufferWindow', 'type': 'duration'},
        'reference_frames': {'key': 'referenceFrames', 'type': 'int'},
        'entropy_mode': {'key': 'entropyMode', 'type': 'str'},
    }

    def __init__(self, *, bitrate: int, width: str=None, height: str=None, label: str=None, max_bitrate: int=None, b_frames: int=None, frame_rate: str=None, slices: int=None, adaptive_bframe: bool=None, profile=None, level: str=None, buffer_window=None, reference_frames: int=None, entropy_mode=None, **kwargs) -> None:
        super(H264Layer, self).__init__(width=width, height=height, label=label, bitrate=bitrate, max_bitrate=max_bitrate, b_frames=b_frames, frame_rate=frame_rate, slices=slices, adaptive_bframe=adaptive_bframe, **kwargs)
        self.profile = profile
        self.level = level
        self.buffer_window = buffer_window
        self.reference_frames = reference_frames
        self.entropy_mode = entropy_mode
        self.odatatype = '#Microsoft.Media.H264Layer'


class Video(Codec):
    """Describes the basic properties for encoding the input video.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: H265Video, Image, H264Video

    All required parameters must be populated in order to send to Azure.

    :param label: An optional label for the codec. The label can be used to
     control muxing behavior.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param key_frame_interval: The distance between two key frames. The value
     should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
     format. The default is 2 seconds(PT2S). Note that this setting is ignored
     if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will
     follow the input source setting.
    :type key_frame_interval: timedelta
    :param stretch_mode: The resizing mode - how the input video will be
     resized to fit the desired output resolution(s). Default is AutoSize.
     Possible values include: 'None', 'AutoSize', 'AutoFit'
    :type stretch_mode: str or ~azure.mgmt.media.models.StretchMode
    :param sync_mode: The Video Sync Mode. Possible values include: 'Auto',
     'Passthrough', 'Cfr', 'Vfr'
    :type sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'key_frame_interval': {'key': 'keyFrameInterval', 'type': 'duration'},
        'stretch_mode': {'key': 'stretchMode', 'type': 'str'},
        'sync_mode': {'key': 'syncMode', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.H265Video': 'H265Video', '#Microsoft.Media.Image': 'Image', '#Microsoft.Media.H264Video': 'H264Video'}
    }

    def __init__(self, *, label: str=None, key_frame_interval=None, stretch_mode=None, sync_mode=None, **kwargs) -> None:
        super(Video, self).__init__(label=label, **kwargs)
        self.key_frame_interval = key_frame_interval
        self.stretch_mode = stretch_mode
        self.sync_mode = sync_mode
        self.odatatype = '#Microsoft.Media.Video'


class H264Video(Video):
    """Describes all the properties for encoding a video with the H.264 codec.

    All required parameters must be populated in order to send to Azure.

    :param label: An optional label for the codec. The label can be used to
     control muxing behavior.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param key_frame_interval: The distance between two key frames. The value
     should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
     format. The default is 2 seconds(PT2S). Note that this setting is ignored
     if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will
     follow the input source setting.
    :type key_frame_interval: timedelta
    :param stretch_mode: The resizing mode - how the input video will be
     resized to fit the desired output resolution(s). Default is AutoSize.
     Possible values include: 'None', 'AutoSize', 'AutoFit'
    :type stretch_mode: str or ~azure.mgmt.media.models.StretchMode
    :param sync_mode: The Video Sync Mode. Possible values include: 'Auto',
     'Passthrough', 'Cfr', 'Vfr'
    :type sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
    :param scene_change_detection: Whether or not the encoder should insert
     key frames at scene changes. If not specified, the default is false. This
     flag should be set to true only when the encoder is being configured to
     produce a single output video.
    :type scene_change_detection: bool
    :param complexity: Tells the encoder how to choose its encoding settings.
     The default value is Balanced. Possible values include: 'Speed',
     'Balanced', 'Quality'
    :type complexity: str or ~azure.mgmt.media.models.H264Complexity
    :param layers: The collection of output H.264 layers to be produced by the
     encoder.
    :type layers: list[~azure.mgmt.media.models.H264Layer]
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'key_frame_interval': {'key': 'keyFrameInterval', 'type': 'duration'},
        'stretch_mode': {'key': 'stretchMode', 'type': 'str'},
        'sync_mode': {'key': 'syncMode', 'type': 'str'},
        'scene_change_detection': {'key': 'sceneChangeDetection', 'type': 'bool'},
        'complexity': {'key': 'complexity', 'type': 'str'},
        'layers': {'key': 'layers', 'type': '[H264Layer]'},
    }

    def __init__(self, *, label: str=None, key_frame_interval=None, stretch_mode=None, sync_mode=None, scene_change_detection: bool=None, complexity=None, layers=None, **kwargs) -> None:
        super(H264Video, self).__init__(label=label, key_frame_interval=key_frame_interval, stretch_mode=stretch_mode, sync_mode=sync_mode, **kwargs)
        self.scene_change_detection = scene_change_detection
        self.complexity = complexity
        self.layers = layers
        self.odatatype = '#Microsoft.Media.H264Video'


class H265VideoLayer(Layer):
    """Describes the settings to be used when encoding the input video into a
    desired output bitrate layer.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: H265Layer

    All required parameters must be populated in order to send to Azure.

    :param width: The width of the output video for this layer. The value can
     be absolute (in pixels) or relative (in percentage). For example 50% means
     the output video has half as many pixels in width as the input.
    :type width: str
    :param height: The height of the output video for this layer. The value
     can be absolute (in pixels) or relative (in percentage). For example 50%
     means the output video has half as many pixels in height as the input.
    :type height: str
    :param label: The alphanumeric label for this layer, which can be used in
     multiplexing different video and audio layers, or in naming the output
     file.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param bitrate: Required. The average bitrate in bits per second at which
     to encode the input video when generating this layer. For example: a
     target bitrate of 3000Kbps or 3Mbps means this value should be 3000000
     This is a required field.
    :type bitrate: int
    :param max_bitrate: The maximum bitrate (in bits per second), at which the
     VBV buffer should be assumed to refill. If not specified, defaults to the
     same value as bitrate.
    :type max_bitrate: int
    :param b_frames: The number of B-frames to be used when encoding this
     layer.  If not specified, the encoder chooses an appropriate number based
     on the video profile and level.
    :type b_frames: int
    :param frame_rate: The frame rate (in frames per second) at which to
     encode this layer. The value can be in the form of M/N where M and N are
     integers (For example, 30000/1001), or in the form of a number (For
     example, 30, or 29.97). The encoder enforces constraints on allowed frame
     rates based on the profile and level. If it is not specified, the encoder
     will use the same frame rate as the input video.
    :type frame_rate: str
    :param slices: The number of slices to be used when encoding this layer.
     If not specified, default is zero, which means that encoder will use a
     single slice for each frame.
    :type slices: int
    :param adaptive_bframe: Specifies whether or not adaptive B-frames are to
     be used when encoding this layer. If not specified, the encoder will turn
     it on whenever the video profile permits its use.
    :type adaptive_bframe: bool
    """

    _validation = {
        'odatatype': {'required': True},
        'bitrate': {'required': True},
    }

    _attribute_map = {
        'width': {'key': 'width', 'type': 'str'},
        'height': {'key': 'height', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'bitrate': {'key': 'bitrate', 'type': 'int'},
        'max_bitrate': {'key': 'maxBitrate', 'type': 'int'},
        'b_frames': {'key': 'bFrames', 'type': 'int'},
        'frame_rate': {'key': 'frameRate', 'type': 'str'},
        'slices': {'key': 'slices', 'type': 'int'},
        'adaptive_bframe': {'key': 'adaptiveBFrame', 'type': 'bool'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.H265Layer': 'H265Layer'}
    }

    def __init__(self, *, bitrate: int, width: str=None, height: str=None, label: str=None, max_bitrate: int=None, b_frames: int=None, frame_rate: str=None, slices: int=None, adaptive_bframe: bool=None, **kwargs) -> None:
        super(H265VideoLayer, self).__init__(width=width, height=height, label=label, **kwargs)
        self.bitrate = bitrate
        self.max_bitrate = max_bitrate
        self.b_frames = b_frames
        self.frame_rate = frame_rate
        self.slices = slices
        self.adaptive_bframe = adaptive_bframe
        self.odatatype = '#Microsoft.Media.H265VideoLayer'


class H265Layer(H265VideoLayer):
    """Describes the settings to be used when encoding the input video into a
    desired output bitrate layer with the H.265 video codec.

    All required parameters must be populated in order to send to Azure.

    :param width: The width of the output video for this layer. The value can
     be absolute (in pixels) or relative (in percentage). For example 50% means
     the output video has half as many pixels in width as the input.
    :type width: str
    :param height: The height of the output video for this layer. The value
     can be absolute (in pixels) or relative (in percentage). For example 50%
     means the output video has half as many pixels in height as the input.
    :type height: str
    :param label: The alphanumeric label for this layer, which can be used in
     multiplexing different video and audio layers, or in naming the output
     file.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param bitrate: Required. The average bitrate in bits per second at which
     to encode the input video when generating this layer. For example: a
     target bitrate of 3000Kbps or 3Mbps means this value should be 3000000
     This is a required field.
    :type bitrate: int
    :param max_bitrate: The maximum bitrate (in bits per second), at which the
     VBV buffer should be assumed to refill. If not specified, defaults to the
     same value as bitrate.
    :type max_bitrate: int
    :param b_frames: The number of B-frames to be used when encoding this
     layer.  If not specified, the encoder chooses an appropriate number based
     on the video profile and level.
    :type b_frames: int
    :param frame_rate: The frame rate (in frames per second) at which to
     encode this layer. The value can be in the form of M/N where M and N are
     integers (For example, 30000/1001), or in the form of a number (For
     example, 30, or 29.97). The encoder enforces constraints on allowed frame
     rates based on the profile and level. If it is not specified, the encoder
     will use the same frame rate as the input video.
    :type frame_rate: str
    :param slices: The number of slices to be used when encoding this layer.
     If not specified, default is zero, which means that encoder will use a
     single slice for each frame.
    :type slices: int
    :param adaptive_bframe: Specifies whether or not adaptive B-frames are to
     be used when encoding this layer. If not specified, the encoder will turn
     it on whenever the video profile permits its use.
    :type adaptive_bframe: bool
    :param profile: We currently support Main. Default is Auto. Possible
     values include: 'Auto', 'Main'
    :type profile: str or ~azure.mgmt.media.models.H265VideoProfile
    :param level: We currently support Level up to 6.2. The value can be Auto,
     or a number that matches the H.265 profile. If not specified, the default
     is Auto, which lets the encoder choose the Level that is appropriate for
     this layer.
    :type level: str
    :param buffer_window: The VBV buffer window length. The value should be in
     ISO 8601 format. The value should be in the range [0.1-100] seconds. The
     default is 5 seconds (for example, PT5S).
    :type buffer_window: timedelta
    :param reference_frames: The number of reference frames to be used when
     encoding this layer. If not specified, the encoder determines an
     appropriate number based on the encoder complexity setting.
    :type reference_frames: int
    """

    _validation = {
        'odatatype': {'required': True},
        'bitrate': {'required': True},
    }

    _attribute_map = {
        'width': {'key': 'width', 'type': 'str'},
        'height': {'key': 'height', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'bitrate': {'key': 'bitrate', 'type': 'int'},
        'max_bitrate': {'key': 'maxBitrate', 'type': 'int'},
        'b_frames': {'key': 'bFrames', 'type': 'int'},
        'frame_rate': {'key': 'frameRate', 'type': 'str'},
        'slices': {'key': 'slices', 'type': 'int'},
        'adaptive_bframe': {'key': 'adaptiveBFrame', 'type': 'bool'},
        'profile': {'key': 'profile', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'buffer_window': {'key': 'bufferWindow', 'type': 'duration'},
        'reference_frames': {'key': 'referenceFrames', 'type': 'int'},
    }

    def __init__(self, *, bitrate: int, width: str=None, height: str=None, label: str=None, max_bitrate: int=None, b_frames: int=None, frame_rate: str=None, slices: int=None, adaptive_bframe: bool=None, profile=None, level: str=None, buffer_window=None, reference_frames: int=None, **kwargs) -> None:
        super(H265Layer, self).__init__(width=width, height=height, label=label, bitrate=bitrate, max_bitrate=max_bitrate, b_frames=b_frames, frame_rate=frame_rate, slices=slices, adaptive_bframe=adaptive_bframe, **kwargs)
        self.profile = profile
        self.level = level
        self.buffer_window = buffer_window
        self.reference_frames = reference_frames
        self.odatatype = '#Microsoft.Media.H265Layer'


class H265Video(Video):
    """Describes all the properties for encoding a video with the H.265 codec.

    All required parameters must be populated in order to send to Azure.

    :param label: An optional label for the codec. The label can be used to
     control muxing behavior.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param key_frame_interval: The distance between two key frames. The value
     should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
     format. The default is 2 seconds(PT2S). Note that this setting is ignored
     if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will
     follow the input source setting.
    :type key_frame_interval: timedelta
    :param stretch_mode: The resizing mode - how the input video will be
     resized to fit the desired output resolution(s). Default is AutoSize.
     Possible values include: 'None', 'AutoSize', 'AutoFit'
    :type stretch_mode: str or ~azure.mgmt.media.models.StretchMode
    :param sync_mode: The Video Sync Mode. Possible values include: 'Auto',
     'Passthrough', 'Cfr', 'Vfr'
    :type sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
    :param scene_change_detection: Specifies whether or not the encoder should
     insert key frames at scene changes. If not specified, the default is
     false. This flag should be set to true only when the encoder is being
     configured to produce a single output video.
    :type scene_change_detection: bool
    :param complexity: Tells the encoder how to choose its encoding settings.
     Quality will provide for a higher compression ratio but at a higher cost
     and longer compute time.  Speed will produce a relatively larger file but
     is faster and more economical. The default value is Balanced. Possible
     values include: 'Speed', 'Balanced', 'Quality'
    :type complexity: str or ~azure.mgmt.media.models.H265Complexity
    :param layers: The collection of output H.265 layers to be produced by the
     encoder.
    :type layers: list[~azure.mgmt.media.models.H265Layer]
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'key_frame_interval': {'key': 'keyFrameInterval', 'type': 'duration'},
        'stretch_mode': {'key': 'stretchMode', 'type': 'str'},
        'sync_mode': {'key': 'syncMode', 'type': 'str'},
        'scene_change_detection': {'key': 'sceneChangeDetection', 'type': 'bool'},
        'complexity': {'key': 'complexity', 'type': 'str'},
        'layers': {'key': 'layers', 'type': '[H265Layer]'},
    }

    def __init__(self, *, label: str=None, key_frame_interval=None, stretch_mode=None, sync_mode=None, scene_change_detection: bool=None, complexity=None, layers=None, **kwargs) -> None:
        super(H265Video, self).__init__(label=label, key_frame_interval=key_frame_interval, stretch_mode=stretch_mode, sync_mode=sync_mode, **kwargs)
        self.scene_change_detection = scene_change_detection
        self.complexity = complexity
        self.layers = layers
        self.odatatype = '#Microsoft.Media.H265Video'


class Hls(Model):
    """HTTP Live Streaming (HLS) packing setting for the live output.

    :param fragments_per_ts_segment: The number of fragments in an HTTP Live
     Streaming (HLS) TS segment in the output of the live event. This value
     does not affect the packing ratio for HLS CMAF output.
    :type fragments_per_ts_segment: int
    """

    _attribute_map = {
        'fragments_per_ts_segment': {'key': 'fragmentsPerTsSegment', 'type': 'int'},
    }

    def __init__(self, *, fragments_per_ts_segment: int=None, **kwargs) -> None:
        super(Hls, self).__init__(**kwargs)
        self.fragments_per_ts_segment = fragments_per_ts_segment


class Image(Video):
    """Describes the basic properties for generating thumbnails from the input
    video.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JpgImage, PngImage

    All required parameters must be populated in order to send to Azure.

    :param label: An optional label for the codec. The label can be used to
     control muxing behavior.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param key_frame_interval: The distance between two key frames. The value
     should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
     format. The default is 2 seconds(PT2S). Note that this setting is ignored
     if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will
     follow the input source setting.
    :type key_frame_interval: timedelta
    :param stretch_mode: The resizing mode - how the input video will be
     resized to fit the desired output resolution(s). Default is AutoSize.
     Possible values include: 'None', 'AutoSize', 'AutoFit'
    :type stretch_mode: str or ~azure.mgmt.media.models.StretchMode
    :param sync_mode: The Video Sync Mode. Possible values include: 'Auto',
     'Passthrough', 'Cfr', 'Vfr'
    :type sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
    :param start: Required. The position in the input video from where to
     start generating thumbnails. The value can be in ISO 8601 format (For
     example, PT05S to start at 5 seconds), or a frame count (For example, 10
     to start at the 10th frame), or a relative value to stream duration (For
     example, 10% to start at 10% of stream duration). Also supports a macro
     {Best}, which tells the encoder to select the best thumbnail from the
     first few seconds of the video and will only produce one thumbnail, no
     matter what other settings are for Step and Range. The default value is
     macro {Best}.
    :type start: str
    :param step: The intervals at which thumbnails are generated. The value
     can be in ISO 8601 format (For example, PT05S for one image every 5
     seconds), or a frame count (For example, 30 for one image every 30
     frames), or a relative value to stream duration (For example, 10% for one
     image every 10% of stream duration). Note: Step value will affect the
     first generated thumbnail, which may not be exactly the one specified at
     transform preset start time. This is due to the encoder, which tries to
     select the best thumbnail between start time and Step position from start
     time as the first output. As the default value is 10%, it means if stream
     has long duration, the first generated thumbnail might be far away from
     the one specified at start time. Try to select reasonable value for Step
     if the first thumbnail is expected close to start time, or set Range value
     at 1 if only one thumbnail is needed at start time.
    :type step: str
    :param range: The position relative to transform preset start time in the
     input video at which to stop generating thumbnails. The value can be in
     ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds
     from start time), or a frame count (For example, 300 to stop at the 300th
     frame from the frame at start time. If this value is 1, it means only
     producing one thumbnail at start time), or a relative value to the stream
     duration (For example, 50% to stop at half of stream duration from start
     time). The default value is 100%, which means to stop at the end of the
     stream.
    :type range: str
    """

    _validation = {
        'odatatype': {'required': True},
        'start': {'required': True},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'key_frame_interval': {'key': 'keyFrameInterval', 'type': 'duration'},
        'stretch_mode': {'key': 'stretchMode', 'type': 'str'},
        'sync_mode': {'key': 'syncMode', 'type': 'str'},
        'start': {'key': 'start', 'type': 'str'},
        'step': {'key': 'step', 'type': 'str'},
        'range': {'key': 'range', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.JpgImage': 'JpgImage', '#Microsoft.Media.PngImage': 'PngImage'}
    }

    def __init__(self, *, start: str, label: str=None, key_frame_interval=None, stretch_mode=None, sync_mode=None, step: str=None, range: str=None, **kwargs) -> None:
        super(Image, self).__init__(label=label, key_frame_interval=key_frame_interval, stretch_mode=stretch_mode, sync_mode=sync_mode, **kwargs)
        self.start = start
        self.step = step
        self.range = range
        self.odatatype = '#Microsoft.Media.Image'


class ImageFormat(Format):
    """Describes the properties for an output image file.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JpgFormat, PngFormat

    All required parameters must be populated in order to send to Azure.

    :param filename_pattern: Required. The pattern of the file names for the
     generated output files. The following macros are supported in the file
     name: {Basename} - An expansion macro that will use the name of the input
     video file. If the base name(the file suffix is not included) of the input
     video file is less than 32 characters long, the base name of input video
     files will be used. If the length of base name of the input video file
     exceeds 32 characters, the base name is truncated to the first 32
     characters in total length. {Extension} - The appropriate extension for
     this format. {Label} - The label assigned to the codec/layer. {Index} - A
     unique index for thumbnails. Only applicable to thumbnails. {Bitrate} -
     The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type
     of the audio/video codec. {Resolution} - The video resolution. Any
     unsubstituted macros will be collapsed and removed from the filename.
    :type filename_pattern: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'filename_pattern': {'required': True},
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'filename_pattern': {'key': 'filenamePattern', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.JpgFormat': 'JpgFormat', '#Microsoft.Media.PngFormat': 'PngFormat'}
    }

    def __init__(self, *, filename_pattern: str, **kwargs) -> None:
        super(ImageFormat, self).__init__(filename_pattern=filename_pattern, **kwargs)
        self.odatatype = '#Microsoft.Media.ImageFormat'


class InputFile(InputDefinition):
    """An InputDefinition for a single file.  TrackSelections are scoped to the
    file specified.

    All required parameters must be populated in order to send to Azure.

    :param included_tracks: The list of TrackDescriptors which define the
     metadata and selection of tracks in the input.
    :type included_tracks: list[~azure.mgmt.media.models.TrackDescriptor]
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param filename: Name of the file that this input definition applies to.
    :type filename: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'included_tracks': {'key': 'includedTracks', 'type': '[TrackDescriptor]'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'filename': {'key': 'filename', 'type': 'str'},
    }

    def __init__(self, *, included_tracks=None, filename: str=None, **kwargs) -> None:
        super(InputFile, self).__init__(included_tracks=included_tracks, **kwargs)
        self.filename = filename
        self.odatatype = '#Microsoft.Media.InputFile'


class IPAccessControl(Model):
    """The IP access control.

    :param allow: The IP allow list.
    :type allow: list[~azure.mgmt.media.models.IPRange]
    """

    _attribute_map = {
        'allow': {'key': 'allow', 'type': '[IPRange]'},
    }

    def __init__(self, *, allow=None, **kwargs) -> None:
        super(IPAccessControl, self).__init__(**kwargs)
        self.allow = allow


class IPRange(Model):
    """The IP address range in the CIDR scheme.

    :param name: The friendly name for the IP address range.
    :type name: str
    :param address: The IP address.
    :type address: str
    :param subnet_prefix_length: The subnet mask prefix length (see CIDR
     notation).
    :type subnet_prefix_length: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'address': {'key': 'address', 'type': 'str'},
        'subnet_prefix_length': {'key': 'subnetPrefixLength', 'type': 'int'},
    }

    def __init__(self, *, name: str=None, address: str=None, subnet_prefix_length: int=None, **kwargs) -> None:
        super(IPRange, self).__init__(**kwargs)
        self.name = name
        self.address = address
        self.subnet_prefix_length = subnet_prefix_length


class Job(ProxyResource):
    """A Job resource type. The progress and state can be obtained by polling a
    Job or subscribing to events using EventGrid.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :ivar created: The UTC date and time when the customer has created the
     Job, in 'YYYY-MM-DDThh:mm:ssZ' format.
    :vartype created: datetime
    :ivar state: The current state of the job. Possible values include:
     'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued',
     'Scheduled'
    :vartype state: str or ~azure.mgmt.media.models.JobState
    :param description: Optional customer supplied description of the Job.
    :type description: str
    :param input: Required. The inputs for the Job.
    :type input: ~azure.mgmt.media.models.JobInput
    :ivar last_modified: The UTC date and time when the customer has last
     updated the Job, in 'YYYY-MM-DDThh:mm:ssZ' format.
    :vartype last_modified: datetime
    :param outputs: Required. The outputs for the Job.
    :type outputs: list[~azure.mgmt.media.models.JobOutput]
    :param priority: Priority with which the job should be processed. Higher
     priority jobs are processed before lower priority jobs. If not set, the
     default is normal. Possible values include: 'Low', 'Normal', 'High'
    :type priority: str or ~azure.mgmt.media.models.Priority
    :param correlation_data: Customer provided key, value pairs that will be
     returned in Job and JobOutput state events.
    :type correlation_data: dict[str, str]
    :ivar start_time: The UTC date and time at which this Job began
     processing.
    :vartype start_time: datetime
    :ivar end_time: The UTC date and time at which this Job finished
     processing.
    :vartype end_time: datetime
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created': {'readonly': True},
        'state': {'readonly': True},
        'input': {'required': True},
        'last_modified': {'readonly': True},
        'outputs': {'required': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'input': {'key': 'properties.input', 'type': 'JobInput'},
        'last_modified': {'key': 'properties.lastModified', 'type': 'iso-8601'},
        'outputs': {'key': 'properties.outputs', 'type': '[JobOutput]'},
        'priority': {'key': 'properties.priority', 'type': 'str'},
        'correlation_data': {'key': 'properties.correlationData', 'type': '{str}'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, input, outputs, description: str=None, priority=None, correlation_data=None, **kwargs) -> None:
        super(Job, self).__init__(**kwargs)
        self.created = None
        self.state = None
        self.description = description
        self.input = input
        self.last_modified = None
        self.outputs = outputs
        self.priority = priority
        self.correlation_data = correlation_data
        self.start_time = None
        self.end_time = None
        self.system_data = None


class JobError(Model):
    """Details of JobOutput errors.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Error code describing the error. Possible values include:
     'ServiceError', 'ServiceTransientError', 'DownloadNotAccessible',
     'DownloadTransientError', 'UploadNotAccessible', 'UploadTransientError',
     'ConfigurationUnsupported', 'ContentMalformed', 'ContentUnsupported'
    :vartype code: str or ~azure.mgmt.media.models.JobErrorCode
    :ivar message: A human-readable language-dependent representation of the
     error.
    :vartype message: str
    :ivar category: Helps with categorization of errors. Possible values
     include: 'Service', 'Download', 'Upload', 'Configuration', 'Content'
    :vartype category: str or ~azure.mgmt.media.models.JobErrorCategory
    :ivar retry: Indicates that it may be possible to retry the Job. If retry
     is unsuccessful, please contact Azure support via Azure Portal. Possible
     values include: 'DoNotRetry', 'MayRetry'
    :vartype retry: str or ~azure.mgmt.media.models.JobRetry
    :ivar details: An array of details about specific errors that led to this
     reported error.
    :vartype details: list[~azure.mgmt.media.models.JobErrorDetail]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'category': {'readonly': True},
        'retry': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'retry': {'key': 'retry', 'type': 'str'},
        'details': {'key': 'details', 'type': '[JobErrorDetail]'},
    }

    def __init__(self, **kwargs) -> None:
        super(JobError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.category = None
        self.retry = None
        self.details = None


class JobErrorDetail(Model):
    """Details of JobOutput errors.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Code describing the error detail.
    :vartype code: str
    :ivar message: A human-readable representation of the error.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(JobErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None


class JobInput(Model):
    """Base class for inputs to a Job.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JobInputClip, JobInputs, JobInputSequence

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.JobInputClip': 'JobInputClip', '#Microsoft.Media.JobInputs': 'JobInputs', '#Microsoft.Media.JobInputSequence': 'JobInputSequence'}
    }

    def __init__(self, **kwargs) -> None:
        super(JobInput, self).__init__(**kwargs)
        self.odatatype = None


class JobInputClip(JobInput):
    """Represents input files for a Job.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JobInputAsset, JobInputHttp

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param files: List of files. Required for JobInputHttp. Maximum of 4000
     characters each.
    :type files: list[str]
    :param start: Defines a point on the timeline of the input media at which
     processing will start. Defaults to the beginning of the input media.
    :type start: ~azure.mgmt.media.models.ClipTime
    :param end: Defines a point on the timeline of the input media at which
     processing will end. Defaults to the end of the input media.
    :type end: ~azure.mgmt.media.models.ClipTime
    :param label: A label that is assigned to a JobInputClip, that is used to
     satisfy a reference used in the Transform. For example, a Transform can be
     authored so as to take an image file with the label 'xyz' and apply it as
     an overlay onto the input video before it is encoded. When submitting a
     Job, exactly one of the JobInputs should be the image file, and it should
     have the label 'xyz'.
    :type label: str
    :param input_definitions: Defines a list of InputDefinitions. For each
     InputDefinition, it defines a list of track selections and related
     metadata.
    :type input_definitions: list[~azure.mgmt.media.models.InputDefinition]
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'files': {'key': 'files', 'type': '[str]'},
        'start': {'key': 'start', 'type': 'ClipTime'},
        'end': {'key': 'end', 'type': 'ClipTime'},
        'label': {'key': 'label', 'type': 'str'},
        'input_definitions': {'key': 'inputDefinitions', 'type': '[InputDefinition]'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.JobInputAsset': 'JobInputAsset', '#Microsoft.Media.JobInputHttp': 'JobInputHttp'}
    }

    def __init__(self, *, files=None, start=None, end=None, label: str=None, input_definitions=None, **kwargs) -> None:
        super(JobInputClip, self).__init__(**kwargs)
        self.files = files
        self.start = start
        self.end = end
        self.label = label
        self.input_definitions = input_definitions
        self.odatatype = '#Microsoft.Media.JobInputClip'


class JobInputAsset(JobInputClip):
    """Represents an Asset for input into a Job.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param files: List of files. Required for JobInputHttp. Maximum of 4000
     characters each.
    :type files: list[str]
    :param start: Defines a point on the timeline of the input media at which
     processing will start. Defaults to the beginning of the input media.
    :type start: ~azure.mgmt.media.models.ClipTime
    :param end: Defines a point on the timeline of the input media at which
     processing will end. Defaults to the end of the input media.
    :type end: ~azure.mgmt.media.models.ClipTime
    :param label: A label that is assigned to a JobInputClip, that is used to
     satisfy a reference used in the Transform. For example, a Transform can be
     authored so as to take an image file with the label 'xyz' and apply it as
     an overlay onto the input video before it is encoded. When submitting a
     Job, exactly one of the JobInputs should be the image file, and it should
     have the label 'xyz'.
    :type label: str
    :param input_definitions: Defines a list of InputDefinitions. For each
     InputDefinition, it defines a list of track selections and related
     metadata.
    :type input_definitions: list[~azure.mgmt.media.models.InputDefinition]
    :param asset_name: Required. The name of the input Asset.
    :type asset_name: str
    """

    _validation = {
        'odatatype': {'required': True},
        'asset_name': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'files': {'key': 'files', 'type': '[str]'},
        'start': {'key': 'start', 'type': 'ClipTime'},
        'end': {'key': 'end', 'type': 'ClipTime'},
        'label': {'key': 'label', 'type': 'str'},
        'input_definitions': {'key': 'inputDefinitions', 'type': '[InputDefinition]'},
        'asset_name': {'key': 'assetName', 'type': 'str'},
    }

    def __init__(self, *, asset_name: str, files=None, start=None, end=None, label: str=None, input_definitions=None, **kwargs) -> None:
        super(JobInputAsset, self).__init__(files=files, start=start, end=end, label=label, input_definitions=input_definitions, **kwargs)
        self.asset_name = asset_name
        self.odatatype = '#Microsoft.Media.JobInputAsset'


class JobInputHttp(JobInputClip):
    """Represents HTTPS job input.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param files: List of files. Required for JobInputHttp. Maximum of 4000
     characters each.
    :type files: list[str]
    :param start: Defines a point on the timeline of the input media at which
     processing will start. Defaults to the beginning of the input media.
    :type start: ~azure.mgmt.media.models.ClipTime
    :param end: Defines a point on the timeline of the input media at which
     processing will end. Defaults to the end of the input media.
    :type end: ~azure.mgmt.media.models.ClipTime
    :param label: A label that is assigned to a JobInputClip, that is used to
     satisfy a reference used in the Transform. For example, a Transform can be
     authored so as to take an image file with the label 'xyz' and apply it as
     an overlay onto the input video before it is encoded. When submitting a
     Job, exactly one of the JobInputs should be the image file, and it should
     have the label 'xyz'.
    :type label: str
    :param input_definitions: Defines a list of InputDefinitions. For each
     InputDefinition, it defines a list of track selections and related
     metadata.
    :type input_definitions: list[~azure.mgmt.media.models.InputDefinition]
    :param base_uri: Base URI for HTTPS job input. It will be concatenated
     with provided file names. If no base uri is given, then the provided file
     list is assumed to be fully qualified uris. Maximum length of 4000
     characters.
    :type base_uri: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'files': {'key': 'files', 'type': '[str]'},
        'start': {'key': 'start', 'type': 'ClipTime'},
        'end': {'key': 'end', 'type': 'ClipTime'},
        'label': {'key': 'label', 'type': 'str'},
        'input_definitions': {'key': 'inputDefinitions', 'type': '[InputDefinition]'},
        'base_uri': {'key': 'baseUri', 'type': 'str'},
    }

    def __init__(self, *, files=None, start=None, end=None, label: str=None, input_definitions=None, base_uri: str=None, **kwargs) -> None:
        super(JobInputHttp, self).__init__(files=files, start=start, end=end, label=label, input_definitions=input_definitions, **kwargs)
        self.base_uri = base_uri
        self.odatatype = '#Microsoft.Media.JobInputHttp'


class JobInputs(JobInput):
    """Describes a list of inputs to a Job.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param inputs: List of inputs to a Job.
    :type inputs: list[~azure.mgmt.media.models.JobInput]
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[JobInput]'},
    }

    def __init__(self, *, inputs=None, **kwargs) -> None:
        super(JobInputs, self).__init__(**kwargs)
        self.inputs = inputs
        self.odatatype = '#Microsoft.Media.JobInputs'


class JobInputSequence(JobInput):
    """A Sequence contains an ordered list of Clips where each clip is a JobInput.
    The Sequence will be treated as a single input.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param inputs: JobInputs that make up the timeline.
    :type inputs: list[~azure.mgmt.media.models.JobInputClip]
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[JobInputClip]'},
    }

    def __init__(self, *, inputs=None, **kwargs) -> None:
        super(JobInputSequence, self).__init__(**kwargs)
        self.inputs = inputs
        self.odatatype = '#Microsoft.Media.JobInputSequence'


class JobOutput(Model):
    """Describes all the properties of a JobOutput.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JobOutputAsset

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar error: If the JobOutput is in the Error state, it contains the
     details of the error.
    :vartype error: ~azure.mgmt.media.models.JobError
    :ivar state: Describes the state of the JobOutput. Possible values
     include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing',
     'Queued', 'Scheduled'
    :vartype state: str or ~azure.mgmt.media.models.JobState
    :ivar progress: If the JobOutput is in a Processing state, this contains
     the Job completion percentage. The value is an estimate and not intended
     to be used to predict Job completion times. To determine if the JobOutput
     is complete, use the State property.
    :vartype progress: int
    :param label: A label that is assigned to a JobOutput in order to help
     uniquely identify it. This is useful when your Transform has more than one
     TransformOutput, whereby your Job has more than one JobOutput. In such
     cases, when you submit the Job, you will add two or more JobOutputs, in
     the same order as TransformOutputs in the Transform. Subsequently, when
     you retrieve the Job, either through events or on a GET request, you can
     use the label to easily identify the JobOutput. If a label is not
     provided, a default value of '{presetName}_{outputIndex}' will be used,
     where the preset name is the name of the preset in the corresponding
     TransformOutput and the output index is the relative index of the this
     JobOutput within the Job. Note that this index is the same as the relative
     index of the corresponding TransformOutput within its Transform.
    :type label: str
    :ivar start_time: The UTC date and time at which this Job Output began
     processing.
    :vartype start_time: datetime
    :ivar end_time: The UTC date and time at which this Job Output finished
     processing.
    :vartype end_time: datetime
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'error': {'readonly': True},
        'state': {'readonly': True},
        'progress': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'JobError'},
        'state': {'key': 'state', 'type': 'str'},
        'progress': {'key': 'progress', 'type': 'int'},
        'label': {'key': 'label', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.JobOutputAsset': 'JobOutputAsset'}
    }

    def __init__(self, *, label: str=None, **kwargs) -> None:
        super(JobOutput, self).__init__(**kwargs)
        self.error = None
        self.state = None
        self.progress = None
        self.label = label
        self.start_time = None
        self.end_time = None
        self.odatatype = None


class JobOutputAsset(JobOutput):
    """Represents an Asset used as a JobOutput.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar error: If the JobOutput is in the Error state, it contains the
     details of the error.
    :vartype error: ~azure.mgmt.media.models.JobError
    :ivar state: Describes the state of the JobOutput. Possible values
     include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing',
     'Queued', 'Scheduled'
    :vartype state: str or ~azure.mgmt.media.models.JobState
    :ivar progress: If the JobOutput is in a Processing state, this contains
     the Job completion percentage. The value is an estimate and not intended
     to be used to predict Job completion times. To determine if the JobOutput
     is complete, use the State property.
    :vartype progress: int
    :param label: A label that is assigned to a JobOutput in order to help
     uniquely identify it. This is useful when your Transform has more than one
     TransformOutput, whereby your Job has more than one JobOutput. In such
     cases, when you submit the Job, you will add two or more JobOutputs, in
     the same order as TransformOutputs in the Transform. Subsequently, when
     you retrieve the Job, either through events or on a GET request, you can
     use the label to easily identify the JobOutput. If a label is not
     provided, a default value of '{presetName}_{outputIndex}' will be used,
     where the preset name is the name of the preset in the corresponding
     TransformOutput and the output index is the relative index of the this
     JobOutput within the Job. Note that this index is the same as the relative
     index of the corresponding TransformOutput within its Transform.
    :type label: str
    :ivar start_time: The UTC date and time at which this Job Output began
     processing.
    :vartype start_time: datetime
    :ivar end_time: The UTC date and time at which this Job Output finished
     processing.
    :vartype end_time: datetime
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param asset_name: Required. The name of the output Asset.
    :type asset_name: str
    """

    _validation = {
        'error': {'readonly': True},
        'state': {'readonly': True},
        'progress': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'odatatype': {'required': True},
        'asset_name': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'JobError'},
        'state': {'key': 'state', 'type': 'str'},
        'progress': {'key': 'progress', 'type': 'int'},
        'label': {'key': 'label', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'asset_name': {'key': 'assetName', 'type': 'str'},
    }

    def __init__(self, *, asset_name: str, label: str=None, **kwargs) -> None:
        super(JobOutputAsset, self).__init__(label=label, **kwargs)
        self.asset_name = asset_name
        self.odatatype = '#Microsoft.Media.JobOutputAsset'


class JpgFormat(ImageFormat):
    """Describes the settings for producing JPEG thumbnails.

    All required parameters must be populated in order to send to Azure.

    :param filename_pattern: Required. The pattern of the file names for the
     generated output files. The following macros are supported in the file
     name: {Basename} - An expansion macro that will use the name of the input
     video file. If the base name(the file suffix is not included) of the input
     video file is less than 32 characters long, the base name of input video
     files will be used. If the length of base name of the input video file
     exceeds 32 characters, the base name is truncated to the first 32
     characters in total length. {Extension} - The appropriate extension for
     this format. {Label} - The label assigned to the codec/layer. {Index} - A
     unique index for thumbnails. Only applicable to thumbnails. {Bitrate} -
     The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type
     of the audio/video codec. {Resolution} - The video resolution. Any
     unsubstituted macros will be collapsed and removed from the filename.
    :type filename_pattern: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'filename_pattern': {'required': True},
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'filename_pattern': {'key': 'filenamePattern', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(self, *, filename_pattern: str, **kwargs) -> None:
        super(JpgFormat, self).__init__(filename_pattern=filename_pattern, **kwargs)
        self.odatatype = '#Microsoft.Media.JpgFormat'


class JpgImage(Image):
    """Describes the properties for producing a series of JPEG images from the
    input video.

    All required parameters must be populated in order to send to Azure.

    :param label: An optional label for the codec. The label can be used to
     control muxing behavior.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param key_frame_interval: The distance between two key frames. The value
     should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
     format. The default is 2 seconds(PT2S). Note that this setting is ignored
     if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will
     follow the input source setting.
    :type key_frame_interval: timedelta
    :param stretch_mode: The resizing mode - how the input video will be
     resized to fit the desired output resolution(s). Default is AutoSize.
     Possible values include: 'None', 'AutoSize', 'AutoFit'
    :type stretch_mode: str or ~azure.mgmt.media.models.StretchMode
    :param sync_mode: The Video Sync Mode. Possible values include: 'Auto',
     'Passthrough', 'Cfr', 'Vfr'
    :type sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
    :param start: Required. The position in the input video from where to
     start generating thumbnails. The value can be in ISO 8601 format (For
     example, PT05S to start at 5 seconds), or a frame count (For example, 10
     to start at the 10th frame), or a relative value to stream duration (For
     example, 10% to start at 10% of stream duration). Also supports a macro
     {Best}, which tells the encoder to select the best thumbnail from the
     first few seconds of the video and will only produce one thumbnail, no
     matter what other settings are for Step and Range. The default value is
     macro {Best}.
    :type start: str
    :param step: The intervals at which thumbnails are generated. The value
     can be in ISO 8601 format (For example, PT05S for one image every 5
     seconds), or a frame count (For example, 30 for one image every 30
     frames), or a relative value to stream duration (For example, 10% for one
     image every 10% of stream duration). Note: Step value will affect the
     first generated thumbnail, which may not be exactly the one specified at
     transform preset start time. This is due to the encoder, which tries to
     select the best thumbnail between start time and Step position from start
     time as the first output. As the default value is 10%, it means if stream
     has long duration, the first generated thumbnail might be far away from
     the one specified at start time. Try to select reasonable value for Step
     if the first thumbnail is expected close to start time, or set Range value
     at 1 if only one thumbnail is needed at start time.
    :type step: str
    :param range: The position relative to transform preset start time in the
     input video at which to stop generating thumbnails. The value can be in
     ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds
     from start time), or a frame count (For example, 300 to stop at the 300th
     frame from the frame at start time. If this value is 1, it means only
     producing one thumbnail at start time), or a relative value to the stream
     duration (For example, 50% to stop at half of stream duration from start
     time). The default value is 100%, which means to stop at the end of the
     stream.
    :type range: str
    :param layers: A collection of output JPEG image layers to be produced by
     the encoder.
    :type layers: list[~azure.mgmt.media.models.JpgLayer]
    :param sprite_column: Sets the number of columns used in thumbnail sprite
     image.  The number of rows are automatically calculated and a VTT file is
     generated with the coordinate mappings for each thumbnail in the sprite.
     Note: this value should be a positive integer and a proper value is
     recommended so that the output image resolution will not go beyond JPEG
     maximum pixel resolution limit 65535x65535.
    :type sprite_column: int
    """

    _validation = {
        'odatatype': {'required': True},
        'start': {'required': True},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'key_frame_interval': {'key': 'keyFrameInterval', 'type': 'duration'},
        'stretch_mode': {'key': 'stretchMode', 'type': 'str'},
        'sync_mode': {'key': 'syncMode', 'type': 'str'},
        'start': {'key': 'start', 'type': 'str'},
        'step': {'key': 'step', 'type': 'str'},
        'range': {'key': 'range', 'type': 'str'},
        'layers': {'key': 'layers', 'type': '[JpgLayer]'},
        'sprite_column': {'key': 'spriteColumn', 'type': 'int'},
    }

    def __init__(self, *, start: str, label: str=None, key_frame_interval=None, stretch_mode=None, sync_mode=None, step: str=None, range: str=None, layers=None, sprite_column: int=None, **kwargs) -> None:
        super(JpgImage, self).__init__(label=label, key_frame_interval=key_frame_interval, stretch_mode=stretch_mode, sync_mode=sync_mode, start=start, step=step, range=range, **kwargs)
        self.layers = layers
        self.sprite_column = sprite_column
        self.odatatype = '#Microsoft.Media.JpgImage'


class JpgLayer(Layer):
    """Describes the settings to produce a JPEG image from the input video.

    All required parameters must be populated in order to send to Azure.

    :param width: The width of the output video for this layer. The value can
     be absolute (in pixels) or relative (in percentage). For example 50% means
     the output video has half as many pixels in width as the input.
    :type width: str
    :param height: The height of the output video for this layer. The value
     can be absolute (in pixels) or relative (in percentage). For example 50%
     means the output video has half as many pixels in height as the input.
    :type height: str
    :param label: The alphanumeric label for this layer, which can be used in
     multiplexing different video and audio layers, or in naming the output
     file.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param quality: The compression quality of the JPEG output. Range is from
     0-100 and the default is 70.
    :type quality: int
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'width': {'key': 'width', 'type': 'str'},
        'height': {'key': 'height', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'quality': {'key': 'quality', 'type': 'int'},
    }

    def __init__(self, *, width: str=None, height: str=None, label: str=None, quality: int=None, **kwargs) -> None:
        super(JpgLayer, self).__init__(width=width, height=height, label=label, **kwargs)
        self.quality = quality
        self.odatatype = '#Microsoft.Media.JpgLayer'


class KeyVaultProperties(Model):
    """KeyVaultProperties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param key_identifier: The URL of the Key Vault key used to encrypt the
     account. The key may either be versioned (for example
     https://vault/keys/mykey/version1) or reference a key without a version
     (for example https://vault/keys/mykey).
    :type key_identifier: str
    :ivar current_key_identifier: The current key used to encrypt the Media
     Services account, including the key version.
    :vartype current_key_identifier: str
    """

    _validation = {
        'current_key_identifier': {'readonly': True},
    }

    _attribute_map = {
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
        'current_key_identifier': {'key': 'currentKeyIdentifier', 'type': 'str'},
    }

    def __init__(self, *, key_identifier: str=None, **kwargs) -> None:
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_identifier = key_identifier
        self.current_key_identifier = None


class ListContainerSasInput(Model):
    """The parameters to the list SAS request.

    :param permissions: The permissions to set on the SAS URL. Possible values
     include: 'Read', 'ReadWrite', 'ReadWriteDelete'
    :type permissions: str or
     ~azure.mgmt.media.models.AssetContainerPermission
    :param expiry_time: The SAS URL expiration time.  This must be less than
     24 hours from the current time.
    :type expiry_time: datetime
    """

    _attribute_map = {
        'permissions': {'key': 'permissions', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
    }

    def __init__(self, *, permissions=None, expiry_time=None, **kwargs) -> None:
        super(ListContainerSasInput, self).__init__(**kwargs)
        self.permissions = permissions
        self.expiry_time = expiry_time


class ListContentKeysResponse(Model):
    """Class of response for listContentKeys action.

    :param content_keys: ContentKeys used by current Streaming Locator
    :type content_keys:
     list[~azure.mgmt.media.models.StreamingLocatorContentKey]
    """

    _attribute_map = {
        'content_keys': {'key': 'contentKeys', 'type': '[StreamingLocatorContentKey]'},
    }

    def __init__(self, *, content_keys=None, **kwargs) -> None:
        super(ListContentKeysResponse, self).__init__(**kwargs)
        self.content_keys = content_keys


class ListEdgePoliciesInput(Model):
    """ListEdgePoliciesInput.

    :param device_id: Unique identifier of the edge device.
    :type device_id: str
    """

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
    }

    def __init__(self, *, device_id: str=None, **kwargs) -> None:
        super(ListEdgePoliciesInput, self).__init__(**kwargs)
        self.device_id = device_id


class ListPathsResponse(Model):
    """Class of response for listPaths action.

    :param streaming_paths: Streaming Paths supported by current Streaming
     Locator
    :type streaming_paths: list[~azure.mgmt.media.models.StreamingPath]
    :param download_paths: Download Paths supported by current Streaming
     Locator
    :type download_paths: list[str]
    """

    _attribute_map = {
        'streaming_paths': {'key': 'streamingPaths', 'type': '[StreamingPath]'},
        'download_paths': {'key': 'downloadPaths', 'type': '[str]'},
    }

    def __init__(self, *, streaming_paths=None, download_paths=None, **kwargs) -> None:
        super(ListPathsResponse, self).__init__(**kwargs)
        self.streaming_paths = streaming_paths
        self.download_paths = download_paths


class ListStreamingLocatorsResponse(Model):
    """The Streaming Locators associated with this Asset.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar streaming_locators: The list of Streaming Locators.
    :vartype streaming_locators:
     list[~azure.mgmt.media.models.AssetStreamingLocator]
    """

    _validation = {
        'streaming_locators': {'readonly': True},
    }

    _attribute_map = {
        'streaming_locators': {'key': 'streamingLocators', 'type': '[AssetStreamingLocator]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ListStreamingLocatorsResponse, self).__init__(**kwargs)
        self.streaming_locators = None


class TrackedResource(Resource):
    """Tracked Resource.

    The resource model definition for an Azure Resource Manager tracked top
    level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class LiveEvent(TrackedResource):
    """The live event.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param description: A description for the live event.
    :type description: str
    :param input: Required. Live event input settings. It defines how the live
     event receives input from a contribution encoder.
    :type input: ~azure.mgmt.media.models.LiveEventInput
    :param preview: Live event preview settings. Preview allows live event
     producers to preview the live streaming content without creating any live
     output.
    :type preview: ~azure.mgmt.media.models.LiveEventPreview
    :param encoding: Encoding settings for the live event. It configures
     whether a live encoder is used for the live event and settings for the
     live encoder if it is used.
    :type encoding: ~azure.mgmt.media.models.LiveEventEncoding
    :param transcriptions: Live transcription settings for the live event. See
     https://go.microsoft.com/fwlink/?linkid=2133742 for more information about
     the live transcription feature.
    :type transcriptions:
     list[~azure.mgmt.media.models.LiveEventTranscription]
    :ivar provisioning_state: The provisioning state of the live event.
    :vartype provisioning_state: str
    :ivar resource_state: The resource state of the live event. See
     https://go.microsoft.com/fwlink/?linkid=2139012 for more information.
     Possible values include: 'Stopped', 'Allocating', 'StandBy', 'Starting',
     'Running', 'Stopping', 'Deleting'
    :vartype resource_state: str or
     ~azure.mgmt.media.models.LiveEventResourceState
    :param cross_site_access_policies: Live event cross site access policies.
    :type cross_site_access_policies:
     ~azure.mgmt.media.models.CrossSiteAccessPolicies
    :param use_static_hostname: Specifies whether a static hostname would be
     assigned to the live event preview and ingest endpoints. This value can
     only be updated if the live event is in Standby state
    :type use_static_hostname: bool
    :param hostname_prefix: When useStaticHostname is set to true, the
     hostnamePrefix specifies the first part of the hostname assigned to the
     live event preview and ingest endpoints. The final hostname would be a
     combination of this prefix, the media service account name and a short
     code for the Azure Media Services data center.
    :type hostname_prefix: str
    :param stream_options: The options to use for the LiveEvent. This value is
     specified at creation time and cannot be updated. The valid values for the
     array entry values are 'Default' and 'LowLatency'.
    :type stream_options: list[str or
     ~azure.mgmt.media.models.StreamOptionsFlag]
    :ivar created: The creation time for the live event
    :vartype created: datetime
    :ivar last_modified: The last modified time of the live event.
    :vartype last_modified: datetime
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'input': {'required': True},
        'provisioning_state': {'readonly': True},
        'resource_state': {'readonly': True},
        'created': {'readonly': True},
        'last_modified': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'input': {'key': 'properties.input', 'type': 'LiveEventInput'},
        'preview': {'key': 'properties.preview', 'type': 'LiveEventPreview'},
        'encoding': {'key': 'properties.encoding', 'type': 'LiveEventEncoding'},
        'transcriptions': {'key': 'properties.transcriptions', 'type': '[LiveEventTranscription]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'cross_site_access_policies': {'key': 'properties.crossSiteAccessPolicies', 'type': 'CrossSiteAccessPolicies'},
        'use_static_hostname': {'key': 'properties.useStaticHostname', 'type': 'bool'},
        'hostname_prefix': {'key': 'properties.hostnamePrefix', 'type': 'str'},
        'stream_options': {'key': 'properties.streamOptions', 'type': '[str]'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'last_modified': {'key': 'properties.lastModified', 'type': 'iso-8601'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, location: str, input, tags=None, description: str=None, preview=None, encoding=None, transcriptions=None, cross_site_access_policies=None, use_static_hostname: bool=None, hostname_prefix: str=None, stream_options=None, **kwargs) -> None:
        super(LiveEvent, self).__init__(tags=tags, location=location, **kwargs)
        self.description = description
        self.input = input
        self.preview = preview
        self.encoding = encoding
        self.transcriptions = transcriptions
        self.provisioning_state = None
        self.resource_state = None
        self.cross_site_access_policies = cross_site_access_policies
        self.use_static_hostname = use_static_hostname
        self.hostname_prefix = hostname_prefix
        self.stream_options = stream_options
        self.created = None
        self.last_modified = None
        self.system_data = None


class LiveEventActionInput(Model):
    """The LiveEvent action input parameter definition.

    :param remove_outputs_on_stop: The flag indicates whether live outputs are
     automatically deleted when live event is being stopped. Deleting live
     outputs do not delete the underlying assets.
    :type remove_outputs_on_stop: bool
    """

    _attribute_map = {
        'remove_outputs_on_stop': {'key': 'removeOutputsOnStop', 'type': 'bool'},
    }

    def __init__(self, *, remove_outputs_on_stop: bool=None, **kwargs) -> None:
        super(LiveEventActionInput, self).__init__(**kwargs)
        self.remove_outputs_on_stop = remove_outputs_on_stop


class LiveEventEncoding(Model):
    """Specifies the live event type and optional encoding settings for encoding
    live events.

    :param encoding_type: Live event type. When encodingType is set to None,
     the service simply passes through the incoming video and audio layer(s) to
     the output. When encodingType is set to Standard or Premium1080p, a live
     encoder transcodes the incoming stream into multiple bitrates or layers.
     See https://go.microsoft.com/fwlink/?linkid=2095101 for more information.
     This property cannot be modified after the live event is created. Possible
     values include: 'None', 'Standard', 'Premium1080p'
    :type encoding_type: str or ~azure.mgmt.media.models.LiveEventEncodingType
    :param preset_name: The optional encoding preset name, used when
     encodingType is not None. This value is specified at creation time and
     cannot be updated. If the encodingType is set to Standard, then the
     default preset name is ‘Default720p’. Else if the encodingType is set to
     Premium1080p, the default preset is ‘Default1080p’.
    :type preset_name: str
    :param stretch_mode: Specifies how the input video will be resized to fit
     the desired output resolution(s). Default is None. Possible values
     include: 'None', 'AutoSize', 'AutoFit'
    :type stretch_mode: str or ~azure.mgmt.media.models.StretchMode
    :param key_frame_interval: Use an ISO 8601 time value between 0.5 to 20
     seconds to specify the output fragment length for the video and audio
     tracks of an encoding live event. For example, use PT2S to indicate 2
     seconds. For the video track it also defines the key frame interval, or
     the length of a GoP (group of pictures).   If this value is not set for an
     encoding live event, the fragment duration defaults to 2 seconds. The
     value cannot be set for pass-through live events.
    :type key_frame_interval: timedelta
    """

    _attribute_map = {
        'encoding_type': {'key': 'encodingType', 'type': 'str'},
        'preset_name': {'key': 'presetName', 'type': 'str'},
        'stretch_mode': {'key': 'stretchMode', 'type': 'str'},
        'key_frame_interval': {'key': 'keyFrameInterval', 'type': 'duration'},
    }

    def __init__(self, *, encoding_type=None, preset_name: str=None, stretch_mode=None, key_frame_interval=None, **kwargs) -> None:
        super(LiveEventEncoding, self).__init__(**kwargs)
        self.encoding_type = encoding_type
        self.preset_name = preset_name
        self.stretch_mode = stretch_mode
        self.key_frame_interval = key_frame_interval


class LiveEventEndpoint(Model):
    """The live event endpoint.

    :param protocol: The endpoint protocol.
    :type protocol: str
    :param url: The endpoint URL.
    :type url: str
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(self, *, protocol: str=None, url: str=None, **kwargs) -> None:
        super(LiveEventEndpoint, self).__init__(**kwargs)
        self.protocol = protocol
        self.url = url


class LiveEventInput(Model):
    """The live event input.

    All required parameters must be populated in order to send to Azure.

    :param streaming_protocol: Required. The input protocol for the live
     event. This is specified at creation time and cannot be updated. Possible
     values include: 'FragmentedMP4', 'RTMP'
    :type streaming_protocol: str or
     ~azure.mgmt.media.models.LiveEventInputProtocol
    :param access_control: Access control for live event input.
    :type access_control: ~azure.mgmt.media.models.LiveEventInputAccessControl
    :param key_frame_interval_duration: ISO 8601 time duration of the key
     frame interval duration of the input. This value sets the
     EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to
     indicate 2 seconds. Leave the value empty for encoding live events.
    :type key_frame_interval_duration: str
    :param access_token: A UUID in string form to uniquely identify the
     stream. This can be specified at creation time but cannot be updated. If
     omitted, the service will generate a unique value.
    :type access_token: str
    :param endpoints: The input endpoints for the live event.
    :type endpoints: list[~azure.mgmt.media.models.LiveEventEndpoint]
    """

    _validation = {
        'streaming_protocol': {'required': True},
    }

    _attribute_map = {
        'streaming_protocol': {'key': 'streamingProtocol', 'type': 'str'},
        'access_control': {'key': 'accessControl', 'type': 'LiveEventInputAccessControl'},
        'key_frame_interval_duration': {'key': 'keyFrameIntervalDuration', 'type': 'str'},
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[LiveEventEndpoint]'},
    }

    def __init__(self, *, streaming_protocol, access_control=None, key_frame_interval_duration: str=None, access_token: str=None, endpoints=None, **kwargs) -> None:
        super(LiveEventInput, self).__init__(**kwargs)
        self.streaming_protocol = streaming_protocol
        self.access_control = access_control
        self.key_frame_interval_duration = key_frame_interval_duration
        self.access_token = access_token
        self.endpoints = endpoints


class LiveEventInputAccessControl(Model):
    """The IP access control for live event input.

    :param ip: The IP access control properties.
    :type ip: ~azure.mgmt.media.models.IPAccessControl
    """

    _attribute_map = {
        'ip': {'key': 'ip', 'type': 'IPAccessControl'},
    }

    def __init__(self, *, ip=None, **kwargs) -> None:
        super(LiveEventInputAccessControl, self).__init__(**kwargs)
        self.ip = ip


class LiveEventInputTrackSelection(Model):
    """A track selection condition. This property is reserved for future use, any
    value set on this property will be ignored.

    :param property: Property name to select. This property is reserved for
     future use, any value set on this property will be ignored.
    :type property: str
    :param operation: Comparing operation. This property is reserved for
     future use, any value set on this property will be ignored.
    :type operation: str
    :param value: Property value to select. This property is reserved for
     future use, any value set on this property will be ignored.
    :type value: str
    """

    _attribute_map = {
        'property': {'key': 'property', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, property: str=None, operation: str=None, value: str=None, **kwargs) -> None:
        super(LiveEventInputTrackSelection, self).__init__(**kwargs)
        self.property = property
        self.operation = operation
        self.value = value


class LiveEventOutputTranscriptionTrack(Model):
    """Describes a transcription track in the output of a live event, generated
    using speech-to-text transcription. This property is reserved for future
    use, any value set on this property will be ignored.

    All required parameters must be populated in order to send to Azure.

    :param track_name: Required. The output track name. This property is
     reserved for future use, any value set on this property will be ignored.
    :type track_name: str
    """

    _validation = {
        'track_name': {'required': True},
    }

    _attribute_map = {
        'track_name': {'key': 'trackName', 'type': 'str'},
    }

    def __init__(self, *, track_name: str, **kwargs) -> None:
        super(LiveEventOutputTranscriptionTrack, self).__init__(**kwargs)
        self.track_name = track_name


class LiveEventPreview(Model):
    """Live event preview settings.

    :param endpoints: The endpoints for preview. Do not share the preview URL
     with the live event audience.
    :type endpoints: list[~azure.mgmt.media.models.LiveEventEndpoint]
    :param access_control: The access control for live event preview.
    :type access_control:
     ~azure.mgmt.media.models.LiveEventPreviewAccessControl
    :param preview_locator: The identifier of the preview locator in Guid
     format. Specifying this at creation time allows the caller to know the
     preview locator url before the event is created. If omitted, the service
     will generate a random identifier. This value cannot be updated once the
     live event is created.
    :type preview_locator: str
    :param streaming_policy_name: The name of streaming policy used for the
     live event preview. This value is specified at creation time and cannot be
     updated.
    :type streaming_policy_name: str
    :param alternative_media_id: An alternative media identifier associated
     with the streaming locator created for the preview. This value is
     specified at creation time and cannot be updated. The identifier can be
     used in the CustomLicenseAcquisitionUrlTemplate or the
     CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the
     StreamingPolicyName field.
    :type alternative_media_id: str
    """

    _attribute_map = {
        'endpoints': {'key': 'endpoints', 'type': '[LiveEventEndpoint]'},
        'access_control': {'key': 'accessControl', 'type': 'LiveEventPreviewAccessControl'},
        'preview_locator': {'key': 'previewLocator', 'type': 'str'},
        'streaming_policy_name': {'key': 'streamingPolicyName', 'type': 'str'},
        'alternative_media_id': {'key': 'alternativeMediaId', 'type': 'str'},
    }

    def __init__(self, *, endpoints=None, access_control=None, preview_locator: str=None, streaming_policy_name: str=None, alternative_media_id: str=None, **kwargs) -> None:
        super(LiveEventPreview, self).__init__(**kwargs)
        self.endpoints = endpoints
        self.access_control = access_control
        self.preview_locator = preview_locator
        self.streaming_policy_name = streaming_policy_name
        self.alternative_media_id = alternative_media_id


class LiveEventPreviewAccessControl(Model):
    """The IP access control for the live event preview endpoint.

    :param ip: The IP access control properties.
    :type ip: ~azure.mgmt.media.models.IPAccessControl
    """

    _attribute_map = {
        'ip': {'key': 'ip', 'type': 'IPAccessControl'},
    }

    def __init__(self, *, ip=None, **kwargs) -> None:
        super(LiveEventPreviewAccessControl, self).__init__(**kwargs)
        self.ip = ip


class LiveEventTranscription(Model):
    """Describes the transcription tracks in the output of a live event, generated
    using speech-to-text transcription. This property is reserved for future
    use, any value set on this property will be ignored.

    :param language: Specifies the language (locale) to be used for
     speech-to-text transcription – it should match the spoken language in the
     audio track. The value should be in BCP-47 format (e.g: 'en-US'). See
     https://go.microsoft.com/fwlink/?linkid=2133742 for more information about
     the live transcription feature and the list of supported languages.
    :type language: str
    :param input_track_selection: Provides a mechanism to select the audio
     track in the input live feed, to which speech-to-text transcription is
     applied. This property is reserved for future use, any value set on this
     property will be ignored.
    :type input_track_selection:
     list[~azure.mgmt.media.models.LiveEventInputTrackSelection]
    :param output_transcription_track: Describes a transcription track in the
     output of a live event, generated using speech-to-text transcription. This
     property is reserved for future use, any value set on this property will
     be ignored.
    :type output_transcription_track:
     ~azure.mgmt.media.models.LiveEventOutputTranscriptionTrack
    """

    _attribute_map = {
        'language': {'key': 'language', 'type': 'str'},
        'input_track_selection': {'key': 'inputTrackSelection', 'type': '[LiveEventInputTrackSelection]'},
        'output_transcription_track': {'key': 'outputTranscriptionTrack', 'type': 'LiveEventOutputTranscriptionTrack'},
    }

    def __init__(self, *, language: str=None, input_track_selection=None, output_transcription_track=None, **kwargs) -> None:
        super(LiveEventTranscription, self).__init__(**kwargs)
        self.language = language
        self.input_track_selection = input_track_selection
        self.output_transcription_track = output_transcription_track


class LiveOutput(ProxyResource):
    """The Live Output.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param description: The description of the live output.
    :type description: str
    :param asset_name: Required. The asset that the live output will write to.
    :type asset_name: str
    :param archive_window_length: Required. ISO 8601 time between 1 minute to
     25 hours to indicate the maximum content length that can be archived in
     the asset for this live output. This also sets the maximum content length
     for the rewind window. For example, use PT1H30M to indicate 1 hour and 30
     minutes of archive window.
    :type archive_window_length: timedelta
    :param manifest_name: The manifest file name. If not provided, the service
     will generate one automatically.
    :type manifest_name: str
    :param hls: HTTP Live Streaming (HLS) packing setting for the live output.
    :type hls: ~azure.mgmt.media.models.Hls
    :param output_snap_time: The initial timestamp that the live output will
     start at, any content before this value will not be archived.
    :type output_snap_time: long
    :ivar created: The creation time the live output.
    :vartype created: datetime
    :ivar last_modified: The time the live output was last modified.
    :vartype last_modified: datetime
    :ivar provisioning_state: The provisioning state of the live output.
    :vartype provisioning_state: str
    :ivar resource_state: The resource state of the live output. Possible
     values include: 'Creating', 'Running', 'Deleting'
    :vartype resource_state: str or
     ~azure.mgmt.media.models.LiveOutputResourceState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'asset_name': {'required': True},
        'archive_window_length': {'required': True},
        'created': {'readonly': True},
        'last_modified': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'asset_name': {'key': 'properties.assetName', 'type': 'str'},
        'archive_window_length': {'key': 'properties.archiveWindowLength', 'type': 'duration'},
        'manifest_name': {'key': 'properties.manifestName', 'type': 'str'},
        'hls': {'key': 'properties.hls', 'type': 'Hls'},
        'output_snap_time': {'key': 'properties.outputSnapTime', 'type': 'long'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'last_modified': {'key': 'properties.lastModified', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
    }

    def __init__(self, *, asset_name: str, archive_window_length, description: str=None, manifest_name: str=None, hls=None, output_snap_time: int=None, **kwargs) -> None:
        super(LiveOutput, self).__init__(**kwargs)
        self.description = description
        self.asset_name = asset_name
        self.archive_window_length = archive_window_length
        self.manifest_name = manifest_name
        self.hls = hls
        self.output_snap_time = output_snap_time
        self.created = None
        self.last_modified = None
        self.provisioning_state = None
        self.resource_state = None


class Location(Model):
    """Location.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name: str, **kwargs) -> None:
        super(Location, self).__init__(**kwargs)
        self.name = name


class LogSpecification(Model):
    """A diagnostic log emitted by service.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The diagnostic log category name.
    :vartype name: str
    :ivar display_name: The diagnostic log category display name.
    :vartype display_name: str
    :ivar blob_duration: The time range for requests in each blob.
    :vartype blob_duration: str
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'blob_duration': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(LogSpecification, self).__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.blob_duration = None


class MediaService(TrackedResource):
    """A Media Services account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :ivar media_service_id: The Media Services account ID.
    :vartype media_service_id: str
    :param storage_accounts: The storage accounts for this resource.
    :type storage_accounts: list[~azure.mgmt.media.models.StorageAccount]
    :param storage_authentication: Possible values include: 'System',
     'ManagedIdentity'
    :type storage_authentication: str or
     ~azure.mgmt.media.models.StorageAuthentication
    :param encryption: The account encryption properties.
    :type encryption: ~azure.mgmt.media.models.AccountEncryption
    :param identity: The Managed Identity for the Media Services account.
    :type identity: ~azure.mgmt.media.models.MediaServiceIdentity
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'media_service_id': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'media_service_id': {'key': 'properties.mediaServiceId', 'type': 'str'},
        'storage_accounts': {'key': 'properties.storageAccounts', 'type': '[StorageAccount]'},
        'storage_authentication': {'key': 'properties.storageAuthentication', 'type': 'str'},
        'encryption': {'key': 'properties.encryption', 'type': 'AccountEncryption'},
        'identity': {'key': 'identity', 'type': 'MediaServiceIdentity'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, location: str, tags=None, storage_accounts=None, storage_authentication=None, encryption=None, identity=None, **kwargs) -> None:
        super(MediaService, self).__init__(tags=tags, location=location, **kwargs)
        self.media_service_id = None
        self.storage_accounts = storage_accounts
        self.storage_authentication = storage_authentication
        self.encryption = encryption
        self.identity = identity
        self.system_data = None


class MediaServiceIdentity(Model):
    """MediaServiceIdentity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The identity type. Possible values include:
     'SystemAssigned', 'None'
    :type type: str or ~azure.mgmt.media.models.ManagedIdentityType
    :ivar principal_id: The Principal ID of the identity.
    :vartype principal_id: str
    :ivar tenant_id: The Tenant ID of the identity.
    :vartype tenant_id: str
    """

    _validation = {
        'type': {'required': True},
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(self, *, type, **kwargs) -> None:
        super(MediaServiceIdentity, self).__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None


class MetricDimension(Model):
    """A metric dimension.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The metric dimension name.
    :vartype name: str
    :ivar display_name: The display name for the dimension.
    :vartype display_name: str
    :ivar to_be_exported_for_shoebox: Whether to export metric to shoebox.
    :vartype to_be_exported_for_shoebox: bool
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'to_be_exported_for_shoebox': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(self, **kwargs) -> None:
        super(MetricDimension, self).__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.to_be_exported_for_shoebox = None


class MetricSpecification(Model):
    """A metric emitted by service.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The metric name.
    :vartype name: str
    :ivar display_name: The metric display name.
    :vartype display_name: str
    :ivar display_description: The metric display description.
    :vartype display_description: str
    :ivar unit: The metric unit. Possible values include: 'Bytes', 'Count',
     'Milliseconds'
    :vartype unit: str or ~azure.mgmt.media.models.MetricUnit
    :ivar aggregation_type: The metric aggregation type. Possible values
     include: 'Average', 'Count', 'Total'
    :vartype aggregation_type: str or
     ~azure.mgmt.media.models.MetricAggregationType
    :ivar lock_aggregation_type: The metric lock aggregation type. Possible
     values include: 'Average', 'Count', 'Total'
    :vartype lock_aggregation_type: str or
     ~azure.mgmt.media.models.MetricAggregationType
    :param supported_aggregation_types: Supported aggregation types.
    :type supported_aggregation_types: list[str]
    :ivar dimensions: The metric dimensions.
    :vartype dimensions: list[~azure.mgmt.media.models.MetricDimension]
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'display_description': {'readonly': True},
        'unit': {'readonly': True},
        'aggregation_type': {'readonly': True},
        'lock_aggregation_type': {'readonly': True},
        'dimensions': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'lock_aggregation_type': {'key': 'lockAggregationType', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimension]'},
    }

    def __init__(self, *, supported_aggregation_types=None, **kwargs) -> None:
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.display_description = None
        self.unit = None
        self.aggregation_type = None
        self.lock_aggregation_type = None
        self.supported_aggregation_types = supported_aggregation_types
        self.dimensions = None


class MultiBitrateFormat(Format):
    """Describes the properties for producing a collection of GOP aligned
    multi-bitrate files. The default behavior is to produce one output file for
    each video layer which is muxed together with all the audios. The exact
    output files produced can be controlled by specifying the outputFiles
    collection.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Mp4Format, TransportStreamFormat

    All required parameters must be populated in order to send to Azure.

    :param filename_pattern: Required. The pattern of the file names for the
     generated output files. The following macros are supported in the file
     name: {Basename} - An expansion macro that will use the name of the input
     video file. If the base name(the file suffix is not included) of the input
     video file is less than 32 characters long, the base name of input video
     files will be used. If the length of base name of the input video file
     exceeds 32 characters, the base name is truncated to the first 32
     characters in total length. {Extension} - The appropriate extension for
     this format. {Label} - The label assigned to the codec/layer. {Index} - A
     unique index for thumbnails. Only applicable to thumbnails. {Bitrate} -
     The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type
     of the audio/video codec. {Resolution} - The video resolution. Any
     unsubstituted macros will be collapsed and removed from the filename.
    :type filename_pattern: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param output_files: The list of output files to produce.  Each entry in
     the list is a set of audio and video layer labels to be muxed together .
    :type output_files: list[~azure.mgmt.media.models.OutputFile]
    """

    _validation = {
        'filename_pattern': {'required': True},
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'filename_pattern': {'key': 'filenamePattern', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'output_files': {'key': 'outputFiles', 'type': '[OutputFile]'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.Mp4Format': 'Mp4Format', '#Microsoft.Media.TransportStreamFormat': 'TransportStreamFormat'}
    }

    def __init__(self, *, filename_pattern: str, output_files=None, **kwargs) -> None:
        super(MultiBitrateFormat, self).__init__(filename_pattern=filename_pattern, **kwargs)
        self.output_files = output_files
        self.odatatype = '#Microsoft.Media.MultiBitrateFormat'


class Mp4Format(MultiBitrateFormat):
    """Describes the properties for an output ISO MP4 file.

    All required parameters must be populated in order to send to Azure.

    :param filename_pattern: Required. The pattern of the file names for the
     generated output files. The following macros are supported in the file
     name: {Basename} - An expansion macro that will use the name of the input
     video file. If the base name(the file suffix is not included) of the input
     video file is less than 32 characters long, the base name of input video
     files will be used. If the length of base name of the input video file
     exceeds 32 characters, the base name is truncated to the first 32
     characters in total length. {Extension} - The appropriate extension for
     this format. {Label} - The label assigned to the codec/layer. {Index} - A
     unique index for thumbnails. Only applicable to thumbnails. {Bitrate} -
     The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type
     of the audio/video codec. {Resolution} - The video resolution. Any
     unsubstituted macros will be collapsed and removed from the filename.
    :type filename_pattern: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param output_files: The list of output files to produce.  Each entry in
     the list is a set of audio and video layer labels to be muxed together .
    :type output_files: list[~azure.mgmt.media.models.OutputFile]
    """

    _validation = {
        'filename_pattern': {'required': True},
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'filename_pattern': {'key': 'filenamePattern', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'output_files': {'key': 'outputFiles', 'type': '[OutputFile]'},
    }

    def __init__(self, *, filename_pattern: str, output_files=None, **kwargs) -> None:
        super(Mp4Format, self).__init__(filename_pattern=filename_pattern, output_files=output_files, **kwargs)
        self.odatatype = '#Microsoft.Media.Mp4Format'


class NoEncryption(Model):
    """Class for NoEncryption scheme.

    :param enabled_protocols: Representing supported protocols
    :type enabled_protocols: ~azure.mgmt.media.models.EnabledProtocols
    """

    _attribute_map = {
        'enabled_protocols': {'key': 'enabledProtocols', 'type': 'EnabledProtocols'},
    }

    def __init__(self, *, enabled_protocols=None, **kwargs) -> None:
        super(NoEncryption, self).__init__(**kwargs)
        self.enabled_protocols = enabled_protocols


class ODataError(Model):
    """Information about an error.

    :param code: A language-independent error name.
    :type code: str
    :param message: The error message.
    :type message: str
    :param target: The target of the error (for example, the name of the
     property in error).
    :type target: str
    :param details: The error details.
    :type details: list[~azure.mgmt.media.models.ODataError]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ODataError]'},
    }

    def __init__(self, *, code: str=None, message: str=None, target: str=None, details=None, **kwargs) -> None:
        super(ODataError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class Operation(Model):
    """An operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The operation name.
    :type name: str
    :param display: The operation display name.
    :type display: ~azure.mgmt.media.models.OperationDisplay
    :param origin: Origin of the operation.
    :type origin: str
    :param properties: Operation properties format.
    :type properties: ~azure.mgmt.media.models.Properties
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'Properties'},
    }

    def __init__(self, *, name: str, display=None, origin: str=None, properties=None, **kwargs) -> None:
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationDisplay(Model):
    """Operation details.

    :param provider: The service provider.
    :type provider: str
    :param resource: Resource on which the operation is performed.
    :type resource: str
    :param operation: The operation type.
    :type operation: str
    :param description: The operation description.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OutputFile(Model):
    """Represents an output file produced.

    All required parameters must be populated in order to send to Azure.

    :param labels: Required. The list of labels that describe how the encoder
     should multiplex video and audio into an output file. For example, if the
     encoder is producing two video layers with labels v1 and v2, and one audio
     layer with label a1, then an array like '[v1, a1]' tells the encoder to
     produce an output file with the video track represented by v1 and the
     audio track represented by a1.
    :type labels: list[str]
    """

    _validation = {
        'labels': {'required': True},
    }

    _attribute_map = {
        'labels': {'key': 'labels', 'type': '[str]'},
    }

    def __init__(self, *, labels, **kwargs) -> None:
        super(OutputFile, self).__init__(**kwargs)
        self.labels = labels


class PngFormat(ImageFormat):
    """Describes the settings for producing PNG thumbnails.

    All required parameters must be populated in order to send to Azure.

    :param filename_pattern: Required. The pattern of the file names for the
     generated output files. The following macros are supported in the file
     name: {Basename} - An expansion macro that will use the name of the input
     video file. If the base name(the file suffix is not included) of the input
     video file is less than 32 characters long, the base name of input video
     files will be used. If the length of base name of the input video file
     exceeds 32 characters, the base name is truncated to the first 32
     characters in total length. {Extension} - The appropriate extension for
     this format. {Label} - The label assigned to the codec/layer. {Index} - A
     unique index for thumbnails. Only applicable to thumbnails. {Bitrate} -
     The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type
     of the audio/video codec. {Resolution} - The video resolution. Any
     unsubstituted macros will be collapsed and removed from the filename.
    :type filename_pattern: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'filename_pattern': {'required': True},
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'filename_pattern': {'key': 'filenamePattern', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(self, *, filename_pattern: str, **kwargs) -> None:
        super(PngFormat, self).__init__(filename_pattern=filename_pattern, **kwargs)
        self.odatatype = '#Microsoft.Media.PngFormat'


class PngImage(Image):
    """Describes the properties for producing a series of PNG images from the
    input video.

    All required parameters must be populated in order to send to Azure.

    :param label: An optional label for the codec. The label can be used to
     control muxing behavior.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param key_frame_interval: The distance between two key frames. The value
     should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
     format. The default is 2 seconds(PT2S). Note that this setting is ignored
     if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will
     follow the input source setting.
    :type key_frame_interval: timedelta
    :param stretch_mode: The resizing mode - how the input video will be
     resized to fit the desired output resolution(s). Default is AutoSize.
     Possible values include: 'None', 'AutoSize', 'AutoFit'
    :type stretch_mode: str or ~azure.mgmt.media.models.StretchMode
    :param sync_mode: The Video Sync Mode. Possible values include: 'Auto',
     'Passthrough', 'Cfr', 'Vfr'
    :type sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
    :param start: Required. The position in the input video from where to
     start generating thumbnails. The value can be in ISO 8601 format (For
     example, PT05S to start at 5 seconds), or a frame count (For example, 10
     to start at the 10th frame), or a relative value to stream duration (For
     example, 10% to start at 10% of stream duration). Also supports a macro
     {Best}, which tells the encoder to select the best thumbnail from the
     first few seconds of the video and will only produce one thumbnail, no
     matter what other settings are for Step and Range. The default value is
     macro {Best}.
    :type start: str
    :param step: The intervals at which thumbnails are generated. The value
     can be in ISO 8601 format (For example, PT05S for one image every 5
     seconds), or a frame count (For example, 30 for one image every 30
     frames), or a relative value to stream duration (For example, 10% for one
     image every 10% of stream duration). Note: Step value will affect the
     first generated thumbnail, which may not be exactly the one specified at
     transform preset start time. This is due to the encoder, which tries to
     select the best thumbnail between start time and Step position from start
     time as the first output. As the default value is 10%, it means if stream
     has long duration, the first generated thumbnail might be far away from
     the one specified at start time. Try to select reasonable value for Step
     if the first thumbnail is expected close to start time, or set Range value
     at 1 if only one thumbnail is needed at start time.
    :type step: str
    :param range: The position relative to transform preset start time in the
     input video at which to stop generating thumbnails. The value can be in
     ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds
     from start time), or a frame count (For example, 300 to stop at the 300th
     frame from the frame at start time. If this value is 1, it means only
     producing one thumbnail at start time), or a relative value to the stream
     duration (For example, 50% to stop at half of stream duration from start
     time). The default value is 100%, which means to stop at the end of the
     stream.
    :type range: str
    :param layers: A collection of output PNG image layers to be produced by
     the encoder.
    :type layers: list[~azure.mgmt.media.models.PngLayer]
    """

    _validation = {
        'odatatype': {'required': True},
        'start': {'required': True},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'key_frame_interval': {'key': 'keyFrameInterval', 'type': 'duration'},
        'stretch_mode': {'key': 'stretchMode', 'type': 'str'},
        'sync_mode': {'key': 'syncMode', 'type': 'str'},
        'start': {'key': 'start', 'type': 'str'},
        'step': {'key': 'step', 'type': 'str'},
        'range': {'key': 'range', 'type': 'str'},
        'layers': {'key': 'layers', 'type': '[PngLayer]'},
    }

    def __init__(self, *, start: str, label: str=None, key_frame_interval=None, stretch_mode=None, sync_mode=None, step: str=None, range: str=None, layers=None, **kwargs) -> None:
        super(PngImage, self).__init__(label=label, key_frame_interval=key_frame_interval, stretch_mode=stretch_mode, sync_mode=sync_mode, start=start, step=step, range=range, **kwargs)
        self.layers = layers
        self.odatatype = '#Microsoft.Media.PngImage'


class PngLayer(Layer):
    """Describes the settings to produce a PNG image from the input video.

    All required parameters must be populated in order to send to Azure.

    :param width: The width of the output video for this layer. The value can
     be absolute (in pixels) or relative (in percentage). For example 50% means
     the output video has half as many pixels in width as the input.
    :type width: str
    :param height: The height of the output video for this layer. The value
     can be absolute (in pixels) or relative (in percentage). For example 50%
     means the output video has half as many pixels in height as the input.
    :type height: str
    :param label: The alphanumeric label for this layer, which can be used in
     multiplexing different video and audio layers, or in naming the output
     file.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'width': {'key': 'width', 'type': 'str'},
        'height': {'key': 'height', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(self, *, width: str=None, height: str=None, label: str=None, **kwargs) -> None:
        super(PngLayer, self).__init__(width=width, height=height, label=label, **kwargs)
        self.odatatype = '#Microsoft.Media.PngLayer'


class PresentationTimeRange(Model):
    """The presentation time range, this is asset related and not recommended for
    Account Filter.

    :param start_timestamp: The absolute start time boundary.
    :type start_timestamp: long
    :param end_timestamp: The absolute end time boundary.
    :type end_timestamp: long
    :param presentation_window_duration: The relative to end sliding window.
    :type presentation_window_duration: long
    :param live_backoff_duration: The relative to end right edge.
    :type live_backoff_duration: long
    :param timescale: The time scale of time stamps.
    :type timescale: long
    :param force_end_timestamp: The indicator of forcing existing of end time
     stamp.
    :type force_end_timestamp: bool
    """

    _attribute_map = {
        'start_timestamp': {'key': 'startTimestamp', 'type': 'long'},
        'end_timestamp': {'key': 'endTimestamp', 'type': 'long'},
        'presentation_window_duration': {'key': 'presentationWindowDuration', 'type': 'long'},
        'live_backoff_duration': {'key': 'liveBackoffDuration', 'type': 'long'},
        'timescale': {'key': 'timescale', 'type': 'long'},
        'force_end_timestamp': {'key': 'forceEndTimestamp', 'type': 'bool'},
    }

    def __init__(self, *, start_timestamp: int=None, end_timestamp: int=None, presentation_window_duration: int=None, live_backoff_duration: int=None, timescale: int=None, force_end_timestamp: bool=None, **kwargs) -> None:
        super(PresentationTimeRange, self).__init__(**kwargs)
        self.start_timestamp = start_timestamp
        self.end_timestamp = end_timestamp
        self.presentation_window_duration = presentation_window_duration
        self.live_backoff_duration = live_backoff_duration
        self.timescale = timescale
        self.force_end_timestamp = force_end_timestamp


class PrivateEndpoint(Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ARM identifier for Private Endpoint
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param private_endpoint: The resource of private end point.
    :type private_endpoint: ~azure.mgmt.media.models.PrivateEndpoint
    :param private_link_service_connection_state: Required. A collection of
     information about the state of the connection between service consumer and
     provider.
    :type private_link_service_connection_state:
     ~azure.mgmt.media.models.PrivateLinkServiceConnectionState
    :param provisioning_state: The provisioning state of the private endpoint
     connection resource. Possible values include: 'Succeeded', 'Creating',
     'Deleting', 'Failed'
    :type provisioning_state: str or
     ~azure.mgmt.media.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'private_link_service_connection_state': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, private_link_service_connection_state, private_endpoint=None, provisioning_state=None, **kwargs) -> None:
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionListResult(Model):
    """List of private endpoint connection associated with the specified storage
    account.

    :param value: Array of private endpoint connections
    :type value: list[~azure.mgmt.media.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = value


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :param required_zone_names: The private link resource Private link DNS
     zone name.
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(self, *, required_zone_names=None, **kwargs) -> None:
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(Model):
    """A list of private link resources.

    :param value: Array of private link resources
    :type value: list[~azure.mgmt.media.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(Model):
    """A collection of information about the state of the connection between
    service consumer and provider.

    :param status: Indicates whether the connection has been
     Approved/Rejected/Removed by the owner of the service. Possible values
     include: 'Pending', 'Approved', 'Rejected'
    :type status: str or
     ~azure.mgmt.media.models.PrivateEndpointServiceConnectionStatus
    :param description: The reason for approval/rejection of the connection.
    :type description: str
    :param actions_required: A message indicating if changes on the service
     provider require any updates on the consumer.
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(self, *, status=None, description: str=None, actions_required: str=None, **kwargs) -> None:
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class Properties(Model):
    """The service specification property.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar service_specification: The service specifications.
    :vartype service_specification:
     ~azure.mgmt.media.models.ServiceSpecification
    """

    _validation = {
        'service_specification': {'readonly': True},
    }

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(self, **kwargs) -> None:
        super(Properties, self).__init__(**kwargs)
        self.service_specification = None


class Provider(Model):
    """A resource provider.

    All required parameters must be populated in order to send to Azure.

    :param provider_name: Required. The provider name.
    :type provider_name: str
    """

    _validation = {
        'provider_name': {'required': True},
    }

    _attribute_map = {
        'provider_name': {'key': 'providerName', 'type': 'str'},
    }

    def __init__(self, *, provider_name: str, **kwargs) -> None:
        super(Provider, self).__init__(**kwargs)
        self.provider_name = provider_name


class Rectangle(Model):
    """Describes the properties of a rectangular window applied to the input media
    before processing it.

    :param left: The number of pixels from the left-margin. This can be
     absolute pixel value (e.g 100), or relative to the size of the video (For
     example, 50%).
    :type left: str
    :param top: The number of pixels from the top-margin. This can be absolute
     pixel value (e.g 100), or relative to the size of the video (For example,
     50%).
    :type top: str
    :param width: The width of the rectangular region in pixels. This can be
     absolute pixel value (e.g 100), or relative to the size of the video (For
     example, 50%).
    :type width: str
    :param height: The height of the rectangular region in pixels. This can be
     absolute pixel value (e.g 100), or relative to the size of the video (For
     example, 50%).
    :type height: str
    """

    _attribute_map = {
        'left': {'key': 'left', 'type': 'str'},
        'top': {'key': 'top', 'type': 'str'},
        'width': {'key': 'width', 'type': 'str'},
        'height': {'key': 'height', 'type': 'str'},
    }

    def __init__(self, *, left: str=None, top: str=None, width: str=None, height: str=None, **kwargs) -> None:
        super(Rectangle, self).__init__(**kwargs)
        self.left = left
        self.top = top
        self.width = width
        self.height = height


class SelectAudioTrackByAttribute(AudioTrackDescriptor):
    """Select audio tracks from the input by specifying an attribute and an
    attribute filter.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param channel_mapping: Optional designation for single channel audio
     tracks.  Can be used to combine the tracks into stereo or multi-channel
     audio tracks. Possible values include: 'FrontLeft', 'FrontRight',
     'Center', 'LowFrequencyEffects', 'BackLeft', 'BackRight', 'StereoLeft',
     'StereoRight'
    :type channel_mapping: str or ~azure.mgmt.media.models.ChannelMapping
    :param attribute: Required. The TrackAttribute to filter the tracks by.
     Possible values include: 'Bitrate', 'Language'
    :type attribute: str or ~azure.mgmt.media.models.TrackAttribute
    :param filter: Required. The type of AttributeFilter to apply to the
     TrackAttribute in order to select the tracks. Possible values include:
     'All', 'Top', 'Bottom', 'ValueEquals'
    :type filter: str or ~azure.mgmt.media.models.AttributeFilter
    :param filter_value: The value to filter the tracks by.  Only used when
     AttributeFilter.ValueEquals is specified for the Filter property.
    :type filter_value: str
    """

    _validation = {
        'odatatype': {'required': True},
        'attribute': {'required': True},
        'filter': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'channel_mapping': {'key': 'channelMapping', 'type': 'str'},
        'attribute': {'key': 'attribute', 'type': 'str'},
        'filter': {'key': 'filter', 'type': 'str'},
        'filter_value': {'key': 'filterValue', 'type': 'str'},
    }

    def __init__(self, *, attribute, filter, channel_mapping=None, filter_value: str=None, **kwargs) -> None:
        super(SelectAudioTrackByAttribute, self).__init__(channel_mapping=channel_mapping, **kwargs)
        self.attribute = attribute
        self.filter = filter
        self.filter_value = filter_value
        self.odatatype = '#Microsoft.Media.SelectAudioTrackByAttribute'


class SelectAudioTrackById(AudioTrackDescriptor):
    """Select audio tracks from the input by specifying a track identifier.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param channel_mapping: Optional designation for single channel audio
     tracks.  Can be used to combine the tracks into stereo or multi-channel
     audio tracks. Possible values include: 'FrontLeft', 'FrontRight',
     'Center', 'LowFrequencyEffects', 'BackLeft', 'BackRight', 'StereoLeft',
     'StereoRight'
    :type channel_mapping: str or ~azure.mgmt.media.models.ChannelMapping
    :param track_id: Required. Track identifier to select
    :type track_id: long
    """

    _validation = {
        'odatatype': {'required': True},
        'track_id': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'channel_mapping': {'key': 'channelMapping', 'type': 'str'},
        'track_id': {'key': 'trackId', 'type': 'long'},
    }

    def __init__(self, *, track_id: int, channel_mapping=None, **kwargs) -> None:
        super(SelectAudioTrackById, self).__init__(channel_mapping=channel_mapping, **kwargs)
        self.track_id = track_id
        self.odatatype = '#Microsoft.Media.SelectAudioTrackById'


class VideoTrackDescriptor(TrackDescriptor):
    """A TrackSelection to select video tracks.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SelectVideoTrackByAttribute, SelectVideoTrackById

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.SelectVideoTrackByAttribute': 'SelectVideoTrackByAttribute', '#Microsoft.Media.SelectVideoTrackById': 'SelectVideoTrackById'}
    }

    def __init__(self, **kwargs) -> None:
        super(VideoTrackDescriptor, self).__init__(**kwargs)
        self.odatatype = '#Microsoft.Media.VideoTrackDescriptor'


class SelectVideoTrackByAttribute(VideoTrackDescriptor):
    """Select video tracks from the input by specifying an attribute and an
    attribute filter.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param attribute: Required. The TrackAttribute to filter the tracks by.
     Possible values include: 'Bitrate', 'Language'
    :type attribute: str or ~azure.mgmt.media.models.TrackAttribute
    :param filter: Required. The type of AttributeFilter to apply to the
     TrackAttribute in order to select the tracks. Possible values include:
     'All', 'Top', 'Bottom', 'ValueEquals'
    :type filter: str or ~azure.mgmt.media.models.AttributeFilter
    :param filter_value: The value to filter the tracks by.  Only used when
     AttributeFilter.ValueEquals is specified for the Filter property. For
     TrackAttribute.Bitrate, this should be an integer value in bits per second
     (e.g: '1500000').  The TrackAttribute.Language is not supported for video
     tracks.
    :type filter_value: str
    """

    _validation = {
        'odatatype': {'required': True},
        'attribute': {'required': True},
        'filter': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'attribute': {'key': 'attribute', 'type': 'str'},
        'filter': {'key': 'filter', 'type': 'str'},
        'filter_value': {'key': 'filterValue', 'type': 'str'},
    }

    def __init__(self, *, attribute, filter, filter_value: str=None, **kwargs) -> None:
        super(SelectVideoTrackByAttribute, self).__init__(**kwargs)
        self.attribute = attribute
        self.filter = filter
        self.filter_value = filter_value
        self.odatatype = '#Microsoft.Media.SelectVideoTrackByAttribute'


class SelectVideoTrackById(VideoTrackDescriptor):
    """Select video tracks from the input by specifying a track identifier.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param track_id: Required. Track identifier to select
    :type track_id: long
    """

    _validation = {
        'odatatype': {'required': True},
        'track_id': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'track_id': {'key': 'trackId', 'type': 'long'},
    }

    def __init__(self, *, track_id: int, **kwargs) -> None:
        super(SelectVideoTrackById, self).__init__(**kwargs)
        self.track_id = track_id
        self.odatatype = '#Microsoft.Media.SelectVideoTrackById'


class ServiceSpecification(Model):
    """The service metric specifications.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar log_specifications: List of log specifications.
    :vartype log_specifications:
     list[~azure.mgmt.media.models.LogSpecification]
    :ivar metric_specifications: List of metric specifications.
    :vartype metric_specifications:
     list[~azure.mgmt.media.models.MetricSpecification]
    """

    _validation = {
        'log_specifications': {'readonly': True},
        'metric_specifications': {'readonly': True},
    }

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = None
        self.metric_specifications = None


class StandardEncoderPreset(Preset):
    """Describes all the settings to be used when encoding the input video with
    the Standard Encoder.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param filters: One or more filtering operations that are applied to the
     input media before encoding.
    :type filters: ~azure.mgmt.media.models.Filters
    :param codecs: Required. The list of codecs to be used when encoding the
     input video.
    :type codecs: list[~azure.mgmt.media.models.Codec]
    :param formats: Required. The list of outputs to be produced by the
     encoder.
    :type formats: list[~azure.mgmt.media.models.Format]
    """

    _validation = {
        'odatatype': {'required': True},
        'codecs': {'required': True},
        'formats': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'filters': {'key': 'filters', 'type': 'Filters'},
        'codecs': {'key': 'codecs', 'type': '[Codec]'},
        'formats': {'key': 'formats', 'type': '[Format]'},
    }

    def __init__(self, *, codecs, formats, filters=None, **kwargs) -> None:
        super(StandardEncoderPreset, self).__init__(**kwargs)
        self.filters = filters
        self.codecs = codecs
        self.formats = formats
        self.odatatype = '#Microsoft.Media.StandardEncoderPreset'


class StorageAccount(Model):
    """The storage account details.

    All required parameters must be populated in order to send to Azure.

    :param id: The ID of the storage account resource. Media Services relies
     on tables and queues as well as blobs, so the primary storage account must
     be a Standard Storage account (either Microsoft.ClassicStorage or
     Microsoft.Storage). Blob only storage accounts can be added as secondary
     storage accounts.
    :type id: str
    :param type: Required. The type of the storage account. Possible values
     include: 'Primary', 'Secondary'
    :type type: str or ~azure.mgmt.media.models.StorageAccountType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, type, id: str=None, **kwargs) -> None:
        super(StorageAccount, self).__init__(**kwargs)
        self.id = id
        self.type = type


class StorageEncryptedAssetDecryptionData(Model):
    """Data needed to decrypt asset files encrypted with legacy storage
    encryption.

    :param key: The Asset File storage encryption key.
    :type key: bytearray
    :param asset_file_encryption_metadata: Asset File encryption metadata.
    :type asset_file_encryption_metadata:
     list[~azure.mgmt.media.models.AssetFileEncryptionMetadata]
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'bytearray'},
        'asset_file_encryption_metadata': {'key': 'assetFileEncryptionMetadata', 'type': '[AssetFileEncryptionMetadata]'},
    }

    def __init__(self, *, key: bytearray=None, asset_file_encryption_metadata=None, **kwargs) -> None:
        super(StorageEncryptedAssetDecryptionData, self).__init__(**kwargs)
        self.key = key
        self.asset_file_encryption_metadata = asset_file_encryption_metadata


class StreamingEndpoint(TrackedResource):
    """The streaming endpoint.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param description: The streaming endpoint description.
    :type description: str
    :param scale_units: Required. The number of scale units. Use the Scale
     operation to adjust this value.
    :type scale_units: int
    :param availability_set_name: This feature is deprecated, do not set a
     value for this property.
    :type availability_set_name: str
    :param access_control: The access control definition of the streaming
     endpoint.
    :type access_control:
     ~azure.mgmt.media.models.StreamingEndpointAccessControl
    :param max_cache_age: Max cache age
    :type max_cache_age: long
    :param custom_host_names: The custom host names of the streaming endpoint
    :type custom_host_names: list[str]
    :ivar host_name: The streaming endpoint host name.
    :vartype host_name: str
    :param cdn_enabled: The CDN enabled flag.
    :type cdn_enabled: bool
    :param cdn_provider: The CDN provider name.
    :type cdn_provider: str
    :param cdn_profile: The CDN profile name.
    :type cdn_profile: str
    :ivar provisioning_state: The provisioning state of the streaming
     endpoint.
    :vartype provisioning_state: str
    :ivar resource_state: The resource state of the streaming endpoint.
     Possible values include: 'Stopped', 'Starting', 'Running', 'Stopping',
     'Deleting', 'Scaling'
    :vartype resource_state: str or
     ~azure.mgmt.media.models.StreamingEndpointResourceState
    :param cross_site_access_policies: The streaming endpoint access policies.
    :type cross_site_access_policies:
     ~azure.mgmt.media.models.CrossSiteAccessPolicies
    :ivar free_trial_end_time: The free trial expiration time.
    :vartype free_trial_end_time: datetime
    :ivar created: The exact time the streaming endpoint was created.
    :vartype created: datetime
    :ivar last_modified: The exact time the streaming endpoint was last
     modified.
    :vartype last_modified: datetime
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'scale_units': {'required': True},
        'host_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_state': {'readonly': True},
        'free_trial_end_time': {'readonly': True},
        'created': {'readonly': True},
        'last_modified': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'scale_units': {'key': 'properties.scaleUnits', 'type': 'int'},
        'availability_set_name': {'key': 'properties.availabilitySetName', 'type': 'str'},
        'access_control': {'key': 'properties.accessControl', 'type': 'StreamingEndpointAccessControl'},
        'max_cache_age': {'key': 'properties.maxCacheAge', 'type': 'long'},
        'custom_host_names': {'key': 'properties.customHostNames', 'type': '[str]'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'cdn_enabled': {'key': 'properties.cdnEnabled', 'type': 'bool'},
        'cdn_provider': {'key': 'properties.cdnProvider', 'type': 'str'},
        'cdn_profile': {'key': 'properties.cdnProfile', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'cross_site_access_policies': {'key': 'properties.crossSiteAccessPolicies', 'type': 'CrossSiteAccessPolicies'},
        'free_trial_end_time': {'key': 'properties.freeTrialEndTime', 'type': 'iso-8601'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'last_modified': {'key': 'properties.lastModified', 'type': 'iso-8601'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, location: str, scale_units: int, tags=None, description: str=None, availability_set_name: str=None, access_control=None, max_cache_age: int=None, custom_host_names=None, cdn_enabled: bool=None, cdn_provider: str=None, cdn_profile: str=None, cross_site_access_policies=None, **kwargs) -> None:
        super(StreamingEndpoint, self).__init__(tags=tags, location=location, **kwargs)
        self.description = description
        self.scale_units = scale_units
        self.availability_set_name = availability_set_name
        self.access_control = access_control
        self.max_cache_age = max_cache_age
        self.custom_host_names = custom_host_names
        self.host_name = None
        self.cdn_enabled = cdn_enabled
        self.cdn_provider = cdn_provider
        self.cdn_profile = cdn_profile
        self.provisioning_state = None
        self.resource_state = None
        self.cross_site_access_policies = cross_site_access_policies
        self.free_trial_end_time = None
        self.created = None
        self.last_modified = None
        self.system_data = None


class StreamingEndpointAccessControl(Model):
    """Streaming endpoint access control definition.

    :param akamai: The access control of Akamai
    :type akamai: ~azure.mgmt.media.models.AkamaiAccessControl
    :param ip: The IP access control of the streaming endpoint.
    :type ip: ~azure.mgmt.media.models.IPAccessControl
    """

    _attribute_map = {
        'akamai': {'key': 'akamai', 'type': 'AkamaiAccessControl'},
        'ip': {'key': 'ip', 'type': 'IPAccessControl'},
    }

    def __init__(self, *, akamai=None, ip=None, **kwargs) -> None:
        super(StreamingEndpointAccessControl, self).__init__(**kwargs)
        self.akamai = akamai
        self.ip = ip


class StreamingEntityScaleUnit(Model):
    """scale units definition.

    :param scale_unit: The scale unit number of the streaming endpoint.
    :type scale_unit: int
    """

    _attribute_map = {
        'scale_unit': {'key': 'scaleUnit', 'type': 'int'},
    }

    def __init__(self, *, scale_unit: int=None, **kwargs) -> None:
        super(StreamingEntityScaleUnit, self).__init__(**kwargs)
        self.scale_unit = scale_unit


class StreamingLocator(ProxyResource):
    """A Streaming Locator resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param asset_name: Required. Asset Name
    :type asset_name: str
    :ivar created: The creation time of the Streaming Locator.
    :vartype created: datetime
    :param start_time: The start time of the Streaming Locator.
    :type start_time: datetime
    :param end_time: The end time of the Streaming Locator.
    :type end_time: datetime
    :param streaming_locator_id: The StreamingLocatorId of the Streaming
     Locator.
    :type streaming_locator_id: str
    :param streaming_policy_name: Required. Name of the Streaming Policy used
     by this Streaming Locator. Either specify the name of Streaming Policy you
     created or use one of the predefined Streaming Policies. The predefined
     Streaming Policies available are: 'Predefined_DownloadOnly',
     'Predefined_ClearStreamingOnly', 'Predefined_DownloadAndClearStreaming',
     'Predefined_ClearKey', 'Predefined_MultiDrmCencStreaming' and
     'Predefined_MultiDrmStreaming'
    :type streaming_policy_name: str
    :param default_content_key_policy_name: Name of the default
     ContentKeyPolicy used by this Streaming Locator.
    :type default_content_key_policy_name: str
    :param content_keys: The ContentKeys used by this Streaming Locator.
    :type content_keys:
     list[~azure.mgmt.media.models.StreamingLocatorContentKey]
    :param alternative_media_id: Alternative Media ID of this Streaming
     Locator
    :type alternative_media_id: str
    :param filters: A list of asset or account filters which apply to this
     streaming locator
    :type filters: list[str]
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'asset_name': {'required': True},
        'created': {'readonly': True},
        'streaming_policy_name': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'asset_name': {'key': 'properties.assetName', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'streaming_locator_id': {'key': 'properties.streamingLocatorId', 'type': 'str'},
        'streaming_policy_name': {'key': 'properties.streamingPolicyName', 'type': 'str'},
        'default_content_key_policy_name': {'key': 'properties.defaultContentKeyPolicyName', 'type': 'str'},
        'content_keys': {'key': 'properties.contentKeys', 'type': '[StreamingLocatorContentKey]'},
        'alternative_media_id': {'key': 'properties.alternativeMediaId', 'type': 'str'},
        'filters': {'key': 'properties.filters', 'type': '[str]'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, asset_name: str, streaming_policy_name: str, start_time=None, end_time=None, streaming_locator_id: str=None, default_content_key_policy_name: str=None, content_keys=None, alternative_media_id: str=None, filters=None, **kwargs) -> None:
        super(StreamingLocator, self).__init__(**kwargs)
        self.asset_name = asset_name
        self.created = None
        self.start_time = start_time
        self.end_time = end_time
        self.streaming_locator_id = streaming_locator_id
        self.streaming_policy_name = streaming_policy_name
        self.default_content_key_policy_name = default_content_key_policy_name
        self.content_keys = content_keys
        self.alternative_media_id = alternative_media_id
        self.filters = filters
        self.system_data = None


class StreamingLocatorContentKey(Model):
    """Class for content key in Streaming Locator.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. ID of Content Key
    :type id: str
    :ivar type: Encryption type of Content Key. Possible values include:
     'CommonEncryptionCenc', 'CommonEncryptionCbcs', 'EnvelopeEncryption'
    :vartype type: str or
     ~azure.mgmt.media.models.StreamingLocatorContentKeyType
    :param label_reference_in_streaming_policy: Label of Content Key as
     specified in the Streaming Policy
    :type label_reference_in_streaming_policy: str
    :param value: Value of Content Key
    :type value: str
    :ivar policy_name: ContentKeyPolicy used by Content Key
    :vartype policy_name: str
    :ivar tracks: Tracks which use this Content Key
    :vartype tracks: list[~azure.mgmt.media.models.TrackSelection]
    """

    _validation = {
        'id': {'required': True},
        'type': {'readonly': True},
        'policy_name': {'readonly': True},
        'tracks': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'label_reference_in_streaming_policy': {'key': 'labelReferenceInStreamingPolicy', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'tracks': {'key': 'tracks', 'type': '[TrackSelection]'},
    }

    def __init__(self, *, id: str, label_reference_in_streaming_policy: str=None, value: str=None, **kwargs) -> None:
        super(StreamingLocatorContentKey, self).__init__(**kwargs)
        self.id = id
        self.type = None
        self.label_reference_in_streaming_policy = label_reference_in_streaming_policy
        self.value = value
        self.policy_name = None
        self.tracks = None


class StreamingPath(Model):
    """Class of paths for streaming.

    All required parameters must be populated in order to send to Azure.

    :param streaming_protocol: Required. Streaming protocol. Possible values
     include: 'Hls', 'Dash', 'SmoothStreaming', 'Download'
    :type streaming_protocol: str or
     ~azure.mgmt.media.models.StreamingPolicyStreamingProtocol
    :param encryption_scheme: Required. Encryption scheme. Possible values
     include: 'NoEncryption', 'EnvelopeEncryption', 'CommonEncryptionCenc',
     'CommonEncryptionCbcs'
    :type encryption_scheme: str or ~azure.mgmt.media.models.EncryptionScheme
    :param paths: Streaming paths for each protocol and encryptionScheme pair
    :type paths: list[str]
    """

    _validation = {
        'streaming_protocol': {'required': True},
        'encryption_scheme': {'required': True},
    }

    _attribute_map = {
        'streaming_protocol': {'key': 'streamingProtocol', 'type': 'str'},
        'encryption_scheme': {'key': 'encryptionScheme', 'type': 'str'},
        'paths': {'key': 'paths', 'type': '[str]'},
    }

    def __init__(self, *, streaming_protocol, encryption_scheme, paths=None, **kwargs) -> None:
        super(StreamingPath, self).__init__(**kwargs)
        self.streaming_protocol = streaming_protocol
        self.encryption_scheme = encryption_scheme
        self.paths = paths


class StreamingPolicy(ProxyResource):
    """A Streaming Policy resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :ivar created: Creation time of Streaming Policy
    :vartype created: datetime
    :param default_content_key_policy_name: Default ContentKey used by current
     Streaming Policy
    :type default_content_key_policy_name: str
    :param envelope_encryption: Configuration of EnvelopeEncryption
    :type envelope_encryption: ~azure.mgmt.media.models.EnvelopeEncryption
    :param common_encryption_cenc: Configuration of CommonEncryptionCenc
    :type common_encryption_cenc:
     ~azure.mgmt.media.models.CommonEncryptionCenc
    :param common_encryption_cbcs: Configuration of CommonEncryptionCbcs
    :type common_encryption_cbcs:
     ~azure.mgmt.media.models.CommonEncryptionCbcs
    :param no_encryption: Configurations of NoEncryption
    :type no_encryption: ~azure.mgmt.media.models.NoEncryption
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'default_content_key_policy_name': {'key': 'properties.defaultContentKeyPolicyName', 'type': 'str'},
        'envelope_encryption': {'key': 'properties.envelopeEncryption', 'type': 'EnvelopeEncryption'},
        'common_encryption_cenc': {'key': 'properties.commonEncryptionCenc', 'type': 'CommonEncryptionCenc'},
        'common_encryption_cbcs': {'key': 'properties.commonEncryptionCbcs', 'type': 'CommonEncryptionCbcs'},
        'no_encryption': {'key': 'properties.noEncryption', 'type': 'NoEncryption'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, default_content_key_policy_name: str=None, envelope_encryption=None, common_encryption_cenc=None, common_encryption_cbcs=None, no_encryption=None, **kwargs) -> None:
        super(StreamingPolicy, self).__init__(**kwargs)
        self.created = None
        self.default_content_key_policy_name = default_content_key_policy_name
        self.envelope_encryption = envelope_encryption
        self.common_encryption_cenc = common_encryption_cenc
        self.common_encryption_cbcs = common_encryption_cbcs
        self.no_encryption = no_encryption
        self.system_data = None


class StreamingPolicyContentKey(Model):
    """Class to specify properties of content key.

    :param label: Label can be used to specify Content Key when creating a
     Streaming Locator
    :type label: str
    :param policy_name: Policy used by Content Key
    :type policy_name: str
    :param tracks: Tracks which use this content key
    :type tracks: list[~azure.mgmt.media.models.TrackSelection]
    """

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'tracks': {'key': 'tracks', 'type': '[TrackSelection]'},
    }

    def __init__(self, *, label: str=None, policy_name: str=None, tracks=None, **kwargs) -> None:
        super(StreamingPolicyContentKey, self).__init__(**kwargs)
        self.label = label
        self.policy_name = policy_name
        self.tracks = tracks


class StreamingPolicyContentKeys(Model):
    """Class to specify properties of all content keys in Streaming Policy.

    :param default_key: Default content key for an encryption scheme
    :type default_key: ~azure.mgmt.media.models.DefaultKey
    :param key_to_track_mappings: Representing tracks needs separate content
     key
    :type key_to_track_mappings:
     list[~azure.mgmt.media.models.StreamingPolicyContentKey]
    """

    _attribute_map = {
        'default_key': {'key': 'defaultKey', 'type': 'DefaultKey'},
        'key_to_track_mappings': {'key': 'keyToTrackMappings', 'type': '[StreamingPolicyContentKey]'},
    }

    def __init__(self, *, default_key=None, key_to_track_mappings=None, **kwargs) -> None:
        super(StreamingPolicyContentKeys, self).__init__(**kwargs)
        self.default_key = default_key
        self.key_to_track_mappings = key_to_track_mappings


class StreamingPolicyFairPlayConfiguration(Model):
    """Class to specify configurations of FairPlay in Streaming Policy.

    All required parameters must be populated in order to send to Azure.

    :param custom_license_acquisition_url_template: Template for the URL of
     the custom service delivering licenses to end user players.  Not required
     when using Azure Media Services for issuing licenses.  The template
     supports replaceable tokens that the service will update at runtime with
     the value specific to the request.  The currently supported token values
     are {AlternativeMediaId}, which is replaced with the value of
     StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is
     replaced with the value of identifier of the key being requested.
    :type custom_license_acquisition_url_template: str
    :param allow_persistent_license: Required. All license to be persistent or
     not
    :type allow_persistent_license: bool
    """

    _validation = {
        'allow_persistent_license': {'required': True},
    }

    _attribute_map = {
        'custom_license_acquisition_url_template': {'key': 'customLicenseAcquisitionUrlTemplate', 'type': 'str'},
        'allow_persistent_license': {'key': 'allowPersistentLicense', 'type': 'bool'},
    }

    def __init__(self, *, allow_persistent_license: bool, custom_license_acquisition_url_template: str=None, **kwargs) -> None:
        super(StreamingPolicyFairPlayConfiguration, self).__init__(**kwargs)
        self.custom_license_acquisition_url_template = custom_license_acquisition_url_template
        self.allow_persistent_license = allow_persistent_license


class StreamingPolicyPlayReadyConfiguration(Model):
    """Class to specify configurations of PlayReady in Streaming Policy.

    :param custom_license_acquisition_url_template: Template for the URL of
     the custom service delivering licenses to end user players.  Not required
     when using Azure Media Services for issuing licenses.  The template
     supports replaceable tokens that the service will update at runtime with
     the value specific to the request.  The currently supported token values
     are {AlternativeMediaId}, which is replaced with the value of
     StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is
     replaced with the value of identifier of the key being requested.
    :type custom_license_acquisition_url_template: str
    :param play_ready_custom_attributes: Custom attributes for PlayReady
    :type play_ready_custom_attributes: str
    """

    _attribute_map = {
        'custom_license_acquisition_url_template': {'key': 'customLicenseAcquisitionUrlTemplate', 'type': 'str'},
        'play_ready_custom_attributes': {'key': 'playReadyCustomAttributes', 'type': 'str'},
    }

    def __init__(self, *, custom_license_acquisition_url_template: str=None, play_ready_custom_attributes: str=None, **kwargs) -> None:
        super(StreamingPolicyPlayReadyConfiguration, self).__init__(**kwargs)
        self.custom_license_acquisition_url_template = custom_license_acquisition_url_template
        self.play_ready_custom_attributes = play_ready_custom_attributes


class StreamingPolicyWidevineConfiguration(Model):
    """Class to specify configurations of Widevine in Streaming Policy.

    :param custom_license_acquisition_url_template: Template for the URL of
     the custom service delivering licenses to end user players.  Not required
     when using Azure Media Services for issuing licenses.  The template
     supports replaceable tokens that the service will update at runtime with
     the value specific to the request.  The currently supported token values
     are {AlternativeMediaId}, which is replaced with the value of
     StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is
     replaced with the value of identifier of the key being requested.
    :type custom_license_acquisition_url_template: str
    """

    _attribute_map = {
        'custom_license_acquisition_url_template': {'key': 'customLicenseAcquisitionUrlTemplate', 'type': 'str'},
    }

    def __init__(self, *, custom_license_acquisition_url_template: str=None, **kwargs) -> None:
        super(StreamingPolicyWidevineConfiguration, self).__init__(**kwargs)
        self.custom_license_acquisition_url_template = custom_license_acquisition_url_template


class SyncStorageKeysInput(Model):
    """The input to the sync storage keys request.

    :param id: The ID of the storage account resource.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(SyncStorageKeysInput, self).__init__(**kwargs)
        self.id = id


class SystemData(Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource.
     Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
    :type created_by_type: str or ~azure.mgmt.media.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the
     resource. Possible values include: 'User', 'Application',
     'ManagedIdentity', 'Key'
    :type last_modified_by_type: str or ~azure.mgmt.media.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC)
    :type last_modified_at: datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(self, *, created_by: str=None, created_by_type=None, created_at=None, last_modified_by: str=None, last_modified_by_type=None, last_modified_at=None, **kwargs) -> None:
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TrackPropertyCondition(Model):
    """Class to specify one track property condition.

    All required parameters must be populated in order to send to Azure.

    :param property: Required. Track property type. Possible values include:
     'Unknown', 'FourCC'
    :type property: str or ~azure.mgmt.media.models.TrackPropertyType
    :param operation: Required. Track property condition operation. Possible
     values include: 'Unknown', 'Equal'
    :type operation: str or
     ~azure.mgmt.media.models.TrackPropertyCompareOperation
    :param value: Track property value
    :type value: str
    """

    _validation = {
        'property': {'required': True},
        'operation': {'required': True},
    }

    _attribute_map = {
        'property': {'key': 'property', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, property, operation, value: str=None, **kwargs) -> None:
        super(TrackPropertyCondition, self).__init__(**kwargs)
        self.property = property
        self.operation = operation
        self.value = value


class TrackSelection(Model):
    """Class to select a track.

    :param track_selections: TrackSelections is a track property condition
     list which can specify track(s)
    :type track_selections:
     list[~azure.mgmt.media.models.TrackPropertyCondition]
    """

    _attribute_map = {
        'track_selections': {'key': 'trackSelections', 'type': '[TrackPropertyCondition]'},
    }

    def __init__(self, *, track_selections=None, **kwargs) -> None:
        super(TrackSelection, self).__init__(**kwargs)
        self.track_selections = track_selections


class Transform(ProxyResource):
    """A Transform encapsulates the rules or instructions for generating desired
    outputs from input media, such as by transcoding or by extracting insights.
    After the Transform is created, it can be applied to input media by
    creating Jobs.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :ivar created: The UTC date and time when the Transform was created, in
     'YYYY-MM-DDThh:mm:ssZ' format.
    :vartype created: datetime
    :param description: An optional verbose description of the Transform.
    :type description: str
    :ivar last_modified: The UTC date and time when the Transform was last
     updated, in 'YYYY-MM-DDThh:mm:ssZ' format.
    :vartype last_modified: datetime
    :param outputs: Required. An array of one or more TransformOutputs that
     the Transform should generate.
    :type outputs: list[~azure.mgmt.media.models.TransformOutput]
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created': {'readonly': True},
        'last_modified': {'readonly': True},
        'outputs': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'last_modified': {'key': 'properties.lastModified', 'type': 'iso-8601'},
        'outputs': {'key': 'properties.outputs', 'type': '[TransformOutput]'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, outputs, description: str=None, **kwargs) -> None:
        super(Transform, self).__init__(**kwargs)
        self.created = None
        self.description = description
        self.last_modified = None
        self.outputs = outputs
        self.system_data = None


class TransformOutput(Model):
    """Describes the properties of a TransformOutput, which are the rules to be
    applied while generating the desired output.

    All required parameters must be populated in order to send to Azure.

    :param on_error: A Transform can define more than one outputs. This
     property defines what the service should do when one output fails - either
     continue to produce other outputs, or, stop the other outputs. The overall
     Job state will not reflect failures of outputs that are specified with
     'ContinueJob'. The default is 'StopProcessingJob'. Possible values
     include: 'StopProcessingJob', 'ContinueJob'
    :type on_error: str or ~azure.mgmt.media.models.OnErrorType
    :param relative_priority: Sets the relative priority of the
     TransformOutputs within a Transform. This sets the priority that the
     service uses for processing TransformOutputs. The default priority is
     Normal. Possible values include: 'Low', 'Normal', 'High'
    :type relative_priority: str or ~azure.mgmt.media.models.Priority
    :param preset: Required. Preset that describes the operations that will be
     used to modify, transcode, or extract insights from the source file to
     generate the output.
    :type preset: ~azure.mgmt.media.models.Preset
    """

    _validation = {
        'preset': {'required': True},
    }

    _attribute_map = {
        'on_error': {'key': 'onError', 'type': 'str'},
        'relative_priority': {'key': 'relativePriority', 'type': 'str'},
        'preset': {'key': 'preset', 'type': 'Preset'},
    }

    def __init__(self, *, preset, on_error=None, relative_priority=None, **kwargs) -> None:
        super(TransformOutput, self).__init__(**kwargs)
        self.on_error = on_error
        self.relative_priority = relative_priority
        self.preset = preset


class TransportStreamFormat(MultiBitrateFormat):
    """Describes the properties for generating an MPEG-2 Transport Stream (ISO/IEC
    13818-1) output video file(s).

    All required parameters must be populated in order to send to Azure.

    :param filename_pattern: Required. The pattern of the file names for the
     generated output files. The following macros are supported in the file
     name: {Basename} - An expansion macro that will use the name of the input
     video file. If the base name(the file suffix is not included) of the input
     video file is less than 32 characters long, the base name of input video
     files will be used. If the length of base name of the input video file
     exceeds 32 characters, the base name is truncated to the first 32
     characters in total length. {Extension} - The appropriate extension for
     this format. {Label} - The label assigned to the codec/layer. {Index} - A
     unique index for thumbnails. Only applicable to thumbnails. {Bitrate} -
     The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type
     of the audio/video codec. {Resolution} - The video resolution. Any
     unsubstituted macros will be collapsed and removed from the filename.
    :type filename_pattern: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param output_files: The list of output files to produce.  Each entry in
     the list is a set of audio and video layer labels to be muxed together .
    :type output_files: list[~azure.mgmt.media.models.OutputFile]
    """

    _validation = {
        'filename_pattern': {'required': True},
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'filename_pattern': {'key': 'filenamePattern', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'output_files': {'key': 'outputFiles', 'type': '[OutputFile]'},
    }

    def __init__(self, *, filename_pattern: str, output_files=None, **kwargs) -> None:
        super(TransportStreamFormat, self).__init__(filename_pattern=filename_pattern, output_files=output_files, **kwargs)
        self.odatatype = '#Microsoft.Media.TransportStreamFormat'


class UtcClipTime(ClipTime):
    """Specifies the clip time as a Utc time position in the media file.  The Utc
    time can point to a different position depending on whether the media file
    starts from a timestamp of zero or not.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param time: Required. The time position on the timeline of the input
     media based on Utc time.
    :type time: datetime
    """

    _validation = {
        'odatatype': {'required': True},
        'time': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
    }

    def __init__(self, *, time, **kwargs) -> None:
        super(UtcClipTime, self).__init__(**kwargs)
        self.time = time
        self.odatatype = '#Microsoft.Media.UtcClipTime'


class VideoAnalyzerPreset(AudioAnalyzerPreset):
    """A video analyzer preset that extracts insights (rich metadata) from both
    audio and video, and outputs a JSON format file.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param audio_language: The language for the audio payload in the input
     using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you
     know the language of your content, it is recommended that you specify it.
     The language must be specified explicitly for AudioAnalysisMode::Basic,
     since automatic language detection is not included in basic mode. If the
     language isn't specified or set to null, automatic language detection will
     choose the first language detected and process with the selected language
     for the duration of the file. It does not currently support dynamically
     switching between languages after the first language is detected. The
     automatic detection works best with audio recordings with clearly
     discernable speech. If automatic detection fails to find the language,
     transcription would fallback to 'en-US'." The list of supported languages
     is available here: https://go.microsoft.com/fwlink/?linkid=2109463
    :type audio_language: str
    :param mode: Determines the set of audio analysis operations to be
     performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
     Possible values include: 'Standard', 'Basic'
    :type mode: str or ~azure.mgmt.media.models.AudioAnalysisMode
    :param experimental_options: Dictionary containing key value pairs for
     parameters not exposed in the preset itself
    :type experimental_options: dict[str, str]
    :param insights_to_extract: Defines the type of insights that you want the
     service to generate. The allowed values are 'AudioInsightsOnly',
     'VideoInsightsOnly', and 'AllInsights'. The default is AllInsights. If you
     set this to AllInsights and the input is audio only, then only audio
     insights are generated. Similarly if the input is video only, then only
     video insights are generated. It is recommended that you not use
     AudioInsightsOnly if you expect some of your inputs to be video only; or
     use VideoInsightsOnly if you expect some of your inputs to be audio only.
     Your Jobs in such conditions would error out. Possible values include:
     'AudioInsightsOnly', 'VideoInsightsOnly', 'AllInsights'
    :type insights_to_extract: str or ~azure.mgmt.media.models.InsightsType
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'audio_language': {'key': 'audioLanguage', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'experimental_options': {'key': 'experimentalOptions', 'type': '{str}'},
        'insights_to_extract': {'key': 'insightsToExtract', 'type': 'str'},
    }

    def __init__(self, *, audio_language: str=None, mode=None, experimental_options=None, insights_to_extract=None, **kwargs) -> None:
        super(VideoAnalyzerPreset, self).__init__(audio_language=audio_language, mode=mode, experimental_options=experimental_options, **kwargs)
        self.insights_to_extract = insights_to_extract
        self.odatatype = '#Microsoft.Media.VideoAnalyzerPreset'


class VideoOverlay(Overlay):
    """Describes the properties of a video overlay.

    All required parameters must be populated in order to send to Azure.

    :param input_label: Required. The label of the job input which is to be
     used as an overlay. The Input must specify exactly one file. You can
     specify an image file in JPG, PNG, GIF or BMP format, or an audio file
     (such as a WAV, MP3, WMA or M4A file), or a video file. See
     https://aka.ms/mesformats for the complete list of supported audio and
     video file formats.
    :type input_label: str
    :param start: The start position, with reference to the input video, at
     which the overlay starts. The value should be in ISO 8601 format. For
     example, PT05S to start the overlay at 5 seconds into the input video. If
     not specified the overlay starts from the beginning of the input video.
    :type start: timedelta
    :param end: The end position, with reference to the input video, at which
     the overlay ends. The value should be in ISO 8601 format. For example,
     PT30S to end the overlay at 30 seconds into the input video. If not
     specified or the value is greater than the input video duration, the
     overlay will be applied until the end of the input video if the overlay
     media duration is greater than the input video duration, else the overlay
     will last as long as the overlay media duration.
    :type end: timedelta
    :param fade_in_duration: The duration over which the overlay fades in onto
     the input video. The value should be in ISO 8601 duration format. If not
     specified the default behavior is to have no fade in (same as PT0S).
    :type fade_in_duration: timedelta
    :param fade_out_duration: The duration over which the overlay fades out of
     the input video. The value should be in ISO 8601 duration format. If not
     specified the default behavior is to have no fade out (same as PT0S).
    :type fade_out_duration: timedelta
    :param audio_gain_level: The gain level of audio in the overlay. The value
     should be in the range [0, 1.0]. The default is 1.0.
    :type audio_gain_level: float
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param position: The location in the input video where the overlay is
     applied.
    :type position: ~azure.mgmt.media.models.Rectangle
    :param opacity: The opacity of the overlay. This is a value in the range
     [0 - 1.0]. Default is 1.0 which mean the overlay is opaque.
    :type opacity: float
    :param crop_rectangle: An optional rectangular window used to crop the
     overlay image or video.
    :type crop_rectangle: ~azure.mgmt.media.models.Rectangle
    """

    _validation = {
        'input_label': {'required': True},
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'input_label': {'key': 'inputLabel', 'type': 'str'},
        'start': {'key': 'start', 'type': 'duration'},
        'end': {'key': 'end', 'type': 'duration'},
        'fade_in_duration': {'key': 'fadeInDuration', 'type': 'duration'},
        'fade_out_duration': {'key': 'fadeOutDuration', 'type': 'duration'},
        'audio_gain_level': {'key': 'audioGainLevel', 'type': 'float'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'position': {'key': 'position', 'type': 'Rectangle'},
        'opacity': {'key': 'opacity', 'type': 'float'},
        'crop_rectangle': {'key': 'cropRectangle', 'type': 'Rectangle'},
    }

    def __init__(self, *, input_label: str, start=None, end=None, fade_in_duration=None, fade_out_duration=None, audio_gain_level: float=None, position=None, opacity: float=None, crop_rectangle=None, **kwargs) -> None:
        super(VideoOverlay, self).__init__(input_label=input_label, start=start, end=end, fade_in_duration=fade_in_duration, fade_out_duration=fade_out_duration, audio_gain_level=audio_gain_level, **kwargs)
        self.position = position
        self.opacity = opacity
        self.crop_rectangle = crop_rectangle
        self.odatatype = '#Microsoft.Media.VideoOverlay'
