"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PullRequestCheck = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_codebuild_1 = require("@aws-cdk/aws-codebuild");
const aws_events_1 = require("@aws-cdk/aws-events");
const aws_events_targets_1 = require("@aws-cdk/aws-events-targets");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
/**
 * Represents a reference to a PullRequestCheck.
 */
class PullRequestCheck extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { repository, buildSpec, buildImage = aws_codebuild_1.LinuxBuildImage.STANDARD_4_0, computeType = buildImage.defaultComputeType, privileged = false, updateApprovalState = true, postComment = true, projectName = `${repository.repositoryName}-pull-request`, role, vpc, subnetSelection, securityGroups, allowAllOutbound, environmentVariables, artifacts, } = props;
        this.pullRequestProject = new aws_codebuild_1.Project(this, 'PullRequestProject', {
            projectName,
            source: aws_codebuild_1.Source.codeCommit({
                repository,
            }),
            environment: {
                buildImage,
                computeType,
                privileged,
                environmentVariables,
            },
            buildSpec,
            role,
            vpc,
            subnetSelection,
            securityGroups,
            allowAllOutbound,
            artifacts,
        });
        if (updateApprovalState || postComment) {
            const codeBuildResultFunction = new aws_lambda_1.Function(this, 'CodeBuildResultFunction', {
                runtime: aws_lambda_1.Runtime.NODEJS_12_X,
                code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'code-build-result')),
                handler: 'index.handler',
                environment: {
                    UPDATE_APPROVAL_STATE: updateApprovalState ? 'TRUE' : 'FALSE',
                    POST_COMMENT: postComment ? 'TRUE' : 'FALSE',
                },
            });
            codeBuildResultFunction.addToRolePolicy(new aws_iam_1.PolicyStatement({
                effect: aws_iam_1.Effect.ALLOW,
                resources: [repository.repositoryArn],
                actions: ['codecommit:PostCommentForPullRequest', 'codecommit:UpdatePullRequestApprovalState'],
            }));
            this.pullRequestProject.onStateChange('PullRequestValidationRule', {
                target: new aws_events_targets_1.LambdaFunction(codeBuildResultFunction),
            });
        }
        const rule = repository.onPullRequestStateChange(`${this.node.addr}Rule`, {
            eventPattern: {
                detail: {
                    event: ['pullRequestSourceBranchUpdated', 'pullRequestCreated'],
                },
            },
        });
        rule.addTarget(new aws_events_targets_1.CodeBuildProject(this.pullRequestProject, {
            event: aws_events_1.RuleTargetInput.fromObject({
                sourceVersion: aws_events_1.EventField.fromPath('$.detail.sourceCommit'),
                environmentVariablesOverride: [
                    {
                        name: 'pullRequestId',
                        value: aws_events_1.EventField.fromPath('$.detail.pullRequestId'),
                        type: 'PLAINTEXT',
                    },
                    {
                        name: 'repositoryName',
                        value: aws_events_1.EventField.fromPath('$.detail.repositoryNames[0]'),
                        type: 'PLAINTEXT',
                    },
                    {
                        name: 'sourceCommit',
                        value: aws_events_1.EventField.fromPath('$.detail.sourceCommit'),
                        type: 'PLAINTEXT',
                    },
                    {
                        name: 'destinationCommit',
                        value: aws_events_1.EventField.fromPath('$.detail.destinationCommit'),
                        type: 'PLAINTEXT',
                    },
                    {
                        name: 'revisionId',
                        value: aws_events_1.EventField.fromPath('$.detail.revisionId'),
                        type: 'PLAINTEXT',
                    },
                ],
            }),
        }));
    }
    /**
     * Defines an event rule which triggers when a check fails.
     */
    onCheckFailed(id, options) {
        return this.pullRequestProject.onBuildFailed(id, options);
    }
    /**
     * Defines an event rule which triggers when a check starts.
     */
    onCheckStarted(id, options) {
        return this.pullRequestProject.onBuildStarted(id, options);
    }
    /**
     * Defines an event rule which triggers when a check complets successfully.
     */
    onCheckSucceeded(id, options) {
        return this.pullRequestProject.onBuildSucceeded(id, options);
    }
    /**
     * Add a permission only if there's a policy attached.
     *
     * @param statement The permissions statement to add.
     */
    addToRolePolicy(statement) {
        this.pullRequestProject.addToRolePolicy(statement);
    }
}
exports.PullRequestCheck = PullRequestCheck;
_a = JSII_RTTI_SYMBOL_1;
PullRequestCheck[_a] = { fqn: "@cloudcomponents/cdk-pull-request-check.PullRequestCheck", version: "1.44.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHVsbC1yZXF1ZXN0LWNoZWNrLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3B1bGwtcmVxdWVzdC1jaGVjay50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZCQUE2QjtBQUM3QiwwREFBcUo7QUFHckosb0RBQXdGO0FBQ3hGLG9FQUErRTtBQUMvRSw4Q0FBa0U7QUFDbEUsb0RBQThEO0FBQzlELHdDQUEwQzs7OztBQXFIMUMsTUFBYSxnQkFBaUIsU0FBUSxnQkFBUztJQUc3QyxZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE0QjtRQUMzRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sRUFDSixVQUFVLEVBQ1YsU0FBUyxFQUNULFVBQVUsR0FBRywrQkFBZSxDQUFDLFlBQVksRUFDekMsV0FBVyxHQUFHLFVBQVUsQ0FBQyxrQkFBa0IsRUFDM0MsVUFBVSxHQUFHLEtBQUssRUFDbEIsbUJBQW1CLEdBQUcsSUFBSSxFQUMxQixXQUFXLEdBQUcsSUFBSSxFQUNsQixXQUFXLEdBQUcsR0FBRyxVQUFVLENBQUMsY0FBYyxlQUFlLEVBQ3pELElBQUksRUFDSixHQUFHLEVBQ0gsZUFBZSxFQUNmLGNBQWMsRUFDZCxnQkFBZ0IsRUFDaEIsb0JBQW9CLEVBQ3BCLFNBQVMsR0FDVixHQUFHLEtBQUssQ0FBQztRQUVWLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLHVCQUFPLENBQUMsSUFBSSxFQUFFLG9CQUFvQixFQUFFO1lBQ2hFLFdBQVc7WUFDWCxNQUFNLEVBQUUsc0JBQU0sQ0FBQyxVQUFVLENBQUM7Z0JBQ3hCLFVBQVU7YUFDWCxDQUFDO1lBQ0YsV0FBVyxFQUFFO2dCQUNYLFVBQVU7Z0JBQ1YsV0FBVztnQkFDWCxVQUFVO2dCQUNWLG9CQUFvQjthQUNyQjtZQUNELFNBQVM7WUFDVCxJQUFJO1lBQ0osR0FBRztZQUNILGVBQWU7WUFDZixjQUFjO1lBQ2QsZ0JBQWdCO1lBQ2hCLFNBQVM7U0FDVixDQUFDLENBQUM7UUFFSCxJQUFJLG1CQUFtQixJQUFJLFdBQVcsRUFBRTtZQUN0QyxNQUFNLHVCQUF1QixHQUFHLElBQUkscUJBQVEsQ0FBQyxJQUFJLEVBQUUseUJBQXlCLEVBQUU7Z0JBQzVFLE9BQU8sRUFBRSxvQkFBTyxDQUFDLFdBQVc7Z0JBQzVCLElBQUksRUFBRSxpQkFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsbUJBQW1CLENBQUMsQ0FBQztnQkFDMUUsT0FBTyxFQUFFLGVBQWU7Z0JBQ3hCLFdBQVcsRUFBRTtvQkFDWCxxQkFBcUIsRUFBRSxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxPQUFPO29CQUM3RCxZQUFZLEVBQUUsV0FBVyxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLE9BQU87aUJBQzdDO2FBQ0YsQ0FBQyxDQUFDO1lBRUgsdUJBQXVCLENBQUMsZUFBZSxDQUNyQyxJQUFJLHlCQUFlLENBQUM7Z0JBQ2xCLE1BQU0sRUFBRSxnQkFBTSxDQUFDLEtBQUs7Z0JBQ3BCLFNBQVMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7Z0JBQ3JDLE9BQU8sRUFBRSxDQUFDLHNDQUFzQyxFQUFFLDJDQUEyQyxDQUFDO2FBQy9GLENBQUMsQ0FDSCxDQUFDO1lBRUYsSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsQ0FBQywyQkFBMkIsRUFBRTtnQkFDakUsTUFBTSxFQUFFLElBQUksbUNBQWMsQ0FBQyx1QkFBdUIsQ0FBQzthQUNwRCxDQUFDLENBQUM7U0FDSjtRQUVELE1BQU0sSUFBSSxHQUFHLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxNQUFNLEVBQUU7WUFDeEUsWUFBWSxFQUFFO2dCQUNaLE1BQU0sRUFBRTtvQkFDTixLQUFLLEVBQUUsQ0FBQyxnQ0FBZ0MsRUFBRSxvQkFBb0IsQ0FBQztpQkFDaEU7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxTQUFTLENBQ1osSUFBSSxxQ0FBZ0IsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLEVBQUU7WUFDNUMsS0FBSyxFQUFFLDRCQUFlLENBQUMsVUFBVSxDQUFDO2dCQUNoQyxhQUFhLEVBQUUsdUJBQVUsQ0FBQyxRQUFRLENBQUMsdUJBQXVCLENBQUM7Z0JBQzNELDRCQUE0QixFQUFFO29CQUM1Qjt3QkFDRSxJQUFJLEVBQUUsZUFBZTt3QkFDckIsS0FBSyxFQUFFLHVCQUFVLENBQUMsUUFBUSxDQUFDLHdCQUF3QixDQUFDO3dCQUNwRCxJQUFJLEVBQUUsV0FBVztxQkFDbEI7b0JBQ0Q7d0JBQ0UsSUFBSSxFQUFFLGdCQUFnQjt3QkFDdEIsS0FBSyxFQUFFLHVCQUFVLENBQUMsUUFBUSxDQUFDLDZCQUE2QixDQUFDO3dCQUN6RCxJQUFJLEVBQUUsV0FBVztxQkFDbEI7b0JBQ0Q7d0JBQ0UsSUFBSSxFQUFFLGNBQWM7d0JBQ3BCLEtBQUssRUFBRSx1QkFBVSxDQUFDLFFBQVEsQ0FBQyx1QkFBdUIsQ0FBQzt3QkFDbkQsSUFBSSxFQUFFLFdBQVc7cUJBQ2xCO29CQUNEO3dCQUNFLElBQUksRUFBRSxtQkFBbUI7d0JBQ3pCLEtBQUssRUFBRSx1QkFBVSxDQUFDLFFBQVEsQ0FBQyw0QkFBNEIsQ0FBQzt3QkFDeEQsSUFBSSxFQUFFLFdBQVc7cUJBQ2xCO29CQUNEO3dCQUNFLElBQUksRUFBRSxZQUFZO3dCQUNsQixLQUFLLEVBQUUsdUJBQVUsQ0FBQyxRQUFRLENBQUMscUJBQXFCLENBQUM7d0JBQ2pELElBQUksRUFBRSxXQUFXO3FCQUNsQjtpQkFDRjthQUNGLENBQUM7U0FDSCxDQUFDLENBQ0gsQ0FBQztJQUNKLENBQUM7Ozs7SUFLTSxhQUFhLENBQUMsRUFBVSxFQUFFLE9BQXdCO1FBQ3ZELE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsQ0FBQyxFQUFFLEVBQUUsT0FBTyxDQUFDLENBQUM7SUFDNUQsQ0FBQzs7OztJQUtNLGNBQWMsQ0FBQyxFQUFVLEVBQUUsT0FBd0I7UUFDeEQsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLEVBQUUsRUFBRSxPQUFPLENBQUMsQ0FBQztJQUM3RCxDQUFDOzs7O0lBS00sZ0JBQWdCLENBQUMsRUFBVSxFQUFFLE9BQXdCO1FBQzFELE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGdCQUFnQixDQUFDLEVBQUUsRUFBRSxPQUFPLENBQUMsQ0FBQztJQUMvRCxDQUFDOzs7Ozs7SUFNTSxlQUFlLENBQUMsU0FBMEI7UUFDL0MsSUFBSSxDQUFDLGtCQUFrQixDQUFDLGVBQWUsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNyRCxDQUFDOztBQTNJSCw0Q0E0SUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0IHsgQnVpbGRTcGVjLCBDb21wdXRlVHlwZSwgSUJ1aWxkSW1hZ2UsIExpbnV4QnVpbGRJbWFnZSwgUHJvamVjdCwgU291cmNlLCBCdWlsZEVudmlyb25tZW50VmFyaWFibGUsIElBcnRpZmFjdHMgfSBmcm9tICdAYXdzLWNkay9hd3MtY29kZWJ1aWxkJztcbmltcG9ydCB7IElSZXBvc2l0b3J5IH0gZnJvbSAnQGF3cy1jZGsvYXdzLWNvZGVjb21taXQnO1xuaW1wb3J0IHsgSVZwYywgU3VibmV0U2VsZWN0aW9uLCBJU2VjdXJpdHlHcm91cCB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1lYzInO1xuaW1wb3J0IHsgRXZlbnRGaWVsZCwgUnVsZVRhcmdldElucHV0LCBPbkV2ZW50T3B0aW9ucywgUnVsZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1ldmVudHMnO1xuaW1wb3J0IHsgQ29kZUJ1aWxkUHJvamVjdCwgTGFtYmRhRnVuY3Rpb24gfSBmcm9tICdAYXdzLWNkay9hd3MtZXZlbnRzLXRhcmdldHMnO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50LCBFZmZlY3QsIElSb2xlIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgeyBDb2RlLCBGdW5jdGlvbiwgUnVudGltZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgUHVsbFJlcXVlc3RDaGVja1Byb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmVwb3NpdG9yeTogSVJlcG9zaXRvcnk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcHJvamVjdE5hbWU/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBidWlsZFNwZWM6IEJ1aWxkU3BlYztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBidWlsZEltYWdlPzogSUJ1aWxkSW1hZ2U7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNvbXB1dGVUeXBlPzogQ29tcHV0ZVR5cGU7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwcml2aWxlZ2VkPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdXBkYXRlQXBwcm92YWxTdGF0ZT86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcG9zdENvbW1lbnQ/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcm9sZT86IElSb2xlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB2cGM/OiBJVnBjO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzdWJuZXRTZWxlY3Rpb24/OiBTdWJuZXRTZWxlY3Rpb247XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNlY3VyaXR5R3JvdXBzPzogSVNlY3VyaXR5R3JvdXBbXTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhbGxvd0FsbE91dGJvdW5kPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZW52aXJvbm1lbnRWYXJpYWJsZXM/OiB7XG4gICAgW25hbWU6IHN0cmluZ106IEJ1aWxkRW52aXJvbm1lbnRWYXJpYWJsZTtcbiAgfTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhcnRpZmFjdHM/OiBJQXJ0aWZhY3RzO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFB1bGxSZXF1ZXN0Q2hlY2sgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBwcml2YXRlIHB1bGxSZXF1ZXN0UHJvamVjdDogUHJvamVjdDtcblxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFB1bGxSZXF1ZXN0Q2hlY2tQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCB7XG4gICAgICByZXBvc2l0b3J5LFxuICAgICAgYnVpbGRTcGVjLFxuICAgICAgYnVpbGRJbWFnZSA9IExpbnV4QnVpbGRJbWFnZS5TVEFOREFSRF80XzAsXG4gICAgICBjb21wdXRlVHlwZSA9IGJ1aWxkSW1hZ2UuZGVmYXVsdENvbXB1dGVUeXBlLFxuICAgICAgcHJpdmlsZWdlZCA9IGZhbHNlLFxuICAgICAgdXBkYXRlQXBwcm92YWxTdGF0ZSA9IHRydWUsXG4gICAgICBwb3N0Q29tbWVudCA9IHRydWUsXG4gICAgICBwcm9qZWN0TmFtZSA9IGAke3JlcG9zaXRvcnkucmVwb3NpdG9yeU5hbWV9LXB1bGwtcmVxdWVzdGAsXG4gICAgICByb2xlLFxuICAgICAgdnBjLFxuICAgICAgc3VibmV0U2VsZWN0aW9uLFxuICAgICAgc2VjdXJpdHlHcm91cHMsXG4gICAgICBhbGxvd0FsbE91dGJvdW5kLFxuICAgICAgZW52aXJvbm1lbnRWYXJpYWJsZXMsXG4gICAgICBhcnRpZmFjdHMsXG4gICAgfSA9IHByb3BzO1xuXG4gICAgdGhpcy5wdWxsUmVxdWVzdFByb2plY3QgPSBuZXcgUHJvamVjdCh0aGlzLCAnUHVsbFJlcXVlc3RQcm9qZWN0Jywge1xuICAgICAgcHJvamVjdE5hbWUsXG4gICAgICBzb3VyY2U6IFNvdXJjZS5jb2RlQ29tbWl0KHtcbiAgICAgICAgcmVwb3NpdG9yeSxcbiAgICAgIH0pLFxuICAgICAgZW52aXJvbm1lbnQ6IHtcbiAgICAgICAgYnVpbGRJbWFnZSxcbiAgICAgICAgY29tcHV0ZVR5cGUsXG4gICAgICAgIHByaXZpbGVnZWQsXG4gICAgICAgIGVudmlyb25tZW50VmFyaWFibGVzLFxuICAgICAgfSxcbiAgICAgIGJ1aWxkU3BlYyxcbiAgICAgIHJvbGUsXG4gICAgICB2cGMsXG4gICAgICBzdWJuZXRTZWxlY3Rpb24sXG4gICAgICBzZWN1cml0eUdyb3VwcyxcbiAgICAgIGFsbG93QWxsT3V0Ym91bmQsXG4gICAgICBhcnRpZmFjdHMsXG4gICAgfSk7XG5cbiAgICBpZiAodXBkYXRlQXBwcm92YWxTdGF0ZSB8fCBwb3N0Q29tbWVudCkge1xuICAgICAgY29uc3QgY29kZUJ1aWxkUmVzdWx0RnVuY3Rpb24gPSBuZXcgRnVuY3Rpb24odGhpcywgJ0NvZGVCdWlsZFJlc3VsdEZ1bmN0aW9uJywge1xuICAgICAgICBydW50aW1lOiBSdW50aW1lLk5PREVKU18xMl9YLFxuICAgICAgICBjb2RlOiBDb2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnbGFtYmRhcycsICdjb2RlLWJ1aWxkLXJlc3VsdCcpKSxcbiAgICAgICAgaGFuZGxlcjogJ2luZGV4LmhhbmRsZXInLFxuICAgICAgICBlbnZpcm9ubWVudDoge1xuICAgICAgICAgIFVQREFURV9BUFBST1ZBTF9TVEFURTogdXBkYXRlQXBwcm92YWxTdGF0ZSA/ICdUUlVFJyA6ICdGQUxTRScsXG4gICAgICAgICAgUE9TVF9DT01NRU5UOiBwb3N0Q29tbWVudCA/ICdUUlVFJyA6ICdGQUxTRScsXG4gICAgICAgIH0sXG4gICAgICB9KTtcblxuICAgICAgY29kZUJ1aWxkUmVzdWx0RnVuY3Rpb24uYWRkVG9Sb2xlUG9saWN5KFxuICAgICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICBlZmZlY3Q6IEVmZmVjdC5BTExPVyxcbiAgICAgICAgICByZXNvdXJjZXM6IFtyZXBvc2l0b3J5LnJlcG9zaXRvcnlBcm5dLFxuICAgICAgICAgIGFjdGlvbnM6IFsnY29kZWNvbW1pdDpQb3N0Q29tbWVudEZvclB1bGxSZXF1ZXN0JywgJ2NvZGVjb21taXQ6VXBkYXRlUHVsbFJlcXVlc3RBcHByb3ZhbFN0YXRlJ10sXG4gICAgICAgIH0pLFxuICAgICAgKTtcblxuICAgICAgdGhpcy5wdWxsUmVxdWVzdFByb2plY3Qub25TdGF0ZUNoYW5nZSgnUHVsbFJlcXVlc3RWYWxpZGF0aW9uUnVsZScsIHtcbiAgICAgICAgdGFyZ2V0OiBuZXcgTGFtYmRhRnVuY3Rpb24oY29kZUJ1aWxkUmVzdWx0RnVuY3Rpb24pLFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgY29uc3QgcnVsZSA9IHJlcG9zaXRvcnkub25QdWxsUmVxdWVzdFN0YXRlQ2hhbmdlKGAke3RoaXMubm9kZS5hZGRyfVJ1bGVgLCB7XG4gICAgICBldmVudFBhdHRlcm46IHtcbiAgICAgICAgZGV0YWlsOiB7XG4gICAgICAgICAgZXZlbnQ6IFsncHVsbFJlcXVlc3RTb3VyY2VCcmFuY2hVcGRhdGVkJywgJ3B1bGxSZXF1ZXN0Q3JlYXRlZCddLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIHJ1bGUuYWRkVGFyZ2V0KFxuICAgICAgbmV3IENvZGVCdWlsZFByb2plY3QodGhpcy5wdWxsUmVxdWVzdFByb2plY3QsIHtcbiAgICAgICAgZXZlbnQ6IFJ1bGVUYXJnZXRJbnB1dC5mcm9tT2JqZWN0KHtcbiAgICAgICAgICBzb3VyY2VWZXJzaW9uOiBFdmVudEZpZWxkLmZyb21QYXRoKCckLmRldGFpbC5zb3VyY2VDb21taXQnKSxcbiAgICAgICAgICBlbnZpcm9ubWVudFZhcmlhYmxlc092ZXJyaWRlOiBbXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgIG5hbWU6ICdwdWxsUmVxdWVzdElkJyxcbiAgICAgICAgICAgICAgdmFsdWU6IEV2ZW50RmllbGQuZnJvbVBhdGgoJyQuZGV0YWlsLnB1bGxSZXF1ZXN0SWQnKSxcbiAgICAgICAgICAgICAgdHlwZTogJ1BMQUlOVEVYVCcsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAge1xuICAgICAgICAgICAgICBuYW1lOiAncmVwb3NpdG9yeU5hbWUnLFxuICAgICAgICAgICAgICB2YWx1ZTogRXZlbnRGaWVsZC5mcm9tUGF0aCgnJC5kZXRhaWwucmVwb3NpdG9yeU5hbWVzWzBdJyksXG4gICAgICAgICAgICAgIHR5cGU6ICdQTEFJTlRFWFQnLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgbmFtZTogJ3NvdXJjZUNvbW1pdCcsXG4gICAgICAgICAgICAgIHZhbHVlOiBFdmVudEZpZWxkLmZyb21QYXRoKCckLmRldGFpbC5zb3VyY2VDb21taXQnKSxcbiAgICAgICAgICAgICAgdHlwZTogJ1BMQUlOVEVYVCcsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAge1xuICAgICAgICAgICAgICBuYW1lOiAnZGVzdGluYXRpb25Db21taXQnLFxuICAgICAgICAgICAgICB2YWx1ZTogRXZlbnRGaWVsZC5mcm9tUGF0aCgnJC5kZXRhaWwuZGVzdGluYXRpb25Db21taXQnKSxcbiAgICAgICAgICAgICAgdHlwZTogJ1BMQUlOVEVYVCcsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAge1xuICAgICAgICAgICAgICBuYW1lOiAncmV2aXNpb25JZCcsXG4gICAgICAgICAgICAgIHZhbHVlOiBFdmVudEZpZWxkLmZyb21QYXRoKCckLmRldGFpbC5yZXZpc2lvbklkJyksXG4gICAgICAgICAgICAgIHR5cGU6ICdQTEFJTlRFWFQnLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICBdLFxuICAgICAgICB9KSxcbiAgICAgIH0pLFxuICAgICk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgb25DaGVja0ZhaWxlZChpZDogc3RyaW5nLCBvcHRpb25zPzogT25FdmVudE9wdGlvbnMpOiBSdWxlIHtcbiAgICByZXR1cm4gdGhpcy5wdWxsUmVxdWVzdFByb2plY3Qub25CdWlsZEZhaWxlZChpZCwgb3B0aW9ucyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIG9uQ2hlY2tTdGFydGVkKGlkOiBzdHJpbmcsIG9wdGlvbnM/OiBPbkV2ZW50T3B0aW9ucyk6IFJ1bGUge1xuICAgIHJldHVybiB0aGlzLnB1bGxSZXF1ZXN0UHJvamVjdC5vbkJ1aWxkU3RhcnRlZChpZCwgb3B0aW9ucyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIG9uQ2hlY2tTdWNjZWVkZWQoaWQ6IHN0cmluZywgb3B0aW9ucz86IE9uRXZlbnRPcHRpb25zKTogUnVsZSB7XG4gICAgcmV0dXJuIHRoaXMucHVsbFJlcXVlc3RQcm9qZWN0Lm9uQnVpbGRTdWNjZWVkZWQoaWQsIG9wdGlvbnMpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWRkVG9Sb2xlUG9saWN5KHN0YXRlbWVudDogUG9saWN5U3RhdGVtZW50KTogdm9pZCB7XG4gICAgdGhpcy5wdWxsUmVxdWVzdFByb2plY3QuYWRkVG9Sb2xlUG9saWN5KHN0YXRlbWVudCk7XG4gIH1cbn1cbiJdfQ==