/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junitxml;

import io.qameta.allure.Reader;
import io.qameta.allure.context.RandomUidContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.datetime.CompositeDateTimeParser;
import io.qameta.allure.datetime.DateTimeParser;
import io.qameta.allure.datetime.LocalDateTimeParser;
import io.qameta.allure.datetime.ZonedDateTimeParser;
import io.qameta.allure.entity.LabelName;
import io.qameta.allure.entity.StageResult;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.Step;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.entity.Time;
import io.qameta.allure.junitxml.TestSuiteInfo;
import io.qameta.allure.parser.XmlElement;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class JunitXmlPlugin
implements Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JunitXmlPlugin.class);
    public static final String JUNIT_RESULTS_FORMAT = "junit";
    private static final BigDecimal MULTIPLICAND = new BigDecimal(1000);
    private static final String TEST_SUITE_ELEMENT_NAME = "testsuite";
    private static final String TEST_SUITES_ELEMENT_NAME = "testsuites";
    private static final String TEST_CASE_ELEMENT_NAME = "testcase";
    private static final String CLASS_NAME_ATTRIBUTE_NAME = "classname";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String TIME_ATTRIBUTE_NAME = "time";
    private static final String FAILURE_ELEMENT_NAME = "failure";
    private static final String ERROR_ELEMENT_NAME = "error";
    private static final String SKIPPED_ELEMENT_NAME = "skipped";
    private static final String MESSAGE_ATTRIBUTE_NAME = "message";
    private static final String RERUN_FAILURE_ELEMENT_NAME = "rerunFailure";
    private static final String RERUN_ERROR_ELEMENT_NAME = "rerunError";
    private static final String HOSTNAME_ATTRIBUTE_NAME = "hostname";
    private static final String TIMESTAMP_ATTRIBUTE_NAME = "timestamp";
    private static final String STATUS_ATTRIBUTE_NAME = "status";
    private static final String SKIPPED_ATTRIBUTE_VALUE = "notrun";
    private static final String SYSTEM_OUTPUT_ELEMENT_NAME = "system-out";
    private static final String XML_GLOB = "*.xml";
    private static final Map<String, Status> RETRIES = new HashMap<String, Status>();
    private final DateTimeParser parser;

    public JunitXmlPlugin() {
        this(ZoneOffset.systemDefault());
    }

    public JunitXmlPlugin(ZoneId defaultZoneId) {
        this.parser = new CompositeDateTimeParser(new DateTimeParser[]{new ZonedDateTimeParser(), new LocalDateTimeParser(defaultZoneId)});
    }

    public void readResults(Configuration configuration, ResultsVisitor visitor, Path directory) {
        RandomUidContext context = (RandomUidContext)configuration.requireContext(RandomUidContext.class);
        JunitXmlPlugin.listResults(directory).forEach(result -> this.parseRootElement(directory, (Path)result, context, visitor));
    }

    private void parseRootElement(Path resultsDirectory, Path parsedFile, RandomUidContext context, ResultsVisitor visitor) {
        try {
            LOGGER.debug("Parsing file {}", (Object)parsedFile);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            XmlElement rootElement = new XmlElement(builder.parse(parsedFile.toFile()).getDocumentElement());
            String elementName = rootElement.getName();
            if (TEST_SUITE_ELEMENT_NAME.equals(elementName)) {
                this.parseTestSuite(rootElement, parsedFile, context, visitor, resultsDirectory);
                return;
            }
            if (TEST_SUITES_ELEMENT_NAME.equals(elementName)) {
                rootElement.get(TEST_SUITE_ELEMENT_NAME).forEach(element -> this.parseTestSuite((XmlElement)element, parsedFile, context, visitor, resultsDirectory));
                return;
            }
            LOGGER.debug("File {} is not a valid JUnit xml. Unknown root element {}", (Object)parsedFile, (Object)elementName);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.error("Could not parse file {}: {}", (Object)parsedFile, (Object)e);
        }
    }

    private void parseTestSuite(XmlElement testSuiteElement, Path parsedFile, RandomUidContext context, ResultsVisitor visitor, Path resultsDirectory) {
        String name = testSuiteElement.getAttribute(NAME_ATTRIBUTE_NAME);
        String hostname = testSuiteElement.getAttribute(HOSTNAME_ATTRIBUTE_NAME);
        String timestamp = testSuiteElement.getAttribute(TIMESTAMP_ATTRIBUTE_NAME);
        TestSuiteInfo info = new TestSuiteInfo().setName(name).setHostname(hostname).setTimestamp(this.getUnix(timestamp));
        testSuiteElement.get(TEST_CASE_ELEMENT_NAME).forEach(element -> this.parseTestCase(info, (XmlElement)element, resultsDirectory, parsedFile, context, visitor));
    }

    private Long getUnix(String timestamp) {
        if (Objects.isNull(timestamp)) {
            return null;
        }
        return this.parser.getEpochMilli(timestamp).orElse(null);
    }

    private void parseTestCase(TestSuiteInfo info, XmlElement testCaseElement, Path resultsDirectory, Path parsedFile, RandomUidContext context, ResultsVisitor visitor) {
        String className = testCaseElement.getAttribute(CLASS_NAME_ATTRIBUTE_NAME);
        Status status = this.getStatus(testCaseElement);
        TestResult result = this.createStatuslessTestResult(info, testCaseElement, parsedFile, context);
        result.setStatus(status);
        result.setFlaky(this.isFlaky(testCaseElement));
        this.setStatusDetails(result, testCaseElement);
        StageResult stageResult = new StageResult();
        this.getLogMessage(testCaseElement).ifPresent(logMessage -> {
            List<String> lines = this.splitLines((String)logMessage);
            List steps = lines.stream().map(line -> new Step().setName(line)).collect(Collectors.toList());
            stageResult.setSteps(steps);
        });
        this.getLogFile(resultsDirectory, className).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(arg_0 -> ((ResultsVisitor)visitor).visitAttachmentFile(arg_0)).map(attachment1 -> attachment1.setName("System out")).ifPresent(attachment -> stageResult.setAttachments(Collections.singletonList(attachment)));
        result.setTestStage(stageResult);
        visitor.visitTestResult(result);
        RETRIES.forEach((elementName, retryStatus) -> testCaseElement.get(elementName).forEach(failure -> {
            TestResult retried = this.createStatuslessTestResult(info, testCaseElement, parsedFile, context);
            retried.setHidden(true);
            retried.setStatus(retryStatus);
            retried.setStatusMessage(failure.getAttribute(MESSAGE_ATTRIBUTE_NAME));
            retried.setStatusTrace(failure.getValue());
            visitor.visitTestResult(retried);
        }));
    }

    private List<String> splitLines(String str) {
        return Arrays.asList(str.split("\\r?\\n"));
    }

    private Optional<String> getLogMessage(XmlElement testCaseElement) {
        return testCaseElement.getFirst(SYSTEM_OUTPUT_ELEMENT_NAME).map(XmlElement::getValue);
    }

    private Optional<Path> getLogFile(Path resultsDirectory, String className) {
        try {
            return Optional.ofNullable(className).map(name -> name + ".txt").map(resultsDirectory::resolve);
        }
        catch (InvalidPathException e) {
            LOGGER.debug("Can not find log file: invalid className {}", (Object)className, (Object)e);
            return Optional.empty();
        }
    }

    private TestResult createStatuslessTestResult(TestSuiteInfo info, XmlElement testCaseElement, Path parsedFile, RandomUidContext context) {
        String className = testCaseElement.getAttribute(CLASS_NAME_ATTRIBUTE_NAME);
        Optional<String> suiteName = JunitXmlPlugin.firstNotNull(info.getName(), className);
        String name = testCaseElement.getAttribute(NAME_ATTRIBUTE_NAME);
        String historyId = String.format("%s:%s#%s", info.getName(), className, name);
        TestResult result = new TestResult();
        if (Objects.nonNull(className) && Objects.nonNull(name)) {
            result.setHistoryId(historyId);
        }
        result.setUid((String)context.getValue().get());
        result.setName(Objects.isNull(name) ? "Unknown test case" : name);
        result.setTime(this.getTime(info.getTimestamp(), testCaseElement, parsedFile));
        result.addLabelIfNotExists(LabelName.RESULT_FORMAT, JUNIT_RESULTS_FORMAT);
        suiteName.ifPresent(s -> result.addLabelIfNotExists(LabelName.SUITE, s));
        if (Objects.nonNull(info.getHostname())) {
            result.addLabelIfNotExists(LabelName.HOST, info.getHostname());
        }
        if (Objects.nonNull(className)) {
            result.addLabelIfNotExists(LabelName.TEST_CLASS, className);
            result.addLabelIfNotExists(LabelName.PACKAGE, className);
        }
        return result;
    }

    private Status getStatus(XmlElement testCaseElement) {
        if (testCaseElement.contains(FAILURE_ELEMENT_NAME)) {
            return Status.FAILED;
        }
        if (testCaseElement.contains(ERROR_ELEMENT_NAME)) {
            return Status.BROKEN;
        }
        if (testCaseElement.contains(SKIPPED_ELEMENT_NAME)) {
            return Status.SKIPPED;
        }
        if (testCaseElement.containsAttribute(STATUS_ATTRIBUTE_NAME) && testCaseElement.getAttribute(STATUS_ATTRIBUTE_NAME).equals(SKIPPED_ATTRIBUTE_VALUE)) {
            return Status.SKIPPED;
        }
        return Status.PASSED;
    }

    private void setStatusDetails(TestResult result, XmlElement testCaseElement) {
        Stream.of(FAILURE_ELEMENT_NAME, ERROR_ELEMENT_NAME, SKIPPED_ELEMENT_NAME).filter(arg_0 -> ((XmlElement)testCaseElement).contains(arg_0)).map(arg_0 -> ((XmlElement)testCaseElement).get(arg_0)).filter(elements -> !elements.isEmpty()).flatMap(Collection::stream).findFirst().ifPresent(element -> {
            result.setStatusMessage(element.getAttribute(MESSAGE_ATTRIBUTE_NAME));
            result.setStatusTrace(element.getValue());
        });
    }

    private Time getTime(Long suiteStart, XmlElement testCaseElement, Path parsedFile) {
        if (testCaseElement.containsAttribute(TIME_ATTRIBUTE_NAME)) {
            try {
                long duration = BigDecimal.valueOf(testCaseElement.getDoubleAttribute(TIME_ATTRIBUTE_NAME)).multiply(MULTIPLICAND).longValue();
                return Objects.nonNull(suiteStart) ? new Time().setStart(suiteStart).setStop(Long.valueOf(suiteStart + duration)).setDuration(Long.valueOf(duration)) : new Time().setDuration(Long.valueOf(duration));
            }
            catch (Exception e) {
                LOGGER.debug("Could not parse time attribute for element {} in file {}", new Object[]{testCaseElement, parsedFile, e});
            }
        }
        return new Time();
    }

    private boolean isFlaky(XmlElement testCaseElement) {
        return testCaseElement.contains(RERUN_ERROR_ELEMENT_NAME) || testCaseElement.contains(RERUN_FAILURE_ELEMENT_NAME);
    }

    private static List<Path> listResults(Path directory) {
        ArrayList<Path> result = new ArrayList<Path>();
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return result;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, XML_GLOB);){
            for (Path path : directoryStream) {
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                result.add(path);
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not read data from {}: {}", (Object)directory, (Object)e);
        }
        return result;
    }

    private static Optional<String> firstNotNull(String ... values) {
        return Stream.of(values).filter(Objects::nonNull).findFirst();
    }

    static {
        RETRIES.put(RERUN_FAILURE_ELEMENT_NAME, Status.FAILED);
        RETRIES.put(RERUN_ERROR_ELEMENT_NAME, Status.BROKEN);
    }
}

