/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.internal;

import com.javonet.core.runtime.IEmbeddedRuntime;
import com.javonet.core.transmitter.Transmitter;
import com.javonet.sdk.internal.AbstractRuntimeFactory;
import com.javonet.sdk.internal.RuntimeContext;
import com.javonet.utils.BinariesUnloader;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.TcpConnectionData;
import java.io.IOException;
import java.util.Optional;

public class RuntimeFactory
implements AbstractRuntimeFactory {
    private final ConnectionType connectionType;
    private final Optional<TcpConnectionData> tcpAddress;

    public RuntimeFactory(ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress) {
        this.connectionType = connectionType;
        this.tcpAddress = tcpAddress;
    }

    public RuntimeFactory(ConnectionType connectionType) {
        this.connectionType = connectionType;
        this.tcpAddress = Optional.empty();
    }

    @Override
    public RuntimeContext clr() {
        return RuntimeContext.getInstance(RuntimeName.Clr, this.connectionType, this.tcpAddress);
    }

    @Override
    public RuntimeContext go() {
        return RuntimeContext.getInstance(RuntimeName.Go, this.connectionType, this.tcpAddress);
    }

    @Override
    public RuntimeContext jvm() {
        return RuntimeContext.getInstance(RuntimeName.Jvm, this.connectionType, this.tcpAddress);
    }

    @Override
    public RuntimeContext netcore() {
        return RuntimeContext.getInstance(RuntimeName.Netcore, this.connectionType, this.tcpAddress);
    }

    @Override
    public RuntimeContext perl() {
        return RuntimeContext.getInstance(RuntimeName.Perl, this.connectionType, this.tcpAddress);
    }

    @Override
    public RuntimeContext ruby() {
        return RuntimeContext.getInstance(RuntimeName.Ruby, this.connectionType, this.tcpAddress);
    }

    @Override
    public RuntimeContext nodejs() {
        return RuntimeContext.getInstance(RuntimeName.Nodejs, this.connectionType, this.tcpAddress);
    }

    @Override
    public RuntimeContext python() {
        return RuntimeContext.getInstance(RuntimeName.Python, this.connectionType, this.tcpAddress);
    }

    public RuntimeContext setEmbeddedRuntime(IEmbeddedRuntime runtime, String path) throws IOException {
        BinariesUnloader.extractBinariesFromJar(runtime.getRuntimeLib());
        byte[] bytes = runtime.getRuntimeBytes();
        Transmitter.deployRuntime(bytes, path, (byte)runtime.getRuntimeVersion());
        Transmitter.setEmbeddedRuntime((byte)runtime.getRuntimeLib().ordinal(), (byte)runtime.getRuntimeVersion(), path);
        return RuntimeContext.getInstance(runtime.getRuntimeLib(), this.connectionType, this.tcpAddress);
    }
}

