BioCManagerLibraries <- c()
requiredLibraries <- c(BioCManagerLibraries, 
                       "shiny",
                       "visNetwork",
                       "igraph",
                       "DT",
                       "shinyWidgets",
                       "ggVennDiagram",
                       "ggplot2",
                       "readxl",
                       "shinythemes",
                       "VennDiagram",
                       "nVennR",
                       'dplyr',
                       'dbplyr',
                       "stringr",
                       'DBI',
                       'pool',
                       'shinyjs',
                       'shinydashboard',
                       'sf',
                       'randomcoloR')

for (packageName in requiredLibraries){
  if (!is.element(packageName, installed.packages()[,1])){
    print(paste("Installing package: ", packageName))
    if (packageName %in% BioCManagerLibraries) {
      BiocManager::install(packageName, type="binary")#INSTALL_opts = '--no-lock')
    }
    else {
      install.packages(packageName, dependencies = TRUE, INSTALL_opts = '--no-lock')
    }
    
  } 
  
  suppressMessages(library(packageName, character.only = TRUE))
  print(paste("Loaded package: ", packageName))
  
}
