# connnect to the server
conn <- pool::dbPool(
  drv = RMySQL::MySQL(),
  dbname = "",
  host = "",
  username = "",
  password = ""
)

# conn <- pool::dbPool(
#   drv = RMySQL::MySQL(),
#   dbname = "SLKB_mysql_live",
#   host = "localhost",
#   username = "root",
#   password = "password"
# )
# conn <- pool::dbPool(drv = RSQLite::SQLite(),
#                     dbname = "SLKB_sqlite3")

init.study_SL <- 'SELECT * FROM cdko_original_sl_results'
init.experiment_designs <- 'SELECT * FROM cdko_experiment_design'
init.study_counts <- 'SELECT * from joined_counts'

# users can run the command directly
#init.computed_SL <- "SELECT * from calculated_sl_table"

# my sql specific
#dbGetQuery(conn, sqlInterpolate(conn, "SET sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''));"))

experiment_design_init <-  dbGetQuery(conn, sqlInterpolate(conn, init.experiment_designs))
study_counts_init <- dbGetQuery(conn, sqlInterpolate(conn, init.study_counts))
study_SL_init <-  dbGetQuery(conn, sqlInterpolate(conn, init.study_SL))

# users can load a file for scores as well
#computed_SL_init <- dbGetQuery(conn, sqlInterpolate(conn, init.computed_SL))
computed_SL_init <- read.csv('')[,-c(1)]

# # create gene pair column (if taken from calculated_sl_table)
# sorted_pairs <- c()
# for (i in seq(dim(computed_SL_init)[1])){
#   gene_1 <- computed_SL_init$gene_1[i]
#   gene_2 <- computed_SL_init$gene_2[i]
#   sorted <- paste(sort(c(gene_1, gene_2)), collapse = '|')
#   sorted_pairs <- c(sorted_pairs, sorted)
# }
# computed_SL_init$gene_pair <- sorted_pairs

# get data annotations
data_annotations_orig <- readxl::read_excel("www/SLKB_Studies.xlsx", skip = 1, sheet = "Sheet1")

source('server_func/browse_data_server.R', local = TRUE)
source('server_func/compareSL_server.R', local = TRUE)
source('server_func/download_data_server.R', local = TRUE)
source('server_func/browse_network_server.R', local = TRUE)
source('server_func/KB_query_server.R', local = TRUE)
source('server_func/data_description_server.R', local = TRUE)

server <- function(input, output, session) {
  
  browseDataServer("browse_data")
  browseDataServer("browse_data_processed")
  browseDataServer("browse_network")
  
  CompareSLServer("compare_SL")
  downloadDataServer("download_data")
  KBQueryServer("KB_query")
  dataDescriptionServer("data_description")

}
