get_top_n_pairs <- function(curr_scores, score_name, top_n_pairs){
  if (score_name == "gemini_score_SL_score_Strong"){
    curr_scores <- curr_scores[order(curr_scores[[score_name]], decreasing = T), ]
  } else {
    curr_scores <- curr_scores[order(curr_scores[[score_name]], decreasing = F), ]
  }
  
  # remove the NA ones (if possible)
  curr_scores <- curr_scores[!(is.na(curr_scores[[score_name]])),]
  
  # in the case the remaining scores are less (too many NAs, in case)
  top_pairs_to_get <- min(top_n_pairs, dim(curr_scores)[1])
  return(curr_scores$gene_pair[1:top_pairs_to_get])
  
}



CompareSLServer <- function(id) {
  moduleServer(
    id,
    function(input, output, session) {
      
      ns <- session$ns
      
      get_n_percent <- function(curr_table, category, n = 10){
        curr_table <- curr_table[!(is.na(curr_table[[category]])), ]
        sample_size <- 1:min(floor(dim(curr_table)[1] * (n / 100)), dim(curr_table)[1])
        
        if (category == 'gemini_score_SL_score_Strong'){
          temp <- order(curr_table[[category]], decreasing = T)
        } else {
          temp <- order(curr_table[[category]], decreasing = F)
        }
        return(curr_table[temp[sample_size], 'gene_pair'])
      }
      get_n_percent_threshold <- function(curr_table, category, n = 10){
        curr_table <- curr_table[!(is.na(curr_table[[category]])), ]
        sample_size <- min(floor(dim(curr_table)[1] * (n / 100)), dim(curr_table)[1])
        
        if (category == 'gemini_score_SL_score_Strong'){
          temp <- order(curr_table[[category]], decreasing = T)
        } else {
          temp <- order(curr_table[[category]], decreasing = F)
        }
        
        return(curr_table[temp, category][sample_size])
      }
      
      # adapted from https://stackoverflow.com/questions/68875752/how-to-edit-ggvenndiagram-intersection-fill-region
      create_plot <- function(pair_list){
        
        venn <- Venn(pair_list)
        d <- process_data(venn)
        d2 <- process_data(venn)
        
        d2@region <- st_polygonize(d@setEdge)
        
        col <- c('Median-B/NB' = 'yellow', 'Horlbeck Score' = 'blue', 'GEMINI Score' = 'orange','MAGECK Score' = 'gray', 'sgRNA Derived-B/NB' = 'green')
        
        return(ggplot() +
                 geom_sf(aes(fill = name), data = venn_region(d2), show.legend = F) +
                 geom_sf(aes(color = name), data = venn_setedge(d), show.legend = F) +
                 geom_sf_text(aes(label = name), data = venn_setlabel(d), show.legend = F) +
                 geom_sf_text(aes(label = count), data = venn_region(d), show.legend = F) +
                 scale_color_manual(values = alpha(col, .3)) +
                 scale_fill_manual(values = alpha(col, .3)) +
                 theme_void())
      }
      
      #
      SLKB_scores_sl_pairs <- list("Horlbeck Score" = get_n_percent(computed_SL_init, 'horlbeck_score_SL_score', 10),
                                   "Median-B/NB" = get_n_percent(computed_SL_init, 'median_nb_score_Z_SL_score', 10),
                                   "sgRNA Derived-B/NB" = get_n_percent(computed_SL_init, 'sgrna_derived_nb_score_SL_score', 10),
                                   "MAGECK Score" = get_n_percent(computed_SL_init, 'mageck_score_Z_SL_score', 10),
                                   "GEMINI Score" = get_n_percent(computed_SL_init, 'gemini_score_SL_score_Strong', 10))
      
      ## For Browse Data
      reactive_data <- reactiveValues(table = computed_SL_init,
                                      SL_pairs = SLKB_scores_sl_pairs,
                                      venn_plot = create_plot(SLKB_scores_sl_pairs),#ggVennDiagram
                                      coloring = NULL,
                                      show = FALSE)
      
      scores_to_pairs <- function(score_category, cutoff){
        
        if (score_category == 'gemini_score_SL_score_Strong'){
          idx <- reactive_data$table[!(is.na(reactive_data$table)), score_category] > cutoff
        } else {
          idx <- reactive_data$table[!(is.na(reactive_data$table)), score_category] < cutoff
        }
        
        return(reactive_data$table[!(is.na(reactive_data$table)), 'gene_pair'][idx])
      }
      
      
      
      output$choose_data_source <- renderUI({
        
        sources <- paste0(data_annotations_orig$Study, ' (', data_annotations_orig$`Pubmed ID`,')')
        selectInput(ns("ChosenDataForVenn"), "Data Sources :",
                    sources)
      })
      
      output$choose_cl_source <- renderUI({
        
        curr_study <- unique(reactive_data$table$study_origin)
        
        if (length(curr_study) > 1){
          cell_lines <- sort(unique(reactive_data$table$cell_line_origin))
        } else {
          cell_lines <- sort(unique(reactive_data$table$cell_line_origin[reactive_data$table$study_origin == curr_study]))
        }
        
        if (length(cell_lines) > 1){
          cell_lines <- c("All Cell Lines", cell_lines)
        }
        selectInput(ns("ChosenCLForVenn"), "Cell Lines :",
                    cell_lines)
      })
      
      observeEvent(input$choose_comparison_button_1, {
        reactive_data$show <- FALSE
        print(paste("1. Browse", input$ChosenDataForVenn))
        
        
        if (grepl('All Studies', input$ChosenDataForVenn, fixed = T)){
          curr.graph <- computed_SL_init
          
        } else {
          curr.graph <- computed_SL_init
          
          study <- gsub(".*\\((.*)\\).*", "\\1", input$ChosenDataForVenn)
          
          # # choose data
          curr.graph <- curr.graph[curr.graph$study_origin == study, ]
        }
        reactive_data$table <- curr.graph
        
        # disable after choosing study
        shinyjs::disable("downloadPairs")
      })
      
      observeEvent(input$choose_comparison_button_2, {
        print(paste("2. Browse", input$ChosenCLForVenn))
        
        curr.graph <- computed_SL_init
        
        study <- gsub(".*\\((.*)\\).*", "\\1", input$ChosenDataForVenn)
        
        # first, filter based on the study, then the cell line
        if (!grepl('All Studies', input$ChosenDataForVenn, fixed = T)){
          curr.graph <- curr.graph[curr.graph$study_origin == study, ]
        }
        
        if (input$ChosenCLForVenn != "All Cell Lines"){
          curr.graph <- curr.graph[curr.graph$cell_line_origin == input$ChosenCLForVenn, ]
        }
        
        reactive_data$table <- curr.graph
        
        median_cat <- 'median_nb_score_Z_SL_score'
        if (sum(is.na(curr.graph[['median_nb_score_Z_SL_score']])) != dim(curr.graph)[1]){
          print('median_b_score_Z_SL_score')
          median_cat <- 'median_b_score_Z_SL_score'
        }
        
        sgRNA_cat <- 'sgrna_derived_nb_score_SL_score'
        if (sum(is.na(curr.graph[['sgrna_derived_nb_score_SL_score']])) != dim(curr.graph)[1]){
          print('switching to sgrna_derived_b_score_SL_score')
          sgRNA_cat <- 'sgrna_derived_b_score_SL_score'
        }
        
        reactive_data$SL_pairs <- list("Horlbeck Score" = get_n_percent(curr.graph, 'horlbeck_score_SL_score', 10),
                                       "Median-B/NB" = get_n_percent(curr.graph, median_cat, 10),
                                       "sgRNA Derived-B/NB" = get_n_percent(curr.graph, sgRNA_cat, 10),
                                       "MAGECK Score" = get_n_percent(curr.graph, 'mageck_score_Z_SL_score', 10),
                                       "GEMINI Score" = get_n_percent(curr.graph, 'gemini_score_SL_score_Strong', 10))
        
        reactive_data$venn_plot <- create_plot(reactive_data$SL_pairs)#ggVennDiagram
        
        horlbeck_treshold <- get_n_percent_threshold(curr.graph, 'horlbeck_score_SL_score', 10)
        median_treshold <- get_n_percent_threshold(curr.graph, median_cat, 10)
        sgRNA_treshold <- get_n_percent_threshold(curr.graph, sgRNA_cat, 10)
        mageck_treshold <- get_n_percent_threshold(curr.graph, 'mageck_score_Z_SL_score', 10)
        gemini_treshold <- get_n_percent_threshold(curr.graph, 'gemini_score_SL_score_Strong', 10)
        
        updateTextInput(session, "Median_B_NB", placeholder = paste("Top 10% Threshold:", median_treshold))
        updateTextInput(session, "sgRNA_Derived_B_NB", placeholder = paste("Top 10% Threshold:", sgRNA_treshold))
        updateTextInput(session,"Horlbeck_Score", placeholder = paste("Top 10% Threshold:", horlbeck_treshold))
        updateTextInput(session, "GEMINI_Score", placeholder = paste("Top 10% Threshold:", gemini_treshold))
        updateTextInput(session, "MAGECK_Score", placeholder = paste("Top 10% Threshold:", mageck_treshold))
        
        
        reactive_data$show <- TRUE
        
        # enable after choosing cell line
        shinyjs::enable("downloadPairs")
      })

      output$venn_diagram <- renderPlot(
        if (reactive_data$show){
          reactive_data$venn_plot
        }
      )
      
      observeEvent(input$Median_B_NB_button, {
        print("Updating Proposed Approach 1")
        print(input$Median_B_NB)
        
        median_cat <- 'median_nb_score_Z_SL_score'
        if (sum(is.na(reactive_data$table[['median_nb_score_Z_SL_score']])) != dim(reactive_data$table)[1]){
          print('MEDIAN_B_SCORE_Z_SL_scor')
          median_cat <- 'median_b_score_Z_SL_score'
        }
        
        if (input$Median_B_NB == ""){
          
          reactive_data$SL_pairs[["Median-B/NB"]] <- get_n_percent(reactive_data$table, median_cat, 10)
          
        } else if (!is.na(as.numeric(input$Median_B_NB))){
          
          reactive_data$SL_pairs[["Median-B/NB"]] <- scores_to_pairs(median_cat, as.numeric(input$Median_B_NB))
          
        }
        
        reactive_data$venn_plot <- create_plot(reactive_data$SL_pairs)#ggVennDiagram
        
      })
      
      observeEvent(input$sgRNA_Derived_B_NB_button, {
        print("Updating Proposed Approach 2")
        print(input$sgRNA_Derived_B_NB)
        
        sgRNA_cat <- 'sgrna_derived_nb_score_SL_score'
        if (sum(is.na(reactive_data$table[['sgrna_derived_nb_score_SL_score']])) != dim(reactive_data$table)[1]){
          print('switching to sgrna_derived_b_score_SL_score')
          sgRNA_cat <- 'sgrna_derived_b_score_SL_score'
        }
        
        if (input$sgRNA_Derived_B_NB == ""){
          
          reactive_data$SL_pairs[["sgRNA Derived-B/NB"]] <- get_n_percent(reactive_data$table, sgRNA_cat, 10)
          
          
        } else if (!is.na(as.numeric(input$sgRNA_Derived_B_NB))){
          
          reactive_data$SL_pairs[["sgRNA Derived-B/NB"]] <- scores_to_pairs(sgRNA_cat, as.numeric(input$sgRNA_Derived_B_NB))
          
        }
        
        reactive_data$venn_plot <- create_plot(reactive_data$SL_pairs)#ggVennDiagram
        
        
      })
      
      observeEvent(input$Horlbeck_Score_button, {
        print("Updating Horlbeck Approach")
        print(input$Horlbeck_Score)
        
        if (input$Horlbeck_Score == ""){
          
          reactive_data$SL_pairs[["Horlbeck Score"]] <- get_n_percent(reactive_data$table, 'horlbeck_score_SL_score', 10)
          
        } else if (!is.na(as.numeric(input$Horlbeck_Score))){
          
          reactive_data$SL_pairs[["Horlbeck Score"]] <- scores_to_pairs("horlbeck_score_SL_score", as.numeric(input$Horlbeck_Score))
          
        }
        reactive_data$venn_plot <- create_plot(reactive_data$SL_pairs)#ggVennDiagram
        
      })
      
      observeEvent(input$GEMINI_Score_button, {
        print("Updating GEMINI Approach")
        print(input$GEMINI_Score)
        
        if (input$GEMINI_Score == ""){
          
          reactive_data$SL_pairs[["GEMINI Score"]] <- get_n_percent(reactive_data$table, 'gemini_score_SL_score_Strong', 10)
          
        } else if (!is.na(as.numeric(input$GEMINI_Score))){
          
          reactive_data$SL_pairs[["GEMINI Score"]] <- scores_to_pairs("gemini_score_SL_score_Strong", as.numeric(input$GEMINI_Score))
          
        }
        
        reactive_data$venn_plot <- create_plot(reactive_data$SL_pairs)#ggVennDiagram
        
      })
      
      observeEvent(input$MAGECK_Score_button, {
        print("Updating MAGECK Approach")
        print(input$MAGECK_Score)

        if (input$MAGECK_Score == ""){
          
          reactive_data$SL_pairs[["MAGECK Score"]] <- get_n_percent(reactive_data$table, 'mageck_score_Z_SL_score', 10)
          
        } else if (!is.na(as.numeric(input$MAGECK_Score))){
          
          reactive_data$SL_pairs[["MAGECK Score"]] <- scores_to_pairs("mageck_score_Z_SL_score", as.numeric(input$MAGECK_Score))
          
        }
        
        reactive_data$venn_plot <- create_plot(reactive_data$SL_pairs)#ggVennDiagram
        
      })
      
      output$downloadPairs <- downloadHandler(
        filename = 'SLKB_SL_pairs_by_approach.csv',
        content = function(file) {
          
          # create the majority vote file
          majority_vote <- reactive_data$SL_pairs
          voted_pairs <- unlist(majority_vote, recursive = FALSE)
          voted_pairs <- sort(table(voted_pairs), decreasing = T)
          
          # get overlapping info for context
          overlapping_pairs <- sort(voted_pairs[Reduce(intersect, majority_vote)], decreasing = T)
          
          # annotation for each SL gene/pair
          participation_table_pairs <- matrix(0, nrow = length(voted_pairs), ncol = length(majority_vote), dimnames = list(names(voted_pairs), names(majority_vote)))
          
          # set 1 at locations indicated by the approach
          for (item in rownames(participation_table_pairs)){
            for (strategy in colnames(participation_table_pairs)){
              if (item %in% majority_vote[[strategy]]){
                participation_table_pairs[item, strategy] <- 1
              }
            }
          }
          
          total_count <- rowSums(participation_table_pairs)
          participation_table_pairs <- cbind(participation_table_pairs[names(total_count),], total_count)
          
          write.csv(participation_table_pairs, file, row.names = T)
        },
        contentType = 'text/csv'
      )
      
      # disable on load
      shinyjs::disable("downloadPairs")
      
      
    }
  )
}
