downloadDataServer <- function(id) {
  moduleServer(
    id,
    function(input, output, session) {
      
      ns <- session$ns
      
      set_width <- '90%'
      set_height <- NULL
      
      output$graphical_img <- renderImage({

        #width  <- session$clientData$output_fig1_width
        #height <- session$clientData$output_fig1_height

        list(src = "www/Graphical_Overview.png",
             contentType = "image/png",
             alt = "",
             width = '70%',
             height =  set_height
        )
      }, deleteFile = F)#, outputArgs = list(width = "50px", height = "50px")

      output$graphical <- renderUI({
        imageOutput(ns("graphical_img"), height = '100%')
      })
      
      output$tutorial_fig1_img <- renderImage({
        
        list(src = "www/Tutorial_Fig1.png",
             contentType = "image/png",
             alt = "",
             width = set_width,
             height =  set_height
        )
      }, deleteFile = F)
      
      output$tutorial_fig1 <- renderUI({
        imageOutput(ns("tutorial_fig1_img"), height = '100%')
      })
      
      output$tutorial_fig2_img <- renderImage({
        
        list(src = "www/Tutorial_Fig2.png",
             contentType = "image/png",
             alt = "",
             width = set_width,
             height =  set_height
        )
      }, deleteFile = F)
      
      output$tutorial_fig2 <- renderUI({
        imageOutput(ns("tutorial_fig2_img"), height = '100%')
      })
      
      output$tutorial_fig3_img <- renderImage({
        
        list(src = "www/Tutorial_Fig3.png",
             contentType = "image/png",
             alt = "",
             width = set_width,
             height =  set_height
        )
      }, deleteFile = F)
      
      output$tutorial_fig3 <- renderUI({
        imageOutput(ns("tutorial_fig3_img"), height = '100%')
      })
      
      output$tutorial_fig4_img <- renderImage({
        
        list(src = "www/Tutorial_Fig4.png",
             contentType = "image/png",
             alt = "",
             width = set_width,
             height =  set_height
        )
      }, deleteFile = F)
      
      output$tutorial_fig4 <- renderUI({
        imageOutput(ns("tutorial_fig4_img"), height = '100%')
      })
      
      output$tutorial_fig5_img <- renderImage({
        
        list(src = "www/Tutorial_Fig5.png",
             contentType = "image/png",
             alt = "",
             width = set_width,
             height =  set_height
        )
      }, deleteFile = F)
      
      output$tutorial_fig5 <- renderUI({
        imageOutput(ns("tutorial_fig5_img"), height = '100%')
      })
      
      output$rawSL <- downloadHandler(
        filename <- 'SLKB_original_scores.csv',
        content <- function(file) {
          data.all <- study_SL_init
          write.csv(data.all[, -c(1,2)], file)
        },
        contentType = 'text/csv'
      )
      
      output$calcSL <- downloadHandler(
        filename <- 'SLKB_calculated_scores.csv',
        content <- function(file) {
          data.calc <- computed_SL_init
          write.csv(data.calc[, -c(1)], file)
        },
        contentType = 'text/csv'
      )
      
      output$predSL <- downloadHandler(
        filename <- 'SLKB_predictions.xlsx',
        content <- function(file) {
          file.copy("www/SLKB_predictions.xlsx", file)
        },
        contentType = 'application/vnd.ms-excel'
      )
    }
  )
}