library("shinythemes")

source('ui_func/overview_ui.R')
source('ui_func/tutorial_ui.R')
source('ui_func/data_ui.R')
source('ui_func/network_ui.R')
source('ui_func/download_ui.R')
source('ui_func/SL_ID_ui.R')
source('ui_func/KB_query_ui.R')
source('ui_func/data_description_ui.R')


#shinytheme("superhero")
ui <- fluidPage(theme = shinytheme("yeti"),
                shinyjs::useShinyjs(),
                shiny::tags$link(rel = "icon", href = "icons/favicon.png"),
                 navbarPage('SLKB',
                            overview.UI("download_data"),
                            tutorial.UI("download_data"),
                            data_description.UI("data_description"),
                            KB_query.UI("KB_query"),
                            SL_ID.UI("compare_SL"),
                            data.UI("browse_data"),
                            network.UI("browse_network"),
                            download.UI("download_data")
                 ),
)
