KB_query.UI <- function(id){
  ns <- NS(id)

  tabPanel("Query KB",

           #query at the top of the page
           fluidPage(
             fluidRow(
               column(4, align="center",
                      textInput(ns("query_gene"), "Enter gene(s) seperated by ;", value = "", width = NULL, placeholder = "e.g., AKT1; AMBRA1"),
                      checkboxInput(ns("either_or"), "Only contains selected genes?", FALSE),
               ),
               column(4, align="center",
                      textInput(ns("query_study"), "Enter study(s) Pubmed ID seperated by ;", value = "", width = NULL, placeholder = "e.g., 33956155"),
                      checkboxInput(ns("study_legend"), "Use Pubmed ID as plot annotation?", TRUE),
                      actionButton(ns("begin_query"), "Search")
               ),
               column(4, align="center",
                      textInput(ns("query_cl"), "Enter cell line(s) seperated by ;", value = "", width = NULL, placeholder = "e.g., RPE1"),
                      checkboxInput(ns("cl_legend"), "Use cell line as plot_annotation?", FALSE)
               )
             ),
             fluidRow(
               tabsetPanel(
                 tabPanel("Experiment Design", DT::dataTableOutput(ns("experiment_design"))),
                 tabPanel("Study SL Counts", DT::dataTableOutput(ns("study_counts"))),
                 tabPanel("Study Reported SL Scores", DT::DTOutput(ns("study_SL"))),
                 tabPanel("Study Reported SL Network", visNetworkOutput(ns("draw_network"), height = "800px"),
                                                      downloadButton(ns('downloadNetwork'), 'Download interactive network')
                          ),
                 tabPanel("SLKB Calculated SL Scores", DT::DTOutput(ns("computed_SL")))
                 
               )
             )

           )
  )
}
