
SL_ID.UI <- function(id){
  ns <- NS(id)
  tabPanel("Compare SL Approaches",
           sidebarLayout(
             sidebarPanel(
               uiOutput(ns("choose_data_source")),
               actionButton(ns("choose_comparison_button_1"), "1. Choose Data"),
               uiOutput(ns("choose_cl_source")),
               actionButton(ns("choose_comparison_button_2"), "2. Apply"),
               ###
               
               ###
               p('Default: top 10%. Median-NB and sgRNA-Derived-NB are used if Median-B and sgRNA-Derived-B are unavailable.'),
               textInput(ns("Median_B_NB"), "Median-B/NB Score (Lower = Stronger)", value = "", placeholder = "-"),
               actionButton(ns("Median_B_NB_button"), "Filter Median-B/NB"),
               textInput(ns("sgRNA_Derived_B_NB"), "sgRNA-Derived-B/NB Score (Lower = Stronger)", value = "", placeholder = "-"),
               actionButton(ns("sgRNA_Derived_B_NB_button"), "Filter sgRNA-Derived-B/NB"),
               textInput(ns("Horlbeck_Score"), "Horlbeck Score (Lower = Stronger)", value = "", placeholder = "-"),
               actionButton(ns("Horlbeck_Score_button"), "Filter Horlbeck"),
               textInput(ns("GEMINI_Score"), "GEMINI Score (Higher = Stronger)", value = "", placeholder = "-"),
               actionButton(ns("GEMINI_Score_button"), "Filter GEMINI"),
               textInput(ns("MAGECK_Score"), "MAGECK Score (Lower = Stronger)", value = "", placeholder = "-"),
               actionButton(ns("MAGECK_Score_button"), "Filter MAGECK"),
               p('Download SL Pairs From Venn Diagram. Table of 1s and 0s based on prediction (Default: top 10%).'),
               downloadButton(ns("downloadPairs"), "Download SL Pairs")
             ),
             
             mainPanel(
               plotOutput(ns("venn_diagram"), height = "800px"),
             ),
             
           )
  )
}