download.UI <- function(id){
  ns <- NS(id)
  tabPanel("Download & Contact",
           
           fluidPage(
             
             fluidRow(
                      
             column(12, align="center",
             #div(
             tags$table(border = 2,height = '60%', width = '80%', style = 'font-size:120%',
                                  tags$tbody(
                                    tags$tr(
                                      tags$td(align = "center", strong("Data Name")),
                                      tags$td(align = "center", strong("Data Description")),
                                      tags$td(align = "center", strong("Data Download"))
                                    ),
                                    tags$tr(
                                      tags$td(align = "center", "Raw SL Data"),
                                      tags$td(align = "center", "Contains original scores for the CDKO studies."),
                                      tags$td(align = "center", downloadButton(ns('rawSL'), label="rawSL"))
                                    ),
                                    tags$tr(
                                      tags$td(align = "center", "SLKB Calculated SL Scores"),
                                      tags$td(align = "center", "Contains SLKB score calculation for the CDKO studies."),
                                      tags$td(align = "center", downloadButton(ns('calcSL'), label="calcSL"))
                                    ),
                                    tags$tr(
                                      tags$td(align = "center", "SLKB Predicted Pairs"),
                                      tags$td(align = "center", "Contains the Venn diagram contents of SLKB scoring methods, separated by study and cell line."),
                                      tags$td(align = "center", downloadButton(ns('predSL'), label="predSL"))
                                    ),
                                    tags$tr(
                                      tags$td(align = "center", "SQL dump file"),
                                      tags$td(align = "center", "Contains the entirety of SLKB database, from counts to scores."),
                                      tags$td(align = "center", shiny::actionButton(inputId='glink', label="FigShare",
                                                                                    icon = icon("link"),
                                                                                    onclick ="window.open('https://figshare.com/articles/dataset/SLKB_-_Deposited_Data/22902839', '_blank')"))
                                  ),
                                  tags$tr(
                                    tags$td(align = "center", "SLKB Pipeline"),
                                    tags$td(align = "center", "Full SLKB pipeline (i.e., scoring, database creation, web app) can be accessed at the project link."),
                                    tags$td(align = "center", shiny::actionButton(inputId='glink', label="Zenodo",
                                                                                  icon = icon("link"),
                                                                                  onclick ="window.open('https://zenodo.org/record/8274172', '_blank')"))
                                  ),
                                  tags$tr(
                                    tags$td(align = "center", "SLKB Analysis Pipeline Documentation"),
                                    tags$td(align = "center", "Documentation can be accessed at the project link."),
                                    tags$td(align = "center", shiny::actionButton(inputId='glink', label="GitHub",
                                                                                  icon = icon("link"),
                                                                                  onclick ="window.open('https://birkangokbag.github.io/SLKB-Analysis-Pipeline', '_blank')"))
                                  ),
                                  tags$tr(
                                    tags$td(align = "center", "SLKB Web App Source"),
                                    tags$td(align = "center", "SLKB Web app can be accessed at the GitHub link (or through Zenodo). Results from the pipeline can be inserted for browsing."),
                                    tags$td(align = "center", shiny::actionButton(inputId='glink', label="GitHub",
                                                                                  icon = icon("link"),
                                                                                  onclick ="window.open('https://github.com/BirkanGokbag/SLKB-Analysis-Pipeline/blob/main/SLKB/files/SLKB_webapp.zip', '_blank')"))
                                  )
                                  
                                )
                          )
             
               )
             ),
             hr(),
             fluidRow(
               column(12, align = 'center',
                 h1('Citation', style = 'font-size:200%'),
                 p('If SLKB, through its pipeline or webapp has helped with your research, please cite us!'
                   , style = 'font-size:125%'),
                 p(code('Gökbağ, B., Tang, S., Fan, K., Cheng, L., Yu, L., Zhao, Y., & Li, L. (2023). SLKB: synthetic lethality knowledge base. Nucleic acids research, gkad806. Advance online publication. https://doi.org/10.1093/nar/gkad806'
                        , style = 'font-size:125%')),
                 p('Bibtex:', style = 'font-size:125%'),
                 p(code('  @Article{,
                            author = {Birkan Gökbağ, Shan Tang, Kunjie Fan, Lijun Cheng, Lianbo Yu, Yue Zhao, Lang Li},
                            title = {SLKB: Synthetic lethality knowledge base},
                            journal = {Nucleic acids research},
                            year = {2023},
                            doi = {10.1093/nar/gkad806}
                          }'), style = 'font-size:125%')
             )),
             hr(),
             fluidRow(
               column(12, align = 'center',
                 h1('Contact Us!', style = 'font-size:200%'),
                 p('Correspondance Mail: ', style = 'font-size:125%'),
                 p(tags$a('lang.li@osumc.edu', href="mailto:lang.li@osumc.edu"), style = 'font-size:125%')
               )
             )
           )
  )
}