library(visNetwork)

network.UI <- function(id){
  ns <- NS(id)
  
  tabPanel("Browse Network",
           
           # display statistics of the entire available SL data
           sidebarLayout(
             sidebarPanel(        
               uiOutput(ns("choose_viz_data")),
               actionButton(ns("browse_data_button"), "1. Get Data"),
               uiOutput(ns("choose_viz_cl")),
               actionButton(ns("browse_cl_button"), "2. Get Cell Line"),
               htmlOutput(ns("data_description"))
             ),
             
             mainPanel(
               textInput(ns("choose_genes"), "Enter gene(s), seperated by ;", value = "", width = NULL, placeholder = "e.g., AKT1; PLK1; PINK1"),
               actionButton(ns("choose_genes_button"), "Get Gene Interactions"),
               visNetworkOutput(ns("draw_network"), height = "800px"),
               downloadButton(ns('downloadNetwork'), 'Download interactive network')
             ),
             
           )
  )
}