overview.UI <- function(id){
  ns <- NS(id)
  
  tabPanel("Project Description",
           fluidRow(
             column(width = 12,
                       box(fluidRow(
                         h1("Introduction to SLKB", style = "font-size:300%;text-decoration:underline;"),
                         p('Synthetic lethality knowledge base (SLKB) is dedicated to curating CRISPR dual knockdown/out experiments (CDKO)
                           aiming to identify synthetic lethal (SL) interactions between two genes. SL identification is highly context dependent, differing across pathways, gene targets, cell lines, and CDKO libraries. SLKB analysis pipeline, additionally distributed as a python package, allows SL score calculation for CDKO studies. Via SLKB, users can analyze their own CDKO data and browse their results.'
                           , style = "font-size:125%"),
                         column(width = 12,align = 'center',
                                uiOutput(ns("graphical"), inline  = T)
                         )
                       ), width = NULL),
                       box(fluidRow(
                       h2("Last Updated 05/23/23", style = "font-size:200%"),
                       column(12, align = 'center',
                              tags$table(border = 1.5,height = '60%', width = '80%', style = 'font-size:120%',
                                         tags$tbody(
                                           tags$tr(
                                             tags$td(align = "center", colspan = '2', strong("SLKB Study Reported Content")),
                                           ),
                                           tags$tr(
                                             tags$td(align = "center", "# of SL CDKO Studies"),
                                             tags$td(align = "center", "11 (currently counts available for 10)")
                                           ),
                                           tags$tr(
                                             tags$td(align = "center", "# of sgRNA guides + sequences"),
                                             tags$td(align = "center", "45,430 sgRNAs (1,802 controls)")
                                           ),
                                           tags$tr(
                                             tags$td(align = "center", "# of sgRNA pair counts"),
                                             tags$td(align = "center", "3,578,017 sgRNA pairs")
                                           ),
                                           tags$tr(
                                             tags$td(align = "center", "# of unique genes and gene pairs"),
                                             tags$td(align = "center", "6,127 genes/280,483 gene pairs (148,040 unique)")
                                           ),
                                           tags$tr(
                                             tags$td(align = "center", "# of SL pairs (originally reported)"),
                                             tags$td(align = "center", "16,059 gene pairs")
                                           ),
                                           tags$tr(
                                             tags$td(align = "center", "# of non-SL pairs (originally reported)"),
                                             tags$td(align = "center", "264,424 gene pairs")
                                           ),
                                           tags$tr(
                                             tags$td(align = "center", colspan = '2', strong("SLKB Processed Content")),
                                           ),
                                           tags$tr(
                                             tags$td(align = "center", "# of unique genes and gene pairs (calculated scores)"),
                                             tags$td(align = "center", "6,124 genes/261,958 gene pairs (127,688 unique)")
                                           ),
                                           tags$tr(
                                             tags$td(align = "center", "# of SL pairs (majority vote)"),
                                             tags$td(align = "center", "13,173 gene pairs")
                                           ),
                                           tags$tr(
                                             tags$td(align = "center", "# of non-SL pairs (majority vote)"),
                                             tags$td(align = "center", "248,785 gene pairs")
                                           ),
                                           tags$tr(
                                             tags$td(align = "center", colspan = '2', strong("SL Connectivity Hubs")),
                                           ),
                                           tags$tr(
                                             tags$td(align = "center", "# of SL hub clusters (containing at least 3 genes through SL interactions)"),
                                             tags$td(align = "center", "865")
                                           ),
                                           tags$tr(
                                             tags$td(align = "center", "# of giant SL hub clusters (containing more than 10 genes through SL interactions)"),
                                             tags$td(align = "center", "67")
                                           ),
                                           tags$tr(
                                             tags$td(align = "center", "# of mega SL hub clusters (containing more than 20 genes through SL interactions)"),
                                             tags$td(align = "center", "10")
                                           ),
                                         )
                              )
                              )), width = NULL)
                       # h2("Synthetic Lethality Scoring Methods", style = "font-size:200%"),
                       # p('SLKB employs 5 main scoring methods for the deposited studies to assess the impact of scoring on SL pair identification. The current available methods are: Horlbeck Score, GEMINI Score, MAGeCK Score, Median Background/No Background Score, sgRNA Derived Background/No Background Score.'
                       #   , style = "font-size:125%"),
                       # h2("SLKB Data Browsing and Querying", style = "font-size:200%"),
                       # p('In SLKB, SL pairs can be browsed across all settings, mainly via tabular data browsing, KB query, SL network visualization, and Venn diagram comparison.'
                       #   , style = "font-size:125%"),
                       # h2("SLKB Analysis Pipeline and Web Application For Browsing", style = "font-size:200%"),
                       # p('In addition, SLKB\'s analysis pipeline and web app are available on GitHub, via the downloads page. Users may utilize the pipelines to analyze their own CDKO data, come up with their own scoring methods, and view the full results within the web app.'
                       #   , style = "font-size:125%")
             ),
           ),
           
           
           
           # fluidRow(
           #   column(width = 6,align = 'center',
           #          uiOutput(ns("fig1"), inline  = F),
           #   ),
           #   column(width = 6,align = 'center',
           #          uiOutput(ns("fig2"), inline  = F),
           #   ),
           # ),
           )

  #)
  
}