add_SL_cluster <- function(vector_attributes, comp, number_to_include, tag){
  more_than_n_SL <- which(comp$csize > number_to_include)
  more_than_n_SL <- which(comp$membership %in% more_than_n_SL)
  more_than_n_SL <- names(comp$membership[more_than_n_SL])
  vector_attributes[more_than_n_SL] = tag
  return(vector_attributes)
}

#computed_SL_res <- computed_SL_res[,c("gene_pair", "gene_1",  "gene_2", "gemini_score_SL_score_Strong", "horlbeck_score_SL_score", "mageck_score_Z_SL_score", "median_b_score_SL_score", "sgrna_derived_b_score_SL_score")]


KBQueryServer <- function(id) {
    moduleServer(
      id,
      function(input, output, session) {
        
        ns <- session$ns
        
        reactive_data <- reactiveValues(experiment_designs =  data.frame(),#dbGetQuery(conn, init.experiment_designs),
                                        study_counts = data.frame(), #dbGetQuery(conn, init.study_counts),
                                        study_SL = data.frame(), #dbGetQuery(conn, init.study_SL)
                                        computed_SL = data.frame(),
                                        plot = NULL#dbGetQuery(conn, init.computed_SL)
                                        )
        
        output$draw_network <- renderVisNetwork({
          reactive_data$plot
        })
        
        observeEvent(input$begin_query, {
          
          print('Beginning query!')
          
          # disable on start
          shinyjs::disable("downloadNetwork")
          query_genes <- toupper(strsplit(gsub(' ', '', input$query_gene), split = ';', fixed = T)[[1]])
          query_study <- toupper(gsub(' ', '', input$query_study))
          query_cl <- toupper(strsplit(gsub(' ', '', input$query_cl), split = ';', fixed = T)[[1]])
          inclusive <- input$either_or
          study_legend <- input$study_legend
          cl_legend <- input$cl_legend
          
          print(query_genes)
          print(query_study)
          print(query_cl)
          
          experiment_design_res <- experiment_design_init
          study_counts_res <- study_counts_init
          study_SL_res <- study_SL_init
          computed_SL_res <- computed_SL_init

          if (length(query_genes) != 0){
            experiment_design_res <- experiment_design_res %>% filter(sgRNA_target_name %in% query_genes)
            
            if (inclusive){
              study_counts_res <- study_counts_res %>% filter(sgRNA_target_name_g1 %in% query_genes) %>% filter(sgRNA_target_name_g2 %in% query_genes)
              study_SL_res <- study_SL_res %>% filter(gene_1 %in% query_genes) %>% filter(gene_2 %in% query_genes)
              computed_SL_res <- computed_SL_res %>% filter((gene_1 %in% query_genes) & (gene_2 %in% query_genes))# %>% filter()
            } else {
              study_counts_res <- study_counts_res %>% filter((sgRNA_target_name_g1 %in% query_genes) | (sgRNA_target_name_g2 %in% query_genes))
              study_SL_res <- study_SL_res %>% filter((gene_1 %in% query_genes) | (gene_2 %in% query_genes))
              computed_SL_res <- computed_SL_res %>% filter((gene_1 %in% query_genes) | (gene_2 %in% query_genes))
            }
          }
          
          if (query_study != ''){
            experiment_design_res <- experiment_design_res %>% filter(study_origin %in% query_study)
            study_counts_res <- study_counts_res %>% filter(study_origin %in% query_study)
            study_SL_res <- study_SL_res %>% filter(study_origin %in% query_study)
            computed_SL_res <- computed_SL_res %>% filter(study_origin %in% query_study)
          }
          
          if (length(query_cl) != 0){
            study_counts_res <- study_counts_res %>% filter(cell_line_origin %in% query_cl)
            study_SL_res <- study_SL_res %>% filter(cell_line_origin %in% query_cl)
            computed_SL_res <- computed_SL_res %>% filter(cell_line_origin %in% query_cl)
          }
          
          reactive_data$experiment_designs <-  experiment_design_res %>% collect()
          reactive_data$study_counts <-  study_counts_res %>% collect()
          reactive_data$study_SL <-  study_SL_res %>% collect()
          reactive_data$computed_SL <-  computed_SL_res %>% collect()
          
          curr.graph <- study_SL_res %>% filter(SL_or_not == 'SL') %>% collect()
          
          # exit if no query
          if (dim(curr.graph)[1] == 0){
            return()
          }
          curr.graph$cl_study_origin <- paste0(curr.graph$cell_line_origin, '+', curr.graph$study_origin)
          study_SL_res <- curr.graph
          
          graph_annotations <- c('gene_1', 'gene_2', 'cell_line_origin', 'study_origin', 'cl_study_origin')
          if (study_legend & cl_legend){
            graph_annotations <- c('gene_1', 'gene_2', 'cl_study_origin')
          } else if (!study_legend & cl_legend){
            graph_annotations <- c('gene_1', 'gene_2', 'cell_line_origin')
          } else {
            graph_annotations <- c('gene_1', 'gene_2', 'study_origin')
          }
          curr.graph <- graph_from_data_frame(unique(curr.graph[,graph_annotations]), directed = F)
          comp <- components(curr.graph)
          
          vector_attributes <- rep('Lone SL', length(V(curr.graph)))
          names(vector_attributes) <- V(curr.graph)$name
          
          vector_attributes <- add_SL_cluster(vector_attributes, comp, 2, 'SL Cluster')
          vector_attributes <- add_SL_cluster(vector_attributes, comp, 10, 'SL Giant Cluster')
          vector_attributes <- add_SL_cluster(vector_attributes, comp, 20, 'SL Mega Cluster')
          
          curr.graph <- set_vertex_attr(curr.graph, 'group', names(vector_attributes), vector_attributes)
          
          curr.graph <- toVisNetworkData(curr.graph)
          
          # color based on cell lines
          #category <- 'cell_line_origin'
          
          if (study_legend & cl_legend){
            category <- 'cl_study_origin'
            color_cl <- distinctColorPalette(length(sort(unique(curr.graph$edges[, category]))))
            names(color_cl) <- sort(unique(study_SL_res[[category]]))
            
            color_vector <- rep('', length(curr.graph$edges$from))
            used_cl <- c()
            for (cl in unique(curr.graph$edges[, category])){
              color_vector[which(cl == curr.graph$edges[, category])] <- color_cl[cl]
              used_cl <- c(cl, used_cl)
            }
            
            curr.graph$edges$color <- color_vector
            
            edge_legend <- data.frame(color = color_cl[used_cl], 
                                      label = used_cl)
          } else if(!study_legend & cl_legend){
            category <- 'cell_line_origin'
            color_cl <- distinctColorPalette(length(sort(unique(curr.graph$edges[, category]))))
            names(color_cl) <- sort(unique(study_SL_res[[category]]))

            color_vector <- rep('', length(curr.graph$edges$from))
            used_cl <- c()
            for (cl in unique(curr.graph$edges[, category])){
              color_vector[which(cl == curr.graph$edges[, category])] <- color_cl[cl]
              used_cl <- c(cl, used_cl)
            }
            
            curr.graph$edges$color <- color_vector
            
            edge_legend <- data.frame(color = color_cl[used_cl], 
                                      label = used_cl)
          } else {
            category <- 'study_origin'
            # pre-selected colors for visibility
            color_cl <- c('#e6194B', '#3cb44b', '#800000', '#4363d8', '#f58231', '#911eb4', '#42d4f4', '#f032e6', '#000075', '#9A6324', '#a9a9a9')
            names(color_cl) <- sort(unique(study_SL_res[[category]]))
            
            color_vector <- rep('', length(curr.graph$edges$from))
            used_cl <- c()
            for (cl in unique(curr.graph$edges[, category])){
              color_vector[which(cl == curr.graph$edges[, category])] <- color_cl[cl]
              used_cl <- c(cl, used_cl)
            }
            
            curr.graph$edges$color <- color_vector
            
            edge_legend <- data.frame(color = color_cl[used_cl], 
                                      label = used_cl)
          }
          
          curr.graph$nodes$group[curr.graph$nodes$id %in% query_genes] <- 'Query Genes'
          

          
          curr.graph <- visNetwork(curr.graph$nodes, curr.graph$edges, width = 1920, height = 1920) %>%
            visLayout(randomSeed = 42) %>%
            visNodes(size = 10, font = list(size = 30)) %>%
            visGroups(groupname = "Lone SL", color = "blue") %>%
            visGroups(groupname = "SL Cluster", color = "red") %>%
            visGroups(groupname = "SL Giant Cluster", color = "yellow") %>%
            visGroups(groupname = "SL Mega Cluster", color = "green") %>%
            visGroups(groupname = "Query Genes", color = "purple") %>%
            visPhysics(solver = "forceAtlas2Based",
                       forceAtlas2Based = list(gravitationalConstant = -100),
                       hierarchicalRepulsion = list(avoidOverlap = 0.99)) %>%
            visOptions(highlightNearest = list(enabled = TRUE, degree = 1,
                                               labelOnly = T, hover = TRUE),
                       nodesIdSelection = TRUE,
                       selectedBy = list(variable = "group", multiple = TRUE)) %>%
            visLegend(useGroups = T, main = 'Legend', position = 'right', addEdges = edge_legend)

          reactive_data$plot <- curr.graph
          
          # enable on end
          shinyjs::enable("downloadNetwork")
          
          print('Done Query!')

        })
        
        output$downloadNetwork <- downloadHandler(
          filename = 'SL_network.html',
          content = function(con) {
            reactive_data$plot %>% visSave(con, selfcontained = T)
          }
        )
        
        # disable on load
        shinyjs::disable("downloadNetwork")

        output$experiment_design = DT::renderDataTable(reactive_data$experiment_designs %>% collect(),
                                                        server = T,
                                                        options = list(buttons = c('copy', 'csv', 'excel','pdf')
                                                          #columnDefs = list(list(visible=FALSE, targets=c(3, 5, 7, 9)))
                                                        ))

        output$study_counts = DT::renderDataTable(reactive_data$study_counts %>% collect(),
                                                        server = T,
                                                        options = list(scrollX = TRUE,
                                                                       buttons = c('copy', 'csv', 'excel','pdf')
                                                          #columnDefs = list(list(visible=FALSE, targets=c(3, 5, 7, 9)))
                                                        ))

        output$study_SL = DT::renderDataTable(reactive_data$study_SL %>% collect(),
                                                        server = T,
                                                        options = list(buttons = c('copy', 'csv', 'excel','pdf')
                                                          #columnDefs = list(list(visible=FALSE, targets=c(3, 5, 7, 9)))
                                                        ))

        output$computed_SL = DT::renderDataTable(reactive_data$computed_SL %>% collect(),
                                                server = T,
                                                options = list(scrollX = TRUE,
                                                               buttons = c('copy', 'csv', 'excel','pdf')
                                                  #columnDefs = list(list(visible=FALSE, targets=c(3, 5, 7, 9)))
                                                ))
        
      }
    )
}

