
data.all <- study_SL_init[, -c(1,2)]
data.all <- data.all[, c("gene_1" , "gene_2", "gene_pair", "study_origin", "cell_line_origin", "SL_or_not",  "SL_score" , "statistical_score", "SL_score_cutoff", "statistical_score_cutoff")]
#data.all <- data.all[, c("gene_1" , "gene_2", "gene_pair", "study_origin", "cell_line_origin", "SL_or_not",  "SL_score")]

data.sig <- data.all[data.all$SL_or_not == 'SL',]

study_name_to_pubmed_id <- list()
study_name_to_pubmed_id[['diehl']] = '33956155'
study_name_to_pubmed_id[['han']] = '28319085'
study_name_to_pubmed_id[['horlbeck']] = '30033366'
study_name_to_pubmed_id[['ito']] = '34857952'
study_name_to_pubmed_id[['parrish']] = '34469736'
study_name_to_pubmed_id[['shen']] = '28319113'
study_name_to_pubmed_id[['thompson']] = '33637726'
study_name_to_pubmed_id[['wong']] = '26864203'
study_name_to_pubmed_id[['zhao']] = '29452643'
study_name_to_pubmed_id[['tang']] = '36060092'
study_name_to_pubmed_id[['najm']] = '29251726'
study_name_to_pubmed_id[['All Studies']] = 'All Studies'

rev_study_name_to_pubmed_id <- list()

for (study in names(study_name_to_pubmed_id)){
  rev_study_name_to_pubmed_id[[study_name_to_pubmed_id[[study]]]] <- study
}

all_study_info <- paste0(dim(study_counts_init)[1], ' sgRNA pair counts, ', dim(experiment_design_init)[1],' sgRNAs (', sum(experiment_design_init$sgRNA_target_name == 'CONTROL'), ' controls), ', length(unique(c(data.all$gene_1, data.all$gene_2))), ' unique genes, ', dim(data.all)[1], ' gene pairs')
all_study_info  <- c("N/A",
                      "All Studies",
                      "CDKO Experiments",
                      "SL Identification",
                      paste(sort(unique(data.all$cell_line_origin)), collapse = ', '),
                      all_study_info,
                      paste(table(data.all$SL_or_not)['SL'], 'SL,', table(data.all$SL_or_not)['Not SL'], 'Not SL'),
                      'Based on study',
                      '10/11 currently studies have counts.')
data_annotations <- rbind(all_study_info, data_annotations_orig)


create_plot_with_coloring <- function(curr.graph, input_genes = NULL){
  
  if (!is.null(input_genes)){
    # Filter to get interactions for the selected genes
    curr.graph <- curr.graph[(curr.graph$gene_1 %in% input_genes) | (curr.graph$gene_2 %in% input_genes), ]
    
    # identify N hop overlaps
    gene_list <- list()
    for (gene in input_genes){
      curr <- curr.graph[grepl(gene, curr.graph$gene_pair, fixed = TRUE),]
      gene_list[[gene]] <- unique(c(curr[grepl(gene, curr$gene_1, fixed = TRUE),'gene_2'], curr[grepl(gene, curr$gene_2, fixed = TRUE),'gene_1']))
    }
    
    if (length(gene_list) > 1){
      res.venn <- plotVenn(gene_list, showPlot = F)
      res.regions <- listVennRegions(res.venn, na.rm = T)
      
      # 2 way: red, 3 way: orange, 4 way: green
      overlapped_genes <- list()
      overlapped_genes[["2_way"]] <- c()
      overlapped_genes[["3_way"]] <- c()
      overlapped_genes[["4_way"]] <- c()
      for (name in names(res.regions)){
        count_category <- strsplit(name, "(", fixed = TRUE)[[1]][1]
        count_category <- str_count(count_category, "1")
        if (count_category < 2){
          next
        }
        count_category <- min(count_category, 4)
        overlapped_genes[[paste0(count_category, "_way")]] <- c(overlapped_genes[[paste0(count_category, "_way")]], res.regions[[name]])
      }
    }
    
    
    print(dim(curr.graph))
    
    curr.graph <- graph_from_data_frame(curr.graph[,c('gene_1', 'gene_2', 'cell_line_origin', 'study_origin')], directed = F)
    
    curr.graph <- toVisNetworkData(curr.graph)
    
    gene_idx <- curr.graph$nodes$id %in% input_genes
    
    curr.graph$nodes$group <- rep("node", length(gene_idx))
    curr.graph$nodes$group[gene_idx] <- "chosen_node"
    
    curr.graph$edges$color <- rep("blue", dim(curr.graph$edges)[1])
    
    if (length(gene_list) > 1){
      overlapped_genes[["2_way"]] <- setdiff(overlapped_genes[["2_way"]], input_genes)
      overlapped_genes[["3_way"]] <- setdiff(overlapped_genes[["3_way"]], input_genes)
      overlapped_genes[["4_way"]] <- setdiff(overlapped_genes[["4_way"]], input_genes)
      for (gene in overlapped_genes[["2_way"]]){
        curr.graph$edges$color[grepl(gene, curr.graph$edges$gene_pair, fixed = TRUE)] <- 'red'
      }
      for (gene in overlapped_genes[["3_way"]]){
        curr.graph$edges$color[grepl(gene, curr.graph$edges$gene_pair, fixed = TRUE)] <- 'orange'
      }
      for (gene in overlapped_genes[["4_way"]]){
        curr.graph$edges$color[grepl(gene, curr.graph$edges$gene_pair, fixed = TRUE)] <- 'green'
      }
      
      for (i in seq_along(input_genes)){
        if (i == length(input_genes)){
          next
        }
        gene1 <- input_genes[i]
        for (gene2 in input_genes[(i+1):length(input_genes)]){
          curr.graph$edges$color[grepl(gene1, curr.graph$edges$gene_pair, fixed = TRUE) & grepl(gene2, curr.graph$edges$gene_pair, fixed = TRUE)] <- 'purple'
        }
      }
      
      gene_idx <- curr.graph$nodes$id %in% overlapped_genes[["2_way"]]
      curr.graph$nodes$group[gene_idx] <- "chosen_node_2_way"
      
      gene_idx <- curr.graph$nodes$id %in% overlapped_genes[["3_way"]]
      curr.graph$nodes$group[gene_idx] <- "chosen_node_3_way"
      
      gene_idx <- curr.graph$nodes$id %in% overlapped_genes[["4_way"]]
      curr.graph$nodes$group[gene_idx] <- "chosen_node_4_way"
      
    }
    
    # color based on cell lines
    color_cl <- distinctColorPalette(length(sort(unique(curr.graph$edges$cell_line_origin))))
    names(color_cl) <- sort(unique(curr.graph$edges$cell_line_origin))
    
    color_vector <- rep('', length(curr.graph$edges$from))
    for (cl in unique(curr.graph$edges$cell_line_origin)){
      color_vector[which(cl == curr.graph$edges$cell_line_origin)] <- color_cl[cl]
    }
    
    curr.graph$edges$color <- color_vector
    
    edge_legend <- data.frame(color = color_cl, 
                              label = names(color_cl)) 
    
    res_plot <- visNetwork(curr.graph$nodes, curr.graph$edges) %>%
      visNodes(size = 20, font = list(size = 20)) %>%
      visGroups(groupname = "chosen_node", color = "purple") %>%
      visGroups(groupname = "chosen_node_2_way", color = "red") %>%
      visGroups(groupname = "chosen_node_3_way", color = "orange") %>%
      visGroups(groupname = "chosen_node_4_way", color = "green") %>%
      visGroups(groupname = "node", color = "blue") %>% 
      visLayout(randomSeed = 42) %>%
      visPhysics(solver = "forceAtlas2Based",
                 forceAtlas2Based = list(gravitationalConstant = -100),
                 hierarchicalRepulsion = list(avoidOverlap = 0.99)) %>%
      visLegend(useGroups = F, main = 'Legend', position = 'right', addEdges = edge_legend)
  } else {
    
    curr.graph <- graph_from_data_frame(curr.graph[,c('gene_1', 'gene_2', 'cell_line_origin', 'study_origin')], directed = F)
    
    curr.graph <- toVisNetworkData(curr.graph)
    
    #gene_idx <- curr.graph$nodes$id %in% genes
    
    # color based on cell lines
    color_cl <- distinctColorPalette(length(sort(unique(curr.graph$edges$cell_line_origin))))
    names(color_cl) <- sort(unique(curr.graph$edges$cell_line_origin))
    
    color_vector <- rep('', length(curr.graph$edges$from))
    for (cl in unique(curr.graph$edges$cell_line_origin)){
      color_vector[which(cl == curr.graph$edges$cell_line_origin)] <- color_cl[cl]
    }
    
    curr.graph$edges$color <- color_vector
    
    edge_legend <- data.frame(color = color_cl, 
                              label = names(color_cl)) 
    
    res_plot <- visNetwork(curr.graph$nodes, curr.graph$edges) %>%
      visNodes(size = 20, font = list(size = 20)) %>%
      visGroups(groupname = "node", color = "blue") %>% 
      visLayout(randomSeed = 42) %>%
      visPhysics(solver = "forceAtlas2Based",
                 forceAtlas2Based = list(gravitationalConstant = -100),
                 hierarchicalRepulsion = list(avoidOverlap = 0.99)) %>%
      visLegend(useGroups = F, main = 'Legend', position = 'right', addEdges = edge_legend)
    
    
  }
  
  
  return(res_plot)
  
}

browseDataServer <- function(id) {
  moduleServer(
    id,
    function(input, output, session) {
      
      ns <- session$ns
      
      # if (grepl('browse_data_processed', ns("name"), ignore.case = T)){
      #   print(ns("name"))
      #   con <- pool::dbPool(drv = RSQLite::SQLite(),dbname = "KB/SLKB_sqlite3")
      #   
      #   data.all <- tbl( con, sql(sqlInterpolate(con, 'SELECT * FROM CDKO_ORIGINAL_SL_RESULTS'))) %>% collect()
      #   #data.all <- data.all[, -c(1,2)]
      #   
      #   data.all <- data.all[, c("gene_1" , "gene_2", "gene_pair", "study_origin", "cell_line_origin", "SL_or_not",  "SL_score" , "statistical_score", "SL_score_cutoff", "statistical_score_cutoff")]
      #   
      #   data.all[data.all$SL_or_not == '0', 'SL_or_not'] <- 'Not SL'
      #   data.all[data.all$SL_or_not == '1', 'SL_or_not'] <- 'SL'
      #   data.sig <- data.all[data.all$SL_or_not == 'SL',]
      #   
      #   curr.graph <- graph_from_data_frame(data.all[1:4,c('gene_1', 'gene_2')])
      #   curr.graph <- toVisNetworkData(curr.graph)
      #   curr.graph <- visNetwork(curr.graph$nodes, curr.graph$edges)
      #   
      # } else {
      #   print(ns("name"))
      #   data.all <- read.csv("www/SLKB_original_raw_reported_SL.csv", row.name = 1)
      #   data.sig <- data.all[data.all$SL_or_not == 'SL',]
      #   
      #   curr.graph <- graph_from_data_frame(data.all[1:4,c('gene_1', 'gene_2')])
      #   curr.graph <- toVisNetworkData(curr.graph)
      #   curr.graph <- visNetwork(curr.graph$nodes, curr.graph$edges)
      #   
      # }
    
      
      ## For Browse Data
      reactive_data <- reactiveValues(plot = NULL,#
                                      table = data.sig,
                                      mode = "Significant",
                                      show = F)
      
      
      
      output$sig_or_all_button <- renderUI({
        materialSwitch(
          inputId = ns("sig_or_all"),
          label = "SL Pairs",
          status = "primary",
          value = FALSE,
          right = TRUE
        )
      })

      output$datatable <- DT::renderDataTable(reactive_data$table, 
                                              server = TRUE,
                                              options = list(scrollX = T,
                                                             pageLength = 20,
                                                             buttons = c('copy', 'csv', 'excel','pdf'),
                                                             #dom = 't',
                                                             lengthMenu = list(c(20, 30, 50, 100, -1), c('20', '30', '50', '100', 'All'))
                                                             # initComplete = JS(
                                                             #   "function(settings, json) {",
                                                             #   "$('body').css({'font-size': '200%'});",
                                                             #   "}"
                                                             # ),
                                                             #fontSize = '200%',
                                                #columnDefs = list(list(visible=FALSE, targets=c(4, 8, 9, 10)))
                                              ))
      
      output$draw_network <- renderVisNetwork({
        reactive_data$plot
      })
      
      observeEvent(input$choose_genes_button, {
        
        genes <- sub(" ", "", input$choose_genes)

        print(paste("Selected genes:", genes))
        
        
        genes <- strsplit(genes, ";")[[1]]
        #genes <- "ARL2;FAM50A;WDR61;POLD1"
        
        if (length(genes) == 0){
          genes <- NULL
        }
        
        curr.graph <- reactive_data$table
        
        reactive_data$plot <- create_plot_with_coloring(curr.graph, genes)
        
        # enable after choosing genes
        shinyjs::enable("downloadNetwork")
        
      })
      
      output$downloadNetwork <- downloadHandler(
        filename = 'SL_network.html',
        content = function(con) {
          reactive_data$plot %>% visSave(con, selfcontained = T)
          #reactive_data$plot %>% saveWidgetFix(con, selfcontained = T, background = 'white')
        }
      )
      
      # disable on load
      shinyjs::disable("downloadNetwork")
      
      output$choose_viz_data <- renderUI({
        
        # let us rely on the annotations file to show study names
        sources <- paste0(data_annotations$Study, ' (', data_annotations$`Pubmed ID`,')')
        selectInput(ns("ChosenDataForViz"), "Data Sources :",
                    sources)
      })
      
      output$choose_viz_cl <- renderUI({
        
        
        curr_study <- unique(reactive_data$table$study_origin)
        
        if (length(curr_study) > 1){
          cell_lines <- sort(unique(reactive_data$table$cell_line_origin))
        } else {
          cell_lines <- sort(unique(data.sig$cell_line_origin[data.sig$study_origin == curr_study]))
        }
        
        #cell_lines <- sort(unique(reactive_data$table$cell_line_origin))
        
        if (length(cell_lines) > 1){
          cell_lines <- c("All Cell Lines", cell_lines)
        }
        selectInput(ns("ChosenCLForViz"), "Cell Lines :",
                    cell_lines)
      })
      
      output$data_description <- renderUI({
        
        # print('input$ChosenDataForViz')
        # print(input$ChosenDataForViz)
        data_idx <- data_annotations$`Study` == "All Studies"
        if (is.null(input$ChosenDataForViz) | grepl('All Studies', input$ChosenDataForViz, fixed = T)){
          # | (input$ChosenDataForViz == "All Studies")
          data_idx <- data_annotations$`Study` == "All Studies"
        } else {
          study <- gsub(".*\\((.*)\\).*", "\\1", input$ChosenDataForViz)
          #data_annotations$`Pubmed ID` == input$ChosenDataForViz
          data_idx <- data_annotations$`Pubmed ID` == study#repl(rev_study_name_to_pubmed_id[[input$ChosenDataForViz]], data_annotations$`CDKO studies`, ignore.case = T)
        }
        
        # data_annotations$`Numbers of genes and gene pairs`[data_idx]
        
        # data_msg <- "<h2>Data Name:</h2>"
        # data_msg <- paste(data_msg, data_annotations$`Study`[data_idx])
        # 
        # library_msg <- "<h2>Screening Library Description:</h2>"
        # library_msg <- paste(library_msg, data_annotations$`Screening Library`[data_idx])
        
        study_msg <- "<h2>Study Goal:</h2>"
        study_msg <- paste(study_msg, data_annotations$`Study Goal`[data_idx])
        
        cutoff_msg <-  "<h2>SL Criteria:</h2>"
        cutoff_msg <- paste(cutoff_msg, data_annotations$`SL Criteria`[data_idx])
        
        # cl_msg <- "<h2>Targeted Cell Line(s):</h2>"
        # cl_msg <- paste(cl_msg, data_annotations$`Cell Line`[data_idx])
        
        pair_msg <- "<h2>Available Target Information:</h2>"
        pair_msg <- paste(pair_msg, data_annotations$`Gene Sets`[data_idx])
        
        sig_msg <- "<h2>Identified SL Interactions:</h2>"
        sig_msg <- paste(sig_msg, data_annotations$`Significant SL Information`[data_idx])
        
        
        
        # grepl("Diehl", data_annotations$`CDKO studies`)
        # data_annotations$`CDKO studies` %in% "Diehl"
        
        HTML(paste(#data_msg,
                   #library_msg,
                   study_msg,
                   cutoff_msg,
                   #cl_msg,
                   pair_msg,
                   sig_msg
                   ))

      })
      
      observeEvent(input$browse_data_button, {
        
        print(paste("1. Browse", input$ChosenDataForViz))
        
        if (grepl('All Studies', input$ChosenDataForViz, fixed = T)){
          curr.graph <- data.all
          if (reactive_data$mode == "Significant"){
            curr.graph <- data.sig
          }
          reactive_data$table <- curr.graph
          
        } else {
          curr.graph <- data.all
          if (reactive_data$mode == "Significant"){
            curr.graph <- data.sig
          }
          #reactive_data$table
          study <- gsub(".*\\((.*)\\).*", "\\1", input$ChosenDataForViz)
          
          # # choose data
          curr.graph <- curr.graph[curr.graph$study_origin == study, ]
          
          reactive_data$table <- curr.graph          
        }
        
        # disable after choosing data
        shinyjs::disable("downloadNetwork")
        
      })
      
      observeEvent(input$browse_cl_button, {
        print(paste("2. Browse", input$ChosenCLForViz))
        
        curr.graph <- data.all
        if (reactive_data$mode == "Significant"){
          curr.graph <- data.sig
        }
        
        #reactive_data$table
        study <- gsub(".*\\((.*)\\).*", "\\1", input$ChosenDataForViz)
        
        # first, filter based on the study, then the cell line
        if (!grepl('All Studies', input$ChosenDataForViz, fixed = T)){
          curr.graph <- curr.graph[curr.graph$study_origin == study, ]
        }
        
        if (input$ChosenCLForViz != "All Cell Lines"){
          curr.graph <- curr.graph[curr.graph$cell_line_origin == input$ChosenCLForViz, ]
        }
        reactive_data$table <- curr.graph
        reactive_data$show <- TRUE
        
        # curr.graph <- graph_from_data_frame(curr.graph, directed = FALSE)
        # 
        # curr.graph <- toVisNetworkData(curr.graph)
        
        reactive_data$plot <- create_plot_with_coloring(curr.graph, NULL)
        
        # enable after choosing cell line
        shinyjs::enable("downloadNetwork")
        
      })
      
      
      
      
      observeEvent(input$sig_or_all, {
        if (reactive_data$mode == "All"){
          reactive_data$mode <- "Significant"
          print(input$ChosenDataForViz)
          reactive_data$table <- data.sig
        } else {
          reactive_data$mode <- "All"
          reactive_data$table <- data.all
        }
        
        curr.graph <- reactive_data$table
        study <- gsub(".*\\((.*)\\).*", "\\1", input$ChosenDataForViz)
        
        if (!grepl('All Studies', input$ChosenDataForViz, fixed = T)){
          curr.graph <- curr.graph[curr.graph$study_origin == study, ]
        }
        
        if (input$ChosenCLForViz != "All Cell Lines"){
          curr.graph <- curr.graph[curr.graph$cell_line_origin == input$ChosenCLForViz, ]
        }
        
        reactive_data$table <- curr.graph          
        
      }) 
      
      
      
    }
  )
}




###########################################################################