data.UI <- function(id){
  ns <- NS(id)
  
  tabPanel("Browse Study Reported Scores",
           
           # display statistics of the entire available SL data
           uiOutput(ns("sig_or_all_button")),
           sidebarLayout(
             sidebarPanel(        
               uiOutput(ns("choose_viz_data")),
               actionButton(ns("browse_data_button"), "1. Get Data"),
               uiOutput(ns("choose_viz_cl")),
               actionButton(ns("browse_cl_button"), "2. Get Cell Line"),
               htmlOutput(ns("data_description"))
             ),
             
             mainPanel(
               DT::dataTableOutput(ns("datatable")),
             ),
             
           )
  )
}