tutorial.UI <- function(id){
  ns <- NS(id)
  
  tabPanel("SLKB User Guide",
           fluidRow(
             column(width = 12,
                       box(fluidRow(
                         h1("Getting Started", style = "font-size:300%"),
                         p('SLKB offers data browsing and visualization in two ways: (1) study reported SL data, and (2) SLKB calculated SL scores. Both ways allow tabular data browsing. Network visualizations and Venn diagrams are available for study reported and SLKB reported data respectively.', style = "font-size:125%"),
                       ), width = NULL),
                       
                    tags$hr(),
                       box(fluidRow(
                         h2("SLKB Available Studies", style = "font-size:200%"),
                         column(width = 12,align = 'center',
                                uiOutput(ns("tutorial_fig1"), inline  = T)
                         ),
                         br(),
                         p('The studies that are currently available in SLKB can be browsed within this page.', style = "font-size:125%"),
                         p(strong('(1):'), ' Users can filter the available datatable with their own query.', style = "font-size:125%"),
                       ), width = NULL),
                      
                       
                       
                    tags$hr(),
                      box(fluidRow(
                         h2("Query KB", style = "font-size:200%"),
                         column(width = 12,align = 'center',
                                uiOutput(ns("tutorial_fig2"), inline  = T),
                         ),
                         br(),
                         p('Users can query the contents of SLKB through this page. Users can browse cell lines, studies, and genes. Empty parameters return every possible query.', style = "font-size:125%"),
                         p(strong('(1):'), ' Users can query multiple genes, separated by semicolon.', style = "font-size:125%"),
                         p(strong('(2):'), ' Users can query multiple studies\' PubMed IDs, separated by semicolon.', style = "font-size:125%"),
                         p(strong('(3):'), ' Users can query multiple cell lines, separated by semicolon.', style = "font-size:125%"),
                         p(strong('(4):'), ' Users can limit the query to the aforementioned genes by checking this box.', style = "font-size:125%"),
                         p(strong('(5):'), ' Users can visualize SL network across Pubmed IDs as annotation. This can be combined with cell line annotation. (Default: only Pubmed ID)', style = "font-size:125%"),
                         p(strong('(6):'), ' Users can visualize SL network across cell lines as annotation. This can be combined with Pubmed ID annotations.', style = "font-size:125%"),
                         p(strong('(7):'), ' Users can run the query after filling all parameters. If no parameters are filled, all contents in SLKB are returned.', style = "font-size:125%"),
                         p(strong('(8):'), ' SLKB contents are displayed in multiple tabs.', style = "font-size:125%"),
                         tags$ul(tags$li('Experiment Design: A table that contains the columns: sgRNA probe id name, guide sequence, sgRNA target name, and study origin.'), 
                                 tags$li('Study SL Counts: A table that contains all pair sgRNA counts.'), 
                                 tags$li('Study Reported SL Scores: A table that contains study reported SL scores and results.'), 
                                 tags$li('Study Reported SL Network: A network plot of study reported SL interactions. Users can download the generated network after it\'s loaded.'), 
                                 tags$ul(tags$li('Network connections are colored by study.'),
                                         tags$li('Lone SL: Blue nodes, only 2 connected through SL interactions.'),
                                         tags$li('SL Cluster: Red nodes, 3-10 genes that are connected through SL interactions.'),
                                         tags$li('SL Giant Cluster: Yellow nodes, 11-20 genes that are connected through SL interactions.'),
                                         tags$li('SL Mega Cluster: Green nodes, 20+ genes that are connected through SL interactions.')
                                         ),
                                 tags$li('SKB Calculated SL Scores: A table that contains all scoring methods\' results.'), 
                                 style = "font-size:125%"),
                         p(strong('(9): All tabs except network tab are tables. Each table can be sorted and filtered based on the columns and contents.'), ' ', style = "font-size:125%"),
                       ), width = NULL),
                       
                       
                    tags$hr(),
                      box(fluidRow(
                         h2("Compare SL Approaches", style = "font-size:200%"),
                         column(width = 12,align = 'center',
                                uiOutput(ns("tutorial_fig3"), inline  = T)
                         ),
                         br(),
                         p('Users can see the impact of each scoring method on the predicted SL pairs. (Default: top 10% pairs from each method)', style = "font-size:125%"),
                         p(strong('(1):'), ' Users need to choose a study and cell line before proceeding.', style = "font-size:125%"),
                         p(strong('(2):'), ' Users can set custom score thresholds to each method. Each user entry is tied to its filter button, the updates are made live.', style = "font-size:125%"),
                         p(strong('(3):'), ' Users can download the Venn diagram contents, where zeros and ones indicate gene prediction by the designated methods.', style = "font-size:125%"),
                       ), width = NULL),
                      
                       
                    tags$hr(),
                    box(fluidRow(
                         h2("Browse Study Reported Scores", style = "font-size:200%"),
                         column(width = 12,align = 'center',
                                uiOutput(ns("tutorial_fig4"), inline  = T)
                         ),
                         br(),
                         p('Users can browse study reported SL scores and contents within this page.', style = "font-size:125%"),
                         p(strong('(1):'), ' Users can filter the reported results to pairs identified as synthetic lethal.', style = "font-size:125%"),
                         p(strong('(2):'), ' Users need to choose a study and cell line. Users can query all studies and cell lines.', style = "font-size:125%"),
                         p(strong('(3):'), ' Users can view the study details to the left side of the panel.', style = "font-size:125%"),
                         p(strong('(4):'), ' Users can sort the table contents and filter based on their query.', style = "font-size:125%"),
                       ), width = NULL),
                       
                       
                    tags$hr(),
                    box(fluidRow(
                         h2("Browse Network", style = "font-size:200%"),
                         column(width = 12,align = 'center',
                                uiOutput(ns("tutorial_fig5"), inline  = T)
                         ),
                         br(),
                         p('Users can browse study reported SL scores and contents within this page.', style = "font-size:125%"),
                         p(strong('(1):'), ' Users can filter the reported results to pairs identified as synthetic lethal.', style = "font-size:125%"),
                         p(strong('(2):'), ' Users need to choose a study and cell line. Users can query all studies and cell lines.', style = "font-size:125%"),
                         p(strong('(3):'), ' Users can select target genes to filter the yielded network, separated by semicolon.', style = "font-size:125%"),
                         tags$ul(tags$li('Purple nodess: User entered genes (i.e., target genes).'),
                                 tags$li('Blue nodes: Genes that are connected to 1 target gene.'),
                                 tags$li('Red nodes: Genes that are connected to 2 target genes.'),
                                 tags$li('Yellow nodes: Genes that are connected to 3 target genes.'),
                                 tags$li('Green nodes: Genes that are connected to 3+ target genes.'),
                                 style = "font-size:125%"),
                         p(strong('(4):'), ' Users can download the resulting network after it\'s loaded.', style = "font-size:125%"),
                       ), width = NULL),
                    
                    box(fluidRow(
                      h2("Accessing SLKB Analysis Pipeline and Web Applicaton", style = "font-size:200%"),
                      p('Users may access both the analysis pipeline and web app at the', tags$a('documentation website.', href="https://birkangokbag.github.io/SLKB-Analysis-Pipeline", target='_blank'), style = "font-size:125%"),
                    ), width = NULL)
                       
                       

             ),
           )
           )

  #)
  
}