import * as iam from '@aws-cdk/aws-iam';
import * as firehose from '@aws-cdk/aws-kinesisfirehose';
import * as kms from '@aws-cdk/aws-kms';
import * as logs from '@aws-cdk/aws-logs';
import * as s3 from '@aws-cdk/aws-s3';
import * as cdk from '@aws-cdk/core';
/**
 * (experimental) Possible compression options Kinesis Data Firehose can use to compress data on delivery.
 *
 * @experimental
 */
export declare class Compression {
    readonly value: string;
    /**
     * (experimental) gzip.
     *
     * @experimental
     */
    static readonly GZIP: Compression;
    /**
     * (experimental) Hadoop-compatible Snappy.
     *
     * @experimental
     */
    static readonly HADOOP_SNAPPY: Compression;
    /**
     * (experimental) Snappy.
     *
     * @experimental
     */
    static readonly SNAPPY: Compression;
    /**
     * (experimental) ZIP.
     *
     * @experimental
     */
    static readonly ZIP: Compression;
    /**
     * (experimental) Creates a new Compression instance with a custom value.
     *
     * @experimental
     */
    static of(value: string): Compression;
    /**
     * @param value the string value of the Compression.
     */
    private constructor();
}
/**
 * (experimental) Options for S3 record backup of a delivery stream.
 *
 * @experimental
 */
export declare enum BackupMode {
    /**
     * (experimental) All records are backed up.
     *
     * @experimental
     */
    ALL = 0,
    /**
     * (experimental) Only records that failed to deliver or transform are backed up.
     *
     * @experimental
     */
    FAILED = 1
}
/**
 * Logging related properties for a delivery stream destination.
 */
interface DestinationLoggingProps {
    /**
     * (experimental) If true, log errors when data transformation or data delivery fails.
     *
     * If `logGroup` is provided, this will be implicitly set to `true`.
     *
     * @default true - errors are logged.
     * @experimental
     */
    readonly logging?: boolean;
    /**
     * (experimental) The CloudWatch log group where log streams will be created to hold error logs.
     *
     * @default - if `logging` is set to `true`, a log group will be created for you.
     * @experimental
     */
    readonly logGroup?: logs.ILogGroup;
}
/**
 * (experimental) Common properties for defining a backup, intermediary, or final S3 destination for a Kinesis Data Firehose delivery stream.
 *
 * @experimental
 */
export interface CommonDestinationS3Props {
    /**
     * (experimental) The length of time that Firehose buffers incoming data before delivering it to the S3 bucket.
     *
     * Minimum: Duration.seconds(60)
     * Maximum: Duration.seconds(900)
     *
     * @default Duration.seconds(300)
     * @experimental
     */
    readonly bufferingInterval?: cdk.Duration;
    /**
     * (experimental) The size of the buffer that Kinesis Data Firehose uses for incoming data before delivering it to the S3 bucket.
     *
     * Minimum: Size.mebibytes(1)
     * Maximum: Size.mebibytes(128)
     *
     * @default Size.mebibytes(5)
     * @experimental
     */
    readonly bufferingSize?: cdk.Size;
    /**
     * (experimental) The type of compression that Kinesis Data Firehose uses to compress the data that it delivers to the Amazon S3 bucket.
     *
     * The compression formats SNAPPY or ZIP cannot be specified for Amazon Redshift
     * destinations because they are not supported by the Amazon Redshift COPY operation
     * that reads from the S3 bucket.
     *
     * @default - UNCOMPRESSED
     * @experimental
     */
    readonly compression?: Compression;
    /**
     * (experimental) The AWS KMS key used to encrypt the data that it delivers to your Amazon S3 bucket.
     *
     * @default - Data is not encrypted.
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3.
     *
     * This prefix appears immediately following the bucket name.
     *
     * @default "YYYY/MM/DD/HH"
     * @see https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html
     * @experimental
     */
    readonly errorOutputPrefix?: string;
    /**
     * (experimental) A prefix that Kinesis Data Firehose evaluates and adds to records before writing them to S3.
     *
     * This prefix appears immediately following the bucket name.
     *
     * @default "YYYY/MM/DD/HH"
     * @see https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html
     * @experimental
     */
    readonly dataOutputPrefix?: string;
}
/**
 * (experimental) Properties for defining an S3 backup destination.
 *
 * S3 backup is available for all destinations, regardless of whether the final destination is S3 or not.
 *
 * @experimental
 */
export interface DestinationS3BackupProps extends DestinationLoggingProps, CommonDestinationS3Props {
    /**
     * (experimental) The S3 bucket that will store data and failed records.
     *
     * @default - If `mode` is set to `BackupMode.ALL` or `BackupMode.FAILED`, a bucket will be created for you.
     * @experimental
     */
    readonly bucket?: s3.IBucket;
    /**
     * (experimental) Indicates the mode by which incoming records should be backed up to S3, if any.
     *
     * If `bucket` is provided, this will be implicitly set to `BackupMode.ALL`.
     *
     * @default - If `bucket` is provided, the default will be `BackupMode.ALL`. Otherwise,
     * source records are not backed up to S3.
     * @experimental
     */
    readonly mode?: BackupMode;
}
/**
 * (experimental) Generic properties for defining a delivery stream destination.
 *
 * @experimental
 */
export interface CommonDestinationProps extends DestinationLoggingProps {
    /**
     * (experimental) The IAM role associated with this destination.
     *
     * Assumed by Kinesis Data Firehose to invoke processors and write to destinations
     *
     * @default - a role will be created with default permissions.
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) The data transformation that should be performed on the data before writing to the destination.
     *
     * @default - no data transformation will occur.
     * @experimental
     */
    readonly processor?: firehose.IDataProcessor;
    /**
     * (experimental) The configuration for backing up source records to S3.
     *
     * @default - source records will not be backed up to S3.
     * @experimental
     */
    readonly s3Backup?: DestinationS3BackupProps;
}
export {};
