import * as firehose from '@aws-cdk/aws-kinesisfirehose';
import * as s3 from '@aws-cdk/aws-s3';
import { Construct } from 'constructs';
import { CommonDestinationProps, CommonDestinationS3Props } from './common';
/**
 * (experimental) Props for defining an S3 destination of a Kinesis Data Firehose delivery stream.
 *
 * @experimental
 */
export interface S3BucketProps extends CommonDestinationS3Props, CommonDestinationProps {
}
/**
 * (experimental) An S3 bucket destination for data from a Kinesis Data Firehose delivery stream.
 *
 * @experimental
 */
export declare class S3Bucket implements firehose.IDestination {
    private readonly bucket;
    private readonly props;
    /**
     * @experimental
     */
    constructor(bucket: s3.IBucket, props?: S3BucketProps);
    /**
     * (experimental) (experimental) Binds this destination to the Kinesis Data Firehose delivery stream.
     *
     * Implementers should use this method to bind resources to the stack and initialize values using the provided stream.
     *
     * @experimental
     */
    bind(scope: Construct, _options: firehose.DestinationBindOptions): firehose.DestinationConfig;
    private getS3BackupMode;
}
