# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSessionResult',
    'AwaitableGetSessionResult',
    'get_session',
    'get_session_output',
]

@pulumi.output_type
class GetSessionResult:
    """
    A collection of values returned by getSession.
    """
    def __init__(__self__, bastion_id=None, bastion_name=None, bastion_public_host_key_info=None, bastion_user_name=None, display_name=None, id=None, key_details=None, key_type=None, lifecycle_details=None, session_id=None, session_ttl_in_seconds=None, ssh_metadata=None, state=None, target_resource_details=None, time_created=None, time_updated=None):
        if bastion_id and not isinstance(bastion_id, str):
            raise TypeError("Expected argument 'bastion_id' to be a str")
        pulumi.set(__self__, "bastion_id", bastion_id)
        if bastion_name and not isinstance(bastion_name, str):
            raise TypeError("Expected argument 'bastion_name' to be a str")
        pulumi.set(__self__, "bastion_name", bastion_name)
        if bastion_public_host_key_info and not isinstance(bastion_public_host_key_info, str):
            raise TypeError("Expected argument 'bastion_public_host_key_info' to be a str")
        pulumi.set(__self__, "bastion_public_host_key_info", bastion_public_host_key_info)
        if bastion_user_name and not isinstance(bastion_user_name, str):
            raise TypeError("Expected argument 'bastion_user_name' to be a str")
        pulumi.set(__self__, "bastion_user_name", bastion_user_name)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_details and not isinstance(key_details, list):
            raise TypeError("Expected argument 'key_details' to be a list")
        pulumi.set(__self__, "key_details", key_details)
        if key_type and not isinstance(key_type, str):
            raise TypeError("Expected argument 'key_type' to be a str")
        pulumi.set(__self__, "key_type", key_type)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if session_id and not isinstance(session_id, str):
            raise TypeError("Expected argument 'session_id' to be a str")
        pulumi.set(__self__, "session_id", session_id)
        if session_ttl_in_seconds and not isinstance(session_ttl_in_seconds, int):
            raise TypeError("Expected argument 'session_ttl_in_seconds' to be a int")
        pulumi.set(__self__, "session_ttl_in_seconds", session_ttl_in_seconds)
        if ssh_metadata and not isinstance(ssh_metadata, dict):
            raise TypeError("Expected argument 'ssh_metadata' to be a dict")
        pulumi.set(__self__, "ssh_metadata", ssh_metadata)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_resource_details and not isinstance(target_resource_details, list):
            raise TypeError("Expected argument 'target_resource_details' to be a list")
        pulumi.set(__self__, "target_resource_details", target_resource_details)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="bastionId")
    def bastion_id(self) -> str:
        """
        The unique identifier (OCID) of the bastion that is hosting this session.
        """
        return pulumi.get(self, "bastion_id")

    @property
    @pulumi.getter(name="bastionName")
    def bastion_name(self) -> str:
        """
        The name of the bastion that is hosting this session.
        """
        return pulumi.get(self, "bastion_name")

    @property
    @pulumi.getter(name="bastionPublicHostKeyInfo")
    def bastion_public_host_key_info(self) -> str:
        """
        The public key of the bastion host. You can use this to verify that you're connecting to the correct bastion.
        """
        return pulumi.get(self, "bastion_public_host_key_info")

    @property
    @pulumi.getter(name="bastionUserName")
    def bastion_user_name(self) -> str:
        """
        The username that the session uses to connect to the target resource.
        """
        return pulumi.get(self, "bastion_user_name")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The name of the session.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique identifier (OCID) of the session, which can't be changed after creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> Sequence['outputs.GetSessionKeyDetailResult']:
        """
        Public key details for a bastion session.
        """
        return pulumi.get(self, "key_details")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> str:
        """
        The type of the key used to connect to the session. PUB is a standard public key in OpenSSH format.
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current session state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="sessionId")
    def session_id(self) -> str:
        return pulumi.get(self, "session_id")

    @property
    @pulumi.getter(name="sessionTtlInSeconds")
    def session_ttl_in_seconds(self) -> int:
        """
        The amount of time the session can remain active.
        """
        return pulumi.get(self, "session_ttl_in_seconds")

    @property
    @pulumi.getter(name="sshMetadata")
    def ssh_metadata(self) -> Mapping[str, Any]:
        """
        The connection message for the session.
        """
        return pulumi.get(self, "ssh_metadata")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the session.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetResourceDetails")
    def target_resource_details(self) -> Sequence['outputs.GetSessionTargetResourceDetailResult']:
        """
        Details about a bastion session's target resource.
        """
        return pulumi.get(self, "target_resource_details")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the session was created. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the session was updated. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2020-01-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetSessionResult(GetSessionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSessionResult(
            bastion_id=self.bastion_id,
            bastion_name=self.bastion_name,
            bastion_public_host_key_info=self.bastion_public_host_key_info,
            bastion_user_name=self.bastion_user_name,
            display_name=self.display_name,
            id=self.id,
            key_details=self.key_details,
            key_type=self.key_type,
            lifecycle_details=self.lifecycle_details,
            session_id=self.session_id,
            session_ttl_in_seconds=self.session_ttl_in_seconds,
            ssh_metadata=self.ssh_metadata,
            state=self.state,
            target_resource_details=self.target_resource_details,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_session(session_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSessionResult:
    """
    This data source provides details about a specific Session resource in Oracle Cloud Infrastructure Bastion service.

    Retrieves a session identified by the session ID. A bastion session lets authorized users connect to a target resource for a predetermined amount of time.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_session = oci.Bastion.get_session(session_id=test_session_oci_bastion_session["id"])
    ```


    :param str session_id: The unique identifier (OCID) of the session.
    """
    __args__ = dict()
    __args__['sessionId'] = session_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Bastion/getSession:getSession', __args__, opts=opts, typ=GetSessionResult).value

    return AwaitableGetSessionResult(
        bastion_id=pulumi.get(__ret__, 'bastion_id'),
        bastion_name=pulumi.get(__ret__, 'bastion_name'),
        bastion_public_host_key_info=pulumi.get(__ret__, 'bastion_public_host_key_info'),
        bastion_user_name=pulumi.get(__ret__, 'bastion_user_name'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        key_details=pulumi.get(__ret__, 'key_details'),
        key_type=pulumi.get(__ret__, 'key_type'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        session_id=pulumi.get(__ret__, 'session_id'),
        session_ttl_in_seconds=pulumi.get(__ret__, 'session_ttl_in_seconds'),
        ssh_metadata=pulumi.get(__ret__, 'ssh_metadata'),
        state=pulumi.get(__ret__, 'state'),
        target_resource_details=pulumi.get(__ret__, 'target_resource_details'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_session)
def get_session_output(session_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSessionResult]:
    """
    This data source provides details about a specific Session resource in Oracle Cloud Infrastructure Bastion service.

    Retrieves a session identified by the session ID. A bastion session lets authorized users connect to a target resource for a predetermined amount of time.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_session = oci.Bastion.get_session(session_id=test_session_oci_bastion_session["id"])
    ```


    :param str session_id: The unique identifier (OCID) of the session.
    """
    ...
