# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'LogConfigurationArgs',
    'LogConfigurationSourceArgs',
    'UnifiedAgentConfigurationGroupAssociationArgs',
    'UnifiedAgentConfigurationServiceConfigurationArgs',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationArgs',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestinationArgs',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceArgs',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptionsArgs',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserArgs',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParserArgs',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPatternArgs',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInputArgs',
    'UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilterArgs',
    'UnifiedAgentConfigurationServiceConfigurationDestinationArgs',
    'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationArgs',
    'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationArgs',
    'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceArgs',
    'UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputArgs',
    'UnifiedAgentConfigurationServiceConfigurationSourceArgs',
    'UnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptionsArgs',
    'UnifiedAgentConfigurationServiceConfigurationSourceParserArgs',
    'UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs',
    'UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs',
    'UnifiedAgentConfigurationServiceConfigurationSourceParserRecordInputArgs',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterArgs',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowListArgs',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSectionArgs',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyListArgs',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserArgs',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParserArgs',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPatternArgs',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInputArgs',
    'UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordListArgs',
    'GetLogGroupsFilterArgs',
    'GetLogSavedSearchesFilterArgs',
    'GetLogsFilterArgs',
    'GetUnifiedAgentConfigurationsFilterArgs',
]

@pulumi.input_type
class LogConfigurationArgs:
    def __init__(__self__, *,
                 source: pulumi.Input['LogConfigurationSourceArgs'],
                 compartment_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['LogConfigurationSourceArgs'] source: The source the log object comes from.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment that the resource belongs to.
        """
        pulumi.set(__self__, "source", source)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['LogConfigurationSourceArgs']:
        """
        The source the log object comes from.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['LogConfigurationSourceArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)


@pulumi.input_type
class LogConfigurationSourceArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[str],
                 resource: pulumi.Input[str],
                 service: pulumi.Input[str],
                 source_type: pulumi.Input[str],
                 parameters: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[str] category: Log object category.
        :param pulumi.Input[str] resource: The unique identifier of the resource emitting the log.
        :param pulumi.Input[str] service: Service generating log.
        :param pulumi.Input[str] source_type: The log source.
               * **OCISERVICE:** Oracle Service.
        :param pulumi.Input[Mapping[str, Any]] parameters: (Updatable) Log category parameters are stored here.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "source_type", source_type)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Input[str]:
        """
        Log object category.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[str]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def resource(self) -> pulumi.Input[str]:
        """
        The unique identifier of the resource emitting the log.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        Service generating log.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[str]:
        """
        The log source.
        * **OCISERVICE:** Oracle Service.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Log category parameters are stored here.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class UnifiedAgentConfigurationGroupAssociationArgs:
    def __init__(__self__, *,
                 group_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_lists: (Updatable) list of group/dynamic group ids associated with this configuration.
        """
        if group_lists is not None:
            pulumi.set(__self__, "group_lists", group_lists)

    @property
    @pulumi.getter(name="groupLists")
    def group_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) list of group/dynamic group ids associated with this configuration.
        """
        return pulumi.get(self, "group_lists")

    @group_lists.setter
    def group_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_lists", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationArgs:
    def __init__(__self__, *,
                 configuration_type: pulumi.Input[str],
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationArgs']]]] = None,
                 destination: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationArgs']] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceArgs']]]] = None,
                 unified_agent_configuration_filters: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterArgs']]]] = None):
        """
        :param pulumi.Input[str] configuration_type: (Updatable) Type of Unified Agent service configuration.
        :param pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationArgs']]] application_configurations: (Updatable) Unified Agent monitoring application configuration details.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationArgs'] destination: (Updatable) Unified monitoring agent operational metrics destination object.
        :param pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceArgs']]] sources: (Updatable) Logging source object.
        :param pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterArgs']]] unified_agent_configuration_filters: (Updatable) Logging filter object.
        """
        pulumi.set(__self__, "configuration_type", configuration_type)
        if application_configurations is not None:
            pulumi.set(__self__, "application_configurations", application_configurations)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if unified_agent_configuration_filters is not None:
            pulumi.set(__self__, "unified_agent_configuration_filters", unified_agent_configuration_filters)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of Unified Agent service configuration.
        """
        return pulumi.get(self, "configuration_type")

    @configuration_type.setter
    def configuration_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_type", value)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationArgs']]]]:
        """
        (Updatable) Unified Agent monitoring application configuration details.
        """
        return pulumi.get(self, "application_configurations")

    @application_configurations.setter
    def application_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationArgs']]]]):
        pulumi.set(self, "application_configurations", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationArgs']]:
        """
        (Updatable) Unified monitoring agent operational metrics destination object.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceArgs']]]]:
        """
        (Updatable) Logging source object.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter(name="unifiedAgentConfigurationFilters")
    def unified_agent_configuration_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterArgs']]]]:
        """
        (Updatable) Logging filter object.
        """
        return pulumi.get(self, "unified_agent_configuration_filters")

    @unified_agent_configuration_filters.setter
    def unified_agent_configuration_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterArgs']]]]):
        pulumi.set(self, "unified_agent_configuration_filters", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestinationArgs'],
                 source_type: pulumi.Input[str],
                 source: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceArgs']] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceArgs']]]] = None,
                 unified_agent_configuration_filter: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilterArgs']] = None):
        """
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestinationArgs'] destination: (Updatable) Unified monitoring agent operational metrics destination object.
        :param pulumi.Input[str] source_type: (Updatable) Unified schema logging source type.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceArgs'] source: (Updatable) Unified monitoring agent operational metrics source object.
        :param pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceArgs']]] sources: (Updatable) Logging source object.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilterArgs'] unified_agent_configuration_filter: (Updatable) Logging filter object.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "source_type", source_type)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if unified_agent_configuration_filter is not None:
            pulumi.set(__self__, "unified_agent_configuration_filter", unified_agent_configuration_filter)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestinationArgs']:
        """
        (Updatable) Unified monitoring agent operational metrics destination object.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestinationArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Unified schema logging source type.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceArgs']]:
        """
        (Updatable) Unified monitoring agent operational metrics source object.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceArgs']]]]:
        """
        (Updatable) Logging source object.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter(name="unifiedAgentConfigurationFilter")
    def unified_agent_configuration_filter(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilterArgs']]:
        """
        (Updatable) Logging filter object.
        """
        return pulumi.get(self, "unified_agent_configuration_filter")

    @unified_agent_configuration_filter.setter
    def unified_agent_configuration_filter(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilterArgs']]):
        pulumi.set(self, "unified_agent_configuration_filter", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationDestinationArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 metrics_namespace: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that the resource belongs to.
        :param pulumi.Input[str] metrics_namespace: (Updatable) Namespace to which metrics will be emitted.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if metrics_namespace is not None:
            pulumi.set(__self__, "metrics_namespace", metrics_namespace)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="metricsNamespace")
    def metrics_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Namespace to which metrics will be emitted.
        """
        return pulumi.get(self, "metrics_namespace")

    @metrics_namespace.setter
    def metrics_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metrics_namespace", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceArgs:
    def __init__(__self__, *,
                 advanced_options: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptionsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parser: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserArgs']] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptionsArgs'] advanced_options: (Updatable) Advanced options for logging configuration
        :param pulumi.Input[str] name: (Updatable) The name key to tag this Grok pattern.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserArgs'] parser: (Updatable) Source parser object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: (Updatable) Absolute paths for log source files. Wildcards can be used.
        :param pulumi.Input[str] source_type: (Updatable) Unified schema logging source type.
        """
        if advanced_options is not None:
            pulumi.set(__self__, "advanced_options", advanced_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parser is not None:
            pulumi.set(__self__, "parser", parser)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="advancedOptions")
    def advanced_options(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptionsArgs']]:
        """
        (Updatable) Advanced options for logging configuration
        """
        return pulumi.get(self, "advanced_options")

    @advanced_options.setter
    def advanced_options(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptionsArgs']]):
        pulumi.set(self, "advanced_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parser(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserArgs']]:
        """
        (Updatable) Source parser object.
        """
        return pulumi.get(self, "parser")

    @parser.setter
    def parser(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserArgs']]):
        pulumi.set(self, "parser", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Absolute paths for log source files. Wildcards can be used.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unified schema logging source type.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_type", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceAdvancedOptionsArgs:
    def __init__(__self__, *,
                 is_read_from_head: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] is_read_from_head: (Updatable) Starts to read the logs from the head of the file or the last read position recorded in pos_file, not tail.
        """
        if is_read_from_head is not None:
            pulumi.set(__self__, "is_read_from_head", is_read_from_head)

    @property
    @pulumi.getter(name="isReadFromHead")
    def is_read_from_head(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Starts to read the logs from the head of the file or the last read position recorded in pos_file, not tail.
        """
        return pulumi.get(self, "is_read_from_head")

    @is_read_from_head.setter
    def is_read_from_head(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_read_from_head", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserArgs:
    def __init__(__self__, *,
                 parser_type: pulumi.Input[str],
                 delimiter: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 field_time_key: Optional[pulumi.Input[str]] = None,
                 format_firstline: Optional[pulumi.Input[str]] = None,
                 formats: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 grok_failure_key: Optional[pulumi.Input[str]] = None,
                 grok_name_key: Optional[pulumi.Input[str]] = None,
                 is_estimate_current_event: Optional[pulumi.Input[bool]] = None,
                 is_keep_time_key: Optional[pulumi.Input[bool]] = None,
                 is_merge_cri_fields: Optional[pulumi.Input[bool]] = None,
                 is_null_empty_string: Optional[pulumi.Input[bool]] = None,
                 is_support_colonless_ident: Optional[pulumi.Input[bool]] = None,
                 is_with_priority: Optional[pulumi.Input[bool]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 message_format: Optional[pulumi.Input[str]] = None,
                 message_key: Optional[pulumi.Input[str]] = None,
                 multi_line_start_regexp: Optional[pulumi.Input[str]] = None,
                 nested_parser: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParserArgs']] = None,
                 null_value_pattern: Optional[pulumi.Input[str]] = None,
                 parse_nested: Optional[pulumi.Input[bool]] = None,
                 patterns: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPatternArgs']]]] = None,
                 record_input: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInputArgs']] = None,
                 rfc5424time_format: Optional[pulumi.Input[str]] = None,
                 separator: Optional[pulumi.Input[str]] = None,
                 syslog_parser_type: Optional[pulumi.Input[str]] = None,
                 time_format: Optional[pulumi.Input[str]] = None,
                 time_type: Optional[pulumi.Input[str]] = None,
                 timeout_in_milliseconds: Optional[pulumi.Input[int]] = None,
                 types: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[str] parser_type: (Updatable) Type of fluent parser.
        :param pulumi.Input[str] delimiter: (Updatable) CSV delimiter.
        :param pulumi.Input[str] expression: (Updatable) Regex pattern.
        :param pulumi.Input[str] field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param pulumi.Input[str] format_firstline: (Updatable) First line pattern format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] formats: (Updatable) Mutiline pattern format.
        :param pulumi.Input[str] grok_failure_key: (Updatable) Grok failure key.
        :param pulumi.Input[str] grok_name_key: (Updatable) Grok name key.
        :param pulumi.Input[bool] is_estimate_current_event: (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        :param pulumi.Input[bool] is_keep_time_key: (Updatable) If true, keep the time field in the record.
        :param pulumi.Input[bool] is_merge_cri_fields: (Updatable) If you don't need stream or logtag fields, set this to false.
        :param pulumi.Input[bool] is_null_empty_string: (Updatable) If true, an empty string field is replaced with a null value.
        :param pulumi.Input[bool] is_support_colonless_ident: (Updatable) Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        :param pulumi.Input[bool] is_with_priority: (Updatable) Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keys: (Updatable) CSV keys.
        :param pulumi.Input[str] message_format: (Updatable) Syslog message format.
        :param pulumi.Input[str] message_key: (Updatable) Specifies the field name to contain logs.
        :param pulumi.Input[str] multi_line_start_regexp: (Updatable) Multiline start regexp pattern.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParserArgs'] nested_parser: (Updatable) Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        :param pulumi.Input[str] null_value_pattern: (Updatable) Specify the null value pattern.
        :param pulumi.Input[bool] parse_nested: (Updatable) If true, a separator parameter can be further defined.
        :param pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPatternArgs']]] patterns: (Updatable) Grok pattern object.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInputArgs'] record_input: (Updatable) record section of openmetrics parser.
        :param pulumi.Input[str] rfc5424time_format: (Updatable) RFC 5424 time format.
        :param pulumi.Input[str] separator: (Updatable) Keys of adjacent levels are joined by the separator.
        :param pulumi.Input[str] syslog_parser_type: (Updatable) Syslog parser type.
        :param pulumi.Input[str] time_format: (Updatable) Process time value using the specified format.
        :param pulumi.Input[str] time_type: (Updatable) JSON parser time type.
        :param pulumi.Input[int] timeout_in_milliseconds: (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        :param pulumi.Input[Mapping[str, Any]] types: (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
               
               This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"
               
               is parsed as: 1362020400 (2013/02/28/ 12:00:00)
               
               record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        pulumi.set(__self__, "parser_type", parser_type)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if format_firstline is not None:
            pulumi.set(__self__, "format_firstline", format_firstline)
        if formats is not None:
            pulumi.set(__self__, "formats", formats)
        if grok_failure_key is not None:
            pulumi.set(__self__, "grok_failure_key", grok_failure_key)
        if grok_name_key is not None:
            pulumi.set(__self__, "grok_name_key", grok_name_key)
        if is_estimate_current_event is not None:
            pulumi.set(__self__, "is_estimate_current_event", is_estimate_current_event)
        if is_keep_time_key is not None:
            pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        if is_merge_cri_fields is not None:
            pulumi.set(__self__, "is_merge_cri_fields", is_merge_cri_fields)
        if is_null_empty_string is not None:
            pulumi.set(__self__, "is_null_empty_string", is_null_empty_string)
        if is_support_colonless_ident is not None:
            pulumi.set(__self__, "is_support_colonless_ident", is_support_colonless_ident)
        if is_with_priority is not None:
            pulumi.set(__self__, "is_with_priority", is_with_priority)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if message_key is not None:
            pulumi.set(__self__, "message_key", message_key)
        if multi_line_start_regexp is not None:
            pulumi.set(__self__, "multi_line_start_regexp", multi_line_start_regexp)
        if nested_parser is not None:
            pulumi.set(__self__, "nested_parser", nested_parser)
        if null_value_pattern is not None:
            pulumi.set(__self__, "null_value_pattern", null_value_pattern)
        if parse_nested is not None:
            pulumi.set(__self__, "parse_nested", parse_nested)
        if patterns is not None:
            pulumi.set(__self__, "patterns", patterns)
        if record_input is not None:
            pulumi.set(__self__, "record_input", record_input)
        if rfc5424time_format is not None:
            pulumi.set(__self__, "rfc5424time_format", rfc5424time_format)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)
        if syslog_parser_type is not None:
            pulumi.set(__self__, "syslog_parser_type", syslog_parser_type)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_type is not None:
            pulumi.set(__self__, "time_type", time_type)
        if timeout_in_milliseconds is not None:
            pulumi.set(__self__, "timeout_in_milliseconds", timeout_in_milliseconds)
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter(name="parserType")
    def parser_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of fluent parser.
        """
        return pulumi.get(self, "parser_type")

    @parser_type.setter
    def parser_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "parser_type", value)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) CSV delimiter.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Regex pattern.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @field_time_key.setter
    def field_time_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_key", value)

    @property
    @pulumi.getter(name="formatFirstline")
    def format_firstline(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) First line pattern format.
        """
        return pulumi.get(self, "format_firstline")

    @format_firstline.setter
    def format_firstline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format_firstline", value)

    @property
    @pulumi.getter
    def formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Mutiline pattern format.
        """
        return pulumi.get(self, "formats")

    @formats.setter
    def formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "formats", value)

    @property
    @pulumi.getter(name="grokFailureKey")
    def grok_failure_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Grok failure key.
        """
        return pulumi.get(self, "grok_failure_key")

    @grok_failure_key.setter
    def grok_failure_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grok_failure_key", value)

    @property
    @pulumi.getter(name="grokNameKey")
    def grok_name_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Grok name key.
        """
        return pulumi.get(self, "grok_name_key")

    @grok_name_key.setter
    def grok_name_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grok_name_key", value)

    @property
    @pulumi.getter(name="isEstimateCurrentEvent")
    def is_estimate_current_event(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        """
        return pulumi.get(self, "is_estimate_current_event")

    @is_estimate_current_event.setter
    def is_estimate_current_event(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_estimate_current_event", value)

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @is_keep_time_key.setter
    def is_keep_time_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_keep_time_key", value)

    @property
    @pulumi.getter(name="isMergeCriFields")
    def is_merge_cri_fields(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If you don't need stream or logtag fields, set this to false.
        """
        return pulumi.get(self, "is_merge_cri_fields")

    @is_merge_cri_fields.setter
    def is_merge_cri_fields(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_merge_cri_fields", value)

    @property
    @pulumi.getter(name="isNullEmptyString")
    def is_null_empty_string(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, an empty string field is replaced with a null value.
        """
        return pulumi.get(self, "is_null_empty_string")

    @is_null_empty_string.setter
    def is_null_empty_string(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_null_empty_string", value)

    @property
    @pulumi.getter(name="isSupportColonlessIdent")
    def is_support_colonless_ident(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        """
        return pulumi.get(self, "is_support_colonless_ident")

    @is_support_colonless_ident.setter
    def is_support_colonless_ident(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_support_colonless_ident", value)

    @property
    @pulumi.getter(name="isWithPriority")
    def is_with_priority(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        """
        return pulumi.get(self, "is_with_priority")

    @is_with_priority.setter
    def is_with_priority(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_with_priority", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) CSV keys.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Syslog message format.
        """
        return pulumi.get(self, "message_format")

    @message_format.setter
    def message_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_format", value)

    @property
    @pulumi.getter(name="messageKey")
    def message_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies the field name to contain logs.
        """
        return pulumi.get(self, "message_key")

    @message_key.setter
    def message_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_key", value)

    @property
    @pulumi.getter(name="multiLineStartRegexp")
    def multi_line_start_regexp(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Multiline start regexp pattern.
        """
        return pulumi.get(self, "multi_line_start_regexp")

    @multi_line_start_regexp.setter
    def multi_line_start_regexp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_line_start_regexp", value)

    @property
    @pulumi.getter(name="nestedParser")
    def nested_parser(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParserArgs']]:
        """
        (Updatable) Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        """
        return pulumi.get(self, "nested_parser")

    @nested_parser.setter
    def nested_parser(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParserArgs']]):
        pulumi.set(self, "nested_parser", value)

    @property
    @pulumi.getter(name="nullValuePattern")
    def null_value_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the null value pattern.
        """
        return pulumi.get(self, "null_value_pattern")

    @null_value_pattern.setter
    def null_value_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "null_value_pattern", value)

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @parse_nested.setter
    def parse_nested(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "parse_nested", value)

    @property
    @pulumi.getter
    def patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPatternArgs']]]]:
        """
        (Updatable) Grok pattern object.
        """
        return pulumi.get(self, "patterns")

    @patterns.setter
    def patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPatternArgs']]]]):
        pulumi.set(self, "patterns", value)

    @property
    @pulumi.getter(name="recordInput")
    def record_input(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInputArgs']]:
        """
        (Updatable) record section of openmetrics parser.
        """
        return pulumi.get(self, "record_input")

    @record_input.setter
    def record_input(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInputArgs']]):
        pulumi.set(self, "record_input", value)

    @property
    @pulumi.getter(name="rfc5424timeFormat")
    def rfc5424time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) RFC 5424 time format.
        """
        return pulumi.get(self, "rfc5424time_format")

    @rfc5424time_format.setter
    def rfc5424time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rfc5424time_format", value)

    @property
    @pulumi.getter
    def separator(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @separator.setter
    def separator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "separator", value)

    @property
    @pulumi.getter(name="syslogParserType")
    def syslog_parser_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Syslog parser type.
        """
        return pulumi.get(self, "syslog_parser_type")

    @syslog_parser_type.setter
    def syslog_parser_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "syslog_parser_type", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) JSON parser time type.
        """
        return pulumi.get(self, "time_type")

    @time_type.setter
    def time_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_type", value)

    @property
    @pulumi.getter(name="timeoutInMilliseconds")
    def timeout_in_milliseconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        """
        return pulumi.get(self, "timeout_in_milliseconds")

    @timeout_in_milliseconds.setter
    def timeout_in_milliseconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_milliseconds", value)

    @property
    @pulumi.getter
    def types(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>

        This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"

        is parsed as: 1362020400 (2013/02/28/ 12:00:00)

        record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "types", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserNestedParserArgs:
    def __init__(__self__, *,
                 field_time_key: Optional[pulumi.Input[str]] = None,
                 is_keep_time_key: Optional[pulumi.Input[bool]] = None,
                 parse_nested: Optional[pulumi.Input[bool]] = None,
                 separator: Optional[pulumi.Input[str]] = None,
                 time_format: Optional[pulumi.Input[str]] = None,
                 time_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param pulumi.Input[bool] is_keep_time_key: (Updatable) If true, keep the time field in the record.
        :param pulumi.Input[bool] parse_nested: (Updatable) If true, a separator parameter can be further defined.
        :param pulumi.Input[str] separator: (Updatable) Keys of adjacent levels are joined by the separator.
        :param pulumi.Input[str] time_format: (Updatable) Process time value using the specified format.
        :param pulumi.Input[str] time_type: (Updatable) JSON parser time type.
        """
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if is_keep_time_key is not None:
            pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        if parse_nested is not None:
            pulumi.set(__self__, "parse_nested", parse_nested)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_type is not None:
            pulumi.set(__self__, "time_type", time_type)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @field_time_key.setter
    def field_time_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_key", value)

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @is_keep_time_key.setter
    def is_keep_time_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_keep_time_key", value)

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @parse_nested.setter
    def parse_nested(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "parse_nested", value)

    @property
    @pulumi.getter
    def separator(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @separator.setter
    def separator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "separator", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) JSON parser time type.
        """
        return pulumi.get(self, "time_type")

    @time_type.setter
    def time_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_type", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserPatternArgs:
    def __init__(__self__, *,
                 field_time_format: Optional[pulumi.Input[str]] = None,
                 field_time_key: Optional[pulumi.Input[str]] = None,
                 field_time_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pattern: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] field_time_format: (Updatable) Process value using the specified format. This is available only when time_type is a string.
        :param pulumi.Input[str] field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param pulumi.Input[str] field_time_zone: (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        :param pulumi.Input[str] name: (Updatable) The name key to tag this Grok pattern.
        :param pulumi.Input[str] pattern: (Updatable) The Grok pattern.
        """
        if field_time_format is not None:
            pulumi.set(__self__, "field_time_format", field_time_format)
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if field_time_zone is not None:
            pulumi.set(__self__, "field_time_zone", field_time_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter(name="fieldTimeFormat")
    def field_time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Process value using the specified format. This is available only when time_type is a string.
        """
        return pulumi.get(self, "field_time_format")

    @field_time_format.setter
    def field_time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_format", value)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @field_time_key.setter
    def field_time_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_key", value)

    @property
    @pulumi.getter(name="fieldTimeZone")
    def field_time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        """
        return pulumi.get(self, "field_time_zone")

    @field_time_zone.setter
    def field_time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_zone", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Grok pattern.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationSourceParserRecordInputArgs:
    def __init__(__self__, *,
                 dimensions: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Mapping[str, Any]] dimensions: (Updatable) Dimensions to be added for metrics.
        :param pulumi.Input[str] namespace: (Updatable) Namespace to emit metrics.
        :param pulumi.Input[str] resource_group: (Updatable) Resource group to emit metrics.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Dimensions to be added for metrics.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Namespace to emit metrics.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Resource group to emit metrics.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationApplicationConfigurationUnifiedAgentConfigurationFilterArgs:
    def __init__(__self__, *,
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 deny_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 filter_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_lists: (Updatable) A list of filtering rules to include logs
        :param pulumi.Input[Sequence[pulumi.Input[str]]] deny_lists: (Updatable) A list of filtering rules to reject logs
        :param pulumi.Input[str] filter_type: (Updatable) Unified schema logging filter type.
        :param pulumi.Input[str] name: (Updatable) The name key to tag this Grok pattern.
        """
        if allow_lists is not None:
            pulumi.set(__self__, "allow_lists", allow_lists)
        if deny_lists is not None:
            pulumi.set(__self__, "deny_lists", deny_lists)
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of filtering rules to include logs
        """
        return pulumi.get(self, "allow_lists")

    @allow_lists.setter
    def allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_lists", value)

    @property
    @pulumi.getter(name="denyLists")
    def deny_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of filtering rules to reject logs
        """
        return pulumi.get(self, "deny_lists")

    @deny_lists.setter
    def deny_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "deny_lists", value)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unified schema logging filter type.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationDestinationArgs:
    def __init__(__self__, *,
                 log_object_id: pulumi.Input[str],
                 operational_metrics_configuration: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationArgs']] = None):
        """
        :param pulumi.Input[str] log_object_id: (Updatable) The OCID of the resource.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationArgs'] operational_metrics_configuration: (Updatable) Unified monitoring agent operational metrics configuration object.
        """
        pulumi.set(__self__, "log_object_id", log_object_id)
        if operational_metrics_configuration is not None:
            pulumi.set(__self__, "operational_metrics_configuration", operational_metrics_configuration)

    @property
    @pulumi.getter(name="logObjectId")
    def log_object_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the resource.
        """
        return pulumi.get(self, "log_object_id")

    @log_object_id.setter
    def log_object_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_object_id", value)

    @property
    @pulumi.getter(name="operationalMetricsConfiguration")
    def operational_metrics_configuration(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationArgs']]:
        """
        (Updatable) Unified monitoring agent operational metrics configuration object.
        """
        return pulumi.get(self, "operational_metrics_configuration")

    @operational_metrics_configuration.setter
    def operational_metrics_configuration(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationArgs']]):
        pulumi.set(self, "operational_metrics_configuration", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationArgs'],
                 source: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceArgs']):
        """
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationArgs'] destination: (Updatable) Unified monitoring agent operational metrics destination object.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceArgs'] source: (Updatable) Unified monitoring agent operational metrics source object.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationArgs']:
        """
        (Updatable) Unified monitoring agent operational metrics destination object.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceArgs']:
        """
        (Updatable) Unified monitoring agent operational metrics source object.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceArgs']):
        pulumi.set(self, "source", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationDestinationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that the resource belongs to.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment that the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceArgs:
    def __init__(__self__, *,
                 record_input: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputArgs'],
                 type: pulumi.Input[str],
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputArgs'] record_input: (Updatable) record section of openmetrics parser.
        :param pulumi.Input[str] type: (Updatable) Type of the unified monitoring agent operational metrics source object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] metrics: (Updatable) List of unified monitoring agent operational metrics.
        """
        pulumi.set(__self__, "record_input", record_input)
        pulumi.set(__self__, "type", type)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter(name="recordInput")
    def record_input(self) -> pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputArgs']:
        """
        (Updatable) record section of openmetrics parser.
        """
        return pulumi.get(self, "record_input")

    @record_input.setter
    def record_input(self, value: pulumi.Input['UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputArgs']):
        pulumi.set(self, "record_input", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of the unified monitoring agent operational metrics source object.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of unified monitoring agent operational metrics.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "metrics", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationDestinationOperationalMetricsConfigurationSourceRecordInputArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input[str],
                 resource_group: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] namespace: (Updatable) Namespace to emit metrics.
        :param pulumi.Input[str] resource_group: (Updatable) Resource group to emit metrics.
        """
        pulumi.set(__self__, "namespace", namespace)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        (Updatable) Namespace to emit metrics.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Resource group to emit metrics.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationSourceArgs:
    def __init__(__self__, *,
                 source_type: pulumi.Input[str],
                 advanced_options: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptionsArgs']] = None,
                 channels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_plugin: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parser: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserArgs']] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] source_type: (Updatable) Unified schema logging source type.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptionsArgs'] advanced_options: (Updatable) Advanced options for logging configuration
        :param pulumi.Input[Sequence[pulumi.Input[str]]] channels: (Updatable) Windows event log channels.
        :param pulumi.Input[str] custom_plugin: (Updatable) User customized source plugin.
        :param pulumi.Input[str] name: (Updatable) The name key to tag this Grok pattern.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserArgs'] parser: (Updatable) Source parser object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: (Updatable) Absolute paths for log source files. Wildcards can be used.
        """
        pulumi.set(__self__, "source_type", source_type)
        if advanced_options is not None:
            pulumi.set(__self__, "advanced_options", advanced_options)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if custom_plugin is not None:
            pulumi.set(__self__, "custom_plugin", custom_plugin)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parser is not None:
            pulumi.set(__self__, "parser", parser)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Unified schema logging source type.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter(name="advancedOptions")
    def advanced_options(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptionsArgs']]:
        """
        (Updatable) Advanced options for logging configuration
        """
        return pulumi.get(self, "advanced_options")

    @advanced_options.setter
    def advanced_options(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptionsArgs']]):
        pulumi.set(self, "advanced_options", value)

    @property
    @pulumi.getter
    def channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Windows event log channels.
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "channels", value)

    @property
    @pulumi.getter(name="customPlugin")
    def custom_plugin(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User customized source plugin.
        """
        return pulumi.get(self, "custom_plugin")

    @custom_plugin.setter
    def custom_plugin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_plugin", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parser(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserArgs']]:
        """
        (Updatable) Source parser object.
        """
        return pulumi.get(self, "parser")

    @parser.setter
    def parser(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserArgs']]):
        pulumi.set(self, "parser", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Absolute paths for log source files. Wildcards can be used.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationSourceAdvancedOptionsArgs:
    def __init__(__self__, *,
                 is_read_from_head: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] is_read_from_head: (Updatable) Starts to read the logs from the head of the file or the last read position recorded in pos_file, not tail.
        """
        if is_read_from_head is not None:
            pulumi.set(__self__, "is_read_from_head", is_read_from_head)

    @property
    @pulumi.getter(name="isReadFromHead")
    def is_read_from_head(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Starts to read the logs from the head of the file or the last read position recorded in pos_file, not tail.
        """
        return pulumi.get(self, "is_read_from_head")

    @is_read_from_head.setter
    def is_read_from_head(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_read_from_head", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationSourceParserArgs:
    def __init__(__self__, *,
                 parser_type: pulumi.Input[str],
                 delimiter: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 field_time_key: Optional[pulumi.Input[str]] = None,
                 format_firstline: Optional[pulumi.Input[str]] = None,
                 formats: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 grok_failure_key: Optional[pulumi.Input[str]] = None,
                 grok_name_key: Optional[pulumi.Input[str]] = None,
                 is_estimate_current_event: Optional[pulumi.Input[bool]] = None,
                 is_keep_time_key: Optional[pulumi.Input[bool]] = None,
                 is_merge_cri_fields: Optional[pulumi.Input[bool]] = None,
                 is_null_empty_string: Optional[pulumi.Input[bool]] = None,
                 is_support_colonless_ident: Optional[pulumi.Input[bool]] = None,
                 is_with_priority: Optional[pulumi.Input[bool]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 message_format: Optional[pulumi.Input[str]] = None,
                 message_key: Optional[pulumi.Input[str]] = None,
                 multi_line_start_regexp: Optional[pulumi.Input[str]] = None,
                 nested_parser: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs']] = None,
                 null_value_pattern: Optional[pulumi.Input[str]] = None,
                 parse_nested: Optional[pulumi.Input[bool]] = None,
                 patterns: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs']]]] = None,
                 record_input: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserRecordInputArgs']] = None,
                 rfc5424time_format: Optional[pulumi.Input[str]] = None,
                 separator: Optional[pulumi.Input[str]] = None,
                 syslog_parser_type: Optional[pulumi.Input[str]] = None,
                 time_format: Optional[pulumi.Input[str]] = None,
                 time_type: Optional[pulumi.Input[str]] = None,
                 timeout_in_milliseconds: Optional[pulumi.Input[int]] = None,
                 types: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[str] parser_type: (Updatable) Type of fluent parser.
        :param pulumi.Input[str] delimiter: (Updatable) CSV delimiter.
        :param pulumi.Input[str] expression: (Updatable) Regex pattern.
        :param pulumi.Input[str] field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param pulumi.Input[str] format_firstline: (Updatable) First line pattern format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] formats: (Updatable) Mutiline pattern format.
        :param pulumi.Input[str] grok_failure_key: (Updatable) Grok failure key.
        :param pulumi.Input[str] grok_name_key: (Updatable) Grok name key.
        :param pulumi.Input[bool] is_estimate_current_event: (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        :param pulumi.Input[bool] is_keep_time_key: (Updatable) If true, keep the time field in the record.
        :param pulumi.Input[bool] is_merge_cri_fields: (Updatable) If you don't need stream or logtag fields, set this to false.
        :param pulumi.Input[bool] is_null_empty_string: (Updatable) If true, an empty string field is replaced with a null value.
        :param pulumi.Input[bool] is_support_colonless_ident: (Updatable) Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        :param pulumi.Input[bool] is_with_priority: (Updatable) Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keys: (Updatable) CSV keys.
        :param pulumi.Input[str] message_format: (Updatable) Syslog message format.
        :param pulumi.Input[str] message_key: (Updatable) Specifies the field name to contain logs.
        :param pulumi.Input[str] multi_line_start_regexp: (Updatable) Multiline start regexp pattern.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs'] nested_parser: (Updatable) Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        :param pulumi.Input[str] null_value_pattern: (Updatable) Specify the null value pattern.
        :param pulumi.Input[bool] parse_nested: (Updatable) If true, a separator parameter can be further defined.
        :param pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs']]] patterns: (Updatable) Grok pattern object.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserRecordInputArgs'] record_input: (Updatable) record section of openmetrics parser.
        :param pulumi.Input[str] rfc5424time_format: (Updatable) RFC 5424 time format.
        :param pulumi.Input[str] separator: (Updatable) Keys of adjacent levels are joined by the separator.
        :param pulumi.Input[str] syslog_parser_type: (Updatable) Syslog parser type.
        :param pulumi.Input[str] time_format: (Updatable) Process time value using the specified format.
        :param pulumi.Input[str] time_type: (Updatable) JSON parser time type.
        :param pulumi.Input[int] timeout_in_milliseconds: (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        :param pulumi.Input[Mapping[str, Any]] types: (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
               
               This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"
               
               is parsed as: 1362020400 (2013/02/28/ 12:00:00)
               
               record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        pulumi.set(__self__, "parser_type", parser_type)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if format_firstline is not None:
            pulumi.set(__self__, "format_firstline", format_firstline)
        if formats is not None:
            pulumi.set(__self__, "formats", formats)
        if grok_failure_key is not None:
            pulumi.set(__self__, "grok_failure_key", grok_failure_key)
        if grok_name_key is not None:
            pulumi.set(__self__, "grok_name_key", grok_name_key)
        if is_estimate_current_event is not None:
            pulumi.set(__self__, "is_estimate_current_event", is_estimate_current_event)
        if is_keep_time_key is not None:
            pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        if is_merge_cri_fields is not None:
            pulumi.set(__self__, "is_merge_cri_fields", is_merge_cri_fields)
        if is_null_empty_string is not None:
            pulumi.set(__self__, "is_null_empty_string", is_null_empty_string)
        if is_support_colonless_ident is not None:
            pulumi.set(__self__, "is_support_colonless_ident", is_support_colonless_ident)
        if is_with_priority is not None:
            pulumi.set(__self__, "is_with_priority", is_with_priority)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if message_key is not None:
            pulumi.set(__self__, "message_key", message_key)
        if multi_line_start_regexp is not None:
            pulumi.set(__self__, "multi_line_start_regexp", multi_line_start_regexp)
        if nested_parser is not None:
            pulumi.set(__self__, "nested_parser", nested_parser)
        if null_value_pattern is not None:
            pulumi.set(__self__, "null_value_pattern", null_value_pattern)
        if parse_nested is not None:
            pulumi.set(__self__, "parse_nested", parse_nested)
        if patterns is not None:
            pulumi.set(__self__, "patterns", patterns)
        if record_input is not None:
            pulumi.set(__self__, "record_input", record_input)
        if rfc5424time_format is not None:
            pulumi.set(__self__, "rfc5424time_format", rfc5424time_format)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)
        if syslog_parser_type is not None:
            pulumi.set(__self__, "syslog_parser_type", syslog_parser_type)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_type is not None:
            pulumi.set(__self__, "time_type", time_type)
        if timeout_in_milliseconds is not None:
            pulumi.set(__self__, "timeout_in_milliseconds", timeout_in_milliseconds)
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter(name="parserType")
    def parser_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of fluent parser.
        """
        return pulumi.get(self, "parser_type")

    @parser_type.setter
    def parser_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "parser_type", value)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) CSV delimiter.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Regex pattern.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @field_time_key.setter
    def field_time_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_key", value)

    @property
    @pulumi.getter(name="formatFirstline")
    def format_firstline(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) First line pattern format.
        """
        return pulumi.get(self, "format_firstline")

    @format_firstline.setter
    def format_firstline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format_firstline", value)

    @property
    @pulumi.getter
    def formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Mutiline pattern format.
        """
        return pulumi.get(self, "formats")

    @formats.setter
    def formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "formats", value)

    @property
    @pulumi.getter(name="grokFailureKey")
    def grok_failure_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Grok failure key.
        """
        return pulumi.get(self, "grok_failure_key")

    @grok_failure_key.setter
    def grok_failure_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grok_failure_key", value)

    @property
    @pulumi.getter(name="grokNameKey")
    def grok_name_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Grok name key.
        """
        return pulumi.get(self, "grok_name_key")

    @grok_name_key.setter
    def grok_name_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grok_name_key", value)

    @property
    @pulumi.getter(name="isEstimateCurrentEvent")
    def is_estimate_current_event(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        """
        return pulumi.get(self, "is_estimate_current_event")

    @is_estimate_current_event.setter
    def is_estimate_current_event(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_estimate_current_event", value)

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @is_keep_time_key.setter
    def is_keep_time_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_keep_time_key", value)

    @property
    @pulumi.getter(name="isMergeCriFields")
    def is_merge_cri_fields(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If you don't need stream or logtag fields, set this to false.
        """
        return pulumi.get(self, "is_merge_cri_fields")

    @is_merge_cri_fields.setter
    def is_merge_cri_fields(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_merge_cri_fields", value)

    @property
    @pulumi.getter(name="isNullEmptyString")
    def is_null_empty_string(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, an empty string field is replaced with a null value.
        """
        return pulumi.get(self, "is_null_empty_string")

    @is_null_empty_string.setter
    def is_null_empty_string(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_null_empty_string", value)

    @property
    @pulumi.getter(name="isSupportColonlessIdent")
    def is_support_colonless_ident(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        """
        return pulumi.get(self, "is_support_colonless_ident")

    @is_support_colonless_ident.setter
    def is_support_colonless_ident(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_support_colonless_ident", value)

    @property
    @pulumi.getter(name="isWithPriority")
    def is_with_priority(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        """
        return pulumi.get(self, "is_with_priority")

    @is_with_priority.setter
    def is_with_priority(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_with_priority", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) CSV keys.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Syslog message format.
        """
        return pulumi.get(self, "message_format")

    @message_format.setter
    def message_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_format", value)

    @property
    @pulumi.getter(name="messageKey")
    def message_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies the field name to contain logs.
        """
        return pulumi.get(self, "message_key")

    @message_key.setter
    def message_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_key", value)

    @property
    @pulumi.getter(name="multiLineStartRegexp")
    def multi_line_start_regexp(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Multiline start regexp pattern.
        """
        return pulumi.get(self, "multi_line_start_regexp")

    @multi_line_start_regexp.setter
    def multi_line_start_regexp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_line_start_regexp", value)

    @property
    @pulumi.getter(name="nestedParser")
    def nested_parser(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs']]:
        """
        (Updatable) Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        """
        return pulumi.get(self, "nested_parser")

    @nested_parser.setter
    def nested_parser(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs']]):
        pulumi.set(self, "nested_parser", value)

    @property
    @pulumi.getter(name="nullValuePattern")
    def null_value_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the null value pattern.
        """
        return pulumi.get(self, "null_value_pattern")

    @null_value_pattern.setter
    def null_value_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "null_value_pattern", value)

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @parse_nested.setter
    def parse_nested(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "parse_nested", value)

    @property
    @pulumi.getter
    def patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs']]]]:
        """
        (Updatable) Grok pattern object.
        """
        return pulumi.get(self, "patterns")

    @patterns.setter
    def patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs']]]]):
        pulumi.set(self, "patterns", value)

    @property
    @pulumi.getter(name="recordInput")
    def record_input(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserRecordInputArgs']]:
        """
        (Updatable) record section of openmetrics parser.
        """
        return pulumi.get(self, "record_input")

    @record_input.setter
    def record_input(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationSourceParserRecordInputArgs']]):
        pulumi.set(self, "record_input", value)

    @property
    @pulumi.getter(name="rfc5424timeFormat")
    def rfc5424time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) RFC 5424 time format.
        """
        return pulumi.get(self, "rfc5424time_format")

    @rfc5424time_format.setter
    def rfc5424time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rfc5424time_format", value)

    @property
    @pulumi.getter
    def separator(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @separator.setter
    def separator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "separator", value)

    @property
    @pulumi.getter(name="syslogParserType")
    def syslog_parser_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Syslog parser type.
        """
        return pulumi.get(self, "syslog_parser_type")

    @syslog_parser_type.setter
    def syslog_parser_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "syslog_parser_type", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) JSON parser time type.
        """
        return pulumi.get(self, "time_type")

    @time_type.setter
    def time_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_type", value)

    @property
    @pulumi.getter(name="timeoutInMilliseconds")
    def timeout_in_milliseconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        """
        return pulumi.get(self, "timeout_in_milliseconds")

    @timeout_in_milliseconds.setter
    def timeout_in_milliseconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_milliseconds", value)

    @property
    @pulumi.getter
    def types(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>

        This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"

        is parsed as: 1362020400 (2013/02/28/ 12:00:00)

        record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "types", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationSourceParserNestedParserArgs:
    def __init__(__self__, *,
                 field_time_key: Optional[pulumi.Input[str]] = None,
                 is_keep_time_key: Optional[pulumi.Input[bool]] = None,
                 parse_nested: Optional[pulumi.Input[bool]] = None,
                 separator: Optional[pulumi.Input[str]] = None,
                 time_format: Optional[pulumi.Input[str]] = None,
                 time_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param pulumi.Input[bool] is_keep_time_key: (Updatable) If true, keep the time field in the record.
        :param pulumi.Input[bool] parse_nested: (Updatable) If true, a separator parameter can be further defined.
        :param pulumi.Input[str] separator: (Updatable) Keys of adjacent levels are joined by the separator.
        :param pulumi.Input[str] time_format: (Updatable) Process time value using the specified format.
        :param pulumi.Input[str] time_type: (Updatable) JSON parser time type.
        """
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if is_keep_time_key is not None:
            pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        if parse_nested is not None:
            pulumi.set(__self__, "parse_nested", parse_nested)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_type is not None:
            pulumi.set(__self__, "time_type", time_type)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @field_time_key.setter
    def field_time_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_key", value)

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @is_keep_time_key.setter
    def is_keep_time_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_keep_time_key", value)

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @parse_nested.setter
    def parse_nested(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "parse_nested", value)

    @property
    @pulumi.getter
    def separator(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @separator.setter
    def separator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "separator", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) JSON parser time type.
        """
        return pulumi.get(self, "time_type")

    @time_type.setter
    def time_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_type", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationSourceParserPatternArgs:
    def __init__(__self__, *,
                 field_time_format: Optional[pulumi.Input[str]] = None,
                 field_time_key: Optional[pulumi.Input[str]] = None,
                 field_time_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pattern: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] field_time_format: (Updatable) Process value using the specified format. This is available only when time_type is a string.
        :param pulumi.Input[str] field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param pulumi.Input[str] field_time_zone: (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        :param pulumi.Input[str] name: (Updatable) The name key to tag this Grok pattern.
        :param pulumi.Input[str] pattern: (Updatable) The Grok pattern.
        """
        if field_time_format is not None:
            pulumi.set(__self__, "field_time_format", field_time_format)
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if field_time_zone is not None:
            pulumi.set(__self__, "field_time_zone", field_time_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter(name="fieldTimeFormat")
    def field_time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Process value using the specified format. This is available only when time_type is a string.
        """
        return pulumi.get(self, "field_time_format")

    @field_time_format.setter
    def field_time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_format", value)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @field_time_key.setter
    def field_time_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_key", value)

    @property
    @pulumi.getter(name="fieldTimeZone")
    def field_time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        """
        return pulumi.get(self, "field_time_zone")

    @field_time_zone.setter
    def field_time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_zone", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Grok pattern.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationSourceParserRecordInputArgs:
    def __init__(__self__, *,
                 dimensions: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Mapping[str, Any]] dimensions: (Updatable) Dimensions to be added for metrics.
        :param pulumi.Input[str] namespace: (Updatable) Namespace to emit metrics.
        :param pulumi.Input[str] resource_group: (Updatable) Resource group to emit metrics.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Dimensions to be added for metrics.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Namespace to emit metrics.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Resource group to emit metrics.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterArgs:
    def __init__(__self__, *,
                 filter_type: pulumi.Input[str],
                 name: pulumi.Input[str],
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowListArgs']]]] = None,
                 custom_filter_type: Optional[pulumi.Input[str]] = None,
                 custom_sections: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSectionArgs']]]] = None,
                 deny_lists: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyListArgs']]]] = None,
                 emit_invalid_record_to_error: Optional[pulumi.Input[bool]] = None,
                 hash_value_field: Optional[pulumi.Input[str]] = None,
                 inject_key_prefix: Optional[pulumi.Input[str]] = None,
                 is_auto_typecast_enabled: Optional[pulumi.Input[bool]] = None,
                 is_renew_record_enabled: Optional[pulumi.Input[bool]] = None,
                 is_ruby_enabled: Optional[pulumi.Input[bool]] = None,
                 keep_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 params: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 parser: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserArgs']] = None,
                 record_lists: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordListArgs']]]] = None,
                 remove_key_name_field: Optional[pulumi.Input[bool]] = None,
                 remove_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 renew_time_key: Optional[pulumi.Input[str]] = None,
                 replace_invalid_sequence: Optional[pulumi.Input[bool]] = None,
                 reserve_data: Optional[pulumi.Input[bool]] = None,
                 reserve_time: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] filter_type: (Updatable) Unified schema logging filter type.
        :param pulumi.Input[str] name: (Updatable) The name key to tag this Grok pattern.
        :param pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowListArgs']]] allow_lists: (Updatable) A list of filtering rules to include logs
        :param pulumi.Input[str] custom_filter_type: (Updatable) Type of the custom filter
        :param pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSectionArgs']]] custom_sections: (Updatable) List of custom sections in custom filter
        :param pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyListArgs']]] deny_lists: (Updatable) A list of filtering rules to reject logs
        :param pulumi.Input[bool] emit_invalid_record_to_error: (Updatable) If true, emit invalid record to @ERROR label. Invalid cases are: 1) key does not exist; 2) the format does not match; or 3) an unexpected error. You can rescue unexpected format logs in the @ERROR lable. If you want to ignore these errors, set this to false.
        :param pulumi.Input[str] hash_value_field: (Updatable) Store the parsed values as a hash value in a field.
        :param pulumi.Input[str] inject_key_prefix: (Updatable) Store the parsed values with the specified key name prefix.
        :param pulumi.Input[bool] is_auto_typecast_enabled: (Updatable) If true, automatically casts the field types.
        :param pulumi.Input[bool] is_renew_record_enabled: (Updatable) If true, it modifies a new empty hash
        :param pulumi.Input[bool] is_ruby_enabled: (Updatable) When set to true, the full Ruby syntax is enabled in the ${} expression.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keep_keys: (Updatable) A list of keys to keep. Only relevant if isRenewRecordEnabled is set to true
        :param pulumi.Input[str] key_name: (Updatable) The field name in the record to parse.
        :param pulumi.Input[Mapping[str, Any]] params: (Updatable) Parameters of the custom filter
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserArgs'] parser: (Updatable) Source parser object.
        :param pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordListArgs']]] record_lists: (Updatable) Add new key-value pairs in logs
        :param pulumi.Input[bool] remove_key_name_field: (Updatable) If true, remove the keyName field when parsing is succeeded.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remove_keys: (Updatable) A list of keys to delete
        :param pulumi.Input[str] renew_time_key: (Updatable) Overwrites the time of logs with this value, this value must be a Unix timestamp.
        :param pulumi.Input[bool] replace_invalid_sequence: (Updatable) If true, the invalid string is replaced with safe characters and is re-parsed.
        :param pulumi.Input[bool] reserve_data: (Updatable) If true, keep the original key-value pair in the parsed result.
        :param pulumi.Input[bool] reserve_time: (Updatable) If true, keep the original event time in the parsed result.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "filter_type", filter_type)
        pulumi.set(__self__, "name", name)
        if allow_lists is not None:
            pulumi.set(__self__, "allow_lists", allow_lists)
        if custom_filter_type is not None:
            pulumi.set(__self__, "custom_filter_type", custom_filter_type)
        if custom_sections is not None:
            pulumi.set(__self__, "custom_sections", custom_sections)
        if deny_lists is not None:
            pulumi.set(__self__, "deny_lists", deny_lists)
        if emit_invalid_record_to_error is not None:
            pulumi.set(__self__, "emit_invalid_record_to_error", emit_invalid_record_to_error)
        if hash_value_field is not None:
            pulumi.set(__self__, "hash_value_field", hash_value_field)
        if inject_key_prefix is not None:
            pulumi.set(__self__, "inject_key_prefix", inject_key_prefix)
        if is_auto_typecast_enabled is not None:
            pulumi.set(__self__, "is_auto_typecast_enabled", is_auto_typecast_enabled)
        if is_renew_record_enabled is not None:
            pulumi.set(__self__, "is_renew_record_enabled", is_renew_record_enabled)
        if is_ruby_enabled is not None:
            pulumi.set(__self__, "is_ruby_enabled", is_ruby_enabled)
        if keep_keys is not None:
            pulumi.set(__self__, "keep_keys", keep_keys)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if parser is not None:
            pulumi.set(__self__, "parser", parser)
        if record_lists is not None:
            pulumi.set(__self__, "record_lists", record_lists)
        if remove_key_name_field is not None:
            pulumi.set(__self__, "remove_key_name_field", remove_key_name_field)
        if remove_keys is not None:
            pulumi.set(__self__, "remove_keys", remove_keys)
        if renew_time_key is not None:
            pulumi.set(__self__, "renew_time_key", renew_time_key)
        if replace_invalid_sequence is not None:
            pulumi.set(__self__, "replace_invalid_sequence", replace_invalid_sequence)
        if reserve_data is not None:
            pulumi.set(__self__, "reserve_data", reserve_data)
        if reserve_time is not None:
            pulumi.set(__self__, "reserve_time", reserve_time)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Unified schema logging filter type.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "filter_type", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowListArgs']]]]:
        """
        (Updatable) A list of filtering rules to include logs
        """
        return pulumi.get(self, "allow_lists")

    @allow_lists.setter
    def allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowListArgs']]]]):
        pulumi.set(self, "allow_lists", value)

    @property
    @pulumi.getter(name="customFilterType")
    def custom_filter_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of the custom filter
        """
        return pulumi.get(self, "custom_filter_type")

    @custom_filter_type.setter
    def custom_filter_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_filter_type", value)

    @property
    @pulumi.getter(name="customSections")
    def custom_sections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSectionArgs']]]]:
        """
        (Updatable) List of custom sections in custom filter
        """
        return pulumi.get(self, "custom_sections")

    @custom_sections.setter
    def custom_sections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSectionArgs']]]]):
        pulumi.set(self, "custom_sections", value)

    @property
    @pulumi.getter(name="denyLists")
    def deny_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyListArgs']]]]:
        """
        (Updatable) A list of filtering rules to reject logs
        """
        return pulumi.get(self, "deny_lists")

    @deny_lists.setter
    def deny_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyListArgs']]]]):
        pulumi.set(self, "deny_lists", value)

    @property
    @pulumi.getter(name="emitInvalidRecordToError")
    def emit_invalid_record_to_error(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, emit invalid record to @ERROR label. Invalid cases are: 1) key does not exist; 2) the format does not match; or 3) an unexpected error. You can rescue unexpected format logs in the @ERROR lable. If you want to ignore these errors, set this to false.
        """
        return pulumi.get(self, "emit_invalid_record_to_error")

    @emit_invalid_record_to_error.setter
    def emit_invalid_record_to_error(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "emit_invalid_record_to_error", value)

    @property
    @pulumi.getter(name="hashValueField")
    def hash_value_field(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Store the parsed values as a hash value in a field.
        """
        return pulumi.get(self, "hash_value_field")

    @hash_value_field.setter
    def hash_value_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hash_value_field", value)

    @property
    @pulumi.getter(name="injectKeyPrefix")
    def inject_key_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Store the parsed values with the specified key name prefix.
        """
        return pulumi.get(self, "inject_key_prefix")

    @inject_key_prefix.setter
    def inject_key_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inject_key_prefix", value)

    @property
    @pulumi.getter(name="isAutoTypecastEnabled")
    def is_auto_typecast_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, automatically casts the field types.
        """
        return pulumi.get(self, "is_auto_typecast_enabled")

    @is_auto_typecast_enabled.setter
    def is_auto_typecast_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_typecast_enabled", value)

    @property
    @pulumi.getter(name="isRenewRecordEnabled")
    def is_renew_record_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, it modifies a new empty hash
        """
        return pulumi.get(self, "is_renew_record_enabled")

    @is_renew_record_enabled.setter
    def is_renew_record_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_renew_record_enabled", value)

    @property
    @pulumi.getter(name="isRubyEnabled")
    def is_ruby_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) When set to true, the full Ruby syntax is enabled in the ${} expression.
        """
        return pulumi.get(self, "is_ruby_enabled")

    @is_ruby_enabled.setter
    def is_ruby_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ruby_enabled", value)

    @property
    @pulumi.getter(name="keepKeys")
    def keep_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of keys to keep. Only relevant if isRenewRecordEnabled is set to true
        """
        return pulumi.get(self, "keep_keys")

    @keep_keys.setter
    def keep_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "keep_keys", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The field name in the record to parse.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Parameters of the custom filter
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "params", value)

    @property
    @pulumi.getter
    def parser(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserArgs']]:
        """
        (Updatable) Source parser object.
        """
        return pulumi.get(self, "parser")

    @parser.setter
    def parser(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserArgs']]):
        pulumi.set(self, "parser", value)

    @property
    @pulumi.getter(name="recordLists")
    def record_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordListArgs']]]]:
        """
        (Updatable) Add new key-value pairs in logs
        """
        return pulumi.get(self, "record_lists")

    @record_lists.setter
    def record_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordListArgs']]]]):
        pulumi.set(self, "record_lists", value)

    @property
    @pulumi.getter(name="removeKeyNameField")
    def remove_key_name_field(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, remove the keyName field when parsing is succeeded.
        """
        return pulumi.get(self, "remove_key_name_field")

    @remove_key_name_field.setter
    def remove_key_name_field(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_key_name_field", value)

    @property
    @pulumi.getter(name="removeKeys")
    def remove_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of keys to delete
        """
        return pulumi.get(self, "remove_keys")

    @remove_keys.setter
    def remove_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "remove_keys", value)

    @property
    @pulumi.getter(name="renewTimeKey")
    def renew_time_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Overwrites the time of logs with this value, this value must be a Unix timestamp.
        """
        return pulumi.get(self, "renew_time_key")

    @renew_time_key.setter
    def renew_time_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renew_time_key", value)

    @property
    @pulumi.getter(name="replaceInvalidSequence")
    def replace_invalid_sequence(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, the invalid string is replaced with safe characters and is re-parsed.
        """
        return pulumi.get(self, "replace_invalid_sequence")

    @replace_invalid_sequence.setter
    def replace_invalid_sequence(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replace_invalid_sequence", value)

    @property
    @pulumi.getter(name="reserveData")
    def reserve_data(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, keep the original key-value pair in the parsed result.
        """
        return pulumi.get(self, "reserve_data")

    @reserve_data.setter
    def reserve_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reserve_data", value)

    @property
    @pulumi.getter(name="reserveTime")
    def reserve_time(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, keep the original event time in the parsed result.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "reserve_time")

    @reserve_time.setter
    def reserve_time(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reserve_time", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterAllowListArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 pattern: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: (Updatable) A new key
        :param pulumi.Input[str] pattern: (Updatable) The Grok pattern.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A new key
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Grok pattern.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterCustomSectionArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 params: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[str] name: (Updatable) The name key to tag this Grok pattern.
        :param pulumi.Input[Mapping[str, Any]] params: (Updatable) Parameters of the custom filter
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if params is not None:
            pulumi.set(__self__, "params", params)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Parameters of the custom filter
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "params", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterDenyListArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 pattern: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: (Updatable) A new key
        :param pulumi.Input[str] pattern: (Updatable) The Grok pattern.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A new key
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Grok pattern.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserArgs:
    def __init__(__self__, *,
                 parser_type: pulumi.Input[str],
                 delimiter: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 field_time_key: Optional[pulumi.Input[str]] = None,
                 format_firstline: Optional[pulumi.Input[str]] = None,
                 formats: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 grok_failure_key: Optional[pulumi.Input[str]] = None,
                 grok_name_key: Optional[pulumi.Input[str]] = None,
                 is_estimate_current_event: Optional[pulumi.Input[bool]] = None,
                 is_keep_time_key: Optional[pulumi.Input[bool]] = None,
                 is_merge_cri_fields: Optional[pulumi.Input[bool]] = None,
                 is_null_empty_string: Optional[pulumi.Input[bool]] = None,
                 is_support_colonless_ident: Optional[pulumi.Input[bool]] = None,
                 is_with_priority: Optional[pulumi.Input[bool]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 message_format: Optional[pulumi.Input[str]] = None,
                 message_key: Optional[pulumi.Input[str]] = None,
                 multi_line_start_regexp: Optional[pulumi.Input[str]] = None,
                 nested_parser: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParserArgs']] = None,
                 null_value_pattern: Optional[pulumi.Input[str]] = None,
                 parse_nested: Optional[pulumi.Input[bool]] = None,
                 patterns: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPatternArgs']]]] = None,
                 record_input: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInputArgs']] = None,
                 rfc5424time_format: Optional[pulumi.Input[str]] = None,
                 separator: Optional[pulumi.Input[str]] = None,
                 syslog_parser_type: Optional[pulumi.Input[str]] = None,
                 time_format: Optional[pulumi.Input[str]] = None,
                 time_type: Optional[pulumi.Input[str]] = None,
                 timeout_in_milliseconds: Optional[pulumi.Input[int]] = None,
                 types: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[str] parser_type: (Updatable) Type of fluent parser.
        :param pulumi.Input[str] delimiter: (Updatable) CSV delimiter.
        :param pulumi.Input[str] expression: (Updatable) Regex pattern.
        :param pulumi.Input[str] field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param pulumi.Input[str] format_firstline: (Updatable) First line pattern format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] formats: (Updatable) Mutiline pattern format.
        :param pulumi.Input[str] grok_failure_key: (Updatable) Grok failure key.
        :param pulumi.Input[str] grok_name_key: (Updatable) Grok name key.
        :param pulumi.Input[bool] is_estimate_current_event: (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        :param pulumi.Input[bool] is_keep_time_key: (Updatable) If true, keep the time field in the record.
        :param pulumi.Input[bool] is_merge_cri_fields: (Updatable) If you don't need stream or logtag fields, set this to false.
        :param pulumi.Input[bool] is_null_empty_string: (Updatable) If true, an empty string field is replaced with a null value.
        :param pulumi.Input[bool] is_support_colonless_ident: (Updatable) Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        :param pulumi.Input[bool] is_with_priority: (Updatable) Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keys: (Updatable) CSV keys.
        :param pulumi.Input[str] message_format: (Updatable) Syslog message format.
        :param pulumi.Input[str] message_key: (Updatable) Specifies the field name to contain logs.
        :param pulumi.Input[str] multi_line_start_regexp: (Updatable) Multiline start regexp pattern.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParserArgs'] nested_parser: (Updatable) Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        :param pulumi.Input[str] null_value_pattern: (Updatable) Specify the null value pattern.
        :param pulumi.Input[bool] parse_nested: (Updatable) If true, a separator parameter can be further defined.
        :param pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPatternArgs']]] patterns: (Updatable) Grok pattern object.
        :param pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInputArgs'] record_input: (Updatable) record section of openmetrics parser.
        :param pulumi.Input[str] rfc5424time_format: (Updatable) RFC 5424 time format.
        :param pulumi.Input[str] separator: (Updatable) Keys of adjacent levels are joined by the separator.
        :param pulumi.Input[str] syslog_parser_type: (Updatable) Syslog parser type.
        :param pulumi.Input[str] time_format: (Updatable) Process time value using the specified format.
        :param pulumi.Input[str] time_type: (Updatable) JSON parser time type.
        :param pulumi.Input[int] timeout_in_milliseconds: (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        :param pulumi.Input[Mapping[str, Any]] types: (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>
               
               This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"
               
               is parsed as: 1362020400 (2013/02/28/ 12:00:00)
               
               record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        pulumi.set(__self__, "parser_type", parser_type)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if format_firstline is not None:
            pulumi.set(__self__, "format_firstline", format_firstline)
        if formats is not None:
            pulumi.set(__self__, "formats", formats)
        if grok_failure_key is not None:
            pulumi.set(__self__, "grok_failure_key", grok_failure_key)
        if grok_name_key is not None:
            pulumi.set(__self__, "grok_name_key", grok_name_key)
        if is_estimate_current_event is not None:
            pulumi.set(__self__, "is_estimate_current_event", is_estimate_current_event)
        if is_keep_time_key is not None:
            pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        if is_merge_cri_fields is not None:
            pulumi.set(__self__, "is_merge_cri_fields", is_merge_cri_fields)
        if is_null_empty_string is not None:
            pulumi.set(__self__, "is_null_empty_string", is_null_empty_string)
        if is_support_colonless_ident is not None:
            pulumi.set(__self__, "is_support_colonless_ident", is_support_colonless_ident)
        if is_with_priority is not None:
            pulumi.set(__self__, "is_with_priority", is_with_priority)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if message_key is not None:
            pulumi.set(__self__, "message_key", message_key)
        if multi_line_start_regexp is not None:
            pulumi.set(__self__, "multi_line_start_regexp", multi_line_start_regexp)
        if nested_parser is not None:
            pulumi.set(__self__, "nested_parser", nested_parser)
        if null_value_pattern is not None:
            pulumi.set(__self__, "null_value_pattern", null_value_pattern)
        if parse_nested is not None:
            pulumi.set(__self__, "parse_nested", parse_nested)
        if patterns is not None:
            pulumi.set(__self__, "patterns", patterns)
        if record_input is not None:
            pulumi.set(__self__, "record_input", record_input)
        if rfc5424time_format is not None:
            pulumi.set(__self__, "rfc5424time_format", rfc5424time_format)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)
        if syslog_parser_type is not None:
            pulumi.set(__self__, "syslog_parser_type", syslog_parser_type)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_type is not None:
            pulumi.set(__self__, "time_type", time_type)
        if timeout_in_milliseconds is not None:
            pulumi.set(__self__, "timeout_in_milliseconds", timeout_in_milliseconds)
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter(name="parserType")
    def parser_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Type of fluent parser.
        """
        return pulumi.get(self, "parser_type")

    @parser_type.setter
    def parser_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "parser_type", value)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) CSV delimiter.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Regex pattern.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @field_time_key.setter
    def field_time_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_key", value)

    @property
    @pulumi.getter(name="formatFirstline")
    def format_firstline(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) First line pattern format.
        """
        return pulumi.get(self, "format_firstline")

    @format_firstline.setter
    def format_firstline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format_firstline", value)

    @property
    @pulumi.getter
    def formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Mutiline pattern format.
        """
        return pulumi.get(self, "formats")

    @formats.setter
    def formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "formats", value)

    @property
    @pulumi.getter(name="grokFailureKey")
    def grok_failure_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Grok failure key.
        """
        return pulumi.get(self, "grok_failure_key")

    @grok_failure_key.setter
    def grok_failure_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grok_failure_key", value)

    @property
    @pulumi.getter(name="grokNameKey")
    def grok_name_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Grok name key.
        """
        return pulumi.get(self, "grok_name_key")

    @grok_name_key.setter
    def grok_name_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grok_name_key", value)

    @property
    @pulumi.getter(name="isEstimateCurrentEvent")
    def is_estimate_current_event(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, use Fluent::EventTime.now(current time) as a timestamp when the time_key is specified.
        """
        return pulumi.get(self, "is_estimate_current_event")

    @is_estimate_current_event.setter
    def is_estimate_current_event(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_estimate_current_event", value)

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @is_keep_time_key.setter
    def is_keep_time_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_keep_time_key", value)

    @property
    @pulumi.getter(name="isMergeCriFields")
    def is_merge_cri_fields(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If you don't need stream or logtag fields, set this to false.
        """
        return pulumi.get(self, "is_merge_cri_fields")

    @is_merge_cri_fields.setter
    def is_merge_cri_fields(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_merge_cri_fields", value)

    @property
    @pulumi.getter(name="isNullEmptyString")
    def is_null_empty_string(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, an empty string field is replaced with a null value.
        """
        return pulumi.get(self, "is_null_empty_string")

    @is_null_empty_string.setter
    def is_null_empty_string(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_null_empty_string", value)

    @property
    @pulumi.getter(name="isSupportColonlessIdent")
    def is_support_colonless_ident(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Specifies whether or not to support colonless ident. Corresponds to the Fluentd support_colonless_ident parameter.
        """
        return pulumi.get(self, "is_support_colonless_ident")

    @is_support_colonless_ident.setter
    def is_support_colonless_ident(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_support_colonless_ident", value)

    @property
    @pulumi.getter(name="isWithPriority")
    def is_with_priority(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Specifies with priority or not. Corresponds to the Fluentd with_priority parameter.
        """
        return pulumi.get(self, "is_with_priority")

    @is_with_priority.setter
    def is_with_priority(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_with_priority", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) CSV keys.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Syslog message format.
        """
        return pulumi.get(self, "message_format")

    @message_format.setter
    def message_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_format", value)

    @property
    @pulumi.getter(name="messageKey")
    def message_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies the field name to contain logs.
        """
        return pulumi.get(self, "message_key")

    @message_key.setter
    def message_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_key", value)

    @property
    @pulumi.getter(name="multiLineStartRegexp")
    def multi_line_start_regexp(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Multiline start regexp pattern.
        """
        return pulumi.get(self, "multi_line_start_regexp")

    @multi_line_start_regexp.setter
    def multi_line_start_regexp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_line_start_regexp", value)

    @property
    @pulumi.getter(name="nestedParser")
    def nested_parser(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParserArgs']]:
        """
        (Updatable) Optional nested JSON Parser for CRI. Supported fields are fieldTimeKey, timeFormat, and isKeepTimeKey.
        """
        return pulumi.get(self, "nested_parser")

    @nested_parser.setter
    def nested_parser(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParserArgs']]):
        pulumi.set(self, "nested_parser", value)

    @property
    @pulumi.getter(name="nullValuePattern")
    def null_value_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the null value pattern.
        """
        return pulumi.get(self, "null_value_pattern")

    @null_value_pattern.setter
    def null_value_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "null_value_pattern", value)

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @parse_nested.setter
    def parse_nested(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "parse_nested", value)

    @property
    @pulumi.getter
    def patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPatternArgs']]]]:
        """
        (Updatable) Grok pattern object.
        """
        return pulumi.get(self, "patterns")

    @patterns.setter
    def patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPatternArgs']]]]):
        pulumi.set(self, "patterns", value)

    @property
    @pulumi.getter(name="recordInput")
    def record_input(self) -> Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInputArgs']]:
        """
        (Updatable) record section of openmetrics parser.
        """
        return pulumi.get(self, "record_input")

    @record_input.setter
    def record_input(self, value: Optional[pulumi.Input['UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInputArgs']]):
        pulumi.set(self, "record_input", value)

    @property
    @pulumi.getter(name="rfc5424timeFormat")
    def rfc5424time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) RFC 5424 time format.
        """
        return pulumi.get(self, "rfc5424time_format")

    @rfc5424time_format.setter
    def rfc5424time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rfc5424time_format", value)

    @property
    @pulumi.getter
    def separator(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @separator.setter
    def separator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "separator", value)

    @property
    @pulumi.getter(name="syslogParserType")
    def syslog_parser_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Syslog parser type.
        """
        return pulumi.get(self, "syslog_parser_type")

    @syslog_parser_type.setter
    def syslog_parser_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "syslog_parser_type", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) JSON parser time type.
        """
        return pulumi.get(self, "time_type")

    @time_type.setter
    def time_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_type", value)

    @property
    @pulumi.getter(name="timeoutInMilliseconds")
    def timeout_in_milliseconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Specify the timeout for parse processing. This is mainly for detecting an incorrect regexp pattern.
        """
        return pulumi.get(self, "timeout_in_milliseconds")

    @timeout_in_milliseconds.setter
    def timeout_in_milliseconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_milliseconds", value)

    @property
    @pulumi.getter
    def types(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Specify types for converting a field into another type. For example, With this configuration: <parse> @type csv keys time,host,req_id,user time_key time </parse>

        This incoming event: "2013/02/28 12:00:00,192.168.0.1,111,-"

        is parsed as: 1362020400 (2013/02/28/ 12:00:00)

        record: { "host"   : "192.168.0.1", "req_id" : "111", "user"   : "-" }
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "types", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserNestedParserArgs:
    def __init__(__self__, *,
                 field_time_key: Optional[pulumi.Input[str]] = None,
                 is_keep_time_key: Optional[pulumi.Input[bool]] = None,
                 parse_nested: Optional[pulumi.Input[bool]] = None,
                 separator: Optional[pulumi.Input[str]] = None,
                 time_format: Optional[pulumi.Input[str]] = None,
                 time_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param pulumi.Input[bool] is_keep_time_key: (Updatable) If true, keep the time field in the record.
        :param pulumi.Input[bool] parse_nested: (Updatable) If true, a separator parameter can be further defined.
        :param pulumi.Input[str] separator: (Updatable) Keys of adjacent levels are joined by the separator.
        :param pulumi.Input[str] time_format: (Updatable) Process time value using the specified format.
        :param pulumi.Input[str] time_type: (Updatable) JSON parser time type.
        """
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if is_keep_time_key is not None:
            pulumi.set(__self__, "is_keep_time_key", is_keep_time_key)
        if parse_nested is not None:
            pulumi.set(__self__, "parse_nested", parse_nested)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_type is not None:
            pulumi.set(__self__, "time_type", time_type)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @field_time_key.setter
    def field_time_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_key", value)

    @property
    @pulumi.getter(name="isKeepTimeKey")
    def is_keep_time_key(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, keep the time field in the record.
        """
        return pulumi.get(self, "is_keep_time_key")

    @is_keep_time_key.setter
    def is_keep_time_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_keep_time_key", value)

    @property
    @pulumi.getter(name="parseNested")
    def parse_nested(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, a separator parameter can be further defined.
        """
        return pulumi.get(self, "parse_nested")

    @parse_nested.setter
    def parse_nested(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "parse_nested", value)

    @property
    @pulumi.getter
    def separator(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Keys of adjacent levels are joined by the separator.
        """
        return pulumi.get(self, "separator")

    @separator.setter
    def separator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "separator", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Process time value using the specified format.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)

    @property
    @pulumi.getter(name="timeType")
    def time_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) JSON parser time type.
        """
        return pulumi.get(self, "time_type")

    @time_type.setter
    def time_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_type", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserPatternArgs:
    def __init__(__self__, *,
                 field_time_format: Optional[pulumi.Input[str]] = None,
                 field_time_key: Optional[pulumi.Input[str]] = None,
                 field_time_zone: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pattern: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] field_time_format: (Updatable) Process value using the specified format. This is available only when time_type is a string.
        :param pulumi.Input[str] field_time_key: (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        :param pulumi.Input[str] field_time_zone: (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        :param pulumi.Input[str] name: (Updatable) The name key to tag this Grok pattern.
        :param pulumi.Input[str] pattern: (Updatable) The Grok pattern.
        """
        if field_time_format is not None:
            pulumi.set(__self__, "field_time_format", field_time_format)
        if field_time_key is not None:
            pulumi.set(__self__, "field_time_key", field_time_key)
        if field_time_zone is not None:
            pulumi.set(__self__, "field_time_zone", field_time_zone)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter(name="fieldTimeFormat")
    def field_time_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Process value using the specified format. This is available only when time_type is a string.
        """
        return pulumi.get(self, "field_time_format")

    @field_time_format.setter
    def field_time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_format", value)

    @property
    @pulumi.getter(name="fieldTimeKey")
    def field_time_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specify the time field for the event time. If the event doesn't have this field, the current time is used.
        """
        return pulumi.get(self, "field_time_key")

    @field_time_key.setter
    def field_time_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_key", value)

    @property
    @pulumi.getter(name="fieldTimeZone")
    def field_time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Use the specified time zone. The time value can be parsed or formatted in the specified time zone.
        """
        return pulumi.get(self, "field_time_zone")

    @field_time_zone.setter
    def field_time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_time_zone", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Grok pattern.
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterParserRecordInputArgs:
    def __init__(__self__, *,
                 dimensions: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Mapping[str, Any]] dimensions: (Updatable) Dimensions to be added for metrics.
        :param pulumi.Input[str] namespace: (Updatable) Namespace to emit metrics.
        :param pulumi.Input[str] resource_group: (Updatable) Resource group to emit metrics.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Dimensions to be added for metrics.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Namespace to emit metrics.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Resource group to emit metrics.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)


@pulumi.input_type
class UnifiedAgentConfigurationServiceConfigurationUnifiedAgentConfigurationFilterRecordListArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: (Updatable) A new key
        :param pulumi.Input[str] value: (Updatable) A new value
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A new key
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A new value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GetLogGroupsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetLogSavedSearchesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Resource name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetLogsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetUnifiedAgentConfigurationsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name key to tag this Grok pattern.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name key to tag this Grok pattern.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


