# coding: utf-8

"""
    Carbon

    Connect external data to LLMs, no matter the source.

    The version of the OpenAPI document: 1.0.0
    Generated by: https://konfigthis.com
"""

from datetime import datetime, date
import typing
from enum import Enum
from typing_extensions import TypedDict, Literal, TYPE_CHECKING
from pydantic import BaseModel, Field, RootModel, ConfigDict

from carbon.pydantic.embedding_generators import EmbeddingGenerators
from carbon.pydantic.file_content_types_nullable import FileContentTypesNullable

class UploadFileFromUrlInput(BaseModel):
    url: str = Field(alias='url')

    file_name: typing.Optional[typing.Optional[str]] = Field(None, alias='file_name')

    chunk_size: typing.Optional[typing.Optional[int]] = Field(None, alias='chunk_size')

    chunk_overlap: typing.Optional[typing.Optional[int]] = Field(None, alias='chunk_overlap')

    skip_embedding_generation: typing.Optional[bool] = Field(None, alias='skip_embedding_generation')

    set_page_as_boundary: typing.Optional[bool] = Field(None, alias='set_page_as_boundary')

    embedding_model: typing.Optional[EmbeddingGenerators] = Field(None, alias='embedding_model')

    generate_sparse_vectors: typing.Optional[bool] = Field(None, alias='generate_sparse_vectors')

    use_textract: typing.Optional[bool] = Field(None, alias='use_textract')

    prepend_filename_to_chunks: typing.Optional[bool] = Field(None, alias='prepend_filename_to_chunks')

    # Number of objects per chunk. For csv, tsv, xlsx, and json files only.
    max_items_per_chunk: typing.Optional[typing.Optional[int]] = Field(None, alias='max_items_per_chunk')

    parse_pdf_tables_with_ocr: typing.Optional[bool] = Field(None, alias='parse_pdf_tables_with_ocr')

    detect_audio_language: typing.Optional[bool] = Field(None, alias='detect_audio_language')

    media_type: typing.Optional[FileContentTypesNullable] = Field(None, alias='media_type')

    split_rows: typing.Optional[bool] = Field(None, alias='split_rows')

    model_config = ConfigDict(
        protected_namespaces=(),
        arbitrary_types_allowed=True
    )
