#/usr/bin/env python3
# -*- coding: utf-8 -*-

from collections import OrderedDict


d2r_dict=OrderedDict([
('क्','k'),
('ख्','kh'),
('ग्','g'),
('घ्','gh'),
('ङ्','n'),
('च्','ch'),
('छ्','chh'),
('ज्','j'),
('झ्','jh'),
('ञ्','n'),
('ट्','t'),
('ठ्','th'),
('ड्','d'),
('ढ्','dh'),
('ण्','n'),
('त्','t'),
('थ्','th'),
('द्','d'),
('ध्','dh'),
('न्','n'),
('प्','p'),
('फ्','ph'),
('ब्','b'),
('भ्','bh'),
('म्','m'),
('य्','y'),
('र्','r'),
('ल्','l'),
('व्','w'),
('श्','s'),
('ष्','s'),
('स्','s'),
('ह्','h'),
('ष','श'),
('स','श'),
('का','kaa'),
('को','ko'),
('कौ','kau'),
('कि','ki'),
('की','ki'),
('कु','ku'),
('कू','ku'),
('के','ke'),
('कै','kai'),
('कं','kum'),
('खा','khaa'),
('खो','kho'),
('खौ','khau'),
('खि','khi'),
('खी','khi'),
('खु','khu'),
('खू','khu'),
('खे','khe'),
('खै','khai'),
('खं','khum'),
('गा','gaa'),
('गो','go'),
('गौ','gau'),
('गि','gi'),
('गी','gi'),
('गु','gu'),
('गू','gu'),
('गे','ge'),
('गै','gai'),
('गं','gum'),
('घा','ghaa'),
('घो','gho'),
('घौ','ghau'),
('घि','ghi'),
('घी','ghi'),
('घु','ghu'),
('घू','ghu'),
('घे','ghe'),
('घै','ghai'),
('घं','ghum'),
('ङा','naa'),
('ङो','no'),
('ङौ','nau'),
('ङि','ni'),
('ङी','ni'),
('ङु','nu'),
('ङू','nu'),
('ङे','ne'),
('ङै','nai'),
('ङं','num'),
('चा','chaa'),
('चो','cho'),
('चौ','chau'),
('चि','chi'),
('ची','chi'),
('चु','chu'),
('चू','chu'),
('चे','che'),
('चै','chai'),
('चं','chum'),
('छा','chhaa'),
('छो','chho'),
('छौ','chhau'),
('छि','chhi'),
('छी','chhi'),
('छु','chhu'),
('छू','chhu'),
('छे','chhe'),
('छै','chhai'),
('छं','chhum'),
('जा','jaa'),
('जो','jo'),
('जौ','jau'),
('जि','ji'),
('जी','ji'),
('जु','ju'),
('जू','ju'),
('जे','je'),
('जै','jai'),
('जं','jum'),
('झा','jhaa'),
('झो','jho'),
('झौ','jhau'),
('झि','jhi'),
('झी','jhi'),
('झु','jhu'),
('झू','jhu'),
('झे','jhe'),
('झै','jhai'),
('झं','jhum'),
('ञा','naa'),
('ञो','no'),
('ञौ','nau'),
('ञि','ni'),
('ञी','ni'),
('ञु','nu'),
('ञू','nu'),
('ञे','ne'),
('ञै','nai'),
('ञं','num'),
('टा','taa'),
('टो','to'),
('टौ','tau'),
('टि','ti'),
('टी','ti'),
('टु','tu'),
('टू','tu'),
('टे','te'),
('टै','tai'),
('टं','tum'),
('ठा','thaa'),
('ठो','tho'),
('ठौ','thau'),
('ठि','thi'),
('ठी','thi'),
('ठु','thu'),
('ठू','thu'),
('ठे','the'),
('ठै','thai'),
('ठं','thum'),
('डा','daa'),
('डो','do'),
('डौ','dau'),
('डि','di'),
('डी','di'),
('डु','du'),
('डू','du'),
('डे','de'),
('डै','dai'),
('डं','dum'),
('ढा','dhaa'),
('ढो','dho'),
('ढौ','dha'),
('ढि','dhi'),
('ढी','dhi'),
('ढु','dhu'),
('ढू','dhu'),
('ढे','dhe'),
('ढै','dhai'),
('ढं','dhum'),
('ता','taa'),
('तो','to'),
('तौ','tau'),
('ति','ti'),
('ती','ti'),
('तु','tu'),
('तू','tu'),
('ते','te'),
('तै','tai'),
('तं','tum'),
('था','thaa'),
('थो','tho'),
('थौ','thau'),
('थि','thi'),
('थी','thi'),
('थु','thu'),
('थू','thu'),
('थे','the'),
('थै','thai'),
('थं','thum'),
('दा','daa'),
('दो','do'),
('दौ','dau'),
('दि','di'),
('दी','di'),
('दु','du'),
('दू','du'),
('दे','de'),
('दै','dai'),
('दं','dum'),
('धा','dhaa'),
('धो','dho'),
('धौ','dhau'),
('धि','dhi'),
('धी','dhi'),
('धु','dhu'),
('धू','dhu'),
('धे','dhe'),
('धै','dhai'),
('धं','dhum'),
('ना','naa'),
('नो','no'),
('नौ','nau'),
('नि','ni'),
('नी','ni'),
('नु','nu'),
('नू','nu'),
('ने','ne'),
('नै','nai'),
('नं','num'),
('पा','paa'),
('पो','po'),
('पौ','pau'),
('पि','pi'),
('पी','pi'),
('पु','pu'),
('पू','pu'),
('पे','pe'),
('पै','pai'),
('पं','pum'),
('फा','phaa'),
('फो','pho'),
('फौ','phau'),
('फि','phi'),
('फी','phi'),
('फु','phu'),
('फू','phu'),
('फे','phe'),
('फै','phai'),
('फं','phum'),
('बा','baa'),
('बो','bo'),
('बौ','bau'),
('बि','bi'),
('बी','bi'),
('बु','bu'),
('बू','bu'),
('बे','be'),
('बै','bai'),
('बं','bum'),
('भा','bhaa'),
('भो','bho'),
('भौ','bhau'),
('भि','bhi'),
('भी','bhi'),
('भु','bhu'),
('भू','bhu'),
('भे','bhe'),
('भै','bhai'),
('भं','bhum'),
('मा','maa'),
('मो','mo'),
('मौ','mau'),
('मि','mi'),
('मी','mi'),
('मु','mu'),
('मू','mu'),
('मे','me'),
('मै','mai'),
('मं','mum'),
('या','yaa'),
('यो','yo'),
('यौ','yau'),
('यि','yi'),
('यी','yi'),
('यु','yu'),
('यू','yu'),
('ये','ye'),
('यै','yai'),
('यं','yum'),
('रा','raa'),
('रो','ro'),
('रौ','rau'),
('रि','ri'),
('री','ri'),
('रु','ru'),
('रू','ru'),
('रे','re'),
('रै','rai'),
('रं','rum'),
('ला','laa'),
('लो','lo'),
('लौ','lau'),
('लि','li'),
('ली','li'),
('लु','lu'),
('लू','lu'),
('ले','le'),
('लै','lai'),
('लं','lum'),
('वा','waa'),
('वो','wo'),
('वौ','wau'),
('वि','wi'),
('वी','wi'),
('वु','wu'),
('वू','wu'),
('वे','we'),
('वै','wai'),
('वं','wum'),
('शा','saa'),
('शो','so'),
('शौ','sau'),
('शि','si'),
('शी','si'),
('शु','su'),
('शू','su'),
('शे','se'),
('शै','sai'),
('शं','sum'),
('हा','haa'),
('हो','ho'),
('हौ','hau'),
('हि','hi'),
('ही','hi'),
('हु','hu'),
('हू','hu'),
('हे','he'),
('है','hai'),
('हं','hum'),
('क','ka'),
('ख','kha'),
('ग','ga'),
('घ','gha'),
('ङ','na'),
('च','cha'),
('छ','chha'),
('ज','ja'),
('झ','jha'),
('ञ','na'),
('ट','ta'),
('ठ','tha'),
('ड','da'),
('ढ','dha'),
('ण','na'),
('त','ta'),
('थ','tha'),
('द','da'),
('ध','dha'),
('न','na'),
('प','pa'),
('फ','pha'),
('ब','ba'),
('भ','bha'),
('म','ma'),
('य','ya'),
('र','ra'),
('ल','la'),
('व','wa'),
('श','sa'),
('ष','श'),
('स','श'),
('ह','ha'),
('ँ','n'),
('ं','m'),
('ः','h'),
('अ','a'),
('आ','a'),
('इ','i'),
('ई','i'),
('उ','u'),
('ऊ','u'),
('ऋ','ri'),
('ए','e'),
('ऐ','ai'),
('ओ','o'),
('औ','au'),
('ा','a'),
('ि','i'),
('ी','i'),
('ु','u'),
('ू','u'),
('ृ','ri'),
('े','e'),
('ै','ai'),
('ो','o'),
('ौ','au'),
    ])


def is_devanagari(text):
    """
    This function checks if the text is in Devanagari format.

    Detail description:
    In the text, it ignores all the punctuations, white spaces and other non-alphanumeric characters and then counts the
    number of devanagari characters. If the number of devanagari characters is more than or equal to 50% of the stripped
    text, the function deems the text devanagari, otherwise not.

    Syntax:
    >>> nr.is_devanagari(text)

    Example:
        >>> import nepali_roman as nr
        >>> nr.is_devanagari("नगरपालिका")
            True

        >>> nr.is_devanagari("surajपालिक")
            False

        >>> nr.is_devanagari("suraj")
            False
    """
    text = "".join(i for i in text if i.isalnum())
    return (sum(True for i in text if ord(i) in range(2304, 2432)) / len(text)) >= 0.5
    
    
def romanize_text(text):
    """
    This function can be used to romanize the Nepali text to English.

    Syntax:
    >>> nr.romanize_text(nepali_text)

    Example:
        >>> import nepali_roman as nr
        >>> nr.romanize_text("नगरपालिका")
            nagarapaalikaa
    """
    if type(text) == float:
        return
    for key,value in d2r_dict.items():
        text=text.replace(key,value)  
    return text


def romanize(in_file, out_file):
    """
    This function takes Nepali text file as an input and saves the romanized text in specified output file.

    Syntax:
    >>> nr.romanize(input_file_path, output_file_path)

    Example:
        >>> import nepali_roman as nr
        >>> nr.romanize('nepali.txt', 'romanized_english.txt')
        # this takes Nepali text file nepali.txt and stores romanized English in the file romanized_english.txt
    """
    with open(in_file) as f:
        text = f.read()
    
    with open(out_file, 'w+') as f:
        romanized_text = romanize_text(text)
        f.write(romanized_text)