class e{constructor(){this.container=null,this.events=[],this.sessions=new Map,this.currentSession=null,this.selectedSessionFilter="all",this.timeRange="30min",this.searchTerm="",this.initialized=!1,this.expandedSessions=new Set,this.expandedAgents=new Set,this.expandedTools=new Set,this.selectedItem=null}initialize(){if(console.log("ActivityTree.initialize() called, initialized:",this.initialized),this.initialized)return void console.log("Activity tree already initialized, skipping");if(this.container=document.getElementById("activity-tree-container"),!this.container&&(this.container=document.getElementById("activity-tree"),!this.container))return void console.error("Activity tree container not found in DOM");const e=document.getElementById("activity-tab");if(e){if(!e.classList.contains("active"))return console.log("Activity tab not active, initializing but deferring render"),this.setupControls(),this.subscribeToEvents(),void(this.initialized=!0);this.setupControls(),this.createLinearTreeView(),this.subscribeToEvents(),this.initialized=!0,console.log("Activity tree initialization complete")}else console.error("Activity tab panel (#activity-tab) not found in DOM")}forceShow(){console.log("ActivityTree.forceShow() called"),this.container||(this.container=document.getElementById("activity-tree-container")||document.getElementById("activity-tree"),this.container)?(this.createLinearTreeView(),this.renderTree()):console.error("Cannot find activity tree container")}renderWhenVisible(){if(console.log("ActivityTree.renderWhenVisible() called"),!this.initialized)return console.log("Not initialized yet, calling initialize..."),void this.initialize();this.createLinearTreeView(),this.renderTree()}setupControls(){const e=document.getElementById("time-range");e&&e.addEventListener("change",e=>{this.timeRange=e.target.value,console.log(`ActivityTree: Time range changed to: ${this.timeRange}`),this.renderTree()}),document.addEventListener("sessionFilterChanged",e=>{this.selectedSessionFilter=e.detail.sessionId||"all",console.log(`ActivityTree: Session filter changed to: ${this.selectedSessionFilter} (from SessionManager)`),this.renderTree()}),document.addEventListener("sessionChanged",e=>{this.selectedSessionFilter=e.detail.sessionId||"all",console.log(`ActivityTree: Session changed to: ${this.selectedSessionFilter} (from SessionManager - backward compat)`),this.renderTree()}),setTimeout(()=>{if(window.sessionManager){const e=window.sessionManager.getCurrentFilter();e!==this.selectedSessionFilter&&(this.selectedSessionFilter=e||"all",console.log(`ActivityTree: Initialized with current session filter: ${this.selectedSessionFilter}`),this.renderTree())}},100);const t=document.getElementById("expand-all");t&&t.addEventListener("click",()=>this.expandAllSessions());const s=document.getElementById("collapse-all");s&&s.addEventListener("click",()=>this.collapseAllSessions());const n=document.getElementById("reset-zoom");n&&(n.style.display="inline-block",n.addEventListener("click",()=>this.resetZoom()));const i=document.getElementById("activity-search");i&&i.addEventListener("input",e=>{this.searchTerm=e.target.value.toLowerCase(),this.renderTree()})}createLinearTreeView(){console.log("Creating linear tree view"),this.container.innerHTML="";const e=document.createElement("div");e.id="linear-tree",e.className="linear-tree",this.container.appendChild(e),console.log("Linear tree view created")}subscribeToEvents(){if(!window.socketClient)return console.warn("Socket client not available for activity tree"),void setTimeout(()=>this.subscribeToEvents(),1e3);console.log("ActivityTree: Setting up event subscription"),window.socketClient.onEventUpdate((e,t)=>{console.log(`ActivityTree: onEventUpdate called with ${e.length} total events and ${t.size} sessions`),this.sessions.clear();for(const[n,i]of t.entries()){const e={id:n,timestamp:new Date(i.lastActivity||i.startTime||new Date),expanded:this.expandedSessions.has(n)||!0,agents:new Map,todos:[],userInstructions:[],tools:[],status:"active",currentTodoTool:null,working_directory:i.working_directory,git_branch:i.git_branch,eventCount:i.eventCount};this.sessions.set(n,e)}const s=e.length-this.events.length;if(s>0){const t=e.slice(this.events.length);console.log(`ActivityTree: Processing ${s} new events`,t),t.forEach(e=>{this.processEvent(e)})}this.events=[...e],this.renderTree(),console.log("ActivityTree: Sessions after sync with socket client:",Array.from(this.sessions.entries()))});const e=window.socketClient?.getState();if(e&&e.events.length>0){console.log(`ActivityTree: Loading existing data - ${e.events.length} events, ${e.sessions.size} sessions`),this.sessions.clear();for(const[t,s]of e.sessions.entries()){const e={id:t,timestamp:new Date(s.lastActivity||s.startTime||new Date),expanded:this.expandedSessions.has(t)||!0,agents:new Map,todos:[],userInstructions:[],tools:[],status:"active",currentTodoTool:null,working_directory:s.working_directory,git_branch:s.git_branch,eventCount:s.eventCount};this.sessions.set(t,e)}e.events.forEach(e=>{this.processEvent(e)}),this.events=[...e.events],this.renderTree(),console.log("ActivityTree: Initial sessions state:",Array.from(this.sessions.entries()))}else console.log("ActivityTree: No existing events found"),this.events=[],this.sessions.clear(),this.renderTree()}processEvent(e){if(!e)return void console.log("ActivityTree: Ignoring null event");let t,s=this.getEventType(e);if(!s)return;console.log(`ActivityTree: Processing event: ${s}`,e),e.timestamp?(t=new Date(e.timestamp),isNaN(t.getTime())&&(console.warn("ActivityTree: Invalid timestamp, using current time:",e.timestamp),t=new Date)):(console.warn("ActivityTree: No timestamp found, using current time"),t=new Date);const n=e.session_id||e.data?.session_id;if(!n)return void console.log(`ActivityTree: Skipping event without session_id: ${s}`);if(!this.sessions.has(n))return void console.warn(`ActivityTree: Session ${n} not found in authoritative sessions - skipping event`);const i=this.sessions.get(n);switch(s){case"Start":this.currentSession=i;break;case"user_prompt":this.processUserInstruction(e,i);break;case"TodoWrite":this.processTodoWrite(e,i);break;case"SubagentStart":this.processSubagentStart(e,i);break;case"SubagentStop":this.processSubagentStop(e,i);break;case"PreToolUse":this.processToolUse(e,i);break;case"PostToolUse":this.updateToolStatus(e,i,"completed")}this.updateStats()}getEventType(e){if(e.hook_event_name)return e.hook_event_name;if("hook"===e.type&&e.subtype){return{pre_tool:"PreToolUse",post_tool:"PostToolUse",subagent_start:"SubagentStart",subagent_stop:"SubagentStop",todo_write:"TodoWrite"}[e.subtype]}if("todo"===e.type&&"updated"===e.subtype)return"TodoWrite";if("subagent"===e.type){if("started"===e.subtype)return"SubagentStart";if("stopped"===e.subtype)return"SubagentStop"}return"start"===e.type?"Start":"user_prompt"===e.type||"user_prompt"===e.subtype?"user_prompt":null}processUserInstruction(e,t){const s=e.prompt_text||e.data?.prompt_text||e.prompt||"";if(!s)return;const n={id:`instruction-${t.id}-${Date.now()}`,text:s,preview:s.length>100?s.substring(0,100)+"...":s,timestamp:e.timestamp||(new Date).toISOString(),type:"user_instruction"};t.userInstructions.push(n),t.userInstructions.length>5&&(t.userInstructions=t.userInstructions.slice(-5))}processTodoWrite(e,t){let s=e.todos||e.data?.todos||e.data||[];if(s&&"object"==typeof s&&s.todos&&(s=s.todos),!Array.isArray(s)||0===s.length)return;t.todos=s.map(t=>({content:t.content,activeForm:t.activeForm,status:t.status,timestamp:e.timestamp}));const n={id:`todo-session-${t.id}-${Date.now()}`,name:"TodoWrite",type:"tool",icon:"📝",timestamp:e.timestamp,status:"active",params:{todos:s},isPrioritizedTool:!0};t.tools=t.tools.filter(e=>"TodoWrite"!==e.name),t.tools.unshift(n),t.currentTodoTool=n;const i=e.session_id||e.data?.session_id;let a=null;if(i&&t.agents.has(i))a=t.agents.get(i);else{const e=Array.from(t.agents.values()).filter(e=>"active"===e.status||"in_progress"===e.status).sort((e,t)=>new Date(t.timestamp)-new Date(e.timestamp));if(e.length>0)a=e[0];else{const e=Array.from(t.agents.values()).sort((e,t)=>new Date(t.timestamp)-new Date(e.timestamp));e.length>0&&(a=e[0])}}if(a){const t={id:`todo-agent-${a.id}-${Date.now()}`,name:"TodoWrite",type:"tool",icon:"📝",timestamp:e.timestamp,status:"active",params:{todos:s},isPrioritizedTool:!0};a.tools=a.tools.filter(e=>"TodoWrite"!==e.name),a.tools.unshift(t)}}processSubagentStart(e,t){const s=e.agent_name||e.data?.agent_name||e.data?.agent_type||e.agent_type||e.agent||"unknown",n=e.session_id||e.data?.session_id,i=n||`agent-${Date.now()}-${Math.random()}`;if(t.agents.has(i)){const s=t.agents.get(i);s.status="active",s.timestamp=e.timestamp}else{const a={id:i,name:s,type:"agent",icon:this.getAgentIcon(s),timestamp:e.timestamp,status:"active",tools:[],sessionId:n,isPM:!1};t.agents.set(i,a)}}processSubagentStop(e,t){const s=e.session_id||e.data?.session_id;if(s&&t.agents.has(s)){t.agents.get(s).status="completed"}}processToolUse(e,t){const s=e.tool_name||e.data?.tool_name||e.tool||e.data?.tool||"unknown",n=e.tool_parameters||e.data?.tool_parameters||e.parameters||e.data?.parameters||{},i=e.session_id||e.data?.session_id,a={id:`tool-${Date.now()}-${Math.random()}`,name:s,type:"tool",icon:this.getToolIcon(s),timestamp:e.timestamp,status:"in_progress",params:n,eventId:e.id};let o=null;if(i&&t.agents.has(i))o=t.agents.get(i);else{const e=Array.from(t.agents.values()).filter(e=>"active"===e.status).sort((e,t)=>new Date(t.timestamp)-new Date(e.timestamp));if(!(e.length>0))return void t.tools.push(a);o=e[0]}o&&o.tools.push(a)}updateToolStatus(e,t,s){const n=t=>{if(t.tools){const n=t.tools.find(t=>t.eventId===e.id);if(n)return n.status=s,!0}return!1};for(let i of t.agents.values())if(n(i))return;!t.tools||n(t)}renderTree(){const e=document.getElementById("linear-tree");if(!e)return;e.innerHTML="";const t=Array.from(this.sessions.values()).sort((e,t)=>new Date(t.timestamp)-new Date(e.timestamp));for(let s of t){if("all"!==this.selectedSessionFilter&&this.selectedSessionFilter!==s.id)continue;const t=this.createSessionElement(s);e.appendChild(t)}}createSessionElement(e){const t=this.expandedSessions.has(e.id)||e.expanded;let s;try{const t=e.timestamp instanceof Date?e.timestamp:new Date(e.timestamp);isNaN(t.getTime())?(s="Invalid Date",console.warn("ActivityTree: Invalid session timestamp:",e.timestamp)):s=t.toLocaleString()}catch(l){s="Invalid Date",console.error("ActivityTree: Error formatting session timestamp:",l,e.timestamp)}const n=document.createElement("div");n.className="tree-node session",n.dataset.sessionId=e.id;const i=t?"▼":"▶",a=e.agents?e.agents.size:0,o=e.todos?e.todos.length:0,r=e.userInstructions?e.userInstructions.length:0;return console.log(`ActivityTree: Rendering session ${e.id}: ${a} agents, ${r} instructions, ${o} todos at ${s}`),n.innerHTML=`\n            <div class="tree-node-content" onclick="window.activityTreeInstance.toggleSession('${e.id}')">\n                <span class="tree-expand-icon">${i}</span>\n                <span class="tree-icon">🎯</span>\n                <span class="tree-label">PM Session</span>\n                <span class="tree-meta">${s} • ${a} agent(s) • ${r} instruction(s) • ${o} todo(s)</span>\n            </div>\n            <div class="tree-children" style="display: ${t?"block":"none"}">\n                ${this.renderSessionContent(e)}\n            </div>\n        `,n}renderSessionContent(e){let t="";if(e.userInstructions&&e.userInstructions.length>0)for(let n of e.userInstructions.slice(-3))t+=this.renderUserInstructionElement(n,1);if(e.todos&&e.todos.length>0&&(t+=this.renderTodoChecklistElement(e.todos,1)),e.tools&&e.tools.length>0)for(let n of e.tools)t+=this.renderToolElement(n,1);const s=Array.from(e.agents.values()).sort((e,t)=>new Date(t.timestamp)-new Date(e.timestamp));for(let n of s)t+=this.renderAgentElement(n,1);return t}renderUserInstructionElement(e,t){return`\n            <div class="tree-node user-instruction ${this.selectedItem&&"instruction"===this.selectedItem.type&&this.selectedItem.data.id===e.id?"selected":""}" data-level="${t}">\n                <div class="tree-node-content">\n                    <span class="tree-expand-icon"></span>\n                    <span class="tree-icon">💬</span>\n                    <span class="tree-label clickable" onclick="window.activityTreeInstance.selectItem(${this.escapeJson(e)}, 'instruction', event)">User: "${this.escapeHtml(e.preview)}"</span>\n                    <span class="tree-status status-active">instruction</span>\n                </div>\n            </div>\n        `}renderTodoChecklistElement(e,t){const s=`checklist-${Date.now()}`,n=!1!==this.expandedTools.has(s),i=n?"▼":"▶";let a=0,o=0;e.forEach(e=>{"completed"===e.status?a++:"in_progress"===e.status&&o++});let r="";r=o>0?`${o} in progress, ${a} completed`:a===e.length&&e.length>0?`All ${e.length} completed`:`${e.length} todo(s)`;let l=`\n            <div class="tree-node todo-checklist" data-level="${t}">\n                <div class="tree-node-content">\n                    <span class="tree-expand-icon" onclick="window.activityTreeInstance.toggleTodoChecklist('${s}'); event.stopPropagation();">${i}</span>\n                    <span class="tree-icon">☑️</span>\n                    <span class="tree-label">TODOs</span>\n                    <span class="tree-params">${r}</span>\n                    <span class="tree-status status-active">checklist</span>\n                </div>\n        `;if(n){l+='<div class="tree-children">';for(let s of e){const e=this.getCheckboxIcon(s.status),n=`status-${s.status}`,i="in_progress"===s.status?s.activeForm:s.content;l+=`\n                    <div class="tree-node todo-item ${n}" data-level="${t+1}">\n                        <div class="tree-node-content">\n                            <span class="tree-expand-icon"></span>\n                            <span class="tree-icon">${e}</span>\n                            <span class="tree-label">${this.escapeHtml(i)}</span>\n                            <span class="tree-status ${n}">${s.status.replace("_"," ")}</span>\n                        </div>\n                    </div>\n                `}l+="</div>"}return l+="</div>",l}renderAgentElement(e,t){const s="active"===e.status?"status-active":"status-completed",n=this.expandedAgents.has(e.id),i=e.tools&&e.tools.length>0,a=i?n?"▼":"▶":"";let o=`\n            <div class="tree-node agent ${s} ${this.selectedItem&&"agent"===this.selectedItem.type&&this.selectedItem.data.id===e.id?"selected":""}" data-level="${t}">\n                <div class="tree-node-content">\n                    ${a?`<span class="tree-expand-icon" onclick="window.activityTreeInstance.toggleAgent('${e.id}'); event.stopPropagation();">${a}</span>`:'<span class="tree-expand-icon"></span>'}\n                    <span class="tree-icon">${e.icon}</span>\n                    <span class="tree-label clickable" onclick="window.activityTreeInstance.selectItem(${this.escapeJson(e)}, 'agent', event)">${e.name}</span>\n                    <span class="tree-status ${s}">${e.status}</span>\n                </div>\n        `;if(i&&n){o+='<div class="tree-children">';for(let s of e.tools)o+=this.renderToolElement(s,t+1);o+="</div>"}return o+="</div>",o}renderToolElement(e,t){const s=`status-${e.status}`,n=this.getToolParams(e);return`\n            <div class="tree-node tool ${s} ${this.selectedItem&&"tool"===this.selectedItem.type&&this.selectedItem.data.id===e.id?"selected":""}" data-level="${t}">\n                <div class="tree-node-content">\n                    <span class="tree-expand-icon"></span>\n                    <span class="tree-icon">${e.icon}</span>\n                    <span class="tree-label clickable" onclick="window.activityTreeInstance.selectItem(${this.escapeJson(e)}, 'tool', event)">${e.name} (click to view details)</span>\n                    <span class="tree-params">${n}</span>\n                    <span class="tree-status ${s}">${e.status}</span>\n                </div>\n            </div>\n        `}getToolParams(e){if(!e.params)return"";if("Read"===e.name&&e.params.file_path)return e.params.file_path;if("Edit"===e.name&&e.params.file_path)return e.params.file_path;if("Write"===e.name&&e.params.file_path)return e.params.file_path;if("Bash"===e.name&&e.params.command){const t=e.params.command;return t.length>50?t.substring(0,50)+"...":t}return"WebFetch"===e.name&&e.params.url?e.params.url:""}getStatusIcon(e){return{pending:"⏸️",in_progress:"🔄",completed:"✅"}[e]||"❓"}getCheckboxIcon(e){return{pending:"⏳",in_progress:"🔄",completed:"✅"}[e]||"❓"}getAgentIcon(e){return{engineer:"👷",research:"🔬",qa:"🧪",ops:"⚙️",pm:"📊",architect:"🏗️"}[e.toLowerCase()]||"🤖"}getToolIcon(e){return{read:"👁️",write:"✍️",edit:"✏️",bash:"💻",webfetch:"🌐",grep:"🔍",glob:"📂",todowrite:"📝"}[e.toLowerCase()]||"🔧"}toggleSession(e){this.expandedSessions.has(e)?this.expandedSessions.delete(e):this.expandedSessions.add(e);const t=this.sessions.get(e);t&&(t.expanded=this.expandedSessions.has(e)),this.renderTree()}expandAllSessions(){for(let e of this.sessions.keys()){this.expandedSessions.add(e);const t=this.sessions.get(e);t&&(t.expanded=!0)}this.renderTree()}collapseAllSessions(){this.expandedSessions.clear();for(let e of this.sessions.values())e.expanded=!1;this.renderTree()}updateStats(){const e=this.countTotalNodes(),t=this.countActiveNodes(),s=this.calculateMaxDepth(),n=document.getElementById("node-count"),i=document.getElementById("active-count"),a=document.getElementById("tree-depth");n&&(n.textContent=e),i&&(i.textContent=t),a&&(a.textContent=s),console.log(`ActivityTree: Stats updated - Nodes: ${e}, Active: ${t}, Depth: ${s}`)}countTotalNodes(){let e=0;for(let t of this.sessions.values()){e+=1,e+=t.agents.size,t.userInstructions&&(e+=t.userInstructions.length),t.todos&&(e+=t.todos.length),t.tools&&(e+=t.tools.length);for(let s of t.agents.values())s.tools&&(e+=s.tools.length)}return e}countActiveNodes(){let e=0;for(let t of this.sessions.values()){if("active"===t.status&&e++,t.todos)for(let s of t.todos)"in_progress"===s.status&&e++;if(t.tools)for(let s of t.tools)"in_progress"===s.status&&e++;for(let s of t.agents.values())if("active"===s.status&&e++,s.tools)for(let t of s.tools)"in_progress"===t.status&&e++}return e}calculateMaxDepth(){let e=0;for(let t of this.sessions.values()){let s=1;t.userInstructions&&t.userInstructions.length>0&&(s=Math.max(s,2)),t.todos&&t.todos.length>0&&(s=Math.max(s,3)),t.tools&&t.tools.length>0&&(s=Math.max(s,2));for(let e of t.agents.values())e.tools&&e.tools.length>0&&(s=Math.max(s,3));e=Math.max(e,s)}return e}toggleAgent(e){this.expandedAgents.has(e)?this.expandedAgents.delete(e):this.expandedAgents.add(e),this.renderTree()}toggleTool(e){console.log("Tool expansion is disabled. Tools now show data in the left pane when clicked.")}toggleTodoChecklist(e){this.expandedTools.has(e)?this.expandedTools.delete(e):this.expandedTools.add(e),this.renderTree()}selectItem(e,t,s){s&&s.stopPropagation(),this.selectedItem={data:e,type:t},this.displayItemData(e,t),this.renderTree()}displayItemData(e,t){if("tool"===t&&"TodoWrite"===e.name&&e.params&&e.params.todos)return void this.displayTodoWriteData(e);switch(t){case"agent":this.displayAgentData(e);break;case"tool":this.displayToolData(e);break;case"instruction":this.displayInstructionData(e);break;default:this.displayGenericData(e,t)}const s=document.querySelector(".module-data-header h5");if(s){const n={agent:"🤖",tool:"🔧",instruction:"💬",session:"🎯"}[t]||"📊",i=e.name||e.agentName||e.tool_name||"Item";s.textContent=`${n} ${t}: ${i}`}}displayTodoWriteData(e){const t=e.params.todos||[],s=this.formatTimestamp(e.timestamp);let n=0,i=0,a=0;t.forEach(e=>{"completed"===e.status?n++:"in_progress"===e.status?i++:a++});let o=`\n            <div class="unified-viewer-header">\n                <h6>📝 TodoWrite: PM ${s}</h6>\n                <span class="unified-viewer-status">${this.formatStatus(e.status)}</span>\n            </div>\n            <div class="unified-viewer-content">\n        `;t.length>0?(o+=`\n                <div class="detail-section">\n                    <span class="detail-section-title">Todo Summary</span>\n                    <div class="todo-summary">\n                        <div class="summary-item completed">\n                            <span class="summary-icon">✅</span>\n                            <span class="summary-count">${n}</span>\n                            <span class="summary-label">Completed</span>\n                        </div>\n                        <div class="summary-item in_progress">\n                            <span class="summary-icon">🔄</span>\n                            <span class="summary-count">${i}</span>\n                            <span class="summary-label">In Progress</span>\n                        </div>\n                        <div class="summary-item pending">\n                            <span class="summary-icon">⏳</span>\n                            <span class="summary-count">${a}</span>\n                            <span class="summary-label">Pending</span>\n                        </div>\n                    </div>\n                </div>\n            `,o+=`\n                <div class="detail-section">\n                    <span class="detail-section-title">Todo List (${t.length} items)</span>\n                    <div class="todo-checklist">\n            `,t.forEach((e,t)=>{const s=this.getCheckboxIcon(e.status),n="in_progress"===e.status&&e.activeForm||e.content,i=this.formatStatusClass(e.status);o+=`\n                    <div class="todo-checklist-item ${e.status}">\n                        <div class="todo-checkbox">\n                            <span class="checkbox-icon ${i}">${s}</span>\n                        </div>\n                        <div class="todo-text">\n                            <span class="todo-content">${this.escapeHtml(n)}</span>\n                            <span class="todo-status-badge ${i}">${e.status.replace("_"," ")}</span>\n                        </div>\n                    </div>\n                `}),o+="\n                    </div>\n                </div>\n            "):o+='\n                <div class="detail-section">\n                    <div class="no-todos">No todo items found</div>\n                </div>\n            ',o+=`\n            <div class="detail-section">\n                <span class="detail-section-title">Parameters (${Object.keys(e.params).length})</span>\n                <div class="params-list">\n                    <div class="param-item">\n                        <div class="param-key">todos:</div>\n                        <div class="param-value">\n                            <pre class="param-json">${this.escapeHtml(JSON.stringify(t,null,2))}</pre>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        `,o+="</div>";const r=document.getElementById("module-data-content");r&&(r.innerHTML=o);const l=document.querySelector(".module-data-header h5");l&&(l.textContent="📝 tool: TodoWrite")}formatStatus(e){if(!e)return"unknown";return{active:"🟢 Active",completed:"✅ Completed",in_progress:"🔄 In Progress",pending:"⏳ Pending",error:"❌ Error",failed:"❌ Failed"}[e]||e}formatStatusClass(e){return`status-${e}`}formatTimestamp(e){if(!e)return"";try{const t=new Date(e);return isNaN(t.getTime())?"":t.toLocaleTimeString()}catch(t){return""}}displayAgentData(e){const t=this.formatTimestamp(e.timestamp),s=document.getElementById("module-data-content");if(!s)return;let n=`\n            <div class="detail-section">\n                <span class="detail-section-title">Agent Information</span>\n                <div class="agent-info">\n                    <div class="info-item">\n                        <span class="info-label">Name:</span>\n                        <span class="info-value">${this.escapeHtml(e.name)}</span>\n                    </div>\n                    <div class="info-item">\n                        <span class="info-label">Status:</span>\n                        <span class="info-value status-${e.status}">${e.status}</span>\n                    </div>\n                    <div class="info-item">\n                        <span class="info-label">Timestamp:</span>\n                        <span class="info-value">${t}</span>\n                    </div>\n                    <div class="info-item">\n                        <span class="info-label">Session ID:</span>\n                        <span class="info-value">${e.sessionId||"N/A"}</span>\n                    </div>\n                </div>\n            </div>\n        `;e.tools&&e.tools.length>0&&(n+=`\n                <div class="detail-section">\n                    <span class="detail-section-title">Tools (${e.tools.length})</span>\n                    <div class="tool-list">\n            `,e.tools.forEach(e=>{n+=`\n                    <div class="tool-item">\n                        <span class="tool-name">${this.escapeHtml(e.name)}</span>\n                        <span class="tool-status status-${e.status}">${e.status}</span>\n                    </div>\n                `}),n+="\n                    </div>\n                </div>\n            "),s.innerHTML=n}displayToolData(e){const t=this.formatTimestamp(e.timestamp),s=document.getElementById("module-data-content");if(!s)return;let n=`\n            <div class="detail-section">\n                <span class="detail-section-title">Tool Information</span>\n                <div class="tool-info">\n                    <div class="info-item">\n                        <span class="info-label">Name:</span>\n                        <span class="info-value">${this.escapeHtml(e.name)}</span>\n                    </div>\n                    <div class="info-item">\n                        <span class="info-label">Status:</span>\n                        <span class="info-value status-${e.status}">${e.status}</span>\n                    </div>\n                    <div class="info-item">\n                        <span class="info-label">Timestamp:</span>\n                        <span class="info-value">${t}</span>\n                    </div>\n                </div>\n            </div>\n        `;e.params&&Object.keys(e.params).length>0&&(n+='\n                <div class="detail-section">\n                    <span class="detail-section-title">Parameters</span>\n                    <div class="params-list">\n            ',Object.entries(e.params).forEach(([e,t])=>{n+=`\n                    <div class="param-item">\n                        <div class="param-key">${this.escapeHtml(e)}:</div>\n                        <div class="param-value">${this.escapeHtml(String(t))}</div>\n                    </div>\n                `}),n+="\n                    </div>\n                </div>\n            "),s.innerHTML=n}displayInstructionData(e){const t=this.formatTimestamp(e.timestamp),s=document.getElementById("module-data-content");if(!s)return;const n=`\n            <div class="detail-section">\n                <span class="detail-section-title">User Instruction</span>\n                <div class="instruction-info">\n                    <div class="info-item">\n                        <span class="info-label">Timestamp:</span>\n                        <span class="info-value">${t}</span>\n                    </div>\n                    <div class="instruction-content">\n                        <div class="instruction-text">${this.escapeHtml(e.text)}</div>\n                    </div>\n                </div>\n            </div>\n        `;s.innerHTML=n}displayGenericData(e,t){const s=document.getElementById("module-data-content");if(!s)return;let n=`\n            <div class="detail-section">\n                <span class="detail-section-title">${t||"Item"} Data</span>\n                <div class="generic-data">\n                    <pre>${this.escapeHtml(JSON.stringify(e,null,2))}</pre>\n                </div>\n            </div>\n        `;s.innerHTML=n}escapeHtml(e){const t=document.createElement("div");return t.textContent=e,t.innerHTML}resetZoom(){this.svg&&this.zoom&&this.svg.transition().duration(this.duration).call(this.zoom.transform,d3.zoomIdentity)}escapeJson(e){return JSON.stringify(e).replace(/'/g,"&apos;").replace(/"/g,"&quot;")}}window.ActivityTree=e;const t=()=>{let t=null;const s=()=>{t||(console.log("Creating new Activity Tree instance..."),t=new e,window.activityTreeInstance=t,window.activityTree=()=>t),setTimeout(()=>{console.log("Attempting to initialize Activity Tree visualization..."),t.initialize()},100)};document.querySelectorAll(".tab-button").forEach(e=>{e.addEventListener("click",e=>{"activity"===e.target.getAttribute("data-tab")&&(console.log("Activity tab button clicked, initializing tree..."),s(),t&&setTimeout(()=>{t.renderWhenVisible(),t.forceShow()},150))})}),document.addEventListener("tabChanged",e=>{e.detail&&"activity"===e.detail.newTab&&(console.log("Tab changed to activity, initializing tree..."),s(),t&&setTimeout(()=>{t.renderWhenVisible(),t.forceShow()},150))});const n=document.querySelector(".tab-button.active");n&&"activity"===n.getAttribute("data-tab")&&(console.log("Activity tab is active on load, initializing tree..."),s());const i=document.getElementById("activity-tab");i&&i.classList.contains("active")&&(console.log("Activity panel is active on load, initializing tree..."),t||s())};"loading"===document.readyState?document.addEventListener("DOMContentLoaded",t):t();
//# sourceMappingURL=activity-tree.js.map
