/*
 * Decompiled with CFR 0.152.
 */
package scene;

import allocator.Allocator;
import bridge.ContractInstanceInSDC;
import caching.WithMemento;
import disassembler.DisassembledEVMBytecode;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scene.ContractClassIdentifiers;
import scene.ContractWithStateLinkInfo;
import scene.IContractClass;
import scene.IContractClassIdentifiers;
import scene.IContractWithSource;
import scene.IMutableStorageInfo;
import scene.IScene;
import scene.ITACMethod;
import scene.MethodAttribute;
import scene.MethodIdentifiers;
import tac.ICoreTACProgram;
import tac.IStorageInfo;
import tac.ITACSymbol;
import tac.TACStorageLayout;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001>J\b\u0010!\u001a\u00020\u0000H&J\n\u0010\"\u001a\u0004\u0018\u00010\u0013H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130&H&J\u0012\u0010'\u001a\u0004\u0018\u00010\u00132\u0006\u0010(\u001a\u00020\u0018H&J\u0012\u0010)\u001a\u0004\u0018\u00010\u00132\u0006\u0010*\u001a\u00020+H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130,H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130&H\u0016J\n\u0010.\u001a\u0004\u0018\u00010/H&J\b\u00100\u001a\u00020\u0013H\u0016J*\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020706H&J*\u00108\u001a\u0002022\u0006\u00103\u001a\u0002042\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020206H\u0016J\u0010\u00109\u001a\u0002022\u0006\u0010:\u001a\u00020\u0002H\u0016J\b\u0010;\u001a\u00020\u0002H\u0016J\b\u0010<\u001a\u00020=H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00130\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0015\u00a8\u0006?"}, d2={"Lscene/IContractClass;", "Lcaching/WithMemento;", "Lscene/IContractClass$ContractMemento;", "Lscene/IContractClassIdentifiers;", "addressSym", "Ltac/ITACSymbol;", "getAddressSym", "()Ltac/ITACSymbol;", "bytecode", "Ldisassembler/DisassembledEVMBytecode;", "getBytecode", "()Ldisassembler/DisassembledEVMBytecode;", "constructorBytecode", "getConstructorBytecode", "constructorCodeName", "", "getConstructorCodeName", "()Ljava/lang/String;", "constructorMethod", "Lscene/ITACMethod;", "getConstructorMethod", "()Lscene/ITACMethod;", "methods", "", "Ljava/math/BigInteger;", "getMethods", "()Ljava/util/Map;", "storage", "Ltac/IStorageInfo;", "getStorage", "()Ltac/IStorageInfo;", "wholeContractMethod", "getWholeContractMethod", "fork", "getConstructor", "getContractStateLinks", "Lscene/ContractWithStateLinkInfo;", "getDeclaredMethods", "", "getMethodBySigHash", "sig", "getMethodByUniqueAttribute", "attr", "Lscene/MethodAttribute$Unique;", "", "getStandardMethods", "getStorageLayout", "Ltac/TACStorageLayout;", "getWholeContract", "mapMethods", "", "scene", "Lscene/IScene;", "p", "Lkotlin/Function2;", "Ltac/ICoreTACProgram;", "mapMethodsInPlace", "restore", "m", "saveState", "toIdentifiers", "Lscene/ContractClassIdentifiers;", "ContractMemento", "Shared"})
public interface IContractClass
extends WithMemento<ContractMemento>,
IContractClassIdentifiers {
    @NotNull
    public Map<BigInteger, ITACMethod> getMethods();

    @Override
    @Nullable
    public ITACMethod getWholeContractMethod();

    @Override
    @Nullable
    public ITACMethod getConstructorMethod();

    @NotNull
    public ContractClassIdentifiers toIdentifiers();

    @Override
    @NotNull
    public ITACMethod getWholeContract();

    @Override
    @Nullable
    public ITACMethod getConstructor();

    @Override
    @Nullable
    public ITACMethod getMethodBySigHash(@NotNull BigInteger var1);

    @Override
    @Nullable
    public ITACMethod getMethodByUniqueAttribute(@NotNull MethodAttribute.Unique var1);

    @NotNull
    public IStorageInfo getStorage();

    @Nullable
    public TACStorageLayout getStorageLayout();

    @NotNull
    public List<ITACMethod> getMethods();

    @NotNull
    public Collection<ITACMethod> getDeclaredMethods();

    @NotNull
    public Collection<ITACMethod> getStandardMethods();

    public void mapMethodsInPlace(@NotNull IScene var1, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> var2);

    public void mapMethods(@NotNull IScene var1, @NotNull Function2<? super IScene, ? super ITACMethod, ? extends ICoreTACProgram> var2);

    @NotNull
    public IContractClass fork();

    @NotNull
    public ITACSymbol getAddressSym();

    @Nullable
    public DisassembledEVMBytecode getBytecode();

    @Nullable
    public DisassembledEVMBytecode getConstructorBytecode();

    @NotNull
    public String getConstructorCodeName();

    @Override
    @NotNull
    public ContractMemento saveState();

    @Override
    public void restore(@NotNull ContractMemento var1);

    @Nullable
    public ContractWithStateLinkInfo getContractStateLinks();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B3\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lscene/IContractClass$ContractMemento;", "Ljava/io/Serializable;", "methods", "", "Ljava/math/BigInteger;", "Ltac/ICoreTACProgram;", "constructorCode", "Lscene/ITACMethod;", "storageInfo", "Ltac/IStorageInfo;", "allocState", "Lallocator/Allocator$Memento;", "(Ljava/util/Map;Lscene/ITACMethod;Ltac/IStorageInfo;Lallocator/Allocator$Memento;)V", "getAllocState", "()Lallocator/Allocator$Memento;", "getConstructorCode", "()Lscene/ITACMethod;", "getMethods", "()Ljava/util/Map;", "getStorageInfo", "()Ltac/IStorageInfo;", "Shared"})
    public static final class ContractMemento
    implements Serializable {
        @NotNull
        private final Map<BigInteger, ICoreTACProgram> methods;
        @Nullable
        private final ITACMethod constructorCode;
        @NotNull
        private final IStorageInfo storageInfo;
        @NotNull
        private final Allocator.Memento allocState;

        public ContractMemento(@NotNull Map<BigInteger, ? extends ICoreTACProgram> methods, @Nullable ITACMethod constructorCode, @NotNull IStorageInfo storageInfo, @NotNull Allocator.Memento allocState) {
            Intrinsics.checkNotNullParameter(methods, "methods");
            Intrinsics.checkNotNullParameter(storageInfo, "storageInfo");
            Intrinsics.checkNotNullParameter(allocState, "allocState");
            this.methods = methods;
            this.constructorCode = constructorCode;
            this.storageInfo = storageInfo;
            this.allocState = allocState;
        }

        @NotNull
        public final Map<BigInteger, ICoreTACProgram> getMethods() {
            return this.methods;
        }

        @Nullable
        public final ITACMethod getConstructorCode() {
            return this.constructorCode;
        }

        @NotNull
        public final IStorageInfo getStorageInfo() {
            return this.storageInfo;
        }

        @NotNull
        public final Allocator.Memento getAllocState() {
            return this.allocState;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public static ContractClassIdentifiers toIdentifiers(@NotNull IContractClass this_) {
            void $this$associateByTo$iv$iv;
            Intrinsics.checkNotNullParameter(this_, "this");
            BigInteger bigInteger = this_.getInstanceId();
            String string = this_.getName();
            ITACMethod iTACMethod = this_.getMethodByUniqueAttribute(MethodAttribute.Unique.Whole.INSTANCE);
            MethodIdentifiers methodIdentifiers = iTACMethod == null ? null : iTACMethod.toIdentifiers();
            ITACMethod iTACMethod2 = this_.getConstructor();
            MethodIdentifiers methodIdentifiers2 = iTACMethod2 == null ? null : iTACMethod2.toIdentifiers();
            Sequence $this$associateBy$iv = SequencesKt.map(CollectionsKt.asSequence((Iterable)this_.getMethods()), toIdentifiers.1.INSTANCE);
            boolean $i$f$associateBy = false;
            Sequence sequence = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                MethodIdentifiers methodIdentifiers3 = (MethodIdentifiers)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(it.getSigHash().getN(), element$iv$iv);
            }
            Map map3 = destination$iv$iv;
            return new ContractClassIdentifiers(bigInteger, string, map3, methodIdentifiers, methodIdentifiers2);
        }

        @NotNull
        public static ITACMethod getWholeContract(@NotNull IContractClass this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            ITACMethod iTACMethod = this_.getMethodByUniqueAttribute(MethodAttribute.Unique.Whole.INSTANCE);
            if (iTACMethod == null) {
                throw new IllegalStateException("Can't ask for whole contract before loading".toString());
            }
            return iTACMethod;
        }

        @Nullable
        public static ITACMethod getConstructor(@NotNull IContractClass this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.getMethodByUniqueAttribute(MethodAttribute.Unique.Constructor.INSTANCE);
        }

        @Nullable
        public static ITACMethod getMethodByUniqueAttribute(@NotNull IContractClass this_, @NotNull MethodAttribute.Unique attr) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(attr, "attr");
            return (ITACMethod)IContractClassIdentifiers.DefaultImpls.getMethodByUniqueAttribute(this_, attr);
        }

        @NotNull
        public static List<ITACMethod> getMethods(@NotNull IContractClass this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return CollectionsKt.plus(this_.getDeclaredMethods(), this_.getWholeContract());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Collection<ITACMethod> getStandardMethods(@NotNull IContractClass this_) {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter(this_, "this");
            Iterable $this$filterNot$iv = this_.getDeclaredMethods();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                ITACMethod it = (ITACMethod)element$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual(it.getAttribute(), MethodAttribute.Unique.Constructor.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public static void mapMethodsInPlace(@NotNull IContractClass this_, @NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> p) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(scene, "scene");
            Intrinsics.checkNotNullParameter(p, "p");
            Iterable $this$forEach$iv = this_.getDeclaredMethods();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ITACMethod it = (ITACMethod)element$iv;
                boolean bl = false;
                p.invoke(scene, it);
            }
        }

        @NotNull
        public static String getConstructorCodeName(@NotNull IContractClass this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return "constructor_" + this_.getName();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static ContractMemento saveState(@NotNull IContractClass this_) {
            void $this$associateTo$iv$iv;
            Intrinsics.checkNotNullParameter(this_, "this");
            Iterable $this$associate$iv = this_.getMethods();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                ITACMethod it = (ITACMethod)element$iv$iv;
                boolean bl = false;
                Pair<BigInteger, ICoreTACProgram> pair2 = TuplesKt.to(it.getSigHash().getN(), it.getCode());
                map2.put(pair2.getFirst(), pair2.getSecond());
            }
            Allocator.Memento memento = Allocator.INSTANCE.saveState();
            IStorageInfo iStorageInfo = this_.getStorage();
            ITACMethod iTACMethod = this_.getConstructor();
            Map map3 = destination$iv$iv;
            return new ContractMemento(map3, iTACMethod, iStorageInfo, memento);
        }

        public static void restore(@NotNull IContractClass this_, @NotNull ContractMemento m) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(m, "m");
            for (ITACMethod meth : this_.getMethods()) {
                ICoreTACProgram iCoreTACProgram = m.getMethods().get(meth.getSigHash().getN());
                if (iCoreTACProgram == null) {
                    throw new IllegalStateException("Broken cache".toString());
                }
                meth.setCode(iCoreTACProgram);
            }
            ITACMethod iTACMethod = this_.getConstructor();
            if (iTACMethod != null) {
                ITACMethod iTACMethod2 = m.getConstructorCode();
                Intrinsics.checkNotNull(iTACMethod2);
                iTACMethod.setCode(iTACMethod2.getCode());
            }
            if (this_ instanceof IMutableStorageInfo) {
                ((IMutableStorageInfo)((Object)this_)).setStorageInfo(m.getStorageInfo());
            } else if (!Intrinsics.areEqual(this_.getStorage(), m.getStorageInfo())) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            Allocator.INSTANCE.restore(m.getAllocState());
        }

        @Nullable
        public static ContractWithStateLinkInfo getContractStateLinks(@NotNull IContractClass this_) {
            ContractWithStateLinkInfo contractWithStateLinkInfo;
            Intrinsics.checkNotNullParameter(this_, "this");
            IContractWithSource iContractWithSource = this_ instanceof IContractWithSource ? (IContractWithSource)((Object)this_) : null;
            if (iContractWithSource == null) {
                contractWithStateLinkInfo = null;
            } else {
                ContractInstanceInSDC contractInstanceInSDC = iContractWithSource.getSrc();
                if (contractInstanceInSDC == null) {
                    contractWithStateLinkInfo = null;
                } else {
                    Map<BigInteger, BigInteger> map2 = contractInstanceInSDC.getState();
                    if (map2 == null) {
                        contractWithStateLinkInfo = null;
                    } else {
                        Map<BigInteger, BigInteger> it = map2;
                        boolean bl = false;
                        contractWithStateLinkInfo = new ContractWithStateLinkInfo(this_, it);
                    }
                }
            }
            return contractWithStateLinkInfo;
        }
    }
}

