mooniswap_abi = [
    {
        "inputs": [
            {"internalType": "contract IERC20", "name": "_token0", "type": "address"},
            {"internalType": "contract IERC20", "name": "_token1", "type": "address"},
            {"internalType": "string", "name": "name", "type": "string"},
            {"internalType": "string", "name": "symbol", "type": "string"},
            {
                "internalType": "contract IMooniswapFactoryGovernance",
                "name": "_mooniswapFactoryGovernance",
                "type": "address",
            },
        ],
        "stateMutability": "nonpayable",
        "type": "constructor",
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": True,
                "internalType": "address",
                "name": "owner",
                "type": "address",
            },
            {
                "indexed": True,
                "internalType": "address",
                "name": "spender",
                "type": "address",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "value",
                "type": "uint256",
            },
        ],
        "name": "Approval",
        "type": "event",
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": True,
                "internalType": "address",
                "name": "user",
                "type": "address",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "decayPeriod",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "bool",
                "name": "isDefault",
                "type": "bool",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "amount",
                "type": "uint256",
            },
        ],
        "name": "DecayPeriodVoteUpdate",
        "type": "event",
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": True,
                "internalType": "address",
                "name": "sender",
                "type": "address",
            },
            {
                "indexed": True,
                "internalType": "address",
                "name": "receiver",
                "type": "address",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "share",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "token0Amount",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "token1Amount",
                "type": "uint256",
            },
        ],
        "name": "Deposited",
        "type": "event",
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": False,
                "internalType": "string",
                "name": "reason",
                "type": "string",
            }
        ],
        "name": "Error",
        "type": "event",
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": True,
                "internalType": "address",
                "name": "user",
                "type": "address",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "fee",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "bool",
                "name": "isDefault",
                "type": "bool",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "amount",
                "type": "uint256",
            },
        ],
        "name": "FeeVoteUpdate",
        "type": "event",
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": True,
                "internalType": "address",
                "name": "previousOwner",
                "type": "address",
            },
            {
                "indexed": True,
                "internalType": "address",
                "name": "newOwner",
                "type": "address",
            },
        ],
        "name": "OwnershipTransferred",
        "type": "event",
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": True,
                "internalType": "address",
                "name": "user",
                "type": "address",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "slippageFee",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "bool",
                "name": "isDefault",
                "type": "bool",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "amount",
                "type": "uint256",
            },
        ],
        "name": "SlippageFeeVoteUpdate",
        "type": "event",
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": True,
                "internalType": "address",
                "name": "sender",
                "type": "address",
            },
            {
                "indexed": True,
                "internalType": "address",
                "name": "receiver",
                "type": "address",
            },
            {
                "indexed": True,
                "internalType": "address",
                "name": "srcToken",
                "type": "address",
            },
            {
                "indexed": False,
                "internalType": "address",
                "name": "dstToken",
                "type": "address",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "amount",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "result",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "srcAdditionBalance",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "dstRemovalBalance",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "address",
                "name": "referral",
                "type": "address",
            },
        ],
        "name": "Swapped",
        "type": "event",
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "srcBalance",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "dstBalance",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "fee",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "slippageFee",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "referralShare",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "governanceShare",
                "type": "uint256",
            },
        ],
        "name": "Sync",
        "type": "event",
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": True,
                "internalType": "address",
                "name": "from",
                "type": "address",
            },
            {
                "indexed": True,
                "internalType": "address",
                "name": "to",
                "type": "address",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "value",
                "type": "uint256",
            },
        ],
        "name": "Transfer",
        "type": "event",
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "indexed": True,
                "internalType": "address",
                "name": "sender",
                "type": "address",
            },
            {
                "indexed": True,
                "internalType": "address",
                "name": "receiver",
                "type": "address",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "share",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "token0Amount",
                "type": "uint256",
            },
            {
                "indexed": False,
                "internalType": "uint256",
                "name": "token1Amount",
                "type": "uint256",
            },
        ],
        "name": "Withdrawn",
        "type": "event",
    },
    {
        "inputs": [
            {"internalType": "address", "name": "owner", "type": "address"},
            {"internalType": "address", "name": "spender", "type": "address"},
        ],
        "name": "allowance",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [
            {"internalType": "address", "name": "spender", "type": "address"},
            {"internalType": "uint256", "name": "amount", "type": "uint256"},
        ],
        "name": "approve",
        "outputs": [{"internalType": "bool", "name": "", "type": "bool"}],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [{"internalType": "address", "name": "account", "type": "address"}],
        "name": "balanceOf",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "decayPeriod",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [{"internalType": "uint256", "name": "vote", "type": "uint256"}],
        "name": "decayPeriodVote",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [{"internalType": "address", "name": "user", "type": "address"}],
        "name": "decayPeriodVotes",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "decimals",
        "outputs": [{"internalType": "uint8", "name": "", "type": "uint8"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [
            {"internalType": "address", "name": "spender", "type": "address"},
            {"internalType": "uint256", "name": "subtractedValue", "type": "uint256"},
        ],
        "name": "decreaseAllowance",
        "outputs": [{"internalType": "bool", "name": "", "type": "bool"}],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [
            {"internalType": "uint256[2]", "name": "maxAmounts", "type": "uint256[2]"},
            {"internalType": "uint256[2]", "name": "minAmounts", "type": "uint256[2]"},
        ],
        "name": "deposit",
        "outputs": [
            {"internalType": "uint256", "name": "fairSupply", "type": "uint256"},
            {
                "internalType": "uint256[2]",
                "name": "receivedAmounts",
                "type": "uint256[2]",
            },
        ],
        "stateMutability": "payable",
        "type": "function",
    },
    {
        "inputs": [
            {"internalType": "uint256[2]", "name": "maxAmounts", "type": "uint256[2]"},
            {"internalType": "uint256[2]", "name": "minAmounts", "type": "uint256[2]"},
            {"internalType": "address", "name": "target", "type": "address"},
        ],
        "name": "depositFor",
        "outputs": [
            {"internalType": "uint256", "name": "fairSupply", "type": "uint256"},
            {
                "internalType": "uint256[2]",
                "name": "receivedAmounts",
                "type": "uint256[2]",
            },
        ],
        "stateMutability": "payable",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "discardDecayPeriodVote",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "discardFeeVote",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "discardSlippageFeeVote",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "fee",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [{"internalType": "uint256", "name": "vote", "type": "uint256"}],
        "name": "feeVote",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [{"internalType": "address", "name": "user", "type": "address"}],
        "name": "feeVotes",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [
            {"internalType": "contract IERC20", "name": "token", "type": "address"}
        ],
        "name": "getBalanceForAddition",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [
            {"internalType": "contract IERC20", "name": "token", "type": "address"}
        ],
        "name": "getBalanceForRemoval",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [
            {"internalType": "contract IERC20", "name": "src", "type": "address"},
            {"internalType": "contract IERC20", "name": "dst", "type": "address"},
            {"internalType": "uint256", "name": "amount", "type": "uint256"},
        ],
        "name": "getReturn",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "getTokens",
        "outputs": [
            {"internalType": "contract IERC20[]", "name": "tokens", "type": "address[]"}
        ],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [
            {"internalType": "address", "name": "spender", "type": "address"},
            {"internalType": "uint256", "name": "addedValue", "type": "uint256"},
        ],
        "name": "increaseAllowance",
        "outputs": [{"internalType": "bool", "name": "", "type": "bool"}],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "mooniswapFactoryGovernance",
        "outputs": [
            {
                "internalType": "contract IMooniswapFactoryGovernance",
                "name": "",
                "type": "address",
            }
        ],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "name",
        "outputs": [{"internalType": "string", "name": "", "type": "string"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "owner",
        "outputs": [{"internalType": "address", "name": "", "type": "address"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "renounceOwnership",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [
            {"internalType": "contract IERC20", "name": "token", "type": "address"},
            {"internalType": "uint256", "name": "amount", "type": "uint256"},
        ],
        "name": "rescueFunds",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [
            {
                "internalType": "contract IMooniswapFactoryGovernance",
                "name": "newMooniswapFactoryGovernance",
                "type": "address",
            }
        ],
        "name": "setMooniswapFactoryGovernance",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "slippageFee",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [{"internalType": "uint256", "name": "vote", "type": "uint256"}],
        "name": "slippageFeeVote",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [{"internalType": "address", "name": "user", "type": "address"}],
        "name": "slippageFeeVotes",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [
            {"internalType": "contract IERC20", "name": "src", "type": "address"},
            {"internalType": "contract IERC20", "name": "dst", "type": "address"},
            {"internalType": "uint256", "name": "amount", "type": "uint256"},
            {"internalType": "uint256", "name": "minReturn", "type": "uint256"},
            {"internalType": "address", "name": "referral", "type": "address"},
        ],
        "name": "swap",
        "outputs": [{"internalType": "uint256", "name": "result", "type": "uint256"}],
        "stateMutability": "payable",
        "type": "function",
    },
    {
        "inputs": [
            {"internalType": "contract IERC20", "name": "src", "type": "address"},
            {"internalType": "contract IERC20", "name": "dst", "type": "address"},
            {"internalType": "uint256", "name": "amount", "type": "uint256"},
            {"internalType": "uint256", "name": "minReturn", "type": "uint256"},
            {"internalType": "address", "name": "referral", "type": "address"},
            {"internalType": "address payable", "name": "receiver", "type": "address"},
        ],
        "name": "swapFor",
        "outputs": [{"internalType": "uint256", "name": "result", "type": "uint256"}],
        "stateMutability": "payable",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "symbol",
        "outputs": [{"internalType": "string", "name": "", "type": "string"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "token0",
        "outputs": [{"internalType": "contract IERC20", "name": "", "type": "address"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "token1",
        "outputs": [{"internalType": "contract IERC20", "name": "", "type": "address"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [{"internalType": "uint256", "name": "i", "type": "uint256"}],
        "name": "tokens",
        "outputs": [{"internalType": "contract IERC20", "name": "", "type": "address"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "totalSupply",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [
            {"internalType": "address", "name": "recipient", "type": "address"},
            {"internalType": "uint256", "name": "amount", "type": "uint256"},
        ],
        "name": "transfer",
        "outputs": [{"internalType": "bool", "name": "", "type": "bool"}],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [
            {"internalType": "address", "name": "sender", "type": "address"},
            {"internalType": "address", "name": "recipient", "type": "address"},
            {"internalType": "uint256", "name": "amount", "type": "uint256"},
        ],
        "name": "transferFrom",
        "outputs": [{"internalType": "bool", "name": "", "type": "bool"}],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [{"internalType": "address", "name": "newOwner", "type": "address"}],
        "name": "transferOwnership",
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [{"internalType": "contract IERC20", "name": "", "type": "address"}],
        "name": "virtualBalancesForAddition",
        "outputs": [
            {"internalType": "uint216", "name": "balance", "type": "uint216"},
            {"internalType": "uint40", "name": "time", "type": "uint40"},
        ],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [{"internalType": "contract IERC20", "name": "", "type": "address"}],
        "name": "virtualBalancesForRemoval",
        "outputs": [
            {"internalType": "uint216", "name": "balance", "type": "uint216"},
            {"internalType": "uint40", "name": "time", "type": "uint40"},
        ],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "virtualDecayPeriod",
        "outputs": [
            {"internalType": "uint104", "name": "", "type": "uint104"},
            {"internalType": "uint104", "name": "", "type": "uint104"},
            {"internalType": "uint48", "name": "", "type": "uint48"},
        ],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "virtualFee",
        "outputs": [
            {"internalType": "uint104", "name": "", "type": "uint104"},
            {"internalType": "uint104", "name": "", "type": "uint104"},
            {"internalType": "uint48", "name": "", "type": "uint48"},
        ],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [],
        "name": "virtualSlippageFee",
        "outputs": [
            {"internalType": "uint104", "name": "", "type": "uint104"},
            {"internalType": "uint104", "name": "", "type": "uint104"},
            {"internalType": "uint48", "name": "", "type": "uint48"},
        ],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [{"internalType": "contract IERC20", "name": "", "type": "address"}],
        "name": "volumes",
        "outputs": [
            {"internalType": "uint128", "name": "confirmed", "type": "uint128"},
            {"internalType": "uint128", "name": "result", "type": "uint128"},
        ],
        "stateMutability": "view",
        "type": "function",
    },
    {
        "inputs": [
            {"internalType": "uint256", "name": "amount", "type": "uint256"},
            {"internalType": "uint256[]", "name": "minReturns", "type": "uint256[]"},
        ],
        "name": "withdraw",
        "outputs": [
            {
                "internalType": "uint256[2]",
                "name": "withdrawnAmounts",
                "type": "uint256[2]",
            }
        ],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "inputs": [
            {"internalType": "uint256", "name": "amount", "type": "uint256"},
            {"internalType": "uint256[]", "name": "minReturns", "type": "uint256[]"},
            {"internalType": "address payable", "name": "target", "type": "address"},
        ],
        "name": "withdrawFor",
        "outputs": [
            {
                "internalType": "uint256[2]",
                "name": "withdrawnAmounts",
                "type": "uint256[2]",
            }
        ],
        "stateMutability": "nonpayable",
        "type": "function",
    },
]
