import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KustoDatabasePrincipalAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal_assignment.html#cluster_name KustoDatabasePrincipalAssignment#cluster_name}.
     *
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal_assignment.html#database_name KustoDatabasePrincipalAssignment#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal_assignment.html#name KustoDatabasePrincipalAssignment#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal_assignment.html#principal_id KustoDatabasePrincipalAssignment#principal_id}.
     *
     * @stability stable
     */
    readonly principalId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal_assignment.html#principal_type KustoDatabasePrincipalAssignment#principal_type}.
     *
     * @stability stable
     */
    readonly principalType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal_assignment.html#resource_group_name KustoDatabasePrincipalAssignment#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal_assignment.html#role KustoDatabasePrincipalAssignment#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal_assignment.html#tenant_id KustoDatabasePrincipalAssignment#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal_assignment.html#timeouts KustoDatabasePrincipalAssignment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KustoDatabasePrincipalAssignmentTimeouts;
}
/**
 * @stability stable
 */
export interface KustoDatabasePrincipalAssignmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal_assignment.html#create KustoDatabasePrincipalAssignment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal_assignment.html#delete KustoDatabasePrincipalAssignment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal_assignment.html#read KustoDatabasePrincipalAssignment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function kustoDatabasePrincipalAssignmentTimeoutsToTerraform(struct?: KustoDatabasePrincipalAssignmentTimeoutsOutputReference | KustoDatabasePrincipalAssignmentTimeouts): any;
/**
 * @stability stable
 */
export declare class KustoDatabasePrincipalAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KustoDatabasePrincipalAssignmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KustoDatabasePrincipalAssignmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal_assignment.html azurerm_kusto_database_principal_assignment}.
 *
 * @stability stable
 */
export declare class KustoDatabasePrincipalAssignment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal_assignment.html azurerm_kusto_database_principal_assignment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KustoDatabasePrincipalAssignmentConfig);
    private _clusterName?;
    /**
     * @stability stable
     */
    get clusterName(): string;
    /**
     * @stability stable
     */
    set clusterName(value: string);
    /**
     * @stability stable
     */
    get clusterNameInput(): string | undefined;
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _principalId?;
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    set principalId(value: string);
    /**
     * @stability stable
     */
    get principalIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get principalName(): string;
    private _principalType?;
    /**
     * @stability stable
     */
    get principalType(): string;
    /**
     * @stability stable
     */
    set principalType(value: string);
    /**
     * @stability stable
     */
    get principalTypeInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get tenantName(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KustoDatabasePrincipalAssignmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KustoDatabasePrincipalAssignmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KustoDatabasePrincipalAssignmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
