import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitorActionRuleActionGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#action_group_id MonitorActionRuleActionGroup#action_group_id}.
     *
     * @stability stable
     */
    readonly actionGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#description MonitorActionRuleActionGroup#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#enabled MonitorActionRuleActionGroup#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#name MonitorActionRuleActionGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#resource_group_name MonitorActionRuleActionGroup#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#tags MonitorActionRuleActionGroup#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#condition MonitorActionRuleActionGroup#condition}
     *
     * @stability stable
     */
    readonly condition?: MonitorActionRuleActionGroupCondition;
    /**
     * scope block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#scope MonitorActionRuleActionGroup#scope}
     *
     * @stability stable
     */
    readonly scope?: MonitorActionRuleActionGroupScope;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#timeouts MonitorActionRuleActionGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitorActionRuleActionGroupTimeouts;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleActionGroupConditionAlertContext {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#operator MonitorActionRuleActionGroup#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#values MonitorActionRuleActionGroup#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorActionRuleActionGroupConditionAlertContextToTerraform(struct?: MonitorActionRuleActionGroupConditionAlertContextOutputReference | MonitorActionRuleActionGroupConditionAlertContext): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleActionGroupConditionAlertContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleActionGroupConditionAlertContext | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleActionGroupConditionAlertContext | undefined);
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleActionGroupConditionAlertRuleId {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#operator MonitorActionRuleActionGroup#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#values MonitorActionRuleActionGroup#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorActionRuleActionGroupConditionAlertRuleIdToTerraform(struct?: MonitorActionRuleActionGroupConditionAlertRuleIdOutputReference | MonitorActionRuleActionGroupConditionAlertRuleId): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleActionGroupConditionAlertRuleIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleActionGroupConditionAlertRuleId | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleActionGroupConditionAlertRuleId | undefined);
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleActionGroupConditionDescription {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#operator MonitorActionRuleActionGroup#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#values MonitorActionRuleActionGroup#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorActionRuleActionGroupConditionDescriptionToTerraform(struct?: MonitorActionRuleActionGroupConditionDescriptionOutputReference | MonitorActionRuleActionGroupConditionDescription): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleActionGroupConditionDescriptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleActionGroupConditionDescription | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleActionGroupConditionDescription | undefined);
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleActionGroupConditionMonitor {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#operator MonitorActionRuleActionGroup#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#values MonitorActionRuleActionGroup#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorActionRuleActionGroupConditionMonitorToTerraform(struct?: MonitorActionRuleActionGroupConditionMonitorOutputReference | MonitorActionRuleActionGroupConditionMonitor): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleActionGroupConditionMonitorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleActionGroupConditionMonitor | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleActionGroupConditionMonitor | undefined);
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleActionGroupConditionMonitorService {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#operator MonitorActionRuleActionGroup#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#values MonitorActionRuleActionGroup#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorActionRuleActionGroupConditionMonitorServiceToTerraform(struct?: MonitorActionRuleActionGroupConditionMonitorServiceOutputReference | MonitorActionRuleActionGroupConditionMonitorService): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleActionGroupConditionMonitorServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleActionGroupConditionMonitorService | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleActionGroupConditionMonitorService | undefined);
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleActionGroupConditionSeverity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#operator MonitorActionRuleActionGroup#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#values MonitorActionRuleActionGroup#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorActionRuleActionGroupConditionSeverityToTerraform(struct?: MonitorActionRuleActionGroupConditionSeverityOutputReference | MonitorActionRuleActionGroupConditionSeverity): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleActionGroupConditionSeverityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleActionGroupConditionSeverity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleActionGroupConditionSeverity | undefined);
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleActionGroupConditionTargetResourceType {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#operator MonitorActionRuleActionGroup#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#values MonitorActionRuleActionGroup#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorActionRuleActionGroupConditionTargetResourceTypeToTerraform(struct?: MonitorActionRuleActionGroupConditionTargetResourceTypeOutputReference | MonitorActionRuleActionGroupConditionTargetResourceType): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleActionGroupConditionTargetResourceTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleActionGroupConditionTargetResourceType | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleActionGroupConditionTargetResourceType | undefined);
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleActionGroupCondition {
    /**
     * alert_context block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#alert_context MonitorActionRuleActionGroup#alert_context}
     *
     * @stability stable
     */
    readonly alertContext?: MonitorActionRuleActionGroupConditionAlertContext;
    /**
     * alert_rule_id block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#alert_rule_id MonitorActionRuleActionGroup#alert_rule_id}
     *
     * @stability stable
     */
    readonly alertRuleId?: MonitorActionRuleActionGroupConditionAlertRuleId;
    /**
     * description block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#description MonitorActionRuleActionGroup#description}
     *
     * @stability stable
     */
    readonly description?: MonitorActionRuleActionGroupConditionDescription;
    /**
     * monitor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#monitor MonitorActionRuleActionGroup#monitor}
     *
     * @stability stable
     */
    readonly monitor?: MonitorActionRuleActionGroupConditionMonitor;
    /**
     * monitor_service block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#monitor_service MonitorActionRuleActionGroup#monitor_service}
     *
     * @stability stable
     */
    readonly monitorService?: MonitorActionRuleActionGroupConditionMonitorService;
    /**
     * severity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#severity MonitorActionRuleActionGroup#severity}
     *
     * @stability stable
     */
    readonly severity?: MonitorActionRuleActionGroupConditionSeverity;
    /**
     * target_resource_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#target_resource_type MonitorActionRuleActionGroup#target_resource_type}
     *
     * @stability stable
     */
    readonly targetResourceType?: MonitorActionRuleActionGroupConditionTargetResourceType;
}
export declare function monitorActionRuleActionGroupConditionToTerraform(struct?: MonitorActionRuleActionGroupConditionOutputReference | MonitorActionRuleActionGroupCondition): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleActionGroupConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleActionGroupCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleActionGroupCondition | undefined);
    private _alertContext;
    /**
     * @stability stable
     */
    get alertContext(): MonitorActionRuleActionGroupConditionAlertContextOutputReference;
    /**
     * @stability stable
     */
    putAlertContext(value: MonitorActionRuleActionGroupConditionAlertContext): void;
    /**
     * @stability stable
     */
    resetAlertContext(): void;
    /**
     * @stability stable
     */
    get alertContextInput(): MonitorActionRuleActionGroupConditionAlertContext | undefined;
    private _alertRuleId;
    /**
     * @stability stable
     */
    get alertRuleId(): MonitorActionRuleActionGroupConditionAlertRuleIdOutputReference;
    /**
     * @stability stable
     */
    putAlertRuleId(value: MonitorActionRuleActionGroupConditionAlertRuleId): void;
    /**
     * @stability stable
     */
    resetAlertRuleId(): void;
    /**
     * @stability stable
     */
    get alertRuleIdInput(): MonitorActionRuleActionGroupConditionAlertRuleId | undefined;
    private _description;
    /**
     * @stability stable
     */
    get description(): MonitorActionRuleActionGroupConditionDescriptionOutputReference;
    /**
     * @stability stable
     */
    putDescription(value: MonitorActionRuleActionGroupConditionDescription): void;
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): MonitorActionRuleActionGroupConditionDescription | undefined;
    private _monitor;
    /**
     * @stability stable
     */
    get monitor(): MonitorActionRuleActionGroupConditionMonitorOutputReference;
    /**
     * @stability stable
     */
    putMonitor(value: MonitorActionRuleActionGroupConditionMonitor): void;
    /**
     * @stability stable
     */
    resetMonitor(): void;
    /**
     * @stability stable
     */
    get monitorInput(): MonitorActionRuleActionGroupConditionMonitor | undefined;
    private _monitorService;
    /**
     * @stability stable
     */
    get monitorService(): MonitorActionRuleActionGroupConditionMonitorServiceOutputReference;
    /**
     * @stability stable
     */
    putMonitorService(value: MonitorActionRuleActionGroupConditionMonitorService): void;
    /**
     * @stability stable
     */
    resetMonitorService(): void;
    /**
     * @stability stable
     */
    get monitorServiceInput(): MonitorActionRuleActionGroupConditionMonitorService | undefined;
    private _severity;
    /**
     * @stability stable
     */
    get severity(): MonitorActionRuleActionGroupConditionSeverityOutputReference;
    /**
     * @stability stable
     */
    putSeverity(value: MonitorActionRuleActionGroupConditionSeverity): void;
    /**
     * @stability stable
     */
    resetSeverity(): void;
    /**
     * @stability stable
     */
    get severityInput(): MonitorActionRuleActionGroupConditionSeverity | undefined;
    private _targetResourceType;
    /**
     * @stability stable
     */
    get targetResourceType(): MonitorActionRuleActionGroupConditionTargetResourceTypeOutputReference;
    /**
     * @stability stable
     */
    putTargetResourceType(value: MonitorActionRuleActionGroupConditionTargetResourceType): void;
    /**
     * @stability stable
     */
    resetTargetResourceType(): void;
    /**
     * @stability stable
     */
    get targetResourceTypeInput(): MonitorActionRuleActionGroupConditionTargetResourceType | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleActionGroupScope {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#resource_ids MonitorActionRuleActionGroup#resource_ids}.
     *
     * @stability stable
     */
    readonly resourceIds: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#type MonitorActionRuleActionGroup#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function monitorActionRuleActionGroupScopeToTerraform(struct?: MonitorActionRuleActionGroupScopeOutputReference | MonitorActionRuleActionGroupScope): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleActionGroupScopeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleActionGroupScope | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleActionGroupScope | undefined);
    private _resourceIds?;
    /**
     * @stability stable
     */
    get resourceIds(): string[];
    /**
     * @stability stable
     */
    set resourceIds(value: string[]);
    /**
     * @stability stable
     */
    get resourceIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleActionGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#create MonitorActionRuleActionGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#delete MonitorActionRuleActionGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#read MonitorActionRuleActionGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html#update MonitorActionRuleActionGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitorActionRuleActionGroupTimeoutsToTerraform(struct?: MonitorActionRuleActionGroupTimeoutsOutputReference | MonitorActionRuleActionGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleActionGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleActionGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleActionGroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html azurerm_monitor_action_rule_action_group}.
 *
 * @stability stable
 */
export declare class MonitorActionRuleActionGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_action_group.html azurerm_monitor_action_rule_action_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitorActionRuleActionGroupConfig);
    private _actionGroupId?;
    /**
     * @stability stable
     */
    get actionGroupId(): string;
    /**
     * @stability stable
     */
    set actionGroupId(value: string);
    /**
     * @stability stable
     */
    get actionGroupIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _condition;
    /**
     * @stability stable
     */
    get condition(): MonitorActionRuleActionGroupConditionOutputReference;
    /**
     * @stability stable
     */
    putCondition(value: MonitorActionRuleActionGroupCondition): void;
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): MonitorActionRuleActionGroupCondition | undefined;
    private _scope;
    /**
     * @stability stable
     */
    get scope(): MonitorActionRuleActionGroupScopeOutputReference;
    /**
     * @stability stable
     */
    putScope(value: MonitorActionRuleActionGroupScope): void;
    /**
     * @stability stable
     */
    resetScope(): void;
    /**
     * @stability stable
     */
    get scopeInput(): MonitorActionRuleActionGroupScope | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitorActionRuleActionGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitorActionRuleActionGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitorActionRuleActionGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
