import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MysqlFlexibleServerFirewallRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server_firewall_rule.html#end_ip_address MysqlFlexibleServerFirewallRule#end_ip_address}.
     *
     * @stability stable
     */
    readonly endIpAddress: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server_firewall_rule.html#name MysqlFlexibleServerFirewallRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server_firewall_rule.html#resource_group_name MysqlFlexibleServerFirewallRule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server_firewall_rule.html#server_name MysqlFlexibleServerFirewallRule#server_name}.
     *
     * @stability stable
     */
    readonly serverName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server_firewall_rule.html#start_ip_address MysqlFlexibleServerFirewallRule#start_ip_address}.
     *
     * @stability stable
     */
    readonly startIpAddress: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server_firewall_rule.html#timeouts MysqlFlexibleServerFirewallRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MysqlFlexibleServerFirewallRuleTimeouts;
}
/**
 * @stability stable
 */
export interface MysqlFlexibleServerFirewallRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server_firewall_rule.html#create MysqlFlexibleServerFirewallRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server_firewall_rule.html#delete MysqlFlexibleServerFirewallRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server_firewall_rule.html#read MysqlFlexibleServerFirewallRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server_firewall_rule.html#update MysqlFlexibleServerFirewallRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mysqlFlexibleServerFirewallRuleTimeoutsToTerraform(struct?: MysqlFlexibleServerFirewallRuleTimeoutsOutputReference | MysqlFlexibleServerFirewallRuleTimeouts): any;
/**
 * @stability stable
 */
export declare class MysqlFlexibleServerFirewallRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MysqlFlexibleServerFirewallRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MysqlFlexibleServerFirewallRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server_firewall_rule.html azurerm_mysql_flexible_server_firewall_rule}.
 *
 * @stability stable
 */
export declare class MysqlFlexibleServerFirewallRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server_firewall_rule.html azurerm_mysql_flexible_server_firewall_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MysqlFlexibleServerFirewallRuleConfig);
    private _endIpAddress?;
    /**
     * @stability stable
     */
    get endIpAddress(): string;
    /**
     * @stability stable
     */
    set endIpAddress(value: string);
    /**
     * @stability stable
     */
    get endIpAddressInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _serverName?;
    /**
     * @stability stable
     */
    get serverName(): string;
    /**
     * @stability stable
     */
    set serverName(value: string);
    /**
     * @stability stable
     */
    get serverNameInput(): string | undefined;
    private _startIpAddress?;
    /**
     * @stability stable
     */
    get startIpAddress(): string;
    /**
     * @stability stable
     */
    set startIpAddress(value: string);
    /**
     * @stability stable
     */
    get startIpAddressInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MysqlFlexibleServerFirewallRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MysqlFlexibleServerFirewallRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MysqlFlexibleServerFirewallRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
