import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServicebusSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#auto_delete_on_idle ServicebusSubscription#auto_delete_on_idle}.
     *
     * @stability stable
     */
    readonly autoDeleteOnIdle?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#dead_lettering_on_filter_evaluation_error ServicebusSubscription#dead_lettering_on_filter_evaluation_error}.
     *
     * @stability stable
     */
    readonly deadLetteringOnFilterEvaluationError?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#dead_lettering_on_message_expiration ServicebusSubscription#dead_lettering_on_message_expiration}.
     *
     * @stability stable
     */
    readonly deadLetteringOnMessageExpiration?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#default_message_ttl ServicebusSubscription#default_message_ttl}.
     *
     * @stability stable
     */
    readonly defaultMessageTtl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#enable_batched_operations ServicebusSubscription#enable_batched_operations}.
     *
     * @stability stable
     */
    readonly enableBatchedOperations?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#forward_dead_lettered_messages_to ServicebusSubscription#forward_dead_lettered_messages_to}.
     *
     * @stability stable
     */
    readonly forwardDeadLetteredMessagesTo?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#forward_to ServicebusSubscription#forward_to}.
     *
     * @stability stable
     */
    readonly forwardTo?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#lock_duration ServicebusSubscription#lock_duration}.
     *
     * @stability stable
     */
    readonly lockDuration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#max_delivery_count ServicebusSubscription#max_delivery_count}.
     *
     * @stability stable
     */
    readonly maxDeliveryCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#name ServicebusSubscription#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#namespace_name ServicebusSubscription#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#requires_session ServicebusSubscription#requires_session}.
     *
     * @stability stable
     */
    readonly requiresSession?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#resource_group_name ServicebusSubscription#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#status ServicebusSubscription#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#topic_name ServicebusSubscription#topic_name}.
     *
     * @stability stable
     */
    readonly topicName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#timeouts ServicebusSubscription#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServicebusSubscriptionTimeouts;
}
/**
 * @stability stable
 */
export interface ServicebusSubscriptionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#create ServicebusSubscription#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#delete ServicebusSubscription#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#read ServicebusSubscription#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html#update ServicebusSubscription#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function servicebusSubscriptionTimeoutsToTerraform(struct?: ServicebusSubscriptionTimeoutsOutputReference | ServicebusSubscriptionTimeouts): any;
/**
 * @stability stable
 */
export declare class ServicebusSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServicebusSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServicebusSubscriptionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html azurerm_servicebus_subscription}.
 *
 * @stability stable
 */
export declare class ServicebusSubscription extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription.html azurerm_servicebus_subscription} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServicebusSubscriptionConfig);
    private _autoDeleteOnIdle?;
    /**
     * @stability stable
     */
    get autoDeleteOnIdle(): string;
    /**
     * @stability stable
     */
    set autoDeleteOnIdle(value: string);
    /**
     * @stability stable
     */
    resetAutoDeleteOnIdle(): void;
    /**
     * @stability stable
     */
    get autoDeleteOnIdleInput(): string | undefined;
    private _deadLetteringOnFilterEvaluationError?;
    /**
     * @stability stable
     */
    get deadLetteringOnFilterEvaluationError(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deadLetteringOnFilterEvaluationError(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeadLetteringOnFilterEvaluationError(): void;
    /**
     * @stability stable
     */
    get deadLetteringOnFilterEvaluationErrorInput(): boolean | cdktf.IResolvable | undefined;
    private _deadLetteringOnMessageExpiration?;
    /**
     * @stability stable
     */
    get deadLetteringOnMessageExpiration(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deadLetteringOnMessageExpiration(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeadLetteringOnMessageExpiration(): void;
    /**
     * @stability stable
     */
    get deadLetteringOnMessageExpirationInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultMessageTtl?;
    /**
     * @stability stable
     */
    get defaultMessageTtl(): string;
    /**
     * @stability stable
     */
    set defaultMessageTtl(value: string);
    /**
     * @stability stable
     */
    resetDefaultMessageTtl(): void;
    /**
     * @stability stable
     */
    get defaultMessageTtlInput(): string | undefined;
    private _enableBatchedOperations?;
    /**
     * @stability stable
     */
    get enableBatchedOperations(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableBatchedOperations(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableBatchedOperations(): void;
    /**
     * @stability stable
     */
    get enableBatchedOperationsInput(): boolean | cdktf.IResolvable | undefined;
    private _forwardDeadLetteredMessagesTo?;
    /**
     * @stability stable
     */
    get forwardDeadLetteredMessagesTo(): string;
    /**
     * @stability stable
     */
    set forwardDeadLetteredMessagesTo(value: string);
    /**
     * @stability stable
     */
    resetForwardDeadLetteredMessagesTo(): void;
    /**
     * @stability stable
     */
    get forwardDeadLetteredMessagesToInput(): string | undefined;
    private _forwardTo?;
    /**
     * @stability stable
     */
    get forwardTo(): string;
    /**
     * @stability stable
     */
    set forwardTo(value: string);
    /**
     * @stability stable
     */
    resetForwardTo(): void;
    /**
     * @stability stable
     */
    get forwardToInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _lockDuration?;
    /**
     * @stability stable
     */
    get lockDuration(): string;
    /**
     * @stability stable
     */
    set lockDuration(value: string);
    /**
     * @stability stable
     */
    resetLockDuration(): void;
    /**
     * @stability stable
     */
    get lockDurationInput(): string | undefined;
    private _maxDeliveryCount?;
    /**
     * @stability stable
     */
    get maxDeliveryCount(): number;
    /**
     * @stability stable
     */
    set maxDeliveryCount(value: number);
    /**
     * @stability stable
     */
    get maxDeliveryCountInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    private _requiresSession?;
    /**
     * @stability stable
     */
    get requiresSession(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requiresSession(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequiresSession(): void;
    /**
     * @stability stable
     */
    get requiresSessionInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _topicName?;
    /**
     * @stability stable
     */
    get topicName(): string;
    /**
     * @stability stable
     */
    set topicName(value: string);
    /**
     * @stability stable
     */
    get topicNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ServicebusSubscriptionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ServicebusSubscriptionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServicebusSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
