# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_fitz')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_fitz')
    _fitz = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_fitz', [dirname(__file__)])
        except ImportError:
            import _fitz
            return _fitz
        try:
            _mod = imp.load_module('_fitz', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _fitz = swig_import_helper()
    del swig_import_helper
else:
    import _fitz
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0


import weakref
from binascii import hexlify
import sys


VersionFitz = "1.11"
VersionBind = "1.11.2"
VersionDate = "2017-11-27 14:19:07"
version = (VersionBind, VersionFitz, "20171127141907")


#------------------------------------------------------------------------------
# link kinds and link flags
#------------------------------------------------------------------------------
LINK_NONE   = 0
LINK_GOTO   = 1
LINK_URI    = 2
LINK_LAUNCH = 3
LINK_NAMED  = 4
LINK_GOTOR  = 5
LINK_FLAG_L_VALID = 1
LINK_FLAG_T_VALID = 2
LINK_FLAG_R_VALID = 4
LINK_FLAG_B_VALID = 8
LINK_FLAG_FIT_H = 16
LINK_FLAG_FIT_V = 32
LINK_FLAG_R_IS_ZOOM = 64

#------------------------------------------------------------------------------
# Text alignment and output flags
#------------------------------------------------------------------------------
TEXT_ALIGN_LEFT     = 0
TEXT_ALIGN_CENTER   = 1
TEXT_ALIGN_RIGHT    = 2
TEXT_ALIGN_JUSTIFY  = 3
TEXT_OUTPUT_TEXT    = 0
TEXT_OUTPUT_HTML    = 1
TEXT_OUTPUT_JSON    = 2
TEXT_OUTPUT_XML     = 3

#------------------------------------------------------------------------------
# Base 14 font names
#------------------------------------------------------------------------------

Base14_fontnames = ("Courier", "Courier-Oblique", "Courier-Bold",
    "Courier-BoldOblique", "Helvetica", "Helvetica-Oblique",
    "Helvetica-Bold", "Helvetica-BoldOblique",
    "Times-Roman", "Times-Italic", "Times-Bold",
    "Times-BoldItalic", "Symbol", "ZapfDingbats")

#------------------------------------------------------------------------------
# Emulate old linkDest class
#------------------------------------------------------------------------------
class linkDest():
    '''link or outline destination details'''
    def __init__(self, obj):
        self.dest = ""
        self.fileSpec = ""
        self.flags = 0
        self.isMap = False
        self.isUri = False
        self.kind = LINK_NONE
        self.lt = Point(0, 0)
        self.named = ""
        self.newWindow = ""
        self.page = obj.page
        self.rb = Point(0, 0)
        self.uri = obj.uri
        if obj.isExternal:
            self.page = -1
            self.kind = LINK_URI
        if not self.uri:
            self.page = -1
            self.kind = LINK_NONE
        if not obj.isExternal and self.uri:
            if self.uri.startswith("#"):
                self.named = ""
                self.kind = LINK_GOTO
                ftab = self.uri[1:].split(",")
                if len(ftab) == 3:
                    self.page = int(ftab[0]) - 1
                    self.lt = Point(float(ftab[1]), float(ftab[2]))
                    self.flags = self.flags | LINK_FLAG_L_VALID | LINK_FLAG_T_VALID
                else:
                    try:
                        self.page = int(ftab[0]) - 1
                    except:
                        self.kind = LINK_NAMED
                        self.named = self.uri[1:]
            else:
                self.kind = LINK_NAMED
                self.named = self.uri
        if obj.isExternal:
            if self.uri.startswith(("http://", "https://", "mailto:", "ftp://")):
                self.isUri = True
                self.kind = LINK_URI
            elif self.uri.startswith("file://"):
                self.fileSpec = self.uri[7:]
                self.isUri = False
                self.uri = ""
                self.kind = LINK_LAUNCH
                ftab = self.fileSpec.split("#")
                if len(ftab) == 2:
                    self.kind = LINK_GOTOR
                    self.fileSpec = ftab[0]
                    if ftab[1].startswith("page="):
                        self.page = int(ftab[1][5:]) - 1    
                    else:
                        self.page = -1
                        self.dest = ftab[1]
            else:
                self.isUri = True
                self.kind = LINK_LAUNCH

#-------------------------------------------------------------------------------
# "Now" timestamp in PDF Format
#-------------------------------------------------------------------------------
def getPDFnow():
    import time
    tz = "%s'%s'" % (str(time.timezone // 3600).rjust(2, "0"),
                 str((time.timezone // 60)%60).rjust(2, "0"))
    tstamp = time.strftime("D:%Y%m%d%H%M%S", time.localtime())
    if time.timezone > 0:
        tstamp += "-" + tz
    elif time.timezone < 0:
        tstamp = "+" + tz
    else:
        pass
    return tstamp

#-------------------------------------------------------------------------------
# Return a PDF string depending on its coding.
# If only ascii then "(original)" is returned,
# else if only 8 bit chars then "(original)" with interspersed octal strings
# \nnn is returned,
# else a string "<FEFF[hexstring]>" is returned, where [hexstring] is the
# UTF-16BE encoding of the original.
#-------------------------------------------------------------------------------
def getPDFstr(s, brackets = True):
    if s is None or s == "":
        return "()" if brackets else ""

    x = s

    utf16 = False
# following returns ascii original string with mixed-in 
# octal numbers \nnn if <= chr(255)
    r = ""
    for i in range(len(x)):
        if ord(x[i]) > 255:
            utf16 = True
            break
        if not brackets:
            r += x[i]
            continue
        if ord(x[i]) > 127:
            r += "\\" + oct(ord(x[i]))[-3:]
        else:
            r += x[i]

    if not utf16:
        return "(" + r + ")" if brackets else r

# require full unicode: make a UTF-16BE hex string with BOM "feff"
    r = hexlify(bytearray([254, 255]) + bytearray(x, "UTF-16BE"))
# r is 'bytes', so turn to 'str' if Python 3
    t = r if str is bytes else r.decode()
    return "<" + t + ">"                         # brackets indicate hex

#===============================================================================
# Return a PDF string suitable for the TJ operator enclosed in "[]" brackets.
# The input string is converted to either 2 or 4 hex digits per character.
# If no glyphs are supplied, then a simple font is assumed and each character
# taken directly.
# Otherwise a char's glyph is taken and 4 hex digits per char are put out.
#===============================================================================
def getTJstr(text, glyphs):
    if text.startswith("[<") and text.endswith(">]"): # already done
        return text
    if not bool(text):
        return "[<>]"
    if glyphs is None:            # this is a simple font
        otxt = "".join([hex(ord(c))[2:].rjust(2, "0") if ord(c)<256 else "3f" for c in text])
        return "[<" + otxt + ">]"
# this is not a simple font -> take the glyphs of a character
    otxt = "".join([hex(glyphs[ord(c)][0])[2:].rjust(4, "0") for c in text])
    return "[<" + otxt + ">]"

'''
Information taken from the following web sites:
www.din-formate.de
www.din-formate.info/amerikanische-formate.html
www.directtools.de/wissen/normen/iso.htm
'''
paperSizes = {                     # known paper formats @ 72 dpi
        'a0': (2384, 3370),
        'a1': (1684, 2384),
        'a10': (74, 105),
        'a2': (1191, 1684),
        'a3': (842, 1191),
        'a4': (595, 842),
        'a5': (420, 595),
        'a6': (298, 420),
        'a7': (210, 298),
        'a8': (147, 210),
        'a9': (105, 147),
        'b0': (2835, 4008),
        'b1': (2004, 2835),
        'b10': (88, 125),
        'b2': (1417, 2004),
        'b3': (1001, 1417),
        'b4': (709, 1001),
        'b5': (499, 709),
        'b6': (354, 499),
        'b7': (249, 354),
        'b8': (176, 249),
        'b9': (125, 176),
        'c0': (2599, 3677),
        'c1': (1837, 2599),
        'c10': (79, 113),
        'c2': (1298, 1837),
        'c3': (918, 1298),
        'c4': (649, 918),
        'c5': (459, 649),
        'c6': (323, 459),
        'c7': (230, 323),
        'c8': (162, 230),
        'c9': (113, 162),
        'card-4x6': (288, 432),
        'card-5x7': (360, 504),
        'commercial': (297, 684),
        'executive': (522, 756),
        'invoice': (396, 612),
        'ledger': (792, 1224),
        'legal': (612, 1008),
        'legal-13': (612, 936),
        'letter': (612, 792),
        'monarch': (279, 540),
        'tabloid-extra': (864, 1296),
        }
def PaperSize(s):
    """Return a tuple (width, height) for a given paper format string. 'A4-L' will
    return (842, 595), the values for A4 landscape. Suffix '-P' and no suffix
    returns portrait."""
    size = s.lower()
    f = "p"
    if size.endswith("-l"):
        f = "l"
        size = size[:-2]
    if size.endswith("-p"):
        size = size[:-2]
    rc = paperSizes.get(size, (-1, -1))
    if f == "p":
        return rc
    return (rc[1], rc[0])

def CheckParent(o):
    if not hasattr(o, "parent") or o.parent is None:
        raise ValueError("orphaned object: parent is None") 

def CheckColor(c):
    if c is not None:
        if type(c) not in (list, tuple) or len(c) != 3 or \
            min(c) < 0 or max(c) > 1:
            raise ValueError("need 3 color components in range 0 to 1")

def CheckMorph(o):
    if not bool(o): return False
    if not (type(o) in (list, tuple) and len(o) == 2):
        raise ValueError("morph must be a sequence of length 2")
    if not (type(o[0]) == Point and issubclass(type(o[1]), Matrix)):
        raise ValueError("invalid morph parameter")
    if not o[1].e == o[1].f == 0:
        raise ValueError("invalid morph parameter")
    return True

def CheckFont(page, fontname):
    """Return an entry in the page's font list if reference name matches.
    """
    fl = page.getFontList()
    refname = None
    for f in fl:
        if f[4] == fontname:
            refname = f
            break
    return refname

def CheckFontInfo(doc, xref):
    """Return a font info if present in the document.
    """
    fi = None
    for f in doc.FontInfos:
        if xref == f[0]:
            fi = f
            break
    return fi

def UpdateFontInfo(doc, info):
    xref = info[0]
    found = False
    for i, fi in enumerate(doc.FontInfos):
        if fi[0] == xref:
            found = True
            break
    if found:
        doc.FontInfos[i] = info
    else:
        doc.FontInfos.append(info)


class Document(_object):
    """open() - new empty PDF
open('pdf', stream) - 'stream': bytes/bytearray
open(filename)"""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Document, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Document, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _fitz.delete_Document
    __del__ = lambda self: None

    def __init__(self, filename=None, stream=None):
        """__init__(self, filename=None, stream=None) -> Document"""

        if not filename or type(filename) == str:
            pass
        elif type(filename) == unicode:
            filename = filename.encode('utf8')
        else:
            raise TypeError("filename must be string or None")
        self.name = filename if filename else ""
        self.streamlen = len(stream) if stream else 0
        if stream and not filename:
            raise ValueError("filetype missing with stream specified")
        self.isClosed    = 0
        self.isEncrypted = 0
        self.metadata    = None
        self.openErrCode = 0
        self.openErrMsg  = ''
        self.FontInfos   = []
        self._page_refs  = weakref.WeakValueDictionary()

        this = _fitz.new_Document(filename, stream)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if this:
            self.openErrCode = self._getGCTXerrcode()
            self.openErrMsg  = self._getGCTXerrmsg()
            self.thisown = True
            if self.needsPass:
                self.isEncrypted = 1
            else: # we won't init until doc is decrypted
                self.initData()
        else:
            self.thisown = False




    def close(self):
        """close(self)"""

        if self.isClosed:
            raise ValueError("operation illegal for closed doc")
        if hasattr(self, '_outline') and self._outline:
            self._dropOutline(self._outline)
            self._outline = None
        self._reset_page_refs()
        self.metadata    = None
        self.isClosed    = 1
        self.openErrCode = 0
        self.openErrMsg  = ''
        self.FontInfos   = []


        val = _fitz.Document_close(self)
        self.thisown = False

        return val


    def loadPage(self, number=0):
        """loadPage(self, number=0) -> Page"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        val = _fitz.Document_loadPage(self, number)

        if val:
            val.thisown = True
            val.parent = weakref.proxy(self)
            pageCount = self.pageCount
            n = number
            while n < 0: n += pageCount
            val.number = n
            self._page_refs[id(val)] = val
            val._annot_refs = weakref.WeakValueDictionary()


        return val


    def _loadOutline(self):
        """_loadOutline(self) -> Outline"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__loadOutline(self)


    def _dropOutline(self, ol):
        """_dropOutline(self, ol)"""
        return _fitz.Document__dropOutline(self, ol)

    @property

    def embeddedFileCount(self):
        """Return number of embedded files."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_embeddedFileCount(self)


    def embeddedFileDel(self, name):
        """Delete embedded file by name."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_embeddedFileDel(self, name)


    def embeddedFileInfo(self, id):
        """Retrieve embedded file information given its entry number or name."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_embeddedFileInfo(self, id)


    def embeddedFileSetInfo(self, id, filename=None, desc=None):
        """Change filename or description of embedded file given its entry number or name."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_embeddedFileSetInfo(self, id, filename, desc)


    def embeddedFileGet(self, id):
        """Retrieve embedded file content given its entry number or name."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_embeddedFileGet(self, id)


    def embeddedFileAdd(self, buffer, name, filename=None, desc=None):
        """Add new file from buffer."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_embeddedFileAdd(self, buffer, name, filename, desc)

    @property

    def pageCount(self):
        """pageCount(self) -> int"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_pageCount(self)


    def _getMetadata(self, key):
        """_getMetadata(self, key) -> char *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getMetadata(self, key)

    @property

    def needsPass(self):
        """needsPass(self) -> int"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_needsPass(self)

    @property

    def isPDF(self):
        """isPDF(self) -> PyObject *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_isPDF(self)


    def _getGCTXerrcode(self):
        """_getGCTXerrcode(self) -> int"""
        return _fitz.Document__getGCTXerrcode(self)


    def _getGCTXerrmsg(self):
        """_getGCTXerrmsg(self) -> char *"""
        return _fitz.Document__getGCTXerrmsg(self)


    def authenticate(self, arg2):
        """Decrypt document with a password."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        val = _fitz.Document_authenticate(self, arg2)

        if val: # the doc is decrypted successfully and we init the outline
            self.isEncrypted = 0
            self.initData()
            self.thisown = True


        return val


    def save(self, filename, garbage=0, clean=0, deflate=0, incremental=0, ascii=0, expand=0, linear=0):
        """save(self, filename, garbage=0, clean=0, deflate=0, incremental=0, ascii=0, expand=0, linear=0) -> int"""

        if self.isClosed:
            raise ValueError("operation illegal for closed doc")
        if type(filename) == str:
            pass
        elif type(filename) == unicode:
            filename = filename.encode('utf8')
        else:
            raise TypeError("filename must be a string")
        if filename == self.name and not incremental:
            raise ValueError("save to original requires incremental")
        if incremental and (self.name != filename or self.streamlen > 0):
            raise ValueError("incremental save needs original file")


        return _fitz.Document_save(self, filename, garbage, clean, deflate, incremental, ascii, expand, linear)


    def write(self, garbage=0, clean=0, deflate=0, ascii=0, expand=0, linear=0):
        """Write document to a bytes object."""

        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_write(self, garbage, clean, deflate, ascii, expand, linear)


    def insertPDF(self, docsrc, from_page=-1, to_page=-1, start_at=-1, rotate=-1, links=1):
        """Copy page range ['from', 'to'] of source PDF, starting as page number 'start_at'."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")
        if id(self) == id(docsrc):
            raise ValueError("source must not equal target PDF")
        sa = start_at
        if sa < 0:
            sa = self.pageCount

        val = _fitz.Document_insertPDF(self, docsrc, from_page, to_page, start_at, rotate, links)
        if val == 0:
            self._reset_page_refs()
            if links:
                self._do_links(docsrc, from_page = from_page, to_page = to_page,
                           start_at = sa)

        return val


    def deletePage(self, pno):
        """Delete page 'pno'."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        val = _fitz.Document_deletePage(self, pno)
        if val == 0: self._reset_page_refs()

        return val


    def deletePageRange(self, from_page=-1, to_page=-1):
        """Delete pages 'from' to 'to'."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        val = _fitz.Document_deletePageRange(self, from_page, to_page)
        if val == 0: self._reset_page_refs()

        return val


    def copyPage(self, pno, to=-1):
        """Copy a page in front of 'to'."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        val = _fitz.Document_copyPage(self, pno, to)
        if val == 0: self._reset_page_refs()

        return val


    def insertPage(self, pno=-1, text=None, fontsize=11, width=595, height=842, idx=0, fontname=None, fontfile=None, set_simple=0, color=None):
        """Insert a new page in front of 'pno'. Use arguments 'width', 'height' to specify a non-default page size, and optionally text insertion arguments."""

        if self.isClosed:
            raise ValueError("operation illegal for closed doc")
        if bool(text):
            CheckColor(color)
            if fontname and fontname[0] == "/":
                raise ValueError("invalid font reference")


        val = _fitz.Document_insertPage(self, pno, text, fontsize, width, height, idx, fontname, fontfile, set_simple, color)

        if val < 0: return val
        self._reset_page_refs()
        if not bool(text): return val
        page = self.loadPage(pno)
        val = page.insertText(Point(50, 72), text, fontsize = fontsize,
                              fontname = fontname, fontfile = fontfile,
                              color = color, idx = idx, set_simple = set_simple)


        return val


    def movePage(self, pno, to=-1):
        """Move page in front of 'to'."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        val = _fitz.Document_movePage(self, pno, to)
        if val == 0: self._reset_page_refs()

        return val


    def select(self, pyliste):
        """Build sub-pdf with page numbers in 'list'."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        val = _fitz.Document_select(self, pyliste)
        if val == 0:
            self._reset_page_refs()
            self.initData()

        return val

    @property

    def permissions(self):
        """Get permissions dictionary."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_permissions(self)


    def _getCharWidths(self, xref=0, idx=0, limit=256, cwlist=None):
        """Return list of glyphs and glyph widths of a font."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getCharWidths(self, xref, idx, limit, cwlist)


    def _getPageObjNumber(self, pno):
        """_getPageObjNumber(self, pno) -> PyObject *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getPageObjNumber(self, pno)


    def getPageImageList(self, pno):
        """List images used on a page."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_getPageImageList(self, pno)


    def getPageFontList(self, pno):
        """List fonts used on a page."""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_getPageFontList(self, pno)


    def extractFont(self, xref=0, info_only=0):
        """extractFont(self, xref=0, info_only=0) -> PyObject *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document_extractFont(self, xref, info_only)


    def _delToC(self):
        """_delToC(self) -> PyObject *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        val = _fitz.Document__delToC(self)
        self.initData()

        return val


    def _getOLRootNumber(self):
        """_getOLRootNumber(self) -> int"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getOLRootNumber(self)


    def _getNewXref(self):
        """_getNewXref(self) -> int"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getNewXref(self)


    def _getXrefLength(self):
        """_getXrefLength(self) -> int"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getXrefLength(self)


    def _getPageRectText(self, pno, rect):
        """_getPageRectText(self, pno, rect) -> char const *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getPageRectText(self, pno, rect)


    def _getXmlMetadataXref(self):
        """_getXmlMetadataXref(self) -> int"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getXmlMetadataXref(self)


    def _delXmlMetadata(self):
        """_delXmlMetadata(self) -> int"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__delXmlMetadata(self)


    def _getObjectString(self, xref):
        """_getObjectString(self, xref) -> char const *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getObjectString(self, xref)

    _getXrefString = _getObjectString

    def _getXrefStream(self, xref):
        """_getXrefStream(self, xref) -> PyObject *"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__getXrefStream(self, xref)


    def _updateObject(self, xref, text, page=None):
        """_updateObject(self, xref, text, page=None) -> int"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__updateObject(self, xref, text, page)


    def _updateStream(self, xref=0, stream=None):
        """_updateStream(self, xref=0, stream=None) -> int"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__updateStream(self, xref, stream)


    def _setMetadata(self, text):
        """_setMetadata(self, text) -> int"""
        if self.isClosed:
            raise ValueError("operation illegal for closed doc")

        return _fitz.Document__setMetadata(self, text)


    def initData(self):
        if self.isEncrypted:
            raise ValueError("cannot initData - document still encrypted")
        self._outline = self._loadOutline()
        self.metadata = dict([(k,self._getMetadata(v)) for k,v in {'format':'format', 'title':'info:Title', 'author':'info:Author','subject':'info:Subject', 'keywords':'info:Keywords','creator':'info:Creator', 'producer':'info:Producer', 'creationDate':'info:CreationDate', 'modDate':'info:ModDate'}.items()])
        self.metadata['encryption'] = None if self._getMetadata('encryption')=='None' else self._getMetadata('encryption')

    outline = property(lambda self: self._outline)
    _getPageXref = _getPageObjNumber

    def saveIncr(self):
        """ Save PDF incrementally"""
        return self.save(self.name, incremental = True)

    def __repr__(self):
        if self.streamlen == 0:
            if self.name == "":
                return "fitz.Document(<new PDF>)"
            return "fitz.Document('%s')" % (self.name,)
        return "fitz.Document('%s', <memory>)" % (self.name,)

    def __getitem__(self, i=0):
        if i >= len(self):
            raise IndexError("page number(s) out of range")
        return self.loadPage(i)

    def __len__(self):
        return self.pageCount

    def _forget_page(self, page):
        """Remove a page from document page dict."""
        pid = id(page)
        if pid in self._page_refs:
            self._page_refs[pid] = None

    def _reset_page_refs(self):
        """Invalidate all pages in document dictionary."""
        for page in self._page_refs.values():
            if page:
                page._erase()
        self._page_refs.clear()

    def __del__(self):
        self._reset_page_refs()
        if hasattr(self, "this") and self.thisown:
            self.thisown = False
            self.__swig_destroy__(self)

Document_swigregister = _fitz.Document_swigregister
Document_swigregister(Document)

class Page(_object):
    """Proxy of C fz_page_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Page, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Page, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _fitz.delete_Page
    __del__ = lambda self: None

    def bound(self):
        """bound(self) -> Rect"""
        CheckParent(self)

        val = _fitz.Page_bound(self)

        if val:
            val.thisown = True


        return val

    rect = property(bound, doc="Rect (mediabox) of the page")

    def run(self, dw, m):
        """run(self, dw, m) -> int"""
        CheckParent(self)

        return _fitz.Page_run(self, dw, m)


    def getDisplayList(self):
        """getDisplayList(self) -> DisplayList"""
        CheckParent(self)

        return _fitz.Page_getDisplayList(self)


    def loadLinks(self):
        """loadLinks(self) -> Link"""
        CheckParent(self)

        val = _fitz.Page_loadLinks(self)
        if val:
            val.thisown = True
            val.parent = weakref.proxy(self) # owning page object
            self._annot_refs[id(val)] = val

        return val

    firstLink = property(loadLinks)
    @property

    def firstAnnot(self):
        """firstAnnot points to first annot on page"""
        CheckParent(self)

        val = _fitz.Page_firstAnnot(self)
        if val:
            val.thisown = True
            val.parent = weakref.proxy(self) # owning page object
            self._annot_refs[id(val)] = val

        return val


    def deleteLink(self, linkdict):
        """Delete link if PDF"""
        CheckParent(self)

        val = _fitz.Page_deleteLink(self, linkdict)
        if linkdict["xref"] == 0: return
        linkid = linkdict["id"]
        try:
            linkobj = self._annot_refs[linkid]
            linkobj._erase()
        except:
            pass


        return val


    def deleteAnnot(self, fannot):
        """Delete annot if PDF and return next one"""
        CheckParent(self)

        val = _fitz.Page_deleteAnnot(self, fannot)
        if val:
            val.thisown = True
            val.parent = weakref.proxy(self) # owning page object
            val.parent._annot_refs[id(val)] = val
        fannot._erase()


        return val

    @property

    def rotation(self):
        """Retrieve page rotation."""
        CheckParent(self)

        return _fitz.Page_rotation(self)


    def setRotation(self, rot):
        """Set page rotation to 'rot' degrees."""
        CheckParent(self)

        return _fitz.Page_setRotation(self, rot)


    def _addAnnot_FromString(self, linklist):
        """_addAnnot_FromString(self, linklist) -> int"""
        CheckParent(self)

        return _fitz.Page__addAnnot_FromString(self, linklist)


    def _getLinkXrefs(self):
        """_getLinkXrefs(self) -> PyObject *"""
        return _fitz.Page__getLinkXrefs(self)


    def _cleanContents(self):
        """_cleanContents(self) -> int"""
        CheckParent(self)

        return _fitz.Page__cleanContents(self)


    def insertImage(self, rect, filename=None, pixmap=None, overlay=1):
        """Insert a new image in a rectangle."""
        CheckParent(self)

        return _fitz.Page_insertImage(self, rect, filename, pixmap, overlay)


    def insertFont(self, fontname=None, fontfile=None, fontbuffer=None, xref=0, set_simple=0, idx=0):
        """insertFont(self, fontname=None, fontfile=None, fontbuffer=None, xref=0, set_simple=0, idx=0) -> PyObject *"""

        if not self.parent:
            raise ValueError("orphaned object: parent is None")
        f = CheckFont(self, fontname)
        if f is not None:         # drop out if fontname already in page list
            return f[0]
        if not fontname:
            fontname = "Helvetica"
        if xref > 0:
            fn, ext, fontbuffer = self.parent.extractFont(xref)
            if not fontbuffer:
                raise ValueError("xref is no valid font")


        val = _fitz.Page_insertFont(self, fontname, fontfile, fontbuffer, xref, set_simple, idx)

        if val:
            xref = val[0]
            f = CheckFont(self, fontname)
            if f is not None:
                val[1]["type"] = f[2]       # put /Subtype in font info
                val[1]["glyphs"] = None
            doc = self.parent               # now add to document font info
            fi = CheckFontInfo(doc, xref)
            if fi is None:                  # look if we are already present
                doc.FontInfos.append(val)   # no: add me to document object
            return xref


        return val


    def _getContents(self):
        """_getContents(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Page__getContents(self)


    def _getRectText(self, rect):
        """_getRectText(self, rect) -> char const *"""
        CheckParent(self)

        return _fitz.Page__getRectText(self, rect)


    def _readPageText(self, output=0):
        """_readPageText(self, output=0) -> char const *"""
        return _fitz.Page__readPageText(self, output)


    def __str__(self):
        CheckParent(self)
        x = self.parent.name
        if self.parent.streamlen > 0:
            x += " (memory)"
        if x == "":
            x = "<new PDF>"
        return "page %s of %s" % (self.number, x)

    def __repr__(self):
        CheckParent(self)
        x = self.parent.name
        if self.parent.streamlen > 0:
            x += " (memory)"
        if x == "":
            x = "<new PDF>"
        return "page %s of %s" % (self.number, x)

    def _forget_annot(self, annot):
        """Remove an annot from reference dictionary."""
        aid = id(annot)
        if aid in self._annot_refs:
            self._annot_refs[aid] = None

    def _reset_annot_refs(self):
        """Invalidate / delete all annots of this page."""
        for annot in self._annot_refs.values():
            if annot:
                annot._erase()
        self._annot_refs.clear()

    def _getXref(self):
        """Return PDF XREF number of page."""
        CheckParent(self)
        return self.parent._getPageXref(self.number)[0]

    def _erase(self):
        self._reset_annot_refs()
        try:
            self.parent._forget_page(self)
        except:
            pass
        if getattr(self, "thisown", True):
            self.__swig_destroy__(self)
        self.parent = None
        self.thisown = False
        self.number = None

    def __del__(self):
        self._erase()

    def getFontList(self):
        CheckParent(self)
        return self.parent.getPageFontList(self.number)

    def getImageList(self):
        CheckParent(self)
        return self.parent.getPageImageList(self.number)


Page_swigregister = _fitz.Page_swigregister
Page_swigregister(Page)


def _fz_transform_rect(rect, transform):
    """_fz_transform_rect(rect, transform) -> Rect"""
    return _fitz._fz_transform_rect(rect, transform)
class Rect(_object):
    """Rect() - all zeros
Rect(x0, y0, x1, y1)
Rect(top-left, x1, y1)
Rect(x0, y0, bottom-right)
Rect(top-left, bottom-right)
Rect(Rect) - copy
Rect(sequence) - from 'sequence'"""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Rect, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Rect, name)
    __repr__ = _swig_repr
    __swig_setmethods__["x0"] = _fitz.Rect_x0_set
    __swig_getmethods__["x0"] = _fitz.Rect_x0_get
    if _newclass:
        x0 = _swig_property(_fitz.Rect_x0_get, _fitz.Rect_x0_set)
    __swig_setmethods__["y0"] = _fitz.Rect_y0_set
    __swig_getmethods__["y0"] = _fitz.Rect_y0_get
    if _newclass:
        y0 = _swig_property(_fitz.Rect_y0_get, _fitz.Rect_y0_set)
    __swig_setmethods__["x1"] = _fitz.Rect_x1_set
    __swig_getmethods__["x1"] = _fitz.Rect_x1_get
    if _newclass:
        x1 = _swig_property(_fitz.Rect_x1_get, _fitz.Rect_x1_set)
    __swig_setmethods__["y1"] = _fitz.Rect_y1_set
    __swig_getmethods__["y1"] = _fitz.Rect_y1_get
    if _newclass:
        y1 = _swig_property(_fitz.Rect_y1_get, _fitz.Rect_y1_set)
    __swig_destroy__ = _fitz.delete_Rect
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(self) -> Rect
        __init__(self, s) -> Rect
        __init__(self, lt, rb) -> Rect
        __init__(self, x0, y0, rb) -> Rect
        __init__(self, lt, x1, y1) -> Rect
        __init__(self, x0, y0, x1, y1) -> Rect
        __init__(self, list) -> Rect
        """
        this = _fitz.new_Rect(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def round(self):
        """Create enclosing 'IRect'"""
        val = _fitz.Rect_round(self)
        val.thisown = True

        return val


    def includePoint(self, p):
        """Enlarge to include a 'Point' p"""
        return _fitz.Rect_includePoint(self, p)


    def intersect(self, r):
        """Shrink to intersection with another 'Rect' r"""
        return _fitz.Rect_intersect(self, r)


    def includeRect(self, r):
        """Enlarge to include another 'Rect' r"""
        return _fitz.Rect_includeRect(self, r)


    def normalize(self):
        """Make rectangle finite"""
        return _fitz.Rect_normalize(self)


    def contains(self, *args):
        """Check for containing some 'Point' or other rectangle."""
        return _fitz.Rect_contains(self, *args)

    @property

    def isEmpty(self):
        """isEmpty(self) -> PyObject *"""
        return _fitz.Rect_isEmpty(self)

    @property

    def isInfinite(self):
        """isInfinite(self) -> PyObject *"""
        return _fitz.Rect_isInfinite(self)


    def transform(self, m):
        """Transform rectangle with Matrix m."""
        _fitz._fz_transform_rect(self, m)
        return self

    @property
    def top_left(self):
        """Return the rectangle's top-left point."""
        return Point(self.x0, self.y0)

    @property
    def top_right(self):
        """Return the rectangle's top-right point."""
        return Point(self.x1, self.y0)

    @property
    def bottom_left(self):
        """Return the rectangle's bottom-left point."""
        return Point(self.x0, self.y1)

    @property
    def bottom_right(self):
        """Return the rectangle's bottom-right point."""
        return Point(self.x1, self.y1)

    def __getitem__(self, i):
        a = [self.x0, self.y0, self.x1, self.y1]
        return a[i]

    def __setitem__(self, i, v):
        if   i == 0: self.x0 = v
        elif i == 1: self.y0 = v
        elif i == 2: self.x1 = v
        elif i == 3: self.y1 = v
        else:
            raise IndexError("index out of range")
        return

    def __len__(self):
        return 4

    def __repr__(self):
        return "fitz.Rect" + str((self.x0, self.y0, self.x1, self.y1))

    irect = property(round)
    width = property(lambda self: self.x1-self.x0)
    height = property(lambda self: self.y1-self.y0)
    tl = top_left
    tr = top_right
    br = bottom_right
    bl = bottom_left


    def __del__(self):
        if getattr(self, "thisown", True):
            try:
                self.__swig_destroy__(self)
            except:
                pass
            self.thisown = False

Rect_swigregister = _fitz.Rect_swigregister
Rect_swigregister(Rect)

class IRect(_object):
    """IRect() - all zeros
IRect(x0, y0, x1, y1)
IRect(IRect) - copy
IRect(sequence) - from 'sequence'"""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, IRect, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, IRect, name)
    __repr__ = _swig_repr
    __swig_setmethods__["x0"] = _fitz.IRect_x0_set
    __swig_getmethods__["x0"] = _fitz.IRect_x0_get
    if _newclass:
        x0 = _swig_property(_fitz.IRect_x0_get, _fitz.IRect_x0_set)
    __swig_setmethods__["y0"] = _fitz.IRect_y0_set
    __swig_getmethods__["y0"] = _fitz.IRect_y0_get
    if _newclass:
        y0 = _swig_property(_fitz.IRect_y0_get, _fitz.IRect_y0_set)
    __swig_setmethods__["x1"] = _fitz.IRect_x1_set
    __swig_getmethods__["x1"] = _fitz.IRect_x1_get
    if _newclass:
        x1 = _swig_property(_fitz.IRect_x1_get, _fitz.IRect_x1_set)
    __swig_setmethods__["y1"] = _fitz.IRect_y1_set
    __swig_getmethods__["y1"] = _fitz.IRect_y1_get
    if _newclass:
        y1 = _swig_property(_fitz.IRect_y1_get, _fitz.IRect_y1_set)
    __swig_destroy__ = _fitz.delete_IRect
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(self) -> IRect
        __init__(self, s) -> IRect
        __init__(self, x0, y0, x1, y1) -> IRect
        __init__(self, list) -> IRect
        """
        this = _fitz.new_IRect(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    @property

    def isEmpty(self):
        """isEmpty(self) -> PyObject *"""
        return _fitz.IRect_isEmpty(self)

    @property

    def isInfinite(self):
        """isInfinite(self) -> PyObject *"""
        return _fitz.IRect_isInfinite(self)


    def normalize(self):
        """Make rectangle finite"""
        return _fitz.IRect_normalize(self)


    def contains(self, *args):
        """Check for containing some 'Point' or other rectangle."""
        return _fitz.IRect_contains(self, *args)


    def translate(self, xoff, yoff):
        """translate(self, xoff, yoff) -> IRect"""
        return _fitz.IRect_translate(self, xoff, yoff)


    def intersect(self, ir):
        """intersect(self, ir) -> IRect"""
        return _fitz.IRect_intersect(self, ir)


    def getRect(self):
        return Rect(self.x0, self.y0, self.x1, self.y1)

    rect = property(getRect)

    @property
    def top_left(self):
        return Point(self.x0, self.y0)

    @property
    def top_right(self):
        return Point(self.x1, self.y0)

    @property
    def bottom_left(self):
        return Point(self.x0, self.y1)

    @property
    def bottom_right(self):
        return Point(self.x1, self.y1)

    def __getitem__(self, i):
        a = [self.x0, self.y0, self.x1, self.y1]
        return a[i]

    def __setitem__(self, i, v):
        if   i == 0: self.x0 = v
        elif i == 1: self.y0 = v
        elif i == 2: self.x1 = v
        elif i == 3: self.y1 = v
        else:
            raise IndexError("index out of range")
        return

    def __len__(self):
        return 4

    def __repr__(self):
        return "fitz.IRect" + str((self.x0, self.y0, self.x1, self.y1))

    width = property(lambda self: self.x1-self.x0)
    height = property(lambda self: self.y1-self.y0)
    tl = top_left
    tr = top_right
    br = bottom_right
    bl = bottom_left


    def __del__(self):
        if getattr(self, "thisown", True):
            try:
                self.__swig_destroy__(self)
            except:
                pass
            self.thisown = False

IRect_swigregister = _fitz.IRect_swigregister
IRect_swigregister(IRect)

class Pixmap(_object):
    """Pixmap(Colorspace, width, height, samples, alpha)
Pixmap(Colorspace, Irect, alpha)
Pixmap(Colorspace, Pixmap [, alpha]) - converted copy
Pixmap(filename)
Pixmap(Pixmap) - new copy with added alpha
Pixmap(image-buffer) - from bytearray
Pixmap(Document, xref) - from PDF image in a PDF"""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Pixmap, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Pixmap, name)
    __repr__ = _swig_repr
    __swig_setmethods__["x"] = _fitz.Pixmap_x_set
    __swig_getmethods__["x"] = _fitz.Pixmap_x_get
    if _newclass:
        x = _swig_property(_fitz.Pixmap_x_get, _fitz.Pixmap_x_set)
    __swig_setmethods__["y"] = _fitz.Pixmap_y_set
    __swig_getmethods__["y"] = _fitz.Pixmap_y_get
    if _newclass:
        y = _swig_property(_fitz.Pixmap_y_get, _fitz.Pixmap_y_set)
    __swig_setmethods__["w"] = _fitz.Pixmap_w_set
    __swig_getmethods__["w"] = _fitz.Pixmap_w_get
    if _newclass:
        w = _swig_property(_fitz.Pixmap_w_get, _fitz.Pixmap_w_set)
    __swig_setmethods__["h"] = _fitz.Pixmap_h_set
    __swig_getmethods__["h"] = _fitz.Pixmap_h_get
    if _newclass:
        h = _swig_property(_fitz.Pixmap_h_get, _fitz.Pixmap_h_set)
    __swig_setmethods__["n"] = _fitz.Pixmap_n_set
    __swig_getmethods__["n"] = _fitz.Pixmap_n_get
    if _newclass:
        n = _swig_property(_fitz.Pixmap_n_get, _fitz.Pixmap_n_set)
    __swig_setmethods__["interpolate"] = _fitz.Pixmap_interpolate_set
    __swig_getmethods__["interpolate"] = _fitz.Pixmap_interpolate_get
    if _newclass:
        interpolate = _swig_property(_fitz.Pixmap_interpolate_get, _fitz.Pixmap_interpolate_set)
    __swig_setmethods__["xres"] = _fitz.Pixmap_xres_set
    __swig_getmethods__["xres"] = _fitz.Pixmap_xres_get
    if _newclass:
        xres = _swig_property(_fitz.Pixmap_xres_get, _fitz.Pixmap_xres_set)
    __swig_setmethods__["yres"] = _fitz.Pixmap_yres_set
    __swig_getmethods__["yres"] = _fitz.Pixmap_yres_get
    if _newclass:
        yres = _swig_property(_fitz.Pixmap_yres_get, _fitz.Pixmap_yres_set)
    __swig_destroy__ = _fitz.delete_Pixmap
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(self, cs, bbox, alpha=0) -> Pixmap
        __init__(self, cs, spix, alpha=1) -> Pixmap
        __init__(self, spix) -> Pixmap
        __init__(self, cs, w, h, samples, alpha=0) -> Pixmap
        __init__(self, filename) -> Pixmap
        __init__(self, imagedata) -> Pixmap
        __init__(self, doc, xref) -> Pixmap
        """
        this = _fitz.new_Pixmap(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

        if this:
            self.thisown = True
        else:
            self.thisown = False



    def gammaWith(self, gamma):
        """gammaWith(self, gamma)"""
        return _fitz.Pixmap_gammaWith(self, gamma)


    def tintWith(self, red, green, blue):
        """tintWith(self, red, green, blue)"""

        if self.colorspace.n > 3:
            raise TypeError("CMYK colorspace cannot be tinted")

        return _fitz.Pixmap_tintWith(self, red, green, blue)


    def clearWith(self, *args):
        """
        clearWith(self, value)
        clearWith(self, value, bbox)
        """
        return _fitz.Pixmap_clearWith(self, *args)


    def copyPixmap(self, src, bbox):
        """copyPixmap(self, src, bbox)"""
        return _fitz.Pixmap_copyPixmap(self, src, bbox)

    @property

    def stride(self):
        """stride(self) -> int"""
        return _fitz.Pixmap_stride(self)

    @property

    def alpha(self):
        """alpha(self) -> int"""
        return _fitz.Pixmap_alpha(self)

    @property

    def colorspace(self):
        """colorspace(self) -> Colorspace"""
        return _fitz.Pixmap_colorspace(self)

    @property

    def irect(self):
        """irect(self) -> IRect"""
        return _fitz.Pixmap_irect(self)

    @property

    def size(self):
        """size(self) -> int"""
        return _fitz.Pixmap_size(self)


    def setAlpha(self, alphavalues=None):
        """setAlpha(self, alphavalues=None) -> int"""
        return _fitz.Pixmap_setAlpha(self, alphavalues)


    def getPNGData(self, savealpha=-1):
        """getPNGData(self, savealpha=-1) -> PyObject *"""
        return _fitz.Pixmap_getPNGData(self, savealpha)


    def _writeIMG(self, filename, format, savealpha=-1):
        """_writeIMG(self, filename, format, savealpha=-1) -> int"""

        if type(filename) == str:
            pass
        elif type(filename) == unicode:
            filename = filename.encode('utf8')
        else:
            raise TypeError("filename must be a string")


        return _fitz.Pixmap__writeIMG(self, filename, format, savealpha)


    def writePNG(self, filename, savealpha = -1):
        return self._writeIMG(filename, 1, savealpha)


    def invertIRect(self, irect=None):
        """invertIRect(self, irect=None)"""
        return _fitz.Pixmap_invertIRect(self, irect)

    @property

    def samples(self):
        """samples(self) -> PyObject *"""
        return _fitz.Pixmap_samples(self)


    width  = w
    height = h

    def __len__(self):
        return self.size

    def __repr__(self):
        if self.colorspace:
            return "fitz.Pixmap(%s, %s, %s)" % (self.colorspace.name, self.irect, self.alpha)
        else:
            return "fitz.Pixmap(%s, %s, %s)" % ('None', self.irect, self.alpha)

    def __del__(self):
        if hasattr(self, "this") and self.thisown:
            self.thisown = False
            self.__swig_destroy__(self)

Pixmap_swigregister = _fitz.Pixmap_swigregister
Pixmap_swigregister(Pixmap)

CS_RGB = _fitz.CS_RGB
CS_GRAY = _fitz.CS_GRAY
CS_CMYK = _fitz.CS_CMYK
class Colorspace(_object):
    """Proxy of C fz_colorspace_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Colorspace, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Colorspace, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _fitz.delete_Colorspace
    __del__ = lambda self: None

    def __init__(self, type):
        """__init__(self, type) -> Colorspace"""
        this = _fitz.new_Colorspace(type)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    @property

    def n(self):
        """n(self) -> int"""
        return _fitz.Colorspace_n(self)

    @property

    def name(self):
        """name(self) -> char const *"""
        return _fitz.Colorspace_name(self)


    def __repr__(self):
        x = ("", "GRAY", "", "RGB", "CMYK")[self.n]
        return "fitz.Colorspace(fitz.CS_%s) - %s" % (x, self.name)

Colorspace_swigregister = _fitz.Colorspace_swigregister
Colorspace_swigregister(Colorspace)

class Device(_object):
    """Proxy of C DeviceWrapper struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Device, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Device, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(self, pm, clip) -> Device
        __init__(self, dl) -> Device
        __init__(self, ts, tp) -> Device
        """
        this = _fitz.new_Device(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fitz.delete_Device
    __del__ = lambda self: None
Device_swigregister = _fitz.Device_swigregister
Device_swigregister(Device)


def _fz_pre_scale(m, sx, sy):
    """_fz_pre_scale(m, sx, sy) -> Matrix"""
    return _fitz._fz_pre_scale(m, sx, sy)

def _fz_pre_shear(m, sx, sy):
    """_fz_pre_shear(m, sx, sy) -> Matrix"""
    return _fitz._fz_pre_shear(m, sx, sy)

def _fz_pre_rotate(m, degree):
    """_fz_pre_rotate(m, degree) -> Matrix"""
    return _fitz._fz_pre_rotate(m, degree)
class Matrix(_object):
    """Matrix() - all zeros
Matrix(a, b, c, d, e, f)
Matrix(zoom-x, zoom-y) - zoom
Matrix(shear-x, shear-y, 1) - shear
Matrix(degree) - rotate
Matrix(Matrix) - new copy
Matrix(sequence) - from 'sequence'"""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Matrix, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Matrix, name)
    __repr__ = _swig_repr
    __swig_setmethods__["a"] = _fitz.Matrix_a_set
    __swig_getmethods__["a"] = _fitz.Matrix_a_get
    if _newclass:
        a = _swig_property(_fitz.Matrix_a_get, _fitz.Matrix_a_set)
    __swig_setmethods__["b"] = _fitz.Matrix_b_set
    __swig_getmethods__["b"] = _fitz.Matrix_b_get
    if _newclass:
        b = _swig_property(_fitz.Matrix_b_get, _fitz.Matrix_b_set)
    __swig_setmethods__["c"] = _fitz.Matrix_c_set
    __swig_getmethods__["c"] = _fitz.Matrix_c_get
    if _newclass:
        c = _swig_property(_fitz.Matrix_c_get, _fitz.Matrix_c_set)
    __swig_setmethods__["d"] = _fitz.Matrix_d_set
    __swig_getmethods__["d"] = _fitz.Matrix_d_get
    if _newclass:
        d = _swig_property(_fitz.Matrix_d_get, _fitz.Matrix_d_set)
    __swig_setmethods__["e"] = _fitz.Matrix_e_set
    __swig_getmethods__["e"] = _fitz.Matrix_e_get
    if _newclass:
        e = _swig_property(_fitz.Matrix_e_get, _fitz.Matrix_e_set)
    __swig_setmethods__["f"] = _fitz.Matrix_f_set
    __swig_getmethods__["f"] = _fitz.Matrix_f_get
    if _newclass:
        f = _swig_property(_fitz.Matrix_f_get, _fitz.Matrix_f_set)
    __swig_destroy__ = _fitz.delete_Matrix
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(self) -> Matrix
        __init__(self, n) -> Matrix
        __init__(self, sx, sy, shear=0) -> Matrix
        __init__(self, r, s, t, u, v, w) -> Matrix
        __init__(self, degree) -> Matrix
        __init__(self, list) -> Matrix
        """
        this = _fitz.new_Matrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def invert(self, m):
        """invert(self, m) -> int"""
        return _fitz.Matrix_invert(self, m)


    def preTranslate(self, sx, sy):
        """preTranslate(self, sx, sy) -> Matrix"""
        return _fitz.Matrix_preTranslate(self, sx, sy)


    def concat(self, m1, m2):
        """concat(self, m1, m2) -> Matrix"""
        return _fitz.Matrix_concat(self, m1, m2)


    def preScale(self, sx, sy):
        """preScale(Matrix self, float sx, float sy) -> Matrix self updated"""
        _fitz._fz_pre_scale(self, sx, sy)
        return self
    def preShear(self, sx, sy):
        """preShear(Matrix self, float sx, float sy) -> Matrix self updated"""
        _fitz._fz_pre_shear(self, sx, sy)
        return self
    def preRotate(self, degree):
        """preRotate(Matrix self, float degree) -> Matrix self updated"""
        _fitz._fz_pre_rotate(self, degree)
        return self
    def __getitem__(self, i):
        m = [self.a, self.b, self.c, self.d, self.e, self.f]
        return m[i]

    def __setitem__(self, i, v):
        if   i == 0: self.a = v
        elif i == 1: self.b = v
        elif i == 2: self.c = v
        elif i == 3: self.d = v
        elif i == 4: self.e = v
        elif i == 5: self.f = v
        else:
            raise IndexError("index out of range")
        return

    def __len__(self):
        return 6
    def __repr__(self):
        return "fitz.Matrix(%s, %s, %s, %s, %s, %s)" % (self.a, self.b, self.c, self.d, self.e, self.f)


    def __del__(self):
        if getattr(self, "thisown", True):
            try:
                self.__swig_destroy__(self)
            except:
                pass
            self.thisown = False

Matrix_swigregister = _fitz.Matrix_swigregister
Matrix_swigregister(Matrix)

class Outline(_object):
    """Proxy of C fz_outline_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Outline, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Outline, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_getmethods__["title"] = _fitz.Outline_title_get
    if _newclass:
        title = _swig_property(_fitz.Outline_title_get)
    __swig_getmethods__["page"] = _fitz.Outline_page_get
    if _newclass:
        page = _swig_property(_fitz.Outline_page_get)
    __swig_getmethods__["next"] = _fitz.Outline_next_get
    if _newclass:
        next = _swig_property(_fitz.Outline_next_get)
    __swig_getmethods__["down"] = _fitz.Outline_down_get
    if _newclass:
        down = _swig_property(_fitz.Outline_down_get)
    __swig_getmethods__["is_open"] = _fitz.Outline_is_open_get
    if _newclass:
        is_open = _swig_property(_fitz.Outline_is_open_get)

    def saveXML(self, filename):
        """saveXML(self, filename) -> int"""

        if type(filename) == str:
            pass
        elif type(filename) == unicode:
            filename = filename.encode('utf8')
        else:
            raise TypeError("filename must be a string")


        return _fitz.Outline_saveXML(self, filename)


    def saveText(self, filename):
        """saveText(self, filename) -> int"""

        if type(filename) == str:
            pass
        elif type(filename) == unicode:
            filename = filename.encode('utf8')
        else:
            raise TypeError("filename must be a string")


        return _fitz.Outline_saveText(self, filename)

    @property

    def uri(self):
        """uri(self) -> char *"""
        return _fitz.Outline_uri(self)

    @property

    def isExternal(self):
        """isExternal(self) -> int"""
        return _fitz.Outline_isExternal(self)

    isOpen = is_open

    @property
    def dest(self):
        '''outline destination details'''
        return linkDest(self)

    __swig_destroy__ = _fitz.delete_Outline
    __del__ = lambda self: None
Outline_swigregister = _fitz.Outline_swigregister
Outline_swigregister(Outline)


def _fz_transform_point(point, transform):
    """_fz_transform_point(point, transform) -> Point"""
    return _fitz._fz_transform_point(point, transform)
class Point(_object):
    """Point() - all zeros
Point(x, y)
Point(Point) - new copy
Point(sequence) - from 'sequence'"""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Point, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Point, name)
    __repr__ = _swig_repr
    __swig_setmethods__["x"] = _fitz.Point_x_set
    __swig_getmethods__["x"] = _fitz.Point_x_get
    if _newclass:
        x = _swig_property(_fitz.Point_x_get, _fitz.Point_x_set)
    __swig_setmethods__["y"] = _fitz.Point_y_set
    __swig_getmethods__["y"] = _fitz.Point_y_get
    if _newclass:
        y = _swig_property(_fitz.Point_y_get, _fitz.Point_y_set)
    __swig_destroy__ = _fitz.delete_Point
    __del__ = lambda self: None

    def __init__(self, *args):
        """
        __init__(self) -> Point
        __init__(self, q) -> Point
        __init__(self, x, y) -> Point
        __init__(self, list) -> Point
        """
        this = _fitz.new_Point(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def distance_to(self, *args):
        """Return the distance to a rectangle or another point."""
        assert len(args) > 0, "at least one parameter must be given"
        x = args[0]
        if len(args) > 1:
            unit = args[1]
        else:
            unit = "px"
        u = {"px": (1.,1.), "in": (1.,72.), "cm": (2.54, 72.), "mm": (25.4, 72.)}
        f = u[unit][0] / u[unit][1]
        if type(x) is Point:
            return abs(self - x) * f

    # from here on, x is a rectangle
    # as a safeguard, make a finite copy of it
        r = Rect(x.top_left, x.top_left)
        r = r | x.bottom_right
        if self in r:
            return 0.0
        if self.x > r.x1:
            if self.y >= r.y1:
                return self.distance_to(r.bottom_right, unit)
            elif self.y <= r.y0:
                return self.distance_to(r.top_right, unit)
            else:
                return (self.x - r.x1) * f
        elif r.x0 <= self.x <= r.x1:
            if self.y >= r.y1:
                return (self.y - r.y1) * f
            else:
                return (r.y0 - self.y) * f
        else:
            if self.y >= r.y1:
                return self.distance_to(r.bottom_left, unit)
            elif self.y <= r.y0:
                return self.distance_to(r.top_left, unit)
            else:
                return (r.x0 - self.x) * f

    def transform(self, m):
        _fitz._fz_transform_point(self, m)
        return self

    def __getitem__(self, i):
        a = [self.x, self.y]
        return a[i]

    def __len__(self):
        return 2

    def __repr__(self):
        return "fitz.Point" + str((self.x, self.y))


    def __del__(self):
        if getattr(self, "thisown", True):
            try:
                self.__swig_destroy__(self)
            except:
                pass
            self.thisown = False

Point_swigregister = _fitz.Point_swigregister
Point_swigregister(Point)

ANNOT_TEXT = _fitz.ANNOT_TEXT
ANNOT_LINK = _fitz.ANNOT_LINK
ANNOT_FREETEXT = _fitz.ANNOT_FREETEXT
ANNOT_LINE = _fitz.ANNOT_LINE
ANNOT_SQUARE = _fitz.ANNOT_SQUARE
ANNOT_CIRCLE = _fitz.ANNOT_CIRCLE
ANNOT_POLYGON = _fitz.ANNOT_POLYGON
ANNOT_POLYLINE = _fitz.ANNOT_POLYLINE
ANNOT_HIGHLIGHT = _fitz.ANNOT_HIGHLIGHT
ANNOT_UNDERLINE = _fitz.ANNOT_UNDERLINE
ANNOT_SQUIGGLY = _fitz.ANNOT_SQUIGGLY
ANNOT_STRIKEOUT = _fitz.ANNOT_STRIKEOUT
ANNOT_STAMP = _fitz.ANNOT_STAMP
ANNOT_CARET = _fitz.ANNOT_CARET
ANNOT_INK = _fitz.ANNOT_INK
ANNOT_POPUP = _fitz.ANNOT_POPUP
ANNOT_FILEATTACHMENT = _fitz.ANNOT_FILEATTACHMENT
ANNOT_SOUND = _fitz.ANNOT_SOUND
ANNOT_MOVIE = _fitz.ANNOT_MOVIE
ANNOT_WIDGET = _fitz.ANNOT_WIDGET
ANNOT_SCREEN = _fitz.ANNOT_SCREEN
ANNOT_PRINTERMARK = _fitz.ANNOT_PRINTERMARK
ANNOT_TRAPNET = _fitz.ANNOT_TRAPNET
ANNOT_WATERMARK = _fitz.ANNOT_WATERMARK
ANNOT_3D = _fitz.ANNOT_3D
ANNOT_XF_Invisible = _fitz.ANNOT_XF_Invisible
ANNOT_XF_Hidden = _fitz.ANNOT_XF_Hidden
ANNOT_XF_Print = _fitz.ANNOT_XF_Print
ANNOT_XF_NoZoom = _fitz.ANNOT_XF_NoZoom
ANNOT_XF_NoRotate = _fitz.ANNOT_XF_NoRotate
ANNOT_XF_NoView = _fitz.ANNOT_XF_NoView
ANNOT_XF_ReadOnly = _fitz.ANNOT_XF_ReadOnly
ANNOT_XF_Locked = _fitz.ANNOT_XF_Locked
ANNOT_XF_ToggleNoView = _fitz.ANNOT_XF_ToggleNoView
ANNOT_XF_LockedContents = _fitz.ANNOT_XF_LockedContents
ANNOT_LE_None = _fitz.ANNOT_LE_None
ANNOT_LE_Square = _fitz.ANNOT_LE_Square
ANNOT_LE_Circle = _fitz.ANNOT_LE_Circle
ANNOT_LE_Diamond = _fitz.ANNOT_LE_Diamond
ANNOT_LE_OpenArrow = _fitz.ANNOT_LE_OpenArrow
ANNOT_LE_ClosedArrow = _fitz.ANNOT_LE_ClosedArrow
ANNOT_LE_Butt = _fitz.ANNOT_LE_Butt
ANNOT_LE_ROpenArrow = _fitz.ANNOT_LE_ROpenArrow
ANNOT_LE_RClosedArrow = _fitz.ANNOT_LE_RClosedArrow
ANNOT_LE_Slash = _fitz.ANNOT_LE_Slash
class Annot(_object):
    """Proxy of C fz_annot_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Annot, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Annot, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _fitz.delete_Annot
    __del__ = lambda self: None
    @property

    def rect(self):
        """rect: rectangle containing the annot"""
        CheckParent(self)

        return _fitz.Annot_rect(self)


    def _getXref(self):
        """return xref number of annotation"""
        CheckParent(self)

        return _fitz.Annot__getXref(self)


    def _getAP(self):
        """_getAP: provides operator source of the /AP"""
        CheckParent(self)

        return _fitz.Annot__getAP(self)


    def _setAP(self, ap):
        """_setAP: updates operator source of the /AP"""
        CheckParent(self)

        return _fitz.Annot__setAP(self, ap)


    def setRect(self, r):
        """setRect: changes the annot's rectangle"""
        CheckParent(self)

        return _fitz.Annot_setRect(self, r)

    @property

    def vertices(self):
        """vertices: point coordinates for various annot types"""
        CheckParent(self)

        return _fitz.Annot_vertices(self)

    @property

    def colors(self):
        """dictionary of the annot's colors"""
        CheckParent(self)

        return _fitz.Annot_colors(self)


    def setColors(self, colors):
        """
        setColors(dict)
        Changes the 'common' and 'fill' colors of an annotation. If provided, values must be lists of up to 4 floats.
        """
        CheckParent(self)

        return _fitz.Annot_setColors(self, colors)

    @property

    def lineEnds(self):
        """lineEnds(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot_lineEnds(self)


    def setLineEnds(self, start, end):
        """setLineEnds(self, start, end)"""
        CheckParent(self)

        return _fitz.Annot_setLineEnds(self, start, end)

    @property

    def type(self):
        """type(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot_type(self)


    def fileInfo(self):
        """Retrieve attached file information."""
        CheckParent(self)

        return _fitz.Annot_fileInfo(self)


    def fileGet(self):
        """Retrieve annotation attached file content."""
        CheckParent(self)

        return _fitz.Annot_fileGet(self)


    def fileUpd(self, buffer, filename=None):
        """Update annotation attached file content."""
        CheckParent(self)

        return _fitz.Annot_fileUpd(self, buffer, filename)

    @property

    def info(self):
        """info(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot_info(self)


    def setInfo(self, info):
        """setInfo(self, info) -> int"""
        CheckParent(self)

        return _fitz.Annot_setInfo(self, info)

    @property

    def border(self):
        """border(self) -> PyObject *"""
        CheckParent(self)

        return _fitz.Annot_border(self)


    def setBorder(self, border):
        """setBorder(self, border) -> int"""
        CheckParent(self)

        return _fitz.Annot_setBorder(self, border)

    @property

    def flags(self):
        """flags(self) -> int"""
        CheckParent(self)

        return _fitz.Annot_flags(self)


    def _cleanContents(self):
        """_cleanContents(self) -> int"""
        CheckParent(self)

        return _fitz.Annot__cleanContents(self)


    def setFlags(self, flags):
        """setFlags(self, flags)"""
        CheckParent(self)

        return _fitz.Annot_setFlags(self, flags)

    @property

    def next(self):
        """next(self) -> Annot"""
        CheckParent(self)

        val = _fitz.Annot_next(self)
        if val:
            val.thisown = True
            val.parent = self.parent # copy owning page object from previous annot
            val.parent._annot_refs[id(val)] = val

        return val


    def getPixmap(self, matrix=None, colorspace=None, alpha=0):
        """getPixmap(self, matrix=None, colorspace=None, alpha=0) -> Pixmap"""
        CheckParent(self)

        return _fitz.Annot_getPixmap(self, matrix, colorspace, alpha)


    def _erase(self):
        try:
            self.parent._forget_annot(self)
        except:
            pass
        if getattr(self, "thisown", True):
            self.__swig_destroy__(self)
        self.parent = None
        self.thisown = False

    def __str__(self):
        CheckParent(self)
        return "'%s' annotation on %s" % (self.type[1], str(self.parent))

    def __repr__(self):
        CheckParent(self)
        return "'%s' annotation on %s" % (self.type[1], str(self.parent))

    def __del__(self):
        self._erase()
Annot_swigregister = _fitz.Annot_swigregister
Annot_swigregister(Annot)

class Link(_object):
    """Proxy of C fz_link_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Link, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Link, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _fitz.delete_Link
    __del__ = lambda self: None
    @property

    def uri(self):
        """uri(self) -> char *"""
        CheckParent(self)

        return _fitz.Link_uri(self)

    @property

    def isExternal(self):
        """isExternal(self) -> int"""
        CheckParent(self)

        return _fitz.Link_isExternal(self)


    page = -1
    @property
    def dest(self):
        """Create link destination details."""
        if hasattr(self, "parent") and self.parent is None:
            raise ValueError("orphaned object: parent is None")
        if self.parent.parent.isClosed:
            raise ValueError("operation illegal for closed doc")
        return linkDest(self)        

    @property

    def rect(self):
        """rect(self) -> Rect"""
        CheckParent(self)

        return _fitz.Link_rect(self)

    @property

    def next(self):
        """next(self) -> Link"""
        CheckParent(self)

        val = _fitz.Link_next(self)
        if val:
            val.thisown = True
            val.parent = self.parent # copy owning page object from previous annot
            val.parent._annot_refs[id(val)] = val

        return val


    def _erase(self):
        try:
            self.parent._forget_annot(self)
        except:
            pass
        if getattr(self, "thisown", True):
            self.__swig_destroy__(self)
        self.parent = None
        self.thisown = False

    def __str__(self):
        CheckParent(self)
        return "link on " + str(self.parent)

    def __repr__(self):
        CheckParent(self)
        return "link on " + str(self.parent)

    def __del__(self):
        self._erase()
Link_swigregister = _fitz.Link_swigregister
Link_swigregister(Link)

class DisplayList(_object):
    """Proxy of C fz_display_list_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DisplayList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DisplayList, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _fitz.delete_DisplayList
    __del__ = lambda self: None

    def __init__(self, mediabox):
        """__init__(self, mediabox) -> DisplayList"""
        this = _fitz.new_DisplayList(mediabox)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def run(self, dw, m, area):
        """run(self, dw, m, area) -> int"""
        return _fitz.DisplayList_run(self, dw, m, area)

    @property

    def rect(self):
        """rect(self) -> Rect"""
        return _fitz.DisplayList_rect(self)


    def getPixmap(self, matrix=None, colorspace=None, alpha=0, clip=None):
        """getPixmap(self, matrix=None, colorspace=None, alpha=0, clip=None) -> Pixmap"""
        return _fitz.DisplayList_getPixmap(self, matrix, colorspace, alpha, clip)


    def getTextPage(self, textsheet):
        """getTextPage(self, textsheet) -> TextPage"""
        return _fitz.DisplayList_getTextPage(self, textsheet)


    def __del__(self):
        if getattr(self, "thisown", True):
            try:
                self.__swig_destroy__(self)
            except:
                pass
            self.thisown = False

DisplayList_swigregister = _fitz.DisplayList_swigregister
DisplayList_swigregister(DisplayList)

class TextSheet(_object):
    """Proxy of C fz_stext_sheet_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, TextSheet, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, TextSheet, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(self) -> TextSheet"""
        this = _fitz.new_TextSheet()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fitz.delete_TextSheet
    __del__ = lambda self: None
TextSheet_swigregister = _fitz.TextSheet_swigregister
TextSheet_swigregister(TextSheet)

class TextPage(_object):
    """Proxy of C fz_stext_page_s struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, TextPage, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, TextPage, name)
    __repr__ = _swig_repr
    __swig_setmethods__["len"] = _fitz.TextPage_len_set
    __swig_getmethods__["len"] = _fitz.TextPage_len_get
    if _newclass:
        len = _swig_property(_fitz.TextPage_len_get, _fitz.TextPage_len_set)

    def __init__(self, mediabox):
        """__init__(self, mediabox) -> TextPage"""
        this = _fitz.new_TextPage(mediabox)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _fitz.delete_TextPage
    __del__ = lambda self: None

    def search(self, needle, hit_max=16):
        """search(self, needle, hit_max=16) -> Rect"""
        return _fitz.TextPage_search(self, needle, hit_max)


    def extractText(self):
        """extractText(self) -> char const *"""
        return _fitz.TextPage_extractText(self)


    def extractHTML(self):
        """extractHTML(self) -> char const *"""
        return _fitz.TextPage_extractHTML(self)


    def extractJSON(self):
        """extractJSON(self) -> char const *"""
        return _fitz.TextPage_extractJSON(self)


    def extractXML(self):
        """extractXML(self) -> char const *"""
        return _fitz.TextPage_extractXML(self)

TextPage_swigregister = _fitz.TextPage_swigregister
TextPage_swigregister(TextPage)

# This file is compatible with both classic and new-style classes.


