#! /usr/bin/python3

r'''###############################################################################
###################################################################################
#
#
#	Syllables Search
#	Version 0.5
#
# PLEASE NOTE THAT THIS IS A WORK IN PROGRESS
# CHECK BACK FOR UPDATES SOON
#
#	Based upon a source-code @ Koziev:
# https://github.com/Koziev/rusyllab and upon
# a source code @ prosegrinder: 
# https://github.com/prosegrinder/python-syllables
#
# Original TXT English Syllables list is courtesy of
# Chris Barker http://ling.ucsd.edu/~barker
# 
#	Project Los Angeles
#	Tegridy Code 2021
#
# https://github.com/Tegridy-Code/Project-Los-Angeles
#
#
###################################################################################
###################################################################################
#       Copyright 2021 Project Los Angeles / Tegridy Code
#
#       Licensed under the Apache License, Version 2.0 (the "License");
#       you may not use this file except in compliance with the License.
#       You may obtain a copy of the License at
#
#           http://www.apache.org/licenses/LICENSE-2.0
#
#       Unless required by applicable law or agreed to in writing, software
#       distributed under the License is distributed on an "AS IS" BASIS,
#       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#       See the License for the specific language governing permissions and
#       limitations under the License.
###################################################################################
###################################################################################'''

########################################################
#
# Critical dependencies/requirements:
#
import pkg_resources
import re
import tqdm
#
########################################################

print('Loading SyllablesSearch Module...')

########################################################

def Lyric_Syllables_Processor(input_lyrics='some great lyrics'):

    '''
    Input: Lyrics as a TXT string in any format

    Output: All encoded words as a TXT string separated by spaces

            Encoded words syllables as a TXT string, where: 
            1 == syllable, 2 == break between words, 3 == break between the lines
            This allows to have a two-bytes-per-token encoding

            Encoded syllables byte-pairs count (aka encoding tokens count)
       
    Project Los Angeles
    Tegridy Code 2021'''

    if len(input_lyrics) == 0 or input_lyrics == None:
      return ' ', 3, 0

    data = load_syllables_dictionary()

    words = [y[0].lower() for y in data[1:]]
    letters_count = [len(y[0]) for y in data[1:]]
    syls_bytes = [y[1] for y in data[1:]]
    syls_count = [y[2] for y in data[1:]]

    txt = input_lyrics.split(chr(10))

    clean_txt = []
    for i in range(len(txt)):
      if len([clean_text(txt[i].lower())]) != 0:
        clean_txt.extend([clean_text(txt[i].lower())])

    all_words = []

    for c in clean_txt:
      if len(c) != 0:
        all_words.extend(c.split(chr(32)))

    out = '3'
    out1 = []
    wout1 = ''
    kbd = False

    for c in tqdm.tqdm(clean_txt):
      try:
        if len(c) != 0:
          for w in c.replace(chr(10), chr(32)).split(chr(32)):
            try:
              idx = words.index(w.lower())
              out1.append([words[idx], letters_count[idx], syls_bytes[idx], syls_count[idx]])
            
            except KeyboardInterrupt:
              kbd = True
              break
            
            except:
              if len(w.lower()) != 0:
                out1.append([w.lower(), len(w.lower()), word2bits(w.lower()), str(word2bits(w.lower())).count('1')])
              continue
        
        syls_bytes_str = ''.join([('2' + str(y[2])) for y in out1]) # 2 == words break
        out += (syls_bytes_str + '3') # 3 == lines break
        wout1 += ' '.join([y[0] for y in out1]) + chr(32)
        out1 = []

        if kbd == True:
          break

      except KeyboardInterrupt:
        break

    return wout1, out, len(out)

########################################################

# -*- coding: utf-8 -*-

# autogenerated 2019-01-19 10:52:09.746954

def V(c):
    return c in u"AEIOUaeiou"


def C(c):
    return c in u"BCDFGHJKLMNPQRSTVWXYZbcdfghjklmnpqrstvwxyz"


def S(c):
    return c in u"Yy"


def M(c):
    return c in u"ЪЬъь"


def BEG(c):
    return c == u"["


def END(c):
    return c == u"]"


def split(s):
    cur_pos = 0
    items = list(u"[" + s + u"]")
    while cur_pos < len(items):
        input_context = items[cur_pos:]
        res = apply1(input_context)
        if res is None:
            cur_pos += 1
        else:
            items = items[:cur_pos] + res[0] + input_context[res[1]:]
            cur_pos += res[2]
    return items[1:-1]


def apply1(s):
        if C(s[0]):
            if V(s[1]):
                if C(s[2]):
                    if V(s[3]):
                        return ([s[0]+s[1], s[2], s[3]], 4, 1)  # SYLLABER_1

                    if C(s[3]):
                        if V(s[4]):
                            return ([s[0]+s[1]+s[2], s[3], s[4]], 5, 1)  # SYLLABER_5

                        if C(s[4]):
                            if C(s[5]):
                                if END(s[6]):
                                    return ([s[0]+s[1]+s[2]+s[3]+s[4]+s[5], s[6]], 7, 1)  # SYLLABER_11

                                if not END(s[6]):
                                    return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5], s[6]], 7, 1)  # SYLLABER_12


                            if V(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3], s[4], s[5]], 6, 1)  # SYLLABER_36

                            if END(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5]], 6, 1)  # SYLLABER_120

                            if M(s[5]):
                                if END(s[6]):
                                    return ([s[0]+s[1]+s[2]+s[3]+s[4]+s[5], s[6]], 7, 1)  # SYLLABER_330



                        if END(s[4]):
                            return ([s[0]+s[1]+s[2]+s[3], s[4]], 5, 1)  # SYLLABER_52

                        if M(s[4]):
                            if END(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5]], 6, 1)  # SYLLABER_76

                            if C(s[5]):
                                if V(s[6]):
                                    return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5], s[6]], 7, 1)  # SYLLABER_250


                            if V(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5]], 6, 1)  # SYLLABER_260



                    if END(s[3]):
                        return ([s[0]+s[1]+s[2], s[3]], 4, 1)  # SYLLABER_6

                    if M(s[3]):
                        if C(s[4]):
                            if not END(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3], s[4], s[5]], 6, 1)  # SYLLABER_13

                            if END(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5]], 6, 1)  # SYLLABER_39

                            if C(s[5]):
                                if C(s[6]):
                                    if END(s[7]):
                                        return ([s[0]+s[1]+s[2]+s[3]+s[4]+s[5]+s[6], s[7]], 8, 1)  # SYLLABER_350




                        if END(s[4]):
                            return ([s[0]+s[1]+s[2]+s[3], s[4]], 5, 1)  # SYLLABER_14

                        if V(s[4]):
                            return ([s[0]+s[1]+s[2]+s[3], s[4]], 5, 1)  # SYLLABER_20



                if END(s[2]):
                    return ([s[0]+s[1], s[2]], 3, 1)  # SYLLABER_7

                if S(s[2]):
                    if C(s[3]):
                        if V(s[4]):
                            return ([s[0]+s[1]+s[2], s[3], s[4]], 5, 1)  # SYLLABER_8

                        if C(s[4]):
                            if END(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5]], 6, 1)  # SYLLABER_9


                        if END(s[4]):
                            return ([s[0]+s[1]+s[2]+s[3], s[4]], 5, 1)  # SYLLABER_280

                        if M(s[4]):
                            if END(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5]], 6, 1)  # SYLLABER_400



                    if END(s[3]):
                        return ([s[0]+s[1]+s[2], s[3]], 4, 1)  # SYLLABER_10

                    return ([s[0]+s[1]+s[2]], 3, 1)  # SYLLABER_64

                if V(s[2]):
                    return ([s[0]+s[1], s[2]], 3, 1)  # SYLLABER_31


            if C(s[1]):
                if C(s[2]):
                    if V(s[3]):
                        if C(s[4]):
                            if C(s[5]):
                                if V(s[6]):
                                    return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5], s[6]], 7, 1)  # SYLLABER_2

                                if M(s[6]):
                                    if END(s[7]):
                                        return ([s[0]+s[1]+s[2]+s[3]+s[4]+s[5]+s[6], s[7]], 8, 1)  # SYLLABER_310



                            if END(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5]], 6, 1)  # SYLLABER_3

                            if V(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3], s[4], s[5]], 6, 1)  # SYLLABER_4

                            if M(s[5]):
                                if C(s[6]):
                                    if M(s[7]):
                                        if END(s[8]):
                                            return ([s[0]+s[1]+s[2]+s[3]+s[4]+s[5]+s[6]+s[7], s[8]], 9, 1)  # SYLLABER_300



                                return ([s[0]+s[1]+s[2]+s[3]+s[4]+s[5]], 6, 1)  # SYLLABER_200


                        if S(s[4]):
                            return ([s[0]+s[1]+s[2]+s[3]+s[4]], 5, 1)  # SYLLABER_54

                        if V(s[4]):
                            return ([s[0]+s[1]+s[2]+s[3], s[4]], 5, 1)  # SYLLABER_68

                        if END(s[4]):
                            return ([s[0]+s[1]+s[2]+s[3], s[4]], 5, 1)  # SYLLABER_170

                        return ([s[0]+s[1]+s[2]+s[3]], 4, 1)  # SYLLABER_210

                    if C(s[3]):
                        if V(s[4]):
                            if S(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3]+s[4]+s[5]], 6, 1)  # SYLLABER_220

                            return ([s[0]+s[1]+s[2]+s[3]+s[4]], 5, 1)  # SYLLABER_98



                if V(s[2]):
                    if C(s[3]):
                        if C(s[4]):
                            if V(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3], s[4], s[5]], 6, 1)  # SYLLABER_15

                            if C(s[5]):
                                if C(s[6]):
                                    if END(s[7]):
                                        return ([s[0]+s[1]+s[2]+s[3]+s[4]+s[5]+s[6], s[7]], 8, 1)  # SYLLABER_370


                                return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5]], 6, 1)  # SYLLABER_80

                            if M(s[5]):
                                if V(s[6]):
                                    return ([s[0]+s[1]+s[2]+s[3]+s[4]+s[5], s[6]], 7, 1)  # SYLLABER_340

                                if C(s[6]):
                                    if V(s[7]):
                                        return ([s[0]+s[1]+s[2]+s[3]+s[4]+s[5], s[6], s[7]], 8, 1)  # SYLLABER_390



                            if END(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5]], 6, 1)  # SYLLABER_470


                        if M(s[4]):
                            if not C(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5]], 6, 1)  # SYLLABER_21

                            if C(s[5]):
                                if V(s[6]):
                                    return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5], s[6]], 7, 1)  # SYLLABER_48

                                if C(s[6]):
                                    if V(s[7]):
                                        return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5], s[6], s[7]], 8, 1)  # SYLLABER_240




                        if END(s[4]):
                            return ([s[0]+s[1]+s[2]+s[3], s[4]], 5, 1)  # SYLLABER_62

                        if V(s[4]):
                            return ([s[0]+s[1]+s[2], s[3], s[4]], 5, 1)  # SYLLABER_230


                    if V(s[3]):
                        if C(s[4]):
                            return ([s[0]+s[1]+s[2], s[3], s[4]], 5, 1)  # SYLLABER_17

                        return ([s[0]+s[1]+s[2], s[3]], 4, 1)  # SYLLABER_82

                    if S(s[3]):
                        if END(s[4]):
                            return ([s[0]+s[1]+s[2]+s[3], s[4]], 5, 1)  # SYLLABER_33

                        if C(s[4]):
                            if V(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3], s[4], s[5]], 6, 1)  # SYLLABER_92

                            if C(s[5]):
                                if C(s[6]):
                                    if END(s[7]):
                                        return ([s[0]+s[1]+s[2]+s[3]+s[4]+s[5]+s[6], s[7]], 8, 1)  # SYLLABER_450




                        return ([s[0]+s[1]+s[2]+s[3]], 4, 1)  # SYLLABER_190

                    if END(s[3]):
                        return ([s[0]+s[1]+s[2], s[3]], 4, 1)  # SYLLABER_66


                if M(s[2]):
                    if V(s[3]):
                        if END(s[4]):
                            return ([s[0]+s[1]+s[2]+s[3], s[4]], 5, 1)  # SYLLABER_410

                        if C(s[4]):
                            if V(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3], s[4], s[5]], 6, 1)  # SYLLABER_480





            if M(s[1]):
                if V(s[2]):
                    if C(s[3]):
                        if V(s[4]):
                            return ([s[0]+s[1]+s[2], s[3], s[4]], 5, 1)  # SYLLABER_16

                        if C(s[4]):
                            if END(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5]], 6, 1)  # SYLLABER_19

                            if V(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3], s[4], s[5]], 6, 1)  # SYLLABER_290

                            if C(s[5]):
                                if C(s[6]):
                                    if V(s[7]):
                                        return ([s[0]+s[1]+s[2]+s[3]+s[4]+s[5], s[6], s[7]], 8, 1)  # SYLLABER_430




                        if END(s[4]):
                            return ([s[0]+s[1]+s[2]+s[3], s[4]], 5, 1)  # SYLLABER_22


                    if END(s[3]):
                        return ([s[0]+s[1]+s[2], s[3]], 4, 1)  # SYLLABER_94


                if C(s[2]):
                    if V(s[3]):
                        if S(s[4]):
                            if END(s[5]):
                                return ([s[0]+s[1]+s[2]+s[3]+s[4], s[5]], 6, 1)  # SYLLABER_320


                        if V(s[4]):
                            return ([s[0]+s[1]+s[2]+s[3], s[4]], 5, 1)  # SYLLABER_360






        if V(s[0]):
            if C(s[1]):
                if C(s[2]):
                    if END(s[3]):
                        return ([s[0]+s[1]+s[2], s[3]], 4, 1)  # SYLLABER_18

                    if V(s[3]):
                        return ([s[0]+s[1], s[2], s[3]], 4, 1)  # SYLLABER_28

                    if C(s[3]):
                        if V(s[4]):
                            if C(s[5]):
                                return ([s[0]+s[1]+s[2], s[3], s[4], s[5]], 6, 1)  # SYLLABER_96

                            return ([s[0]+s[1], s[2], s[3], s[4]], 5, 1)  # SYLLABER_50

                        if C(s[4]):
                            if V(s[5]):
                                return ([s[0]+s[1]+s[2], s[3], s[4], s[5]], 6, 1)  # SYLLABER_460



                    if M(s[3]):
                        if END(s[4]):
                            return ([s[0]+s[1]+s[2]+s[3], s[4]], 5, 1)  # SYLLABER_72



                if V(s[2]):
                    return ([s[0], s[1], s[2]], 3, 1)  # SYLLABER_35

                if M(s[2]):
                    if END(s[3]):
                        return ([s[0]+s[1]+s[2], s[3]], 4, 1)  # SYLLABER_40

                    if C(s[3]):
                        if C(s[4]):
                            if V(s[5]):
                                return ([s[0]+s[1]+s[2], s[3], s[4], s[5]], 6, 1)  # SYLLABER_42


                        if V(s[4]):
                            return ([s[0]+s[1]+s[2], s[3], s[4]], 5, 1)  # SYLLABER_84


                    if V(s[3]):
                        return ([s[0]+s[1]+s[2], s[3]], 4, 1)  # SYLLABER_78


                if END(s[2]):
                    return ([s[0]+s[1], s[2]], 3, 1)  # SYLLABER_44

                return ([s[0]+s[1]], 2, 1)  # SYLLABER_56

            if END(s[1]):
                return ([s[0], s[1]], 2, 1)  # SYLLABER_30

            if V(s[1]):
                return ([s[0], s[1]], 2, 1)  # SYLLABER_34

            if S(s[1]):
                if END(s[2]):
                    return ([s[0]+s[1], s[2]], 3, 1)  # SYLLABER_46

                if C(s[2]):
                    if V(s[3]):
                        return ([s[0]+s[1], s[2], s[3]], 4, 1)  # SYLLABER_180





        if BEG(s[0]):
            if C(s[1]):
                if C(s[2]):
                    if V(s[3]):
                        if C(s[4]):
                            if END(s[5]):
                                return ([s[0], s[1]+s[2]+s[3]+s[4], s[5]], 6, 2)  # SYLLABER_23

                            if C(s[5]):
                                if END(s[6]):
                                    return ([s[0], s[1]+s[2]+s[3]+s[4]+s[5], s[6]], 7, 2)  # SYLLABER_60

                                if M(s[6]):
                                    if END(s[7]):
                                        return ([s[0], s[1]+s[2]+s[3]+s[4]+s[5]+s[6], s[7]], 8, 2)  # SYLLABER_74




                        if S(s[4]):
                            if END(s[5]):
                                return ([s[0], s[1]+s[2]+s[3]+s[4], s[5]], 6, 2)  # SYLLABER_24


                        if END(s[4]):
                            return ([s[0], s[1]+s[2]+s[3], s[4]], 5, 2)  # SYLLABER_27


                    if END(s[3]):
                        return ([s[0], s[1]+s[2], s[3]], 4, 2)  # SYLLABER_70

                    if C(s[3]):
                        if C(s[4]):
                            if V(s[5]):
                                if C(s[6]):
                                    if END(s[7]):
                                        return ([s[0], s[1]+s[2]+s[3]+s[4]+s[5]+s[6], s[7]], 8, 2)  # SYLLABER_88




                        if V(s[4]):
                            if C(s[5]):
                                if M(s[6]):
                                    if END(s[7]):
                                        return ([s[0], s[1]+s[2]+s[3]+s[4]+s[5]+s[6], s[7]], 8, 2)  # SYLLABER_90



                            if END(s[5]):
                                return ([s[0], s[1]+s[2]+s[3]+s[4], s[5]], 6, 2)  # SYLLABER_140




                if V(s[2]):
                    if C(s[3]):
                        if C(s[4]):
                            if M(s[5]):
                                if END(s[6]):
                                    return ([s[0], s[1]+s[2]+s[3]+s[4]+s[5], s[6]], 7, 2)  # SYLLABER_26


                            if END(s[5]):
                                return ([s[0], s[1]+s[2]+s[3]+s[4], s[5]], 6, 2)  # SYLLABER_37


                        if M(s[4]):
                            if C(s[5]):
                                if C(s[6]):
                                    if END(s[7]):
                                        return ([s[0], s[1]+s[2]+s[3]+s[4]+s[5]+s[6], s[7]], 8, 2)  # SYLLABER_440





                    if S(s[3]):
                        if C(s[4]):
                            if END(s[5]):
                                return ([s[0], s[1]+s[2]+s[3]+s[4], s[5]], 6, 2)  # SYLLABER_160




                if END(s[2]):
                    return ([s[0], s[1], s[2]], 3, 2)  # SYLLABER_32

                if M(s[2]):
                    if C(s[3]):
                        if V(s[4]):
                            if END(s[5]):
                                return ([s[0], s[1]+s[2]+s[3]+s[4], s[5]], 6, 2)  # SYLLABER_58

                            if C(s[5]):
                                if END(s[6]):
                                    return ([s[0], s[1]+s[2]+s[3]+s[4]+s[5], s[6]], 7, 2)  # SYLLABER_100

                                if V(s[6]):
                                    return ([s[0], s[1]+s[2]+s[3]+s[4], s[5], s[6]], 7, 2)  # SYLLABER_420




                    if V(s[3]):
                        if END(s[4]):
                            return ([s[0], s[1]+s[2]+s[3], s[4]], 5, 2)  # SYLLABER_86

                        if S(s[4]):
                            if END(s[5]):
                                return ([s[0], s[1]+s[2]+s[3]+s[4], s[5]], 6, 2)  # SYLLABER_110


                        if C(s[4]):
                            if M(s[5]):
                                if END(s[6]):
                                    return ([s[0], s[1]+s[2]+s[3]+s[4]+s[5], s[6]], 7, 2)  # SYLLABER_150






            if V(s[1]):
                if C(s[2]):
                    if M(s[3]):
                        if END(s[4]):
                            return ([s[0], s[1]+s[2]+s[3], s[4]], 5, 2)  # SYLLABER_25


                    if END(s[3]):
                        return ([s[0], s[1]+s[2], s[3]], 4, 2)  # SYLLABER_29

                    if C(s[3]):
                        if C(s[4]):
                            if C(s[5]):
                                if END(s[6]):
                                    return ([s[0], s[1]+s[2]+s[3]+s[4]+s[5], s[6]], 7, 2)  # SYLLABER_130






            if S(s[1]):
                if V(s[2]):
                    if C(s[3]):
                        if V(s[4]):
                            return ([s[0], s[1]+s[2], s[3], s[4]], 5, 2)  # SYLLABER_380

def split_word(word):
    """
    Split single word to syllables
    :param word: unicode string representing Russian word
    :return: list of unicode strings for syllables
    """
    return split(word)


def split_words(words):
    """
    Split the words in list to contiguous list of sillables and word separators (single space chars)
    :param words: list of words (unicode strings)
    :return: list of tokens - syllables and spaces
    """
    tokens = []
    for word in words:
        sx = split(word)
        if len(tokens) > 0:
            tokens.append(u' ')
        tokens.extend(sx)
    return tokens

sx = split(u"Syllables Search is ready")
print(u"|".join(sx))

########################################################

print('Loading the rest of the module...')

########################################################

# -*- coding: utf-8 -*-

# Estimation stuff here

subSyllables = [
    'cial',
    'tia',
    'cius',
    'cious',
    'uiet',
    'gious',
    'geous',
    'priest',
    'giu',
    'dge',
    'ion',
    'iou',
    'sia$',
    '.che$',
    '.ched$',
    '.abe$',
    '.ace$',
    '.ade$',
    '.age$',
    '.aged$',
    '.ake$',
    '.ale$',
    '.aled$',
    '.ales$',
    '.ane$',
    '.ame$',
    '.ape$',
    '.are$',
    '.ase$',
    '.ashed$',
    '.asque$',
    '.ate$',
    '.ave$',
    '.azed$',
    '.awe$',
    '.aze$',
    '.aped$',
    '.athe$',
    '.athes$',
    '.ece$',
    '.ese$',
    '.esque$',
    '.esques$',
    '.eze$',
    '.gue$',
    '.ibe$',
    '.ice$',
    '.ide$',
    '.ife$',
    '.ike$',
    '.ile$',
    '.ime$',
    '.ine$',
    '.ipe$',
    '.iped$',
    '.ire$',
    '.ise$',
    '.ished$',
    '.ite$',
    '.ive$',
    '.ize$',
    '.obe$',
    '.ode$',
    '.oke$',
    '.ole$',
    '.ome$',
    '.one$',
    '.ope$',
    '.oque$',
    '.ore$',
    '.ose$',
    '.osque$',
    '.osques$',
    '.ote$',
    '.ove$',
    '.pped$',
    '.sse$',
    '.ssed$',
    '.ste$',
    '.ube$',
    '.uce$',
    '.ude$',
    '.uge$',
    '.uke$',
    '.ule$',
    '.ules$',
    '.uled$',
    '.ume$',
    '.une$',
    '.upe$',
    '.ure$',
    '.use$',
    '.ushed$',
    '.ute$',
    '.ved$',
    '.we$',
    '.wes$',
    '.wed$',
    '.yse$',
    '.yze$',
    '.rse$',
    '.red$',
    '.rce$',
    '.rde$',
    '.ily$',
    '.ely$',
    '.des$',
    '.gged$',
    '.kes$',
    '.ced$',
    '.ked$',
    '.med$',
    '.mes$',
    '.ned$',
    '.[sz]ed$',
    '.nce$',
    '.rles$',
    '.nes$',
    '.pes$',
    '.tes$',
    '.res$',
    '.ves$',
    'ere$'
]

addSyllables = [
    'ia',
    'riet',
    'dien',
    'ien',
    'iet',
    'iu',
    'iest',
    'io',
    'ii',
    'ily',
    '.oala$',
    '.iara$',
    '.ying$',
    '.earest',
    '.arer',
    '.aress',
    '.eate$',
    '.eation$',
    '[aeiouym]bl$',
    '[aeiou]{3}',
    '^mc', 'ism',
    '^mc', 'asm',
    '([^aeiouy])1l$',
    '[^l]lien',
    '^coa[dglx].',
    '[^gq]ua[^auieo]',
    'dnt$'
]

re_subsyllables = []
for s in subSyllables:
    re_subsyllables.append(re.compile(s))

re_addsyllables = []
for s in addSyllables:
    re_addsyllables.append(re.compile(s))


def estimate(word):
    parts = re.split(r'[^aeiouy]+', word)
    valid_parts = []

    for part in parts:
        if part != '':
            valid_parts.append(part)

    syllables = 0

    for p in re_subsyllables:
        if p.match(word):
            syllables -= 1

    for p in re_addsyllables:
        if p.match(word):
            syllables += 1

    syllables += len(valid_parts)

    if syllables <= 0:
        syllables = 1

    return syllables

print('Syllables Estimator is loaded:', estimate('This is a test'))

########################################################

print('Loading other aux functions...')

def word2bits(word):
    import re
    import numpy as np
    idxs = [m.start() for m in re.finditer(r'[^a-z ].', word)]
    yen_idxs = [m.start() for m in re.finditer(r'¥.', word)]
    arr = np.zeros(len(word) - len(yen_idxs), dtype = np.int32)
    arr[0] = 1
    counter = 0
    for idx in idxs:
        if idx not in yen_idxs:
            arr[idx - counter + 1] = 1
        else:
            arr[idx - counter] = 1
            counter += 1
    bits = ''.join([str(i) for i in arr])
    return bits

def count_syls(word):
    import re
    return len(re.findall(r'[^a-z ]', word)) + 1

def clean_text(word):
    import re
    return re.sub(r'[^a-z\-\/ ]', '', word)

def load_syllables_dictionary(full_path_to_dict='/content/tegridy-tools/tegridy-data/Gutteral-Syllables-List.tsv'):
  
  dictionary = []
  
  with open(full_path_to_dict) as f:
    dic = f.readlines()
    for d in dic:
      dictionary.append(d.replace(chr(10), '').split('\t'))
  
  return dictionary

def Detailed_English_Syllables_Breakdown():

  words = [y[0].lower() for y in English_Words_Syllables]
  letters_count = [y[1] for y in English_Words_Syllables]
  syls = [y[2].replace(' ', '¥.') for y in English_Words_Syllables]
  syls_count = [y[3] for y in English_Words_Syllables]
  syls_bytes = [word2bits(y) for y in syls]

  return words, letters_count, syls, syls_count, syls_bytes 

########################################################

print('Loading built-in syllables dict...')

########################################################

English_Words_Syllables = [['SEAFOOD', 7, 'f uw d', 3], ['FUCHSINE', 8, 'f uw k', 3], ['TOMFOOL', 7, 'f uw l', 3], ['TYPHOON', 7, 'f uw n', 3], ['fuwp', 4, 'f uw p', 3], ['fuwb', 4, 'f uw b', 3], ['fuwt', 4, 'f uw t', 3], ['fuwf', 4, 'f uw f', 3], ['fuwv', 4, 'f uw v', 3], ['fuwth', 5, 'f uw th', 3], ['fuwdh', 5, 'f uw dh', 3], ['fuws', 4, 'f uw s', 3], ['fuwz', 4, 'f uw z', 3], ['fuwsh', 5, 'f uw sh', 3], ['fuwzh', 5, 'f uw zh', 3], ['fuwch', 5, 'f uw ch', 3], ['fuwjh', 5, 'f uw jh', 3], ['fuwk', 4, 'f uw k', 3], ['fuwng', 5, 'f uw ng', 3], ['fuwg', 4, 'f uw g', 3], ['fuwm', 4, 'f uw m', 3], ['fuwr', 4, 'f uw r', 3], ['aword.]', 7, 'a word.]', 2], ['odd', 3, 'aa', 1], ['at', 2, 'ae', 1], ['hut', 3, 'ah', 1], ['ought', 5, 'ao', 1], ['cow', 3, 'aw', 1], ['hide', 4, 'ay', 1], ['Ed', 2, 'eh', 1], ['hurt', 4, 'er', 1], ['ate', 3, 'ey', 1], ['it', 2, 'ih', 1], ['teen', 4, 'iy', 1], ['mob', 3, 'oh', 1], ['lobe', 4, 'ow', 1], ['toy', 3, 'oy', 1], ['nook', 4, 'uh', 1], ['two', 3, 'uw', 1], ['pick', 4, 'p', 1], ['tip', 3, 't', 1], ['dee', 3, 'd', 1], ['fee', 3, 'f', 1], ['vise', 4, 'v', 1], ['thick', 5, 'th', 1], ['sick', 4, 's', 1], ['zip', 3, 'z', 1], ['ship', 4, 'sh', 1], ['seizure', 7, 'zh', 1], ['cheese', 6, 'ch', 1], ['jeep', 4, 'jh', 1], ['key', 3, 'k', 1], ['green', 5, 'g', 1], ['me', 2, 'm', 1], ['new', 3, 'n', 1], ['lee', 3, 'l', 1], ['ream', 4, 'r', 1], ['win', 3, 'w', 1], ['you', 3, 'y', 1], ['he', 2, 'hh', 1], ['ARB', 3, 'aa b', 2], ['ARBS', 4, 'aa b z', 3], ['ARCHED', 6, 'aa ch t', 3], ['MILLIARD', 8, 'aa d', 2], ['AFT', 3, 'aa f t', 3], ['REAL', 4, 'aa l', 2], ['REALS', 5, 'aa l z', 3], ['REARMED', 7, 'aa m d', 3], ['REARMS', 6, 'aa m z', 3], ['TAIYUAN', 7, 'aa n', 2], ["S\\'EANCE", 8, 'aa n s', 3], ['NUANCED', 7, 'aa n s t', 4], ['AUNT', 4, 'aa n t', 3], ['AUNTS', 5, 'aa n t s', 4], ["ARPS'S", 6, 'aa p', 2], ['ARPS', 4, 'aa p s', 3], ['R.', 2, 'aa r', 2], ["DUARTE'S", 8, 'aa r t s', 4], ['CAVIARS', 7, 'aa r z', 3], ['ARSE', 4, 'aa s', 2], ['ASK', 3, 'aa s k', 3], ['ASKS', 4, 'aa s k s', 4], ['ASKED', 5, 'aa s k t', 4], ['GOUACHE', 7, 'aa sh', 2], ['DUARTE', 6, 'aa t', 2], ['ARTS', 4, 'aa t s', 3], ['ZOUAVE', 6, 'aa v', 2], ['ZOUAVES', 7, 'aa v z', 3], ["R'S", 3, 'aa z', 2], ['TRIAD', 5, 'ae d', 2], ['TRIADS', 6, 'ae d z', 3], ['PIAFFE', 6, 'ae f', 2], ['ZODIAC', 6, 'ae k', 2], ['ZODIACS', 7, 'ae k s', 3], ['AXED', 4, 'ae k s t', 4], ['RETROACT', 8, 'ae k t', 3], ['BIVOUACS', 8, 'ae k z', 3], ['ALB', 3, 'ae l b', 3], ['ALBS', 4, 'ae l b z', 4], ['ALF', 3, 'ae l f', 3], ['ALP', 3, 'ae l p', 3], ['ALPS', 4, 'ae l p s', 4], ['ALT', 3, 'ae l t', 3], ['SIAM', 4, 'ae m', 2], ['CHORIAMB', 8, 'ae m b', 3], ['AMP', 3, 'ae m p', 3], ['AMPS', 4, 'ae m p s', 4], ['IAMBS', 5, 'ae m z', 3], ['RWANDANS', 8, 'ae n', 2], ['AND', 3, 'ae n d', 3], ['ANT', 3, 'ae n t', 3], ['ANTS', 4, 'ae n t s', 4], ['JOANNES', 7, 'ae n z', 3], ['ANGST', 5, 'ae ng s t', 4], ['ANGSTS', 6, 'ae ng s t s', 5], ["LIANG'S", 7, 'ae ng z', 3], ['APTLY', 5, 'ae p', 2], ['APSE', 4, 'ae p s', 3], ['ASK', 3, 'ae s k', 3], ['ASP', 3, 'ae s p', 3], ['ASPS', 4, 'ae s p s', 4], ['ASHTRAYS', 8, 'ae sh', 2], ['FIATS', 5, 'ae t s', 3], ['AVE', 3, 'ae v', 2], ['MIASMATA', 8, 'ae z', 2], ['ZIA', 3, 'ah', 1], ['ULVERT', 6, 'ah l', 2], ['UMPIRING', 8, 'ah m', 2], ['UMPTY', 5, 'ah m p', 3], ['UNZIPS', 6, 'ah n', 2], ['UNLOVED', 7, 'ah ng', 2], ['UPPED', 5, 'ah p t', 3], ['ANDREAS', 7, 'ah s', 2], ['UTMOSTS', 7, 'ah t', 2], ['HYATTS', 6, 'ah t s', 3], ['US', 2, 'ah z', 2], ['ORB', 3, 'ao b', 2], ['ORBED', 5, 'ao b d', 3], ['ORBS', 4, 'ao b z', 3], ['FJORDS', 6, 'ao d z', 3], ['PLAYOFF', 7, 'ao f', 2], ['PLAYOFFS', 8, 'ao f s', 3], ['OFTTIMES', 8, 'ao f t', 3], ["ORKNEY'S", 8, 'ao k', 2], ['AUKS', 4, 'ao k s', 3], ['MONTREAL', 8, 'ao l', 2], ['AULD', 4, 'ao l d', 3], ["AULD'S", 6, 'ao l d z', 4], ['AUMBRY', 6, 'ao m', 2], ['ORMSKIRK', 8, 'ao m z', 3], ["ONLINE'S", 8, 'ao n', 2], ['AWNED', 5, 'ao n d', 3], ['ORE', 3, 'ao r', 2], ["OUGHTN'T", 8, 'ao t', 2], ['OUGHTS', 6, 'ao t s', 3], ['ORES', 4, 'ao z', 2], ['OUCH', 4, 'aw ch', 2], ['MIAOWED', 7, 'aw d', 2], ['OWL', 3, 'aw l', 2], ['OWLS', 4, 'aw l z', 3], ['OUNCES', 6, 'aw n', 2], ['OZ.', 3, 'aw n s', 3], ['OUST', 4, 'aw s t', 3], ['OUSTS', 5, 'aw s t s', 4], ['TRY-OUTS', 8, 'aw t s', 3], ['MIAOWS', 6, 'aw z', 2], ['OBTUSION', 8, 'ax b', 2], ['ZVIAD', 5, 'ax d', 2], ['NEWARKS', 7, 'ax k s', 3], ['VIALED', 6, 'ax l d', 3], ['TRIUMPH', 7, 'ax m f', 3], ['TRIUMPHS', 8, 'ax m f s', 4], ['TE_DEUMS', 8, 'ax m z', 3], ["ZIONS'S", 7, 'ax n', 2], ['VIAND', 5, 'ax n d', 3], ['VIANDS', 6, 'ax n d z', 4], ['SCIENCED', 8, 'ax n s t', 4], ['UNTRUANT', 8, 'ax n t', 3], ['TRUANTS', 7, 'ax n t s', 4], ['ZIONS', 5, 'ax n z', 3], ['YELLOWER', 8, 'ax r', 2], ["YEAR'S", 6, 'ax r z', 3], ['WYATT', 5, 'ax t', 2], ["WYATT'S", 7, 'ax t s', 3], ['GOLIATH', 7, 'ax th', 2], ['GOLIATHS', 8, 'ax th s', 3], ['OF', 2, 'ax v', 2], ['ZINGERS', 7, 'ax z', 2], ['W._I.', 5, 'ay', 1], ['IDES', 4, 'ay d z', 3], ['IKE', 3, 'ay k', 2], ['ISLE', 4, 'ay l', 2], ['AISLED', 6, 'ay l d', 3], ['ISLES', 5, 'ay l z', 3], ["I'M", 3, 'ay m', 2], ['ICEFREE', 7, 'ay s', 2], ['ICED', 4, 'ay s t', 3], ['SHIITE', 6, 'ay t', 2], ['SHIITES', 7, 'ay t s', 3], ["I'VE", 4, 'ay v', 2], ['IVES', 4, 'ay v z', 3], ['W._I.S', 6, 'ay z', 2], ['BARBED', 6, 'b aa b d', 4], ['RHUBARBS', 8, 'b aa b z', 4], ['BOMBARDS', 8, 'b aa d z', 4], ['ABAFT', 5, 'b aa f t', 4], ['BARGED', 6, 'b aa jh d', 4], ['EMBARKED', 8, 'b aa k t', 4], ['TIMBALE', 7, 'b aa l', 3], ['TIMBALES', 8, 'b aa l z', 4], ['EMBALM', 6, 'b aa m', 3], ['EMBALMS', 7, 'b aa m z', 4], ['TIMBANG', 7, 'b aa ng', 3], ['UNBAR', 5, 'b aa r', 3], ['BARTH', 5, 'b aa r th', 4], ['BARTHES', 7, 'b aa r th s', 5], ['BAAS', 4, 'b aa s', 3], ['BASK', 4, 'b aa s k', 4], ['BASKS', 5, 'b aa s k s', 5], ['BASKED', 6, 'b aa s k t', 5], ["BART'S", 6, 'b aa t s', 4], ['BATHS', 5, 'b aa th s', 4], ['BATHED', 6, 'b aa th t', 4], ['UNBARS', 6, 'b aa z', 3], ['SANDBACH', 8, 'b ae ch', 3], ["BACHE'S", 7, 'b ae ch s', 4], ['BATCHED', 7, 'b ae ch t', 4], ['IBADAN', 6, 'b ae d', 3], ['WORKBAG', 7, 'b ae g', 3], ['DEBAGGED', 8, 'b ae g d', 4], ['WORKBAGS', 8, 'b ae g z', 4], ['BADGE', 5, 'b ae jh', 3], ['BADGED', 6, 'b ae jh d', 4], ['ZWIEBACK', 8, 'b ae k', 3], ['UNBACKED', 8, 'b ae k t', 4], ['CABALS', 6, 'b ae l z', 4], ['CORYBANT', 8, 'b ae n t', 4], ['BANTS', 5, 'b ae n t s', 5], ['BANS', 4, 'b ae n z', 4], ['YAOBANG', 7, 'b ae ng', 3], ['BANGED', 6, 'b ae ng d', 4], ['BARRON', 6, 'b ae r n', 4], ['BARRONS', 7, 'b ae r n z', 5], ['BASS', 4, 'b ae s', 3], ['BASQUE', 6, 'b ae s k', 4], ['BASQUES', 7, 'b ae s k s', 5], ['BASQUED', 7, 'b ae s k t', 5], ['BOMBAST', 7, 'b ae s t', 4], ['BOMBASTS', 8, 'b ae s t s', 5], ['CALABASH', 8, 'b ae sh', 3], ['WOMBAT', 6, 'b ae t', 3], ['WOMBATS', 7, 'b ae t s', 4], ['SYLLABUB', 8, 'b ah b', 3], ['ROSEBUD', 7, 'b ah d', 3], ['ROSEBUDS', 8, 'b ah d z', 4], ['REBUFF', 6, 'b ah f', 3], ['REBUFFS', 7, 'b ah f s', 4], ['REBUFFED', 8, 'b ah f t', 4], ['REDBUGS', 7, 'b ah g z', 4], ['BUDGE', 5, 'b ah jh', 3], ['BUDGED', 6, 'b ah jh d', 4], ['ROEBUCKS', 8, 'b ah k s', 4], ['BUCKED', 6, 'b ah k t', 4], ['HUXTABLE', 8, 'b ah l', 3], ['BULBED', 6, 'b ah l b d', 5], ['BULGE', 5, 'b ah l jh', 4], ['BULGED', 6, 'b ah l jh d', 5], ['BULK', 4, 'b ah l k', 4], ['BULKS', 5, 'b ah l k s', 5], ['BULKED', 6, 'b ah l k t', 5], ["REBELS'", 7, 'b ah l z', 4], ['BUMPY', 5, 'b ah m', 3], ['BUMMED', 6, 'b ah m d', 4], ['BUMPS', 5, 'b ah m p s', 5], ['BUMPED', 6, 'b ah m p t', 5], ['BUMS', 4, 'b ah m z', 4], ['BUNCH', 5, 'b ah n ch', 4], ['BUNCHED', 7, 'b ah n ch t', 5], ['MORIBUND', 8, 'b ah n d', 4], ['BUNT', 4, 'b ah n t', 4], ['BUNGED', 6, 'b ah ng d', 4], ['DEBUNKS', 7, 'b ah ng k s', 5], ['DEBUNKED', 8, 'b ah ng k t', 5], ['BUNGS', 5, 'b ah ng z', 4], ['RUB-UP', 6, 'b ah p', 3], ['RUB-UPS', 7, 'b ah p s', 4], ['SUPERBUS', 8, 'b ah s', 3], ['BUSK', 4, 'b ah s k', 4], ['BUSKES', 6, 'b ah s k s', 5], ['BUSKED', 6, 'b ah s k t', 5], ['UNROBUST', 8, 'b ah s t', 4], ['COMBUSTS', 8, 'b ah s t s', 5], ['ABOVES', 6, 'b ah v z', 4], ['BUZZED', 6, 'b ah z d', 4], ['DEBAUCH', 7, 'b ao ch', 3], ['GOTEBORG', 8, 'b ao g', 3], ['BORGES', 6, 'b ao g z', 4], ['BORK', 4, 'b ao k', 3], ["BORK'S", 6, 'b ao k s', 4], ['BORKED', 6, 'b ao k t', 4], ['PIEBALD', 7, 'b ao l d', 4], ['PIEBALDS', 8, 'b ao l d z', 5], ['COBALT', 6, 'b ao l t', 4], ['COBALTS', 7, 'b ao l t s', 5], ['SUBORNS', 7, 'b ao n z', 4], ["BONKER'S", 8, 'b ao ng', 3], ['TIBOR', 5, 'b ao r', 3], ["BOAR'S", 6, 'b ao r z', 4], ['BORSCH', 6, 'b ao sh', 3], ['ABORTS', 6, 'b ao t s', 4], ['UNBOWED', 7, 'b aw d', 3], ["ABOUD'S", 7, 'b aw d z', 4], ['REBOUNDS', 8, 'b aw n d z', 5], ['REBOUNCE', 8, 'b aw n s', 4], ['BOUNCED', 7, 'b aw n s t', 5], ['BAUSCH', 6, 'b aw sh', 3], ['LONGBOWS', 8, 'b aw z', 3], ['BOWSED', 6, 'b aw z d', 4], ['ZAMBELL', 7, 'b ax l', 3], ['UMBELED', 7, 'b ax l d', 4], ['RIBALDS', 7, 'b ax l d z', 5], ['ZAMBALES', 8, 'b ax l z', 4], ['WOBURN', 6, 'b ax n', 3], ['TURBANED', 8, 'b ax n d', 4], ['RIBANDS', 7, 'b ax n d z', 5], ["URBAN'S", 7, 'b ax n z', 4], ['WEBER', 5, 'b ax r', 3], ['WEBERS', 6, 'b ax r z', 4], ['SYLLABUS', 8, 'b ax s', 3], ['NIMBUSED', 8, 'b ax s t', 4], ['TURBOT', 6, 'b ax t', 3], ['TURBOTS', 7, 'b ax t s', 4], ['SABBATH', 7, 'b ax th', 3], ['SABBATHS', 8, 'b ax th s', 4], ['WEBERS', 6, 'b ax z', 3], ['WHEREBY', 7, 'b ay', 2], ['REIMBIBE', 8, 'b ay b', 3], ['IMBIBED', 7, 'b ay b d', 4], ['IMBIBES', 7, 'b ay b z', 4], ['CARBIDES', 8, 'b ay d z', 4], ['BIKED', 5, 'b ay k t', 4], ['NUBILE', 6, 'b ay l', 3], ['MOBILES', 7, 'b ay l z', 4], ['WOODBINE', 8, 'b ay n', 3], ['UNBINDS', 7, 'b ay n d z', 5], ['BICE', 4, 'b ay s', 3], ['DABCHICK', 8, 'b ch ih k', 4], ['BEARED', 6, 'b ea d', 3], ['BAIRN', 5, 'b ea n', 3], ['BAIRNS', 6, 'b ea n z', 4], ['UNBEARD', 7, 'b ea r d', 4], ['AUBERGE', 7, 'b ea zh', 3], ['UNDERBED', 8, 'b eh d', 3], ['PHILIBEG', 8, 'b eh g', 3], ['BEGGED', 6, 'b eh g d', 4], ['BEGS', 4, 'b eh g z', 4], ['XEBEC', 5, 'b eh k', 3], ['XEBECS', 6, 'b eh k s', 4], ['BECKED', 6, 'b eh k t', 4], ['BELCH', 5, 'b eh l ch', 4], ['BELCHED', 7, 'b eh l ch t', 5], ['REBELLED', 8, 'b eh l d', 4], ["BELL'S", 6, 'b eh l s', 4], ['SUNBELT', 7, 'b eh l t', 4], ['BEM', 3, 'b eh m', 3], ['BENCHED', 7, 'b eh n ch t', 5], ['UNBEND', 6, 'b eh n d', 4], ['UNBENDS', 7, 'b eh n d z', 5], ['UNBENT', 6, 'b eh n t', 4], ['BENZ', 4, 'b eh n z', 4], ['BENGALIS', 8, 'b eh ng', 3], ['BAER', 4, 'b eh r', 3], ["BAER'S", 6, 'b eh r z', 4], ['BESS', 4, 'b eh s', 3], ['BESTS', 5, 'b eh s t s', 5], ['TIBETANS', 8, 'b eh t', 3], ["TIBET'S", 7, 'b eh t s', 4], ['BETH', 4, 'b eh th', 3], ["BETH'S", 6, 'b eh th s', 4], ['WILBUR', 6, 'b er', 2], ['SUBURB', 6, 'b er b', 3], ['SUBURBED', 8, 'b er b d', 4], ['SUBURBS', 7, 'b er b z', 4], ['BIRCH', 5, 'b er ch', 3], ['BIRCHED', 7, 'b er ch t', 4], ['FABERGE', 7, 'b er jh', 3], ['HAUBERK', 7, 'b er k', 3], ['HAUBERKS', 8, 'b er k s', 4], ['BURKED', 6, 'b er k t', 4], ['WHITBURN', 8, 'b er n', 3], ['BURNUP', 6, 'b er n p', 4], ['SUNBURNT', 8, 'b er n t', 4], ['BURNSED', 7, 'b er n z d', 5], ['BURP', 4, 'b er p', 3], ['BURPS', 5, 'b er p s', 4], ['BURPED', 6, 'b er p t', 4], ['BURR', 4, 'b er r', 3], ['BURRED', 6, 'b er r d', 4], ['EDBERG', 6, 'b er r g', 4], ["EDBERG'S", 8, 'b er r g z', 5], ['BURRES', 6, 'b er r z', 4], ['SUNBURST', 8, 'b er s t', 4], ['SIEBERT', 7, 'b er t', 3], ['BIRTHED', 7, 'b er th t', 4], ["WILBUR'S", 8, 'b er z', 3], ['BABE', 4, 'b ey b', 3], ['BABES', 5, 'b ey b z', 4], ['OBEYED', 6, 'b ey d', 3], ['SUNBATHE', 8, 'b ey dh', 3], ['HARDBAKE', 8, 'b ey k', 3], ['SUNBAKED', 8, 'b ey k t', 4], ['BALED', 5, 'b ey l d', 4], ['BALES', 5, 'b ey l z', 4], ['URBANELY', 8, 'b ey n', 3], ['HENBANES', 8, 'b ey n z', 4], ['BAIRD', 5, 'b ey r d', 4], ["BAIRD'S", 7, 'b ey r d z', 5], ['SICKBAYS', 8, 'b ey z', 3], ['BEIGE', 5, 'b ey zh', 3], ['ABHORRED', 8, 'b hh ao d', 4], ['ABHOR', 5, 'b hh ao r', 4], ['ABHORS', 6, 'b hh ao z', 4], ['SUBHEADS', 8, 'b hh eh d z', 5], ['SUBHUMID', 8, 'b hh y uw', 4], ['ZAMBIA', 6, 'b ia', 2], ['LABIALS', 7, 'b ia l z', 4], ['ZAMBIAN', 7, 'b ia n', 3], ['AMBIENTS', 8, 'b ia n t s', 5], ['ZAMBIANS', 8, 'b ia n z', 4], ['TUBBIER', 7, 'b ia r', 3], ["BEER'S", 6, 'b ia r z', 4], ["ZAMBIA'S", 8, 'b ia z', 3], ['ZOMBIE', 6, 'b ih', 2], ['BIB', 3, 'b ih b', 3], ['BIBBED', 6, 'b ih b d', 4], ['BIBS', 4, 'b ih b z', 4], ['BITCH', 5, 'b ih ch', 3], ['BITCHED', 7, 'b ih ch t', 4], ['ZOMBIED', 7, 'b ih d', 3], ['BIFF', 4, 'b ih f', 3], ['BIFFS', 5, 'b ih f s', 4], ['BIFFED', 6, 'b ih f t', 4], ["BIGGS'S", 7, 'b ih g', 3], ['BIGGS', 5, 'b ih g s', 4], ['HERBAGE', 7, 'b ih jh', 3], ['HERBAGED', 8, 'b ih jh d', 4], ['WAYBILL', 7, 'b ih l', 3], ['REBUILDS', 8, 'b ih l d z', 5], ['BILGE', 5, 'b ih l jh', 4], ['BILGED', 6, 'b ih l jh d', 5], ['BILK', 4, 'b ih l k', 4], ['BILKS', 5, 'b ih l k s', 5], ['BILKED', 6, 'b ih l k t', 5], ['WAYBILLS', 8, 'b ih l z', 4], ['CHERUBIM', 8, 'b ih m', 3], ['WASTEBIN', 8, 'b ih n', 3], ['CABINED', 7, 'b ih n d', 4], ['HARBINGE', 8, 'b ih n jh', 4], ['BINGED', 6, 'b ih n jh d', 5], ['WEBBING', 7, 'b ih ng', 3], ['WEBBINGS', 8, 'b ih ng z', 4], ['IBIS', 4, 'b ih s', 3], ['BISQUE', 6, 'b ih s k', 4], ['BISQUES', 7, 'b ih s k s', 5], ['BESPED', 6, 'b ih s p t', 5], ['IAMBIST', 7, 'b ih s t', 4], ['CUBISTS', 7, 'b ih s t s', 5], ['TUBBISH', 7, 'b ih sh', 3], ['UNHABIT', 7, 'b ih t', 3], ['TITBITS', 7, 'b ih t s', 4], ['ZOMBIES', 7, 'b ih z', 3], ['WISBECH', 7, 'b iy ch', 3], ['BEACHED', 7, 'b iy ch t', 4], ['BEAD', 4, 'b iy d', 3], ['BEADS', 5, 'b iy d z', 4], ['BEEFS', 5, 'b iy f s', 4], ['BEEFED', 6, 'b iy f t', 4], ['BEAKED', 6, 'b iy k t', 4], ['SUNBEAM', 7, 'b iy m', 3], ['SUNBEAMS', 8, 'b iy m z', 4], ['TEREBENE', 8, 'b iy n', 3], ['BEANED', 6, 'b iy n d', 4], ['SOYBEANS', 8, 'b iy n z', 4], ['BEEP', 4, 'b iy p', 3], ['BEEPS', 5, 'b iy p s', 4], ['BEEPED', 6, 'b iy p t', 4], ['OBESE', 5, 'b iy s', 3], ['UPBEATS', 7, 'b iy t s', 4], ['BEEVES', 6, 'b iy v z', 4], ['TABES', 5, 'b iy z', 3], ['SUBJECT', 7, 'b jh ih k t', 5], ['SUBJOINT', 8, 'b jh oy n t', 5], ['SUBJOINS', 8, 'b jh oy n z', 5], ['ABJURING', 8, 'b jh ua', 3], ['ABJURED', 7, 'b jh ua d', 4], ['ABJURE', 6, 'b jh ua r', 4], ['ABJURES', 7, 'b jh ua z', 4], ['ZABEL', 5, 'b l', 2], ["BLAS\\'E", 7, 'b l aa', 3], ['BLANCH', 6, 'b l aa n ch', 5], ['BLAB', 4, 'b l ae b', 4], ['BLABBED', 7, 'b l ae b d', 5], ['BLABS', 5, 'b l ae b z', 5], ['BLACKED', 7, 'b l ae k t', 5], ['BLANTYRE', 8, 'b l ae n', 4], ['CLUBLAND', 8, 'b l ae n d', 5], ["BLAND'S", 7, 'b l ae n d z', 6], ['BLASS', 5, 'b l ae s', 4], ['BLAZON', 6, 'b l ae z', 4], ['BLUB', 4, 'b l ah b', 4], ['SBLOOD', 6, 'b l ah d', 4], ['BLUFFS', 6, 'b l ah f s', 5], ['BLUFFED', 7, 'b l ah f t', 5], ['BLUNGE', 6, 'b l ah n jh', 5], ['BLUNTS', 6, 'b l ah n t s', 6], ['BLUNKETT', 8, 'b l ah ng', 4], ['BLUSH', 5, 'b l ah sh', 4], ['BLUSHED', 7, 'b l ah sh t', 5], ['BLOUNT', 6, 'b l aw n t', 5], ["BLOUNT'S", 8, 'b l aw n t s', 6], ['ABLAUT', 6, 'b l aw t', 4], ['ABLAUTS', 7, 'b l aw t s', 5], ['BLOUSE', 6, 'b l aw z', 4], ['BLOUSED', 7, 'b l aw z d', 5], ['WOBBLER', 7, 'b l ax', 3], ['PROBLEM', 7, 'b l ax m', 4], ['PROBLEMS', 8, 'b l ax m z', 5], ['WOBBLER', 7, 'b l ax r', 4], ['STABLERS', 8, 'b l ax r z', 5], ['TUBELESS', 8, 'b l ax s', 4], ['WOBBLERS', 8, 'b l ax z', 4], ['UNBLITHE', 8, 'b l ay dh', 4], ['OBLIGE', 6, 'b l ay jh', 4], ['SLABLIKE', 8, 'b l ay k', 4], ['SUBLIMES', 8, 'b l ay m z', 5], ['UNBLIND', 7, 'b l ay n d', 5], ['BLIGHT', 6, 'b l ay t', 4], ['BLIGHTS', 7, 'b l ay t s', 5], ['WOBBLED', 7, 'b l d', 3], ['BLARING', 7, 'b l ea', 3], ['BLARED', 6, 'b l ea d', 4], ['BLARE', 5, 'b l ea r', 4], ["BLAIR'S", 7, 'b l ea r z', 5], ['BLARES', 6, 'b l ea z', 4], ['BLEB', 4, 'b l eh b', 4], ['BLED', 4, 'b l eh d', 4], ['BLENCH', 6, 'b l eh n ch', 5], ['BLENDS', 6, 'b l eh n d z', 6], ['UNBLENT', 7, 'b l eh n t', 5], ['KOBLENZ', 7, 'b l eh n t s', 6], ['NOBLESSE', 8, 'b l eh s', 4], ['SUBLETTE', 8, 'b l eh t', 4], ['SUBLETS', 7, 'b l eh t s', 5], ['BLURB', 5, 'b l er b', 4], ['BLURBS', 6, 'b l er b z', 5], ['BLURRED', 7, 'b l er d', 4], ['BLUR', 4, 'b l er r', 4], ["BLUR'S", 6, 'b l er r z', 5], ['BLURT', 5, 'b l er t', 4], ['BLURTS', 6, 'b l er t s', 5], ['BLURS', 5, 'b l er z', 4], ['BLAKE', 5, 'b l ey k', 4], ['BLAKES', 6, 'b l ey k s', 5], ['BLAMED', 6, 'b l ey m d', 5], ['BLAMES', 6, 'b l ey m z', 5], ['OBLATE', 6, 'b l ey t', 4], ['OBLATES', 7, 'b l ey t s', 5], ['EMBLAZED', 8, 'b l ey z d', 5], ['WOBBLIER', 8, 'b l ia', 3], ['WOBBLIER', 8, 'b l ia r', 4], ['BLEARED', 7, 'b l ia r d', 5], ['WORKABLY', 8, 'b l ih', 3], ['UNPUBLIC', 8, 'b l ih k', 4], ['BLIMP', 5, 'b l ih m p', 5], ['BLIMPS', 6, 'b l ih m p s', 6], ['TUMBLIN', 7, 'b l ih n', 4], ['BLINK', 5, 'b l ih ng k', 5], ['BLIP', 4, 'b l ih p', 4], ['BLIPS', 5, 'b l ih p s', 5], ['BLIPPED', 7, 'b l ih p t', 5], ['TRIBLET', 7, 'b l ih t', 4], ['TABLETS', 7, 'b l ih t s', 5], ['BLITZED', 7, 'b l ih t s t', 6], ['WOBBLIES', 8, 'b l ih z', 4], ['BLEACH', 6, 'b l iy ch', 4], ['OBLIQUE', 7, 'b l iy k', 4], ['OBLIQUES', 8, 'b l iy k s', 5], ['OBLIQUED', 8, 'b l iy k t', 5], ['BLEEP', 5, 'b l iy p', 4], ['BLEEPS', 6, 'b l iy p s', 5], ['BLEEPED', 7, 'b l iy p t', 5], ['SUBLEASE', 8, 'b l iy s', 4], ['BLEAT', 5, 'b l iy t', 4], ['BLEATS', 6, 'b l iy t s', 5], ['OBLIGE', 6, 'b l iy zh', 4], ['BLOB', 4, 'b l oh b', 4], ['BLOBBED', 7, 'b l oh b d', 5], ['BLOBS', 5, 'b l oh b z', 5], ['BLOTCH', 6, 'b l oh ch', 4], ['BLOTCHED', 8, 'b l oh ch t', 5], ['BLONDISH', 8, 'b l oh n', 4], ['BLONDE', 6, 'b l oh n d', 5], ['BLONDS', 6, 'b l oh n d z', 6], ['OBLONGS', 7, 'b l oh ng z', 5], ['BLOT', 4, 'b l oh t', 4], ['BLOTS', 5, 'b l oh t s', 5], ['BLOWED', 6, 'b l ow d', 4], ['BLOKE', 5, 'b l ow k', 4], ['BLOKES', 6, 'b l ow k s', 5], ['BLOHM', 5, 'b l ow m', 4], ["BLOHM'S", 7, 'b l ow m z', 5], ['BLOAT', 5, 'b l ow t', 4], ['BLOATS', 6, 'b l ow t s', 5], ['TABLEAUX', 8, 'b l ow z', 4], ['BLOWSED', 7, 'b l ow z d', 5], ['TABLOID', 7, 'b l oy d', 4], ['TABLOIDS', 8, 'b l oy d z', 5], ['BLUED', 5, 'b l uw d', 4], ['BLOOMED', 7, 'b l uw m d', 5], ['BLOOMS', 6, 'b l uw m z', 5], ['DOUBLOON', 8, 'b l uw n', 4], ['FWD.', 4, 'b l y uw d', 5], ['W.S', 3, 'b l y uw z', 5], ['BOBBED', 6, 'b oh b d', 4], ['BOTCH', 5, 'b oh ch', 3], ['BOTCHED', 7, 'b oh ch t', 4], ['BODMIN', 6, 'b oh d', 3], ['BOGGED', 6, 'b oh g d', 4], ['BOGGS', 5, 'b oh g s', 4], ['BOGS', 4, 'b oh g z', 4], ['WORKBOX', 7, 'b oh k s', 4], ['BOXED', 5, 'b oh k s t', 5], ['OBOL', 4, 'b oh l', 3], ['THEOBALD', 8, 'b oh l d', 4], ['VAGABOND', 8, 'b oh n d', 4], ['BONKING', 7, 'b oh ng', 3], ['BAUR', 4, 'b oh r', 3], ['EMBOSS', 6, 'b oh s', 3], ['KIBOSH', 6, 'b oh sh', 3], ['KIBOSHED', 8, 'b oh sh t', 4], ['ROBOTS', 6, 'b oh t s', 4], ['BOSNIAS', 7, 'b oh z', 3], ['YOBO', 4, 'b ow', 2], ['SABOTED', 7, 'b ow d', 3], ['WASHBOWL', 8, 'b ow l', 3], ['KOBOLDS', 7, 'b ow l d z', 5], ['UNBOLT', 6, 'b ow l t', 4], ['UNBOLTS', 7, 'b ow l t s', 5], ['WISHBONE', 8, 'b ow n', 3], ['VERBOSE', 7, 'b ow s', 3], ['BOASTS', 6, 'b ow s t s', 5], ['U-BOAT', 6, 'b ow t', 3], ['U-BOATS', 7, 'b ow t s', 4], ['BOTH', 4, 'b ow th', 3], ['YOBOS', 5, 'b ow z', 3], ['BOWSED', 6, 'b ow z d', 4], ['RHOMBOID', 8, 'b oy d', 3], ['POTBOIL', 7, 'b oy l', 3], ['UNBOILED', 8, 'b oy l d', 4], ['PARBOILS', 8, 'b oy l z', 4], ['VIBRATOS', 8, 'b r aa', 3], ['CWMBRAN', 7, 'b r aa n', 4], ['BRASS', 5, 'b r aa s', 4], ['BRAS', 4, 'b r aa z', 4], ['BRACH', 5, 'b r ae ch', 4], ['BRADT', 5, 'b r ae d t', 5], ["BRADT'S", 7, 'b r ae d t s', 6], ['BRADS', 5, 'b r ae d z', 5], ['BRAG', 4, 'b r ae g', 4], ['BRAGGED', 7, 'b r ae g d', 5], ['BRAGS', 5, 'b r ae g z', 5], ['TRIBRACH', 8, 'b r ae k', 4], ["BRACK'S", 7, 'b r ae k s', 5], ['BRACT', 5, 'b r ae k t', 5], ['BRACTS', 6, 'b r ae k t s', 6], ['BRAMSON', 7, 'b r ae m', 4], ["ABRAMS'", 7, 'b r ae m z', 5], ['BRANTON', 7, 'b r ae n', 4], ['BRANT', 5, 'b r ae n t', 5], ['BRANTS', 6, 'b r ae n t s', 6], ["BRAN'S", 6, 'b r ae n z', 5], ['BRANKO', 6, 'b r ae ng', 4], ['CAB-RANK', 8, 'b r ae ng k', 5], ['BRASH', 5, 'b r ae sh', 4], ['FIREBRAT', 8, 'b r ae t', 4], ['BRATS', 5, 'b r ae t s', 5], ['BROUGH', 6, 'b r ah f', 4], ['BRUMMELL', 8, 'b r ah m', 4], ['KOBREN', 6, 'b r ah n', 4], ['BRUNCH', 6, 'b r ah n ch', 5], ['BRUNT', 5, 'b r ah n t', 5], ['BRUNTS', 6, 'b r ah n t s', 6], ["KOBREN'S", 8, 'b r ah n z', 5], ['ABRUPTLY', 8, 'b r ah p', 4], ['UNABRUPT', 8, 'b r ah p t', 5], ['BRUSHED', 7, 'b r ah sh t', 5], ['BROADS', 6, 'b r ao d z', 5], ['BRAWLED', 7, 'b r ao l d', 5], ['BRAWLS', 6, 'b r ao l z', 5], ['BRAWN', 5, 'b r ao n', 4], ['BRAWNED', 7, 'b r ao n d', 5], ['BRAWNS', 6, 'b r ao n z', 5], ['BROWNED', 7, 'b r aw n d', 5], ['BROWNS', 6, 'b r aw n z', 5], ['BROWSED', 7, 'b r aw z d', 5], ['ZEBRA', 5, 'b r ax', 3], ['PEMBROKE', 8, 'b r ax k', 4], ['TUMBRILS', 8, 'b r ax l z', 5], ['LABRUM', 6, 'b r ax m', 4], ['VIBRANCE', 8, 'b r ax n s', 5], ['VIBRANT', 7, 'b r ax n t', 5], ['VIBRANTS', 8, 'b r ax n t s', 6], ['UMBROUS', 7, 'b r ax s', 4], ['ZEBRAS', 6, 'b r ax z', 4], ['BRIBE', 5, 'b r ay b', 4], ['BRIBED', 6, 'b r ay b d', 5], ['BRIBES', 6, 'b r ay b z', 5], ['FEBRILE', 7, 'b r ay l', 4], ['BRINED', 6, 'b r ay n d', 5], ['BRINES', 6, 'b r ay n z', 5], ['BRIGHTS', 7, 'b r ay t s', 5], ['BREADTH', 7, 'b r eh d th', 5], ['BREMNER', 7, 'b r eh m', 4], ['BRENT', 5, 'b r eh n t', 5], ['BRENTS', 6, 'b r eh n t s', 6], ['BRENS', 5, 'b r eh n z', 5], ['UMBRETTE', 8, 'b r eh t', 4], ['BREATHS', 7, 'b r eh th s', 5], ['UPBRAID', 7, 'b r ey d', 4], ['UPBRAIDS', 8, 'b r ey d z', 5], ['BRAKED', 6, 'b r ey k t', 5], ['BRAILLE', 7, 'b r ey l', 4], ['BRAILS', 6, 'b r ey l z', 5], ['VIBRATE', 7, 'b r ey t', 4], ['VIBRATES', 8, 'b r ey t s', 5], ['OUTBRAVE', 8, 'b r ey v', 4], ['UNBRAZE', 7, 'b r ey z', 4], ['UMBRIA', 6, 'b r ia', 3], ['UMBRIAN', 7, 'b r ia n', 4], ['HYBRID', 6, 'b r ih d', 4], ['HYBRIDS', 7, 'b r ih d z', 5], ['BRIG', 4, 'b r ih g', 4], ['BRIGS', 5, 'b r ih g z', 5], ['RUBRIC', 6, 'b r ih k', 4], ['RUBRICS', 7, 'b r ih k s', 5], ['BRICKED', 7, 'b r ih k t', 5], ['UMBRIL', 6, 'b r ih l', 4], ['FIBRILS', 7, 'b r ih l z', 5], ['UPBRIM', 6, 'b r ih m', 4], ['BRIMS', 5, 'b r ih m z', 5], ['OBRINSKY', 8, 'b r ih n', 4], ['BRINGED', 7, 'b r ih ng d', 5], ['BRINGS', 6, 'b r ih ng z', 5], ['HYBRIS', 6, 'b r ih s', 4], ['BRISK', 5, 'b r ih s k', 5], ['BRISKS', 6, 'b r ih s k s', 6], ['BRISKED', 7, 'b r ih s k t', 6], ['UNBREECH', 8, 'b r iy ch', 4], ['BREATHES', 8, 'b r iy dh z', 5], ['DEBRIEF', 7, 'b r iy f', 4], ['DEBRIEFS', 8, 'b r iy f s', 5], ['BREEKS', 6, 'b r iy k s', 5], ['BREAMS', 6, 'b r iy m z', 5], ['BREAN', 5, 'b r iy n', 4], ['BREEZED', 7, 'b r iy z d', 5], ['PIBROCH', 7, 'b r oh k', 4], ['PIBROCHS', 8, 'b r oh k s', 5], ['BROCKED', 7, 'b r oh k t', 5], ['HEBRON', 6, 'b r oh n', 4], ["HEBRON'S", 8, 'b r oh n z', 5], ['BRONZED', 7, 'b r oh n z d', 6], ['BRONCOS', 7, 'b r oh ng', 4], ["BRONX'S", 7, 'b r oh ng k', 5], ['BROS', 4, 'b r oh s', 4], ['BROTH', 5, 'b r oh th', 4], ['BROTHS', 6, 'b r oh th s', 5], ['UPBROKEN', 8, 'b r ow', 3], ['BROOCH', 6, 'b r ow ch', 4], ['BROACHED', 8, 'b r ow ch t', 5], ['BROGUE', 6, 'b r ow g', 4], ['BROGUES', 7, 'b r ow g z', 5], ['BROME', 5, 'b r ow m', 4], ['ARBROATH', 8, 'b r ow th', 4], ['UMBROSE', 7, 'b r ow z', 4], ['EMBROILS', 8, 'b r oy l z', 5], ['BROOKED', 7, 'b r uh k t', 5], ['IMBRUTED', 8, 'b r uw', 3], ['IMBRUED', 7, 'b r uw d', 4], ['BROODS', 6, 'b r uw d z', 5], ['BRUME', 5, 'b r uw m', 4], ['BROOMED', 7, 'b r uw m d', 5], ['BROOMS', 6, 'b r uw m z', 5], ['BRUCE', 5, 'b r uw s', 4], ['IMBRUTE', 7, 'b r uw t', 4], ['BRUTES', 6, 'b r uw t s', 5], ['IMBRUES', 7, 'b r uw z', 4], ['BRUISED', 7, 'b r uw z d', 5], ['BRUGES', 6, 'b r uw zh', 4], ['BOURDON', 7, 'b ua d', 3], ['FAUBOURG', 8, 'b ua g', 3], ['BOURNE', 6, 'b ua n', 3], ['BOURNS', 6, 'b ua n z', 4], ['TAMBOUR', 7, 'b ua r', 3], ["BOOR'S", 6, 'b ua r z', 4], ['BOURSE', 6, 'b ua s', 3], ['TAMBOURS', 8, 'b ua z', 3], ['UNBOSOMS', 8, 'b uh', 2], ['BUTCH', 5, 'b uh ch', 3], ['YEARBOOK', 8, 'b uh k', 3], ['BOOKED', 6, 'b uh k t', 4], ['TURNBULL', 8, 'b uh l', 3], ["KABUL'S", 7, 'b uh l z', 4], ['BUSHED', 6, 'b uh sh t', 4], ['KIBBUTZ', 7, 'b uh t s', 4], ['BOOB', 4, 'b uw b', 3], ['BOOBED', 6, 'b uw b d', 4], ['BOOBS', 5, 'b uw b z', 4], ['TABOOED', 7, 'b uw d', 3], ['BOUFFE', 6, 'b uw f', 3], ['BOUFFES', 7, 'b uw f s', 4], ['BUHL', 4, 'b uw l', 3], ['JIB-BOOM', 8, 'b uw m', 3], ['BOOMED', 6, 'b uw m d', 4], ['BOONE', 5, 'b uw n', 3], ['BOONS', 5, 'b uw n z', 4], ['CABOOSE', 7, 'b uw s', 3], ['BOOST', 5, 'b uw s t', 4], ['BOOSTS', 6, 'b uw s t s', 5], ['TARBOOSH', 8, 'b uw sh', 3], ['TOP-BOOT', 8, 'b uw t', 3], ['TOLBOOTH', 8, 'b uw th', 3], ['TABOOS', 6, 'b uw z', 3], ['BOUSED', 6, 'b uw z d', 4], ['GAMBOGE', 7, 'b uw zh', 3], ['BJORN', 5, 'b y ao n', 4], ["BJORN'S", 7, 'b y ao n z', 5], ['GABIONED', 8, 'b y ax n d', 5], ['SERBIANS', 8, 'b y ax n z', 5], ['ZEBU', 4, 'b y uw', 3], ['IMBUED', 6, 'b y uw d', 4], ['REBUKE', 6, 'b y uw k', 4], ['REBUKES', 7, 'b y uw k s', 5], ['REBUKED', 7, 'b y uw k t', 5], ['TRIBUNE', 7, 'b y uw n', 4], ['TRIBUNES', 8, 'b y uw n z', 5], ['ABUSE', 5, 'b y uw s', 4], ['TRIBUTE', 7, 'b y uw t', 4], ['TRIBUTES', 8, 'b y uw t s', 5], ['ZEBUS', 5, 'b y uw z', 4], ['CHUTING', 7, 'ch', 1], ['CHAFF', 5, 'ch aa f', 3], ['CHAFFS', 6, 'ch aa f s', 4], ['CHAFFED', 7, 'ch aa f t', 4], ['CHARLTON', 8, 'ch aa l', 3], ['CHARLES', 7, 'ch aa l z', 4], ['CHARM', 5, 'ch aa m', 3], ['CHARMED', 7, 'ch aa m d', 4], ['CHARMS', 6, 'ch aa m z', 4], ['CHANCED', 7, 'ch aa n s t', 5], ['ENCHANTS', 8, 'ch aa n t s', 5], ['CHAR', 4, 'ch aa r', 3], ['CHARED', 6, 'ch aa r d', 4], ['CHARES', 6, 'ch aa r z', 4], ['CHARS', 5, 'ch aa z', 3], ['CHAD', 4, 'ch ae d', 3], ["CHAD'S", 6, 'ch ae d z', 4], ['CHAMPON', 7, 'ch ae m', 3], ['CHAMPED', 7, 'ch ae m p t', 5], ['CHANES', 6, 'ch ae n z', 4], ['NANCHANG', 8, 'ch ae ng', 3], ["CHANG'S", 7, 'ch ae ng z', 4], ['CHAPTERS', 8, 'ch ae p', 3], ['CHAPS', 5, 'ch ae p s', 4], ['CHAPPED', 7, 'ch ae p t', 4], ['WHINCHAT', 8, 'ch ae t', 3], ['CHATS', 5, 'ch ae t s', 4], ['CHAS', 4, 'ch ae z', 3], ['CHUMMY', 6, 'ch ah', 2], ['CHUBB', 5, 'ch ah b', 3], ['CHUBBED', 7, 'ch ah b d', 4], ["CHUBB'S", 7, 'ch ah b z', 4], ['CHUFF', 5, 'ch ah f', 3], ['CHUFFS', 6, 'ch ah f s', 4], ['CHUFFED', 7, 'ch ah f t', 4], ['CHUG', 4, 'ch ah g', 3], ['CHUGGED', 7, 'ch ah g d', 4], ['CHUGS', 5, 'ch ah g z', 4], ['CHUCK', 5, 'ch ah k', 3], ['CHUCKS', 6, 'ch ah k s', 4], ['CHUCKED', 7, 'ch ah k t', 4], ['MITCHELL', 8, 'ch ah l', 3], ['KETCHUM', 7, 'ch ah m', 3], ['CHUMMED', 7, 'ch ah m d', 4], ['CHUMP', 5, 'ch ah m p', 4], ['CHUMPS', 6, 'ch ah m p s', 5], ['CHUMPED', 7, 'ch ah m p t', 5], ["CHUN'S", 6, 'ch ah n z', 4], ['CHUNKY', 6, 'ch ah ng', 3], ['CHUNK', 5, 'ch ah ng k', 4], ['CHUNKS', 6, 'ch ah ng k s', 5], ['CHUNKED', 7, 'ch ah ng k t', 5], ["CHUNG'S", 7, 'ch ah ng z', 4], ['PUNCH-UP', 8, 'ch ah p', 3], ['CHUTNEYS', 8, 'ch ah t', 3], ['CHORED', 6, 'ch ao d', 3], ['CHALKS', 6, 'ch ao k s', 4], ['CHALKED', 7, 'ch ao k t', 4], ['CHALDRON', 8, 'ch ao l', 3], ['CHORE', 5, 'ch ao r', 3], ['CHORED', 6, 'ch ao r d', 4], ['CHORES', 6, 'ch ao z', 3], ['SUCHOW', 6, 'ch aw', 2], ['CHOWED', 6, 'ch aw d', 3], ['CHOUSE', 6, 'ch aw s', 3], ['CHOWS', 5, 'ch aw z', 3], ['WOTCHER', 7, 'ch ax', 2], ['RICHARDS', 8, 'ch ax d z', 4], ['THATCHAM', 8, 'ch ax m', 3], ['SACHEMS', 7, 'ch ax m z', 4], ['KETCHUP', 7, 'ch ax p', 3], ['KETCHUPS', 8, 'ch ax p s', 4], ['WRENCHER', 8, 'ch ax r', 3], ['CULCHETH', 8, 'ch ax th', 3], ['WINCHERS', 8, 'ch ax z', 3], ['CHIDE', 5, 'ch ay d', 3], ['CHIDES', 6, 'ch ay d z', 4], ['CHILDLY', 7, 'ch ay l', 3], ['CHIME', 5, 'ch ay m', 3], ['CHIMED', 6, 'ch ay m d', 4], ['CHIMES', 6, 'ch ay m z', 4], ['CHINE', 5, 'ch ay n', 3], ['CHINED', 6, 'ch ay n d', 4], ['CHINES', 6, 'ch ay n z', 4], ['CHIVE', 5, 'ch ay v', 3], ['CHIVES', 6, 'ch ay v z', 4], ['CHARED', 6, 'ch ea d', 3], ['CHAIRES', 7, 'ch ea r z', 4], ['V._H._F.', 8, 'ch eh f', 3], ['WOJCIECH', 8, 'ch eh k', 3], ['CHELSEY', 7, 'ch eh l', 3], ['H._M.', 5, 'ch eh m', 3], ['VICENZO', 7, 'ch eh n', 3], ['CHENES', 6, 'ch eh n z', 4], ['CHENGTU', 7, 'ch eh ng', 3], ['CHEPSTOW', 8, 'ch eh p', 3], ['N._H._S.', 8, 'ch eh s', 3], ['SANCHEZ', 7, 'ch eh z', 3], ['CHURCHED', 8, 'ch er ch t', 4], ['CHURL', 5, 'ch er l', 3], ['CHURLED', 7, 'ch er l d', 4], ['CHURLS', 6, 'ch er l z', 4], ['CHURN', 5, 'ch er n', 3], ['CHURNED', 7, 'ch er n d', 4], ['CHURNS', 6, 'ch er n z', 4], ['CHIRP', 5, 'ch er p', 3], ['CHIRPS', 6, 'ch er p s', 4], ['CHIRPED', 7, 'ch er p t', 4], ['Y._H._A.', 8, 'ch ey', 2], ['CHAFE', 5, 'ch ey f', 3], ['CHAFES', 6, 'ch ey f s', 4], ['CHAFED', 6, 'ch ey f t', 4], ['UNCHANGE', 8, 'ch ey n jh', 4], ['UNCHAINS', 8, 'ch ey n z', 4], ['CHAPE', 5, 'ch ey p', 3], ['CHAPED', 6, 'ch ey p t', 4], ['UNCHASTE', 8, 'ch ey s t', 4], ['TOUCHIER', 8, 'ch ia', 2], ['CHEERED', 7, 'ch ia d', 3], ['TOUCHIER', 8, 'ch ia r', 3], ['TCHICK', 6, 'ch ih k', 3], ['CHILLED', 7, 'ch ih l d', 4], ['CHIMP', 5, 'ch ih m p', 4], ['CHIMPS', 6, 'ch ih m p s', 5], ['URCHIN', 6, 'ch ih n', 3], ['CHINCH', 6, 'ch ih n ch', 4], ['CHINNED', 7, 'ch ih n d', 4], ['CHINTZES', 8, 'ch ih n t', 4], ['CHINTZ', 6, 'ch ih n t s', 5], ['URCHINS', 7, 'ch ih n z', 4], ['CHINK', 5, 'ch ih ng k', 4], ['CHINKS', 6, 'ch ih ng k s', 5], ['CHINKED', 7, 'ch ih ng k t', 5], ['CHIPPED', 7, 'ch ih p t', 4], ['DUCHESS', 7, 'ch ih s', 3], ['ROCHET', 6, 'ch ih t', 3], ['RATCHETS', 8, 'ch ih t s', 4], ['YAMAICHI', 8, 'ch iy', 2], ['IN-CHIEF', 8, 'ch iy f', 3], ['CHIEFS', 6, 'ch iy f s', 4], ['CHEEKS', 6, 'ch iy k s', 4], ['CHEEKED', 7, 'ch iy k t', 4], ['CHEEP', 5, 'ch iy p', 3], ['CHEEPS', 6, 'ch iy p s', 4], ['CHEEPED', 7, 'ch iy p t', 4], ['CHEAT', 5, 'ch iy t', 3], ['CHEATS', 6, 'ch iy t s', 4], ['ACHIEVED', 8, 'ch iy v d', 4], ['ACHIEVES', 8, 'ch iy v z', 4], ['CHEESED', 7, 'ch iy z d', 4], ['SATCHEL', 7, 'ch l', 2], ['FINCHLEY', 8, 'ch l iy', 3], ['SATCHELS', 8, 'ch l z', 3], ['CHOPPY', 6, 'ch oh', 2], ['CHOCS', 5, 'ch oh k s', 4], ['CHOCKED', 7, 'ch oh k t', 4], ['OUTSHONE', 8, 'ch oh n', 3], ['CHOPPED', 7, 'ch oh p t', 4], ['GRACHEV', 7, 'ch oh v', 3], ['W._H._O.', 8, 'ch ow', 2], ['PONCHOED', 8, 'ch ow d', 3], ['CHOKES', 6, 'ch ow k s', 4], ['CHOKED', 6, 'ch ow k t', 4], ['RANCHOS', 7, 'ch ow z', 3], ['CHOICES', 7, 'ch oy', 2], ['CHOICE', 6, 'ch oy s', 3], ["CHOI'S", 6, 'ch oy z', 3], ['NATURALS', 8, 'ch r ax l z', 5], ['CHUT', 4, 'ch t', 2], ['VIRTUAL', 7, 'ch ua l', 3], ['VIRTUOUS', 8, 'ch ua s', 3], ['VIRTUE', 6, 'ch uw', 2], ['VIRTUED', 7, 'ch uw d', 3], ['CHOONG', 6, 'ch uw ng', 3], ['STATUTES', 8, 'ch uw t s', 4], ['VIRTUES', 7, 'ch uw z', 3], ['H._V._O.', 8, 'ch v iy', 3], ['ARCHWISE', 8, 'ch w ay z', 4], ['HATCHWAY', 8, 'ch w ey', 3], ['ZEMINDAR', 8, 'd aa', 2], ['DAFT', 4, 'd aa f t', 4], ["NASDAQ'S", 8, 'd aa k s', 4], ['DARKED', 6, 'd aa k t', 4], ['DAHL', 4, 'd aa l', 3], ["DAHL'S", 6, 'd aa l z', 4], ['YARDARM', 7, 'd aa m', 3], ['YARDARMS', 8, 'd aa m z', 4], ['DARNED', 6, 'd aa n d', 4], ['DANCED', 6, 'd aa n s t', 5], ["SUDAN'S", 7, 'd aa n z', 4], ['SIRDAR', 6, 'd aa r', 3], ['RADARS', 6, 'd aa r z', 4], ['DARTSMAN', 8, 'd aa t', 3], ['DARTS', 5, 'd aa t s', 4], ['SIRDARS', 7, 'd aa z', 3], ['DAB', 3, 'd ae b', 3], ['DABBED', 6, 'd ae b d', 4], ['DABS', 4, 'd ae b z', 4], ['TRINIDAD', 8, 'd ae d', 3], ['DAPHNES', 7, 'd ae f', 3], ['DAG', 3, 'd ae g', 3], ["SENDAK'S", 8, 'd ae k s', 4], ['REDACT', 6, 'd ae k t', 4], ['REDACTS', 7, 'd ae k t s', 5], ['HIDALGOS', 8, 'd ae l', 3], ['FIREDAMP', 8, 'd ae m p', 4], ['DAMPED', 6, 'd ae m p t', 5], ['SADDAMS', 7, 'd ae m z', 4], ['SLOBODAN', 8, 'd ae n', 3], ['GDANSK', 6, 'd ae n s k', 5], ["GDANSK'S", 8, 'd ae n s k s', 6], ["SUDAN'S", 7, 'd ae n z', 4], ['DANKNESS', 8, 'd ae ng k', 4], ['ADAPT', 5, 'd ae p t', 4], ['ADAPTS', 6, 'd ae p t s', 5], ['SLAPDASH', 8, 'd ae sh', 3], ['DASHED', 6, 'd ae sh t', 4], ['DAT', 3, 'd ae t', 3], ['DATS', 4, 'd ae t s', 4], ['DUBBED', 6, 'd ah b d', 4], ['DUBS', 4, 'd ah b z', 4], ['DUTCHMEN', 8, 'd ah ch', 3], ['DUD', 3, 'd ah d', 3], ['DUDS', 4, 'd ah d z', 4], ['DUFF', 4, 'd ah f', 3], ["DUFF'S", 6, 'd ah f s', 4], ['DUG', 3, 'd ah g', 3], ['DUGS', 4, 'd ah g z', 4], ['DUX', 3, 'd ah k s', 4], ['VIADUCT', 7, 'd ah k t', 4], ['VIADUCTS', 8, 'd ah k t s', 5], ['DULLED', 6, 'd ah l d', 4], ['BIDDULPH', 8, 'd ah l f', 4], ['UNADULT', 7, 'd ah l t', 4], ['ADULTS', 6, 'd ah l t s', 5], ['DULLS', 5, 'd ah l z', 4], ['DUMPY', 5, 'd ah m', 3], ['DUMBED', 6, 'd ah m d', 4], ['DUMP', 4, 'd ah m p', 4], ['DUMPS', 5, 'd ah m p s', 5], ['DUMPED', 6, 'd ah m p t', 5], ['DUMDUMS', 7, 'd ah m z', 4], ['WELDON', 6, 'd ah n', 3], ['DUNNED', 6, 'd ah n d', 4], ['DUNCE', 5, 'd ah n s', 4], ["WELDON'S", 8, 'd ah n z', 4], ['DUNGED', 6, 'd ah ng d', 4], ['DUNK', 4, 'd ah ng k', 4], ['DUNKS', 5, 'd ah ng k s', 5], ['DUNKED', 6, 'd ah ng k t', 5], ['STAND-UP', 8, 'd ah p', 3], ['PARDUS', 6, 'd ah s', 3], ['DUSK', 4, 'd ah s k', 4], ['DUSKED', 6, 'd ah s k t', 5], ['STARDUST', 8, 'd ah s t', 4], ['DUTT', 4, 'd ah t', 3], ['DOTH', 4, 'd ah th', 3], ['UNDOES', 6, 'd ah z', 3], ['DAUB', 4, 'd ao b', 3], ['DAUBED', 6, 'd ao b d', 4], ['DAUBS', 5, 'd ao b z', 4], ['UNADORED', 8, 'd ao d', 3], ['DUNDALK', 7, 'd ao k', 3], ['HOLDALL', 7, 'd ao l', 3], ['RUDOLPH', 7, 'd ao l f', 4], ['HOLDALLS', 8, 'd ao l z', 4], ['DAUNT', 5, 'd ao n t', 4], ['DAUNTS', 6, 'd ao n t s', 5], ['DAWNS', 5, 'd ao n z', 4], ['INDORSE', 7, 'd ao s', 3], ['REDOUND', 7, 'd aw n d', 4], ['REDOUNDS', 8, 'd aw n d z', 5], ['DOWSE', 5, 'd aw s', 3], ['DOWSED', 6, 'd aw s t', 4], ['ENDOWS', 6, 'd aw z', 3], ['ZENDER', 6, 'd ax', 2], ['WONDERED', 8, 'd ax d', 3], ['SHADDOCK', 8, 'd ax k', 3], ['WINDALL', 7, 'd ax l', 3], ['VANDALS', 7, 'd ax l z', 4], ['UNDOMED', 7, 'd ax m d', 4], ['WISDOMS', 7, 'd ax m z', 4], ['YIELDEN', 7, 'd ax n', 3], ['VOIDANCE', 8, 'd ax n s', 4], ['UGANDANS', 8, 'd ax n z', 4], ['BANDUNG', 7, 'd ax ng', 3], ['ZENDA', 5, 'd ax r', 3], ['UDDERED', 7, 'd ax r d', 4], ["WONDER'S", 8, 'd ax r z', 4], ["WOULD'VE", 8, 'd ax v', 3], ['ZODIACAL', 8, 'd ay', 2], ['IODIDES', 7, 'd ay d z', 4], ['VANDYKE', 7, 'd ay k', 3], ['VANDYKES', 8, 'd ay k s', 4], ['VANDYKED', 8, 'd ay k t', 4], ['EDILE', 5, 'd ay l', 3], ['PARADIGM', 8, 'd ay m', 3], ['VANDINE', 7, 'd ay n', 3], ['GODCHILD', 8, 'd ch ay l d', 5], ['SUDARIUM', 8, 'd ea', 2], ['DARED', 5, 'd ea d', 3], ["DAREN'T", 7, 'd ea n t', 4], ['DEB', 3, 'd eh b', 3], ['DEBS', 4, 'd eh b z', 4], ["DEAD'S", 6, 'd eh d z', 4], ['DEFTNESS', 8, 'd eh f t', 4], ['WINDEX', 6, 'd eh k s', 4], ['PANDECT', 7, 'd eh k t', 4], ['PANDECTS', 8, 'd eh k t s', 5], ['SABADELL', 8, 'd eh l', 3], ['DELF', 4, 'd eh l f', 4], ['DELFT', 5, 'd eh l f t', 5], ['DELFTS', 6, 'd eh l f t s', 6], ['DELTON', 6, 'd eh l t', 4], ['DELVE', 5, 'd eh l v', 4], ['DELVED', 6, 'd eh l v d', 5], ['DELVES', 6, 'd eh l v z', 5], ['FIDELES', 7, 'd eh l z', 4], ['DIVIDEND', 8, 'd eh n d', 4], ['INDENTS', 7, 'd eh n t s', 5], ['DENGUES', 7, 'd eh ng', 3], ["DENG'S", 6, 'd eh ng z', 4], ['DEPTHING', 8, 'd eh p', 3], ['ADEPT', 5, 'd eh p t', 4], ['ADEPTS', 6, 'd eh p t s', 5], ['DEPTHS', 6, 'd eh p th s', 5], ['VEDETTE', 7, 'd eh t', 3], ['DEBTS', 5, 'd eh t s', 4], ['SDEATH', 6, 'd eh th', 3], ["DEVON'S", 7, 'd eh v', 3], ['ORLANDEZ', 8, 'd eh z', 3], ['DIRGE', 5, 'd er jh', 3], ['DIRGED', 6, 'd er jh d', 4], ['DIRK', 4, 'd er k', 3], ['DIRKS', 5, 'd er k s', 4], ['DIRKED', 6, 'd er k t', 4], ['DIRNDLS', 7, 'd er n', 3], ['DERBIES', 7, 'd er r', 3], ['DURST', 5, 'd er s t', 4], ["DURST'S", 7, 'd er s t s', 5], ['PAYDIRT', 7, 'd er t', 3], ["DIRT'S", 6, 'd er t s', 4], ['DEARTH', 6, 'd er th', 3], ['DEARTHS', 7, 'd er th s', 4], ['SNYDERS', 7, 'd er z', 3], ["DADE'S", 6, 'd ey d z', 4], ['NANDAIME', 8, 'd ey m', 3], ['DAMES', 5, 'd ey m z', 4], ['DACE', 4, 'd ey s', 3], ['VALIDATE', 8, 'd ey t', 3], ['DAVE', 4, 'd ey v', 3], ["DAVE'S", 6, 'd ey v z', 4], ['DAZED', 5, 'd ey z d', 4], ['ADHERING', 8, 'd hh ia', 3], ['ADHERED', 7, 'd hh ia d', 4], ['ADHERE', 6, 'd hh ia r', 4], ['ADHERES', 7, 'd hh ia z', 4], ['SANDHI', 6, 'd hh iy', 3], ['ROAD-HOG', 8, 'd hh oh g', 4], ['AD_HOC', 6, 'd hh oh k', 4], ['RED-HOT', 7, 'd hh oh t', 4], ['WINDHOLE', 8, 'd hh ow l', 4], ['LANDHOLD', 8, 'd hh ow l d', 5], ['WORDIER', 7, 'd ia', 2], ['UNIDEAL', 7, 'd ia l', 3], ['RADIALS', 7, 'd ia l z', 4], ['TEDIUM', 6, 'd ia m', 3], ['TEDIUMS', 7, 'd ia m z', 4], ['VIRIDIAN', 8, 'd ia n', 3], ['RADIANCE', 8, 'd ia n s', 4], ['RADIANTS', 8, 'd ia n t s', 5], ['WORDIER', 7, 'd ia r', 3], ['ZODIACS', 7, 'd ih', 2], ['DIB', 3, 'd ih b', 3], ['REDDITCH', 8, 'd ih ch', 3], ['DITCHED', 7, 'd ih ch t', 4], ['YIELDED', 7, 'd ih d', 3], ['TARDIFF', 7, 'd ih f', 3], ['VENDIG', 6, 'd ih g', 3], ['SHINDIGS', 8, 'd ih g z', 4], ['WINDAGE', 7, 'd ih jh', 3], ['BANDAGED', 8, 'd ih jh d', 4], ['ZENDIC', 6, 'd ih k', 3], ['SYNDICS', 7, 'd ih k s', 4], ['VERDICT', 7, 'd ih k t', 4], ['VERDICTS', 8, 'd ih k t s', 5], ['IDYLL', 5, 'd ih l', 3], ['IDYLLS', 6, 'd ih l z', 4], ['UNDIMMED', 8, 'd ih m d', 4], ['DIMS', 4, 'd ih m z', 4], ['TRADE-IN', 8, 'd ih n', 3], ['DINNED', 6, 'd ih n d', 4], ['DINT', 4, 'd ih n t', 4], ['DINTS', 5, 'd ih n t s', 5], ['DINGED', 6, 'd ih ng d', 4], ['DIPTYCHS', 8, 'd ih p', 3], ['DIPS', 4, 'd ih p s', 4], ['UNDIPPED', 8, 'd ih p t', 4], ['WANDIS', 6, 'd ih s', 3], ['DISQUE', 6, 'd ih s k', 4], ['DISKS', 5, 'd ih s k s', 5], ['DISKED', 6, 'd ih s k t', 5], ['DYSPNOEA', 8, 'd ih s p', 4], ['WOULDEST', 8, 'd ih s t', 4], ['SADISTS', 7, 'd ih s t s', 5], ['YIDDISH', 7, 'd ih sh', 3], ['UNDISHED', 8, 'd ih sh t', 4], ['SUBEDITS', 8, 'd ih t s', 4], ['MEREDITH', 8, 'd ih th', 3], ['RECIDIVE', 8, 'd ih v', 3], ['ORDEAL', 6, 'd iy l', 3], ['ORDEALS', 7, 'd iy l z', 4], ['REDEEM', 6, 'd iy m', 3], ['REDEEMS', 7, 'd iy m z', 4], ['UNDINE', 6, 'd iy n', 3], ['UNDINED', 7, 'd iy n d', 4], ['UNDINES', 7, 'd iy n z', 4], ['DEEPS', 5, 'd iy p s', 4], ['MODISTE', 7, 'd iy s t', 4], ['MODISTES', 8, 'd iy s t s', 5], ['JUDITH', 6, 'd iy th', 3], ['KHEDIVE', 7, 'd iy v', 3], ['KHEDIVES', 8, 'd iy v z', 4], ['VENDEES', 7, 'd iy z', 3], ['ODD-JOB', 7, 'd jh oh b', 4], ['YODEL', 5, 'd l', 2], ['MUDLARK', 7, 'd l aa k', 4], ['MUDLARKS', 8, 'd l aa k s', 5], ['HEADLAMP', 8, 'd l ae m p', 5], ['WILDLAND', 8, 'd l ae n d', 5], ['LUDLUM', 6, 'd l ah m', 4], ["LUDLUM'S", 8, 'd l ah m z', 5], ['LANDLORD', 8, 'd l ao d', 4], ['RUDLOFF', 7, 'd l ao f', 4], ['YODELLER', 8, 'd l ax', 3], ['HOODLUM', 7, 'd l ax m', 4], ['HOODLUMS', 8, 'd l ax m z', 5], ['WOODLAND', 8, 'd l ax n d', 5], ['YODELLER', 8, 'd l ax r', 4], ['WILDLIFE', 8, 'd l ay f', 4], ['BIRDLIME', 8, 'd l ay m', 4], ['SIDELINE', 8, 'd l ay n', 4], ['WOODLICE', 8, 'd l ay s', 4], ['YODELLED', 8, 'd l d', 3], ['AD_LIB', 6, 'd l ih b', 4], ['AD-LIBS', 7, 'd l ih b z', 5], ['WINDLIN', 7, 'd l ih n', 4], ['IDLEST', 6, 'd l ih s t', 5], ['RADLETT', 7, 'd l ih t', 4], ['MEDLEYS', 7, 'd l ih z', 4], ['RADLEIAN', 8, 'd l iy', 3], ['WEDLOCK', 7, 'd l oh k', 4], ['WEDLOCKS', 8, 'd l oh k s', 5], ['SIDELONG', 8, 'd l oh ng', 4], ["LUDLOW'S", 8, 'd l ow z', 4], ['YODELS', 6, 'd l z', 3], ['STANDOFF', 8, 'd oh f', 3], ['DOFFED', 6, 'd oh f t', 4], ['WATCHDOG', 8, 'd oh g', 3], ['DOGGED', 6, 'd oh g d', 4], ['DODGE', 5, 'd oh jh', 3], ['DODGED', 6, 'd oh jh d', 4], ['UNDOCKED', 8, 'd oh k t', 4], ['ODOL', 4, 'd oh l', 3], ['DOLLED', 6, 'd oh l d', 4], ['RUDOLPH', 7, 'd oh l f', 4], ['DALTONS', 7, 'd oh l t', 4], ['DOLLS', 5, 'd oh l z', 4], ['CONDOMS', 7, 'd oh m z', 4], ['TANDON', 6, 'd oh n', 3], ['DONNED', 6, 'd oh n d', 4], ["TANDON'S", 8, 'd oh n z', 4], ['ADOPT', 5, 'd oh p t', 4], ['ADOPTS', 6, 'd oh p t s', 5], ['REREDOS', 7, 'd oh s', 3], ['SUPERDOT', 8, 'd oh t', 3], ['PERIDOTS', 8, 'd oh t s', 4], ['WINDOWED', 8, 'd ow d', 3], ['DOGE', 4, 'd ow jh', 3], ['DOLT', 4, 'd ow l t', 4], ['DOLTS', 5, 'd ow l t s', 5], ['DOLES', 5, 'd ow l z', 4], ['DOMED', 5, 'd ow m d', 4], ['CONDONE', 7, 'd ow n', 3], ["DON'TS", 6, 'd ow n t s', 5], ['CONDONES', 8, 'd ow n z', 4], ['DOPE', 4, 'd ow p', 3], ['DOPES', 5, 'd ow p s', 4], ['DOPED', 5, 'd ow p t', 4], ['DOTES', 5, 'd ow t s', 4], ['WINDOWS', 7, 'd ow z', 3], ['DOZED', 5, 'd ow z d', 4], ['DOYLY', 5, 'd oy', 2], ['DM.', 3, 'd oy ch', 3], ['DOIT', 4, 'd oy t', 3], ['MADRAS', 6, 'd r aa s', 4], ['DRABNESS', 8, 'd r ae b', 4], ['DRAFTERS', 8, 'd r ae f', 4], ['DRAGNETS', 8, 'd r ae g', 4], ['DRAGGED', 7, 'd r ae g d', 5], ['DRAGS', 5, 'd r ae g z', 5], ['DRACHMAS', 8, 'd r ae k', 4], ['DRAMME', 6, 'd r ae m', 4], ['DRAMMED', 7, 'd r ae m d', 5], ['DRAMS', 5, 'd r ae m z', 5], ['DRANK', 5, 'd r ae ng k', 5], ['DRAT', 4, 'd r ae t', 4], ['DRATS', 5, 'd r ae t s', 5], ['DRUB', 4, 'd r ah b', 4], ['DRUBBED', 7, 'd r ah b d', 5], ['DRUBS', 5, 'd r ah b z', 5], ['WOODRUFF', 8, 'd r ah f', 4], ['DRUGGED', 7, 'd r ah g d', 5], ['DRUGS', 5, 'd r ah g z', 5], ['DRUDGE', 6, 'd r ah jh', 4], ['DRUDGED', 7, 'd r ah jh d', 5], ['DRUCTOR', 7, 'd r ah k', 4], ['WOODRUM', 7, 'd r ah m', 4], ['DRUMMED', 7, 'd r ah m d', 5], ['DRUNKEST', 8, 'd r ah ng', 4], ['DRAWLED', 7, 'd r ao l d', 5], ['DRAWLS', 6, 'd r ao l z', 5], ['REDRAW', 6, 'd r ao r', 4], ['REDRAWS', 7, 'd r ao r z', 5], ['VANDROSS', 8, 'd r ao s', 4], ['DROWSY', 6, 'd r aw', 3], ['DROWNED', 7, 'd r aw n d', 5], ['DROWNDS', 7, 'd r aw n d z', 6], ['DROWNS', 6, 'd r aw n z', 5], ['DROUGHT', 7, 'd r aw t', 4], ['DROUGHTS', 8, 'd r aw t s', 5], ['DROWSE', 6, 'd r aw z', 4], ['DROWSED', 7, 'd r aw z d', 5], ['HUNDREDS', 8, 'd r ax d z', 5], ['TENDRILS', 8, 'd r ax l z', 5], ['QUADRANT', 8, 'd r ax n t', 5], ['WONDROUS', 8, 'd r ax s', 4], ['TUNDRAS', 7, 'd r ax z', 4], ['HYDRIDES', 8, 'd r ay d z', 5], ['SANDRINE', 8, 'd r ay n', 4], ['DREADS', 6, 'd r eh d z', 5], ['DREGS', 5, 'd r eh g z', 5], ['REDREDGE', 8, 'd r eh jh', 4], ["DREXEL'S", 8, 'd r eh k', 4], ['UNDREAMT', 8, 'd r eh m t', 5], ['DRENCH', 6, 'd r eh n ch', 5], ['UNDRESS', 7, 'd r eh s', 4], ['DRAYED', 6, 'd r ey d', 4], ['LANDRAIL', 8, 'd r ey l', 4], ['DRAINED', 7, 'd r ey n d', 5], ['MIDRANGE', 8, 'd r ey n jh', 5], ['DRAINS', 6, 'd r ey n z', 5], ['UNDRAPE', 7, 'd r ey p', 4], ['UNDRAPES', 8, 'd r ey p s', 5], ['UNDRAPED', 8, 'd r ey p t', 5], ['PADRES', 6, 'd r ey z', 4], ['TUNDREA', 7, 'd r ia', 3], ['ADRIANCE', 8, 'd r ia n s', 5], ["ADRIAN'S", 8, 'd r ia n z', 5], ['TAWDRIER', 8, 'd r ia r', 4], ['WIZARDRY', 8, 'd r ih', 3], ['MILDRED', 7, 'd r ih d', 4], ["MADRID'S", 8, 'd r ih d z', 5], ['MIDRIFF', 7, 'd r ih f', 4], ['MIDRIFFS', 8, 'd r ih f s', 5], ['QUADRICS', 8, 'd r ih k s', 5], ['DRINK', 5, 'd r ih ng k', 5], ['DRIPS', 5, 'd r ih p s', 5], ['DRIPPED', 7, 'd r ih p t', 5], ['WARDRESS', 8, 'd r ih s', 4], ['QUADRATE', 8, 'd r ih t', 4], ['UNDRIVEN', 8, 'd r ih v', 4], ['TAWDRIES', 8, 'd r ih z', 4], ["HENDRY'S", 8, 'd r iy z', 4], ['BEDROCKS', 8, 'd r oh k s', 5], ['DROSS', 5, 'd r oh s', 4], ['DROSHKY', 7, 'd r oh sh', 4], ['WARDROBE', 8, 'd r ow b', 4], ['DROGUE', 6, 'd r ow g', 4], ['DROGUES', 7, 'd r ow g z', 5], ['DROLL', 5, 'd r ow l', 4], ['DROLLS', 6, 'd r ow l z', 5], ['SYNDROME', 8, 'd r ow m', 4], ['LADRONE', 7, 'd r ow n', 4], ['DRONED', 6, 'd r ow n d', 5], ['DRONES', 6, 'd r ow n z', 5], ['DROVED', 6, 'd r ow v d', 5], ['DROVES', 6, 'd r ow v z', 5], ['WINDROWS', 8, 'd r ow z', 4], ['ANDROIDS', 8, 'd r oy d z', 5], ['DREWERY', 7, 'd r ua', 3], ['WARDROOM', 8, 'd r uh m', 4], ['WITHDREW', 8, 'd r uw', 3], ['DROOLED', 7, 'd r uw l d', 5], ['HEADROOM', 8, 'd r uw m', 4], ['QUADROON', 8, 'd r uw n', 4], ['DRUPE', 5, 'd r uw p', 4], ['DRUPES', 6, 'd r uw p s', 5], ['DROOPED', 7, 'd r uw p t', 5], ['REDRUTH', 7, 'd r uw th', 4], ['DOUR', 4, 'd ua r', 3], ['ABDUL', 5, 'd uh l', 3], ["ABDUL'S", 7, 'd uh l z', 4], ['VOODOOED', 8, 'd uw d', 3], ['SHADOOF', 7, 'd uw f', 3], ['ABDUL', 5, 'd uw l', 3], ["ABDUL'S", 7, 'd uw l z', 4], ['FOREDOOM', 8, 'd uw m', 3], ['BRIDOON', 7, 'd uw n', 3], ['DOUCHE', 6, 'd uw sh', 3], ['DOUCHED', 7, 'd uw sh t', 4], ['VOODOOS', 7, 'd uw z', 3], ['EDOUARD', 7, 'd w aa', 3], ['EDOUARD', 7, 'd w aa r', 4], ['BOUDOIRS', 8, 'd w aa z', 4], ['DWARF', 5, 'd w ao f', 4], ['DWARFS', 6, 'd w ao f s', 5], ['DWARFED', 7, 'd w ao f t', 5], ['SIDEWALK', 8, 'd w ao k', 4], ['HEADWALL', 8, 'd w ao l', 4], ['TIDWORTH', 8, 'd w ax th', 4], ['MIDWIFE', 7, 'd w ay f', 4], ['MIDWIFES', 8, 'd w ay f s', 5], ['MIDWIFED', 8, 'd w ay f t', 5], ['DWIGHT', 6, 'd w ay t', 4], ['MIDWIVED', 8, 'd w ay v d', 5], ['MIDWIVES', 8, 'd w ay v z', 5], ['HARDWARE', 8, 'd w ea', 3], ['HARDWARE', 8, 'd w ea r', 4], ['DWELLED', 7, 'd w eh l d', 5], ['INDWELT', 7, 'd w eh l t', 5], ['HEADWORD', 8, 'd w er d', 4], ['WOODWORK', 8, 'd w er k', 4], ['WOODWORM', 8, 'd w er m', 4], ['TIDEWAY', 7, 'd w ey', 3], ['DWALE', 5, 'd w ey l', 4], ['TIDEWAYS', 8, 'd w ey z', 4], ['GOODWILL', 8, 'd w ih l', 4], ['WOODWIND', 8, 'd w ih n d', 5], ['REDWING', 7, 'd w ih ng', 4], ['HOODWINK', 8, 'd w ih ng k', 5], ['REDWINGS', 8, 'd w ih ng z', 5], ['GODWIT', 6, 'd w ih t', 4], ['GODWITS', 7, 'd w ih t s', 5], ['MIDWEEK', 7, 'd w iy k', 4], ['MIDWEEKS', 8, 'd w iy k s', 5], ['BEDWAS', 6, 'd w oh z', 4], ['MADWOMAN', 8, 'd w uh', 3], ['REDWOOD', 7, 'd w uh d', 4], ['REDWOODS', 8, 'd w uh d z', 5], ['MADURAI', 7, 'd y ah', 3], ['VERDURE', 7, 'd y ax', 3], ['VERDURED', 8, 'd y ax d', 4], ['VANADIUM', 8, 'd y ax m', 4], ['RHODIAN', 7, 'd y ax n', 4], ['RADIANT', 7, 'd y ax n t', 5], ['RADIANTS', 8, 'd y ax n t s', 6], ['RADIANS', 7, 'd y ax n z', 5], ['VERDURE', 7, 'd y ax r', 4], ['VERDURED', 8, 'd y ax r d', 5], ['VERDURES', 8, 'd y ax r z', 5], ['VERDURES', 8, 'd y ax z', 4], ['RESIDUAL', 8, 'd y ua l', 4], ['RESIDUUM', 8, 'd y ua m', 4], ['PADUAN', 6, 'd y ua n', 4], ['ORDURE', 6, 'd y ua r', 4], ['ORDURES', 7, 'd y ua r z', 5], ['ORDURES', 7, 'd y ua z', 4], ['DUDES', 5, 'd y uw d z', 5], ['DUKES', 5, 'd y uw k s', 5], ['SCHEDULE', 8, 'd y uw l', 4], ['DUNE', 4, 'd y uw n', 4], ['DUNES', 5, 'd y uw n z', 5], ['DUPE', 4, 'd y uw p', 4], ['DUPES', 5, 'd y uw p s', 5], ['DUPED', 5, 'd y uw p t', 5], ['DEUTZIA', 7, 'd y uw t', 4], ['SUBDUES', 7, 'd y uw z', 4], ["THAT'LL", 7, 'dh ae', 2], ['THAN', 4, 'dh ae n', 3], ['THAT', 4, 'dh ae t', 3], ["THAT'S", 6, 'dh ae t s', 4], ['THUS', 4, 'dh ah s', 3], ['WITHAL', 6, 'dh ao l', 3], ['THOUING', 7, 'dh aw', 2], ['THOUED', 6, 'dh aw d', 3], ['WITHOUTS', 8, 'dh aw t s', 4], ['ZITHER', 6, 'dh ax', 2], ['WITHERED', 8, 'dh ax d', 3], ['RHYTHMS', 7, 'dh ax m z', 4], ['WREATHEN', 8, 'dh ax n', 3], ['ZITHER', 6, 'dh ax r', 3], ['POTHERED', 8, 'dh ax r d', 4], ['WRITHERS', 8, 'dh ax r z', 4], ['ZITHERS', 7, 'dh ax z', 3], ['THYSELF', 7, 'dh ay', 2], ['THINE', 5, 'dh ay n', 3], ["THEY'RE", 7, 'dh ea', 2], ['THERED', 6, 'dh ea d', 3], ["THERE'LL", 8, 'dh ea l', 3], ["THEY'RE", 7, 'dh ea r', 3], ['THERED', 6, 'dh ea r d', 4], ['THERES', 6, 'dh ea r z', 4], ['THERES', 6, 'dh ea z', 3], ['THEM', 4, 'dh eh m', 3], ['THEMED', 6, 'dh eh m d', 4], ["THEM'S", 6, 'dh eh m z', 4], ['THEN', 4, 'dh eh n', 3], ['WRATHER', 7, 'dh er', 2], ['LEATHERN', 8, 'dh er n', 3], ['WRATHERS', 8, 'dh er z', 3], ['THEY', 4, 'dh ey', 2], ["THEY'D", 6, 'dh ey d', 3], ["THEY'LL", 7, 'dh ey l', 3], ["THEY'VE", 7, 'dh ey v', 3], ['THEYES', 6, 'dh ey z', 3], ['WITHHELD', 8, 'dh hh eh l d', 5], ['WITHHOLD', 8, 'dh hh ow l d', 5], ['WORTHIER', 8, 'dh ia', 2], ['SCYTHIAN', 8, 'dh ia n', 3], ['WORTHIER', 8, 'dh ia r', 3], ['WORTHY', 6, 'dh ih', 2], ['TITHINGS', 8, 'dh ih ng z', 4], ['THIS', 4, 'dh ih s', 3], ['SOUTHEST', 8, 'dh ih s t', 4], ['WORTHIES', 8, 'dh ih z', 3], ['THEE', 4, 'dh iy', 2], ['WITHIN', 6, 'dh iy n', 3], ['WITHINS', 7, 'dh iy n z', 4], ['THESE', 5, 'dh iy z', 3], ['SMOOTHLY', 8, 'dh l ih', 3], ['THOUGH', 6, 'dh ow', 2], ['THOSE', 5, 'dh ow z', 3], ['SOUTHRON', 8, 'dh r ax n', 4], ["WHOE'ER", 7, 'ea', 1], ['HEIRED', 6, 'ea d', 2], ['HEIRED', 6, 'ea r d', 3], ['HEIRES', 6, 'ea r z', 3], ['EBBTIDES', 8, 'eh b', 2], ['EBBED', 5, 'eh b d', 3], ['EBBS', 4, 'eh b z', 3], ['ETCH', 4, 'eh ch', 2], ['ETCHED', 6, 'eh ch t', 3], ['INFRARED', 8, 'eh d', 2], ["KIEV'S", 6, 'eh f s', 3], ['EFT', 3, 'eh f t', 3], ['EFTS', 4, 'eh f t s', 4], ['EGGED', 5, 'eh g d', 3], ['EGGS', 4, 'eh g z', 3], ['EDGE', 4, 'eh jh', 2], ['XMASES', 6, 'eh k', 2], ['X.', 2, 'eh k s', 3], ["WELSH'S", 7, 'eh l', 2], ['ELF', 3, 'eh l f', 3], ["ELF'S", 5, 'eh l f s', 4], ['ELK', 3, 'eh l k', 3], ['ELKS', 4, 'eh l k s', 4], ['ELMSFORD', 8, 'eh l m', 3], ['ELMS', 4, 'eh l m z', 4], ['ELSE', 4, 'eh l s', 3], ['WELSH', 5, 'eh l sh', 3], ['ELVES', 5, 'eh l v z', 4], ['PRE-EMPT', 8, 'eh m p t', 4], ['PROEMS', 6, 'eh m z', 3], ['U._N._D.', 8, 'eh n d', 3], ['ENDS', 4, 'eh n d z', 4], ['ENC', 3, 'eh n k', 3], ["UN'S", 4, 'eh n z', 3], ['U._S.', 5, 'eh s', 2], ['TRIESTE', 7, 'eh s t', 3], ['SUEZ', 4, 'eh z', 2], ['ERRED', 5, 'er d', 2], ['ERG', 3, 'er g', 2], ['ERGS', 4, 'er g z', 3], ['URGE', 4, 'er jh', 2], ['URGED', 5, 'er jh d', 3], ['IRKS', 4, 'er k s', 3], ['IRKED', 5, 'er k t', 3], ['EARLS', 5, 'er l z', 3], ['URN', 3, 'er n', 2], ['EARNED', 6, 'er n d', 3], ['ERNST', 5, 'er n s t', 4], ["ERNST'S", 7, 'er n s t s', 5], ['URNS', 4, 'er n z', 3], ['ERSE', 4, 'er s', 2], ['ERST', 4, 'er s t', 3], ['EARTHS', 6, 'er th s', 3], ['EARTHED', 7, 'er th t', 3], ["ZAYRE'S", 7, 'er z', 2], ['ABE', 3, 'ey b', 2], ['P._H._D.', 8, 'ey ch', 2], ['AGED', 4, 'ey jh d', 3], ['AILED', 5, 'ey l d', 3], ['AMESES', 6, 'ey m', 2], ['AIMED', 5, 'ey m d', 3], ['AMESBURY', 8, 'ey m z', 3], ['ANGELS', 6, 'ey n', 2], ["AIN'T", 5, 'ey n t', 3], ['APE', 3, 'ey p', 2], ['APES', 4, 'ey p s', 3], ['APED', 4, 'ey p t', 3], ['PIERRE', 6, 'ey r', 2], ["PIERRE'S", 8, 'ey r z', 3], ['ACE', 3, 'ey s', 2], ['VITIATE', 7, 'ey t', 2], ['VITIATES', 8, 'ey t s', 3], ['EIGHTH', 6, 'ey t th', 3], ['EIGHTHS', 7, 'ey t th s', 4], ["ROU\\'ES", 7, 'ey z', 2], ['LIAISED', 7, 'ey z d', 3], ['LIEGE', 5, 'ey zh', 2], ['FOIE', 4, 'f', 1], ['UPHARSIN', 8, 'f aa', 2], ['FAHD', 4, 'f aa d', 3], ["FAHD'S", 6, 'f aa d z', 4], ['FARMED', 6, 'f aa m d', 4], ['INSOFAR', 7, 'f aa r', 3], ['FASTS', 5, 'f aa s t s', 5], ['FART', 4, 'f aa t', 3], ['FARTS', 5, 'f aa t s', 4], ['PREFABS', 7, 'f ae b z', 4], ['FAD', 3, 'f ae d', 3], ['FADS', 4, 'f ae d z', 4], ['FAGGED', 6, 'f ae g d', 4], ['FAGS', 4, 'f ae g z', 4], ['HALIFAX', 7, 'f ae k s', 4], ['OLFACT', 6, 'f ae k t', 4], ['FACTS', 5, 'f ae k t s', 5], ['ASPHALT', 7, 'f ae l t', 4], ['ASPHALTS', 8, 'f ae l t s', 5], ['FANNED', 6, 'f ae n d', 4], ['STEFANS', 7, 'f ae n z', 4], ['FANGED', 6, 'f ae ng d', 4], ['FANGS', 5, 'f ae ng z', 4], ['FASH', 4, 'f ae sh', 3], ['FASHED', 6, 'f ae sh t', 4], ['FATS', 4, 'f ae t s', 4], ['FUG', 3, 'f ah g', 3], ['FUGS', 4, 'f ah g z', 4], ['FUDGE', 5, 'f ah jh', 3], ['FUDGED', 6, 'f ah jh d', 4], ['FUCK', 4, 'f ah k', 3], ['FUCKS', 5, 'f ah k s', 4], ['FUCKED', 6, 'f ah k t', 4], ['EFFULGE', 7, 'f ah l jh', 4], ['EFFULGED', 8, 'f ah l jh d', 5], ['FUNKY', 5, 'f ah ng', 3], ['FUNKS', 5, 'f ah ng k s', 5], ['FUNKED', 6, 'f ah ng k t', 5], ['FUSS', 4, 'f ah s', 3], ['SUBFUSC', 7, 'f ah s k', 4], ['FUSSED', 6, 'f ah s t', 4], ['PHUT', 4, 'f ah t', 3], ['FUZZBUZZ', 8, 'f ah z', 3], ['FUZZED', 6, 'f ah z d', 4], ['FORDS', 5, 'f ao d z', 4], ['FORGE', 5, 'f ao jh', 3], ['FORGED', 6, 'f ao jh d', 4], ['FORKED', 6, 'f ao k t', 4], ['WINDFALL', 8, 'f ao l', 3], ['FALLED', 6, 'f ao l d', 4], ['LAFALCE', 7, 'f ao l s', 4], ['UNIFORMS', 8, 'f ao m z', 4], ['FAWN', 4, 'f ao n', 3], ['FAWNED', 6, 'f ao n d', 4], ['FAWNS', 5, 'f ao n z', 4], ['FORTS', 5, 'f ao t s', 4], ['FOURTHS', 7, 'f ao th s', 4], ['FOULKES', 7, 'f aw k s', 4], ['WILDFOWL', 8, 'f aw l', 3], ['FOWLED', 6, 'f aw l d', 4], ['FOUNT', 5, 'f aw n t', 4], ['FOUNTS', 6, 'f aw n t s', 5], ['WILFORD', 7, 'f ax d', 3], ['SUFFOLK', 7, 'f ax k', 3], ['TRIFLED', 7, 'f ax l d', 4], ['SYPHONED', 8, 'f ax n d', 4], ['SYPHONS', 7, 'f ax n z', 4], ['ZEPHYR', 6, 'f ax r', 3], ['WAFERED', 7, 'f ax r d', 4], ["WAFER'S", 7, 'f ax r z', 4], ['TYPHUS', 6, 'f ax s', 3], ['ZEPHYRS', 7, 'f ax z', 3], ['WINTRIFY', 8, 'f ay', 2], ['FIFE', 4, 'f ay f', 3], ['FIFES', 5, 'f ay f s', 4], ['PROFILE', 7, 'f ay l', 3], ['PROFILES', 8, 'f ay l z', 4], ['FINDS', 5, 'f ay n d z', 5], ['REFINES', 7, 'f ay n z', 4], ['SUFFICE', 7, 'f ay s', 3], ['SUFFICED', 8, 'f ay s t', 4], ['ZOOPHYTE', 8, 'f ay t', 3], ['M._I._5.', 8, 'f ay v', 3], ['FIVES', 5, 'f ay v z', 4], ['VIVIFIES', 8, 'f ay z', 3], ['FAREED', 6, 'f ea d', 3], ['WELFARE', 7, 'f ea r', 3], ['FAREED', 6, 'f ea r d', 4], ['WELFARES', 8, 'f ea r z', 4], ['WELFARES', 8, 'f ea z', 3], ['FEB', 3, 'f eh b', 3], ['FETCH', 5, 'f eh ch', 3], ['FETCHED', 7, 'f eh ch t', 4], ['WESTFED', 7, 'f eh d', 3], ['FEDS', 4, 'f eh d z', 4], ['U._F._F.', 8, 'f eh f', 3], ['PONTIFEX', 8, 'f eh k s', 4], ['UNFELTED', 8, 'f eh l', 3], ['UNFELLED', 8, 'f eh l d', 4], ["FELD'S", 6, 'f eh l d z', 5], ["PHELPS'S", 8, 'f eh l p', 4], ['PHELPS', 6, 'f eh l p s', 5], ['UNFELT', 6, 'f eh l t', 4], ['FELTES', 6, 'f eh l t s', 5], ['FELLS', 5, 'f eh l z', 4], ['FEM', 3, 'f eh m', 3], ['OFFENDS', 7, 'f eh n d z', 5], ['FENS', 4, 'f eh n z', 4], ['NYMPHET', 7, 'f eh t', 3], ['NYMPHETS', 8, 'f eh t s', 4], ['UNFURL', 6, 'f er l', 3], ['UNFURLED', 8, 'f er l d', 4], ['UNFURLS', 7, 'f er l z', 4], ['FERNED', 6, 'f er n d', 4], ['TRANSFER', 8, 'f er r', 3], ['SEAFIRST', 8, 'f er s t', 4], ['ERFURT', 6, 'f er t', 3], ['FURTH', 5, 'f er th', 3], ['FIRTHS', 6, 'f er th s', 4], ['FURZED', 6, 'f er z d', 4], ['FADE', 4, 'f ey d', 3], ['FADES', 5, 'f ey d z', 4], ['FAKE', 4, 'f ey k', 3], ['FAKES', 5, 'f ey k s', 4], ['FAKED', 5, 'f ey k t', 4], ['FAILED', 6, 'f ey l d', 4], ['FAILS', 5, 'f ey l z', 4], ['FAME', 4, 'f ey m', 3], ["FAME'S", 6, 'f ey m z', 4], ['FEINT', 5, 'f ey n t', 4], ['FEINTS', 6, 'f ey n t s', 5], ['PROFANES', 8, 'f ey n z', 4], ['TYPEFACE', 8, 'f ey s', 3], ['SULPHATE', 8, 'f ey t', 3], ['FAITH', 5, 'f ey th', 3], ['FAITHS', 6, 'f ey th s', 4], ['FAITHED', 7, 'f ey th t', 4], ['PHASED', 6, 'f ey z d', 4], ['OFFHAND', 7, 'f hh ae n d', 5], ['WIFEHOOD', 8, 'f hh uh d', 4], ['SPHERED', 7, 'f ia d', 3], ['RUFFIANS', 8, 'f ia n z', 4], ['STUFFIER', 8, 'f ia r', 3], ['SPHERED', 7, 'f ia r d', 4], ["SPHERE'S", 8, 'f ia r z', 4], ['MORPHEUS', 8, 'f ia s', 3], ['FIB', 3, 'f ih b', 3], ['FIBBED', 6, 'f ih b d', 4], ['FIBS', 4, 'f ih b z', 4], ['FITCH', 5, 'f ih ch', 3], ['FITCHED', 7, 'f ih ch t', 4], ['APHIDS', 6, 'f ih d z', 4], ['FYFFES', 6, 'f ih f s', 4], ['FIFTH', 5, 'f ih f th', 4], ['FIFTHS', 6, 'f ih f th s', 5], ['FIGS', 4, 'f ih g z', 4], ['WHARFAGE', 8, 'f ih jh', 3], ['UNFIX', 5, 'f ih k s', 4], ['FILCH', 5, 'f ih l ch', 4], ['UNFILM', 6, 'f ih l m', 4], ['UNFILMED', 8, 'f ih l m d', 5], ['FILTH', 5, 'f ih l th', 4], ['FILTHS', 6, 'f ih l th s', 5], ['REFILLS', 7, 'f ih l z', 4], ['TERAPHIM', 8, 'f ih m', 3], ['HAWFINCH', 8, 'f ih n ch', 4], ['FINCHED', 7, 'f ih n ch t', 5], ['TIFFINS', 7, 'f ih n z', 4], ['WOOFING', 7, 'f ih ng', 3], ['SPHINXES', 8, 'f ih ng k', 4], ['SPHINX', 6, 'f ih ng k s', 5], ['FINKED', 6, 'f ih ng k t', 5], ['SURFINGS', 8, 'f ih ng z', 4], ['FISK', 4, 'f ih s k', 4], ['FISKES', 6, 'f ih s k s', 5], ['WOLFISH', 7, 'f ih sh', 3], ['UNPROFIT', 8, 'f ih t', 3], ['UNFITS', 6, 'f ih t s', 4], ["TROPHY'S", 8, 'f ih z', 3], ['FIZZED', 6, 'f ih z d', 4], ['FIEFDOMS', 8, 'f iy f', 3], ['FIEFS', 5, 'f iy f s', 4], ['FEELS', 5, 'f iy l z', 4], ['MORPHEME', 8, 'f iy m', 3], ['TREPHINE', 8, 'f iy n', 3], ['FIENDS', 6, 'f iy n d z', 5], ['FEASTS', 6, 'f iy s t s', 5], ['UNDEFEAT', 8, 'f iy t', 3], ["FEET'S", 6, 'f iy t s', 4], ['WAFFLE', 6, 'f l', 2], ['FLASKET', 7, 'f l aa', 3], ['FLAGGED', 7, 'f l ae g d', 5], ['FLAXY', 5, 'f l ae k', 4], ['FLAX', 4, 'f l ae k s', 5], ['FLACKED', 7, 'f l ae k t', 5], ['FLANNELS', 8, 'f l ae n', 4], ['FLANGE', 6, 'f l ae n jh', 5], ['FLANS', 5, 'f l ae n z', 5], ['UNFLANK', 7, 'f l ae ng k', 5], ['FLAPS', 5, 'f l ae p s', 5], ['FLAPPED', 7, 'f l ae p t', 5], ['FLASHED', 7, 'f l ae sh t', 5], ['UNFLAT', 6, 'f l ae t', 4], ["FLATS'", 6, 'f l ae t s', 5], ['FLOODS', 6, 'f l ah d z', 5], ['FLUFF', 5, 'f l ah f', 4], ['FLUFFS', 6, 'f l ah f s', 5], ['FLUFFED', 7, 'f l ah f t', 5], ['REFLUX', 6, 'f l ah k s', 5], ['REFLUXED', 8, 'f l ah k s t', 6], ['FLUMPING', 8, 'f l ah m', 4], ['FLUMP', 5, 'f l ah m p', 5], ['FLUMPS', 6, 'f l ah m p s', 6], ['FLUMPED', 7, 'f l ah m p t', 6], ['FLUNKY', 6, 'f l ah ng', 4], ['FLUNK', 5, 'f l ah ng k', 5], ['FLUSH', 5, 'f l ah sh', 4], ['FLUSHED', 7, 'f l ah sh t', 5], ['FLOORED', 7, 'f l ao d', 4], ['FLAUNT', 6, 'f l ao n t', 5], ['FLAUNTS', 7, 'f l ao n t s', 6], ['FLORES', 6, 'f l ao r z', 5], ['FLOUNCE', 7, 'f l aw n s', 5], ['FLOUT', 5, 'f l aw t', 4], ['FLOUTS', 6, 'f l aw t s', 5], ['TRUFFLER', 8, 'f l ax r', 4], ['WIFELESS', 8, 'f l ax s', 4], ['TRIFLERS', 8, 'f l ax z', 4], ['WIFELIKE', 8, 'f l ay k', 4], ['FLIGHTS', 7, 'f l ay t s', 5], ['WAFFLED', 7, 'f l d', 3], ['FLARED', 6, 'f l ea d', 4], ['FLARE', 5, 'f l ea r', 4], ['FLARES', 6, 'f l ea z', 4], ['UNFLESHY', 8, 'f l eh', 3], ['FLED', 4, 'f l eh d', 4], ['REFLEDGE', 8, 'f l eh jh', 4], ['REFLECT', 7, 'f l eh k t', 5], ['REFLECTS', 8, 'f l eh k t s', 6], ['PHLEGM', 6, 'f l eh m', 4], ['PHLEGMS', 7, 'f l eh m z', 5], ['FLENSING', 8, 'f l eh n', 4], ['FLENCH', 6, 'f l eh n ch', 5], ['FLENSE', 6, 'f l eh n z', 5], ['FLENSED', 7, 'f l eh n z d', 6], ['FLESHED', 7, 'f l eh sh t', 5], ['FLIRT', 5, 'f l er t', 4], ['FLIRTS', 6, 'f l er t s', 5], ['FLAKED', 6, 'f l ey k t', 5], ['FLAIL', 5, 'f l ey l', 4], ['FLAILED', 7, 'f l ey l d', 5], ['FLAILS', 6, 'f l ey l z', 5], ['REFLATES', 8, 'f l ey t s', 5], ['WIFELIER', 8, 'f l ia', 3], ['FLEERED', 7, 'f l ia d', 4], ['WIFELIER', 8, 'f l ia r', 4], ['FLEERS', 6, 'f l ia z', 4], ['WIFELY', 6, 'f l ih', 3], ['FLICKS', 6, 'f l ih k s', 5], ['INFLICTS', 8, 'f l ih k t s', 6], ['FLIMSY', 6, 'f l ih m', 4], ['FLINCH', 6, 'f l ih n ch', 5], ['WAFFLING', 8, 'f l ih ng', 4], ['FLIP', 4, 'f l ih p', 4], ['FLIPS', 5, 'f l ih p s', 5], ['FLIPPED', 7, 'f l ih p t', 5], ['PAMPHLET', 8, 'f l ih t', 4], ['FLEAM', 5, 'f l iy m', 4], ['FLYNN', 5, 'f l iy n', 4], ["FLYNN'S", 7, 'f l iy n z', 5], ['FLEECE', 6, 'f l iy s', 4], ['FLEECED', 7, 'f l iy s t', 5], ['FLEETS', 6, 'f l iy t s', 5], ['FLEES', 5, 'f l iy z', 4], ['FLOG', 4, 'f l oh g', 4], ['FLOGGED', 7, 'f l oh g d', 5], ['FLOGS', 5, 'f l oh g z', 5], ['PHLOXES', 7, 'f l oh k', 4], ['PHLOX', 5, 'f l oh k s', 5], ['FLOCKED', 7, 'f l oh k t', 5], ['MOUFLON', 7, 'f l oh n', 4], ['LIFELONG', 8, 'f l oh ng', 4], ['FLOP', 4, 'f l oh p', 4], ['FLOPS', 5, 'f l oh p s', 5], ['FLOPPED', 7, 'f l oh p t', 5], ['FLOSS', 5, 'f l oh s', 4], ['FLOSSED', 7, 'f l oh s t', 5], ['FLOTSAMS', 8, 'f l oh t', 4], ['REFLOAT', 7, 'f l ow t', 4], ['REFLOATS', 8, 'f l ow t s', 5], ['FLOYD', 5, 'f l oy d', 4], ["FLOYD'S", 7, 'f l oy d z', 5], ['UNFLUENT', 8, 'f l ua n t', 5], ['OVERFLEW', 8, 'f l uw', 3], ['FLEWED', 6, 'f l uw d', 4], ['FLUKE', 5, 'f l uw k', 4], ['FLUKES', 6, 'f l uw k s', 5], ['FLUKED', 6, 'f l uw k t', 5], ['FLUME', 5, 'f l uw m', 4], ['FLUMED', 6, 'f l uw m d', 5], ['FLUMES', 6, 'f l uw m z', 5], ['FLUTE', 5, 'f l uw t', 4], ['FLUTES', 6, 'f l uw t s', 5], ['FLUES', 5, 'f l uw z', 4], ['WAFFLES', 7, 'f l z', 3], ['FOB', 3, 'f oh b', 3], ['FOBBED', 6, 'f oh b d', 4], ['FOBS', 4, 'f oh b z', 4], ['EPHOD', 5, 'f oh d', 3], ['FOGGED', 6, 'f oh g d', 4], ['OUTFOX', 6, 'f oh k s', 4], ['OUTFOXED', 8, 'f oh k s t', 5], ['FALCONRY', 8, 'f oh l', 3], ['TELETHON', 8, 'f oh n', 3], ['FONT', 4, 'f oh n t', 4], ['FONTS', 5, 'f oh n t s', 5], ['HAIPHONG', 8, 'f oh ng', 3], ['FOP', 3, 'f oh p', 3], ['FOPS', 4, 'f oh p s', 4], ["FORBES'S", 8, 'f oh r b', 4], ['FORBES', 6, 'f oh r b s', 5], ['FOSSED', 6, 'f oh s t', 4], ['UNFOLD', 6, 'f ow l d', 4], ['UNFOLDS', 7, 'f ow l d z', 5], ['FOALS', 5, 'f ow l z', 4], ['FOAMED', 6, 'f ow m d', 4], ['FOAMS', 5, 'f ow m z', 4], ["UFO'S", 5, 'f ow z', 3], ['FOYERS', 6, 'f oy', 2], ['TYPHOID', 7, 'f oy d', 3], ['TYPHOIDS', 8, 'f oy d z', 4], ['TREFOIL', 7, 'f oy l', 3], ['TREFOILS', 8, 'f oy l z', 4], ['SAINFOIN', 8, 'f oy n', 3], ['FOIST', 5, 'f oy s t', 4], ['FOISTS', 6, 'f oy s t s', 5], ['FOISON', 6, 'f oy z', 3], ['FRANCE', 6, 'f r aa n s', 5], ["LEFRAK'S", 8, 'f r ae k s', 5], ['REFRACT', 7, 'f r ae k t', 5], ['REFRACTS', 8, 'f r ae k t s', 6], ['FRANZ', 5, 'f r ae n z', 5], ['FRAP', 4, 'f r ae p', 4], ['FRAPPED', 7, 'f r ae p t', 5], ['FRUSTUMS', 8, 'f r ah', 3], ['FRUSTIFY', 8, 'f r ah k', 4], ['USUFRUCT', 8, 'f r ah k t', 5], ['FRUMPY', 6, 'f r ah m', 4], ['FRUMP', 5, 'f r ah m p', 5], ['FRUMPS', 6, 'f r ah m p s', 6], ['FRAUD', 5, 'f r ao d', 4], ['FRAUDS', 6, 'f r ao d z', 5], ['FRAUGHT', 7, 'f r ao t', 4], ['FRAUGHTS', 8, 'f r ao t s', 5], ['FROWZY', 6, 'f r aw', 3], ['FROWN', 5, 'f r aw n', 4], ['FROWNED', 7, 'f r aw n d', 5], ['FROWNS', 6, 'f r aw n z', 5], ['WOLFRAM', 7, 'f r ax m', 4], ['WOLFRAMS', 8, 'f r ax m z', 5], ['SAFFRONS', 8, 'f r ax n z', 5], ["FRIED'S", 7, 'f r ay d z', 5], ['FRIGHTS', 7, 'f r ay t s', 5], ['FRIES', 5, 'f r ay z', 4], ['RENFRED', 7, 'f r eh d', 4], ["FRED'S", 6, 'f r eh d z', 5], ['REFRESH', 7, 'f r eh sh', 4], ['FRETTE', 6, 'f r eh t', 4], ['FRETS', 5, 'f r eh t s', 5], ['UNFRAYED', 8, 'f r ey d', 4], ['UNFRAIL', 7, 'f r ey l', 4], ['UNFRAME', 7, 'f r ey m', 4], ['UNFRAMED', 8, 'f r ey m d', 5], ['REFRAIN', 7, 'f r ey n', 4], ['REFRAINS', 8, 'f r ey n z', 5], ['FREIGHTS', 8, 'f r ey t s', 5], ['WOLFREY', 7, 'f r ih', 3], ['WOLFRED', 7, 'f r ih d', 4], ['SUFFRAGE', 8, 'f r ih jh', 4], ['FRILL', 5, 'f r ih l', 4], ['FRILLED', 7, 'f r ih l d', 5], ['FRILLS', 6, 'f r ih l z', 5], ['UNFRINGE', 8, 'f r ih n jh', 5], ['FRINTON', 7, 'f r ih n t', 5], ['FRISK', 5, 'f r ih s k', 5], ['FRISKS', 6, 'f r ih s k s', 6], ['FRISKED', 7, 'f r ih s k t', 6], ['UNFRET', 6, 'f r ih t', 4], ['FRITZ', 5, 'f r ih t s', 5], ['FRITH', 5, 'f r ih th', 4], ['PALFREYS', 8, 'f r ih z', 4], ['FRIZZED', 7, 'f r ih z d', 5], ['UNFREED', 7, 'f r iy d', 4], ['FREAK', 5, 'f r iy k', 4], ['FREAKS', 6, 'f r iy k s', 5], ['FREAKED', 7, 'f r iy k t', 5], ['FRERES', 6, 'f r iy r z', 5], ['DUMFRIES', 8, 'f r iy s', 4], ['AFRIT', 5, 'f r iy t', 4], ['AFRITS', 6, 'f r iy t s', 5], ['UNFREEZE', 8, 'f r iy z', 4], ['FRIEZED', 7, 'f r iy z d', 5], ['FRODSHAM', 8, 'f r oh d', 4], ['LEAPFROG', 8, 'f r oh g', 4], ['UNFROCK', 7, 'f r oh k', 4], ['UNFROCKS', 8, 'f r oh k s', 5], ['FRONDER', 7, 'f r oh n', 4], ['FROND', 5, 'f r oh n d', 5], ['FRONDS', 6, 'f r oh n d z', 6], ['FROTH', 5, 'f r oh th', 4], ['FROTHS', 6, 'f r oh th s', 5], ['FROTHED', 7, 'f r oh th t', 5], ['FROZEN', 6, 'f r ow', 3], ['UNFROZEN', 8, 'f r ow z', 4], ['UNFRUITY', 8, 'f r uw', 3], ['FROME', 5, 'f r uw m', 4], ['OFFSHORE', 8, 'f sh ao', 3], ['OFFSHORE', 8, 'f sh ao r', 4], ['OFFSHOOT', 8, 'f sh uw t', 4], ['NAPHTHAS', 8, 'f th ax z', 4], ['FIFTHLY', 7, 'f th l ih', 4], ['NAPHTHOL', 8, 'f th oh l', 4], ['UNFULLED', 8, 'f uh l d', 4], ['TUBFULS', 7, 'f uh l z', 4], ['WEBFOOT', 7, 'f uh t', 3], ['SEAFOOD', 7, 'f uw d', 3], ['SEAFOODS', 8, 'f uw d z', 4], ['FUCHSINE', 8, 'f uw k', 3], ['FUCHS', 5, 'f uw k s', 4], ['TOMFOOL', 7, 'f uw l', 3], ['FOOLED', 6, 'f uw l d', 4], ['TOMFOOLS', 8, 'f uw l z', 4], ['TYPHOON', 7, 'f uw n', 3], ['TYPHOONS', 8, 'f uw n z', 4], ['COIFFURE', 8, 'f y ua r', 4], ['WHEW', 4, 'f y uw', 3], ['FEUD', 4, 'f y uw d', 4], ['FEUDS', 5, 'f y uw d z', 5], ['FUGUE', 5, 'f y uw g', 4], ['FUGUED', 6, 'f y uw g d', 5], ['FUGUES', 6, 'f y uw g z', 5], ['REFUGED', 7, 'f y uw jh d', 5], ['PERFUME', 7, 'f y uw m', 4], ['PERFUMES', 8, 'f y uw m z', 5], ['EFFUSED', 7, 'f y uw s t', 5], ['REFUTE', 6, 'f y uw t', 4], ['REFUTES', 7, 'f y uw t s', 5], ["GDANSK'S", 8, 'g', 1], ['GARB', 4, 'g aa b', 3], ['UNGARBED', 8, 'g aa b d', 4], ['GARBS', 5, 'g aa b z', 4], ['OLIGARCH', 8, 'g aa k', 3], ['KALGAN', 6, 'g aa n', 3], ['GARVIS', 6, 'g aa r', 3], ["CIGAR'S", 7, 'g aa r z', 4], ['GASP', 4, 'g aa s p', 4], ['GASPS', 5, 'g aa s p s', 5], ['GASPED', 6, 'g aa s p t', 5], ['HOGARTH', 7, 'g aa th', 3], ['GARTHS', 6, 'g aa th s', 4], ['NOUGATS', 7, 'g aa z', 3], ['GAB', 3, 'g ae b', 3], ['GADZOOKS', 8, 'g ae d', 3], ['GADS', 4, 'g ae d z', 4], ['GAFFS', 5, 'g ae f s', 4], ['GAFFED', 6, 'g ae f t', 4], ['GAG', 3, 'g ae g', 3], ['GAGGED', 6, 'g ae g d', 4], ['GAGS', 4, 'g ae g z', 4], ['GALVIS', 6, 'g ae l', 3], ['GALS', 4, 'g ae l z', 4], ['GAMP', 4, 'g ae m p', 4], ['GAMPS', 5, 'g ae m p s', 5], ['UGANDANS', 8, 'g ae n', 3], ['ARGAND', 6, 'g ae n d', 4], ["MORGAN'S", 8, 'g ae n z', 4], ['GANGWAYS', 8, 'g ae ng', 3], ['GANGED', 6, 'g ae ng d', 4], ['GANGS', 5, 'g ae ng z', 4], ['STOPGAP', 7, 'g ae p', 3], ['STOPGAPS', 8, 'g ae p s', 4], ['TOWN-GAS', 8, 'g ae s', 3], ['GASH', 4, 'g ae sh', 3], ['GASHED', 6, 'g ae sh t', 4], ['GATT', 4, 'g ae t', 3], ["VEGAS'S", 7, 'g ah', 2], ['STEAGALL', 8, 'g ah l', 3], ['GULCH', 5, 'g ah l ch', 4], ['GULLED', 6, 'g ah l d', 4], ['GULF', 4, 'g ah l f', 4], ['GULFS', 5, 'g ah l f s', 5], ['GULFED', 6, 'g ah l f t', 5], ['GULP', 4, 'g ah l p', 4], ['GULPS', 5, 'g ah l p s', 5], ['GULPED', 6, 'g ah l p t', 5], ['GULCH', 5, 'g ah l sh', 4], ['GUMSHOES', 8, 'g ah m', 3], ['GUMMED', 6, 'g ah m d', 4], ['GUMS', 4, 'g ah m z', 4], ['VEGAS', 5, 'g ah s', 3], ['GUSTS', 5, 'g ah s t s', 5], ['GUSH', 4, 'g ah sh', 3], ['GUSHED', 6, 'g ah sh t', 4], ['ROTGUT', 6, 'g ah t', 3], ['ROTGUTS', 7, 'g ah t s', 4], ["VEGA'S", 6, 'g ah z', 3], ['YEGOR', 5, 'g ao', 2], ['GORED', 5, 'g ao d', 3], ['GAUDS', 5, 'g ao d z', 4], ['GORGE', 5, 'g ao jh', 3], ['GORGED', 6, 'g ao jh d', 4], ['GAWK', 4, 'g ao k', 3], ['GAWKS', 5, 'g ao k s', 4], ['GAWKED', 6, 'g ao k t', 4], ['SENEGAL', 7, 'g ao l', 3], ['GALLED', 6, 'g ao l d', 4], ['GORMLY', 6, 'g ao m', 3], ['LEGHORN', 7, 'g ao n', 3], ['LEGHORNS', 8, 'g ao n z', 4], ['GAWP', 4, 'g ao p', 3], ['GAWPS', 5, 'g ao p s', 4], ['GAWPED', 6, 'g ao p t', 4], ['YEGOR', 5, 'g ao r', 3], ["GORE'S", 6, 'g ao r z', 4], ['GORSE', 5, 'g ao s', 3], ['GHAT', 4, 'g ao t', 3], ['GHATS', 5, 'g ao t s', 4], ['RIGORS', 6, 'g ao z', 3], ['GAUZED', 6, 'g ao z d', 4], ['GOUGE', 5, 'g aw jh', 3], ['GOUGED', 6, 'g aw jh d', 4], ['GOWK', 4, 'g aw k', 3], ['GOWKED', 6, 'g aw k t', 4], ['UNGOWN', 6, 'g aw n', 3], ['UNGOWNED', 8, 'g aw n d', 4], ['DEGAUSS', 7, 'g aw s', 3], ['RIGOUT', 6, 'g aw t', 3], ['RIGOUTS', 7, 'g aw t s', 4], ['ZINGARO', 7, 'g ax', 2], ['MANGOLD', 7, 'g ax l d', 4], ['REGALS', 6, 'g ax l z', 4], ['SYNTAGM', 7, 'g ax m', 3], ['SORGHUMS', 8, 'g ax m z', 4], ['YATAGHAN', 8, 'g ax n', 3], ['WAGONED', 7, 'g ax n d', 4], ['LIGANDS', 7, 'g ax n d z', 5], ['YOUNGER', 7, 'g ax r', 3], ['YOUNGERS', 8, 'g ax r z', 4], ['VEGAS', 5, 'g ax s', 3], ['FUNGUSED', 8, 'g ax s t', 4], ['AUGUSTS', 7, 'g ax s t s', 5], ['YOGURT', 6, 'g ax t', 3], ['YOGURTS', 7, 'g ax t s', 4], ['YOUNGERS', 8, 'g ax z', 3], ['GUIDES', 6, 'g ay d z', 4], ['GUILES', 6, 'g ay l z', 4], ['GUISED', 6, 'g ay z d', 4], ['WINGATE', 7, 'g eh', 2], ['GELD', 4, 'g eh l d', 4], ['GELDS', 5, 'g eh l d z', 5], ['GEMSHORN', 8, 'g eh m', 3], ['GEMSBOKS', 8, 'g eh m z', 4], ['GENGHIS', 7, 'g eh n', 3], ['AGAINST', 7, 'g eh n s t', 5], ['GHENT', 5, 'g eh n t', 4], ['AGAINS', 6, 'g eh n z', 4], ['GUESS', 5, 'g eh s', 3], ["GUESTS'", 7, 'g eh s t s', 5], ['GETS', 4, 'g eh t s', 4], ['UNGIRDED', 8, 'g er', 2], ['UNGIRD', 6, 'g er d', 3], ['GIRDS', 5, 'g er d z', 4], ['MCGURN', 6, 'g er n', 3], ["MCGURN'S", 8, 'g er n z', 4], ['RIGEUR', 6, 'g er r', 3], ['SEA-GIRT', 8, 'g er t', 3], ['GIRTH', 5, 'g er th', 3], ['GIRTHS', 6, 'g er th s', 4], ['GIRTHED', 7, 'g er th t', 4], ['GIRVAN', 6, 'g er v', 3], ["SIGUR'S", 7, 'g er z', 3], ['UNGAGED', 7, 'g ey jh d', 4], ['ZINGALE', 7, 'g ey l', 3], ['REGALES', 7, 'g ey l z', 4], ['MOORGAME', 8, 'g ey m', 3], ['GAMED', 5, 'g ey m d', 4], ['UNGAINLY', 8, 'g ey n', 3], ['GAPE', 4, 'g ey p', 3], ['GAPES', 5, 'g ey p s', 4], ['GAPED', 5, 'g ey p t', 4], ['WINGATE', 7, 'g ey t', 3], ['GAVE', 4, 'g ey v', 3], ['STARGAZE', 8, 'g ey z', 3], ['LEGHORN', 7, 'g hh ao n', 4], ['FOGHORNS', 8, 'g hh ao n z', 5], ['DOGHOUSE', 8, 'g hh aw s', 4], ['PIGHEAD', 7, 'g hh eh d', 4], ['EGGHEADS', 8, 'g hh eh d z', 5], ['PLUGHOLE', 8, 'g hh ow l', 4], ['GEARED', 6, 'g ia d', 3], ['YOGISM', 6, 'g ih', 2], ["GIBBS'S", 7, 'g ih b', 3], ['GIBBS', 5, 'g ih b z', 4], ['GIFTING', 7, 'g ih f', 3], ['GIFT', 4, 'g ih f t', 4], ['GIFTS', 5, 'g ih f t s', 5], ['MORTGAGE', 8, 'g ih jh', 3], ['PELASGIC', 8, 'g ih k', 3], ['AGOGICS', 7, 'g ih k s', 4], ['SCARGILL', 8, 'g ih l', 3], ['REGILD', 6, 'g ih l d', 4], ['REGILDS', 7, 'g ih l d z', 5], ['MEGILP', 6, 'g ih l p', 4], ['REGILT', 6, 'g ih l t', 4], ['GUILTS', 6, 'g ih l t s', 5], ['GIMPING', 7, 'g ih m', 3], ['GIMP', 4, 'g ih m p', 4], ['GIMPED', 6, 'g ih m p t', 5], ['WIGGINS', 7, 'g ih n z', 4], ['WIGGINGS', 8, 'g ih ng z', 4], ['GIP', 3, 'g ih p', 3], ['HAGGIS', 6, 'g ih s', 3], ['YOUNGEST', 8, 'g ih s t', 4], ['WIGGISH', 7, 'g ih sh', 3], ['TARGET', 6, 'g ih t', 3], ["TARGETS'", 8, 'g ih t s', 4], ['GIVES', 5, 'g ih v z', 4], ['YOGIS', 5, 'g ih z', 3], ['WHANGEE', 7, 'g iy', 2], ['GEESE', 5, 'g iy s', 3], ['LOG-JAM', 7, 'g jh ae m', 4], ['LOG-JAMS', 8, 'g jh ae m z', 5], ['WRIGGLE', 7, 'g l', 2], ['GLANCED', 7, 'g l aa n s t', 6], ['GLASSED', 7, 'g l aa s t', 5], ["GLAXO'S", 7, 'g l ae k', 4], ['FOGLAMP', 7, 'g l ae m p', 5], ['FOGLAMPS', 8, 'g l ae m p s', 6], ['GLANTON', 7, 'g l ae n', 4], ['GLAND', 5, 'g l ae n d', 5], ['GLANDS', 6, 'g l ae n d z', 6], ["GLANTZ'S", 8, 'g l ae n t', 5], ['GLANTZ', 6, 'g l ae n t s', 6], ['GLUCK', 5, 'g l ah k', 4], ["GLUCK'S", 7, 'g l ah k s', 5], ['GLUMPY', 6, 'g l ah m', 4], ['GLUTTONY', 8, 'g l ah t', 4], ['GLUTS', 5, 'g l ah t s', 5], ['UNGLOVE', 7, 'g l ah v', 4], ['UNGLOVED', 8, 'g l ah v d', 5], ['GLOVES', 6, 'g l ah v z', 5], ['GLUSBURN', 8, 'g l ah z', 4], ['GLOWERS', 7, 'g l aw', 3], ['WRIGGLER', 8, 'g l ax', 3], ['RAGLAN', 6, 'g l ax n', 4], ['RINGLAND', 8, 'g l ax n d', 5], ['RAGLANS', 7, 'g l ax n z', 5], ['WRIGGLER', 8, 'g l ax r', 4], ['WIGGLERS', 8, 'g l ax r z', 5], ['LEGLESS', 7, 'g l ax s', 4], ['GLYCOLS', 7, 'g l ay', 3], ['GLIDES', 6, 'g l ay d z', 5], ['DOG-LIKE', 8, 'g l ay k', 4], ['WRIGGLED', 8, 'g l d', 3], ['GLARED', 6, 'g l ea d', 4], ['GLARE', 5, 'g l ea r', 4], ['GLARES', 6, 'g l ea z', 4], ['GLENNY', 6, 'g l eh', 3], ['NEGLECTS', 8, 'g l eh k t s', 6], ['GLENS', 5, 'g l eh n z', 5], ['GLADE', 5, 'g l ey d', 4], ['GLADES', 6, 'g l ey d z', 5], ['GLAIVE', 6, 'g l ey v', 4], ['GLAIVED', 7, 'g l ey v d', 5], ['GLAIVES', 7, 'g l ey v z', 5], ['UNGLAZE', 7, 'g l ey z', 4], ['UNGLAZED', 8, 'g l ey z d', 5], ['GANGLION', 8, 'g l ia n', 4], ['UGLIER', 6, 'g l ia r', 4], ['WRIGGLY', 7, 'g l ih', 3], ['GLIBNESS', 8, 'g l ih b', 4], ['TRIGLYPH', 8, 'g l ih f', 4], ['GLIMPSE', 7, 'g l ih m p s', 6], ['GLINT', 5, 'g l ih n t', 5], ['GLINTS', 6, 'g l ih n t s', 6], ['TINGLISH', 8, 'g l ih sh', 4], ['SINGLET', 7, 'g l ih t', 4], ['SINGLETS', 8, 'g l ih t s', 5], ['UGLIES', 6, 'g l ih z', 4], ['NEGLIGE', 7, 'g l iy', 3], ['GLEBE', 5, 'g l iy b', 4], ['GLEBES', 6, 'g l iy b z', 5], ['FIG-LEAF', 8, 'g l iy f', 4], ['GLEAM', 5, 'g l iy m', 4], ['GLEAMED', 7, 'g l iy m d', 5], ['GLEAMS', 6, 'g l iy m z', 5], ['GLEAN', 5, 'g l iy n', 4], ['GLEANED', 7, 'g l iy n d', 5], ['GLEANS', 6, 'g l iy n z', 5], ['GLEES', 5, 'g l iy z', 4], ['ISOGLOSS', 8, 'g l oh s', 4], ['GLOSSED', 7, 'g l oh s t', 5], ['POLYGLOT', 8, 'g l oh t', 4], ['UNGLOBE', 7, 'g l ow b', 4], ['GLOBED', 6, 'g l ow b d', 5], ['GLOBES', 6, 'g l ow b z', 5], ['GLOWED', 6, 'g l ow d', 4], ['GLOAT', 5, 'g l ow t', 4], ['GLOATS', 6, 'g l ow t s', 5], ['GLOZE', 5, 'g l ow z', 4], ['GLOZED', 6, 'g l ow z d', 5], ['UNGLUED', 7, 'g l uw d', 4], ['GLOOM', 5, 'g l uw m', 4], ['GLOOMED', 7, 'g l uw m d', 5], ['GLOOMS', 6, 'g l uw m z', 5], ['IGLOOS', 6, 'g l uw z', 4], ['WRIGGLES', 8, 'g l z', 3], ['UNGODLY', 7, 'g oh', 2], ['GOB', 3, 'g oh b', 3], ['GOBS', 4, 'g oh b z', 4], ['WAR-GOD', 7, 'g oh d', 3], ['WAR-GODS', 8, 'g oh d z', 4], ['GOGH', 4, 'g oh f', 3], ["GOGH'S", 6, 'g oh f s', 4], ['GOCH', 4, 'g oh k', 3], ['GOLKAR', 6, 'g oh l', 3], ['GOLFS', 5, 'g oh l f s', 5], ['GOLFED', 6, 'g oh l f t', 5], ['ARGOLS', 6, 'g oh l z', 4], ["SAIGON'S", 8, 'g oh n z', 4], ['GONGING', 7, 'g oh ng', 3], ['GONGED', 6, 'g oh ng d', 4], ['GONGS', 5, 'g oh ng z', 4], ['LAGOS', 5, 'g oh s', 3], ['GOSH', 4, 'g oh sh', 3], ['UNGOTTEN', 8, 'g oh t', 3], ['VISIGOTH', 8, 'g oh th', 3], ["ARGO'S", 6, 'g oh z', 3], ['ZYGOMATA', 8, 'g ow', 2], ['UNDERGOD', 8, 'g ow d', 3], ['GOADS', 5, 'g ow d z', 4], ['GOLKAR', 6, 'g ow l', 3], ['MARIGOLD', 8, 'g ow l d', 4], ["GOLD'S", 6, 'g ow l d s', 5], ['GOALS', 5, 'g ow l z', 4], ['EPIGONE', 7, 'g ow n', 3], ['GHOST', 5, 'g ow s t', 4], ['GHOSTS', 6, 'g ow s t s', 5], ['GAUCHE', 6, 'g ow sh', 3], ['SHE-GOAT', 8, 'g ow t', 3], ['VIRGOS', 6, 'g ow z', 3], ['GOITROUS', 8, 'g oy', 2], ['FUNGOID', 7, 'g oy d', 3], ['FUNGOIDS', 8, 'g oy d z', 4], ['GARGOYLE', 8, 'g oy l', 3], ['GRANTORS', 8, 'g r aa n', 4], ['GRANTZ', 6, 'g r aa n t s', 6], ['GRANDES', 7, 'g r aa n z', 5], ['UNGRACE', 7, 'g r aa s', 4], ['GRASP', 5, 'g r aa s p', 5], ['GRASPS', 6, 'g r aa s p s', 6], ['GRASPED', 7, 'g r aa s p t', 6], ['GRASSED', 7, 'g r aa s t', 5], ['GRAZ', 4, 'g r aa t s', 5], ['GRAVED', 6, 'g r aa v d', 5], ['GRAVES', 6, 'g r aa v z', 5], ['GRAB', 4, 'g r ae b', 4], ['GRABBED', 7, 'g r ae b d', 5], ['GRABS', 5, 'g r ae b z', 5], ['TAGRAG', 6, 'g r ae g', 4], ['TONOGRAM', 8, 'g r ae m', 4], ["GRANZ'S", 7, 'g r ae n', 4], ['GRANDES', 7, 'g r ae n d z', 6], ['GRAPNELS', 8, 'g r ae p', 4], ['GRUBB', 5, 'g r ah b', 4], ['GRUBS', 5, 'g r ah b z', 5], ['GRUFFS', 6, 'g r ah f s', 5], ['GRUFFED', 7, 'g r ah f t', 5], ['GRUDGE', 6, 'g r ah jh', 4], ['GRUMPS', 6, 'g r ah m p s', 6], ['GRUMPED', 7, 'g r ah m p t', 6], ['SEAGRAMS', 8, 'g r ah m z', 5], ['GRUNT', 5, 'g r ah n t', 5], ['GRUNTS', 6, 'g r ah n t s', 6], ['GROUCH', 6, 'g r aw ch', 4], ['GROUCHED', 8, 'g r aw ch t', 5], ['GROWL', 5, 'g r aw l', 4], ['GROWLED', 7, 'g r aw l d', 5], ['GROWLS', 6, 'g r aw l z', 5], ['UNGROUND', 8, 'g r aw n d', 5], ['GROUSE', 6, 'g r aw s', 4], ['GROUSED', 7, 'g r aw s t', 5], ['SANGREL', 7, 'g r ax l', 4], ['MONGRELS', 8, 'g r ax l z', 5], ['POGROM', 6, 'g r ax m', 4], ['POGROMED', 8, 'g r ax m d', 5], ['POGROMS', 7, 'g r ax m z', 5], ['VAGRANCE', 8, 'g r ax n s', 5], ['VAGRANT', 7, 'g r ax n t', 5], ['VAGRANTS', 8, 'g r ax n t s', 6], ['GRIPERS', 7, 'g r ay', 3], ['GRIMES', 6, 'g r ay m z', 5], ['GRINDS', 6, 'g r ay n d z', 6], ['GRIPEN', 6, 'g r ay p', 4], ['GRIPES', 6, 'g r ay p s', 5], ['GRIPED', 6, 'g r ay p t', 5], ['ZAGREB', 6, 'g r eh b', 4], ["ZAGREB'S", 8, 'g r eh b z', 5], ['GREGG', 5, 'g r eh g', 4], ['GREGGS', 6, 'g r eh g z', 5], ['GREMLINS', 8, 'g r eh m', 4], ['GRENCH', 6, 'g r eh n ch', 5], ['UPGRADE', 7, 'g r ey d', 4], ['UPGRADES', 8, 'g r ey d z', 5], ['GRAIL', 5, 'g r ey l', 4], ['GRAILS', 6, 'g r ey l z', 5], ['UNGRAIN', 7, 'g r ey n', 4], ['GRAPES', 6, 'g r ey p s', 5], ['GRAPED', 6, 'g r ey p t', 5], ['UNGRACED', 8, 'g r ey s t', 5], ['UNGRAVED', 8, 'g r ey v d', 5], ['GRAZED', 6, 'g r ey z d', 5], ['HUNGRIER', 8, 'g r ia', 3], ['UGRIAN', 6, 'g r ia n', 4], ['HUNGRIER', 8, 'g r ia r', 4], ['INGRID', 6, 'g r ih d', 4], ['GRIDS', 5, 'g r ih d z', 5], ['GRIFTING', 8, 'g r ih f', 4], ["GRIGGS'S", 8, 'g r ih g', 4], ['GRIGGS', 6, 'g r ih g z', 5], ['GRILSES', 7, 'g r ih l', 4], ['GRILLED', 7, 'g r ih l d', 5], ['GRILSE', 6, 'g r ih l s', 5], ['GRILLS', 6, 'g r ih l z', 5], ['PILGRIM', 7, 'g r ih m', 4], ['TIGRINE', 7, 'g r ih n', 4], ['GRINNED', 7, 'g r ih n d', 5], ['GRINGOS', 7, 'g r ih ng', 4], ['HANDGRIP', 8, 'g r ih p', 4], ['GRIPPED', 7, 'g r ih p t', 5], ['GRIST', 5, 'g r ih s t', 5], ['GRISTS', 6, 'g r ih s t s', 6], ['MARGARET', 8, 'g r ih t', 4], ['PEDIGREE', 8, 'g r iy', 3], ['GREBE', 5, 'g r iy b', 4], ['GREBES', 6, 'g r iy b z', 5], ['GREEDS', 6, 'g r iy d z', 5], ['GRIEFF', 6, 'g r iy f', 4], ['GRIEFS', 6, 'g r iy f s', 5], ['GREEK', 5, 'g r iy k', 4], ["GREEKS'", 7, 'g r iy k s', 5], ['GRIPPE', 6, 'g r iy p', 4], ['GRIPPES', 7, 'g r iy p s', 5], ['GREASE', 6, 'g r iy s', 4], ['GREASED', 7, 'g r iy s t', 5], ['GREET', 5, 'g r iy t', 4], ['GREETS', 6, 'g r iy t s', 5], ['GRIEVE', 6, 'g r iy v', 4], ['GRIEVED', 7, 'g r iy v d', 5], ['GRIEVES', 7, 'g r iy v z', 5], ['GROG', 4, 'g r oh g', 4], ['GROMWELL', 8, 'g r oh m', 4], ['GROT', 4, 'g r oh t', 4], ['GROTS', 5, 'g r oh t s', 5], ['GROWED', 6, 'g r ow d', 4], ['UNGROWN', 7, 'g r ow n', 4], ['GROANED', 7, 'g r ow n d', 5], ['GROANS', 6, 'g r ow n z', 5], ['GROPE', 5, 'g r ow p', 4], ['GROPES', 6, 'g r ow p s', 5], ['GROPED', 6, 'g r ow p t', 5], ['UNGROSS', 7, 'g r ow s', 4], ['GROSSED', 7, 'g r ow s t', 5], ['GROAT', 5, 'g r ow t', 4], ['GROATS', 6, 'g r ow t s', 5], ['GROVED', 6, 'g r ow v d', 5], ['NEGROID', 7, 'g r oy d', 4], ['NEGROIDS', 8, 'g r oy d z', 5], ['GROYNE', 6, 'g r oy n', 4], ['GROINED', 7, 'g r oy n d', 5], ['GROYNES', 7, 'g r oy n z', 5], ['GROOM', 5, 'g r uw m', 4], ['GROOMS', 6, 'g r uw m z', 5], ['SUBGROUP', 8, 'g r uw p', 4], ['GROOVE', 6, 'g r uw v', 4], ['GROOVED', 7, 'g r uw v d', 5], ['GROOVES', 7, 'g r uw v z', 5], ['LANGUR', 6, 'g ua', 2], ['GOURG', 5, 'g ua d', 3], ['GOURDS', 6, 'g ua d z', 4], ['LANGUR', 6, 'g ua r', 3], ['LANGURS', 7, 'g ua z', 3], ['GURUS', 5, 'g uh', 2], ['GOODS', 5, 'g uh d z', 4], ['GULDENS', 7, 'g uh l', 3], ['TAEGU', 5, 'g uw', 2], ['GOOF', 4, 'g uw f', 3], ['GOOFS', 5, 'g uw f s', 4], ['GOOFED', 6, 'g uw f t', 4], ['GOULD', 5, 'g uw l d', 4], ['GOULDS', 6, 'g uw l d z', 5], ['GHOULS', 6, 'g uw l z', 4], ['SHOGUN', 6, 'g uw n', 3], ['SHOGUNS', 7, 'g uw n z', 4], ['MONGOOSE', 8, 'g uw s', 3], ['GOOSED', 6, 'g uw s t', 4], ['RAGOUTS', 7, 'g uw z', 3], ['GUAM', 4, 'g w aa m', 4], ["GUAM'S", 6, 'g w aa m z', 5], ['WIGWAM', 6, 'g w ae m', 4], ['WIGWAMS', 7, 'g w ae m z', 5], ['MUGWUMP', 7, 'g w ah m p', 5], ['MUGWUMPS', 8, 'g w ah m p s', 6], ['LINGUALS', 8, 'g w ax l z', 5], ['UNGUENT', 7, 'g w ax n t', 5], ['UNGUENTS', 8, 'g w ax n t s', 6], ['MIGUEL', 6, 'g w eh l', 4], ["MIGUEL'S", 8, 'g w eh l z', 5], ['GWENT', 5, 'g w eh n t', 5], ["GWEN'S", 6, 'g w eh n z', 5], ['PINGUID', 7, 'g w ih d', 4], ['BIGWIG', 6, 'g w ih g', 4], ['BIGWIGS', 7, 'g w ih g z', 5], ['COGWHEEL', 8, 'g w iy l', 4], ['DOGWATCH', 8, 'g w oh ch', 4], ['PIGWASH', 7, 'g w oh sh', 4], ['HOGWOOD', 7, 'g w uh d', 4], ['MAGYAR', 6, 'g y aa', 3], ['MAGYAR', 6, 'g y aa r', 4], ['MAGYARS', 7, 'g y aa z', 4], ["ZAGURY'S", 8, 'g y er', 3], ['GYOHTEN', 7, 'g y ow', 3], ['MANAGUA', 7, 'g y ua r', 4], ['ARGUERS', 7, 'g y uh z', 4], ['UNARGUED', 8, 'g y uw d', 4], ['VIRGULE', 7, 'g y uw l', 4], ['VIRGULES', 8, 'g y uw l z', 5], ['LEGUME', 6, 'g y uw m', 4], ['LEGUMES', 7, 'g y uw m z', 5], ['ARGUES', 6, 'g y uw z', 4], ["H'MMING", 7, 'hh', 1], ['JIHAD', 5, 'hh aa d', 3], ['JIHADS', 6, 'hh aa d z', 4], ["HALF'S", 6, 'hh aa f s', 4], ['HAFT', 4, 'hh aa f t', 4], ["HAFTS'", 6, 'hh aa f t s', 5], ['HARK', 4, 'hh aa k', 3], ['HARKS', 5, 'hh aa k s', 4], ['HARKED', 6, 'hh aa k t', 4], ['HARMED', 6, 'hh aa m d', 4], ['HARMS', 5, 'hh aa m z', 4], ['WUHAN', 5, 'hh aa n', 3], ['HARPS', 5, 'hh aa p s', 4], ['HARPED', 6, 'hh aa p t', 4], ['GERHARD', 7, 'hh aa r d', 4], ['GERHARDT', 8, 'hh aa r t', 4], ['HASP', 4, 'hh aa s p', 4], ['HASPS', 5, 'hh aa s p s', 5], ['HASPED', 6, 'hh aa s p t', 5], ['HARSH', 5, 'hh aa sh', 3], ['HEARTS', 6, 'hh aa t s', 4], ['HEARTH', 6, 'hh aa th', 3], ['HEARTHS', 7, 'hh aa th s', 4], ['HALVE', 5, 'hh aa v', 3], ['HALVED', 6, 'hh aa v d', 4], ['HALVES', 6, 'hh aa v z', 4], ['YAMAHAS', 7, 'hh aa z', 3], ['HATCHED', 7, 'hh ae ch t', 4], ["HADN'T", 6, 'hh ae d', 3], ['HADST', 5, 'hh ae d s t', 5], ['HAGBERRY', 8, 'hh ae g', 3], ['HAGS', 4, 'hh ae g z', 4], ['HACKSAWS', 8, 'hh ae k', 3], ['HACKS', 5, 'hh ae k s', 4], ['HACKED', 6, 'hh ae k t', 4], ['HAMMED', 6, 'hh ae m d', 4], ['HAMS', 4, 'hh ae m z', 4], ['HANGED', 6, 'hh ae ng d', 4], ["HANKS'S", 7, 'hh ae ng k', 4], ["HANKS'", 6, 'hh ae ng k s', 5], ['HANKED', 6, 'hh ae ng k t', 5], ['PERHAPS', 7, 'hh ae p s', 4], ['HAPPED', 6, 'hh ae p t', 4], ['HAST', 4, 'hh ae s t', 4], ['HASTES', 6, 'hh ae s t s', 5], ['REHASH', 6, 'hh ae sh', 3], ['REHASHED', 8, 'hh ae sh t', 4], ['SHOHAT', 6, 'hh ae t', 3], ['HATH', 4, 'hh ae th', 3], ["HAVEN'T", 7, 'hh ae v', 3], ['HAVES', 5, 'hh ae v z', 4], ['HUB', 3, 'hh ah b', 3], ['HUBS', 4, 'hh ah b z', 4], ['HUTCH', 5, 'hh ah ch', 3], ['HUTCHED', 7, 'hh ah ch t', 4], ['HUDSONS', 7, 'hh ah d', 3], ['HUFF', 4, 'hh ah f', 3], ['HUFFS', 5, 'hh ah f s', 4], ['HUFFED', 6, 'hh ah f t', 4], ['HUG', 3, 'hh ah g', 3], ['HUGGED', 6, 'hh ah g d', 4], ['HUGS', 4, 'hh ah g z', 4], ['SOLIHULL', 8, 'hh ah l', 3], ['HULLED', 6, 'hh ah l d', 4], ['HULK', 4, 'hh ah l k', 4], ['HULKS', 5, 'hh ah l k s', 5], ['HULKED', 6, 'hh ah l k t', 5], ['HULLS', 5, 'hh ah l z', 4], ['HUMPY', 5, 'hh ah m', 3], ['HUMMED', 6, 'hh ah m d', 4], ['HUMPTY', 6, 'hh ah m p', 4], ['HUMPH', 5, 'hh ah m p f', 5], ['HUMPS', 5, 'hh ah m p s', 5], ['HUMPED', 6, 'hh ah m p t', 5], ['HUMS', 4, 'hh ah m z', 4], ['HUNCHED', 7, 'hh ah n ch t', 5], ['HUNTSMEN', 8, 'hh ah n t', 4], ["HUNTS'", 6, 'hh ah n t s', 5], ['HUNS', 4, 'hh ah n z', 4], ['HUNK', 4, 'hh ah ng k', 4], ['HUNKS', 5, 'hh ah ng k s', 5], ["HUNG'S", 6, 'hh ah ng z', 4], ['HUSK', 4, 'hh ah s k', 4], ['HUSKS', 5, 'hh ah s k s', 5], ['HUSKED', 6, 'hh ah s k t', 5], ['HUSH', 4, 'hh ah sh', 3], ['HUSHED', 6, 'hh ah sh t', 4], ['HUTMENTS', 8, 'hh ah t', 3], ['HUTS', 4, 'hh ah t s', 4], ['WHORED', 6, 'hh ao d', 3], ['HORDES', 6, 'hh ao d z', 4], ['TOMAHAWK', 8, 'hh ao k', 3], ['OVERHAUL', 8, 'hh ao l', 3], ['HALT', 4, 'hh ao l t', 4], ['HALTS', 5, 'hh ao l t s', 5], ['HAULM', 5, 'hh ao m', 3], ['SHOEHORN', 8, 'hh ao n', 3], ['HAUNCH', 6, 'hh ao n ch', 4], ['HAUNCHED', 8, 'hh ao n ch t', 5], ['HAUNT', 5, 'hh ao n t', 4], ['HAUNTS', 6, 'hh ao n t s', 5], ['WHORE', 5, 'hh ao r', 3], ['WHORED', 6, 'hh ao r d', 4], ["WHORE'S", 7, 'hh ao r z', 4], ['WARHORSE', 8, 'hh ao s', 3], ['HORSED', 6, 'hh ao s t', 4], ['COHORTS', 7, 'hh ao t s', 4], ['WHORES', 6, 'hh ao z', 3], ['HOWL', 4, 'hh aw l', 3], ['HOWLED', 6, 'hh aw l d', 4], ['HOWLS', 5, 'hh aw l z', 4], ['HOUNSLOW', 8, 'hh aw n', 3], ['HOUND', 5, 'hh aw n d', 4], ['HOUNDS', 6, 'hh aw n d z', 5], ['MAHOUT', 6, 'hh aw t', 3], ['MAHOUTS', 7, 'hh aw t s', 4], ["H'M", 3, 'hh ax m', 3], ["H'MMED", 6, 'hh ax m d', 4], ["H'MS", 4, 'hh ax m z', 4], ['SABAHAN', 7, 'hh ax n', 3], ['SABAHANS', 8, 'hh ax n z', 4], ['ARHAT', 5, 'hh ax t', 3], ['ARHATS', 6, 'hh ax t s', 4], ['RAWHIDES', 8, 'hh ay d z', 4], ['HYTHE', 5, 'hh ay dh', 3], ['HYPHENS', 7, 'hh ay f', 3], ['HIKE', 4, 'hh ay k', 3], ['HIKES', 5, 'hh ay k s', 4], ['HIKED', 5, 'hh ay k t', 4], ['ANAHEIM', 7, 'hh ay m', 3], ['HINDHEAD', 8, 'hh ay n', 3], ['HINDS', 5, 'hh ay n d z', 5], ['HYPE', 4, 'hh ay p', 3], ["HYPE'S", 6, 'hh ay p s', 4], ['HEIGHTS', 7, 'hh ay t s', 4], ['HIVE', 4, 'hh ay v', 3], ['HIVED', 5, 'hh ay v d', 4], ['HIVES', 5, 'hh ay v z', 4], ['MOHAIR', 6, 'hh ea', 2], ['MOHAIR', 6, 'hh ea r', 3], ['HAIRED', 6, 'hh ea r d', 4], ['MOHAIRS', 7, 'hh ea r z', 4], ['MOHAIRS', 7, 'hh ea z', 3], ['WARHEADS', 8, 'hh eh d z', 4], ['HEFTY', 5, 'hh eh f', 3], ['HEDGED', 6, 'hh eh jh d', 4], ['HEXHAM', 6, 'hh eh k', 3], ['HECKS', 5, 'hh eh k s', 4], ['HELLED', 6, 'hh eh l d', 4], ["HELD'S", 6, 'hh eh l d z', 5], ["HELMS'S", 7, 'hh eh l m', 4], ['HELMED', 6, 'hh eh l m d', 5], ['HELMSMEN', 8, 'hh eh l m z', 5], ['HELENS', 6, 'hh eh l n z', 5], ['HELPS', 5, 'hh eh l p s', 5], ['HELPED', 6, 'hh eh l p t', 5], ['HELTON', 6, 'hh eh l t', 4], ['HEALTHS', 7, 'hh eh l th s', 5], ['HELVE', 5, 'hh eh l v', 4], ['HELVED', 6, 'hh eh l v d', 5], ['HELVES', 6, 'hh eh l v z', 5], ['HELLS', 5, 'hh eh l z', 4], ['MAYHEM', 6, 'hh eh m', 3], ['HEMMED', 6, 'hh eh m d', 4], ["HEMP'S", 6, 'hh eh m p s', 5], ['MAYHEMS', 7, 'hh eh m z', 4], ['WATERHEN', 8, 'hh eh n', 3], ['HENCHMEN', 8, 'hh eh n ch', 4], ['HENKELS', 7, 'hh eh ng', 3], ['HESS', 4, 'hh eh s', 3], ['BEHEST', 6, 'hh eh s t', 4], ['BEHESTS', 7, 'hh eh s t s', 5], ['SUPERHET', 8, 'hh eh t', 3], ['HERBED', 6, 'hh er b d', 4], ['HERBS', 5, 'hh er b z', 4], ['REHEARD', 7, 'hh er d', 3], ["HURD'S", 6, 'hh er d z', 4], ['HURL', 4, 'hh er l', 3], ['HURLED', 6, 'hh er l d', 4], ['HURLS', 5, 'hh er l z', 4], ['HER', 3, 'hh er r', 3], ['REHEARSE', 8, 'hh er s', 3], ["HURST'S", 7, 'hh er s t s', 5], ['HURTS', 5, 'hh er t s', 4], ['HERS', 4, 'hh er z', 3], ['HERSED', 6, 'hh er z d', 4], ['HADE', 4, 'hh ey d', 3], ['HAIG', 4, 'hh ey g', 3], ["HAIG'S", 6, 'hh ey g z', 4], ['HAKE', 4, 'hh ey k', 3], ['HAILED', 6, 'hh ey l d', 4], ["HALE'S", 6, 'hh ey l z', 4], ['HASTE', 5, 'hh ey s t', 4], ['HASTES', 6, 'hh ey s t s', 5], ['HATES', 5, 'hh ey t s', 4], ['NEWHAVEN', 8, 'hh ey v', 3], ['HAZE', 4, 'hh ey z', 3], ['HAZED', 5, 'hh ey z d', 4], ['COHERED', 7, 'hh ia d', 3], ['REHEAR', 6, 'hh ia r', 3], ['REHEARS', 7, 'hh ia z', 3], ['HEARSED', 7, 'hh ia z d', 4], ['HIB', 3, 'hh ih b', 3], ['HITCH', 5, 'hh ih ch', 3], ['HITCHED', 7, 'hh ih ch t', 4], ['HIDDEN', 6, 'hh ih d', 3], ["HIGBEE'S", 8, 'hh ih g', 3], ['HICKSON', 7, 'hh ih k', 3], ['HICKS', 5, 'hh ih k s', 4], ['HILLED', 6, 'hh ih l d', 4], ["HILTON'S", 8, 'hh ih l t', 4], ['HILTS', 5, 'hh ih l t s', 5], ['HILLS', 5, 'hh ih l z', 4], ['HYMNED', 6, 'hh ih m d', 4], ['HYMNS', 5, 'hh ih m z', 4], ["HINTON'S", 8, 'hh ih n', 3], ['HINGE', 5, 'hh ih n jh', 4], ['HINGED', 6, 'hh ih n jh d', 5], ['HINT', 4, 'hh ih n t', 4], ['HINTS', 5, 'hh ih n t s', 5], ['HINZ', 4, 'hh ih n z', 4], ['HINGHAM', 7, 'hh ih ng m', 4], ['HIPS', 4, 'hh ih p s', 4], ['HISS', 4, 'hh ih s', 3], ['HIST', 4, 'hh ih s t', 4], ['HITS', 4, 'hh ih t s', 4], ["LEAHY'S", 7, 'hh ih z', 3], ['HEEDS', 5, 'hh iy d z', 4], ['HEATHENS', 8, 'hh iy dh', 3], ['HEEL', 4, 'hh iy l', 3], ['HEELED', 6, 'hh iy l d', 4], ['HEELS', 5, 'hh iy l z', 4], ['IBRAHIM', 7, 'hh iy m', 3], ['FELLAHIN', 8, 'hh iy n', 3], ['HEAP', 4, 'hh iy p', 3], ['HEAPS', 5, 'hh iy p s', 4], ['HEAPED', 6, 'hh iy p t', 4], ['HEATH', 5, 'hh iy th', 3], ['HEATHS', 6, 'hh iy th s', 4], ['HEAVE', 5, 'hh iy v', 3], ['HEAVED', 6, 'hh iy v d', 4], ['HEAVES', 6, 'hh iy v z', 4], ['SPAHIS', 6, 'hh iy z', 3], ["H'M", 3, 'hh m', 2], ["H'MMED", 6, 'hh m d', 3], ["H'MS", 4, 'hh m z', 3], ["HOBSON'S", 8, 'hh oh b', 3], ['HOBS', 4, 'hh oh b z', 4], ['HODMEN', 6, 'hh oh d', 3], ['HODS', 4, 'hh oh d z', 4], ['HOGGED', 6, 'hh oh g d', 4], ['HOGS', 4, 'hh oh g z', 4], ['HOGSED', 6, 'hh oh g z d', 5], ['HOUGH', 5, 'hh oh k', 3], ['HOUGHS', 6, 'hh oh k s', 4], ['HOCKED', 6, 'hh oh k t', 4], ['ALCOHOLS', 8, 'hh oh l z', 4], ['HOMBURGS', 8, 'hh oh m', 3], ['HONKING', 7, 'hh oh ng', 3], ['HONK', 4, 'hh oh ng k', 4], ['HONKS', 5, 'hh oh ng k s', 5], ['HONKED', 6, 'hh oh ng k t', 5], ["HONG'S", 6, 'hh oh ng z', 4], ['HOPS', 4, 'hh oh p s', 4], ['HOPPED', 6, 'hh oh p t', 4], ["HORNER'S", 8, 'hh oh r', 3], ["HOARE'S", 7, 'hh oh r z', 4], ['HOSP', 4, 'hh oh s p', 4], ['HUHEHOT', 7, 'hh oh t', 3], ['HOTS', 4, 'hh oh t s', 4], ['HOSNI', 5, 'hh oh z', 3], ['WHOLLY', 6, 'hh ow', 2], ['HOED', 4, 'hh ow d', 3], ['HOAXING', 7, 'hh ow k', 3], ['HOAX', 4, 'hh ow k s', 4], ['HOAXED', 6, 'hh ow k s t', 5], ['WORMHOLE', 8, 'hh ow l', 3], ['TOEHOLDS', 8, 'hh ow l d z', 5], ['HOLT', 4, 'hh ow l t', 4], ["HOLT'S", 6, 'hh ow l t s', 5], ['HOMED', 5, 'hh ow m d', 4], ['HONE', 4, 'hh ow n', 3], ['HONED', 5, 'hh ow n d', 4], ['HONES', 5, 'hh ow n z', 4], ['HOPEFULS', 8, 'hh ow p', 3], ['HOPES', 5, 'hh ow p s', 4], ['HOPED', 5, 'hh ow p t', 4], ['HOST', 4, 'hh ow s t', 4], ["HOSTS'", 6, 'hh ow s t s', 5], ['HOVE', 4, 'hh ow v', 3], ['BEHOVED', 7, 'hh ow v d', 4], ['BEHOVES', 7, 'hh ow v z', 4], ["SOHO'S", 6, 'hh ow z', 3], ['HOSED', 5, 'hh ow z d', 4], ['HOYDENS', 7, 'hh oy d', 3], ['HOIK', 4, 'hh oy k', 3], ['HOIST', 5, 'hh oy s t', 4], ['HOISTS', 6, 'hh oy s t s', 5], ['HOURIS', 6, 'hh ua', 2], ['HUZZAS', 6, 'hh uh', 2], ['HOOKED', 6, 'hh uh k t', 4], ['HAMHUNG', 7, 'hh uh ng', 3], ['YAHOO', 5, 'hh uw', 2], ['HOOCH', 5, 'hh uw ch', 3], ["WHO'D", 5, 'hh uw d', 3], ['HOOF', 4, 'hh uw f', 3], ['HOOFS', 5, 'hh uw f s', 4], ['HOOFED', 6, 'hh uw f t', 4], ["WHO'LL", 6, 'hh uw l', 3], ['WHOOP', 5, 'hh uw p', 3], ['WHOOPS', 6, 'hh uw p s', 4], ['WHOOPED', 7, 'hh uw p t', 4], ['AARHUS', 6, 'hh uw s', 3], ['HOOT', 4, 'hh uw t', 3], ['HOOTS', 5, 'hh uw t s', 4], ["WHO'VE", 6, 'hh uw v', 3], ['HOOVES', 6, 'hh uw v z', 4], ['YAHOOS', 6, 'hh uw z', 3], ["JUANA'S", 7, 'hh w aa', 3], ['JUAN', 4, 'hh w aa n', 4], ["JUAN'S", 6, 'hh w aa n z', 5], ['HWAINAN', 7, 'hh w ay', 3], ['HUED', 4, 'hh y uw d', 4], ['HUGE', 4, 'hh y uw jh', 4], ['HUMIAN', 6, 'hh y uw m', 4], ["HUME'S", 6, 'hh y uw m z', 5], ['HEWN', 4, 'hh y uw n', 4], ['MAYHEWS', 7, 'hh y uw z', 4], ['ZAIREANS', 8, 'ia', 1], ['ZAIRE', 5, 'ia r', 2], ['ZAIRES', 6, 'ia r z', 3], ['ZAIRES', 6, 'ia z', 2], ['ITCH', 4, 'ih ch', 2], ['ITCHED', 6, 'ih ch t', 3], ['NEREID', 6, 'ih d', 2], ['NEREIDS', 7, 'ih d z', 3], ['IF', 2, 'ih f', 2], ['IFS', 3, 'ih f s', 3], ['VOYAGE', 6, 'ih jh', 2], ['VOYAGED', 7, 'ih jh d', 3], ['ZOIC', 4, 'ih k', 2], ['ILKESTON', 8, 'ih l k', 3], ['ILLS', 4, 'ih l z', 3], ['IMPSON', 6, 'ih m p', 3], ['IMPS', 4, 'ih m p s', 4], ['INCH', 4, 'ih n ch', 3], ['INCHED', 6, 'ih n ch t', 4], ['RUINED', 6, 'ih n d', 3], ['ENGEMAN', 7, 'ih n jh', 3], ['INKSTONE', 8, 'ih n k', 3], ['INST', 4, 'ih n s t', 4], ['INKED', 5, 'ih ng k t', 4], ['TENUIS', 6, 'ih s', 2], ['ZIPPIEST', 8, 'ih s t', 3], ['THEISTS', 7, 'ih s t s', 4], ['ISTHMIAN', 8, 'ih s th', 3], ['YOUNGISH', 8, 'ih sh', 2], ['STRIATES', 8, 'ih t s', 3], ['DOETH', 5, 'ih th', 2], ["ZAGURY'S", 8, 'ih z', 2], ['EACH', 4, 'iy ch', 2], ['SAYEED', 6, 'iy d', 2], ["SAYEED'S", 8, 'iy d z', 3], ['EKE', 3, 'iy k', 2], ['EKES', 4, 'iy k s', 3], ['EKED', 4, 'iy k t', 3], ['EEL', 3, 'iy l', 2], ['EELS', 4, 'iy l z', 3], ['PYAEMIA', 7, 'iy m', 2], ['EASTES', 6, 'iy s t s', 4], ['WINGATE', 7, 'iy t', 2], ['EATS', 4, 'iy t s', 3], ['NAIVE', 5, 'iy v', 2], ['EVES', 4, 'iy v z', 3], ["WINERY'S", 8, 'iy z', 2], ['EASED', 5, 'iy z d', 3], ['PYJAMAS', 7, 'jh aa', 2], ['JARRED', 6, 'jh aa d', 3], ["JOHN'S", 6, 'jh aa n s', 4], ["JARVIS'S", 8, 'jh aa r', 3], ['JARS', 4, 'jh aa z', 3], ['PUNJAB', 6, 'jh ae b', 3], ['JABBED', 6, 'jh ae b d', 4], ["PUNJAB'S", 8, 'jh ae b z', 4], ['JAFFNA', 6, 'jh ae f', 3], ['JAGGED', 6, 'jh ae g d', 4], ['JAGS', 4, 'jh ae g z', 4], ['JACKED', 6, 'jh ae k t', 4], ['JAMPOTS', 7, 'jh ae m', 3], ['JAMMED', 6, 'jh ae m d', 4], ['JIMJAMS', 7, 'jh ae m z', 4], ['JANGULA', 7, 'jh ae ng', 3], ['JAZZ', 4, 'jh ae z', 3], ['JAZZED', 6, 'jh ae z d', 4], ['TOBY-JUG', 8, 'jh ah g', 3], ['JUGGED', 6, 'jh ah g d', 4], ['SKI-JUMP', 8, 'jh ah m p', 4], ['JUMPED', 6, 'jh ah m p t', 5], ['JUNTOS', 6, 'jh ah n', 3], ['JUNKY', 5, 'jh ah ng', 3], ['JUNKS', 5, 'jh ah ng k s', 5], ['JUNKED', 6, 'jh ah ng k t', 5], ['JUS', 3, 'jh ah s', 3], ['JUT', 3, 'jh ah t', 3], ['JUTS', 4, 'jh ah t s', 4], ['GEORGE', 6, 'jh ao jh', 3], ['JAUNTY', 6, 'jh ao n', 3], ['JAUNT', 5, 'jh ao n t', 4], ['JAUNTS', 6, 'jh ao n t s', 5], ['JOWLY', 5, 'jh aw', 2], ['JOWL', 4, 'jh aw l', 3], ['JOWLED', 6, 'jh aw l d', 4], ['JOWLS', 5, 'jh aw l z', 4], ['JOUST', 5, 'jh aw s t', 4], ['JOUSTS', 6, 'jh aw s t s', 5], ['WAGERED', 7, 'jh ax d', 3], ['GUDGEL', 6, 'jh ax l', 3], ['CUDGELED', 8, 'jh ax l d', 4], ['CUDGELS', 7, 'jh ax l z', 4], ['WIDGEON', 7, 'jh ax n', 3], ['LEGENDS', 7, 'jh ax n d z', 5], ['VERGENCE', 8, 'jh ax n s', 4], ['VERGENT', 7, 'jh ax n t', 4], ['TANGENTS', 8, 'jh ax n t s', 5], ['WIDGEONS', 8, 'jh ax n z', 4], ['WIDGER', 6, 'jh ax r', 3], ['GUDGET', 6, 'jh ax t', 3], ['BUDGETS', 7, 'jh ax t s', 4], ['VAGINAS', 7, 'jh ay', 2], ['JIBE', 4, 'jh ay b', 3], ['JIBED', 5, 'jh ay b d', 4], ['JIBES', 5, 'jh ay b z', 4], ['FRAGILE', 7, 'jh ay l', 3], ['GILES', 5, 'jh ay l z', 4], ['OGIVE', 5, 'jh ay v', 3], ['OGIVED', 6, 'jh ay v d', 4], ['JIVES', 5, 'jh ay v z', 4], ['JEDBURGH', 8, 'jh eh d', 3], ['JEFF', 4, 'jh eh f', 3], ["JEFF'S", 6, 'jh eh f s', 4], ['TRAJECTS', 8, 'jh eh k t s', 5], ['JELL', 4, 'jh eh l', 3], ['JELLED', 6, 'jh eh l d', 4], ['JELLS', 5, 'jh eh l z', 4], ['GEMMED', 6, 'jh eh m d', 4], ['GEMS', 4, 'jh eh m z', 4], ['GENTS', 5, 'jh eh n t s', 5], ["JEPSON'S", 8, 'jh eh p', 3], ['LARGESSE', 8, 'jh eh s', 3], ['SUGGESTS', 8, 'jh eh s t s', 5], ['TURBOJET', 8, 'jh eh t', 3], ['JERK', 4, 'jh er k', 3], ['JERKS', 5, 'jh er k s', 4], ['JERKED', 6, 'jh er k t', 4], ['GERM', 4, 'jh er m', 3], ['GERMS', 5, 'jh er m z', 4], ['SOJOURN', 7, 'jh er n', 3], ['ADJOURNS', 8, 'jh er n z', 4], ['POPINJAY', 8, 'jh ey', 2], ['JAKE', 4, 'jh ey k', 3], ['JAKES', 5, 'jh ey k s', 4], ['JAILED', 6, 'jh ey l d', 4], ['JAILS', 5, 'jh ey l z', 4], ['JAMESES', 7, 'jh ey m', 3], ['JAMES', 5, 'jh ey m z', 4], ['JAYNE', 5, 'jh ey n', 3], ['JAYNES', 6, 'jh ey n z', 4], ['JAPE', 4, 'jh ey p', 3], ['JAPES', 5, 'jh ey p s', 4], ['HEDGEHOG', 8, 'jh hh oh g', 4], ['HEDGEHOP', 8, 'jh hh oh p', 4], ['JEERED', 6, 'jh ia d', 3], ['SWINGIER', 8, 'jh ia r', 3], ["JEER'S", 6, 'jh ia r z', 4], ['LOGGIAS', 7, 'jh ia z', 3], ['ZOOLOGY', 7, 'jh ih', 2], ['JIBBED', 6, 'jh ih b d', 4], ['JIBS', 4, 'jh ih b z', 4], ['UNFRIGID', 8, 'jh ih d', 3], ['REJIGGED', 8, 'jh ih g d', 4], ['KARADZIC', 8, 'jh ih jh', 3], ['ZOOLOGIC', 8, 'jh ih k', 3], ['VIRGIL', 6, 'jh ih l', 3], ['GILLED', 6, 'jh ih l d', 4], ['JILT', 4, 'jh ih l t', 4], ['JILTS', 5, 'jh ih l t s', 5], ["VIRGIL'S", 8, 'jh ih l z', 4], ['JIM_CROW', 8, 'jh ih m', 3], ['JIMPSON', 7, 'jh ih m p', 4], ["JIM'S", 5, 'jh ih m z', 4], ['VIRGINS', 7, 'jh ih n z', 4], ['WEDGING', 7, 'jh ih ng', 3], ['JINXING', 7, 'jh ih ng k', 4], ['JINX', 4, 'jh ih ng k s', 5], ['JINKED', 6, 'jh ih ng k t', 5], ['GYPSYING', 8, 'jh ih p', 3], ['GYPS', 4, 'jh ih p s', 4], ['GYPPED', 6, 'jh ih p t', 4], ["EGYPT'S", 7, 'jh ih p t s', 5], ['REGIS', 5, 'jh ih s', 3], ['LARGISH', 7, 'jh ih sh', 3], ['PUGET', 5, 'jh ih t', 3], ["PUGET'S", 7, 'jh ih t s', 4], ['CONGEALS', 8, 'jh iy l z', 4], ['JEANED', 6, 'jh iy n d', 4], ['JEEP', 4, 'jh iy p', 3], ['JEEPS', 5, 'jh iy p s', 4], ['JEEPED', 6, 'jh iy p t', 4], ['NIGEL', 5, 'jh l', 2], ['AGELONG', 7, 'jh l oh ng', 4], ["RANGEL'S", 8, 'jh l z', 3], ['PEJORITY', 8, 'jh oh', 2], ["JOBS'S", 6, 'jh oh b', 3], ['JOBBED', 6, 'jh oh b d', 4], ['JOBS', 4, 'jh oh b z', 4], ['JODHPURS', 8, 'jh oh d', 3], ['JOGGED', 6, 'jh oh g d', 4], ['JOGS', 4, 'jh oh g z', 4], ['JON', 3, 'jh oh n', 3], ['MAHJONG', 7, 'jh oh ng', 3], ['MAHJONGS', 8, 'jh oh ng z', 4], ['JOSS', 4, 'jh oh s', 3], ['JOSH', 4, 'jh oh sh', 3], ['JOSHED', 6, 'jh oh sh t', 4], ['JOT', 3, 'jh oh t', 3], ['JOTS', 4, 'jh oh t s', 4], ['JUJO', 4, 'jh ow', 2], ["JOBS'S", 6, 'jh ow b', 3], ['JOBS', 4, 'jh ow b z', 4], ['JOKE', 4, 'jh ow k', 3], ['JOKES', 5, 'jh ow k s', 4], ['JOKED', 5, 'jh ow k t', 4], ['JOLTY', 5, 'jh ow l', 3], ['CAJOLED', 7, 'jh ow l d', 4], ['JOLT', 4, 'jh ow l t', 4], ['JOLTS', 5, 'jh ow l t s', 5], ['CAJOLES', 7, 'jh ow l z', 4], ['JONESES', 7, 'jh ow n', 3], ['JONES', 5, 'jh ow n z', 4], ['JOVE', 4, 'jh ow v', 3], ['JOES', 4, 'jh ow z', 3], ['REJOINS', 7, 'jh oy n z', 4], ['REJOICE', 7, 'jh oy s', 3], ['REJOICED', 8, 'jh oy s t', 4], ['JOISTS', 6, 'jh oy s t s', 5], ['OVERJOYS', 8, 'jh oy z', 3], ['SAVAGERY', 8, 'jh r ih', 3], ['HEDGEROW', 8, 'jh r ow', 3], ['PADUA', 5, 'jh ua', 2], ['ADJURED', 7, 'jh ua d', 3], ['ADJURE', 6, 'jh ua r', 3], ['ADJURES', 7, 'jh ua z', 3], ['JUJUBE', 6, 'jh uw b', 3], ['JUJUBES', 7, 'jh uw b z', 4], ['JOULE', 5, 'jh uw l', 3], ['JOULES', 6, 'jh uw l z', 4], ['JUNE', 4, 'jh uw n', 3], ['JUNES', 5, 'jh uw n z', 4], ['VERJUICE', 8, 'jh uw s', 3], ['JUICED', 6, 'jh uw s t', 4], ['JUTE', 4, 'jh uw t', 3], ['EULOGIUM', 8, 'jh y ax m', 4], ['KANGYO', 6, 'jh y ow', 3], ["KANGYO'S", 8, 'jh y ow z', 4], ['MANGES', 6, 'jh z', 2], ['KVASS', 5, 'k', 1], ['UNCARTED', 8, 'k aa', 2], ['TIMECARD', 8, 'k aa d', 3], ['CALF', 4, 'k aa f', 3], ["CALF'S", 6, 'k aa f s', 4], ['CALFED', 6, 'k aa f t', 4], ["CALFED'S", 8, 'k aa f t s', 5], ['LOCALE', 6, 'k aa l', 3], ['LOCALES', 7, 'k aa l z', 4], ['CALMNESS', 8, 'k aa m', 3], ['CALMED', 6, 'k aa m d', 4], ['CALMS', 5, 'k aa m z', 4], ['VICON', 5, 'k aa n', 3], ["CAN'T", 5, 'k aa n t', 4], ["VICON'S", 7, 'k aa n z', 4], ['PERICARP', 8, 'k aa p', 3], ['CARPED', 6, 'k aa p t', 4], ['ROCARD', 6, 'k aa r d', 4], ["ROCARD'S", 8, 'k aa r d z', 5], ['KARL', 4, 'k aa r l', 4], ["KARL'S", 6, 'k aa r l z', 5], ['CASK', 4, 'k aa s k', 4], ['CASKS', 5, 'k aa s k s', 5], ['CASKED', 6, 'k aa s k t', 5], ['WORMCAST', 8, 'k aa s t', 4], ['CARVE', 5, 'k aa v', 3], ['CARVED', 6, 'k aa v d', 4], ['CARVES', 6, 'k aa v z', 4], ['TAXICAB', 7, 'k ae b', 3], ['TAXICABS', 8, 'k ae b z', 4], ['CATCHED', 7, 'k ae ch t', 4], ['CADS', 4, 'k ae d z', 4], ['CAFTANS', 7, 'k ae f', 3], ['CAFFS', 5, 'k ae f s', 4], ['CADGE', 5, 'k ae jh', 3], ['CADGED', 6, 'k ae jh d', 4], ['PICKAXES', 8, 'k ae k', 3], ['PICKAXE', 7, 'k ae k s', 4], ['PICKAXED', 8, 'k ae k s t', 5], ['KALB', 4, 'k ae l b', 4], ['CALXES', 6, 'k ae l k', 4], ['CALX', 4, 'k ae l k s', 5], ['MCCALLUM', 8, 'k ae l m', 4], ["CALTON'S", 8, 'k ae l t', 4], ['KAMP', 4, 'k ae m p', 4], ["KAMP'S", 6, 'k ae m p s', 5], ['CAMS', 4, 'k ae m z', 4], ['CANST', 5, 'k ae n s t', 5], ['RECANT', 6, 'k ae n t', 4], ['RECANTS', 7, 'k ae n t s', 5], ['KANGAS', 6, 'k ae ng', 3], ['JACKASS', 7, 'k ae s', 3], ['CASH', 4, 'k ae sh', 3], ['CASHED', 6, 'k ae sh t', 4], ['WILDCAT', 7, 'k ae t', 3], ['KATH', 4, 'k ae th', 3], ["KAVNER'S", 8, 'k ae v', 3], ['WOLF-CUB', 8, 'k ah b', 3], ['PACKARD', 7, 'k ah d', 3], ['PACKARDS', 8, 'k ah d z', 4], ['CULLED', 6, 'k ah l d', 4], ['CULM', 4, 'k ah l m', 4], ['OCCULT', 6, 'k ah l t', 4], ['OCCULTS', 7, 'k ah l t s', 5], ['WELLCOME', 8, 'k ah m', 3], ['CUNT', 4, 'k ah n t', 4], ['CUNTS', 5, 'k ah n t s', 5], ['MILKENS', 7, 'k ah n z', 4], ['QUINCUNX', 8, 'k ah ng k s', 5], ['WATERCUP', 8, 'k ah p', 3], ['TEACUPS', 7, 'k ah p s', 4], ['PINCUS', 6, 'k ah s', 3], ['CUSP', 4, 'k ah s p', 4], ['CUSPS', 5, 'k ah s p s', 5], ['CUSPED', 6, 'k ah s p t', 5], ['WOODCUT', 7, 'k ah t', 3], ['WOODCUTS', 8, 'k ah t s', 4], ['COVENS', 6, 'k ah v', 3], ["TRUMKA'S", 8, 'k ah z', 3], ['WHIPCORD', 8, 'k ao d', 3], ['UNCORK', 6, 'k ao k', 3], ['UNCORKS', 7, 'k ao k s', 4], ['UNCORKED', 8, 'k ao k t', 4], ['UNCALL', 6, 'k ao l', 3], ['CORM', 4, 'k ao m', 3], ['CORMS', 5, 'k ao m z', 4], ['UNICORN', 7, 'k ao n', 3], ['CORNED', 6, 'k ao n d', 4], ['UNICORNS', 8, 'k ao n z', 4], ['UNICORP', 7, 'k ao p', 3], ['OSHKOSH', 7, 'k ao sh', 3], ["UNICOR'S", 8, 'k ao z', 3], ['CAUSED', 6, 'k ao z d', 4], ['SEA-COW', 7, 'k aw', 2], ['COUCHED', 7, 'k aw ch t', 4], ['COWED', 5, 'k aw d', 3], ['COWL', 4, 'k aw l', 3], ['COWLED', 6, 'k aw l d', 4], ['COWLS', 5, 'k aw l z', 4], ['COUNCE', 6, 'k aw n s', 4], ['WORK-OUT', 8, 'k aw t', 3], ['SEA-COWS', 8, 'k aw z', 3], ['ZENECA', 6, 'k ax', 2], ['KINCOB', 6, 'k ax b', 3], ['JACOBS', 6, 'k ax b z', 4], ['TANKARDS', 8, 'k ax d z', 4], ['ZODIACAL', 8, 'k ax l', 3], ['WYCOMBE', 7, 'k ax m', 3], ['WELCOMED', 8, 'k ax m d', 4], ['WELCOMES', 8, 'k ax m z', 4], ['WOKEN', 5, 'k ax n', 3], ['WEAKENED', 8, 'k ax n d', 4], ['SECONDS', 7, 'k ax n d z', 5], ['VESICANT', 8, 'k ax n t', 4], ['WICKENS', 7, 'k ax n z', 4], ['BACUP', 5, 'k ax p', 3], ['ZENECA', 6, 'k ax r', 3], ["ZENECA'S", 8, 'k ax r z', 4], ['LOCUSTS', 7, 'k ax s t s', 5], ['VELICATE', 8, 'k ax t', 3], ["ZENECA'S", 8, 'k ax z', 3], ['KIBE', 4, 'k ay b', 3], ['MIKHAIL', 7, 'k ay l', 3], ['CHYME', 5, 'k ay m', 3], ['UNKINDLY', 8, 'k ay n', 3], ['MANKINDS', 8, 'k ay n d z', 5], ['CHOC-ICE', 8, 'k ay s', 3], ['KITES', 5, 'k ay t s', 4], ['ARCHIVE', 7, 'k ay v', 3], ['ARCHIVED', 8, 'k ay v d', 4], ['ARCHIVES', 8, 'k ay v z', 4], ['BACKCHAT', 8, 'k ch ae t', 4], ['UNCTUOUS', 8, 'k ch ua s', 4], ['CAIRNED', 7, 'k ea n d', 4], ['CAIRNS', 6, 'k ea n z', 4], ['MEDICARE', 8, 'k ea r', 3], ['KETCH', 5, 'k eh ch', 3], ['KEG', 3, 'k eh g', 3], ['KEGS', 4, 'k eh g z', 4], ['KEDGE', 5, 'k eh jh', 3], ['KEDGED', 6, 'k eh jh d', 4], ['TEKEL', 5, 'k eh l', 3], ['KELP', 4, 'k eh l p', 4], ['KELPED', 6, 'k eh l p t', 5], ['KELTON', 6, 'k eh l t', 4], ['KELTS', 5, 'k eh l t s', 5], ['RAYCHEM', 7, 'k eh m', 3], ["KEMP'S", 6, 'k eh m p s', 5], ['WEEKEND', 7, 'k eh n d', 4], ['WEEKENDS', 8, 'k eh n d z', 5], ['TASHKENT', 8, 'k eh n t', 4], ["KENT'S", 6, 'k eh n t s', 5], ['KENS', 4, 'k eh n z', 4], ['UNKEPT', 6, 'k eh p t', 4], ['ROQUETTE', 8, 'k eh t', 3], ['UNCURB', 6, 'k er b', 3], ['UNCURBED', 8, 'k er b d', 4], ['KERBS', 5, 'k er b z', 4], ['KURDS', 5, 'k er d z', 4], ['UNKIRK', 6, 'k er k', 3], ['UNCURL', 6, 'k er l', 3], ['UNCURLED', 8, 'k er l d', 4], ['KOLN', 4, 'k er l n', 4], ['UNCURLS', 7, 'k er l z', 4], ['KERNELS', 7, 'k er n', 3], ['KERNED', 6, 'k er n d', 4], ['KERNES', 6, 'k er n z', 4], ['REINCUR', 7, 'k er r', 3], ['OCCURED', 7, 'k er r d', 4], ["KERR'S", 6, 'k er r z', 4], ['RECURSE', 7, 'k er s', 3], ['CURST', 5, 'k er s t', 4], ["KURT'S", 6, 'k er t s', 4], ['RECURVE', 7, 'k er v', 3], ['RECURVED', 8, 'k er v d', 4], ['RECURVES', 8, 'k er v z', 4], ['VICKERS', 7, 'k er z', 3], ['RECURSED', 8, 'k er z d', 4], ['VOLCANOS', 8, 'k ey', 2], ['MCCABE', 6, 'k ey b', 3], ["MCCABE'S", 8, 'k ey b z', 4], ['STOCKADE', 8, 'k ey d', 3], ['INCAGE', 6, 'k ey jh', 3], ['INCAGED', 7, 'k ey jh d', 4], ['PANCAKED', 8, 'k ey k t', 4], ['SEAKALE', 7, 'k ey l', 3], ['OVERCAME', 8, 'k ey m', 3], ['CHICANED', 8, 'k ey n d', 4], ['CAPES', 5, 'k ey p s', 4], ['UKASE', 5, 'k ey s', 3], ['CONCAVE', 7, 'k ey v', 3], ['CONCAVED', 8, 'k ey v d', 4], ['CONCAVES', 8, 'k ey v z', 4], ['BACKHAND', 8, 'k hh ae n d', 5], ['BUCKHORN', 8, 'k hh ao n', 4], ['MIKHAIL', 7, 'k hh ay l', 4], ['LOCKHEED', 8, 'k hh iy d', 4], ['SUKHUMI', 7, 'k hh uw', 3], ['KIRSCH', 6, 'k ia sh', 3], ['TRACHEAS', 8, 'k ia z', 3], ['ZINKY', 5, 'k ih', 2], ['KITSCH', 6, 'k ih ch', 3], ['WRECKAGE', 8, 'k ih jh', 3], ['KICKED', 6, 'k ih k t', 4], ['OVERKILL', 8, 'k ih l', 3], ['LIMEKILN', 8, 'k ih l n', 4], ['KILNED', 6, 'k ih l n d', 5], ['KILTON', 6, 'k ih l t', 4], ['KILTS', 5, 'k ih l t s', 5], ['KIMS', 4, 'k ih m z', 4], ['WORK-IN', 7, 'k ih n', 3], ['RIFKIND', 7, 'k ih n d', 4], ['QUINT', 5, 'k ih n t', 4], ['QUINTS', 6, 'k ih n t s', 5], ['YOUNKINS', 8, 'k ih n z', 4], ['ZINCING', 7, 'k ih ng', 3], ['KINK', 4, 'k ih ng k', 4], ['KINKS', 5, 'k ih ng k s', 5], ['KINKED', 6, 'k ih ng k t', 5], ['KIP', 3, 'k ih p', 3], ['KIPS', 4, 'k ih p s', 4], ['KIPPED', 6, 'k ih p t', 4], ['ORCHIS', 6, 'k ih s', 3], ['YORKIST', 7, 'k ih s t', 4], ['WEAKISH', 7, 'k ih sh', 3], ['WICKETT', 7, 'k ih t', 3], ['WICKETS', 7, 'k ih t s', 4], ['KITH', 4, 'k ih th', 3], ['YANKEES', 7, 'k ih z', 3], ['ZUCCHINO', 8, 'k iy', 2], ['KEEFE', 5, 'k iy f', 3], ["KEEFE'S", 7, 'k iy f s', 4], ['KEELE', 5, 'k iy l', 3], ['KEELED', 6, 'k iy l d', 4], ['KEELS', 5, 'k iy l z', 4], ['MCKEAND', 7, 'k iy n d', 4], ['UPKEEP', 6, 'k iy p', 3], ['UPKEEPS', 7, 'k iy p s', 4], ['QUICHE', 6, 'k iy sh', 3], ['PAROQUET', 8, 'k iy t', 3], ['KEITH', 5, 'k iy th', 3], ["KEITH'S", 7, 'k iy th s', 4], ['STICKJAW', 8, 'k jh ao', 3], ['LOCKJAWS', 8, 'k jh ao z', 4], ["\\'ECLAT", 7, 'k l aa', 3], ['CLERKED', 7, 'k l aa k t', 5], ['UNCLASP', 7, 'k l aa s p', 5], ['UNCLASPS', 8, 'k l aa s p s', 6], ['ECLATS', 6, 'k l aa z', 4], ['KLAXONS', 7, 'k l ae k', 4], ['CLAQUES', 7, 'k l ae k s', 5], ['CLACKED', 7, 'k l ae k t', 5], ['CLAMPING', 8, 'k l ae m', 4], ['CLAMMED', 7, 'k l ae m d', 5], ['CLAMPS', 6, 'k l ae m p s', 6], ['CLAMPED', 7, 'k l ae m p t', 6], ['CLAMS', 5, 'k l ae m z', 5], ['CLANSHIP', 8, 'k l ae n', 4], ['CLANNED', 7, 'k l ae n d', 5], ['CLANSMEN', 8, 'k l ae n z', 5], ['CLANGED', 7, 'k l ae ng d', 5], ['CLANK', 5, 'k l ae ng k', 5], ['CLANGS', 6, 'k l ae ng z', 5], ['CLAPSED', 7, 'k l ae p s t', 6], ['CLAPPED', 7, 'k l ae p t', 5], ['CLARENCE', 8, 'k l ae r n s', 6], ['CLASH', 5, 'k l ae sh', 4], ['CLASHED', 7, 'k l ae sh t', 5], ['CLUBBED', 7, 'k l ah b d', 5], ['UNCLUTCH', 8, 'k l ah ch', 4], ['CLOUGH', 6, 'k l ah f', 4], ["CLOUGH'S", 8, 'k l ah f s', 5], ['CLUCK', 5, 'k l ah k', 4], ['CLUCKS', 6, 'k l ah k s', 5], ['CLUCKED', 7, 'k l ah k t', 5], ['CLUMSY', 6, 'k l ah m', 4], ['CLUMP', 5, 'k l ah m p', 5], ['CLUMPS', 6, 'k l ah m p s', 6], ['CLUMPED', 7, 'k l ah m p t', 6], ['BROOKLYN', 8, 'k l ah n', 4], ['CLUNCH', 6, 'k l ah n ch', 5], ['OAKLAND', 7, 'k l ah n d', 5], ['CLUNKY', 6, 'k l ah ng', 4], ['CLUNK', 5, 'k l ah ng k', 5], ["ARKLA'S", 7, 'k l ah z', 4], ['CLAWED', 6, 'k l ao d', 4], ["CLAUDE'S", 8, 'k l ao d z', 5], ['FOLKLORE', 8, 'k l ao r', 4], ['UNCLOUDY', 8, 'k l aw', 3], ['CLOWNE', 6, 'k l aw n', 4], ['CLOWNED', 7, 'k l aw n d', 5], ['CLOWNS', 6, 'k l aw n z', 5], ['KLAUS', 5, 'k l aw s', 4], ['CLOUT', 5, 'k l aw t', 4], ['CLOUTS', 6, 'k l aw t s', 5], ['WINKLER', 7, 'k l ax', 3], ['WICKLAND', 8, 'k l ax n d', 5], ['WINKLER', 7, 'k l ax r', 4], ['YOKELESS', 8, 'k l ax s', 4], ["CLYDE'S", 7, 'k l ay d z', 5], ['RECLIMB', 7, 'k l ay m', 4], ['CLIMBED', 7, 'k l ay m d', 5], ['CLIMES', 6, 'k l ay m z', 5], ['CLIVE', 5, 'k l ay v', 4], ['WRINKLED', 8, 'k l d', 3], ["\\'ECLAIR", 8, 'k l ea', 3], ["\\'ECLAIR", 8, 'k l ea r', 4], ["CLARE'S", 7, 'k l ea r z', 5], ['CLEFTED', 7, 'k l eh f', 4], ['CLEFS', 5, 'k l eh f s', 5], ['CLEFT', 5, 'k l eh f t', 5], ['CLEFTS', 6, 'k l eh f t s', 6], ['CLEG', 4, 'k l eh g', 4], ['CLEM', 4, 'k l eh m', 4], ['CLENCH', 6, 'k l eh n ch', 5], ['YCLEPT', 6, 'k l eh p t', 5], ['CLEVEN', 6, 'k l eh v', 4], ['KLERK', 5, 'k l er k', 4], ["KLERK'S", 7, 'k l er k s', 5], ['CLAYED', 6, 'k l ey d', 4], ['ENCLAVE', 7, 'k l ey v', 4], ['ENCLAVES', 8, 'k l ey v z', 5], ['NUCLEAL', 7, 'k l ia l', 4], ['NUCLEUS', 7, 'k l ia s', 4], ['CLIFTS', 6, 'k l ih f t s', 6], ['CLICKED', 7, 'k l ih k t', 5], ['CLINCH', 6, 'k l ih n ch', 5], ["CLINT'S", 7, 'k l ih n t s', 6], ['CLINGED', 7, 'k l ih ng d', 5], ['CLINK', 5, 'k l ih ng k', 5], ['ECLIPSED', 8, 'k l ih p s t', 6], ['CLIPPED', 7, 'k l ih p t', 5], ['FECKLESS', 8, 'k l ih s', 4], ['TICKLISH', 8, 'k l ih sh', 4], ['WRINKLET', 8, 'k l ih t', 4], ['NECKLETS', 8, 'k l ih t s', 5], ["WEEKLY'S", 8, 'k l ih z', 4], ['CLIQUE', 6, 'k l iy k', 4], ['CLIQUES', 7, 'k l iy k s', 5], ['CLIQUED', 7, 'k l iy k t', 5], ['UNCLEAN', 7, 'k l iy n', 4], ['CLEAT', 5, 'k l iy t', 4], ['CLEATS', 6, 'k l iy t s', 5], ['CLEAVED', 7, 'k l iy v d', 5], ['CLEAVES', 7, 'k l iy v z', 5], ['CLOD', 4, 'k l oh d', 4], ['CLODS', 5, 'k l oh d z', 5], ['HACKLOG', 7, 'k l oh g', 4], ['CLOGGED', 7, 'k l oh g d', 5], ['ECLOGUES', 8, 'k l oh g z', 5], ['CLOCKED', 7, 'k l oh k t', 5], ['WEEKLONG', 8, 'k l oh ng', 4], ['CYCLOPS', 7, 'k l oh p s', 5], ['CLOCHE', 6, 'k l oh sh', 4], ['CLOT', 4, 'k l oh t', 4], ['CLOTS', 5, 'k l oh t s', 5], ['WICKLOW', 7, 'k l ow', 3], ['UNCLOAKS', 8, 'k l ow k s', 5], ['CYCLONE', 7, 'k l ow n', 4], ['CLONED', 6, 'k l ow n d', 5], ['CYCLONES', 8, 'k l ow n z', 5], ['CYCLOPE', 7, 'k l ow p', 4], ['CLOVEN', 6, 'k l ow v', 4], ['CLOVES', 6, 'k l ow v z', 5], ['UNCLOSE', 7, 'k l ow z', 4], ['CYCLOIDS', 8, 'k l oy d z', 5], ['CLOYS', 5, 'k l oy z', 4], ['SECLUDE', 7, 'k l uw d', 4], ['SECLUDES', 8, 'k l uw d z', 5], ['KLUGE', 5, 'k l uw jh', 4], ['SECLUSE', 7, 'k l uw s', 4], ['CLUES', 5, 'k l uw z', 4], ['YOKELS', 6, 'k l z', 3], ['JAKOB', 5, 'k oh b', 3], ['JAKOBS', 6, 'k oh b z', 4], ['KOCH', 4, 'k oh ch', 3], ['PEASECOD', 8, 'k oh d', 3], ['CODS', 4, 'k oh d z', 4], ['TAKEOFFS', 8, 'k oh f s', 4], ['COUGHED', 7, 'k oh f t', 4], ['COGS', 4, 'k oh g z', 4], ['WOODCOCK', 8, 'k oh k', 3], ['COXED', 5, 'k oh k s t', 5], ['UNCOCKED', 8, 'k oh k t', 4], ['DECOCTS', 7, 'k oh k t s', 5], ['PROTOCOL', 8, 'k oh l', 3], ['VIACOM', 6, 'k oh m', 3], ['INACOMP', 7, 'k oh m p', 4], ["VIACOM'S", 8, 'k oh m z', 4], ['YUKON', 5, 'k oh n', 3], ['CONCH', 5, 'k oh n ch', 4], ['CONCHED', 7, 'k oh n ch t', 5], ["SECONDS'", 8, 'k oh n d z', 5], ['CONS', 4, 'k oh n s', 4], ['CONT', 4, 'k oh n t', 4], ['CONTES', 6, 'k oh n t s', 5], ["YUKON'S", 7, 'k oh n z', 4], ['CONK', 4, 'k oh ng k', 4], ['CONKS', 5, 'k oh ng k s', 5], ['CONKED', 6, 'k oh ng k t', 5], ["KONG'S", 6, 'k oh ng z', 4], ['HELICOPT', 8, 'k oh p t', 4], ['WESTCORP', 8, 'k oh r', 3], ['HARCOURT', 8, 'k oh r t', 4], ['MARCOS', 6, 'k oh s', 3], ['COSTS', 5, 'k oh s t s', 5], ['COSH', 4, 'k oh sh', 3], ['COSHED', 6, 'k oh sh t', 4], ['MONOCOTS', 8, 'k oh t s', 4], ['ZHIVKOV', 7, 'k oh v', 3], ["KOBE'S", 6, 'k ow b z', 4], ['COACHED', 7, 'k ow ch t', 4], ['ZIP_CODE', 8, 'k ow d', 3], ['DECOKE', 6, 'k ow k', 3], ['DECOKES', 7, 'k ow k s', 4], ['COAXED', 6, 'k ow k s t', 5], ['DECOKED', 7, 'k ow k t', 4], ['CUCKOLDS', 8, 'k ow l d z', 5], ['COLEMAN', 7, 'k ow l m n', 5], ['COLT', 4, 'k ow l t', 4], ['KOHLES', 6, 'k ow l z', 4], ['TRICONE', 7, 'k ow n', 3], ['CONED', 5, 'k ow n d', 4], ['COPE', 4, 'k ow p', 3], ['COPES', 5, 'k ow p s', 4], ['COPED', 5, 'k ow p t', 4], ['HARCOURT', 8, 'k ow r t', 4], ['COVE', 4, 'k ow v', 3], ['ALCOVED', 7, 'k ow v d', 4], ['COVES', 5, 'k ow v z', 4], ['VOCOID', 6, 'k oy d', 3], ['COIF', 4, 'k oy f', 3], ['COIFS', 5, 'k oy f s', 4], ['COIFED', 6, 'k oy f t', 4], ['UNCOIL', 6, 'k oy l', 3], ['UNCOILED', 8, 'k oy l d', 4], ['UNCOILS', 7, 'k oy l z', 4], ['QUOIN', 5, 'k oy n', 3], ['QUOINED', 7, 'k oy n d', 4], ['QUOINS', 6, 'k oy n z', 4], ['QUOIT', 5, 'k oy t', 3], ['QUOITS', 6, 'k oy t s', 4], ['DECOYS', 6, 'k oy z', 3], ["KRAKOW'S", 8, 'k r aa', 3], ["CRAFT'S", 7, 'k r aa f t z', 6], ['KRAAL', 5, 'k r aa l', 4], ['KRAALS', 6, 'k r aa l z', 5], ["ACCRA'S", 7, 'k r aa z', 4], ['CRABBED', 7, 'k r ae b d', 5], ['CRABS', 5, 'k r ae b z', 5], ['CRATCH', 6, 'k r ae ch', 4], ['KRAFT', 5, 'k r ae f t', 5], ['KRAFTS', 6, 'k r ae f t s', 6], ['CRAGSMEN', 8, 'k r ae g', 4], ['CRAGSMEN', 8, 'k r ae g z', 5], ['CRAMPONS', 8, 'k r ae m', 4], ['CRAMMED', 7, 'k r ae m d', 5], ['CRAMP', 5, 'k r ae m p', 5], ['CRAMPS', 6, 'k r ae m p s', 6], ['CRAMPED', 7, 'k r ae m p t', 6], ['CRAMS', 5, 'k r ae m z', 5], ['CRANKY', 6, 'k r ae ng', 4], ['CRANK', 5, 'k r ae ng k', 5], ['CRAPS', 5, 'k r ae p s', 5], ['CRAPPED', 7, 'k r ae p t', 5], ['CRASS', 5, 'k r ae s', 4], ['THEOCRAT', 8, 'k r ae t', 4], ['CRUTCH', 6, 'k r ah ch', 4], ['CRUTCHED', 8, 'k r ah ch t', 5], ['CRUXES', 6, 'k r ah k', 4], ['CRUX', 4, 'k r ah k s', 5], ['CRUMBED', 7, 'k r ah m d', 5], ['CRUMP', 5, 'k r ah m p', 5], ['CRUMPS', 6, 'k r ah m p s', 6], ['CRUMPED', 7, 'k r ah m p t', 6], ['CRUMBS', 6, 'k r ah m z', 5], ['CRUNCHY', 7, 'k r ah n', 4], ['CRUNCH', 6, 'k r ah n ch', 5], ['KRUPP', 5, 'k r ah p', 4], ["KRUPP'S", 7, 'k r ah p s', 5], ['BANKRUPT', 8, 'k r ah p t', 5], ['INCRUSTS', 8, 'k r ah s t s', 6], ['CRUSH', 5, 'k r ah sh', 4], ['CRUSHED', 7, 'k r ah sh t', 5], ['CRORE', 5, 'k r ao r', 4], ['CRORES', 6, 'k r ao z', 4], ['CROUCH', 6, 'k r aw ch', 4], ['CROUCHED', 8, 'k r aw ch t', 5], ['UNCROWN', 7, 'k r aw n', 4], ['SACRALS', 7, 'k r ax l z', 5], ['FULCRUMS', 8, 'k r ax m z', 5], ['SYNCHRON', 8, 'k r ax n', 4], ['OMICRONS', 8, 'k r ax n z', 5], ['PANCRAS', 7, 'k r ax s', 4], ['WAR-CRY', 7, 'k r ay', 3], ['DECRIBE', 7, 'k r ay b', 4], ['DECRIBED', 8, 'k r ay b d', 5], ['DECRIBES', 8, 'k r ay b z', 5], ['DECRIED', 7, 'k r ay d', 4], ['CRIME', 5, 'k r ay m', 4], ['CRIMED', 6, 'k r ay m d', 5], ['CRIMES', 6, 'k r ay m z', 5], ['NACRINE', 7, 'k r ay n', 4], ['CRIPES', 6, 'k r ay p s', 5], ['CHRIST', 6, 'k r ay s t', 5], ['CHRISTS', 7, 'k r ay s t s', 6], ['NACRITE', 7, 'k r ay t', 4], ['KRAITS', 6, 'k r ay t s', 5], ["KREBS'S", 7, 'k r eh b', 4], ['KREBS', 5, 'k r eh b z', 5], ['CREF', 4, 'k r eh f', 4], ["CREF'S", 6, 'k r eh f s', 5], ['KREMLINS', 8, 'k r eh m', 4], ["KRENZ'S", 7, 'k r eh n', 4], ['KRENZ', 5, 'k r eh n z', 5], ['CREPT', 5, 'k r eh p t', 5], ['CRESTS', 6, 'k r eh s t s', 6], ['CRES', 4, 'k r eh z', 4], ['CRAIG', 5, 'k r ey g', 4], ['CRAIGS', 6, 'k r ey g z', 5], ['MUCKRAKE', 8, 'k r ey k', 4], ['UKRAINE', 7, 'k r ey n', 4], ['CRANED', 6, 'k r ey n d', 5], ['CR\\^EPE', 7, 'k r ey p', 4], ['CREPES', 6, 'k r ey p s', 5], ['CREPED', 6, 'k r ey p t', 5], ['CR\\`ECHE', 8, 'k r ey sh', 4], ['CRAVENS', 7, 'k r ey v', 4], ['CRAVED', 6, 'k r ey v d', 5], ['CRAVES', 6, 'k r ey v z', 5], ['CRAZE', 5, 'k r ey z', 4], ['LOCRIAN', 7, 'k r ia n', 4], ['RECREANT', 8, 'k r ia n t', 5], ['PANCREAS', 8, 'k r ia s', 4], ['UNCRIB', 6, 'k r ih b', 4], ['CRIBBED', 7, 'k r ih b d', 5], ['CRIBS', 5, 'k r ih b z', 5], ['PICRIC', 6, 'k r ih k', 4], ['CRICKS', 6, 'k r ih k s', 5], ['CRICKED', 7, 'k r ih k t', 5], ['CRIMP', 5, 'k r ih m p', 5], ['CRIMPS', 6, 'k r ih m p s', 6], ['CRIMPED', 7, 'k r ih m p t', 6], ['CRIMSONS', 8, 'k r ih m z', 5], ['CRINED', 6, 'k r ih n d', 5], ['CRINGE', 6, 'k r ih n jh', 5], ['CRINKLY', 7, 'k r ih ng', 4], ['CRYPTOS', 7, 'k r ih p', 4], ['CRIPPS', 6, 'k r ih p s', 5], ['CRYPT', 5, 'k r ih p t', 5], ['CRYPTS', 6, 'k r ih p t s', 6], ['DECRESS', 7, 'k r ih s', 4], ['UNCRISP', 7, 'k r ih s p', 5], ['CRISPS', 6, 'k r ih s p s', 6], ['CRISPED', 7, 'k r ih s p t', 6], ['SACRIST', 7, 'k r ih s t', 5], ['SACRISTS', 8, 'k r ih s t s', 6], ['SECRET', 6, 'k r ih t', 4], ['SECRETS', 7, 'k r ih t s', 5], ['CREECH', 6, 'k r iy ch', 4], ['DECREED', 7, 'k r iy d', 4], ['CREEDS', 6, 'k r iy d z', 5], ['CRIEFF', 6, 'k r iy f', 4], ['CREEK', 5, 'k r iy k', 4], ['CREEKS', 6, 'k r iy k s', 5], ['CREAKED', 7, 'k r iy k t', 5], ['CREEL', 5, 'k r iy l', 4], ['CREELS', 6, 'k r iy l z', 5], ['UNCREAM', 7, 'k r iy m', 4], ['CREAMED', 7, 'k r iy m d', 5], ['CREAMS', 6, 'k r iy m z', 5], ['CREEP', 5, 'k r iy p', 4], ['CREEPS', 6, 'k r iy p s', 5], ['CREEPED', 7, 'k r iy p t', 5], ['SECRETE', 7, 'k r iy t', 4], ['SECRETES', 8, 'k r iy t s', 5], ['DECREES', 7, 'k r iy z', 4], ['CROTCH', 6, 'k r oh ch', 4], ['CROTCHED', 8, 'k r oh ch t', 5], ['CROFTS', 6, 'k r oh f t s', 6], ['CROCK', 5, 'k r oh k', 4], ['CROCKS', 6, 'k r oh k s', 5], ['CROCKED', 7, 'k r oh k t', 5], ['CROMPTON', 8, 'k r oh m p', 5], ['MICRON', 6, 'k r oh n', 4], ['MICRONS', 7, 'k r oh n z', 5], ['UNCROSS', 7, 'k r oh s', 4], ['MICROBE', 7, 'k r ow b', 4], ['MICROBES', 8, 'k r ow b z', 5], ['CROAK', 5, 'k r ow k', 4], ['CROAKS', 6, 'k r ow k s', 5], ['CROAKED', 7, 'k r ow k t', 5], ['BANKROLL', 8, 'k r ow l', 4], ['CHROMED', 7, 'k r ow m d', 5], ['CRONE', 5, 'k r ow n', 4], ['CRONES', 6, 'k r ow n z', 5], ['NECROSE', 7, 'k r ow s', 4], ['KREUTZER', 8, 'k r oy t', 4], ['CRUELLY', 7, 'k r ua', 3], ['CRUEL', 5, 'k r ua l', 4], ['CRUELS', 6, 'k r ua l z', 5], ['CROOKING', 8, 'k r uh', 3], ['CROOKS', 6, 'k r uh k s', 5], ['CROOKED', 7, 'k r uh k t', 5], ['CRUDES', 6, 'k r uw d s', 5], ['CRUDES', 6, 'k r uw d z', 5], ['WORKROOM', 8, 'k r uw m', 4], ['CROON', 5, 'k r uw n', 4], ['CROONED', 7, 'k r uw n d', 5], ['CROONS', 6, 'k r uw n z', 5], ['CROUP', 5, 'k r uw p', 4], ['CROUPS', 6, 'k r uw p s', 5], ['RECRUITS', 8, 'k r uw t s', 5], ['CRUSE', 5, 'k r uw z', 4], ['CRUISED', 7, 'k r uw z d', 5], ['KURSAAL', 7, 'k ua', 2], ["COULDN'T", 8, 'k uh d', 3], ['COULDST', 7, 'k uh d s t', 5], ['PENICUIK', 8, 'k uh k', 3], ['UNCOOKED', 8, 'k uh k t', 4], ['KULTURS', 7, 'k uh l', 3], ['KUNMING', 7, 'k uh n', 3], ['KUNG_FU', 7, 'k uh ng', 3], ['CUCKOOED', 8, 'k uw d', 3], ['COOLED', 6, 'k uw l d', 4], ['COOLS', 5, 'k uw l z', 4], ['COOMES', 6, 'k uw m z', 4], ['TYCOON', 6, 'k uw n', 3], ['COCOONED', 8, 'k uw n d', 4], ['TYCOONS', 7, 'k uw n z', 4], ['RECOUPS', 7, 'k uw p s', 4], ['RECOUPED', 8, 'k uw p t', 4], ["COORS'S", 7, 'k uw r', 3], ['COORS', 5, 'k uw r z', 4], ['COOT', 4, 'k uw t', 3], ['COOTS', 5, 'k uw t s', 4], ['TURKUS', 6, 'k uw z', 3], ['QUARK', 5, 'k w aa k', 4], ['QUARKS', 6, 'k w aa k s', 5], ['QUALM', 5, 'k w aa m', 4], ['QUALMED', 7, 'k w aa m d', 5], ['QUALMS', 6, 'k w aa m z', 5], ['KUAN', 4, 'k w aa n', 4], ['FARQUHAR', 8, 'k w aa r', 4], ['QUACKS', 6, 'k w ae k s', 5], ['QUACKED', 7, 'k w ae k t', 5], ['QUANGOS', 7, 'k w ae ng', 4], ['CAKEWALK', 8, 'k w ao k', 4], ['KIRKWALL', 8, 'k w ao l', 4], ['QUALLS', 6, 'k w ao l z', 5], ['QUARTZES', 8, 'k w ao t', 4], ['QUARTZ', 6, 'k w ao t s', 5], ['UNEQUAL', 7, 'k w ax l', 4], ['UNEQUALS', 8, 'k w ax l z', 5], ['SEQUENTS', 8, 'k w ax n t s', 6], ['EQUINE', 6, 'k w ay n', 4], ['EQUINES', 7, 'k w ay n z', 5], ['REQUITE', 7, 'k w ay t', 4], ['REQUITES', 8, 'k w ay t s', 5], ['NECKWEAR', 8, 'k w ea r', 4], ['QUELCH', 6, 'k w eh l ch', 5], ['QUENCH', 6, 'k w eh n ch', 5], ['LIQUESCE', 8, 'k w eh s', 4], ['SEQUEST', 7, 'k w eh s t', 5], ['REQUESTS', 8, 'k w eh s t s', 6], ['QUETZALS', 8, 'k w eh t', 4], ['QUIRKED', 7, 'k w er k t', 5], ['SILKWORM', 8, 'k w er m', 4], ['QUERN', 5, 'k w er n', 4], ['QUERNS', 6, 'k w er n z', 5], ['QUIRTS', 6, 'k w er t s', 5], ['QUAKEFUL', 8, 'k w ey k', 4], ['QUAKES', 6, 'k w ey k s', 5], ['QUAKED', 6, 'k w ey k t', 5], ['QUAYLE', 6, 'k w ey l', 4], ['QUAILED', 7, 'k w ey l d', 5], ['QUAYLES', 7, 'k w ey l z', 5], ['QUEERED', 7, 'k w ia d', 4], ['REQUIEM', 7, 'k w ia m', 4], ['REQUIEMS', 8, 'k w ia m z', 5], ['QUEER', 5, 'k w ia r', 4], ['QUEERS', 6, 'k w ia z', 4], ['UNLIQUID', 8, 'k w ih d', 4], ['QUIDS', 5, 'k w ih d z', 5], ['QUIFF', 5, 'k w ih f', 4], ['QUIFFS', 6, 'k w ih f s', 5], ['QUICKS', 6, 'k w ih k s', 5], ['QUILLED', 7, 'k w ih l d', 5], ['QUILT', 5, 'k w ih l t', 5], ['QUILTS', 6, 'k w ih l t s', 6], ['QUILLS', 6, 'k w ih l z', 5], ['SEQUIM', 6, 'k w ih m', 4], ['SEQUIN', 6, 'k w ih n', 4], ['QUINCH', 6, 'k w ih n ch', 5], ['SEQUINED', 8, 'k w ih n d', 5], ['QUINCE', 6, 'k w ih n s', 5], ['QUINT', 5, 'k w ih n t', 5], ['QUINTS', 6, 'k w ih n t s', 6], ['SEQUINS', 7, 'k w ih n z', 5], ['QUIP', 4, 'k w ih p', 4], ['QUIPS', 5, 'k w ih p s', 5], ['MARQUIS', 7, 'k w ih s', 4], ['VANQUISH', 8, 'k w ih sh', 4], ['UNACQUIT', 8, 'k w ih t', 4], ['QUITS', 5, 'k w ih t s', 5], ['QUIZZED', 7, 'k w ih z d', 5], ['SEQUELAE', 8, 'k w iy', 3], ['SILKWEED', 8, 'k w iy d', 4], ['BEQUEATH', 8, 'k w iy dh', 4], ['QUEENED', 7, 'k w iy n d', 5], ['QUAD', 4, 'k w oh d', 4], ['QUADS', 5, 'k w oh d z', 5], ['QUAFF', 5, 'k w oh f', 4], ['QUAFFS', 6, 'k w oh f s', 5], ['QUASH', 5, 'k w oh sh', 4], ['QUASHED', 7, 'k w oh sh t', 5], ['LOQUAT', 6, 'k w oh t', 4], ['LOQUATS', 7, 'k w oh t s', 5], ['UNQUOTED', 8, 'k w ow', 3], ['UNQUOTE', 7, 'k w ow t', 4], ['UNQUOTES', 8, 'k w ow t s', 5], ['QUOTH', 5, 'k w ow th', 4], ['OAKWOOD', 7, 'k w uh d', 4], ['CLARKIAS', 8, 'k y ax z', 4], ['KUKJE', 5, 'k y eh', 3], ["KUKJE'S", 7, 'k y eh z', 4], ['TOKYO', 5, 'k y ow', 3], ["TOKYO'S", 7, 'k y ow z', 4], ['VACUUM', 6, 'k y ua m', 4], ['VACUUMED', 8, 'k y ua m d', 5], ['VACUUMS', 7, 'k y ua m z', 5], ['EVACUANT', 8, 'k y ua n t', 5], ['VACUOUS', 7, 'k y ua s', 4], ['VINCULUM', 8, 'k y uh', 3], ['VICU~NAS', 8, 'k y uw', 3], ['CUBED', 5, 'k y uw b d', 5], ['QUEUED', 6, 'k y uw d', 4], ['SPICULES', 8, 'k y uw l z', 5], ['CUMULUS', 7, 'k y uw m', 4], ['SYRACUSE', 8, 'k y uw z', 4], ['RECUSED', 7, 'k y uw z d', 5], ['ZONAL', 5, 'l', 1], ['LARCH', 5, 'l aa ch', 3], ['WILLARD', 7, 'l aa d', 3], ['LATHS', 5, 'l aa dh z', 4], ['LAUGHS', 6, 'l aa f s', 4], ['LAUGHED', 7, 'l aa f t', 4], ['LARGS', 5, 'l aa g z', 4], ['SKYLARK', 7, 'l aa k', 3], ['SKYLARKS', 8, 'l aa k s', 4], ['SALAAM', 6, 'l aa m', 3], ['SALAAMED', 8, 'l aa m d', 4], ["\\'ELAN", 6, 'l aa n', 3], ['UHLAND', 6, 'l aa n d', 4], ['LANCED', 6, 'l aa n s t', 5], ['LARNS', 5, 'l aa n z', 4], ['OVERLAST', 8, 'l aa s t', 4], ['LASTS', 5, 'l aa s t s', 5], ['LATH', 4, 'l aa th', 3], ['LATHED', 6, 'l aa th t', 4], ['FUSELAGE', 8, 'l aa zh', 3], ["LABS'S", 6, 'l ae b', 3], ['LABS', 4, 'l ae b z', 4], ['UNLATCH', 7, 'l ae ch', 3], ['POHLAD', 6, 'l ae d', 3], ["POHLAD'S", 8, 'l ae d z', 4], ['PILAFF', 6, 'l ae f', 3], ['PILAFS', 6, 'l ae f s', 4], ['TIME-LAG', 8, 'l ae g', 3], ['LAGGED', 6, 'l ae g d', 4], ['SMILAX', 6, 'l ae k s', 4], ['LAMPREYS', 8, 'l ae m', 3], ['LAMMED', 6, 'l ae m d', 4], ['SUNLAMP', 7, 'l ae m p', 4], ['SUNLAMPS', 8, 'l ae m p s', 5], ['LAMPED', 6, 'l ae m p t', 5], ['LAMS', 4, 'l ae m z', 4], ['PHALANGE', 8, 'l ae n jh', 4], ['GALLANT', 7, 'l ae n t', 4], ['GALLANTS', 8, 'l ae n t s', 5], ['MILANES', 7, 'l ae n z', 4], ['LANKY', 5, 'l ae ng', 3], ['PHALANX', 7, 'l ae ng k s', 5], ["LANG'S", 6, 'l ae ng z', 4], ['RELAPSE', 7, 'l ae p s', 4], ['LASS', 4, 'l ae s', 3], ['LASK', 4, 'l ae s k', 4], ['LAST', 4, 'l ae s t', 4], ["LAST'S", 6, 'l ae s t s', 5], ['UNLASH', 6, 'l ae sh', 3], ['UNLASHED', 8, 'l ae sh t', 4], ['LATVIANS', 8, 'l ae t', 3], ['LAV', 3, 'l ae v', 3], ['LAVS', 4, 'l ae v z', 4], ['PELASGIC', 8, 'l ae z', 3], ["LUFKIN'S", 8, 'l ah f', 3], ['LUFFS', 5, 'l ah f s', 4], ['LUFFED', 6, 'l ah f t', 4], ['LUGGED', 6, 'l ah g d', 4], ['LUGS', 4, 'l ah g z', 4], ['LUXE', 4, 'l ah k s', 4], ['LUCKED', 6, 'l ah k t', 4], ['LULL', 4, 'l ah l', 3], ['LULLED', 6, 'l ah l d', 4], ['LULLS', 5, 'l ah l z', 4], ['GALUMPH', 7, 'l ah m f', 4], ['GALUMPHS', 8, 'l ah m f s', 5], ['LUMPED', 6, 'l ah m p t', 5], ['LUMSDEN', 7, 'l ah m z', 4], ['TRILON', 6, 'l ah n', 3], ['LUNCHED', 7, 'l ah n ch t', 5], ['SHERLUND', 8, 'l ah n d', 4], ['LUNGE', 5, 'l ah n jh', 4], ['LUNGED', 6, 'l ah n jh d', 5], ['LUNGED', 6, 'l ah ng d', 4], ['LUNGS', 5, 'l ah ng z', 4], ['LUSTS', 5, 'l ah s t s', 5], ['LUSH', 4, 'l ah sh', 3], ['LUSHED', 6, 'l ah sh t', 4], ["LUTZ'S", 6, 'l ah t', 3], ['LUTZ', 4, 'l ah t s', 4], ['TRUELOVE', 8, 'l ah v', 3], ['UNLOVED', 7, 'l ah v d', 4], ['VALOREM', 7, 'l ao', 2], ['WARLORD', 7, 'l ao d', 3], ['WARLORDS', 8, 'l ao d z', 4], ['LAWKS', 5, 'l ao k s', 4], ['RELAUNCH', 8, 'l ao n ch', 4], ['LAWNED', 6, 'l ao n d', 4], ['LAWNS', 5, 'l ao n z', 4], ['LORE', 4, 'l ao r', 3], ['GALORES', 7, 'l ao r z', 4], ['VALORES', 7, 'l ao z', 3], ['PILAUED', 7, 'l aw d', 3], ['LOUTH', 5, 'l aw dh', 3], ['LOUNGED', 7, 'l aw n jh d', 5], ['LOUSE', 5, 'l aw s', 3], ['LOUSED', 6, 'l aw s t', 4], ['UMLAUT', 6, 'l aw t', 3], ['UMLAUTS', 7, 'l aw t s', 4], ['LOUSE', 5, 'l aw z', 3], ['LOUSED', 6, 'l aw z d', 4], ['ZOOLOGY', 7, 'l ax', 2], ['ROWLOCKS', 8, 'l ax k s', 4], ['WHILOM', 6, 'l ax m', 3], ['SLALOMED', 8, 'l ax m d', 4], ['VELLUMS', 7, 'l ax m z', 4], ['ZEALAND', 7, 'l ax n d', 4], ['VOLANT', 6, 'l ax n t', 4], ['WOOLLENS', 8, 'l ax n z', 4], ['WALLOP', 6, 'l ax p', 3], ['WALLOPS', 7, 'l ax p s', 4], ['WALLOPED', 8, 'l ax p t', 4], ['ZEALOUS', 7, 'l ax s', 3], ['MOLLUSC', 7, 'l ax s k', 4], ['MOLLUSCS', 8, 'l ax s k s', 5], ['BALLASTS', 8, 'l ax s t s', 5], ['ZEALOT', 6, 'l ax t', 3], ['ZEALOTS', 7, 'l ax t s', 4], ['ELIDES', 6, 'l ay d z', 4], ["LIFE'S", 6, 'l ay f s', 4], ['LIKES', 5, 'l ay k s', 4], ['UNLIKED', 7, 'l ay k t', 4], ['LISLE', 5, 'l ay l', 3], ['LISLES', 6, 'l ay l z', 4], ['LIMED', 5, 'l ay m d', 4], ['LIMES', 5, 'l ay m z', 4], ['UNLINED', 7, 'l ay n d', 4], ['ZOOLITE', 7, 'l ay t', 3], ['LIVES', 5, 'l ay v z', 4], ['RONALDS', 7, 'l d z', 3], ['LAIRED', 6, 'l ea d', 3], ['LAIRDS', 6, 'l ea d z', 4], ['LAIR', 4, 'l ea r', 3], ['LAIRED', 6, 'l ea r d', 4], ["LAIR'S", 6, 'l ea r z', 4], ['LAIRS', 5, 'l ea z', 3], ['UNLED', 5, 'l eh d', 3], ['LEADS', 5, 'l eh d z', 4], ['LT.', 3, 'l eh f', 3], ["LEFF'S", 6, 'l eh f s', 4], ["LEFT'S", 6, 'l eh f t s', 5], ['PROLEG', 6, 'l eh g', 3], ['SEA-LEGS', 8, 'l eh g z', 4], ['LEDGE', 5, 'l eh jh', 3], ['LEDGED', 6, 'l eh jh d', 4], ['ULEX', 4, 'l eh k s', 4], ['TELEXED', 7, 'l eh k s t', 5], ['UNSELECT', 8, 'l eh k t', 4], ['SELECTS', 7, 'l eh k t s', 5], ['TAIL-END', 8, 'l eh n d', 4], ['SMOLENSK', 8, 'l eh n s k', 5], ['RELENTS', 7, 'l eh n t s', 5], ['LENSED', 6, 'l eh n z d', 5], ['LENGTHY', 7, 'l eh ng', 3], ['LENGTH', 6, 'l eh ng th', 4], ['LENGTHS', 7, 'l eh ng th s', 5], ['UNLESS', 6, 'l eh s', 3], ['MOLESTS', 7, 'l eh s t s', 5], ['UNDERLET', 8, 'l eh t', 3], ['TRIOLETS', 8, 'l eh t s', 4], ['LESBIANS', 8, 'l eh z', 3], ["VALERY'S", 8, 'l er', 2], ['LURCH', 5, 'l er ch', 3], ['LURCHED', 7, 'l er ch t', 4], ['WOOLARD', 7, 'l er d', 3], ['LURK', 4, 'l er k', 3], ['LURKS', 5, 'l er k s', 4], ['LURKED', 6, 'l er k t', 4], ['UNLEARN', 7, 'l er n', 3], ['UNLEARNT', 8, 'l er n t', 4], ['UNLEARNS', 8, 'l er n z', 4], ['ALERTS', 6, 'l er t s', 4], ['WAYLAID', 7, 'l ey d', 3], ['LATHE', 5, 'l ey dh', 3], ['LATHED', 6, 'l ey dh d', 4], ['LATHES', 6, 'l ey dh z', 4], ['LAKES', 5, 'l ey k s', 4], ['LAMED', 5, 'l ey m d', 4], ['LAMEDS', 6, 'l ey m d z', 5], ['LAMES', 5, 'l ey m z', 4], ['VILLEIN', 7, 'l ey n', 3], ['VILLEINS', 8, 'l ey n z', 4], ['LAYER', 5, 'l ey r', 3], ['UNLACE', 6, 'l ey s', 3], ['UNLACED', 7, 'l ey s t', 4], ['VIOLATE', 7, 'l ey t', 3], ['VIOLATES', 8, 'l ey t s', 4], ['LAVE', 4, 'l ey v', 3], ['LAVED', 5, 'l ey v d', 4], ['LAVES', 5, 'l ey v z', 4], ['WAYLAYS', 7, 'l ey z', 3], ['LAZED', 5, 'l ey z d', 4], ['KEELHAUL', 8, 'l hh ao l', 4], ['MULHEIM', 7, 'l hh ay m', 4], ['WELLHEAD', 8, 'l hh eh d', 4], ['MOLEHILL', 8, 'l hh ih l', 4], ['BELLHOP', 7, 'l hh oh p', 4], ['BELLHOPS', 8, 'l hh oh p s', 5], ['GIRLHOOD', 8, 'l hh uh d', 4], ['BILLHOOK', 8, 'l hh uh k', 4], ['WOOLLIER', 8, 'l ia', 2], ['LEERED', 6, 'l ia d', 3], ['ILIADS', 6, 'l ia d z', 4], ['FILIAL', 6, 'l ia l', 3], ['WILLIAMS', 8, 'l ia m z', 4], ['WILLIAN', 7, 'l ia n', 3], ['VALIANT', 7, 'l ia n t', 4], ['VALIANTS', 8, 'l ia n t s', 5], ['BILLION', 7, 'l ia ng', 3], ['BILLIONS', 8, 'l ia ng z', 4], ['WOOLLIER', 8, 'l ia r', 3], ['ALIASED', 7, 'l ia s t', 4], ['GALLIOT', 7, 'l ia t', 3], ['ZOOLITIC', 8, 'l ih', 2], ["VALID'S", 7, 'l ih d z', 4], ['LIFTON', 6, 'l ih f', 3], ["LIFFE'S", 7, 'l ih f s', 4], ['SKI-LIFT', 8, 'l ih f t', 4], ['SEELIG', 6, 'l ih g', 3], ["SEELIG'S", 8, 'l ih g z', 4], ['VILLAGE', 7, 'l ih jh', 3], ['WALLICH', 7, 'l ih k', 3], ['RELICTS', 7, 'l ih k t s', 5], ['LILT', 4, 'l ih l t', 4], ['LILTS', 5, 'l ih l t s', 5], ['LIMNED', 6, 'l ih m d', 4], ['LYMPH', 5, 'l ih m f', 4], ['LYMPHS', 6, 'l ih m f s', 5], ['LYMPH', 5, 'l ih m p f', 5], ['LYMPHS', 6, 'l ih m p f s', 6], ['LIMPS', 5, 'l ih m p s', 5], ['LIMPED', 6, 'l ih m p t', 5], ['PRELIMS', 7, 'l ih m z', 4], ['ZEPPELIN', 8, 'l ih n', 3], ['LYNCHED', 7, 'l ih n ch t', 5], ['ROSALIND', 8, 'l ih n d', 4], ['LINKBOYS', 8, 'l ih n k', 4], ['LINTNER', 7, 'l ih n t', 4], ['LINZ', 4, 'l ih n t s', 5], ['YOWLING', 7, 'l ih ng', 3], ['UNLINK', 6, 'l ih ng k', 4], ['UNLINKS', 7, 'l ih ng k s', 5], ['UNLINKED', 8, 'l ih ng k t', 5], ['TULIP', 5, 'l ih p', 3], ['TULIPS', 6, 'l ih p s', 4], ['SOLIPED', 7, 'l ih p t', 4], ['WIRELESS', 8, 'l ih s', 3], ['LISP', 4, 'l ih s p', 4], ['LISPS', 5, 'l ih s p s', 5], ['LISPED', 6, 'l ih s p t', 5], ['WHALISH', 7, 'l ih sh', 3], ['WALLET', 6, 'l ih t', 3], ['WALLETS', 7, 'l ih t s', 4], ['ZOOLITH', 7, 'l ih th', 3], ['RELIVE', 6, 'l ih v', 3], ['RELIVED', 7, 'l ih v d', 4], ['RELIVES', 7, 'l ih v z', 4], ["WYLIE'S", 7, 'l ih z', 3], ['ELISIONS', 8, 'l ih zh', 3], ['WILLEY', 6, 'l iy', 2], ['LIEBMANN', 8, 'l iy b', 3], ['LEECH', 5, 'l iy ch', 3], ['LEECHED', 7, 'l iy ch t', 4], ['LEEDS', 5, 'l iy d z', 4], ['UNBELIEF', 8, 'l iy f', 3], ['LEAFED', 6, 'l iy f t', 4], ['LEAGUE', 6, 'l iy g', 3], ['LEAGUED', 7, 'l iy g d', 4], ['LEAGUES', 7, 'l iy g z', 4], ['LIEGEMEN', 8, 'l iy jh', 3], ['LEEKE', 5, 'l iy k', 3], ['LEEKS', 5, 'l iy k s', 4], ['LEAKED', 6, 'l iy k t', 4], ['LILLE', 5, 'l iy l', 3], ["LEAL'S", 6, 'l iy l z', 4], ['VASELINE', 8, 'l iy n', 3], ['LEANED', 6, 'l iy n d', 4], ['OVERLEAP', 8, 'l iy p', 3], ['LISTS', 5, 'l iy s t s', 5], ['UNLEASH', 7, 'l iy sh', 3], ["\\'ELITE", 7, 'l iy t', 3], ["\\'ELITES", 8, 'l iy t s', 4], ['WHEELIES', 8, 'l iy z', 3], ['LESIONS', 7, 'l iy zh', 3], ['TAILLESS', 8, 'l l ax s', 4], ['WHOLLY', 6, 'l l ih', 3], ['GOALLESS', 8, 'l l ih s', 4], ['YULE-LOG', 8, 'l l oh g', 4], ['LOBSTERS', 8, 'l oh b', 3], ['LOBBED', 6, 'l oh b d', 4], ['LOBS', 4, 'l oh b z', 4], ['LODZ', 4, 'l oh d z', 4], ['SIGOLOFF', 8, 'l oh f', 3], ['LODGED', 6, 'l oh jh d', 4], ['WARLOCK', 7, 'l oh k', 3], ['WARLOCKS', 8, 'l oh k s', 4], ['UNLOCKED', 8, 'l oh k t', 4], ['LOLL', 4, 'l oh l', 3], ['LOLLED', 6, 'l oh l d', 4], ['LOLLS', 5, 'l oh l z', 4], ['SHALOM', 6, 'l oh m', 3], ["SHALOM'S", 8, 'l oh m z', 4], ['LENS', 4, 'l oh n s', 4], ['LENSED', 6, 'l oh n s t', 5], ['SOLONS', 6, 'l oh n z', 4], ['YEARLONG', 8, 'l oh ng', 3], ['PROLONGS', 8, 'l oh ng z', 4], ['ORLOP', 5, 'l oh p', 3], ['ORLOPS', 6, 'l oh p s', 4], ['LOPPED', 6, 'l oh p t', 4], ['OMPHALOS', 8, 'l oh s', 3], ['LOST', 4, 'l oh s t', 4], ['GOLOSH', 6, 'l oh sh', 3], ['GALOSHED', 8, 'l oh sh t', 4], ['SHALLOT', 7, 'l oh t', 3], ['SHALLOTS', 8, 'l oh t s', 4], ['ZORILLO', 7, 'l ow', 2], ['LOBE', 4, 'l ow b', 3], ['LOBED', 5, 'l ow b d', 4], ['LOBES', 5, 'l ow b z', 4], ['YELLOWED', 8, 'l ow d', 3], ['UNLOADS', 7, 'l ow d z', 4], ['LOATHED', 7, 'l ow dh d', 4], ['LOATHES', 7, 'l ow dh z', 4], ['LOAFS', 5, 'l ow f s', 4], ['LOAFED', 6, 'l ow f t', 4], ['LOMB', 4, 'l ow m', 3], ['LOAMED', 6, 'l ow m d', 4], ["LOMB'S", 6, 'l ow m z', 4], ['VIOLONE', 7, 'l ow n', 3], ['LOANED', 6, 'l ow n d', 4], ['LOANS', 5, 'l ow n z', 4], ['LOPE', 4, 'l ow p', 3], ['LOPES', 5, 'l ow p s', 4], ['LOPED', 5, 'l ow p t', 4], ['LOTH', 4, 'l ow th', 3], ['LOAVES', 6, 'l ow v z', 4], ['YELLOWS', 7, 'l ow z', 3], ['SYNALLOY', 8, 'l oy', 2], ['FOWL-RUN', 8, 'l r ah n', 4], ['BULRUSH', 7, 'l r ah sh', 4], ['WALRUSES', 8, 'l r ax', 3], ['WALRUS', 6, 'l r ax s', 4], ['ALREADY', 7, 'l r eh', 3], ["ALLRED'S", 8, 'l r eh d z', 5], ['MILREIS', 7, 'l r ey s', 4], ['OIL-RIG', 7, 'l r ih g', 4], ['OIL-RIGS', 8, 'l r ih g z', 5], ['RAILROAD', 8, 'l r ow d', 4], ['GILROY', 6, 'l r oy', 3], ["GILROY'S", 8, 'l r oy z', 4], ['VELOURS', 7, 'l ua', 2], ['LURED', 5, 'l ua d', 3], ['VELOUR', 6, 'l ua r', 3], ["ALLURE'S", 8, 'l ua r z', 4], ['LURES', 5, 'l ua z', 3], ['OVERLOOK', 8, 'l uh k', 3], ['ZULU', 4, 'l uw', 2], ['LUBE', 4, 'l uw b', 3], ["LUBE'S", 6, 'l uw b z', 4], ['UNDELUDE', 8, 'l uw d', 3], ['MALOUF', 6, 'l uw f', 3], ["MALOUF'S", 8, 'l uw f s', 4], ['LUKE', 4, 'l uw k', 3], ["LUKE'S", 6, 'l uw k s', 4], ['LOOM', 4, 'l uw m', 3], ['LOOMED', 6, 'l uw m d', 4], ['LOOMS', 5, 'l uw m z', 4], ['WALLOON', 7, 'l uw n', 3], ['WALLOONS', 8, 'l uw n z', 4], ['LOOP', 4, 'l uw p', 3], ['LOOPS', 5, 'l uw p s', 4], ['LOOPED', 6, 'l uw p t', 4], ['UNLOOSE', 7, 'l uw s', 3], ['UNLOOSED', 8, 'l uw s t', 4], ['SOLUTES', 7, 'l uw t s', 4], ['DULUTH', 6, 'l uw th', 3], ["DULUTH'S", 8, 'l uw th s', 4], ['ZULUS', 5, 'l uw z', 3], ['LUGE', 4, 'l uw zh', 3], ['HELLWARD', 8, 'l w ax d', 4], ['BULWARK', 7, 'l w ax k', 4], ['BULWARKS', 8, 'l w ax k s', 5], ['STALWART', 8, 'l w ax t', 4], ['ALEWIFE', 7, 'l w ay f', 4], ['OIL-WELL', 8, 'l w eh l', 4], ['WOOLWORK', 8, 'l w er k', 4], ['SPILLWAY', 8, 'l w ey', 3], ['MCELWEE', 7, 'l w iy', 3], ['HALEWOOD', 8, 'l w uh d', 4], ['HALYARD', 7, 'l y ax d', 4], ['HALYARDS', 8, 'l y ax d z', 5], ['UNFILIAL', 8, 'l y ax l', 4], ['MILIEU', 6, 'l y er', 3], ['MILIEUS', 7, 'l y er z', 4], ['DILUENT', 7, 'l y ua n t', 5], ['DILUENTS', 8, 'l y ua n t s', 6], ['COLURES', 7, 'l y ua z', 4], ['VOLUTED', 7, 'l y uw', 3], ['VALUED', 6, 'l y uw d', 4], ['PRELUDES', 8, 'l y uw d z', 5], ['DELUGE', 6, 'l y uw jh', 4], ['DELUGED', 7, 'l y uw jh d', 5], ['PILULE', 6, 'l y uw l', 4], ['VOLUME', 6, 'l y uw m', 4], ['VOLUMED', 7, 'l y uw m d', 5], ['VOLUMES', 7, 'l y uw m z', 5], ['VOLUTE', 6, 'l y uw t', 4], ['VOLUTES', 7, 'l y uw t s', 5], ['VALUES', 6, 'l y uw z', 4], ['ILL-USED', 8, 'l y uw z d', 5], ['WYCOMBE', 7, 'm', 1], ['POMADE', 6, 'm aa d', 3], ['POMADES', 7, 'm aa d z', 4], ['MARJ', 4, 'm aa jh', 3], ['WESTMARK', 8, 'm aa k', 3], ['MARLED', 6, 'm aa l d', 4], ['MALMSEY', 7, 'm aa m', 3], ['IMAMS', 5, 'm aa m z', 4], ["OMAN'S", 6, 'm aa n z', 4], ['OMAR', 4, 'm aa r', 3], ["OMAR'S", 6, 'm aa r z', 4], ['UNMASK', 6, 'm aa s k', 4], ['UNMASKS', 7, 'm aa s k s', 5], ['UNMASKED', 8, 'm aa s k t', 5], ['TOPMAST', 7, 'm aa s t', 4], ['TOPMASTS', 8, 'm aa s t s', 5], ['MARSH', 5, 'm aa sh', 3], ['MART', 4, 'm aa t', 3], ['MARTS', 5, 'm aa t s', 4], ['PANAMAS', 7, 'm aa z', 3], ['NOMAD', 5, 'm ae d', 3], ['NOMADS', 6, 'm ae d z', 4], ['MAGS', 4, 'm ae g z', 4], ['MADGE', 5, 'm ae jh', 3], ['TARMAC', 6, 'm ae k', 3], ['TARMACS', 7, 'm ae k s', 4], ['CLIMAXED', 8, 'm ae k s t', 5], ['MLLE.', 5, 'm ae m', 3], ['YOUNGMAN', 8, 'm ae n', 3], ['UNMANNED', 8, 'm ae n d', 4], ['MANDES', 6, 'm ae n d z', 5], ['ROMANCE', 7, 'm ae n s', 4], ['ROMANCED', 8, 'm ae n s t', 5], ['ROMANSCH', 8, 'm ae n sh', 4], ['MANX', 4, 'm ae ng k s', 5], ['MAPPED', 6, 'm ae p t', 4], ['MASSE', 5, 'm ae s', 3], ['MASC', 4, 'm ae s k', 4], ['MASSED', 6, 'm ae s t', 4], ['MASH', 4, 'm ae sh', 3], ['MASHED', 6, 'm ae sh t', 4], ['TABLEMAT', 8, 'm ae t', 3], ['MATH', 4, 'm ae th', 3], ['MATHS', 5, 'm ae th s', 4], ['MAZDAS', 6, 'm ae z', 3], ['YAMAHAS', 7, 'm ah', 2], ['MUDS', 4, 'm ah d z', 4], ['MUFTIS', 6, 'm ah f', 3], ['MUFFS', 5, 'm ah f s', 4], ['MUFFED', 6, 'm ah f t', 4], ['MUG', 3, 'm ah g', 3], ['MUGGED', 6, 'm ah g d', 4], ['MUGS', 4, 'm ah g z', 4], ['MUCK', 4, 'm ah k', 3], ['MUCKS', 5, 'm ah k s', 4], ['MUCKED', 6, 'm ah k t', 4], ['MULCH', 5, 'm ah l ch', 4], ['MULCHED', 7, 'm ah l ch t', 5], ['MULLED', 6, 'm ah l d', 4], ['MULCTING', 8, 'm ah l k', 4], ['MULCT', 5, 'm ah l k t', 5], ['MULCTS', 6, 'm ah l k t s', 6], ['TUMULT', 6, 'm ah l t', 4], ['TUMULTS', 7, 'm ah l t s', 5], ['MULLS', 5, 'm ah l z', 4], ['MUMP', 4, 'm ah m p', 4], ['MUMPS', 5, 'm ah m p s', 5], ['MUMPED', 6, 'm ah m p t', 5], ['MUMS', 4, 'm ah m z', 4], ['MUNCH', 5, 'm ah n ch', 4], ['MUNCHED', 7, 'm ah n ch t', 5], ['HARMOND', 7, 'm ah n d', 4], ["MONKS'S", 7, 'm ah ng k', 4], ["MONKS'", 6, 'm ah ng k s', 5], ['MONGST', 6, 'm ah ng s t', 5], ['FRAME-UP', 8, 'm ah p', 3], ['MUSS', 4, 'm ah s', 3], ['MUST', 4, 'm ah s t', 4], ['MUSTS', 5, 'm ah s t s', 5], ['MUSH', 4, 'm ah sh', 3], ['MUSHED', 6, 'm ah sh t', 4], ['MUTTONS', 7, 'm ah t', 3], ['MUTTS', 5, 'm ah t s', 4], ["XOMA'S", 6, 'm ah z', 3], ['MORDANTS', 8, 'm ao d', 3], ['MORGUE', 6, 'm ao g', 3], ['MORGUES', 7, 'm ao g z', 4], ['MAULED', 6, 'm ao l d', 4], ['MALTS', 5, 'm ao l t s', 5], ['MAULS', 5, 'm ao l z', 4], ['ROMAUNT', 7, 'm ao n t', 4], ['MOURNS', 6, 'm ao n z', 4], ['SYCAMORE', 8, 'm ao r', 3], ['MOTT', 4, 'm ao t', 3], ['MOWED', 5, 'm aw d', 3], ['MOUTH', 5, 'm aw dh', 3], ['MOUTHS', 6, 'm aw dh z', 4], ['MOUND', 5, 'm aw n d', 4], ['MOUNDS', 6, 'm aw n d z', 5], ['TITMOUSE', 8, 'm aw s', 3], ['MOUSED', 6, 'm aw s t', 4], ['COMB-OUT', 8, 'm aw t', 3], ['MOUTHES', 7, 'm aw th s', 4], ['MOWS', 4, 'm aw z', 3], ['ZYGOMATA', 8, 'm ax', 2], ['YAMMERED', 8, 'm ax d', 3], ['STOMACHS', 8, 'm ax k s', 4], ['TRAMMELS', 8, 'm ax l z', 4], ['ULTIMUM', 7, 'm ax m', 3], ['OPTIMUMS', 8, 'm ax m z', 4], ['YEOMEN', 6, 'm ax n', 3], ['WOMANED', 7, 'm ax n d', 4], ['SIMONDS', 7, 'm ax n d z', 5], ['YEOMANS', 7, 'm ax n z', 4], ['YAMMER', 6, 'm ax r', 3], ['TUMOURED', 8, 'm ax r d', 4], ["WOOMER'S", 8, 'm ax r z', 4], ['DAMASK', 6, 'm ax s k', 4], ['DAMASKS', 7, 'm ax s k s', 5], ['UNIMATE', 7, 'm ax t', 3], ['YARMOUTH', 8, 'm ax th', 3], ['DEMERSED', 8, 'm ax z d', 4], ['MIKE', 4, 'm ay k', 3], ['MIKES', 5, 'm ay k s', 4], ['MILDNESS', 8, 'm ay l d', 4], ['MILES', 5, 'm ay l z', 4], ['REMINDS', 7, 'm ay n d z', 5], ['TITMICE', 7, 'm ay s', 3], ['TERMITES', 8, 'm ay t s', 4], ['MOHAMMED', 8, 'm eh d', 3], ['I._M._F.', 8, 'm eh f', 3], ['NUTMEG', 6, 'm eh g', 3], ['NUTMEGS', 7, 'm eh g z', 4], ["PEMEX'S", 7, 'm eh k', 3], ['TIMEX', 5, 'm eh k s', 4], ['MELKSHAM', 8, 'm eh l k', 4], ['MELTS', 5, 'm eh l t s', 5], ["MEHL'S", 6, 'm eh l z', 4], ['WORKMEN', 7, 'm eh n', 3], ['REMENDS', 7, 'm eh n d z', 5], ['TORMENTS', 8, 'm eh n t s', 5], ['MENK', 4, 'm eh ng k', 4], ['MENKES', 6, 'm eh ng k s', 5], ['MESS', 4, 'm eh s', 3], ['MESSED', 6, 'm eh s t', 4], ['MESHED', 6, 'm eh sh t', 4], ['UNMET', 5, 'm eh t', 3], ['METH', 4, 'm eh th', 3], ['METHS', 5, 'm eh th s', 4], ['ZIMMER', 6, 'm er', 2], ['MYRRHED', 7, 'm er d', 3], ['SUBMERGE', 8, 'm er jh', 3], ['MURK', 4, 'm er k', 3], ['MERCKS', 6, 'm er k s', 4], ['MERCED', 6, 'm er k t', 4], ['MERLE', 5, 'm er l', 3], ['MYRRH', 5, 'm er r', 3], ['MYRRHED', 7, 'm er r d', 4], ['MYRRHS', 6, 'm er r z', 4], ['IMMERSE', 7, 'm er s', 3], ['IMMERSED', 8, 'm er s t', 4], ['MURTON', 6, 'm er t', 3], ['MERTZ', 5, 'm er t s', 4], ['MIRTH', 5, 'm er th', 3], ['MIRTHS', 6, 'm er th s', 4], ['MERV', 4, 'm er v', 3], ['ZIMMERS', 7, 'm er z', 3], ['UNMADE', 6, 'm ey d', 3], ['NIJMEGEN', 8, 'm ey g', 3], ['MAGE', 4, 'm ey jh', 3], ['REMAKES', 7, 'm ey k s', 4], ['VERMEIL', 7, 'm ey l', 3], ['MAIM', 4, 'm ey m', 3], ['MAIMED', 6, 'm ey m d', 4], ['MAIMS', 5, 'm ey m z', 4], ['REMAINED', 8, 'm ey n d', 4], ['MAINZ', 5, 'm ey n t s', 5], ['MACE', 4, 'm ey s', 3], ['GRIMACED', 8, 'm ey s t', 4], ['WORKMATE', 8, 'm ey t', 3], ['MAZED', 5, 'm ey z d', 4], ['WORMIER', 7, 'm ia', 2], ['PREMIUM', 7, 'm ia m', 3], ['PREMIUMS', 8, 'm ia m z', 4], ['SIMIAN', 6, 'm ia n', 3], ['SIMIANS', 7, 'm ia n z', 4], ['WORMIER', 7, 'm ia r', 3], ['TUMID', 5, 'm ih d', 3], ['MIDST', 5, 'm ih d s t', 5], ['MIDSTS', 6, 'm ih d s t s', 6], ['PYRAMIDS', 8, 'm ih d z', 4], ['MIMICKED', 8, 'm ih k d', 4], ['UNMIXED', 7, 'm ih k s t', 5], ["MIXTE'S", 7, 'm ih k s t s', 6], ['MIMICKED', 8, 'm ih k t', 4], ['WINDMILL', 8, 'm ih l', 3], ['MILCH', 5, 'm ih l ch', 4], ['MILKS', 5, 'm ih l k s', 5], ['MILKED', 6, 'm ih l k t', 5], ['MILNROW', 7, 'm ih l n', 4], ['TUMIM', 5, 'm ih m', 3], ['ZEMINDAR', 8, 'm ih n', 3], ['MINCE', 5, 'm ih n s', 4], ['MINSK', 5, 'm ih n s k', 5], ["MINSK'S", 7, 'm ih n s k s', 6], ['MINCED', 6, 'm ih n s t', 5], ['VARMINT', 7, 'm ih n t', 4], ['VARMINTS', 8, 'm ih n t s', 5], ['HELMINTH', 8, 'm ih n th', 4], ["ZEMIN'S", 7, 'm ih n z', 4], ['ZOOMING', 7, 'm ih ng', 3], ['MINXES', 6, 'm ih ng k', 4], ['MINX', 4, 'm ih ng k s', 5], ['MISC', 4, 'm ih s k', 4], ['WORMISH', 7, 'm ih sh', 3], ['VOMIT', 5, 'm ih t', 3], ['VOMITS', 6, 'm ih t s', 4], ['MYTH', 4, 'm ih th', 3], ['MYTHS', 5, 'm ih th s', 4], ['MEEDS', 5, 'm iy d z', 4], ['MEEKNESS', 8, 'm iy k', 3], ['MEEKS', 5, 'm iy k s', 4], ['OATMEALS', 8, 'm iy l z', 4], ['ROMINE', 6, 'm iy n', 3], ['MEANED', 6, 'm iy n d', 4], ['ROMINES', 7, 'm iy n z', 4], ['MEESE', 5, 'm iy s', 3], ['MEATH', 5, 'm iy th', 3], ['REMISED', 7, 'm iy z d', 4], ['HEM', 3, 'm m', 2], ['MOBSTERS', 8, 'm oh b', 3], ['MOBBED', 6, 'm oh b d', 4], ['MOBS', 4, 'm oh b z', 4], ['UNMODERN', 8, 'm oh d', 3], ['MODS', 4, 'm oh d z', 4], ['MOCK', 4, 'm oh k', 3], ['MOCKS', 5, 'm oh k s', 4], ['MOCKED', 6, 'm oh k t', 4], ['THYMOL', 6, 'm oh l', 3], ['MALDON', 6, 'm oh l d', 4], ['MALTBY', 6, 'm oh l t', 4], ['MALVERN', 7, 'm oh l v', 4], ['MOLLS', 5, 'm oh l z', 4], ['VERMONT', 7, 'm oh n t', 4], ['MENTHE', 6, 'm oh n th', 4], ['GNOMONS', 7, 'm oh n z', 4], ['ARMONK', 6, 'm oh ng k', 4], ['MOP', 3, 'm oh p', 3], ['MOPS', 4, 'm oh p s', 4], ['MOPPED', 6, 'm oh p t', 4], ['MORTONS', 7, 'm oh r', 3], ["MOORE'S", 7, 'm oh r z', 4], ['SEISMOS', 7, 'm oh s', 3], ['MOSQUE', 6, 'm oh s k', 4], ['MOSQUES', 7, 'm oh s k s', 5], ['MOSSED', 6, 'm oh s t', 4], ["MOTT'S", 6, 'm oh t s', 4], ['MOTHS', 5, 'm oh th s', 4], ['MOTHED', 6, 'm oh th t', 4], ['ZYMOSIS', 7, 'm ow', 2], ['OUTMODES', 8, 'm ow d z', 4], ['MOKE', 4, 'm ow k', 3], ['MOKES', 5, 'm ow k s', 4], ['UNMOLD', 6, 'm ow l d', 4], ['REMOULDS', 8, 'm ow l d z', 5], ['MOULT', 5, 'm ow l t', 4], ['MOULTS', 6, 'm ow l t s', 5], ['MOLES', 5, 'm ow l z', 4], ['MOWN', 4, 'm ow n', 3], ['MOANED', 6, 'm ow n d', 4], ['MOANS', 5, 'm ow n z', 4], ['MOPE', 4, 'm ow p', 3], ['MOPES', 5, 'm ow p s', 4], ['MOPED', 5, 'm ow p t', 4], ['SQUAMOSE', 8, 'm ow s', 3], ['UNREMOTE', 8, 'm ow t', 3], ['REMOTES', 7, 'm ow t s', 4], ['MAUVE', 5, 'm ow v', 3], ['MAUVES', 6, 'm ow v z', 4], ['LIMOGES', 7, 'm ow zh', 3], ['PEGAMOID', 8, 'm oy d', 3], ['TURMOIL', 7, 'm oy l', 3], ['TURMOILS', 8, 'm oy l z', 4], ['ALMOIN', 6, 'm oy n', 3], ['MOINES', 6, 'm oy n z', 4], ['MOIST', 5, 'm oy s t', 4], ['UNMOORED', 8, 'm ua d', 3], ['MOORES', 6, 'm ua r z', 4], ['TALMUD', 6, 'm uh d', 3], ['TALMUDS', 7, 'm uh d z', 4], ["MUKDEN'S", 8, 'm uh k', 3], ['MOUCH', 5, 'm uw ch', 3], ['MOOCHED', 7, 'm uw ch t', 4], ['MOOED', 5, 'm uw d', 3], ['MOODS', 5, 'm uw d z', 4], ['SIMOOM', 6, 'm uw m', 3], ['SIMOOMS', 7, 'm uw m z', 4], ['SIMOON', 6, 'm uw n', 3], ['MOONED', 6, 'm uw n d', 4], ['SIMOONS', 7, 'm uw n z', 4], ['VAMOOSE', 7, 'm uw s', 3], ['VAMOOSED', 8, 'm uw s t', 4], ['MOOT', 4, 'm uw t', 3], ['MOOTS', 5, 'm uw t s', 4], ['REMOVES', 7, 'm uw v z', 4], ['MOOS', 4, 'm uw z', 3], ['ZENANAS', 7, 'n aa', 2], ['NARK', 4, 'n aa k', 3], ['NARKS', 5, 'n aa k s', 4], ['NARKED', 6, 'n aa k t', 4], ['GNARLED', 7, 'n aa l d', 4], ['VIETNAM', 7, 'n aa m', 3], ['UNARMED', 7, 'n aa m d', 4], ['VIETNAMS', 8, 'n aa m z', 4], ['SONAR', 5, 'n aa r', 3], ['PINARD', 6, 'n aa r d', 4], ['UNASKED', 7, 'n aa s k t', 5], ['NAZISM', 6, 'n aa t', 3], ['PENARTH', 7, 'n aa th', 3], ['SONARS', 6, 'n aa z', 3], ["M\\'ENAGE", 8, 'n aa zh', 3], ['NAB', 3, 'n ae b', 3], ['NABBED', 6, 'n ae b d', 4], ['NABS', 4, 'n ae b z', 4], ['MONAD', 5, 'n ae d', 3], ['MONADS', 6, 'n ae d z', 4], ['NAGPUR', 6, 'n ae g', 3], ['NAGGED', 6, 'n ae g d', 4], ['NAGS', 4, 'n ae g z', 4], ['KNACKED', 7, 'n ae k t', 4], ['ENACTS', 6, 'n ae k t s', 5], ['CANALED', 7, 'n ae l d', 4], ['ORDINAND', 8, 'n ae n d', 4], ['VENANGO', 7, 'n ae ng', 3], ['NAPKINS', 7, 'n ae p', 3], ['NAPS', 4, 'n ae p s', 4], ['NAPPED', 6, 'n ae p t', 4], ['NAST', 4, 'n ae s t', 4], ["NAST'S", 6, 'n ae s t s', 5], ['PANACHE', 7, 'n ae sh', 3], ['PANACHED', 8, 'n ae sh t', 4], ['NAT', 3, 'n ae t', 3], ['GNATS', 5, 'n ae t s', 4], ["NASDAQ'S", 8, 'n ae z', 3], ['NUB', 3, 'n ah b', 3], ['NUBS', 4, 'n ah b z', 4], ['ENOUGH', 6, 'n ah f', 3], ['ENOUGHS', 7, 'n ah f s', 4], ['NUDGE', 5, 'n ah jh', 3], ['NUDGED', 6, 'n ah jh d', 4], ['KINNOCK', 7, 'n ah k', 3], ['NULLED', 6, 'n ah l d', 4], ['PENULT', 6, 'n ah l t', 4], ['PENULTS', 7, 'n ah l t s', 5], ['NUMBED', 6, 'n ah m d', 4], ["PUTNAM'S", 8, 'n ah m z', 4], ["WINANS'S", 8, 'n ah n', 3], ['WINANS', 6, 'n ah n z', 4], ['QUIDNUNC', 8, 'n ah ng k', 4], ['TURN-UP', 7, 'n ah p', 3], ['TURN-UPS', 8, 'n ah p s', 4], ['MCMANUS', 7, 'n ah s', 3], ['WING-NUT', 8, 'n ah t', 3], ['IGNORED', 7, 'n ao d', 3], ['SPINOFF', 7, 'n ao f', 3], ['NORMED', 6, 'n ao m d', 4], ['NORMS', 5, 'n ao m z', 4], ["NOR'-", 5, 'n ao r', 3], ['NORSE', 5, 'n ao s', 3], ['NOUGHT', 6, 'n ao t', 3], ['NOUGHTS', 7, 'n ao t s', 4], ['NORTHMEN', 8, 'n ao th', 3], ['NORTHS', 6, 'n ao th s', 4], ['NOWADAYS', 8, 'n aw', 2], ['RENOWNED', 8, 'n aw n d', 4], ['RENOWNS', 7, 'n aw n z', 4], ['NOUS', 4, 'n aw s', 3], ['TURNOUT', 7, 'n aw t', 3], ['TURNOUTS', 8, 'n aw t s', 4], ["NOW'S", 5, 'n aw z', 3], ['ZENANA', 6, 'n ax', 2], ['VERNARD', 7, 'n ax d', 3], ['GWYNEDD', 7, 'n ax dh', 3], ['INNARDS', 7, 'n ax jh', 3], ['VIBURNUM', 8, 'n ax m', 3], ['VENOMED', 7, 'n ax m d', 4], ['TENONED', 7, 'n ax n d', 4], ['URINANT', 7, 'n ax n t', 4], ['STANHOPE', 8, 'n ax p', 3], ['WINNER', 6, 'n ax r', 3], ['MINORED', 7, 'n ax r d', 4], ["WINNER'S", 8, 'n ax r z', 4], ['DYNASTS', 7, 'n ax s t s', 5], ['ZENANAS', 7, 'n ax z', 3], ['UNDENIED', 8, 'n ay d', 3], ['CYANIDES', 8, 'n ay d z', 4], ['KNIFES', 6, 'n ay f s', 4], ['KNIFED', 6, 'n ay f t', 4], ['SENILE', 6, 'n ay l', 3], ['SENILES', 7, 'n ay l z', 4], ['NINTH', 5, 'n ay n th', 4], ['NINTHS', 6, 'n ay n th s', 5], ['PENNINES', 8, 'n ay n z', 4], ['NICE', 4, 'n ay s', 3], ['XYLONITE', 8, 'n ay t', 3], ['UNITES', 6, 'n ay t s', 4], ['CONNIVE', 7, 'n ay v', 3], ['WOMANIZE', 8, 'n ay z', 3], ['WIZENED', 7, 'n d', 2], ["WHENE'ER", 8, 'n ea', 2], ['NAIRN', 5, 'n ea n', 3], ["ZENECA'S", 8, 'n eh', 2], ['NED', 3, 'n eh d', 3], ['NEFF', 4, 'n eh f', 3], ["NEFF'S", 6, 'n eh f s', 4], ['NEGS', 4, 'n eh g z', 4], ['WRYNECK', 7, 'n eh k', 3], ['WRYNECKS', 8, 'n eh k s', 4], ['NEXT', 4, 'n eh k s t', 5], ["NEXT'S", 6, 'n eh k s t s', 6], ['SPINELLE', 8, 'n eh l', 3], ['KNELLED', 7, 'n eh l d', 4], ['KNELT', 5, 'n eh l t', 4], ['SPINELS', 7, 'n eh l z', 4], ['NEM_CON', 7, 'n eh m', 3], ['TRANENT', 7, 'n eh n t', 4], ['TENENS', 6, 'n eh n z', 4], ['INEPT', 5, 'n eh p t', 4], ['WAGONESS', 8, 'n eh s', 3], ['NESTFUL', 7, 'n eh s t', 4], ['NESTS', 5, 'n eh s t s', 5], ['DONETSK', 7, 'n eh t s k', 5], ['BREZHNEV', 8, 'n eh v', 3], ['MARTINEZ', 8, 'n eh z', 3], ["WINERY'S", 8, 'n er', 2], ['HONORED', 7, 'n er d', 3], ['UNEARNED', 8, 'n er n d', 4], ['NURSED', 6, 'n er s t', 4], ['INERT', 5, 'n er t', 3], ['INERTS', 6, 'n er t s', 4], ['UNEARTH', 7, 'n er th', 3], ['UNEARTHS', 8, 'n er th s', 4], ['UNNERVE', 7, 'n er v', 3], ['UNNERVED', 8, 'n er v d', 4], ['UNNERVES', 8, 'n er v z', 4], ["WERNER'S", 8, 'n er z', 3], ['V_AND_A', 7, 'n ey', 2], ['SERENADE', 8, 'n ey d', 3], ['RENEGUE', 7, 'n ey g', 3], ['RENEGUED', 8, 'n ey g d', 4], ['RENEGUES', 8, 'n ey g z', 4], ['TEENAGE', 7, 'n ey jh', 3], ['TEENAGED', 8, 'n ey jh d', 4], ['TOENAIL', 7, 'n ey l', 3], ['TOENAILS', 8, 'n ey l z', 4], ['UNNAME', 6, 'n ey m', 3], ['UNNAMED', 7, 'n ey m d', 4], ['SURNAMES', 8, 'n ey m z', 4], ['NAINSOOK', 8, 'n ey n', 3], ['INANES', 6, 'n ey n z', 4], ['NAPE', 4, 'n ey p', 3], ['NAPES', 5, 'n ey p s', 4], ['NAVEED', 6, 'n ey v d', 4], ['NAVES', 5, 'n ey v z', 4], ['UNHARD', 6, 'n hh aa d', 4], ['UNHARMED', 8, 'n hh aa m d', 5], ['ENHANCE', 7, 'n hh aa n s', 5], ['REINHARD', 8, 'n hh aa r d', 5], ['UNHANDY', 7, 'n hh ae n', 4], ['UNHANG', 6, 'n hh ae ng', 4], ['UNHANGED', 8, 'n hh ae ng d', 5], ['SUNHAT', 6, 'n hh ae t', 4], ['UNHATS', 6, 'n hh ae t s', 5], ['UNHUNG', 6, 'n hh ah ng', 4], ['UNHORSE', 7, 'n hh ao s', 4], ['UNHORSED', 8, 'n hh ao s t', 5], ['UNHOUSE', 7, 'n hh aw s', 4], ['UNHOUSED', 8, 'n hh aw s t', 5], ['MANNHEIM', 8, 'n hh ay m', 4], ['UNHEDGE', 7, 'n hh eh jh', 4], ['UNHEDGED', 8, 'n hh eh jh d', 5], ['UNHELD', 6, 'n hh eh l d', 5], ['UNHEARD', 7, 'n hh er d', 4], ['INHALING', 8, 'n hh ey', 3], ['INHALE', 6, 'n hh ey l', 4], ['INHALES', 7, 'n hh ey l z', 5], ['INHERED', 7, 'n hh ia d', 4], ['MYNHEERS', 8, 'n hh ia z', 4], ['UNHITCH', 7, 'n hh ih ch', 4], ['DOWNHILL', 8, 'n hh ih l', 4], ['UNHINTED', 8, 'n hh ih n', 4], ['UNHISSED', 8, 'n hh ih s t', 5], ['UNHEEDY', 7, 'n hh iy', 3], ['UNHEALED', 8, 'n hh iy l d', 5], ['PINHOLD', 7, 'n hh ow l d', 5], ['PINHOLES', 8, 'n hh ow l z', 5], ['MANHOODS', 8, 'n hh uh d z', 5], ['UNHOOK', 6, 'n hh uh k', 4], ['UNHOOKS', 7, 'n hh uh k s', 5], ['UNHOOKED', 8, 'n hh uh k t', 5], ['SAN_JUAN', 8, 'n hh w aa n', 5], ['INHUME', 6, 'n hh y uw m', 5], ['ZINNIA', 6, 'n ia', 2], ['VENEERED', 8, 'n ia d', 3], ['FINIALED', 8, 'n ia l d', 4], ['URANIUM', 7, 'n ia m', 3], ['URANIUMS', 8, 'n ia m z', 4], ['UNIONED', 7, 'n ia n d', 4], ["UNIONS'", 7, 'n ia n z', 4], ['ZANIER', 6, 'n ia r', 3], ["SENIOR'S", 8, 'n ia r z', 4], ['ST_NEOTS', 8, 'n ia t s', 4], ['ZINNIAS', 7, 'n ia z', 3], ['ZUCCHINI', 8, 'n ih', 2], ['NIB', 3, 'n ih b', 3], ['NIBS', 4, 'n ih b z', 4], ['NICHE', 5, 'n ih ch', 3], ['NICHED', 6, 'n ih ch t', 4], ['WHINNIED', 8, 'n ih d', 3], ['HOMINIDS', 8, 'n ih d z', 4], ['NIFTY', 5, 'n ih f', 3], ['NIFFS', 5, 'n ih f s', 4], ['PFENNIGS', 8, 'n ih g z', 4], ['ZENICK', 6, 'n ih k', 3], ['TUNICKED', 8, 'n ih k t', 4], ['VINYL', 5, 'n ih l', 3], ['NILS', 4, 'n ih l s', 4], ['VINYLS', 6, 'n ih l z', 4], ['UNIMPED', 7, 'n ih m p t', 5], ['SYNONYMS', 8, 'n ih m z', 4], ['TANNINED', 8, 'n ih n d', 4], ['TANNINS', 7, 'n ih n z', 4], ['ZONING', 6, 'n ih ng', 3], ['TURNIP', 6, 'n ih p', 3], ['TURNIPS', 7, 'n ih p s', 4], ['NIPPED', 6, 'n ih p t', 4], ['ZIONIST', 7, 'n ih s t', 4], ['ZIONISTS', 8, 'n ih s t s', 5], ['WOMANISH', 8, 'n ih sh', 3], ['WHODUNIT', 8, 'n ih t', 3], ['ZENITH', 6, 'n ih th', 3], ['ZENITHS', 7, 'n ih th s', 4], ['WHINNEY', 7, 'n iy', 2], ['NEEDS', 5, 'n iy d z', 4], ['RENEGUE', 7, 'n iy g', 3], ['UNIQUES', 7, 'n iy k s', 4], ['NEIL', 4, 'n iy l', 3], ['KNEELED', 7, 'n iy l d', 4], ['NIELS', 5, 'n iy l s', 4], ["NEIL'S", 6, 'n iy l z', 4], ['TONEME', 6, 'n iy m', 3], ['PHONEMES', 8, 'n iy m z', 4], ['QUININES', 8, 'n iy n z', 4], ['GAININGS', 8, 'n iy ng z', 4], ['NEAPS', 5, 'n iy p s', 4], ['NEAPED', 6, 'n iy p t', 4], ['KINNEAR', 7, 'n iy r', 3], ['NIECE', 5, 'n iy s', 3], ['UNEATEN', 7, 'n iy t', 3], ['UNEVENLY', 8, 'n iy v', 3], ['XENOGAMY', 8, 'n oh', 2], ['NOBS', 4, 'n oh b z', 4], ['TOPNOTCH', 8, 'n oh ch', 3], ['NOTCHED', 7, 'n oh ch t', 4], ['NOD', 3, 'n oh d', 3], ['NODS', 4, 'n oh d z', 4], ['TURN-OFF', 8, 'n oh f', 3], ['KNOCKS', 6, 'n oh k s', 4], ['KNOCKED', 7, 'n oh k t', 4], ['REYNOLDS', 8, 'n oh l d z', 5], ['PHENOLS', 7, 'n oh l z', 4], ['XENON', 5, 'n oh n', 3], ['NONCE', 5, 'n oh n s', 4], ['XENONS', 6, 'n oh n z', 4], ['THANOS', 6, 'n oh s', 3], ['GLASNOST', 8, 'n oh s t', 4], ['NOSH', 4, 'n oh sh', 3], ['NOSHED', 6, 'n oh sh t', 4], ['WHATNOT', 7, 'n oh t', 3], ['WHATNOTS', 8, 'n oh t s', 4], ['ZUCCHINO', 8, 'n ow', 2], ['WINNOWED', 8, 'n ow d', 3], ['SEMINOLE', 8, 'n ow l', 3], ['GNOMED', 6, 'n ow m d', 4], ['UNOWNED', 7, 'n ow n d', 4], ['UNKNOWNS', 8, 'n ow n z', 4], ['NOPE', 4, 'n ow p', 3], ['URINOSE', 7, 'n ow s', 3], ['NOTES', 5, 'n ow t s', 4], ['WINNOWS', 7, 'n ow z', 3], ['ANOINTS', 7, 'n oy n t s', 5], ['NOIR', 4, 'n oy r', 3], ['NEUSS', 5, 'n oy s', 3], ['TANNOYS', 7, 'n oy z', 3], ['NOISED', 6, 'n oy z d', 4], ["WOULDN'T", 8, 'n t', 2], ['TRIDENTS', 8, 'n t s', 3], ['NOOKING', 7, 'n uh', 2], ['NOOK', 4, 'n uh k', 3], ['NOOKS', 5, 'n uh k s', 4], ['NOOKED', 6, 'n uh k t', 4], ['CANOED', 6, 'n uw d', 3], ['NOOSE', 5, 'n uw s', 3], ['NOOSED', 6, 'n uw s t', 4], ['GNUS', 4, 'n uw z', 3], ['PEIGNOIR', 8, 'n w aa r', 4], ['RENOIRS', 7, 'n w aa z', 4], ['CORNWALL', 8, 'n w ao l', 4], ['UNWARM', 6, 'n w ao m', 4], ['UNWARMED', 8, 'n w ao m d', 5], ['UNWORN', 6, 'n w ao n', 4], ['UNWARNED', 8, 'n w ao n d', 5], ['UNWOUND', 7, 'n w aw n d', 5], ['ONWARDLY', 8, 'n w ax', 3], ['ZIONWARD', 8, 'n w ax d', 4], ['UNWIND', 6, 'n w ay n d', 5], ['UNWINDS', 7, 'n w ay n d z', 6], ['UNWIPED', 7, 'n w ay p t', 5], ['UNWISE', 6, 'n w ay z', 4], ['UNWED', 5, 'n w eh d', 4], ['UNWELL', 6, 'n w eh l', 4], ['UNWELD', 6, 'n w eh l d', 5], ['UNWORTHY', 8, 'n w er', 3], ['LOANWORD', 8, 'n w er d', 4], ['UNWORKED', 8, 'n w er k t', 5], ['UNWAVING', 8, 'n w ey', 3], ['UNWAVED', 7, 'n w ey v d', 5], ['RUNWAYS', 7, 'n w ey z', 4], ['UNWITTY', 7, 'n w ih', 3], ['CYNWYD', 6, 'n w ih d', 4], ['UNWILLED', 8, 'n w ih l d', 5], ['UNWISDOM', 8, 'n w ih z', 4], ['UNWIELDY', 8, 'n w iy l', 4], ['UNWEANED', 8, 'n w iy n d', 5], ['INWEAVE', 7, 'n w iy v', 4], ['INWEAVED', 8, 'n w iy v d', 5], ['INWEAVES', 8, 'n w iy v z', 5], ['ENNUIS', 6, 'n w iy z', 4], ['PENNWALT', 8, 'n w oh l t', 5], ['UNWANTON', 8, 'n w oh n', 4], ['RAINWASH', 8, 'n w oh sh', 4], ['UNWASHED', 8, 'n w oh sh t', 5], ['INWOVEN', 7, 'n w ow', 3], ['INWOVE', 6, 'n w ow v', 4], ['ASSIGNAT', 8, 'n y aa', 3], ['WYNYARD', 7, 'n y aa d', 4], ['COGNAC', 6, 'n y ae k', 4], ['COGNACS', 7, 'n y ae k s', 5], ['KENYON', 6, 'n y ah n', 4], ["KENYON'S", 8, 'n y ah n z', 5], ['SIGNOR', 6, 'n y ao r', 4], ['SIGNORS', 7, 'n y ao z', 4], ['VINEYARD', 8, 'n y ax d', 4], ['UNGENIAL', 8, 'n y ax l', 4], ['POIGNANT', 8, 'n y ax n t', 5], ['TONYA', 5, 'n y ax r', 4], ["TONYA'S", 7, 'n y ax r z', 5], ['VERNIERS', 8, 'n y ax z', 4], ['VIGNETTE', 8, 'n y eh t', 4], ["SOIGN\\'E", 8, 'n y ey', 3], ['KELLENYI', 8, 'n y iy', 3], ['SIGNON', 6, 'n y oh n', 4], ['SIGNONS', 7, 'n y oh n z', 5], ['SANYO', 5, 'n y ow', 3], ['UNYOKE', 6, 'n y ow k', 4], ['UNYOKES', 7, 'n y ow k s', 5], ['UNYOKED', 7, 'n y ow k t', 5], ["SANYO'S", 7, 'n y ow z', 4], ['TOURNURE', 8, 'n y ua', 3], ['TENURED', 7, 'n y ua d', 4], ['MANUEL', 6, 'n y ua l', 4], ["MANUEL'S", 8, 'n y ua l z', 5], ['TENURE', 6, 'n y ua r', 4], ['TENURES', 7, 'n y ua z', 4], ['VENUE', 5, 'n y uw', 3], ['NUDES', 5, 'n y uw d z', 5], ['LUNULE', 6, 'n y uw l', 4], ['GRANULES', 8, 'n y uw l z', 5], ['NEUME', 5, 'n y uw m', 4], ['UNUSED', 6, 'n y uw s t', 5], ['NEWTS', 5, 'n y uw t s', 5], ['VENUES', 6, 'n y uw z', 4], ['UNUSED', 6, 'n y uw z d', 5], ['WIZENS', 6, 'n z', 2], ['ZOOTOMY', 7, 'oh', 1], ['ODDS-ON', 7, 'oh d', 2], ['SHOWOFF', 7, 'oh f', 2], ['SHOWOFFS', 8, 'oh f s', 3], ['OFT', 3, 'oh f t', 3], ['OXYTONE', 7, 'oh k', 2], ['OCT', 3, 'oh k t', 3], ["OLSTEN'S", 8, 'oh l', 2], ['ALBANS', 6, 'oh l b', 3], ['OMPHALUS', 8, 'oh m', 2], ['OMSK', 4, 'oh m s k', 4], ['ZOON', 4, 'oh n', 2], ['NEONED', 6, 'oh n d', 3], ['TRY-ONS', 7, 'oh n z', 3], ['ROUENS', 6, 'oh ng z', 3], ['CO-OPS', 6, 'oh p s', 3], ['OPT', 3, 'oh p t', 3], ['OPTS', 4, 'oh p t s', 4], ['ORTEGAS', 7, 'oh r', 2], ['LAOS', 4, 'oh s', 2], ['KIOSK', 5, 'oh s k', 3], ['KIOSKS', 6, 'oh s k s', 4], ['BRIOCHE', 7, 'oh sh', 2], ['OF', 2, 'oh v', 2], ['OZ', 2, 'oh z', 2], ['OWED', 4, 'ow d', 2], ['ODES', 4, 'ow d z', 3], ['OATHS', 5, 'ow dh z', 3], ['OAF', 3, 'ow f', 2], ['OAFS', 4, 'ow f s', 3], ["OAKES'S", 7, 'ow k', 2], ['OAKS', 4, 'ow k s', 3], ['OLSHAN', 6, 'ow l', 2], ['OLDSTERS', 8, 'ow l d', 3], ['OLMSTED', 7, 'ow l m', 3], ['OLDS', 4, 'ow l z', 3], ['OHM', 3, 'ow m', 2], ['OHMS', 4, 'ow m z', 3], ['OWNED', 5, 'ow n d', 3], ['OWNS', 4, 'ow n z', 3], ['OPE', 3, 'ow p', 2], ['MYOPES', 6, 'ow p s', 3], ['OAST', 4, 'ow s t', 3], ['OASTS', 5, 'ow s t s', 4], ['OATMEALS', 8, 'ow t', 2], ['OATS', 4, 'ow t s', 3], ['OATH', 4, 'ow th', 2], ['OATHED', 6, 'ow th t', 3], ['OAVES', 5, 'ow v z', 3], ['TRIOS', 5, 'ow z', 2], ['OYSTERS', 7, 'oy', 1], ['HYOID', 5, 'oy d', 2], ['HYOIDES', 7, 'oy d z', 3], ['TUNG-OIL', 8, 'oy l', 2], ['OILED', 5, 'oy l d', 3], ['OILS', 4, 'oy l z', 3], ['OINTER', 6, 'oy n', 2], ['PUISSANT', 8, 'p', 1], ['PARCHED', 7, 'p aa ch t', 4], ['PARDES', 6, 'p aa d z', 4], ['WARPATHS', 8, 'p aa dh z', 4], ['VIEWPARK', 8, 'p aa k', 3], ['PARKS', 5, 'p aa k s', 4], ['PARKED', 6, 'p aa k t', 4], ['PALMED', 6, 'p aa m d', 4], ['PALMS', 5, 'p aa m z', 4], ['PARR', 4, 'p aa r', 3], ['PARRED', 6, 'p aa r d', 4], ["PARR'S", 6, 'p aa r z', 4], ['REPASTS', 7, 'p aa s t s', 5], ['UNIPART', 7, 'p aa t', 3], ['WARPATH', 7, 'p aa th', 3], ["PATH'S", 6, 'p aa th s', 4], ['PATHED', 6, 'p aa th t', 4], ['PARSE', 5, 'p aa z', 3], ['PARSED', 6, 'p aa z d', 4], ['PATCHED', 7, 'p ae ch t', 4], ['PAGNELL', 7, 'p ae g', 3], ['WESTPAC', 7, 'p ae k', 3], ['UNPACKED', 8, 'p ae k t', 4], ['PALLED', 6, 'p ae l d', 4], ['PALS', 4, 'p ae l z', 4], ['JAPANSE', 7, 'p ae n s', 4], ['PANZERS', 7, 'p ae n t', 4], ['PANGED', 6, 'p ae ng d', 4], ['PANGS', 5, 'p ae ng z', 4], ['PAP', 3, 'p ae p', 3], ['CALIPASH', 8, 'p ae sh', 3], ['PITAPAT', 7, 'p ae t', 3], ['PITAPATS', 8, 'p ae t s', 4], ['TOPAZ', 5, 'p ae z', 3], ['PUBS', 4, 'p ah b z', 4], ['PUDSEY', 6, 'p ah d', 3], ['PUFFS', 5, 'p ah f s', 4], ['PUFFED', 6, 'p ah f t', 4], ['PUGS', 4, 'p ah g z', 4], ['PUCK', 4, 'p ah k', 3], ['PUCKS', 5, 'p ah k s', 4], ['PULPS', 5, 'p ah l p s', 5], ['PULPED', 6, 'p ah l p t', 5], ['REPULSE', 7, 'p ah l s', 4], ['REPULSED', 8, 'p ah l s t', 5], ['CATAPULT', 8, 'p ah l t', 4], ['UPHAM', 5, 'p ah m', 3], ['PUMPED', 6, 'p ah m p t', 5], ["UPHAM'S", 7, 'p ah m z', 4], ['PUNCHED', 7, 'p ah n ch t', 5], ['PUNNED', 6, 'p ah n d', 4], ['PUNTSMAN', 8, 'p ah n t', 4], ['PUNTS', 5, 'p ah n t s', 5], ['PUNS', 4, 'p ah n z', 4], ['PUNKISH', 7, 'p ah ng', 3], ['PUNKS', 5, 'p ah ng k s', 5], ['TIP-UP', 6, 'p ah p', 3], ['SLIP-UPS', 8, 'p ah p s', 4], ['PUS', 3, 'p ah s', 3], ['PASHTO', 6, 'p ah sh', 3], ['SINCIPUT', 8, 'p ah t', 3], ['PUTTS', 5, 'p ah t s', 4], ["TAMPA'S", 7, 'p ah z', 3], ['PORCHED', 7, 'p ao ch t', 4], ['POURED', 6, 'p ao d', 3], ["PORK'S", 6, 'p ao k s', 4], ['ST_PAUL', 7, 'p ao l', 3], ['PALLED', 6, 'p ao l d', 4], ['PAWLS', 5, 'p ao l z', 4], ['PORN', 4, 'p ao n', 3], ['PAUNCH', 6, 'p ao n ch', 4], ['PAUNCHED', 8, 'p ao n ch t', 5], ['PAWNED', 6, 'p ao n d', 4], ['PONT', 4, 'p ao n t', 4], ['PAWNS', 5, 'p ao n z', 4], ['PORSCHE', 7, 'p ao sh', 3], ['VIEWPORT', 8, 'p ao t', 3], ['SUPPORTS', 8, 'p ao t s', 4], ['PAUSED', 6, 'p ao z d', 4], ['POUCH', 5, 'p aw ch', 3], ['POUCHED', 7, 'p aw ch t', 4], ['POUNCE', 6, 'p aw n s', 4], ['POUNCED', 7, 'p aw n s t', 5], ['POUT', 4, 'p aw t', 3], ['POUTS', 5, 'p aw t s', 4], ['ZIPPERED', 8, 'p ax d', 3], ['SYNCOPAL', 8, 'p ax l', 3], ['SCALPELS', 8, 'p ax l z', 4], ['WAMPUM', 6, 'p ax m', 3], ['WAMPUMS', 7, 'p ax m z', 4], ['WEAPONED', 8, 'p ax n d', 4], ['TWOPENCE', 8, 'p ax n s', 4], ['TRIPPANT', 8, 'p ax n t', 4], ['SERPENTS', 8, 'p ax n t s', 5], ['WEAPONS', 7, 'p ax n z', 4], ['ZIPPER', 6, 'p ax r', 3], ['ZIPPERED', 8, 'p ax r d', 4], ['WAMPUS', 6, 'p ax s', 3], ['RUPERT', 6, 'p ax t', 3], ['RUPERTS', 7, 'p ax t s', 4], ["HAP'ORTH", 8, 'p ax th', 3], ['ZIPPERS', 7, 'p ax z', 3], ['VAMPIRES', 8, 'p ay', 2], ['TURNPIKE', 8, 'p ay k', 3], ['WOODPILE', 8, 'p ay l', 3], ['UNPILED', 7, 'p ay l d', 4], ['VULPINE', 7, 'p ay n', 3], ['PT.', 3, 'p ay n t', 4], ['PINTS', 5, 'p ay n t s', 5], ['WINDPIPE', 8, 'p ay p', 3], ['PIPED', 5, 'p ay p t', 4], ['PICE', 4, 'p ay s', 3], ['PYTHONS', 7, 'p ay th', 3], ['PAREDES', 7, 'p ea d z', 4], ["PAIR'S", 6, 'p ea r z', 4], ['REPAIRS', 7, 'p ea z', 3], ['WINNIPEG', 8, 'p eh g', 3], ['PEGGED', 6, 'p eh g d', 4], ['WOODPECK', 8, 'p eh k', 3], ['TORPEX', 6, 'p eh k s', 4], ['APEXED', 6, 'p eh k s t', 5], ['PECKED', 6, 'p eh k t', 4], ['REPEL', 5, 'p eh l', 3], ['PELF', 4, 'p eh l f', 4], ["PELTZ'S", 7, 'p eh l t', 4], ['PELTZ', 5, 'p eh l t s', 5], ['REPELS', 6, 'p eh l z', 4], ['STIPENDS', 8, 'p eh n d z', 5], ['REPENTS', 7, 'p eh n t s', 5], ['PLAYPENS', 8, 'p eh n z', 4], ['PENGUINS', 8, 'p eh ng', 3], ['PEPS', 4, 'p eh p s', 4], ['PEPPED', 6, 'p eh p t', 4], ["PESTS'", 6, 'p eh s t s', 5], ['PIPETTE', 7, 'p eh t', 3], ['PIPETTES', 8, 'p eh t s', 4], ['SUPERB', 6, 'p er b', 3], ['PERCH', 5, 'p er ch', 3], ['PERCHED', 7, 'p er ch t', 4], ['SHEPPARD', 8, 'p er d', 3], ['PURGE', 5, 'p er jh', 3], ['PURGED', 6, 'p er jh d', 4], ['PERK', 4, 'p er k', 3], ['PERKS', 5, 'p er k s', 4], ['PERKED', 6, 'p er k t', 4], ['PURL', 4, 'p er l', 3], ['PURLED', 6, 'p er l d', 4], ['PERMED', 6, 'p er m d', 4], ['PERMS', 5, 'p er m z', 4], ['SUPERNAL', 8, 'p er n', 3], ['EPERGNES', 8, 'p er n z', 4], ['PURR', 4, 'p er r', 3], ['PURSE', 5, 'p er s', 3], ['PURSED', 6, 'p er s t', 4], ['PERTNESS', 8, 'p er t', 3], ["PERT'S", 6, 'p er t s', 4], ['PERTH', 5, 'p er th', 3], ["PERTH'S", 7, 'p er th s', 4], ['ROPERS', 6, 'p er z', 3], ["\\'EP\\'EE", 8, 'p ey', 2], ['UNREPAID', 8, 'p ey d', 3], ['RAMPAGED', 8, 'p ey jh d', 4], ['OPAQUES', 7, 'p ey k s', 4], ['OPAQUED', 7, 'p ey k t', 4], ['PALED', 5, 'p ey l d', 4], ['PAINED', 6, 'p ey n d', 4], ['WARPAINT', 8, 'p ey n t', 4], ['REPAINTS', 8, 'p ey n t s', 5], ['PACE', 4, 'p ey s', 3], ['UNPAVE', 6, 'p ey v', 3], ['UNPAVED', 7, 'p ey v d', 4], ['PAVES', 5, 'p ey v z', 4], ['GEPHARDT', 8, 'p hh aa r t', 5], ['SAPHEADS', 8, 'p hh eh d z', 5], ['UPHELD', 6, 'p hh eh l d', 5], ['UPHILL', 6, 'p hh ih l', 4], ['UPHILLS', 7, 'p hh ih l z', 5], ['UPHEAVE', 7, 'p hh iy v', 4], ['UPHEAVED', 8, 'p hh iy v d', 5], ['UPHEAVES', 8, 'p hh iy v z', 5], ['UPHOLD', 6, 'p hh ow l d', 5], ['APEHOOD', 7, 'p hh uh d', 4], ['WHIPPIER', 8, 'p ia', 2], ['OPIUMS', 6, 'p ia m z', 4], ['UTOPIAN', 7, 'p ia n', 3], ['SAPIENCE', 8, 'p ia n s', 4], ['UTOPIANS', 8, 'p ia n z', 4], ['WHIPPIER', 8, 'p ia r', 3], ['RAPIERED', 8, 'p ia r d', 4], ["PEER'S", 6, 'p ia r z', 4], ['PIERCE', 6, 'p ia s', 3], ['OPIATE', 6, 'p ia t', 3], ['OPIATES', 7, 'p ia t s', 4], ['UTOPIAS', 7, 'p ia z', 3], ['ZIPPIEST', 8, 'p ih', 2], ['PITCHED', 7, 'p ih ch t', 4], ['TORPIDS', 7, 'p ih d z', 4], ['PIGGED', 6, 'p ih g d', 4], ['STOPPAGE', 8, 'p ih jh', 3], ['UNPICKS', 7, 'p ih k s', 4], ['UNPICKED', 8, 'p ih k t', 4], ['DEPICTS', 7, 'p ih k t s', 5], ['PILCH', 5, 'p ih l ch', 4], ['PILLED', 6, 'p ih l d', 4], ['PYMM', 4, 'p ih m', 3], ['PIMP', 4, 'p ih m p', 4], ['PIMPS', 5, 'p ih m p s', 5], ['PIMPED', 6, 'p ih m p t', 5], ['UNPIN', 5, 'p ih n', 3], ['IMPINGED', 8, 'p ih n jh d', 5], ['UNPINS', 6, 'p ih n z', 4], ['PINGED', 6, 'p ih ng d', 4], ['POPPINK', 7, 'p ih ng k', 4], ['PINKS', 5, 'p ih ng k s', 5], ['PINKED', 6, 'p ih ng k t', 5], ['PIPS', 4, 'p ih p s', 4], ['PIPPED', 6, 'p ih p t', 4], ['UNRIPEST', 8, 'p ih s t', 4], ['TYPISTS', 7, 'p ih s t s', 5], ['YAPPISH', 7, 'p ih sh', 3], ['PISHED', 6, 'p ih sh t', 4], ['WHIPPET', 7, 'p ih t', 3], ['WHIPPETS', 8, 'p ih t s', 4], ['PITH', 4, 'p ih th', 3], ['PITHES', 6, 'p ih th s', 4], ['PITHED', 6, 'p ih th t', 4], ['YUPPIES', 7, 'p ih z', 3], ['WHOOPEE', 7, 'p iy', 2], ['PEACH', 5, 'p iy ch', 3], ['REPIQUE', 7, 'p iy k', 3], ['PIQUES', 6, 'p iy k s', 4], ['PIQUED', 6, 'p iy k t', 4], ['UNPEEL', 6, 'p iy l', 3], ['SPIELS', 6, 'p iy l z', 4], ['PEEPS', 5, 'p iy p s', 4], ['PEEPED', 6, 'p iy p t', 4], ['UNPEACE', 7, 'p iy s', 3], ['PIECED', 6, 'p iy s t', 4], ['REPEAT', 6, 'p iy t', 3], ['REPEATS', 7, 'p iy t s', 4], ['PEEVE', 5, 'p iy v', 3], ['PEEVED', 6, 'p iy v d', 4], ['PEEVES', 6, 'p iy v z', 4], ['APPEASED', 8, 'p iy z d', 4], ['FLAPJACK', 8, 'p jh ae k', 4], ['UPJOHN', 6, 'p jh oh n', 4], ["UPJOHN'S", 8, 'p jh oh n z', 5], ['WIMPLE', 6, 'p l', 2], ['PLAQUE', 6, 'p l aa k', 4], ['PLAQUES', 7, 'p l aa k s', 5], ['PLANCH', 6, 'p l aa n sh', 5], ['HOOPLAS', 7, 'p l aa z', 4], ['PLAGE', 5, 'p l aa zh', 4], ['UNPLAID', 7, 'p l ae d', 4], ['PLAIDS', 6, 'p l ae d z', 5], ['PLANS', 5, 'p l ae n z', 5], ['PLANKY', 6, 'p l ae ng', 4], ['WHIPLASH', 8, 'p l ae sh', 4], ['UNPLAIT', 7, 'p l ae t', 4], ['PLATTS', 6, 'p l ae t s', 5], ['UNPLUG', 6, 'p l ah g', 4], ['UNPLUGS', 7, 'p l ah g z', 5], ['PLUCK', 5, 'p l ah k', 4], ['PLUCKS', 6, 'p l ah k s', 5], ['PLUCKED', 7, 'p l ah k t', 5], ['PLUMPY', 6, 'p l ah m', 4], ['PLUMP', 5, 'p l ah m p', 5], ['PLUMPS', 6, 'p l ah m p s', 6], ['PLUMPED', 7, 'p l ah m p t', 6], ['PLUMS', 5, 'p l ah m z', 5], ['PLUNGE', 6, 'p l ah n jh', 5], ['PLUNKITT', 8, 'p l ah ng', 4], ['PLUNK', 5, 'p l ah ng k', 5], ['PLUSHED', 7, 'p l ah sh t', 5], ['APPLAUDS', 8, 'p l ao d z', 5], ['IMPLORE', 7, 'p l ao r', 4], ['IMPLORES', 8, 'p l ao z', 4], ['PLOUGHED', 8, 'p l aw d', 4], ['POPLARED', 8, 'p l ax d', 4], ['UPLAND', 6, 'p l ax n d', 5], ['UPLANDS', 7, 'p l ax n d z', 6], ['POPLARED', 8, 'p l ax r d', 5], ['PEOPLERS', 8, 'p l ax r z', 5], ['TOPLESS', 7, 'p l ax s', 4], ['TRIPLET', 7, 'p l ax t', 4], ['TRIPLETS', 8, 'p l ax t s', 5], ['PIPELINE', 8, 'p l ay n', 4], ['PLIGHT', 6, 'p l ay t', 4], ['PLIGHTS', 7, 'p l ay t s', 5], ['WIMPLED', 7, 'p l d', 3], ['PLEB', 4, 'p l eh b', 4], ['PLEBS', 5, 'p l eh b z', 5], ['PLED', 4, 'p l eh d', 4], ['PLEDGE', 6, 'p l eh jh', 4], ['PLEDGED', 7, 'p l eh jh d', 5], ['PLENTY', 6, 'p l eh n', 4], ['UNPLAYED', 8, 'p l ey d', 4], ['PLAGUED', 7, 'p l ey g d', 5], ['PLAGUES', 7, 'p l ey g z', 5], ['VOLPLANE', 8, 'p l ey n', 4], ['PLAINTS', 7, 'p l ey n t s', 6], ['REPLATES', 8, 'p l ey t s', 5], ['UPLIFT', 6, 'p l ih f t', 5], ['UPLIFTS', 7, 'p l ih f t s', 6], ['PLINTH', 6, 'p l ih n th', 5], ['POPLINS', 7, 'p l ih n z', 5], ['WIMPLING', 8, 'p l ih ng', 4], ['TRIPLICE', 8, 'p l ih s', 4], ['PURPLISH', 8, 'p l ih sh', 4], ['TEMPLET', 7, 'p l ih t', 4], ['TEMPLETS', 8, 'p l ih t s', 5], ['PLEACH', 6, 'p l iy ch', 4], ['PLEACHED', 8, 'p l iy ch t', 5], ['PLEAD', 5, 'p l iy d', 4], ['PLEADS', 6, 'p l iy d z', 5], ['UNPLEAT', 7, 'p l iy t', 4], ['PLEATS', 6, 'p l iy t s', 5], ['PLEASE', 6, 'p l iy z', 4], ['PLEASED', 7, 'p l iy z d', 5], ['PLOTTY', 6, 'p l oh', 3], ['PLOD', 4, 'p l oh d', 4], ['PLODS', 5, 'p l oh d z', 5], ['PLODGE', 6, 'p l oh jh', 4], ['APLOMB', 6, 'p l oh m', 4], ['APLOMBS', 7, 'p l oh m z', 5], ['PLONKING', 8, 'p l oh ng', 4], ['PLONK', 5, 'p l oh ng k', 5], ['PLOP', 4, 'p l oh p', 4], ['PLOPS', 5, 'p l oh p s', 5], ['PLOPPED', 7, 'p l oh p t', 5], ['PLOTS', 5, 'p l oh t s', 5], ['PLOSIVES', 8, 'p l ow', 3], ['SHIPLOAD', 8, 'p l ow d', 4], ['PLURALS', 7, 'p l ua', 3], ['PLUVIOUS', 8, 'p l uw', 3], ['PLUME', 5, 'p l uw m', 4], ['PLUMED', 6, 'p l uw m d', 5], ['PLUMES', 6, 'p l uw m z', 5], ['WIMPLES', 7, 'p l z', 3], ['TUPENNY', 7, 'p ng', 2], ['TRIPOD', 6, 'p oh d', 3], ['TRIPODS', 7, 'p oh d z', 4], ['TIP-OFF', 7, 'p oh f', 3], ['TIP-OFFS', 8, 'p oh f s', 4], ['SMALLPOX', 8, 'p oh k s', 4], ['POCKED', 6, 'p oh k t', 4], ['POLLS', 5, 'p oh l z', 4], ['POMP', 4, 'p oh m p', 4], ['POMS', 4, 'p oh m z', 4], ['PONDMAN', 7, 'p oh n d', 4], ["PONDS'", 6, 'p oh n d z', 5], ['PONCE', 5, 'p oh n s', 4], ['DUPONT', 6, 'p oh n t', 4], ['PONTES', 6, 'p oh n t s', 5], ['TARPONS', 7, 'p oh n z', 4], ['PINGPONG', 8, 'p oh ng', 3], ['KAMPONGS', 8, 'p oh ng z', 4], ["POPS'S", 6, 'p oh p', 3], ['POPS', 4, 'p oh p s', 4], ['UNPOPPED', 8, 'p oh p t', 4], ['TRIPOS', 6, 'p oh s', 3], ['RIPOSTE', 7, 'p oh s t', 4], ['RIPOSTES', 8, 'p oh s t s', 5], ['POSH', 4, 'p oh sh', 3], ['POSHED', 6, 'p oh sh t', 4], ['TRAMPOT', 7, 'p oh t', 3], ['TEAPOTS', 7, 'p oh t s', 4], ['REPOS', 5, 'p oh z', 3], ['POACH', 5, 'p ow ch', 3], ['POACHED', 7, 'p ow ch t', 4], ['LYCOPODE', 8, 'p ow d', 3], ['EPODES', 6, 'p ow d z', 4], ['POLK', 4, 'p ow k', 3], ["POLK'S", 6, 'p ow k s', 4], ['POKED', 5, 'p ow k t', 4], ['POLCE', 5, 'p ow l s', 4], ['POULT', 5, 'p ow l t', 4], ['POULTS', 6, 'p ow l t s', 5], ['POME', 4, 'p ow m', 3], ['SAPONE', 6, 'p ow n', 3], ['PROPONED', 8, 'p ow n d', 4], ['PONES', 5, 'p ow n z', 4], ['POPEDOMS', 8, 'p ow p', 3], ['POPES', 5, 'p ow p s', 4], ['ADIPOSE', 7, 'p ow s', 3], ['POTENTLY', 8, 'p ow t', 3], ['CAPOTES', 7, 'p ow t s', 4], ['TEMPOS', 6, 'p ow z', 3], ['COMPOSE', 7, 'p ow zh', 3], ['COMPOSED', 8, 'p ow zh d', 4], ['TEAPOY', 6, 'p oy', 2], ['POISONS', 7, 'p oy z', 3], ['POISED', 6, 'p oy z d', 4], ['SOPRANOS', 8, 'p r aa', 3], ['PRAGUE', 6, 'p r aa g', 4], ["PRAGUE'S", 8, 'p r aa g z', 5], ['PRANCY', 6, 'p r aa n', 4], ['PRANCE', 6, 'p r aa n s', 5], ['PRANCED', 7, 'p r aa n s t', 6], ['PRAM', 4, 'p r ae m', 4], ['PRAMS', 5, 'p r ae m z', 5], ['PRATT', 5, 'p r ae t', 4], ['PRATTS', 6, 'p r ae t s', 5], ['PRUSSIC', 7, 'p r ah', 3], ['SHEEPRUN', 8, 'p r ah n', 4], ['PRAWN', 5, 'p r ao n', 4], ['PRAWNED', 7, 'p r ao n d', 5], ['PRAWNS', 6, 'p r ao n z', 5], ['UPROAR', 6, 'p r ao r', 4], ['UPROARS', 7, 'p r ao z', 4], ['PROWED', 6, 'p r aw d', 4], ['PROWL', 5, 'p r aw l', 4], ['PROWLED', 7, 'p r aw l d', 5], ['PROWLS', 6, 'p r aw l z', 5], ['PROWSE', 6, 'p r aw z', 4], ['CPL.', 4, 'p r ax l', 4], ['APRILS', 6, 'p r ax l z', 5], ['APRONS', 6, 'p r ax n z', 5], ['LEPROUS', 7, 'p r ax s', 4], ['SEPARATE', 8, 'p r ax t', 4], ['PRIED', 5, 'p r ay d', 4], ['PRIDES', 6, 'p r ay d z', 5], ['PRIME', 5, 'p r ay m', 4], ['PRIMED', 6, 'p r ay m d', 5], ['PRIMES', 6, 'p r ay m z', 5], ['PRICE', 5, 'p r ay s', 4], ['UNPRICED', 8, 'p r ay s t', 5], ['UPRIGHTS', 8, 'p r ay t s', 5], ['DEPRIVED', 8, 'p r ay v d', 5], ['DEPRIVES', 8, 'p r ay v z', 5], ['PRAYER', 6, 'p r ea r', 4], ["PRAYER'S", 8, 'p r ea r z', 5], ['PRAYERS', 7, 'p r ea z', 4], ['LIP-READ', 8, 'p r eh d', 4], ['PRENDES', 7, 'p r eh n d z', 6], ['PREP', 4, 'p r eh p', 4], ['PREPS', 5, 'p r eh p s', 5], ['PREPPED', 7, 'p r eh p t', 5], ['PRESQUE', 7, 'p r eh s k', 5], ['IMPRESTS', 8, 'p r eh s t s', 6], ['PRETZELS', 8, 'p r eh t', 4], ['PRESENTS', 8, 'p r eh z', 4], ['UPRAISES', 8, 'p r ey', 3], ['PREYED', 6, 'p r ey d', 4], ['PRATE', 5, 'p r ey t', 4], ['PRATES', 6, 'p r ey t s', 5], ['DEPRAVE', 7, 'p r ey v', 4], ['DEPRAVED', 8, 'p r ey v d', 5], ['DEPRAVES', 8, 'p r ey v z', 5], ['UPRAISE', 7, 'p r ey z', 4], ['UPRAISED', 8, 'p r ey z d', 5], ['UPREARED', 8, 'p r ia d', 4], ['CYPRIAN', 7, 'p r ia n', 4], ['CYPRIANS', 8, 'p r ia n z', 5], ['CUPREOUS', 8, 'p r ia s', 4], ['CYPRIOTS', 8, 'p r ia t s', 5], ['UPREARS', 7, 'p r ia z', 4], ['PRIG', 4, 'p r ih g', 4], ['PRIGS', 5, 'p r ih g z', 5], ['PRICK', 5, 'p r ih k', 4], ['PRICKS', 6, 'p r ih k s', 5], ['APR.', 4, 'p r ih l', 4], ['PRIMULAS', 8, 'p r ih m', 4], ['PRIMMED', 7, 'p r ih m d', 5], ['PRIMP', 5, 'p r ih m p', 5], ['PRIMPS', 6, 'p r ih m p s', 6], ['PRIMPED', 7, 'p r ih m p t', 6], ['PRIMS', 5, 'p r ih m z', 5], ['PRINCE', 6, 'p r ih n s', 5], ['PRINK', 5, 'p r ih ng k', 5], ['EMPRESS', 7, 'p r ih s', 4], ['PREACH', 6, 'p r iy ch', 4], ['PREACHED', 8, 'p r iy ch t', 5], ['LIP-READ', 8, 'p r iy d', 4], ['SUPREMES', 8, 'p r iy m z', 5], ['PREENED', 7, 'p r iy n d', 5], ['PREENS', 6, 'p r iy n z', 5], ['REPRICED', 8, 'p r iy s t', 5], ["PRIESTS'", 8, 'p r iy s t s', 6], ['REPRIEVE', 8, 'p r iy v', 4], ['CAPRIS', 6, 'p r iy z', 4], ['PROD', 4, 'p r oh d', 4], ['PRODS', 5, 'p r oh d z', 5], ['PROF', 4, 'p r oh f', 4], ['PROX.', 5, 'p r oh k s', 5], ['PROM', 4, 'p r oh m', 4], ['PROMS', 5, 'p r oh m z', 5], ['PRONTO', 6, 'p r oh n', 4], ['PRONGING', 8, 'p r oh ng', 4], ['PRONGED', 7, 'p r oh ng d', 5], ['PRONGS', 6, 'p r oh ng z', 5], ['UNPROP', 6, 'p r oh p', 4], ['PROPSED', 7, 'p r oh p s t', 6], ['PROST', 5, 'p r oh s t', 5], ['PROBE', 5, 'p r ow b', 4], ['PROBED', 6, 'p r ow b d', 5], ['PROBES', 6, 'p r ow b z', 5], ['REPROACH', 8, 'p r ow ch', 4], ['PROLE', 5, 'p r ow l', 4], ['PROLES', 6, 'p r ow l z', 5], ['PROSE', 5, 'p r ow z', 4], ['PROSED', 6, 'p r ow z d', 5], ['PRUDES', 6, 'p r uw d z', 5], ['TAPROOM', 7, 'p r uw m', 4], ['TAPROOMS', 8, 'p r uw m z', 5], ['PRUNE', 5, 'p r uw n', 4], ['PRUNED', 6, 'p r uw n d', 5], ['PRUNES', 6, 'p r uw n z', 5], ['UPROOT', 6, 'p r uw t', 4], ['UPROOTS', 7, 'p r uw t s', 5], ['UNPROVEN', 8, 'p r uw v', 4], ['UNPROVED', 8, 'p r uw v d', 5], ['REPROVES', 8, 'p r uw v z', 5], ['POOR', 4, 'p ua r', 3], ["POOR'S", 6, 'p ua r z', 4], ["POOR'S", 6, 'p ua z', 3], ['PUTSCH', 6, 'p uh ch', 3], ['PUDDENS', 7, 'p uh d', 3], ['PULPITS', 7, 'p uh l', 3], ['PULLED', 6, 'p uh l d', 4], ['PULLS', 5, 'p uh l z', 4], ['PUSS', 4, 'p uh s', 3], ['PUSHED', 6, 'p uh sh t', 4], ['POUFFE', 6, 'p uw f', 3], ['POUFS', 5, 'p uw f s', 4], ['POUFFED', 7, 'p uw f t', 4], ['POOLED', 6, 'p uw l d', 4], ['POULT', 5, 'p uw l t', 4], ['POULTS', 6, 'p uw l t s', 5], ['TAMPOON', 7, 'p uw n', 3], ['LAMPOONS', 8, 'p uw n z', 4], ['POOP', 4, 'p uw p', 3], ['POOPS', 5, 'p uw p s', 4], ['POOPED', 6, 'p uw p t', 4], ['PAPOOSE', 7, 'p uw s', 3], ['CAPUCHE', 7, 'p uw sh', 3], ['CAPUCHED', 8, 'p uw sh t', 4], ['SHAMPOOS', 8, 'p uw z', 3], ["PIANO'S", 7, 'p y aa', 3], ['SHIPYARD', 8, 'p y aa d', 4], ['UTOPIAN', 7, 'p y ax n', 4], ['UTOPIANS', 8, 'p y ax n z', 5], ['SEPIAS', 6, 'p y ax z', 4], ['PERM', 4, 'p y eh r m', 5], ['SKOPJE', 6, 'p y ih', 3], ["PUR\\'EES", 8, 'p y ua', 3], ['PUREED', 6, 'p y ua d', 4], ['PAPUAN', 6, 'p y ua n', 4], ['PAPUANS', 7, 'p y ua n z', 5], ['PURE', 4, 'p y ua r', 4], ['PUREED', 6, 'p y ua r d', 5], ['PUREES', 6, 'p y ua r z', 5], ['PUREES', 6, 'p y ua z', 4], ['PUKE', 4, 'p y uw k', 4], ['PUKES', 5, 'p y uw k s', 5], ['PUKED', 5, 'p y uw k t', 5], ['STIPULE', 7, 'p y uw l', 4], ['STIPULED', 8, 'p y uw l d', 5], ['PULES', 5, 'p y uw l z', 5], ['OPPUGN', 6, 'p y uw n', 4], ['OPPUGNS', 7, 'p y uw n z', 5], ['PUCE', 4, 'p y uw s', 4], ['REPUTE', 6, 'p y uw t', 4], ['REPUTES', 7, 'p y uw t s', 5], ['PEWS', 4, 'p y uw z', 4], ['VIRAGOS', 7, 'r aa', 2], ['OVERARCH', 8, 'r aa ch', 3], ['HURRAHED', 8, 'r aa d', 3], ['CHARADES', 8, 'r aa d z', 4], ['GIRAFFES', 8, 'r aa f s', 4], ['RAFTSMEN', 8, 'r aa f t', 4], ['RAFTS', 5, 'r aa f t s', 5], ['SWARAJ', 6, 'r aa jh', 3], ["IRAQ'S", 6, 'r aa k s', 4], ['RALESES', 7, 'r aa l', 3], ['RALES', 5, 'r aa l z', 4], ['UNDERARM', 8, 'r aa m', 3], ['TEHRAN', 6, 'r aa n', 3], ['RANCH', 5, 'r aa n ch', 4], ['RANCHED', 7, 'r aa n ch t', 5], ["TEHRAN'S", 8, 'r aa n z', 4], ['SEMARANG', 8, 'r aa ng', 3], ['RASP', 4, 'r aa s p', 4], ['RASPS', 5, 'r aa s p s', 5], ['RASPED', 6, 'r aa s p t', 5], ['MIRAGE', 6, 'r aa zh', 3], ['MIRAGED', 7, 'r aa zh d', 4], ['WRATHERS', 8, 'r ae', 2], ['RATCH', 5, 'r ae ch', 3], ['SUPERADD', 8, 'r ae d', 3], ['CARAFE', 6, 'r ae f', 3], ['CARAFES', 7, 'r ae f s', 4], ['RAGTIMES', 8, 'r ae g', 3], ['RAGGED', 6, 'r ae g d', 4], ['RAGS', 4, 'r ae g z', 4], ['WRACK', 5, 'r ae k', 3], ['WRACKS', 6, 'r ae k s', 4], ['WRACKED', 7, 'r ae k t', 4], ["CHIRAC'S", 8, 'r ae k z', 4], ['PONDERAL', 8, 'r ae l', 3], ["RALPHS'S", 8, 'r ae l f', 4], ['RALPHS', 6, 'r ae l f s', 5], ['SHOREHAM', 8, 'r ae m', 3], ['RAMMED', 6, 'r ae m d', 4], ['RAMP', 4, 'r ae m p', 4], ['RAMPS', 5, 'r ae m p s', 5], ['RAMPED', 6, 'r ae m p t', 5], ['VERANDAS', 8, 'r ae n', 3], ['RAND', 4, 'r ae n d', 4], ['RANDS', 5, 'r ae n d z', 5], ['RANCE', 5, 'r ae n s', 4], ['RANT', 4, 'r ae n t', 4], ['RANTS', 5, 'r ae n t s', 5], ['AMARANTH', 8, 'r ae n th', 4], ['RANKNESS', 8, 'r ae ng k', 4], ['RANKS', 5, 'r ae ng k s', 5], ['RANKED', 6, 'r ae ng k t', 5], ['WRAP', 4, 'r ae p', 3], ['WRAPS', 5, 'r ae p s', 4], ['WRAPPED', 7, 'r ae p t', 4], ['WRASSE', 6, 'r ae s', 3], ['PEDERAST', 8, 'r ae s t', 4], ['RASH', 4, 'r ae sh', 3], ['RASHED', 6, 'r ae sh t', 4], ['WHEREAT', 7, 'r ae t', 3], ['RAVENED', 7, 'r ae v', 3], ['WHEREAS', 7, 'r ae z', 3], ['RUBBED', 6, 'r ah b d', 4], ['RUBS', 4, 'r ah b z', 4], ['RUDMANS', 7, 'r ah d', 3], ['RUFF', 4, 'r ah f', 3], ['RUFFS', 5, 'r ah f s', 4], ['RUFFED', 6, 'r ah f t', 4], ['RUGBY', 5, 'r ah g', 3], ['RUGS', 4, 'r ah g z', 4], ['RUXPIN', 6, 'r ah k', 3], ['RUCKS', 5, 'r ah k s', 4], ['RUCKED', 6, 'r ah k t', 4], ['ERUCTS', 6, 'r ah k t s', 5], ['MERRILL', 7, 'r ah l', 3], ['MERRILLS', 8, 'r ah l z', 4], ['RUMPUSES', 8, 'r ah m', 3], ['RUMPS', 5, 'r ah m p s', 5], ['RHUMBS', 6, 'r ah m z', 4], ['RUNT', 4, 'r ah n t', 4], ['RUNTS', 5, 'r ah n t s', 5], ['WRUNG', 5, 'r ah ng', 3], ['RUNGS', 5, 'r ah ng z', 4], ['IRRUPTS', 7, 'r ah p t s', 5], ['RUSS', 4, 'r ah s', 3], ['RUSK', 4, 'r ah s k', 4], ['RUSKS', 5, 'r ah s k s', 5], ['RUSTS', 5, 'r ah s t s', 5], ['RUSH', 4, 'r ah sh', 3], ['RUSHED', 6, 'r ah sh t', 4], ['RUT', 3, 'r ah t', 3], ['RUTS', 4, 'r ah t s', 4], ['ROARED', 6, 'r ao d', 3], ['MARAUDS', 7, 'r ao d z', 4], ['OVERALL', 7, 'r ao l', 3], ['OVERALLS', 8, 'r ao l z', 4], ['ROAR', 4, 'r ao r', 3], ['VASTERAS', 8, 'r ao s', 3], ['ROTH', 4, 'r ao th', 3], ["ROTH'S", 6, 'r ao th s', 4], ['ROARS', 5, 'r ao z', 3], ['ROWINGS', 7, 'r aw', 2], ['ROWED', 5, 'r aw d', 3], ['ROUNCE', 6, 'r aw n s', 4], ['ROWS', 4, 'r aw z', 3], ['ROUSED', 6, 'r aw z d', 4], ['ZIPPERER', 8, 'r ax', 2], ['SCARAB', 6, 'r ax b', 3], ["ARABS'", 6, 'r ax b s', 4], ['SCARABS', 7, 'r ax b z', 4], ['TIARAED', 7, 'r ax d', 3], ['TERAPH', 6, 'r ax f', 3], ['SERAPHS', 7, 'r ax f s', 4], ['HORROCKS', 8, 'r ax k s', 4], ['HERALDS', 7, 'r ax l d z', 5], ['VIRALS', 6, 'r ax l z', 4], ['VARIORUM', 8, 'r ax m', 3], ['WARREN', 6, 'r ax n', 3], ['WARRAND', 7, 'r ax n d', 4], ['WARRANT', 7, 'r ax n t', 4], ['DARENTH', 7, 'r ax n th', 4], ['ORANG', 5, 'r ax ng', 3], ['ORANGS', 6, 'r ax ng z', 4], ['SYRUP', 5, 'r ax p', 3], ['SYRUPS', 6, 'r ax p s', 4], ['SYRUPED', 7, 'r ax p t', 4], ["EUROPE'S", 8, 'r ax p z', 4], ["WEARER'S", 8, 'r ax r z', 4], ['GARRETH', 7, 'r ax th', 3], ["THERE'VE", 8, 'r ax v', 3], ['WRYNECKS', 8, 'r ay', 2], ['RIDES', 5, 'r ay d z', 4], ['WRITHE', 6, 'r ay dh', 3], ['WRITHED', 7, 'r ay dh d', 4], ['WRITHES', 7, 'r ay dh z', 4], ['RIFE', 4, 'r ay f', 3], ['REICH', 5, 'r ay k', 3], ['REICHS', 6, 'r ay k s', 4], ['VIRILE', 6, 'r ay l', 3], ['RILED', 5, 'r ay l d', 4], ['RILES', 5, 'r ay l z', 4], ['RIME', 4, 'r ay m', 3], ['RIMED', 5, 'r ay m d', 4], ['RIMES', 5, 'r ay m z', 4], ['RIND', 4, 'r ay n d', 4], ['RINDS', 5, 'r ay n d z', 5], ['RHINES', 6, 'r ay n z', 4], ['UNRIPED', 7, 'r ay p t', 4], ['WRITES', 6, 'r ay t s', 4], ['RIVE', 4, 'r ay v', 3], ['UNRIVED', 7, 'r ay v d', 4], ['RIVES', 5, 'r ay v z', 4], ["WHERE'ER", 8, 'r ea', 2], ['RARE', 4, 'r ea r', 3], ['WRETCHES', 8, 'r eh', 2], ['WRETCH', 6, 'r eh ch', 3], ['RETCHED', 7, 'r eh ch t', 4], ['UNREAD', 6, 'r eh d', 3], ['REDS', 4, 'r eh d z', 4], ['REFSNES', 7, 'r eh f', 3], ['REFT', 4, 'r eh f t', 4], ['REGNUM', 6, 'r eh g', 3], ["IMREG'S", 7, 'r eh g z', 4], ['REG', 3, 'r eh jh', 3], ['WREXHAM', 7, 'r eh k', 3], ['WRECKS', 6, 'r eh k s', 4], ['WRECKED', 7, 'r eh k t', 4], ['MOREL', 5, 'r eh l', 3], ['REALM', 5, 'r eh l m', 4], ['REALMS', 6, 'r eh l m z', 5], ['MORELS', 6, 'r eh l z', 4], ['WRENCH', 6, 'r eh n ch', 4], ['WRENCHED', 8, 'r eh n ch t', 5], ['REND', 4, 'r eh n d', 4], ['RENDS', 5, 'r eh n d z', 5], ['RENTS', 5, 'r eh n t s', 5], ['WRNS', 4, 'r eh n z', 4], ['REPS', 4, 'r eh p s', 4], ['REPPED', 6, 'r eh p t', 4], ['WREST', 5, 'r eh s t', 4], ['WRESTS', 6, 'r eh s t s', 5], ['KORESH', 6, 'r eh sh', 3], ['REVVED', 6, 'r eh v d', 4], ['REVS', 4, 'r eh v z', 4], ['RES', 3, 'r eh z', 3], ['PARERGON', 8, 'r er', 2], ['H._R._H.', 8, 'r ey ch', 3], ['TIRADE', 6, 'r ey d', 3], ['TIRADES', 7, 'r ey d z', 4], ['RAIFF', 5, 'r ey f', 3], ["REAGAN'S", 8, 'r ey g', 3], ['RAGE', 4, 'r ey jh', 3], ['RAGED', 5, 'r ey jh d', 4], ['RAKE', 4, 'r ey k', 3], ['RAKES', 5, 'r ey k s', 4], ['RAKED', 5, 'r ey k t', 4], ['RAILCARS', 8, 'r ey l', 3], ['RAILED', 6, 'r ey l d', 4], ['RAILS', 5, 'r ey l z', 4], ['DURAMED', 7, 'r ey m d', 4], ['TERRAIN', 7, 'r ey n', 3], ['REINED', 6, 'r ey n d', 4], ['RANGED', 6, 'r ey n jh d', 5], ['TERRAINS', 8, 'r ey n z', 4], ['RAPE', 4, 'r ey p', 3], ['RAPES', 5, 'r ey p s', 4], ['RAPED', 5, 'r ey p t', 4], ['REIS', 4, 'r ey s', 3], ['RACED', 5, 'r ey s t', 4], ['WRAITH', 6, 'r ey th', 3], ['WRAITHS', 7, 'r ey th s', 4], ['RAVENS', 6, 'r ey v', 3], ['RAVED', 5, 'r ey v d', 4], ['RAVES', 5, 'r ey v z', 4], ['RAZEED', 6, 'r ey z d', 4], ['WORRIER', 7, 'r ia', 2], ['REARED', 6, 'r ia d', 3], ['PERIODS', 7, 'r ia d z', 4], ['VIVARIUM', 8, 'r ia m', 3], ['ZAIREAN', 7, 'r ia n', 3], ['VARIANCE', 8, 'r ia n s', 4], ['VARIANT', 7, 'r ia n t', 4], ['VARIANTS', 8, 'r ia n t s', 5], ['ZAIREANS', 8, 'r ia n z', 4], ['WIRIER', 6, 'r ia r', 3], ['WORRIERS', 8, 'r ia z', 3], ['ZORILLO', 7, 'r ih', 2], ['RIBBED', 6, 'r ih b d', 4], ['RICHNESS', 8, 'r ih ch', 3], ['ENRICHED', 8, 'r ih ch t', 4], ['WORRIED', 7, 'r ih d', 3], ['TARIFFS', 7, 'r ih f s', 4], ['TARIFFED', 8, 'r ih f t', 4], ['RIFTS', 5, 'r ih f t s', 5], ['RIGS', 4, 'r ih g z', 4], ['ZURICH', 6, 'r ih k', 3], ["ZURICH'S", 8, 'r ih k s', 4], ['WRICKED', 7, 'r ih k t', 4], ['ZORILLE', 7, 'r ih l', 3], ['RILLED', 6, 'r ih l d', 4], ['RILLS', 5, 'r ih l z', 4], ['RIMMED', 6, 'r ih m d', 4], ['RIMS', 4, 'r ih m z', 4], ['TAMARIND', 8, 'r ih n d', 4], ['SYRINGE', 7, 'r ih n jh', 4], ['SYRINGED', 8, 'r ih n jh d', 5], ['RINSE', 5, 'r ih n s', 4], ['RINSED', 6, 'r ih n s t', 5], ['URINES', 6, 'r ih n z', 4], ['WRINGED', 7, 'r ih ng d', 4], ['SYRINXES', 8, 'r ih ng k', 4], ['SYRINX', 6, 'r ih ng k s', 5], ['WRINGS', 6, 'r ih ng z', 4], ['RIPTIDES', 8, 'r ih p', 3], ['RIPS', 4, 'r ih p s', 4], ['RIPPED', 6, 'r ih p t', 4], ['TAMARISK', 8, 'r ih s k', 4], ['RISKED', 6, 'r ih s k t', 5], ['WRISTS', 6, 'r ih s t s', 5], ['WRITTEN', 7, 'r ih t', 3], ['WRITS', 5, 'r ih t s', 4], ['PENRITH', 7, 'r ih th', 3], ['RIVEN', 5, 'r ih v', 3], ['ZINGARI', 7, 'r iy', 2], ['REREAD', 6, 'r iy d', 3], ['REREADS', 7, 'r iy d z', 4], ['WREATHE', 7, 'r iy dh', 3], ['WREATHED', 8, 'r iy dh d', 4], ['WREATHS', 7, 'r iy dh z', 4], ['SHARIF', 6, 'r iy f', 3], ['SHARIFS', 7, 'r iy f s', 4], ['REEFED', 6, 'r iy f t', 4], ['WREAK', 5, 'r iy k', 3], ['WREAKS', 6, 'r iy k s', 4], ['WREAKED', 7, 'r iy k t', 4], ['SURREAL', 7, 'r iy l', 3], ['REELED', 6, 'r iy l d', 4], ['REELS', 5, 'r iy l z', 4], ['URAEMIA', 7, 'r iy m', 3], ['REAMED', 6, 'r iy m d', 4], ['TRIREMES', 8, 'r iy m z', 4], ['REAP', 4, 'r iy p', 3], ['REAPS', 5, 'r iy p s', 4], ['REAPED', 6, 'r iy p t', 4], ['REES', 4, 'r iy s', 3], ['RICHES', 6, 'r iy sh', 3], ['OVEREATS', 8, 'r iy t s', 4], ['WREATH', 6, 'r iy th', 3], ['WREATHS', 7, 'r iy th s', 4], ['REEVE', 5, 'r iy v', 3], ['REEVED', 6, 'r iy v d', 4], ['REEVES', 6, 'r iy v z', 4], ['VIRES', 5, 'r iy z', 3], ['FARLEY', 6, 'r l ih', 3], ['AIRLIFT', 7, 'r l ih f t', 5], ['MARLIN', 6, 'r l ih n', 4], ["MARLIN'S", 8, 'r l ih n z', 5], ['KARLING', 7, 'r l ih ng', 4], ["FARLEY'S", 8, 'r l ih z', 4], ['ORLOFF', 6, 'r l oh f', 4], ["ROBSON'S", 8, 'r oh b', 3], ['ROBBED', 6, 'r oh b d', 4], ['ROBS', 4, 'r oh b z', 4], ['ROCHDALE', 8, 'r oh ch', 3], ['KASPAROV', 8, 'r oh f', 3], ['XEROXING', 8, 'r oh k', 3], ['XEROX', 5, 'r oh k s', 4], ['XEROXED', 7, 'r oh k s t', 5], ['ROCKED', 6, 'r oh k t', 4], ['ROMPRESS', 8, 'r oh m', 3], ['ROMP', 4, 'r oh m p', 4], ['ROMPS', 5, 'r oh m p s', 5], ['ROMPED', 6, 'r oh m p t', 5], ['RHOMBS', 6, 'r oh m z', 4], ['WHEREON', 7, 'r oh n', 3], ['MORONS', 6, 'r oh n z', 4], ['WRONGLY', 7, 'r oh ng', 3], ['WRONGED', 7, 'r oh ng d', 4], ['WRONGS', 6, 'r oh ng z', 4], ['ROSS', 4, 'r oh s', 3], ['LAROCHE', 7, 'r oh sh', 3], ['WROCLAW', 7, 'r oh t', 3], ['ROTS', 4, 'r oh t s', 4], ['WRATH', 5, 'r oh th', 3], ['WRATHS', 6, 'r oh th s', 4], ['WRATHED', 7, 'r oh th t', 4], ['WHEREOF', 7, 'r oh v', 3], ["CARO'S", 6, 'r oh z', 3], ['UNROBE', 6, 'r ow b', 3], ['UNROBED', 7, 'r ow b d', 4], ['UNROBES', 7, 'r ow b z', 4], ['ROCHE', 5, 'r ow ch', 3], ['ROACHED', 7, 'r ow ch t', 4], ['ZEROED', 6, 'r ow d', 3], ['ROADS', 5, 'r ow d z', 4], ['ROGUE', 5, 'r ow g', 3], ['ROGUED', 6, 'r ow g d', 4], ['ROGUES', 6, 'r ow g z', 4], ['ROKE', 4, 'r ow k', 3], ['UNROLLED', 8, 'r ow l d', 4], ['UNROLLS', 7, 'r ow l z', 4], ['ROME', 4, 'r ow m', 3], ['ROAMED', 6, 'r ow m d', 4], ["ROME'S", 6, 'r ow m z', 4], ['TYRONE', 6, 'r ow n', 3], ['ROANS', 5, 'r ow n z', 4], ['UNROPE', 6, 'r ow p', 3], ['TOWROPES', 8, 'r ow p s', 4], ['UNROPED', 7, 'r ow p t', 4], ['TUBEROSE', 8, 'r ow s', 3], ['ROAST', 5, 'r ow s t', 4], ['ROASTS', 6, 'r ow s t s', 5], ['WROTE', 5, 'r ow t', 3], ['WROTH', 5, 'r ow th', 3], ['ROVE', 4, 'r ow v', 3], ['ROVED', 5, 'r ow v d', 4], ['ROVES', 5, 'r ow v z', 4], ['ZEROS', 5, 'r ow z', 3], ['EROSIONS', 8, 'r ow zh', 3], ['THYROID', 7, 'r oy d', 3], ['THYROIDS', 8, 'r oy d z', 4], ['ROIL', 4, 'r oy l', 3], ['ROILED', 6, 'r oy l d', 4], ['ROYCE', 5, 'r oy s', 3], ['ROOK', 4, 'r uh k', 3], ['ROOKS', 5, 'r uh k s', 4], ['ROOKED', 6, 'r uh k t', 4], ['RUHR', 4, 'r uh r', 3], ['RUUD', 4, 'r uw d', 3], ['ROODS', 5, 'r uw d z', 4], ['ROOFED', 6, 'r uw f t', 4], ['PERUKE', 6, 'r uw k', 3], ['PERUKES', 7, 'r uw k s', 4], ['UNRULE', 6, 'r uw l', 3], ['UNRULED', 7, 'r uw l d', 4], ['RULES', 5, 'r uw l z', 4], ['ROOMED', 6, 'r uw m d', 4], ['RUNE', 4, 'r uw n', 3], ['RUNES', 5, 'r uw n z', 4], ['CERUSE', 6, 'r uw s', 3], ['ROOST', 5, 'r uw s t', 4], ['ROOSTS', 6, 'r uw s t s', 5], ['RUCHE', 5, 'r uw sh', 3], ['ROUTES', 6, 'r uw t s', 4], ['RUTH', 4, 'r uw th', 3], ["RUTH'S", 6, 'r uw th s', 4], ['SUBARUS', 7, 'r uw z', 3], ['PERUSED', 7, 'r uw z d', 4], ['ROUGE', 5, 'r uw zh', 3], ['ROUGED', 6, 'r uw zh d', 4], ['NORWALK', 7, 'r w oh l k', 5], ['SPHERULE', 8, 'r y uw l', 4], ['SAHIB', 5, 's aa b', 3], ['SAHIBS', 6, 's aa b z', 4], ['MANSARD', 7, 's aa d', 3], ['MANSARDS', 8, 's aa d z', 4], ['HEXARCH', 7, 's aa k', 3], ['EXARCHS', 7, 's aa k s', 4], ['SOMBERLY', 8, 's aa m', 3], ['PSALMS', 6, 's aa m z', 4], ['TUCSON', 6, 's aa n', 3], ["TUCSON'S", 8, 's aa n z', 4], ['SANGO', 5, 's aa ng', 3], ["PULSAR'S", 8, 's aa r z', 4], ['THASSOS', 7, 's aa s', 3], ['PULSARS', 7, 's aa z', 3], ['MASSAGE', 7, 's aa zh', 3], ['MASSAGED', 8, 's aa zh d', 4], ["ASSAD'S", 7, 's ae d z', 4], ['SAG', 3, 's ae g', 3], ['SAGGED', 6, 's ae g d', 4], ['SAGS', 4, 's ae g z', 4], ['WOOLSACK', 8, 's ae k', 3], ['SAX', 3, 's ae k s', 4], ['SACKED', 6, 's ae k t', 4], ['SALVE', 5, 's ae l v', 4], ['SALVED', 6, 's ae l v d', 5], ['SALVES', 6, 's ae l v z', 5], ["SAM'S", 5, 's ae m z', 4], ['SANDS', 5, 's ae n d z', 5], ['SANS', 4, 's ae n z', 4], ['SAPWOODS', 8, 's ae p', 3], ['SAPS', 4, 's ae p s', 4], ['SAPPED', 6, 's ae p t', 4], ['SASS', 4, 's ae s', 3], ['SASSED', 6, 's ae s t', 4], ['SASHED', 6, 's ae sh t', 4], ['SATSUMAS', 8, 's ae t', 3], ['SUBBED', 6, 's ah b d', 4], ['SUBS', 4, 's ah b z', 4], ['SUCH', 4, 's ah ch', 3], ['SUDSING', 7, 's ah d', 3], ['SUDS', 4, 's ah d z', 4], ['SUDSED', 6, 's ah d z d', 5], ['SOUGH', 5, 's ah f', 3], ['SOUGHS', 6, 's ah f s', 4], ['SOUGHED', 7, 's ah f t', 4], ['SUCTIONS', 8, 's ah k', 3], ['SUCKS', 5, 's ah k s', 4], ['SUCKED', 6, 's ah k t', 4], ['UNSULTRY', 8, 's ah l', 3], ['SULK', 4, 's ah l k', 4], ['SULKS', 5, 's ah l k s', 5], ['SULKED', 6, 's ah l k t', 5], ['RUSSELLS', 8, 's ah l z', 4], ['SUMMED', 6, 's ah m d', 4], ['SUMPS', 5, 's ah m p s', 5], ['SUMS', 4, 's ah m z', 4], ['WILSON', 6, 's ah n', 3], ['SUNNED', 6, 's ah n d', 4], ['WILSONS', 7, 's ah n z', 4], ['UNSUNKEN', 8, 's ah ng', 3], ['SUNK', 4, 's ah ng k', 4], ["SUNG'S", 6, 's ah ng z', 4], ['TOSS-UP', 7, 's ah p', 3], ['TOSS-UPS', 8, 's ah p s', 4], ['SUPPED', 6, 's ah p t', 4], ['SUSS', 4, 's ah s', 3], ['SUSSED', 6, 's ah s t', 4], ['WARSAW', 6, 's ao', 2], ['ADSORB', 6, 's ao b', 3], ['SORBED', 6, 's ao b d', 4], ['ADSORBS', 7, 's ao b z', 4], ['WALSALL', 7, 's ao l', 3], ['UNSALT', 6, 's ao l t', 4], ['SAWN', 4, 's ao n', 3], ['SORE', 4, 's ao r', 3], ['SOARES', 6, 's ao r z', 4], ['SOURCE', 6, 's ao s', 3], ['SOURCED', 7, 's ao s t', 4], ['UNSOUGHT', 8, 's ao t', 3], ['SORTS', 5, 's ao t s', 4], ['WARSAWS', 7, 's ao z', 3], ['SOW', 3, 's aw', 2], ['SOUTH', 5, 's aw dh', 3], ['SOUTHED', 7, 's aw dh d', 4], ['SOUTHS', 6, 's aw dh z', 4], ['SOUNDS', 6, 's aw n d z', 5], ['SOUSE', 5, 's aw s', 3], ['SOUSED', 6, 's aw s t', 4], ['SOUTHS', 6, 's aw th s', 4], ['SOUTHED', 7, 's aw th t', 4], ['SOWS', 4, 's aw z', 3], ['YASSER', 6, 's ax', 2], ['TUSSOCKS', 8, 's ax k s', 4], ['VESSELED', 8, 's ax l d', 4], ['VESSELS', 7, 's ax l z', 4], ['WREXHAM', 7, 's ax m', 3], ['TRANSOMS', 8, 's ax m z', 4], ['WORSEN', 6, 's ax n', 3], ['WORSENED', 8, 's ax n d', 4], ['VERSANT', 7, 's ax n t', 4], ['WORSENS', 7, 's ax n z', 4], ['JESSOP', 6, 's ax p', 3], ['HYSSOPS', 7, 's ax p s', 4], ['YASSER', 6, 's ax r', 3], ['ULCERED', 7, 's ax r d', 4], ['VS.', 3, 's ax s', 3], ['CENSUSED', 8, 's ax s t', 4], ['WAYSIDER', 8, 's ay', 2], ['WAYSIDES', 8, 's ay d z', 4], ['SCYTHE', 6, 's ay dh', 3], ['SCYTHED', 7, 's ay dh d', 4], ['SCYTHES', 7, 's ay dh z', 4], ["SIKES'S", 7, 's ay k', 3], ['SIKES', 5, 's ay k s', 4], ['TENSILE', 7, 's ay l', 3], ['CYME', 4, 's ay m', 3], ['URSINE', 6, 's ay n', 3], ['UNSIGNED', 8, 's ay n d', 4], ['SYCE', 4, 's ay s', 3], ['UNSIGHT', 7, 's ay t', 3], ['SITES', 5, 's ay t s', 4], ['KILSYTH', 7, 's ay th', 3], ['DISBARK', 7, 's b aa k', 4], ['GASBAG', 6, 's b ae g', 4], ['GASBAGS', 7, 's b ae g z', 5], ['DISBANDS', 8, 's b ae n d z', 6], ['RIKSBANK', 8, 's b ae ng k', 5], ['DISBUD', 6, 's b ah d', 4], ['DISBUDS', 7, 's b ah d z', 5], ['BASEBALL', 8, 's b ao l', 4], ['ICEBOUND', 8, 's b aw n d', 5], ['WESTBURY', 8, 's b ax', 3], ['WURZBURG', 8, 's b er g', 4], ['CROSBYS', 7, 's b ih z', 4], ['GROSBEAK', 8, 's b iy k', 4], ['TEXTBOOK', 8, 's b uh k', 4], ['VESTURED', 8, 's ch ax d', 4], ['VESTURE', 7, 's ch ax r', 4], ['VESTURES', 8, 's ch ax z', 4], ['EXCHANGE', 8, 's ch ey n jh', 5], ['MISCHIEF', 8, 's ch ih f', 4], ['ESCHEAT', 7, 's ch iy t', 4], ['VESTUARY', 8, 's ch ua', 3], ['ESCHEWED', 8, 's ch uw d', 4], ['ESCHEWS', 7, 's ch uw z', 4], ['POTSDAM', 7, 's d ae m', 4], ['MISDEALT', 8, 's d eh l t', 5], ['DISDAINS', 8, 's d ey n z', 5], ['MISDATE', 7, 's d ey t', 4], ['MISDATES', 8, 's d ey t s', 5], ['MISDEED', 7, 's d iy d', 4], ['MISDEEDS', 8, 's d iy d z', 5], ['MISDEAL', 7, 's d iy l', 4], ['MISDEALS', 8, 's d iy l z', 5], ['NIXDORF', 7, 's d oh f', 4], ['HOUSEDOG', 8, 's d oh g', 4], ['ICEDROME', 8, 's d r ow m', 5], ['CORSAIR', 7, 's ea r', 3], ['UNSAID', 6, 's eh d', 3], ["SAID'S", 6, 's eh d z', 4], ['UNICEF', 6, 's eh f', 3], ["UNICEF'S", 8, 's eh f s', 4], ['SEDGE', 5, 's eh jh', 3], ['SEDGED', 6, 's eh jh d', 4], ['UNSEX', 5, 's eh k s', 4], ['UNSEXED', 7, 's eh k s t', 5], ['VIVISECT', 8, 's eh k t', 4], ['YOURSELF', 8, 's eh l f', 4], ["SELF'S", 6, 's eh l f s', 5], ['SELFED', 6, 's eh l f t', 5], ['SENSE', 5, 's eh n s', 4], ['UNSENSED', 8, 's eh n s t', 5], ['UNACCENT', 8, 's eh n t', 4], ['SENTES', 6, 's eh n t s', 5], ['SENDS', 5, 's eh n z', 4], ['SENG', 4, 's eh ng', 3], ["SENG'S", 6, 's eh ng z', 4], ['TRICEPS', 7, 's eh p s', 4], ['UNACCEPT', 8, 's eh p t', 4], ['WELL-SET', 8, 's eh t', 3], ['SETH', 4, 's eh th', 3], ["SETH'S", 6, 's eh th s', 4], ['SAYS', 4, 's eh z', 3], ['YASSER', 6, 's er', 2], ['SERB', 4, 's er b', 3], ['SERBS', 5, 's er b z', 4], ['SEARCHED', 8, 's er ch t', 4], ['SURD', 4, 's er d', 3], ['SURDS', 5, 's er d z', 4], ["SURF'S", 6, 's er f s', 4], ['SURFED', 6, 's er f t', 4], ['EXERGUE', 7, 's er g', 3], ['UPSURGE', 7, 's er jh', 3], ['UPSURGED', 8, 's er jh d', 4], ['CIRQUE', 6, 's er k', 3], ['CIRQUES', 7, 's er k s', 4], ['SEARLE', 6, 's er l', 3], ['SEARLES', 7, 's er l z', 4], ['DISCERNS', 8, 's er n z', 4], ['EXCERPT', 7, 's er p t', 4], ['EXCERPTS', 8, 's er p t s', 5], ['SIR', 3, 's er r', 3], ['SUBSERVE', 8, 's er v', 3], ['SIRS', 4, 's er z', 3], ['SAKE', 4, 's ey k', 3], ['SAKES', 5, 's ey k s', 4], ['UNINSANE', 8, 's ey n', 3], ['SEINED', 6, 's ey n d', 4], ['ST.', 3, 's ey n t', 4], ["SAINTS'", 7, 's ey n t s', 5], ['SEINES', 6, 's ey n z', 4], ['SAVE', 4, 's ey v', 3], ['SAVED', 5, 's ey v d', 4], ['SAVES', 5, 's ey v z', 4], ['UNSAYS', 6, 's ey z', 3], ['DISGUSTS', 8, 's g ah s t s', 6], ['DISGORGE', 8, 's g ao jh', 4], ['MISGUIDE', 8, 's g ay d', 4], ['MISGAVE', 7, 's g ey v', 4], ['MISGIVEN', 8, 's g ih v', 4], ['MISGIVES', 8, 's g ih v z', 5], ['FOXGLOVE', 8, 's g l ah v', 5], ['DISGRADE', 8, 's g r ey d', 5], ['MISHAP', 6, 's hh ae p', 4], ['MISHAPS', 7, 's hh ae p s', 5], ['FOXHUNT', 7, 's hh ah n t', 5], ['GOSHAWK', 7, 's hh ao k', 4], ['GOSHAWKS', 8, 's hh ao k s', 5], ['VAUXHALL', 8, 's hh ao l', 4], ['SAXHORN', 7, 's hh ao n', 4], ['SAXHORNS', 8, 's hh ao n z', 5], ['FOXHOUND', 8, 's hh aw n d', 5], ['EXHALING', 8, 's hh ey', 3], ['EXHALE', 6, 's hh ey l', 4], ['EXHALED', 7, 's hh ey l d', 5], ['EXHALES', 7, 's hh ey l z', 5], ['BEXHILL', 7, 's hh ih l', 4], ['FOXHOLES', 8, 's hh ow l z', 5], ['EXHUMING', 8, 's hh y uw', 4], ['EXHUME', 6, 's hh y uw m', 5], ['WAXIER', 6, 's ia', 2], ['SEARED', 6, 's ia d', 3], ['UNIAXIAL', 8, 's ia l', 3], ['UNCIALS', 7, 's ia l z', 4], ['HESSIANS', 8, 's ia n z', 4], ['WAXIER', 6, 's ia r', 3], ["SEAR'S", 6, 's ia r z', 4], ['OSSEOUS', 7, 's ia s', 3], ['ZEALOUSY', 8, 's ih', 2], ["SIBSON'S", 8, 's ih b', 3], ['VISCID', 6, 's ih d', 3], ["PLACID'S", 8, 's ih d z', 4], ['SIFTON', 6, 's ih f', 3], ['SIFT', 4, 's ih f t', 4], ['SIFTS', 5, 's ih f t s', 5], ['USAGE', 5, 's ih jh', 3], ['PASSAGED', 8, 's ih jh d', 4], ["WESSEX'S", 8, 's ih k', 3], ['WESSEX', 6, 's ih k s', 4], ['SIXTE', 5, 's ih k s t', 5], ['SIXTES', 6, 's ih k s t s', 6], ['SIXTH', 5, 's ih k s th', 5], ['SICKED', 6, 's ih k t', 4], ['BASICS', 6, 's ih k z', 4], ['SYLPH', 5, 's ih l f', 4], ['SYLPHS', 6, 's ih l f s', 5], ['SILKMAN', 7, 's ih l k', 4], ['SILKS', 5, 's ih l k s', 5], ['SILKED', 6, 's ih l k t', 5], ['SILT', 4, 's ih l t', 4], ['SILTS', 5, 's ih l t s', 5], ['MAXIMED', 7, 's ih m d', 4], ['SYMPTONS', 8, 's ih m p', 4], ['SYMMS', 5, 's ih m z', 4], ['YELTSIN', 7, 's ih n', 3], ['UNCINCH', 7, 's ih n ch', 4], ['CINCHED', 7, 's ih n ch t', 5], ['SINNED', 6, 's ih n d', 4], ['RESCINDS', 8, 's ih n d z', 5], ['SINGE', 5, 's ih n jh', 4], ['SINGED', 6, 's ih n jh d', 5], ['SINCE', 5, 's ih n s', 4], ['YELTSINS', 8, 's ih n z', 4], ['XEROXING', 8, 's ih ng', 3], ['SYNC', 4, 's ih ng k', 4], ["SINKS'", 6, 's ih ng k s', 5], ['WAXINGS', 7, 's ih ng z', 4], ['SIP', 3, 's ih p', 3], ['SIPS', 4, 's ih p s', 4], ['SIPPED', 6, 's ih p t', 4], ['ZYMOSIS', 7, 's ih s', 3], ["SISK'S", 6, 's ih s k s', 5], ['SIXISH', 6, 's ih sh', 3], ['TRANSITS', 8, 's ih t s', 4], ['SIEVED', 6, 's ih v d', 4], ['YESES', 5, 's ih z', 3], ['BESEECH', 7, 's iy ch', 3], ['SEETHE', 6, 's iy dh', 3], ['SEETHED', 7, 's iy dh d', 4], ['SEETHES', 7, 's iy dh z', 4], ['MASSIF', 6, 's iy f', 3], ['MASSIFS', 7, 's iy f s', 4], ['SIEGE', 5, 's iy jh', 3], ['SIEGED', 6, 's iy jh d', 4], ['SIKHS', 5, 's iy k s', 4], ['UNSEAL', 6, 's iy l', 3], ['UNSEALED', 8, 's iy l d', 4], ['UNSEALS', 7, 's iy l z', 4], ['UNSEEMLY', 8, 's iy m', 3], ['SEEMED', 6, 's iy m d', 4], ['SEEMS', 5, 's iy m z', 4], ['VACCINE', 7, 's iy n', 3], ['VACCINES', 8, 's iy n z', 4], ['SEEP', 4, 's iy p', 3], ['SEEPS', 5, 's iy p s', 4], ['SEEPED', 6, 's iy p t', 4], ['SURCEASE', 8, 's iy s', 3], ['UNSEAT', 6, 's iy t', 3], ['UNSEATS', 7, 's iy t s', 4], ['W._C._S.', 8, 's iy z', 3], ['SEIZED', 6, 's iy z d', 4], ['DISJOINT', 8, 's jh oy n t', 5], ['DISJOINS', 8, 's jh oy n z', 5], ['SCARRED', 7, 's k aa d', 4], ['SCARFS', 6, 's k aa f s', 5], ['SCARFED', 7, 's k aa f t', 5], ['SCARP', 5, 's k aa p', 4], ['SCARPS', 6, 's k aa p s', 5], ['SCARPED', 7, 's k aa p t', 5], ["SCAR'S", 6, 's k aa r z', 5], ['MISCAST', 7, 's k aa s t', 5], ['MISCASTS', 8, 's k aa s t s', 6], ['SCARVED', 7, 's k aa v d', 5], ['SCARVES', 7, 's k aa v z', 5], ['SCAB', 4, 's k ae b', 4], ['SCABS', 5, 's k ae b z', 5], ['SCADS', 5, 's k ae d z', 5], ["SKAGGS'S", 8, 's k ae g', 4], ['SKAGGS', 6, 's k ae g z', 5], ['SCALPING', 8, 's k ae l', 4], ['SCALP', 5, 's k ae l p', 5], ['SCALPS', 6, 's k ae l p s', 6], ['SCALPED', 7, 's k ae l p t', 6], ['SCAMP', 5, 's k ae m p', 5], ['SCAMPS', 6, 's k ae m p s', 6], ['SCAMPED', 7, 's k ae m p t', 6], ['SCAMS', 5, 's k ae m z', 5], ['SCANTY', 6, 's k ae n', 4], ['SCANNED', 7, 's k ae n d', 5], ['ASKANCE', 7, 's k ae n s', 5], ['SCANT', 5, 's k ae n t', 5], ['SCANTS', 6, 's k ae n t s', 6], ['SCANS', 5, 's k ae n z', 5], ['ICECAPS', 7, 's k ae p s', 5], ['SCAT', 4, 's k ae t', 4], ['SCATES', 6, 's k ae t s', 5], ['SCUD', 4, 's k ah d', 4], ['SCUDS', 5, 's k ah d z', 5], ['SCUFF', 5, 's k ah f', 4], ['SCUFFS', 6, 's k ah f s', 5], ['SCUFFED', 7, 's k ah f t', 5], ['SKULLED', 7, 's k ah l d', 5], ['SKULK', 5, 's k ah l k', 5], ['SKULKS', 6, 's k ah l k s', 6], ['SKULKED', 7, 's k ah l k t', 6], ['SCULPT', 6, 's k ah l p t', 6], ['SKULLS', 6, 's k ah l z', 5], ["SCUM'S", 6, 's k ah m z', 5], ['SKUNKISH', 8, 's k ah ng', 4], ['SKUNK', 5, 's k ah ng k', 5], ['SCUPFUL', 7, 's k ah p', 4], ['SCUT', 4, 's k ah t', 4], ['SCUTS', 5, 's k ah t s', 5], ['SCORCH', 6, 's k ao ch', 4], ['SCORCHED', 8, 's k ao ch t', 5], ['DISCORDS', 8, 's k ao d z', 5], ['SCALDING', 8, 's k ao l', 4], ['SCALD', 5, 's k ao l d', 5], ['SCALDS', 6, 's k ao l d z', 6], ['MISCALLS', 8, 's k ao l z', 5], ['SCORNED', 7, 's k ao n d', 5], ['SCORNS', 6, 's k ao n z', 5], ["SCORE'S", 7, 's k ao r z', 5], ['SCOWED', 6, 's k aw d', 4], ['SCOWL', 5, 's k aw l', 4], ['SCOWLED', 7, 's k aw l d', 5], ['SCOWLS', 6, 's k aw l z', 5], ['SCOUTS', 6, 's k aw t s', 5], ['SCOWS', 5, 's k aw z', 4], ['WHISKER', 7, 's k ax', 3], ['AUSCULT', 7, 's k ax l t', 5], ['TUSCAN', 6, 's k ax n', 4], ['WHISKER', 7, 's k ax r', 4], ["OSCAR'S", 7, 's k ax r z', 5], ['VISCUS', 6, 's k ax s', 4], ['WAINSCOT', 8, 's k ax t', 4], ['WHISKERS', 8, 's k ax z', 4], ['SKIED', 5, 's k ay d', 4], ['BOX-KITE', 8, 's k ay t', 4], ['SKIVE', 5, 's k ay v', 4], ['SKIES', 5, 's k ay z', 4], ['SCARY', 5, 's k ea', 3], ['SCARED', 6, 's k ea d', 4], ['SCARE', 5, 's k ea r', 4], ['SCARCE', 6, 's k ea s', 4], ['SCHERZOS', 8, 's k ea t', 4], ['SCARES', 6, 's k ea z', 4], ['SKETCHY', 7, 's k eh', 3], ['SKETCHED', 8, 's k eh ch t', 5], ['SKEGNESS', 8, 's k eh g', 4], ['SKEPS', 5, 's k eh p s', 5], ['SCURF', 5, 's k er f', 4], ['SCURFS', 6, 's k er f s', 5], ['SCOURGE', 7, 's k er jh', 4], ['SCOURGED', 8, 's k er jh d', 5], ['SKIRL', 5, 's k er l', 4], ['SKIRLED', 7, 's k er l d', 5], ['SKIRLS', 6, 's k er l z', 5], ['EXCURSE', 7, 's k er s', 4], ['CASCADE', 7, 's k ey d', 4], ['CASCADES', 8, 's k ey d z', 5], ['SCATHE', 6, 's k ey dh', 4], ['SCATHES', 7, 's k ey dh z', 5], ['AMOSKEAG', 8, 's k ey g', 4], ['SCALE', 5, 's k ey l', 4], ['SCALED', 6, 's k ey l d', 5], ['SKEIN', 5, 's k ey n', 4], ['SKEINED', 7, 's k ey n d', 5], ['SKEINS', 6, 's k ey n z', 5], ['SKATES', 6, 's k ey t s', 5], ['RISKIER', 7, 's k ia', 3], ['VOLSCIAN', 8, 's k ia n', 4], ['RISKIER', 7, 's k ia r', 4], ['WHISKY', 6, 's k ih', 3], ['SKIDPANS', 8, 's k ih d', 4], ['SKIDS', 5, 's k ih d z', 5], ['SKIFF', 5, 's k ih f', 4], ['SKIFFS', 6, 's k ih f s', 5], ['BOSCAGE', 7, 's k ih jh', 4], ['SKILLS', 6, 's k ih l z', 5], ['SKIMPY', 6, 's k ih m', 4], ['SKIMP', 5, 's k ih m p', 5], ['SKIMPS', 6, 's k ih m p s', 6], ['SKIMPED', 7, 's k ih m p t', 6], ['SKIMS', 5, 's k ih m z', 5], ['WINESKIN', 8, 's k ih n', 4], ['SKINT', 5, 's k ih n t', 5], ['MASKINGS', 8, 's k ih ng z', 5], ['SKIPTON', 7, 's k ih p', 4], ['SKIPS', 5, 's k ih p s', 5], ['SKIPPED', 7, 's k ih p t', 5], ['BRISKEST', 8, 's k ih s t', 5], ['WHISKYS', 7, 's k ih z', 4], ["SKI'D", 5, 's k iy d', 4], ['SCHEME', 6, 's k iy m', 4], ['SCHEMED', 7, 's k iy m d', 5], ['SCHEMES', 7, 's k iy m z', 5], ['SKEET', 5, 's k iy t', 4], ['SKEETS', 6, 's k iy t s', 5], ['RASCAL', 6, 's k l', 3], ['EXCLAIM', 7, 's k l ey m', 5], ['EXCLAIMS', 8, 's k l ey m z', 6], ['EXCLUDE', 7, 's k l uw d', 5], ['EXCLUDES', 8, 's k l uw d z', 6], ['RASCALS', 7, 's k l z', 4], ['SCOTCHED', 8, 's k oh ch t', 5], ['SCOFF', 5, 's k oh f', 4], ['SCOFFS', 6, 's k oh f s', 5], ['SCOFFED', 7, 's k oh f t', 5], ['ARASKOG', 7, 's k oh g', 4], ['SCOLES', 6, 's k oh l z', 5], ['ABSCOND', 7, 's k oh n d', 5], ['ABSCONDS', 8, 's k oh n d z', 6], ['SCONCE', 6, 's k oh n s', 5], ['SCONES', 6, 's k oh n z', 5], ["SCOTTS'S", 8, 's k oh t', 4], ['SCOTTS', 6, 's k oh t s', 5], ['FRESCOED', 8, 's k ow d', 4], ['SCOLD', 5, 's k ow l d', 5], ['SCOLDS', 6, 's k ow l d z', 6], ['COXCOMB', 7, 's k ow m', 4], ['COXCOMBS', 8, 's k ow m z', 5], ['SCRAG', 5, 's k r ae g', 5], ['SCRAGGED', 8, 's k r ae g d', 6], ['SCRAGS', 6, 's k r ae g z', 6], ['SCRAMMED', 8, 's k r ae m d', 6], ['SCRAMS', 6, 's k r ae m z', 6], ['SCRAPS', 6, 's k r ae p s', 6], ['SCRAPPED', 8, 's k r ae p t', 6], ['MUSKRAT', 7, 's k r ae t', 5], ['MUSKRATS', 8, 's k r ae t s', 6], ['SCRUBS', 6, 's k r ah b z', 6], ['SCRUFF', 6, 's k r ah f', 5], ['SCRUFFS', 7, 's k r ah f s', 6], ['SCRUMPLE', 8, 's k r ah m', 5], ['SCRUMS', 6, 's k r ah m z', 6], ['SCRUNCHY', 8, 's k r ah n', 5], ['SCRAWNY', 7, 's k r ao', 4], ['SCRAWL', 6, 's k r ao l', 5], ['SCRAWLS', 7, 's k r ao l z', 6], ['DESCRIES', 8, 's k r ay z', 5], ['SCRAPES', 7, 's k r ey p s', 6], ['SCRAZE', 6, 's k r ey z', 5], ['SCRIMP', 6, 's k r ih m p', 6], ['SANSKRIT', 8, 's k r ih t', 5], ['SCRIVENS', 8, 's k r ih v', 5], ['SCREECH', 7, 's k r iy ch', 5], ['SCREED', 6, 's k r iy d', 5], ['SCREEDS', 7, 's k r iy d z', 6], ['SCREEK', 6, 's k r iy k', 5], ['SCREEL', 6, 's k r iy l', 5], ['SCREAM', 6, 's k r iy m', 5], ['SCREAMED', 8, 's k r iy m d', 6], ['SCREAMS', 7, 's k r iy m z', 6], ['EXCRETES', 8, 's k r iy t s', 6], ['SCREES', 6, 's k r iy z', 5], ['SCROTUMS', 8, 's k r ow', 4], ['SCROLL', 6, 's k r ow l', 5], ['SCROLLED', 8, 's k r ow l d', 6], ['SCROLLS', 7, 's k r ow l z', 6], ['SCROOGE', 7, 's k r uw jh', 5], ['SCUDO', 5, 's k uw', 3], ['SCHOOLED', 8, 's k uw l d', 5], ['SCHOOLS', 7, 's k uw l z', 5], ['SCOOPS', 6, 's k uw p s', 5], ['SCOOPED', 7, 's k uw p t', 5], ['SCOOT', 5, 's k uw t', 4], ['SCOOTS', 6, 's k uw t s', 5], ['MESCUS', 6, 's k uw z', 4], ['SQUAWK', 6, 's k w ao k', 5], ['SQUAWKS', 7, 's k w ao k s', 6], ['SQUAWKED', 8, 's k w ao k t', 6], ['SQUALL', 6, 's k w ao l', 5], ['SQUALLED', 8, 's k w ao l d', 6], ['SQUALLS', 7, 's k w ao l z', 6], ['SQUAWS', 6, 's k w ao z', 5], ['SQUIRING', 8, 's k w ay', 4], ['T-SQUARE', 8, 's k w ea', 4], ['SQUARED', 7, 's k w ea d', 5], ['T-SQUARE', 8, 's k w ea r', 5], ["SQUARE'S", 8, 's k w ea r z', 6], ['SQUEGGER', 8, 's k w eh', 4], ['SQUIRK', 6, 's k w er k', 5], ['SQUIRM', 6, 's k w er m', 5], ['SQUIRMED', 8, 's k w er m d', 6], ['SQUIRMS', 7, 's k w er m z', 6], ['SQUIRT', 6, 's k w er t', 5], ['SQUIRTS', 7, 's k w er t s', 6], ['SQUAMAE', 7, 's k w ey', 4], ['SQUIBB', 6, 's k w ih b', 5], ['SQUIBS', 6, 's k w ih b z', 6], ['SQUID', 5, 's k w ih d', 5], ['SQUIDS', 6, 's k w ih d z', 6], ['SQUILL', 6, 's k w ih l', 5], ['SQUINT', 6, 's k w ih n t', 6], ['SQUISH', 6, 's k w ih sh', 5], ['SQUEEZY', 7, 's k w iy', 4], ['SQUEAK', 6, 's k w iy k', 5], ['SQUEAKS', 7, 's k w iy k s', 6], ['SQUEAKED', 8, 's k w iy k t', 6], ['SQUEAL', 6, 's k w iy l', 5], ['SQUEALED', 8, 's k w iy l d', 6], ['SQUEALS', 7, 's k w iy l z', 6], ['SQUEEZE', 7, 's k w iy z', 5], ['SQUEEZED', 8, 's k w iy z d', 6], ['SQUAB', 5, 's k w oh b', 5], ['SQUABS', 6, 's k w oh b z', 6], ['SQUAD', 5, 's k w oh d', 5], ['SQUADS', 6, 's k w oh d z', 6], ['SQUANTUM', 8, 's k w oh n', 5], ['SQUASH', 6, 's k w oh sh', 5], ['SQUAT', 5, 's k w oh t', 5], ['SQUATS', 6, 's k w oh t s', 6], ['MISQUOTE', 8, 's k w ow t', 5], ['SKEWERED', 8, 's k y ua d', 5], ['SKEWER', 6, 's k y ua r', 5], ['SKEWERS', 7, 's k y ua z', 5], ['ICECUBE', 7, 's k y uw b', 5], ['ICECUBES', 8, 's k y uw b z', 6], ['SKEWED', 6, 's k y uw d', 5], ['OSCULE', 6, 's k y uw l', 5], ['OSCULES', 7, 's k y uw l z', 6], ['SKEWES', 6, 's k y uw z', 5], ['WRESTLE', 7, 's l', 2], ['WROCLAW', 7, 's l aa f', 4], ['SLANT', 5, 's l aa n t', 5], ['SLANTS', 6, 's l aa n t s', 6], ['YUGOSLAV', 8, 's l aa v', 4], ['SLAVICK', 7, 's l ae', 3], ['SLAB', 4, 's l ae b', 4], ['SLABBED', 7, 's l ae b d', 5], ['SLABS', 5, 's l ae b z', 5], ['SLAG', 4, 's l ae g', 4], ['SLAGGED', 7, 's l ae g d', 5], ['SLACKS', 6, 's l ae k s', 5], ['SLACKED', 7, 's l ae k t', 5], ['SLAM', 4, 's l ae m', 4], ['SLAMMED', 7, 's l ae m d', 5], ['SLAMS', 5, 's l ae m z', 5], ['SLANT', 5, 's l ae n t', 5], ['SLANGY', 6, 's l ae ng', 4], ['SLANGED', 7, 's l ae ng d', 5], ['SLANGS', 6, 's l ae ng z', 5], ['SLAPS', 5, 's l ae p s', 5], ['SLAPPED', 7, 's l ae p t', 5], ['SLASH', 5, 's l ae sh', 4], ['SLASHED', 7, 's l ae sh t', 5], ['SLATTEN', 7, 's l ae t', 4], ['SLATS', 5, 's l ae t s', 5], ['SLUTTY', 6, 's l ah', 3], ['SLOUGH', 6, 's l ah f', 4], ['SLOUGHS', 7, 's l ah f s', 5], ['SLOUGHED', 8, 's l ah f t', 5], ['SLUG', 4, 's l ah g', 4], ['SLUGGED', 7, 's l ah g d', 5], ['SLUGS', 5, 's l ah g z', 5], ['SLUDGE', 6, 's l ah jh', 4], ['SLUDGED', 7, 's l ah jh d', 5], ['SLUMPY', 6, 's l ah m', 4], ['SLUMMED', 7, 's l ah m d', 5], ['SLUMP', 5, 's l ah m p', 5], ['SLUMPS', 6, 's l ah m p s', 6], ['SLUMPED', 7, 's l ah m p t', 6], ['SLUMS', 5, 's l ah m z', 5], ['SLUNK', 5, 's l ah ng k', 5], ['SLUSH', 5, 's l ah sh', 4], ['SLUSHED', 7, 's l ah sh t', 5], ['SLUT', 4, 's l ah t', 4], ['SLUTS', 5, 's l ah t s', 5], ['SLOVENS', 7, 's l ah v', 4], ['SLAW', 4, 's l ao', 3], ['SLOUGH', 6, 's l aw', 3], ['SLOUCH', 6, 's l aw ch', 4], ['SLOUCHED', 8, 's l aw ch t', 5], ['SLOUGHS', 7, 's l aw z', 4], ['WRESTLER', 8, 's l ax', 3], ['ICELAND', 7, 's l ax n d', 5], ['WRESTLER', 8, 's l ax r', 4], ['SLIDE', 5, 's l ay d', 4], ['SLIDES', 6, 's l ay d z', 5], ['DISLIKES', 8, 's l ay k s', 5], ['SLIME', 5, 's l ay m', 4], ['SLIMED', 6, 's l ay m d', 5], ['SLIMES', 6, 's l ay m z', 5], ['SLICE', 5, 's l ay s', 4], ['SLICED', 6, 's l ay s t', 5], ['SLIGHTS', 7, 's l ay t s', 5], ['WRESTLED', 8, 's l d', 3], ['ROSSLARE', 8, 's l ea', 3], ['ROSSLARE', 8, 's l ea r', 4], ['SLEDGING', 8, 's l eh', 3], ['SLED', 4, 's l eh d', 4], ['SLEDS', 5, 's l eh d z', 5], ['SLEDGE', 6, 's l eh jh', 4], ['SLEDGED', 7, 's l eh jh d', 5], ['SLENDID', 7, 's l eh n', 4], ['SLEPT', 5, 's l eh p t', 5], ['SLURRED', 7, 's l er d', 4], ['SLUR', 4, 's l er r', 4], ["SLUR'S", 6, 's l er r z', 5], ['SLURS', 5, 's l er z', 4], ['SLEIGHED', 8, 's l ey d', 4], ['SLAKE', 5, 's l ey k', 4], ['SLAKES', 6, 's l ey k s', 5], ['UNSLAKED', 8, 's l ey k t', 5], ['UNSLAIN', 7, 's l ey n', 4], ['SLATES', 6, 's l ey t s', 5], ['UNSLAVE', 7, 's l ey v', 4], ['SLAVED', 6, 's l ey v d', 5], ['SLAVES', 6, 's l ey v z', 5], ['SLEIGHS', 7, 's l ey z', 4], ['SLID', 4, 's l ih d', 4], ['SLICK', 5, 's l ih k', 4], ['SLICKS', 6, 's l ih k s', 5], ['SLICKED', 7, 's l ih k t', 5], ['SLIMNESS', 8, 's l ih m', 4], ['SLIMMED', 7, 's l ih m d', 5], ['SLIMS', 5, 's l ih m z', 5], ['PURSLANE', 8, 's l ih n', 4], ['SLINK', 5, 's l ih ng k', 5], ['SLIPWAYS', 8, 's l ih p', 4], ['SLIPS', 5, 's l ih p s', 5], ['SLIPPED', 7, 's l ih p t', 5], ['SLIT', 4, 's l ih t', 4], ['SLITS', 5, 's l ih t s', 5], ['PARSLEYS', 8, 's l ih z', 4], ['SLEEVER', 7, 's l iy', 3], ['MISLEADS', 8, 's l iy d z', 5], ['SLEEKS', 6, 's l iy k s', 5], ['SLEEKED', 7, 's l iy k t', 5], ['SLEEPS', 6, 's l iy p s', 5], ['SLEET', 5, 's l iy t', 4], ['SLEETS', 6, 's l iy t s', 5], ['SLEEVED', 7, 's l iy v d', 5], ['SLEEVES', 7, 's l iy v z', 5], ['SLEAZE', 6, 's l iy z', 4], ['SLOTTING', 8, 's l oh', 3], ['SLOB', 4, 's l oh b', 4], ['SLOBS', 5, 's l oh b z', 5], ['SLOG', 4, 's l oh g', 4], ['SLOGGED', 7, 's l oh g d', 5], ['SLOGS', 5, 's l oh g z', 5], ['SLOPS', 5, 's l oh p s', 5], ['SLOPPED', 7, 's l oh p t', 5], ['SLOSH', 5, 's l oh sh', 4], ['SLOSHED', 7, 's l oh sh t', 5], ['SLOTS', 5, 's l oh t s', 5], ['SLOWNESS', 8, 's l ow', 3], ['SLOWED', 6, 's l ow d', 4], ['SLOANE', 6, 's l ow n', 4], ['SLOANS', 6, 's l ow n z', 5], ['SLOPE', 5, 's l ow p', 4], ['SLOPES', 6, 's l ow p s', 5], ['SLOPED', 6, 's l ow p t', 5], ['SLOATE', 6, 's l ow t', 4], ["SLOATE'S", 8, 's l ow t s', 5], ['SLOTH', 5, 's l ow th', 4], ['SLOTHS', 6, 's l ow th s', 5], ['SLOWS', 5, 's l ow z', 4], ['SLOID', 5, 's l oy d', 4], ['SLUICY', 6, 's l uw', 3], ['SLEWED', 6, 's l uw d', 4], ['SLOOP', 5, 's l uw p', 4], ['SLOOPS', 6, 's l uw p s', 5], ['SLUICED', 7, 's l uw s t', 5], ['SLEUTH', 6, 's l uw th', 4], ['SLEUTHS', 7, 's l uw th s', 5], ['SLEUTHED', 8, 's l uw th t', 5], ['SLEWS', 5, 's l uw z', 4], ['WRESTLES', 8, 's l z', 3], ['SMARTLY', 7, 's m aa', 3], ['SMARM', 5, 's m aa m', 4], ['GASMASK', 7, 's m aa s k', 5], ['GASMASKS', 8, 's m aa s k s', 6], ['SMARTS', 6, 's m aa t s', 5], ['SMATTERY', 8, 's m ae', 3], ['SMATCH', 6, 's m ae ch', 4], ['SMACKS', 6, 's m ae k s', 5], ['SMACKED', 7, 's m ae k t', 5], ['ICEMANS', 7, 's m ae n z', 5], ['SMASH', 5, 's m ae sh', 4], ['SMASHED', 7, 's m ae sh t', 5], ['SMUTTY', 6, 's m ah', 3], ['SMUGNESS', 8, 's m ah g', 4], ['SMUDGE', 6, 's m ah jh', 4], ['SMUDGED', 7, 's m ah jh d', 5], ['WAXMAN', 6, 's m ah n', 4], ["WAXMAN'S", 8, 's m ah n z', 5], ['SMUT', 4, 's m ah t', 4], ['SMUTS', 5, 's m ah t s', 5], ['SMALT', 5, 's m ao l t', 5], ['SMALTZ', 6, 's m ao l t s', 6], ['SMALLS', 6, 's m ao l z', 5], ['DISMOUNT', 8, 's m aw n t', 5], ['XMASES', 6, 's m ax', 3], ['XMAS', 4, 's m ax s', 4], ['ASTHMAS', 7, 's m ax z', 4], ['SMILE', 5, 's m ay l', 4], ['SMILED', 6, 's m ay l d', 5], ['SMILES', 6, 's m ay l z', 5], ['SMITE', 5, 's m ay t', 4], ['SMITES', 6, 's m ay t s', 5], ['SMELLY', 6, 's m eh', 3], ['SMELTING', 8, 's m eh l', 4], ['SMELLED', 7, 's m eh l d', 5], ['SMELT', 5, 's m eh l t', 5], ['SMELTZ', 6, 's m eh l t s', 6], ['SMELLS', 6, 's m eh l z', 5], ['SMIRKY', 6, 's m er', 3], ['SMIRCH', 6, 's m er ch', 4], ['SMIRCHED', 8, 's m er ch t', 5], ['SMIRK', 5, 's m er k', 4], ['SMIRKS', 6, 's m er k s', 5], ['SMIRKED', 7, 's m er k t', 5], ['UNDISMAY', 8, 's m ey', 3], ['SMALE', 5, 's m ey l', 4], ["SMALE'S", 7, 's m ey l z', 5], ['MESSMATE', 8, 's m ey t', 4], ['DISMAYS', 7, 's m ey z', 4], ['SMEARY', 6, 's m ia', 3], ['SMEARED', 7, 's m ia d', 4], ['SMEAR', 5, 's m ia r', 4], ['SMEARS', 6, 's m ia z', 4], ['JASMINE', 7, 's m ih n', 4], ['JASMINED', 8, 's m ih n d', 5], ['JASMINES', 8, 's m ih n z', 5], ['SMITTEN', 7, 's m ih t', 4], ["SMIT'S", 6, 's m ih t s', 5], ['TINSMITH', 8, 's m ih th', 4], ['SMOG', 4, 's m oh g', 4], ['SMOGS', 5, 's m oh g z', 5], ['SMOCK', 5, 's m oh k', 4], ['SMOCKS', 6, 's m oh k s', 5], ['SMOCKED', 7, 's m oh k t', 5], ['UNSMOKY', 7, 's m ow', 3], ['SMOKES', 6, 's m ow k s', 5], ['SMOKED', 6, 's m ow k t', 5], ['SMOLT', 5, 's m ow l t', 5], ['SMOLTS', 6, 's m ow l t s', 6], ['SMOTE', 5, 's m ow t', 4], ['SMOOTING', 8, 's m uw', 3], ['SMOOTHED', 8, 's m uw dh d', 5], ['SMOOTHS', 7, 's m uw dh z', 5], ['SMOOT', 5, 's m uw t', 4], ['SMOOTS', 6, 's m uw t s', 5], ['WILSON', 6, 's n', 2], ['SNARK', 5, 's n aa k', 4], ['SNARKS', 6, 's n aa k s', 5], ['SNARL', 5, 's n aa l', 4], ['SNARLED', 7, 's n aa l d', 5], ['SNARLS', 6, 's n aa l z', 5], ['SNATCH', 6, 's n ae ch', 4], ['SNATCHED', 8, 's n ae ch t', 5], ['SNAG', 4, 's n ae g', 4], ['SNAGGED', 7, 's n ae g d', 5], ['SNAGS', 5, 's n ae g z', 5], ['SNACKS', 6, 's n ae k s', 5], ['SNACKED', 7, 's n ae k t', 5], ['SNAPS', 5, 's n ae p s', 5], ['SNAPPED', 7, 's n ae p t', 5], ['SNUGLY', 6, 's n ah', 3], ['SNUBBED', 7, 's n ah b d', 5], ['SNUBS', 5, 's n ah b z', 5], ['SNUFFS', 6, 's n ah f s', 5], ['SNUFFED', 7, 's n ah f t', 5], ['SNUGNESS', 8, 's n ah g', 4], ['SNUGS', 5, 's n ah g z', 5], ['SNORTY', 6, 's n ao', 3], ['SNORED', 6, 's n ao d', 4], ['SNORE', 5, 's n ao r', 4], ['SNORT', 5, 's n ao t', 4], ['SNORTS', 6, 's n ao t s', 5], ['SNORES', 6, 's n ao z', 4], ['SNOUTISH', 8, 's n aw', 3], ['SNOUT', 5, 's n aw t', 4], ['SNOUTS', 6, 's n aw t s', 5], ['ARSENALS', 8, 's n ax l z', 5], ['SNYDERS', 7, 's n ay', 3], ['SNIDE', 5, 's n ay d', 4], ['SNIPE', 5, 's n ay p', 4], ['SNIPES', 6, 's n ay p s', 5], ['SNIPED', 6, 's n ay p t', 5], ['SNARED', 6, 's n ea d', 4], ['SNARE', 5, 's n ea r', 4], ['SNARES', 6, 's n ea z', 4], ['SNELL', 5, 's n eh l', 4], ["SNELL'S", 7, 's n eh l z', 5], ['WEXNER', 6, 's n er', 3], ["WEXNER'S", 8, 's n er z', 4], ['SNAKY', 5, 's n ey', 3], ['SNAKE', 5, 's n ey k', 4], ['SNAKES', 6, 's n ey k s', 5], ['SNAKED', 6, 's n ey k t', 5], ['SNAIL', 5, 's n ey l', 4], ['SNAILED', 7, 's n ey l d', 5], ['SNAILS', 6, 's n ey l z', 5], ['MISNAMED', 8, 's n ey m d', 5], ['SNEERED', 7, 's n ia d', 4], ['SNEER', 5, 's n ia r', 4], ['SNEERS', 6, 's n ia z', 4], ['SNIVELS', 7, 's n ih', 3], ['SNITCH', 6, 's n ih ch', 4], ['SNITCHED', 8, 's n ih ch t', 5], ['SNIFTY', 6, 's n ih f', 4], ['SNIFFS', 6, 's n ih f s', 5], ['SNIFFED', 7, 's n ih f t', 5], ['SNICK', 5, 's n ih k', 4], ['SNICKS', 6, 's n ih k s', 5], ['SNICKED', 7, 's n ih k t', 5], ['SNIP', 4, 's n ih p', 4], ['SNIPS', 5, 's n ih p s', 5], ['SNIPPED', 7, 's n ih p t', 5], ['SARSENET', 8, 's n ih t', 4], ['SNEAKS', 6, 's n iy k s', 5], ['SNEAKED', 7, 's n iy k t', 5], ['SNEEZE', 6, 's n iy z', 4], ['SNEEZED', 7, 's n iy z d', 5], ['SNOTTY', 6, 's n oh', 3], ['SNOB', 4, 's n oh b', 4], ['SNOBS', 5, 's n oh b z', 5], ['SOSNOFF', 7, 's n oh f', 4], ['SNOG', 4, 's n oh g', 4], ['SNOGGED', 7, 's n oh g d', 5], ['SNOGS', 5, 's n oh g z', 5], ['SNOWY', 5, 's n ow', 3], ['SNOWED', 6, 's n ow d', 4], ['SNOWS', 5, 's n ow z', 4], ['SNOOZY', 6, 's n uw', 3], ['SNOOD', 5, 's n uw d', 4], ['SNOODS', 6, 's n uw d z', 5], ['SNOOK', 5, 's n uw k', 4], ['SNOOKS', 6, 's n uw k s', 5], ['SNOOP', 5, 's n uw p', 4], ['SNOOPS', 6, 's n uw p s', 5], ['SNOOPED', 7, 's n uw p t', 5], ['SNOOZE', 6, 's n uw z', 4], ['SNOOZED', 7, 's n uw z d', 5], ['WILSONS', 7, 's n z', 3], ['SOBBED', 6, 's oh b d', 4], ['SOBS', 4, 's oh b z', 4], ['SODDENS', 7, 's oh d', 3], ['SODS', 4, 's oh d z', 4], ['SOFTNESS', 8, 's oh f t', 4], ['WINDSOCK', 8, 's oh k', 3], ['SOCKED', 6, 's oh k t', 4], ['UNSOLVED', 8, 's oh l v d', 5], ['SOLVES', 6, 's oh l v z', 5], ['SOUP<CON', 8, 's oh n', 3], ['WORKSOP', 7, 's oh p', 3], ['SOPS', 4, 's oh p s', 4], ['SOPPED', 6, 's oh p t', 4], ['SOT', 3, 's oh t', 3], ['SOTS', 4, 's oh t s', 4], ['SOWED', 5, 's ow d', 3], ['EPISODES', 8, 's ow d z', 4], ['SOAK', 4, 's ow k', 3], ['SOAKS', 5, 's ow k s', 4], ['SOAKED', 6, 's ow k t', 4], ['UNSOLD', 6, 's ow l d', 4], ['SOULS', 5, 's ow l z', 4], ['SOWN', 4, 's ow n', 3], ['DISOWNS', 7, 's ow n z', 4], ['MYOSOTE', 7, 's ow t', 3], ['VERSOS', 6, 's ow z', 3], ['SINUSOID', 8, 's oy d', 3], ['SUBSOIL', 7, 's oy l', 3], ['SUBSOILS', 8, 's oy l z', 4], ['SPARTIN', 7, 's p aa', 3], ['SPARRED', 7, 's p aa d', 4], ["SPARKS'S", 8, 's p aa k', 4], ['SPARKS', 6, 's p aa k s', 5], ['SPARKED', 7, 's p aa k t', 5], ['SPAR', 4, 's p aa r', 4], ['SPARSE', 6, 's p aa s', 4], ['SPARTON', 7, 's p aa t', 4], ['SPAS', 4, 's p aa z', 4], ['ICEPACK', 7, 's p ae k', 4], ['ICEPACKS', 8, 's p ae k s', 5], ['SPAM', 4, 's p ae m', 4], ["SPAM'S", 6, 's p ae m z', 5], ['WINGSPAN', 8, 's p ae n', 4], ['EXPANSE', 7, 's p ae n s', 5], ['EXPANSED', 8, 's p ae n s t', 6], ['SPANK', 5, 's p ae ng k', 5], ['SPAT', 4, 's p ae t', 4], ['SPATS', 5, 's p ae t s', 5], ['SPUTTERY', 8, 's p ah', 3], ['SPUD', 4, 's p ah d', 4], ['SPUDS', 5, 's p ah d z', 5], ['EXPULSED', 8, 's p ah l s t', 6], ['SPUN', 4, 's p ah n', 4], ['SPUNKY', 6, 's p ah ng', 4], ['SPUNK', 5, 's p ah ng k', 5], ['SPORED', 6, 's p ao d', 4], ['SPALL', 5, 's p ao l', 4], ['SPALLED', 7, 's p ao l d', 5], ['SPALLS', 6, 's p ao l z', 5], ['SPAWN', 5, 's p ao n', 4], ['SPAWNED', 7, 's p ao n d', 5], ['SPAWNS', 6, 's p ao n z', 5], ['SPORE', 5, 's p ao r', 4], ['SPORED', 6, 's p ao r d', 5], ["SPORE'S", 7, 's p ao r z', 5], ['SPORES', 6, 's p ao z', 4], ['SPOUTING', 8, 's p aw', 3], ['EXPOUND', 7, 's p aw n d', 5], ['EXPOUNDS', 8, 's p aw n d z', 6], ['SPOUSE', 6, 's p aw z', 4], ['SPOUSED', 7, 's p aw z d', 5], ['ASPULL', 6, 's p ax l', 4], ['SIXPENCE', 8, 's p ax n s', 5], ['WHISPER', 7, 's p ax r', 4], ['JASPERED', 8, 's p ax r d', 5], ['JASPERS', 7, 's p ax r z', 5], ['TRESPASS', 8, 's p ax s', 4], ['WHISPERS', 8, 's p ax z', 4], ['SPIED', 5, 's p ay d', 4], ['UNSPIKE', 7, 's p ay k', 4], ['SPIKES', 6, 's p ay k s', 5], ['SPIKED', 6, 's p ay k t', 5], ['SPINED', 6, 's p ay n d', 5], ['SPINES', 6, 's p ay n z', 5], ['SPICE', 5, 's p ay s', 4], ['UNSPICED', 8, 's p ay s t', 5], ['SPITES', 6, 's p ay t s', 5], ['SPIES', 5, 's p ay z', 4], ['SPARE', 5, 's p ea r', 4], ['SPARES', 6, 's p ea z', 4], ['SPED', 4, 's p eh d', 4], ['SPECS', 5, 's p eh k s', 5], ['SUSPECTS', 8, 's p eh k t s', 6], ['SPLETER', 7, 's p eh l', 4], ['SPELT', 5, 's p eh l t', 5], ['SPELLS', 6, 's p eh l z', 5], ['SUSPENSE', 8, 's p eh n s', 5], ['UNSPENT', 7, 's p eh n t', 5], ['SPEZIA', 6, 's p eh t', 4], ['SPURRED', 7, 's p er d', 4], ['ASPERGE', 7, 's p er jh', 4], ['SPERMS', 6, 's p er m z', 5], ['SPURN', 5, 's p er n', 4], ['SPURNED', 7, 's p er n d', 5], ['SPURNS', 6, 's p er n z', 5], ['SPUR', 4, 's p er r', 4], ["SPUR'S", 6, 's p er r z', 5], ['RESPERSE', 8, 's p er s', 4], ['SPURTS', 6, 's p er t s', 5], ['SPURS', 5, 's p er z', 4], ['SPAYED', 6, 's p ey d', 4], ['SPADES', 6, 's p ey d z', 5], ['SPAKE', 5, 's p ey k', 4], ['SPAIN', 5, 's p ey n', 4], ["SPAIN'S", 7, 's p ey n z', 5], ['SPACED', 6, 's p ey s t', 5], ['SPATE', 5, 's p ey t', 4], ['SPATES', 6, 's p ey t s', 5], ['WISPIER', 7, 's p ia', 3], ['SPEARED', 7, 's p ia d', 4], ['THESPIAN', 8, 's p ia n', 4], ['WISPIER', 7, 's p ia r', 4], ["SPEAR'S", 7, 's p ia r z', 5], ['SPEARS', 6, 's p ia z', 4], ['WISPY', 5, 's p ih', 3], ['CUSPID', 6, 's p ih d', 4], ['CUSPIDS', 7, 's p ih d z', 5], ['SPICK', 5, 's p ih k', 4], ['ICEPICKS', 8, 's p ih k s', 5], ['SPILL', 5, 's p ih l', 4], ['SPILLED', 7, 's p ih l d', 5], ['SPILT', 5, 's p ih l t', 5], ['SPILLS', 6, 's p ih l z', 5], ['UNSPIN', 6, 's p ih n', 4], ['SPINED', 6, 's p ih n d', 5], ['WISPING', 7, 's p ih ng', 4], ["SPINKS'S", 8, 's p ih ng k', 5], ['RASPINGS', 8, 's p ih ng z', 5], ['HOSPICE', 7, 's p ih s', 4], ['CRISPEST', 8, 's p ih s t', 5], ['WISPISH', 7, 's p ih sh', 4], ['UNSPIT', 6, 's p ih t', 4], ['SPIV', 4, 's p ih v', 4], ['SPIVS', 5, 's p ih v z', 5], ['SPEEDS', 6, 's p iy d z', 5], ['UNSPEAK', 7, 's p iy k', 4], ['SPEAKS', 6, 's p iy k s', 5], ['SPHENE', 6, 's p iy n', 4], ['GOSPEL', 6, 's p l', 3], ['SPLATS', 6, 's p l ae t s', 6], ['SPLORE', 6, 's p l ao r', 5], ['EXPLORES', 8, 's p l ao z', 5], ['WASPLIKE', 8, 's p l ay k', 5], ['SPLICE', 6, 's p l ay s', 5], ['SPLICED', 7, 's p l ay s t', 6], ['SPLURGE', 7, 's p l er jh', 5], ['SPLAIN', 6, 's p l ey n', 5], ['EXPLAINS', 8, 's p l ey n z', 6], ['SPLAYS', 6, 's p l ey z', 5], ['SPLINED', 7, 's p l ih n d', 6], ['SPLINT', 6, 's p l ih n t', 6], ['SPLINES', 7, 's p l ih n z', 6], ['SPLISH', 6, 's p l ih sh', 5], ['SPLITT', 6, 's p l ih t', 5], ['SPLITS', 6, 's p l ih t s', 6], ['SPLENIUM', 8, 's p l iy', 4], ['SPLEEN', 6, 's p l iy n', 5], ['SPLEENS', 7, 's p l iy n z', 6], ['SPLOTCHY', 8, 's p l oh', 4], ['SPLOTCH', 7, 's p l oh ch', 5], ['SPLODGE', 7, 's p l oh jh', 5], ['SPLOSH', 6, 's p l oh sh', 5], ['EXPLODE', 7, 's p l ow d', 5], ['EXPLODES', 8, 's p l ow d z', 6], ['EXPLOIT', 7, 's p l oy t', 5], ['EXPLOITS', 8, 's p l oy t s', 6], ['GOSPELS', 7, 's p l z', 4], ['RESPONDS', 8, 's p oh n d z', 6], ['RESPONSE', 8, 's p oh n s', 5], ['UNSPOT', 6, 's p oh t', 4], ['SUNSPOTS', 8, 's p oh t s', 5], ['SPODE', 5, 's p ow d', 4], ['SPOKES', 6, 's p ow k s', 5], ['SPOKED', 6, 's p ow k t', 5], ['SPOILING', 8, 's p oy', 3], ['UNSPOIL', 7, 's p oy l', 4], ['UNSPOILT', 8, 's p oy l t', 5], ['SPOILS', 6, 's p oy l z', 5], ['SPRANG', 6, 's p r ae ng', 5], ['SPRAT', 5, 's p r ae t', 5], ['SPRATS', 6, 's p r ae t s', 6], ['UNSPRUNG', 8, 's p r ah ng', 5], ['SPRAWLY', 7, 's p r ao', 4], ['SPRAWL', 6, 's p r ao l', 5], ['SPRAWLED', 8, 's p r ao l d', 6], ['SPRAWLS', 7, 's p r ao l z', 6], ['SPROWL', 6, 's p r aw l', 5], ['SPROWLS', 7, 's p r aw l z', 6], ['SPROUTS', 7, 's p r aw t s', 6], ['SPRITE', 6, 's p r ay t', 5], ['SPRITES', 7, 's p r ay t s', 6], ['SPRAIN', 6, 's p r ey n', 5], ['SPRAINS', 7, 's p r ey n z', 6], ['SPRAYS', 6, 's p r ey z', 5], ['SPRITTY', 7, 's p r ih', 4], ['SPRIGG', 6, 's p r ih g', 5], ['SPRIGGED', 8, 's p r ih g d', 6], ['SPRIGS', 6, 's p r ih g z', 6], ['SPRICK', 6, 's p r ih k', 5], ['SPRINT', 6, 's p r ih n t', 6], ['ASPIRINS', 8, 's p r ih n z', 6], ['SPRITS', 6, 's p r ih t s', 6], ['OSPREYS', 7, 's p r ih z', 5], ['SPREE', 5, 's p r iy', 4], ['SPREEN', 6, 's p r iy n', 5], ['SPREES', 6, 's p r iy z', 5], ['SPROAT', 6, 's p r ow t', 5], ['SPRUCE', 6, 's p r uw s', 5], ['SPOORING', 8, 's p ua', 3], ['SPOORED', 7, 's p ua d', 4], ['SPOOR', 5, 's p ua r', 4], ['SPOORED', 7, 's p ua r d', 5], ["SPOOR'S", 7, 's p ua r z', 5], ['SPOORS', 6, 's p ua z', 4], ['SPUTNIKS', 8, 's p uh t', 4], ['SPOONY', 6, 's p uw', 3], ['SPOOF', 5, 's p uw f', 4], ['SPOOFS', 6, 's p uw f s', 5], ['SPOOFED', 7, 's p uw f t', 5], ['SPOOK', 5, 's p uw k', 4], ['SPOOKS', 6, 's p uw k s', 5], ['SPOOKED', 7, 's p uw k t', 5], ['SPOOL', 5, 's p uw l', 4], ['SPOOLED', 7, 's p uw l d', 5], ['SPOOLS', 6, 's p uw l z', 5], ['SPOONED', 7, 's p uw n d', 5], ['SPUED', 5, 's p y uw d', 5], ['SPUME', 5, 's p y uw m', 5], ['SPUMED', 6, 's p y uw m d', 6], ['SPUMES', 6, 's p y uw m z', 6], ['EXPUGN', 6, 's p y uw n', 5], ['DISPUTES', 8, 's p y uw t s', 6], ['SPUES', 5, 's p y uw z', 5], ['DISRUPTS', 8, 's r ah p t s', 6], ['BASRA', 5, 's r ax', 3], ["BASRA'S", 7, 's r ax z', 4], ['MISREAD', 7, 's r eh d', 4], ['X-RAYING', 8, 's r ey', 3], ['X-RAYED', 7, 's r ey d', 4], ['X-RAYS', 6, 's r ey z', 4], ['GAS-RING', 8, 's r ih ng', 4], ['ICERINK', 7, 's r ih ng k', 5], ['MISREAD', 7, 's r iy d', 4], ['MISREADS', 8, 's r iy d z', 5], ['DISROBE', 7, 's r ow b', 4], ['DISROBED', 8, 's r ow b d', 5], ['DISROBES', 8, 's r ow b z', 5], ['VICEROYS', 8, 's r oy z', 4], ['MISRULE', 7, 's r uw l', 4], ['MISRULED', 8, 's r uw l d', 5], ['MISRULES', 8, 's r uw l z', 5], ['DISSERVE', 8, 's s er v', 4], ['MISSPELL', 8, 's s p eh l', 5], ['MISSPELT', 8, 's s p eh l t', 6], ['MISSPEND', 8, 's s p eh n d', 6], ['MISSPENT', 8, 's s p eh n t', 6], ['MISSUIT', 7, 's s y uw t', 5], ['UNSTARCH', 8, 's t aa ch', 4], ['UPSTAFF', 7, 's t aa f', 4], ['STARK', 5, 's t aa k', 4], ['STARKS', 6, 's t aa k s', 5], ['UNSTANCH', 8, 's t aa n ch', 5], ['RESTANTE', 8, 's t aa n t', 5], ['WINSTAR', 7, 's t aa r', 4], ['PISTACHE', 8, 's t aa sh', 4], ['UPSTART', 7, 's t aa t', 4], ['UPSTARTS', 8, 's t aa t s', 5], ['STARVE', 6, 's t aa v', 4], ['STARVED', 7, 's t aa v d', 5], ['STARVES', 7, 's t aa v z', 5], ['STAB', 4, 's t ae b', 4], ['STABBED', 7, 's t ae b d', 5], ['STABS', 5, 's t ae b z', 5], ['STAGS', 5, 's t ae g z', 5], ['UNSTACK', 7, 's t ae k', 4], ['UNSTACKS', 8, 's t ae k s', 5], ['UPSTAMP', 7, 's t ae m p', 5], ['STAMPS', 6, 's t ae m p s', 6], ['STANCE', 6, 's t ae n s', 5], ['EXTANT', 6, 's t ae n t', 5], ["STAN'S", 6, 's t ae n z', 5], ['STANKO', 6, 's t ae ng', 4], ['STANK', 5, 's t ae ng k', 5], ['MUSTANGS', 8, 's t ae ng z', 5], ['STASH', 5, 's t ae sh', 4], ['STASHED', 7, 's t ae sh t', 5], ['STUB', 4, 's t ah b', 4], ['STUBS', 5, 's t ah b z', 5], ['STUDS', 5, 's t ah d z', 5], ['UNSTUFF', 7, 's t ah f', 4], ['STUFFS', 6, 's t ah f s', 5], ['STUNG', 5, 's t ah g', 4], ['UNSTUCK', 7, 's t ah k', 4], ['STULTZ', 6, 's t ah l t s', 6], ['STUMP', 5, 's t ah m p', 5], ['STUMPS', 6, 's t ah m p s', 6], ['STUMPED', 7, 's t ah m p t', 6], ['WINSTON', 7, 's t ah n', 4], ['STUNNED', 7, 's t ah n d', 5], ['STUNT', 5, 's t ah n t', 5], ['STUNTS', 6, 's t ah n t s', 6], ['WINSTONS', 8, 's t ah n z', 5], ['STUNK', 5, 's t ah ng k', 5], ['STUPSKI', 7, 's t ah p', 4], ['UNSTORED', 8, 's t ao d', 4], ['STORK', 5, 's t ao k', 4], ['STORKS', 6, 's t ao k s', 5], ['STALKED', 7, 's t ao k t', 5], ['STAUNTON', 8, 's t ao n', 4], ['STORE', 5, 's t ao r', 4], ["STORE'S", 7, 's t ao r z', 5], ['EXTORT', 6, 's t ao t', 4], ['STORTS', 6, 's t ao t s', 5], ["STORES'", 7, 's t ao z', 4], ['STOUTLY', 7, 's t aw', 3], ['ASTOUND', 7, 's t aw n d', 5], ['ASTOUNDS', 8, 's t aw n d z', 6], ['STOUTS', 6, 's t aw t s', 5], ['WESTERED', 8, 's t ax d', 4], ['MUSTARDS', 8, 's t ax d z', 5], ['VESTAL', 6, 's t ax l', 4], ['VESTALS', 7, 's t ax l z', 5], ["SYSTEMS'", 8, 's t ax m z', 5], ['YESTERN', 7, 's t ax n', 4], ['SCHISTUS', 8, 's t ax s', 4], ['STYLED', 6, 's t ay l d', 5], ['MISTIMED', 8, 's t ay m d', 5], ['WINSTEIN', 8, 's t ay n', 4], ['STYES', 5, 's t ay z', 4], ['WISTARIA', 8, 's t ea', 3], ['STARED', 6, 's t ea d', 4], ['STARE', 5, 's t ea r', 4], ['STAIRED', 7, 's t ea r d', 5], ["STAIR'S", 7, 's t ea r z', 5], ['UPSTAIRS', 8, 's t ea z', 4], ['WINSTED', 7, 's t eh d', 4], ['STEADS', 6, 's t eh d z', 5], ['NEST-EGG', 8, 's t eh g', 4], ['STEALTH', 7, 's t eh l th', 5], ['STEMS', 5, 's t eh m z', 5], ['STENCH', 6, 's t eh n ch', 5], ['WEST-END', 8, 's t eh n d', 5], ['EXTENDS', 7, 's t eh n d z', 6], ['STENT', 5, 's t eh n t', 5], ['STENTS', 6, 's t eh n t s', 6], ['UNSTEP', 6, 's t eh p', 4], ['STEPPED', 7, 's t eh p t', 5], ['STETSONS', 8, 's t eh t', 4], ["STET'S", 6, 's t eh t s', 5], ['DISTURBS', 8, 's t er b z', 5], ['STIRRED', 7, 's t er d', 4], ['STERNED', 7, 's t er n d', 5], ['STERNS', 6, 's t er n z', 5], ['STIRPS', 6, 's t er p s', 5], ['STUERMER', 8, 's t er r', 4], ['STIRES', 6, 's t er r z', 5], ['SESTERCE', 8, 's t er s', 4], ['UNSTAYED', 8, 's t ey d', 4], ['UPSTAGE', 7, 's t ey jh', 4], ['UPSTAGED', 8, 's t ey jh d', 5], ['STAKED', 6, 's t ey k t', 5], ['STALED', 6, 's t ey l d', 5], ['STALES', 6, 's t ey l z', 5], ['SUSTAINS', 8, 's t ey n z', 5], ['DIASTASE', 8, 's t ey s', 4], ['UPSTATE', 7, 's t ey t', 4], ['UNSTATES', 8, 's t ey t s', 5], ['STAVE', 5, 's t ey v', 4], ['STAVED', 6, 's t ey v d', 5], ['STAVES', 6, 's t ey v z', 5], ['STAYS', 5, 's t ey z', 4], ['WESTHEAD', 8, 's t hh eh d', 5], ['PESTHOLE', 8, 's t hh ow l', 5], ['ZESTIER', 7, 's t ia', 3], ['STEERED', 7, 's t ia d', 4], ['OSTIUM', 6, 's t ia m', 4], ['YEASTIER', 8, 's t ia r', 4], ["STEER'S", 7, 's t ia r z', 5], ['SIXTIETH', 8, 's t ia th', 4], ['ZESTIEST', 8, 's t ih', 3], ['UNSTITCH', 8, 's t ih ch', 4], ['ZESTED', 6, 's t ih d', 4], ['WORSTEDS', 8, 's t ih d z', 5], ['STIFFS', 6, 's t ih f s', 5], ['STIFFED', 7, 's t ih f t', 5], ['WASTAGE', 7, 's t ih jh', 4], ['STICKED', 7, 's t ih k t', 5], ['STILT', 5, 's t ih l t', 5], ['STILTS', 6, 's t ih l t s', 6], ['STILLS', 6, 's t ih l z', 5], ['WESTIN', 6, 's t ih n', 4], ['STINT', 5, 's t ih n t', 5], ['STINTS', 6, 's t ih n t s', 6], ["WESTIN'S", 8, 's t ih n z', 5], ['ZESTING', 7, 's t ih ng', 4], ['WESTINGS', 8, 's t ih ng z', 5], ['STYPTICS', 8, 's t ih p', 4], ['VASTEST', 7, 's t ih s t', 5], ['WESTIES', 7, 's t ih z', 4], ['TRUSTEED', 8, 's t iy d', 4], ['STEEDS', 6, 's t iy d z', 5], ['MYSTIQUE', 8, 's t iy k', 4], ['STEELED', 7, 's t iy l d', 5], ['STEELS', 6, 's t iy l z', 5], ['STEAMED', 7, 's t iy m d', 5], ['STEAMS', 6, 's t iy m z', 5], ['STEENTH', 7, 's t iy n th', 5], ['STEENS', 6, 's t iy n z', 5], ['STEEPS', 6, 's t iy p s', 5], ['STEEPED', 7, 's t iy p t', 5], ['POSTICHE', 8, 's t iy sh', 4], ['STEVES', 6, 's t iy v z', 5], ['TRUSTEES', 8, 's t iy z', 4], ['PRESTIGE', 8, 's t iy zh', 4], ['WASTELL', 7, 's t l', 3], ['WISTLESS', 8, 's t l ax s', 5], ['PISTOLED', 8, 's t l d', 4], ['LISTLESS', 8, 's t l ih s', 5], ['WRISTLET', 8, 's t l ih t', 5], ['HOSTELRY', 8, 's t l r ih', 5], ['STODGE', 6, 's t oh jh', 4], ['STODGED', 7, 's t oh jh d', 5], ['STOMPING', 8, 's t oh m', 4], ['STOMP', 5, 's t oh m p', 5], ['STOMPS', 6, 's t oh m p s', 6], ['STOMPED', 7, 's t oh m p t', 6], ['STOPPED', 7, 's t oh p t', 5], ['CUSTOS', 6, 's t oh s', 4], ['STOTFOLD', 8, 's t oh t', 4], ['UNSTOIC', 7, 's t ow', 3], ['STOWED', 6, 's t ow d', 4], ['STOKE', 5, 's t ow k', 4], ['STOKES', 6, 's t ow k s', 5], ['UNSTOKED', 8, 's t ow k t', 5], ['STOLE', 5, 's t ow l', 4], ['STOLED', 6, 's t ow l d', 5], ['STOLES', 6, 's t ow l z', 5], ['UNSTONED', 8, 's t ow n d', 5], ['STOAT', 5, 's t ow t', 4], ['STOATS', 6, 's t ow t s', 5], ['STOVES', 6, 's t ow v z', 5], ['STOWS', 5, 's t ow z', 4], ['MASTOIDS', 8, 's t oy d z', 5], ['STRADE', 6, 's t r aa d', 5], ['STRAFE', 6, 's t r aa f', 5], ['STRAFES', 7, 's t r aa f s', 6], ['STROM', 5, 's t r aa m', 5], ["STROM'S", 7, 's t r aa m z', 6], ['STRAG', 5, 's t r ae g', 5], ['STRAMP', 6, 's t r ae m p', 6], ['UNSTRAND', 8, 's t r ae n d', 6], ['UNSTRAP', 7, 's t r ae p', 5], ['UNSTRAPS', 8, 's t r ae p s', 6], ['STRUMMED', 8, 's t r ah m d', 6], ['STRUMS', 6, 's t r ah m z', 6], ['VESTRON', 7, 's t r ah n', 5], ['UNSTRUNG', 8, 's t r ah ng', 5], ['STRUSS', 6, 's t r ah s', 5], ['STRUT', 5, 's t r ah t', 5], ['STRUTS', 6, 's t r ah t s', 6], ['STRAWY', 6, 's t r ao', 4], ['STRAWED', 7, 's t r ao d', 5], ['STRAWS', 6, 's t r ao z', 5], ['STROUD', 6, 's t r aw d', 5], ['STROUDS', 7, 's t r aw d z', 6], ['STROUT', 6, 's t r aw t', 5], ["STROUT'S", 8, 's t r aw t s', 6], ['WESTRA', 6, 's t r ax', 4], ['WASTREL', 7, 's t r ax l', 5], ['WASTRELS', 8, 's t r ax l z', 6], ['WESTRUM', 7, 's t r ax m', 5], ['SISTRUMS', 8, 's t r ax m z', 6], ['STRIDES', 7, 's t r ay d z', 6], ['WASTRIFE', 8, 's t r ay f', 5], ['STRIFES', 7, 's t r ay f s', 6], ['UPSTRIKE', 8, 's t r ay k', 5], ['STRIKES', 7, 's t r ay k s', 6], ['STRINE', 6, 's t r ay n', 5], ['STRIND', 6, 's t r ay n d', 6], ['STRIPE', 6, 's t r ay p', 5], ['STRIPES', 7, 's t r ay p s', 6], ['UPSTRIVE', 8, 's t r ay v', 5], ['STRIVED', 7, 's t r ay v d', 6], ['STRIVES', 7, 's t r ay v z', 6], ['STRENT', 6, 's t r eh n t', 6], ['STRETTE', 7, 's t r eh t', 5], ['WESTRAY', 7, 's t r ey', 4], ['STRAYED', 7, 's t r ey d', 5], ['STRAINS', 7, 's t r ey n z', 6], ['ESTRACE', 7, 's t r ey s', 5], ['WESTRATE', 8, 's t r ey t', 5], ['STRAYS', 6, 's t r ey z', 5], ['AUSTRIUM', 8, 's t r ia m', 5], ['WESTRICH', 8, 's t r ih ch', 5], ['WESTRICK', 8, 's t r ih k', 5], ['UNSTRIP', 7, 's t r ih p', 5], ['STRIPS', 6, 's t r ih p s', 6], ['STRIVEN', 7, 's t r ih v', 5], ['VESTRIES', 8, 's t r ih z', 5], ['STREED', 6, 's t r iy d', 5], ['STREAK', 6, 's t r iy k', 5], ['STREAKS', 7, 's t r iy k s', 6], ['STREAMS', 7, 's t r iy m z', 6], ['STREETS', 7, 's t r iy t s', 6], ['STROPPY', 7, 's t r oh', 4], ['STROP', 5, 's t r oh p', 5], ['STROPS', 6, 's t r oh p s', 6], ['STROPPED', 8, 's t r oh p t', 6], ['FOXTROT', 7, 's t r oh t', 5], ['FOXTROTS', 8, 's t r oh t s', 6], ['STROWING', 8, 's t r ow', 4], ["STROBE'S", 8, 's t r ow b z', 6], ['STROWD', 6, 's t r ow d', 5], ['STRODES', 7, 's t r ow d z', 6], ['UPSTROKE', 8, 's t r ow k', 5], ['STROLLE', 7, 's t r ow l', 5], ['STROLLED', 8, 's t r ow l d', 6], ['STROLLS', 7, 's t r ow l z', 6], ['STROVE', 6, 's t r ow v', 5], ['STROHS', 6, 's t r ow z', 5], ['STROYER', 7, 's t r oy', 4], ['DESTROYS', 8, 's t r oy z', 5], ['OESTRUAL', 8, 's t r ua l', 5], ['EXTRUDES', 8, 's t r uw d z', 6], ['RESTROOM', 8, 's t r uw m', 5], ['UNSTREWN', 8, 's t r uw n', 5], ['ABSTRUSE', 8, 's t r uw s', 5], ['STRUTH', 6, 's t r uw th', 5], ['STREWS', 6, 's t r uw z', 5], ['STOODED', 7, 's t uh', 3], ['STOOK', 5, 's t uh k', 4], ['STOEP', 5, 's t uh p', 4], ['STOEPS', 6, 's t uh p s', 5], ['STOOGE', 6, 's t uw jh', 4], ['STOOGED', 7, 's t uw jh d', 5], ['STOOLED', 7, 's t uw l d', 5], ['TESTOON', 7, 's t uw n', 4], ['FESTOONS', 8, 's t uw n z', 5], ['STOUP', 5, 's t uw p', 4], ['STOUPS', 6, 's t uw p s', 5], ['STOOPED', 7, 's t uw p t', 5], ['WESTWARD', 8, 's t w ax d', 5], ['STEWARD', 7, 's t y ua d', 5], ['STEWARDS', 8, 's t y ua d z', 6], ['VISTULA', 7, 's t y uh', 4], ['TESTUDO', 7, 's t y uw', 4], ['STUDENTS', 8, 's t y uw d', 5], ['PUSTULE', 7, 's t y uw l', 5], ['PUSTULED', 8, 's t y uw l d', 6], ['PUSTULES', 8, 's t y uw l z', 6], ['COSTUMED', 8, 's t y uw m d', 6], ['STUPE', 5, 's t y uw p', 5], ['STUPES', 6, 's t y uw p s', 6], ['STEWS', 5, 's t y uw z', 5], ['VAVASOUR', 8, 's ua', 2], ["SUSIE'S", 7, 's uh', 2], ['NAINSOOK', 8, 's uh k', 3], ['SOOT', 4, 's uh t', 3], ['SOOTS', 5, 's uh t s', 4], ['LASSOED', 7, 's uw d', 3], ['SOOTHE', 6, 's uw dh', 3], ['SOOTHED', 7, 's uw dh d', 4], ['SOOTHES', 7, 's uw dh z', 4], ['SOON', 4, 's uw n', 3], ['MONSOONS', 8, 's uw n z', 4], ['SOUPS', 5, 's uw p s', 4], ['SOUPED', 6, 's uw p t', 4], ['SOOTHS', 6, 's uw th s', 4], ['SUSANS', 6, 's uw z', 3], ['TSWANAS', 7, 's w aa', 3], ['SWANSONS', 8, 's w aa n', 4], ["SWANN'S", 7, 's w aa n z', 5], ['SUAVE', 5, 's w aa v', 4], ["SUAVE'S", 7, 's w aa v z', 5], ['SWAGING', 7, 's w ae', 3], ['SWAG', 4, 's w ae g', 4], ['SWAGED', 6, 's w ae g d', 5], ['SWAGES', 6, 's w ae g z', 5], ['SWAM', 4, 's w ae m', 4], ['SWANKY', 6, 's w ae ng', 4], ['SWANK', 5, 's w ae ng k', 5], ['SWUM', 4, 's w ah m', 4], ['SWUNG', 5, 's w ah ng', 4], ['SWORE', 5, 's w ao', 3], ['SWARD', 5, 's w ao d', 4], ['SWARDS', 6, 's w ao d z', 5], ['SWARM', 5, 's w ao m', 4], ['SWARMED', 7, 's w ao m d', 5], ['SWARMS', 6, 's w ao m z', 5], ['SWORN', 5, 's w ao n', 4], ['SWORE', 5, 's w ao r', 4], ['SWARTZES', 8, 's w ao t', 4], ['SWARTS', 6, 's w ao t s', 5], ['SWATH', 5, 's w ao th', 4], ['SWATHS', 6, 's w ao th s', 5], ['SWIPING', 7, 's w ay', 3], ['SWINE', 5, 's w ay n', 4], ['SWIPE', 5, 's w ay p', 4], ['SWIPES', 6, 's w ay p s', 5], ['SWIPED', 6, 's w ay p t', 5], ['SWEAR', 5, 's w ea r', 4], ['SWEARS', 6, 's w ea z', 4], ['SWELTERS', 8, 's w eh l', 4], ['SWELLED', 7, 's w eh l d', 5], ['SWELLS', 6, 's w eh l z', 5], ['SWEATS', 6, 's w eh t s', 5], ['PASSWORD', 8, 's w er d', 4], ['WAXWORK', 7, 's w er k', 4], ['WAXWORKS', 8, 's w er k s', 5], ['SWIRL', 5, 's w er l', 4], ['SWIRLED', 7, 's w er l d', 5], ['SWIRLS', 6, 's w er l z', 5], ['SWERVE', 6, 's w er v', 4], ['SWERVED', 7, 's w er v d', 5], ['SWERVES', 7, 's w er v z', 5], ['UNSWAYED', 8, 's w ey d', 4], ['SUEDES', 6, 's w ey d z', 5], ['SWATHE', 6, 's w ey dh', 4], ['SWATHED', 7, 's w ey dh d', 5], ['SWATHES', 7, 's w ey dh z', 5], ['SWAGE', 5, 's w ey jh', 4], ['SWAGED', 6, 's w ey jh d', 5], ['SWAINE', 6, 's w ey n', 4], ['SWAINS', 6, 's w ey n z', 5], ['SWAYS', 5, 's w ey z', 4], ['SWITCHED', 8, 's w ih ch t', 5], ['SWIFTY', 6, 's w ih f', 4], ['SWIFTS', 6, 's w ih f t s', 6], ['SWIG', 4, 's w ih g', 4], ['SWIGGED', 7, 's w ih g d', 5], ['SWIGS', 5, 's w ih g z', 5], ['MESSUAGE', 8, 's w ih jh', 4], ['SWILL', 5, 's w ih l', 4], ['SWILLED', 7, 's w ih l d', 5], ['SWILLS', 6, 's w ih l z', 5], ['SWIMS', 5, 's w ih m z', 5], ['SWINTON', 7, 's w ih n', 4], ['SWINGE', 6, 's w ih n jh', 5], ['WAXWING', 7, 's w ih ng', 4], ['WAXWINGS', 8, 's w ih ng z', 5], ['SWISS', 5, 's w ih s', 4], ['SWISH', 5, 's w ih sh', 4], ['SWISHED', 7, 's w ih sh t', 5], ['SWIZ', 4, 's w ih z', 4], ['SWEDES', 6, 's w iy d z', 5], ['SWEEPS', 6, 's w iy p s', 5], ['SUISSE', 6, 's w iy s', 4], ['SWEETS', 6, 's w iy t s', 5], ['SWOTTING', 8, 's w oh', 3], ['SWOB', 4, 's w oh b', 4], ['SWOBBED', 7, 's w oh b d', 5], ['SWOBS', 5, 's w oh b z', 5], ['SWAMPY', 6, 's w oh m', 4], ['SWAMP', 5, 's w oh m p', 5], ['SWAMPS', 6, 's w oh m p s', 6], ['SWAMPED', 7, 's w oh m p t', 6], ['SWANTON', 7, 's w oh n', 4], ['SWANNED', 7, 's w oh n d', 5], ['SWANS', 5, 's w oh n z', 5], ['SWOP', 4, 's w oh p', 4], ['SWOPS', 5, 's w oh p s', 5], ['SWOPPED', 7, 's w oh p t', 5], ['SWASHED', 7, 's w oh sh t', 5], ['SWOT', 4, 's w oh t', 4], ['SWOTS', 5, 's w oh t s', 5], ['BOXWOOD', 7, 's w uh d', 4], ['BOXWOODS', 8, 's w uh d z', 5], ['SWOOPING', 8, 's w uw', 3], ['SWOON', 5, 's w uw n', 4], ['SWOONED', 7, 's w uw n d', 5], ['SWOONS', 6, 's w uw n z', 5], ['SWOOP', 5, 's w uw p', 4], ['SWOOPS', 6, 's w uw p s', 5], ['SWOOPED', 7, 's w uw p t', 5], ['TRUCIAL', 7, 's y ax l', 4], ['DACIANS', 7, 's y ax n z', 5], ['CADUCEUS', 8, 's y ax s', 4], ['CADUCEI', 7, 's y ay', 3], ['MONSIEUR', 8, 's y er', 3], ['MONSIEUR', 8, 's y er r', 4], ['SURAH', 5, 's y ua', 3], ['URSULA', 6, 's y uh', 3], ['UNSUED', 6, 's y uw d', 4], ['SUEDES', 6, 's y uw d z', 5], ['CAPSULED', 8, 's y uw l d', 5], ['SUBSUME', 7, 's y uw m', 4], ['SUBSUMES', 8, 's y uw m z', 5], ['MISUSE', 6, 's y uw s', 4], ['UNSUIT', 6, 's y uw t', 4], ['PURSUITS', 8, 's y uw t s', 5], ['SUES', 4, 's y uw z', 4], ['MISUSED', 7, 's y uw z d', 5], ['SHARPLY', 7, 'sh aa', 2], ['SHARD', 5, 'sh aa d', 3], ['SHARDS', 6, 'sh aa d z', 4], ['SHAFTY', 6, 'sh aa f', 3], ['SHAFTS', 6, 'sh aa f t s', 5], ['SHARKS', 6, 'sh aa k s', 4], ['SHARKED', 7, 'sh aa k t', 4], ['PENCHANT', 8, 'sh aa n', 3], ["SHAN'T", 6, 'sh aa n t', 4], ['SHARPS', 6, 'sh aa p s', 4], ['SHARPED', 7, 'sh aa p t', 4], ['SUCHARD', 7, 'sh aa r d', 4], ['SHAHS', 5, 'sh aa z', 3], ['SHAD', 4, 'sh ae d', 3], ["SHAD'S", 6, 'sh ae d z', 4], ['SHAG', 4, 'sh ae g', 3], ['SHAGGED', 7, 'sh ae g d', 4], ['SHAGS', 5, 'sh ae g z', 4], ['SHACKSON', 8, 'sh ae k', 3], ['SHACKS', 6, 'sh ae k s', 4], ['SHACKED', 7, 'sh ae k t', 4], ['SHALL', 5, 'sh ae l', 3], ['SHALT', 5, 'sh ae l t', 4], ['SJAMBOK', 7, 'sh ae m', 3], ['SHAMMED', 7, 'sh ae m d', 4], ['SHAMPS', 6, 'sh ae m p s', 5], ['SHAMS', 5, 'sh ae m z', 4], ['TANGSHAN', 8, 'sh ae n', 3], ['SHANDS', 6, 'sh ae n d z', 5], ['SHANKLIN', 8, 'sh ae ng', 3], ['SHANK', 5, 'sh ae ng k', 4], ['SHANKS', 6, 'sh ae ng k s', 5], ['SHANKED', 7, 'sh ae ng k t', 5], ['SHAT', 4, 'sh ae t', 3], ['SHOUGH', 6, 'sh ah f', 3], ['SHUCK', 5, 'sh ah k', 3], ['SHUCKS', 6, 'sh ah k s', 4], ['SHUCKED', 7, 'sh ah k t', 4], ['SCHULTZ', 7, 'sh ah l t s', 5], ['SHUNTO', 6, 'sh ah n', 3], ['SHUNNED', 7, 'sh ah n d', 4], ['SHUNT', 5, 'sh ah n t', 4], ['SHUNTS', 6, 'sh ah n t s', 5], ['SMASH-UP', 8, 'sh ah p', 3], ['SHUTS', 5, 'sh ah t s', 4], ['SHOVE', 5, 'sh ah v', 3], ['SHOVED', 6, 'sh ah v d', 4], ['SHOVES', 6, 'sh ah v z', 4], ['SHORED', 6, 'sh ao d', 3], ['SHAWL', 5, 'sh ao l', 3], ['SHAWLED', 7, 'sh ao l d', 4], ['SHAWLS', 6, 'sh ao l z', 4], ['SHAWM', 5, 'sh ao m', 3], ['SHAWMS', 6, 'sh ao m z', 4], ['UNSHORN', 7, 'sh ao n', 3], ["SEAN'S", 6, 'sh ao n z', 4], ['UNSHORE', 7, 'sh ao r', 3], ['UNSHORED', 8, 'sh ao r d', 4], ["SHORE'S", 7, 'sh ao r z', 4], ['SHORTS', 6, 'sh ao t s', 4], ['SHORES', 6, 'sh ao z', 3], ['SHOWERY', 7, 'sh aw', 2], ['WASHOUT', 7, 'sh aw t', 3], ['WASHOUTS', 8, 'sh aw t s', 4], ['USHERED', 7, 'sh ax d', 3], ['WALSHAM', 7, 'sh ax m', 3], ['BISHOPS', 7, 'sh ax p s', 4], ['BISHOPED', 8, 'sh ax p t', 4], ['CUSHAT', 6, 'sh ax t', 3], ['WORKSHY', 7, 'sh ay', 2], ['SHIED', 5, 'sh ay d', 3], ['SHINED', 6, 'sh ay n d', 4], ['WILSHIRE', 8, 'sh ay r', 3], ['SHIES', 5, 'sh ay z', 3], ['SHARING', 7, 'sh ea', 2], ['SHARED', 6, 'sh ea d', 3], ['SHARE', 5, 'sh ea r', 3], ["SHARE'S", 7, 'sh ea r z', 4], ['SHARES', 6, 'sh ea z', 3], ['WOODSHED', 8, 'sh eh d', 3], ['CHEFS', 5, 'sh eh f s', 4], ['SHELLED', 7, 'sh eh l d', 4], ['SHELF', 5, 'sh eh l f', 4], ['SHELFS', 6, 'sh eh l f s', 5], ['SHELVE', 6, 'sh eh l v', 4], ['SHELVED', 7, 'sh eh l v d', 5], ['SHELVES', 7, 'sh eh l v z', 5], ['SHELLS', 6, 'sh eh l z', 4], ['SHIRTY', 6, 'sh er', 2], ['SHERD', 5, 'sh er d', 3], ['SHERDS', 6, 'sh er d z', 4], ['SHIRK', 5, 'sh er k', 3], ['SHIRKS', 6, 'sh er k s', 4], ['SHIRKED', 7, 'sh er k t', 4], ["SHER'S", 6, 'sh er z', 3], ['UNSHADE', 7, 'sh ey d', 3], ['SHEIKS', 6, 'sh ey k s', 4], ['SHAKED', 6, 'sh ey k t', 4], ['SHALE', 5, 'sh ey l', 3], ['SHALED', 6, 'sh ey l d', 4], ['SHALES', 6, 'sh ey l z', 4], ["SHAMES'S", 8, 'sh ey m', 3], ['SHAMES', 6, 'sh ey m z', 4], ['SHANE', 5, 'sh ey n', 3], ["SHANE'S", 7, 'sh ey n z', 4], ['UNSHAPE', 7, 'sh ey p', 3], ['SHAPES', 6, 'sh ey p s', 4], ['UNSHAPED', 8, 'sh ey p t', 4], ['UNSHAVED', 8, 'sh ey v d', 4], ['SHAVES', 6, 'sh ey v z', 4], ["SHARES'", 7, 'sh ey z', 3], ['BASHFORD', 8, 'sh f ax d', 4], ['PUSHFUL', 7, 'sh f uh l', 4], ['DISHFULS', 8, 'sh f uh l z', 5], ['WASHIER', 7, 'sh ia', 2], ['SHEERED', 7, 'sh ia d', 3], ['TITIAN', 6, 'sh ia n', 3], ['TITIANS', 7, 'sh ia n z', 4], ['TRASHIER', 8, 'sh ia r', 3], ['SHEARD', 6, 'sh ia r d', 4], ["SHEAR'S", 7, 'sh ia r z', 4], ['SHEERS', 6, 'sh ia z', 3], ['SHIFTY', 6, 'sh ih f', 3], ['SHIFT', 5, 'sh ih f t', 4], ['SHIFTS', 6, 'sh ih f t s', 5], ['SHILDON', 7, 'sh ih l d', 4], ['SHILTON', 7, 'sh ih l t', 4], ['SHINNED', 7, 'sh ih n d', 4], ['SHINS', 5, 'sh ih n z', 4], ['WASHINGS', 8, 'sh ih ng z', 4], ['WORSHIPS', 8, 'sh ih p s', 4], ['SCHIST', 6, 'sh ih s t', 4], ['SCHISTS', 7, 'sh ih s t s', 5], ['SHIT', 4, 'sh ih t', 3], ['SHITS', 5, 'sh ih t s', 4], ['WISHES', 6, 'sh ih z', 3], ["SHE'D", 5, 'sh iy d', 3], ['SHEAF', 5, 'sh iy f', 3], ['SHEAFS', 6, 'sh iy f s', 4], ['SHEAFED', 7, 'sh iy f t', 4], ['CHIC', 4, 'sh iy k', 3], ["CHIC'S", 6, 'sh iy k s', 4], ['SHIELDS', 7, 'sh iy l z', 4], ['SHEENED', 7, 'sh iy n d', 4], ["SHIPS'", 6, 'sh iy p s', 4], ['HASHISH', 7, 'sh iy sh', 3], ['SHEAVES', 7, 'sh iy v z', 4], ['UNSOCIAL', 8, 'sh l', 2], ['ASHLARED', 8, 'sh l ax d', 4], ['ASHLARS', 7, 'sh l ax z', 4], ['RUSHLIKE', 8, 'sh l ay k', 4], ['ASHLEY', 6, 'sh l iy', 3], ['ASHLEYS', 7, 'sh l iy z', 4], ['NUPTIALS', 8, 'sh l s', 3], ['SPECIALS', 8, 'sh l z', 3], ['YASHMAK', 7, 'sh m ae k', 4], ['YASHMAKS', 8, 'sh m ae k s', 5], ['FISHMAN', 7, 'sh m ae n', 4], ['MISHMASH', 8, 'sh m ae sh', 4], ['CUSHMAN', 7, 'sh m ah n', 4], ['CUSHMANS', 8, 'sh m ah n z', 5], ['SCHMALL', 7, 'sh m ao l', 4], ['WELSHMEN', 8, 'sh m ax n', 4], ['KASHMIR', 7, 'sh m ia r', 4], ['KASHMIRS', 8, 'sh m ia r z', 5], ['KASHMIRS', 8, 'sh m ia z', 4], ['SCHMIDT', 7, 'sh m ih t', 4], ['SCHNAPP', 7, 'sh n ae p', 4], ['SCHNAPS', 7, 'sh n ae p s', 5], ['PATIENCE', 8, 'sh n s', 3], ['UPSHAW', 6, 'sh oh', 2], ['UNSHOD', 6, 'sh oh d', 3], ['SHOCKS', 6, 'sh oh k s', 4], ['SHOCKED', 7, 'sh oh k t', 4], ['SCHALL', 6, 'sh oh l', 3], ['SHONE', 5, 'sh oh n', 3], ['SOUCHONG', 8, 'sh oh ng', 3], ['WORKSHOP', 8, 'sh oh p', 3], ['SHOPPED', 7, 'sh oh p t', 4], ['UPSHOT', 6, 'sh oh t', 3], ['UPSHOTS', 7, 'sh oh t s', 4], ["UPSHAW'S", 8, 'sh oh z', 3], ['SHOWED', 6, 'sh ow d', 3], ['SHOALED', 7, 'sh ow l d', 4], ['SHOALS', 6, 'sh ow l z', 4], ['SHOWN', 5, 'sh ow n', 3], ['ASHRAWI', 7, 'sh r aa', 3], ['SHRANK', 6, 'sh r ae ng k', 5], ['SHRAPNEL', 8, 'sh r ae p', 4], ['SHRUB', 5, 'sh r ah b', 4], ['SHRUBS', 6, 'sh r ah b z', 5], ['SHRUG', 5, 'sh r ah g', 4], ['SHRUGGED', 8, 'sh r ah g d', 5], ['SHRUGS', 6, 'sh r ah g z', 5], ['SHRUNKEN', 8, 'sh r ah n', 4], ['SHRUNKEN', 8, 'sh r ah ng', 4], ['SHRUNK', 6, 'sh r ah ng k', 5], ['UNSHROUD', 8, 'sh r aw d', 4], ['SHROUDS', 7, 'sh r aw d z', 5], ['SHRIVING', 8, 'sh r ay', 3], ['SHRIKE', 6, 'sh r ay k', 4], ['SHRIKES', 7, 'sh r ay k s', 5], ['SHRINES', 7, 'sh r ay n z', 5], ['SHRIVE', 6, 'sh r ay v', 4], ['SHRIVED', 7, 'sh r ay v d', 5], ['SHRIVES', 7, 'sh r ay v z', 5], ['SHREDDY', 7, 'sh r eh', 3], ['SHRED', 5, 'sh r eh d', 4], ['SHREDS', 6, 'sh r eh d z', 5], ['SHRIFT', 6, 'sh r ih f t', 5], ['UNSHRILL', 8, 'sh r ih l', 4], ['SHRILLED', 8, 'sh r ih l d', 5], ['SHRILLS', 7, 'sh r ih l z', 5], ['SHRIMP', 6, 'sh r ih m p', 5], ['UNSHRINK', 8, 'sh r ih ng k', 5], ['SHRIEK', 6, 'sh r iy k', 4], ['SHRIEKS', 7, 'sh r iy k s', 5], ['SHRIEKED', 8, 'sh r iy k t', 5], ['SHROVER', 7, 'sh r ow', 3], ['MUSHROOM', 8, 'sh r uh m', 4], ['SHREWED', 7, 'sh r uw d', 4], ['WASHROOM', 8, 'sh r uw m', 4], ['SHREWS', 6, 'sh r uw z', 4], ['UNSURE', 6, 'sh ua', 2], ['INSUREDS', 8, 'sh ua d z', 4], ['UNSEXUAL', 8, 'sh ua l', 3], ['UNSURE', 6, 'sh ua r', 3], ['SHOOK', 5, 'sh uh k', 3], ['SHOOKS', 6, 'sh uh k s', 4], ["SHULTZ'S", 8, 'sh uh l t', 4], ['SHULTZ', 6, 'sh uh l t s', 5], ['FUSHUN', 6, 'sh uh n', 3], ['SHUSH', 5, 'sh uh sh', 3], ['SHUSHED', 7, 'sh uh sh t', 4], ['TISSUED', 7, 'sh uw d', 3], ['TISSUES', 7, 'sh uw z', 3], ['SCHWERIN', 8, 'sh v eh', 3], ['SCHWAR', 6, 'sh w aa', 3], ['SCHWAB', 6, 'sh w aa b', 4], ["SCHWAB'S", 8, 'sh w aa b z', 5], ['SCHWAS', 6, 'sh w aa z', 4], ['FISHWIFE', 8, 'sh w ay f', 4], ['SIAN', 4, 'sh y aa n', 4], ["SIAN'S", 6, 'sh y aa n z', 5], ['TESTACEA', 8, 'sh y ax', 3], ['FIDUCIAL', 8, 'sh y ax l', 4], ['SOLATIUM', 8, 'sh y ax m', 4], ['THRACIAN', 8, 'sh y ax n', 4], ['VITALY', 6, 't aa', 2], ['TARRED', 6, 't aa d', 3], ['RETARDS', 7, 't aa d z', 4], ['EPITAPH', 7, 't aa f', 3], ['EPITAPHS', 8, 't aa f s', 4], ['HEPTARCH', 8, 't aa k', 3], ['TARN', 4, 't aa n', 3], ['TARNS', 5, 't aa n z', 4], ['TAR', 3, 't aa r', 3], ["QATAR'S", 7, 't aa r z', 4], ['TASKS', 5, 't aa s k s', 5], ['TASKED', 6, 't aa s k t', 5], ['TACHE', 5, 't aa sh', 3], ['TARTNESS', 8, 't aa t', 3], ['TARTS', 5, 't aa t s', 4], ['TARS', 4, 't aa z', 3], ['SABOTAGE', 8, 't aa zh', 3], ['TAB', 3, 't ae b', 3], ['TABS', 4, 't ae b z', 4], ['UNATTACH', 8, 't ae ch', 3], ['WANT-AD', 7, 't ae d', 3], ['WANT-ADS', 8, 't ae d z', 4], ['TAFT', 4, 't ae f t', 4], ["TAFT'S", 6, 't ae f t s', 5], ['TAG', 3, 't ae g', 3], ['TAGGED', 6, 't ae g d', 4], ['TAGS', 4, 't ae g z', 4], ['UNTAXING', 8, 't ae k', 3], ['TINTACKS', 8, 't ae k s', 4], ['UNTAXED', 7, 't ae k s t', 5], ['CONTACTS', 8, 't ae k t s', 5], ['TALMUDS', 7, 't ae l', 3], ['TALC', 4, 't ae l k', 4], ['TALCED', 6, 't ae l k t', 5], ['TIMBRES', 7, 't ae m', 3], ['TAMP', 4, 't ae m p', 4], ['TAMPS', 5, 't ae m p s', 5], ['TAMPED', 6, 't ae m p t', 5], ['UNTANNED', 8, 't ae n d', 4], ['TANS', 4, 't ae n z', 4], ['TANGED', 6, 't ae ng d', 4], ['TANKED', 6, 't ae ng k t', 5], ['TANGS', 5, 't ae ng z', 4], ['TAPS', 4, 't ae p s', 4], ['UNTAPPED', 8, 't ae p t', 4], ['TASS', 4, 't ae s', 3], ['TASHKENT', 8, 't ae sh', 3], ['TAT', 3, 't ae t', 3], ['TATS', 4, 't ae t s', 4], ['WASHTUB', 7, 't ah b', 3], ['WASHTUBS', 8, 't ah b z', 4], ['UNTOUCH', 7, 't ah ch', 3], ['TUFTY', 5, 't ah f', 3], ['TOUGHS', 6, 't ah f s', 4], ["TUFTS'S", 7, 't ah f t', 4], ["TUFTS'", 6, 't ah f t s', 5], ['TUGBOATS', 8, 't ah g', 3], ['TUGGED', 6, 't ah g d', 4], ['TUGS', 4, 't ah g z', 4], ['UNTUCK', 6, 't ah k', 3], ['TUCKS', 5, 't ah k s', 4], ['UNTUCKED', 8, 't ah k t', 4], ['SOCIETAL', 8, 't ah l', 3], ['TUMBRILS', 8, 't ah m', 3], ['TONNED', 6, 't ah n d', 4], ['TUNKU', 5, 't ah ng', 3], ['TONGUED', 7, 't ah ng d', 4], ['TONGUES', 7, 't ah ng z', 4], ['WRITE-UP', 8, 't ah p', 3], ['TUSK', 4, 't ah s k', 4], ['TUSKS', 5, 't ah s k s', 5], ['TUSKED', 6, 't ah s k t', 5], ['TUSH', 4, 't ah sh', 3], ['TUSHED', 6, 't ah sh t', 4], ['TUT-TUT', 7, 't ah t', 3], ['TUTS', 4, 't ah t s', 4], ['NIKITAS', 7, 't ah z', 3], ['TORCHED', 7, 't ao ch t', 4], ['TORQUE', 6, 't ao k', 3], ['TORQUES', 7, 't ao k s', 4], ['TORQUED', 7, 't ao k t', 4], ['TALLBOYS', 8, 't ao l', 3], ['TALLES', 6, 't ao l z', 4], ['WAR-TORN', 8, 't ao n', 3], ['TAUNT', 5, 't ao n t', 4], ['TAUNTS', 6, 't ao n t s', 5], ['TORNES', 6, 't ao n z', 4], ['UNTAUT', 6, 't ao t', 3], ['TORTS', 5, 't ao t s', 4], ['KOWTOWED', 8, 't aw d', 3], ['TOWLE', 5, 't aw l', 3], ['TOWLES', 6, 't aw l z', 4], ['UPTOWN', 6, 't aw n', 3], ['TOWNED', 6, 't aw n d', 4], ['UPTOWNS', 7, 't aw n z', 4], ['TOUT', 4, 't aw t', 3], ['TOUTS', 5, 't aw t s', 4], ['KOWTOWS', 7, 't aw z', 3], ['ZYGOMATA', 8, 't ax', 2], ['WINTERED', 8, 't ax d', 3], ['MATTOCK', 7, 't ax k', 3], ['MATTOCKS', 8, 't ax k s', 4], ['WITHAM', 6, 't ax m', 3], ['ITEMED', 6, 't ax m d', 4], ['WANTONED', 8, 't ax n d', 4], ['VISITANT', 8, 't ax n t', 4], ['YEUTTER', 7, 't ax r', 3], ['VECTORED', 8, 't ax r d', 4], ['VOMITUS', 7, 't ax s', 3], ['YULETIDE', 8, 't ay d', 3], ['TITHED', 6, 't ay dh d', 4], ['TITHES', 6, 't ay dh z', 4], ['TYKE', 4, 't ay k', 3], ['TYKES', 5, 't ay k s', 4], ['VOLATILE', 8, 't ay l', 3], ['TILED', 5, 't ay l d', 4], ['WARTIMES', 8, 't ay m z', 4], ['TINED', 5, 't ay n d', 4], ['TYPES', 5, 't ay p s', 4], ['TICE', 4, 't ay s', 3], ['ENTICED', 7, 't ay s t', 4], ['TIGHTS', 6, 't ay t s', 4], ['ST_IVES', 7, 't ay v z', 4], ['YOTIZE', 6, 't ay z', 3], ['HUTCHINS', 8, 't ch ih n z', 5], ["WHATE'ER", 8, 't ea', 2], ['TEARED', 6, 't ea d', 3], ["WHATE'ER", 8, 't ea r', 3], ['TEARED', 6, 't ea r d', 4], ["TEAR'S", 6, 't ea r z', 4], ['TEARS', 5, 't ea z', 3], ['TED', 3, 't eh d', 3], ['TEDS', 4, 't eh d z', 4], ['TEG', 3, 't eh g', 3], ['TEGS', 4, 't eh g z', 4], ['VORTEX', 6, 't eh k s', 4], ['TEXTS', 5, 't eh k s t s', 6], ['TECHED', 6, 't eh k t', 4], ['PROTECTS', 8, 't eh k t s', 5], ['TELSTAR', 7, 't eh l', 3], ["TELXON'S", 8, 't eh l k', 4], ['TELLS', 5, 't eh l z', 4], ['TEMPS', 5, 't eh m p s', 5], ['TEMPT', 5, 't eh m p t', 5], ['TEMPTS', 6, 't eh m p t s', 6], ['THAMES', 6, 't eh m z', 4], ['TENCH', 5, 't eh n ch', 4], ['TEND', 4, 't eh n d', 4], ['TENDS', 5, 't eh n d z', 5], ['UNTENSE', 7, 't eh n s', 4], ['TENSED', 6, 't eh n s t', 5], ['UNTENT', 6, 't eh n t', 4], ['TENTS', 5, 't eh n t s', 5], ['TENTH', 5, 't eh n th', 4], ['TENTHS', 6, 't eh n th s', 5], ['TENS', 4, 't eh n z', 4], ['TENGKU', 6, 't eh ng', 3], ['TESS', 4, 't eh s', 3], ['TESTBEDS', 8, 't eh s t', 4], ["TESTS'", 6, 't eh s t s', 5], ['SEPTETTE', 8, 't eh t', 3], ['VITEZ', 5, 't eh z', 3], ['PERTURB', 7, 't er b', 3], ['PERTURBS', 8, 't er b z', 4], ['TURDS', 5, 't er d z', 4], ['TURF', 4, 't er f', 3], ['TURFS', 5, 't er f s', 4], ['TURFED', 6, 't er f t', 4], ['TURK', 4, 't er k', 3], ["TURKS'", 6, 't er k s', 4], ['TERM', 4, 't er m', 3], ['TERMED', 6, 't er m d', 4], ['TERMS', 5, 't er m z', 4], ['UPTURN', 6, 't er n', 3], ['UPTURNS', 7, 't er n z', 4], ['TURPS', 5, 't er p s', 4], ['SECATEUR', 8, 't er r', 3], ['TERSE', 5, 't er s', 3], ['INTERSTS', 8, 't er s t s', 5], ['TERZETTO', 8, 't er t', 3], ['TURVES', 6, 't er v z', 4], ['WOLTERS', 7, 't er z', 3], ['UPTAKES', 7, 't ey k s', 4], ['WIGTAIL', 7, 't ey l', 3], ['UNTAILED', 8, 't ey l d', 4], ['WAGTAILS', 8, 't ey l z', 4], ['UNTAMED', 7, 't ey m d', 4], ['TAMES', 5, 't ey m z', 4], ['UNTAINT', 7, 't ey n t', 4], ['TAINTS', 6, 't ey n t s', 5], ['RETAINS', 7, 't ey n z', 4], ['PENATES', 7, 't ey s', 3], ['TASTES', 6, 't ey s t s', 5], ['VOLUTATE', 8, 't ey t', 3], ['OCTAVE', 6, 't ey v', 3], ["SAUT\\'ES", 8, 't ey z', 3], ['NUTHATCH', 8, 't hh ae ch', 4], ['POTHUNT', 7, 't hh ah n t', 5], ['POTHERB', 7, 't hh er b', 4], ['POTHERBS', 8, 't hh er b z', 5], ['GOATHERD', 8, 't hh er d', 4], ['WARTHOG', 7, 't hh oh g', 4], ['WARTHOGS', 8, 't hh oh g z', 5], ['RT_HON', 6, 't hh oh n', 4], ['POTHOLED', 8, 't hh ow l d', 5], ['POTHOOK', 7, 't hh uh k', 4], ['POTHOOKS', 8, 't hh uh k s', 5], ['WITTIER', 7, 't ia', 2], ['LACTEAL', 7, 't ia l', 3], ['LACTEALS', 8, 't ia l z', 4], ['TRITIUM', 7, 't ia m', 3], ['TRITIUMS', 8, 't ia m z', 4], ['PROTEAN', 7, 't ia n', 3], ['KANTIANS', 8, 't ia n z', 4], ['WITTIER', 7, 't ia r', 3], ['TIERED', 6, 't ia r d', 4], ['TIERCED', 7, 't ia s t', 4], ['YACHTED', 7, 't ih d', 3], ['TIFF', 4, 't ih f', 3], ['TIFFS', 5, 't ih f s', 4], ['TIFFED', 6, 't ih f t', 4], ['TIG', 3, 't ih g', 3], ['WATTAGE', 7, 't ih jh', 3], ['ZYMOTIC', 7, 't ih k', 3], ['UPTICKS', 7, 't ih k s', 4], ['TICKED', 6, 't ih k t', 4], ['UPTILL', 6, 't ih l', 3], ['UNTILLED', 8, 't ih l d', 4], ['TILDES', 6, 't ih l d z', 5], ['UPTILT', 6, 't ih l t', 4], ['UPTILTS', 7, 't ih l t s', 5], ['TILTH', 5, 't ih l th', 4], ['TILTHS', 6, 't ih l th s', 5], ['TILLS', 5, 't ih l z', 4], ['VICTIM', 6, 't ih m', 3], ['TIMPSON', 7, 't ih m p', 4], ["VICTIMS'", 8, 't ih m z', 4], ['UNTINNED', 8, 't ih n d', 4], ['TINGE', 5, 't ih n jh', 4], ['UNTINGED', 8, 't ih n jh d', 5], ['TINTS', 5, 't ih n t s', 5], ['TINS', 4, 't ih n z', 4], ['YACHTING', 8, 't ih ng', 3], ['TINGED', 6, 't ih ng d', 4], ['JOTTINGS', 8, 't ih ng s', 4], ['TIPS', 4, 't ih p s', 4], ['TIPPED', 6, 't ih p t', 4], ['WHITIS', 6, 't ih s', 3], ['STATISTS', 8, 't ih s t s', 5], ['WHITISH', 7, 't ih sh', 3], ['TOMTIT', 6, 't ih t', 3], ['TOMTITS', 7, 't ih t s', 4], ['ZLOTYS', 6, 't ih z', 3], ['UNTEACH', 7, 't iy ch', 3], ['TEED', 4, 't iy d', 3], ['TEETHE', 6, 't iy dh', 3], ['TEETHED', 7, 't iy dh d', 4], ['TEETHES', 7, 't iy dh z', 4], ['MOTIF', 5, 't iy f', 3], ['MOTIFS', 6, 't iy f s', 4], ["TEAK'S", 6, 't iy k s', 4], ['GENTEELS', 8, 't iy l z', 4], ['TEEM', 4, 't iy m', 3], ['TEEMED', 6, 't iy m d', 4], ['TEEMS', 5, 't iy m z', 4], ['TONTINES', 8, 't iy n z', 4], ['BATISTE', 7, 't iy s t', 4], ['BATISTES', 8, 't iy s t s', 5], ['TEETS', 5, 't iy t s', 4], ['TEASED', 6, 't iy z d', 4], ['TIGE', 4, 't iy zh', 3], ['NIGHTJAR', 8, 't jh aa', 3], ['NIGHTJAR', 8, 't jh aa r', 4], ['MUNTJAK', 7, 't jh ae k', 4], ['WYTHALL', 7, 't l', 2], ['TITLARK', 7, 't l aa k', 4], ['TITLARKS', 8, 't l aa k s', 5], ['OUTLAST', 7, 't l aa s t', 5], ['OUTLASTS', 8, 't l aa s t s', 6], ['SOFTLAND', 8, 't l ae n d', 5], ['WHITELAW', 8, 't l ao', 3], ['OUTLAWED', 8, 't l ao d', 4], ['WHITELAW', 8, 't l ao r', 4], ['OUTLAWS', 7, 't l ao z', 4], ['WHITTLER', 8, 't l ax', 3], ['ANTLERED', 8, 't l ax d', 4], ['SHETLAND', 8, 't l ax n d', 5], ['WHITTLER', 8, 't l ax r', 4], ['OUTLINED', 8, 't l ay n d', 5], ['OUTLINES', 8, 't l ay n z', 5], ['WHITTLED', 8, 't l d', 3], ['BOOTLEG', 7, 't l eh g', 4], ['BOOTLEGS', 8, 't l eh g z', 5], ['OUTLET', 6, 't l eh t', 4], ['OUTLETS', 7, 't l eh t s', 5], ['OUTLAID', 7, 't l ey d', 4], ['BOOTLACE', 8, 't l ey s', 4], ['OUTLAYS', 7, 't l ey z', 4], ['YATELEY', 7, 't l ih', 3], ['STRATLIN', 8, 't l ih n', 4], ['WITLING', 7, 't l ih ng', 4], ['WITLINGS', 8, 't l ih ng z', 5], ['WITLESS', 7, 't l ih s', 4], ['TITLIST', 7, 't l ih s t', 5], ['TITLISTS', 8, 't l ih s t s', 6], ['WITLET', 6, 't l ih t', 4], ['TARTLETS', 8, 't l ih t s', 5], ['OUTLIVE', 7, 't l ih v', 4], ['OUTLIVES', 8, 't l ih v z', 5], ['MATLOCK', 7, 't l oh k', 4], ['WHITLOW', 7, 't l ow', 3], ['CARTLOAD', 8, 't l ow d', 4], ['WHITLOWS', 8, 't l ow z', 4], ['SKITTLES', 8, 't l s', 3], ['OUTLOOK', 7, 't l uh k', 4], ['OUTLOOKS', 8, 't l uh k s', 5], ['ST_LOUIS', 8, 't l uw', 3], ['WHITTLES', 8, 't l z', 3], ["TODD'S", 6, 't oh d z', 4], ['TOG', 3, 't oh g', 3], ['TOGGED', 6, 't oh g d', 4], ['TOGS', 4, 't oh g z', 4], ['TOLBOOTH', 8, 't oh l', 3], ['ATOLLS', 6, 't oh l z', 4], ['TOMTOMS', 7, 't oh m', 3], ['TOMTOMS', 7, 't oh m z', 4], ['CANTONED', 8, 't oh n d', 4], ['ENTENTES', 8, 't oh n t s', 5], ['PUT-ONS', 7, 't oh n z', 4], ['TONGAS', 6, 't oh ng', 3], ['TONGS', 5, 't oh ng z', 4], ['TOPPED', 6, 't oh p t', 4], ['WINTOUR', 7, 't oh r', 3], ['TORCHED', 7, 't oh r ch t', 5], ['TOSS', 4, 't oh s', 3], ['TOSSED', 6, 't oh s t', 4], ['TOSH', 4, 't oh sh', 3], ['TOTS', 4, 't oh t s', 4], ['TOBE', 4, 't ow b', 3], ['WEB-TOED', 8, 't ow d', 3], ['TOADS', 5, 't ow d z', 4], ['TOQUE', 5, 't ow k', 3], ['TOQUES', 6, 't ow k s', 4], ['UNTOLLED', 8, 't ow l d', 4], ['TOLLS', 5, 't ow l z', 4], ['TOME', 4, 't ow m', 3], ['TOMES', 5, 't ow m z', 4], ['TOPE', 4, 't ow p', 3], ['TOPES', 5, 't ow p s', 4], ['TOPED', 5, 't ow p t', 4], ['TOASTS', 6, 't ow s t s', 5], ['TOTE', 4, 't ow t', 3], ['TOTES', 5, 't ow t s', 4], ['VIBRATOS', 8, 't ow z', 3], ['TOYSHOPS', 8, 't oy', 2], ['TOYED', 5, 't oy d', 3], ['DELTOIDS', 8, 't oy d z', 4], ['TOILED', 6, 't oy l d', 4], ['TOILS', 5, 't oy l z', 4], ['TOYS', 4, 't oy z', 3], ['TETRARCH', 8, 't r aa k', 4], ['TRANCING', 8, 't r aa n', 4], ['TRANCE', 6, 't r aa n s', 5], ['TRANCED', 7, 't r aa n s t', 6], ['TRAD', 4, 't r ae d', 4], ['TETRADS', 7, 't r ae d z', 5], ['TRACKS', 6, 't r ae k s', 5], ['TRACTS', 6, 't r ae k t s', 6], ['TRAMPS', 6, 't r ae m p s', 6], ['TRAMPED', 7, 't r ae m p t', 6], ['TRAMS', 5, 't r ae m z', 5], ['OUTRANK', 7, 't r ae ng k', 5], ['TRAPS', 5, 't r ae p s', 5], ['TRASH', 5, 't r ae sh', 4], ['TRAVNIK', 7, 't r ae v', 4], ['UNTRUSTY', 8, 't r ah', 3], ['TRUDGE', 6, 't r ah jh', 4], ['TRUDGED', 7, 't r ah jh d', 5], ['TRUCK', 5, 't r ah k', 4], ['TRUCKS', 6, 't r ah k s', 5], ['TRUCKED', 7, 't r ah k t', 5], ['TRUMP', 5, 't r ah m p', 5], ['TRUMPS', 6, 't r ah m p s', 6], ['OUTRUNS', 7, 't r ah n z', 5], ['TRUNKING', 8, 't r ah ng', 4], ['TRUSS', 5, 't r ah s', 4], ["TRUSTS'", 7, 't r ah s t s', 6], ['OUTRUSH', 7, 't r ah sh', 4], ['TRAWLING', 8, 't r ao', 3], ['TRAWLED', 7, 't r ao l d', 5], ['TRAWLS', 6, 't r ao l z', 5], ['TROWSERS', 8, 't r aw', 3], ['TROUNCE', 7, 't r aw n s', 5], ['TROUNCED', 8, 't r aw n s t', 6], ['TROUT', 5, 't r aw t', 4], ['TROUTS', 6, 't r aw t s', 5], ['VENTRAD', 7, 't r ax d', 4], ['VENTRAL', 7, 't r ax l', 4], ['VENTRALS', 8, 't r ax l z', 5], ['TANTRUM', 7, 't r ax m', 4], ['TANTRUMS', 8, 't r ax m z', 5], ['THEATRON', 8, 't r ax n', 4], ['UNTRANCE', 8, 't r ax n s', 5], ['CALTROP', 7, 't r ax p', 4], ['CALTROPS', 8, 't r ax p s', 5], ['NITROUS', 7, 't r ax s', 4], ['ULTRAS', 6, 't r ax z', 4], ['TRIBE', 5, 't r ay b', 4], ['OUTRIDES', 8, 't r ay d z', 5], ['TRIPE', 5, 't r ay p', 4], ['TRIPES', 6, 't r ay p s', 5], ['TRICE', 5, 't r ay s', 4], ['UNTRICED', 8, 't r ay s t', 5], ['TRYSTES', 7, 't r ay s t s', 6], ['UNTRITE', 7, 't r ay t', 4], ['TRITES', 6, 't r ay t s', 5], ['TRIES', 5, 't r ay z', 4], ['TREADS', 6, 't r eh d z', 5], ['TREK', 4, 't r eh k', 4], ['TREKS', 5, 't r eh k s', 5], ['UTRECHT', 7, 't r eh k t', 5], ['TRENCH', 6, 't r eh n ch', 5], ['UPTREND', 7, 't r eh n d', 5], ['UPTRENDS', 8, 't r eh n d z', 6], ['TRENT', 5, 't r eh n t', 5], ["TRENT'S", 7, 't r eh n t s', 6], ['TRESS', 5, 't r eh s', 4], ['TRESSED', 7, 't r eh s t', 5], ['OUTRAGE', 7, 't r ey jh', 4], ['OUTRAGED', 8, 't r ey jh d', 5], ['TRAIL', 5, 't r ey l', 4], ['TRAILS', 6, 't r ey l z', 5], ['UNTRAIN', 7, 't r ey n', 4], ['TRAINS', 6, 't r ey n z', 5], ['TRAPES', 6, 't r ey p s', 5], ['TRAIPSED', 8, 't r ey p s t', 6], ['TRACE', 5, 't r ey s', 4], ['TRACED', 6, 't r ey s t', 5], ['TRAIT', 5, 't r ey t', 4], ['TRAITS', 6, 't r ey t s', 5], ['TRAYS', 5, 't r ey z', 4], ['YTTRIA', 6, 't r ia', 3], ['VITRIOL', 7, 't r ia l', 4], ['VITRIOLS', 8, 't r ia l z', 5], ['YTTRIUM', 7, 't r ia m', 4], ['YTTRIUMS', 8, 't r ia m z', 5], ['NUTRIEN', 7, 't r ia n', 4], ['NUTRIENT', 8, 't r ia n t', 5], ['WINTRIER', 8, 't r ia r', 4], ['YTTRIOUS', 8, 't r ia s', 4], ['PATRIOT', 7, 't r ia t', 4], ['PATRIOTS', 8, 't r ia t s', 5], ['NUTRIAS', 7, 't r ia z', 4], ['ZEALOTRY', 8, 't r ih', 3], ['PETRICH', 7, 't r ih ch', 4], ['PUTRID', 6, 't r ih d', 4], ['HATREDS', 7, 't r ih d z', 5], ['UNTRIG', 6, 't r ih g', 4], ['PATRIDGE', 8, 't r ih jh', 4], ['VITRICS', 7, 't r ih k s', 5], ['TRICKED', 7, 't r ih k t', 5], ['UNTRILL', 7, 't r ih l', 4], ['TRILLED', 7, 't r ih l d', 5], ['TRILLS', 6, 't r ih l z', 5], ['UNTRIM', 6, 't r ih m', 4], ['TRIMS', 5, 't r ih m z', 5], ['VITRINES', 8, 't r ih n z', 5], ['TRINKLET', 8, 't r ih ng', 4], ['TRIPS', 5, 't r ih p s', 5], ['WAITRESS', 8, 't r ih s', 4], ['TRYSTS', 6, 't r ih s t s', 6], ['YEW-TREE', 8, 't r iy', 3], ['OUTREACH', 8, 't r iy ch', 4], ['TREED', 5, 't r iy d', 4], ['INTRIGUE', 8, 't r iy g', 4], ['LATRINE', 7, 't r iy n', 4], ['LATRINES', 8, 't r iy n z', 5], ['PATRICE', 7, 't r iy s', 4], ['TREATS', 6, 't r iy t s', 5], ['RETRIEVE', 8, 't r iy v', 4], ['TROUGH', 6, 't r oh f', 4], ['TROUGHS', 7, 't r oh f s', 5], ['BUNTROCK', 8, 't r oh k', 4], ['TROMPLE', 7, 't r oh m', 4], ['TROMPS', 6, 't r oh m p s', 6], ['TROMPED', 7, 't r oh m p t', 6], ['VECTRON', 7, 't r oh n', 4], ['BOUTROSS', 8, 't r oh s', 4], ['TROTS', 5, 't r oh t s', 5], ['OUTRODE', 7, 't r ow d', 4], ['BETROTH', 7, 't r ow dh', 4], ['BETROTHS', 8, 't r ow dh z', 5], ['CENTRODE', 8, 't r ow k', 4], ['TROLLS', 6, 't r ow l z', 5], ['ZOETROPE', 8, 't r ow p', 4], ['TROPES', 6, 't r ow p s', 5], ['TROCHE', 6, 't r ow sh', 4], ['TROTH', 5, 't r ow th', 4], ['TROTHS', 6, 't r ow th s', 5], ['TROTHED', 7, 't r ow th t', 5], ['TROVE', 5, 't r ow v', 4], ['TROVES', 6, 't r ow v z', 5], ["VITRO'S", 7, 't r ow z', 4], ['TROY', 4, 't r oy', 3], ['INTROIT', 7, 't r oy t', 4], ['INTROITS', 8, 't r oy t s', 5], ['TROYES', 6, 't r oy z', 4], ['TRURO', 5, 't r ua', 3], ['TRUED', 5, 't r uw d', 4], ['UNTRUTHS', 8, 't r uw dh z', 5], ['TROON', 5, 't r uw n', 4], ['TROUPE', 6, 't r uw p', 4], ['TROUPS', 6, 't r uw p s', 5], ['TROUPED', 7, 't r uw p t', 5], ['TRUCE', 5, 't r uw s', 4], ['TRUCED', 6, 't r uw s t', 5], ['BEETROOT', 8, 't r uw t', 4], ['UNTRUTH', 7, 't r uw th', 4], ['TRUES', 5, 't r uw z', 4], ['OCTROI', 6, 't r w aa', 4], ['OCTROIS', 7, 't r w aa z', 5], ['TOURED', 6, 't ua d', 3], ['TOURS', 5, 't ua r', 3], ["TOUR'S", 6, 't ua r z', 4], ['TOURS', 5, 't ua z', 3], ['UNTO', 4, 't uh', 2], ['TOOKES', 6, 't uh k s', 4], ['VIRTUED', 7, 't uw d', 3], ['TOOL', 4, 't uw l', 3], ['TOOLED', 6, 't uw l d', 4], ['TOOLS', 5, 't uw l z', 4], ['TOMBS', 5, 't uw m z', 4], ['SPONTOON', 8, 't uw n', 3], ['TOUCHE', 6, 't uw sh', 3], ['TOUT', 4, 't uw t', 3], ['TOOTS', 5, 't uw t s', 4], ['TOOTHS', 6, 't uw th s', 4], ['TOOTHED', 7, 't uw th t', 4], ['TWOS', 4, 't uw z', 3], ['TROTTOIR', 8, 't w aa', 3], ['TOILE', 5, 't w aa l', 4], ['TWANKY', 6, 't w ae ng', 4], ['TWANGED', 7, 't w ae ng d', 5], ['TWANGS', 6, 't w ae ng z', 5], ['OUTWALK', 7, 't w ao k', 4], ['OUTWALKS', 8, 't w ao k s', 5], ['OUTWORN', 7, 't w ao n', 4], ['OUTWORE', 7, 't w ao r', 4], ['OUTWARDS', 8, 't w ax d z', 5], ['UNTWINE', 7, 't w ay n', 4], ['UNTWINED', 8, 't w ay n d', 5], ['TWINES', 6, 't w ay n z', 5], ['TWICE', 5, 't w ay s', 4], ['SOFTWARE', 8, 't w ea', 3], ['SOFTWARE', 8, 't w ea r', 4], ['TWELVISH', 8, 't w eh l', 4], ['TWELVES', 7, 't w eh l v z', 6], ['OUTWENT', 7, 't w eh n t', 5], ['NATWEST', 7, 't w eh s t', 5], ['OUTWORK', 7, 't w er k', 4], ['TWIRL', 5, 't w er l', 4], ['TWIRLED', 7, 't w er l d', 5], ['TWIRLS', 6, 't w er l z', 5], ['CUTWORM', 7, 't w er m', 4], ['CUTWORMS', 8, 't w er m z', 5], ['TWIRP', 5, 't w er p', 4], ['TWIRPS', 6, 't w er p s', 5], ["'TWERE", 6, 't w er r', 4], ['TWAIN', 5, 't w ey n', 4], ['TWAINS', 6, 't w ey n z', 5], ['HEATWAVE', 8, 't w ey v', 4], ['TWITCH', 6, 't w ih ch', 4], ['TWIG', 4, 't w ih g', 4], ['TWIGGED', 7, 't w ih g d', 5], ['TWIGS', 5, 't w ih g z', 5], ['GATWICK', 7, 't w ih k', 4], ['TWIXT', 5, 't w ih k s t', 6], ['TWILL', 5, 't w ih l', 4], ['TWILLS', 6, 't w ih l z', 5], ['TWINTER', 7, 't w ih n', 4], ['TWINGE', 6, 't w ih n jh', 5], ['TWINS', 5, 't w ih n z', 5], ['TWINKLY', 7, 't w ih ng', 4], ['UNTWIST', 7, 't w ih s t', 5], ['UNTWISTS', 8, 't w ih s t s', 6], ['TWITTEN', 7, 't w ih t', 4], ['TWITS', 5, 't w ih t s', 5], ['TWEEZING', 8, 't w iy', 3], ['TWEED', 5, 't w iy d', 4], ['TWEEDS', 6, 't w iy d z', 5], ['TWEAK', 5, 't w iy k', 4], ['TWEAKS', 6, 't w iy k s', 5], ['TWEAKED', 7, 't w iy k t', 5], ['TWEEN', 5, 't w iy n', 4], ['TWEET', 5, 't w iy t', 4], ['TWEETS', 6, 't w iy t s', 5], ['TWAS', 4, 't w oh z', 4], ['CATWOMAN', 8, 't w uh', 3], ['TILTYARD', 8, 't y aa d', 4], ['ROENTGEN', 8, 't y ax n', 4], ['MANTUAN', 7, 't y ua n', 4], ['TUBESING', 8, 't y uw b', 4], ['TUBES', 5, 't y uw b z', 5], ['TULLE', 5, 't y uw l', 4], ['TULLES', 6, 't y uw l z', 5], ['TUNED', 5, 't y uw n d', 5], ['TUNES', 5, 't y uw n z', 5], ['OBTUSE', 6, 't y uw s', 4], ['TUESDAYS', 8, 't y uw z', 4], ['CONTUSED', 8, 't y uw z d', 5], ['OBTUSION', 8, 't y uw zh', 4], ["THANOS'S", 8, 'th aa', 2], ['LITHARGE', 8, 'th aa jh', 3], ['THATCHY', 7, 'th ae', 2], ['THATCH', 6, 'th ae ch', 3], ['THATCHED', 8, 'th ae ch t', 4], ['TANH', 4, 'th ae n', 3], ['THANKS', 6, 'th ae ng k s', 5], ['THURROCK', 8, 'th ah', 2], ['THUD', 4, 'th ah d', 3], ['THUDS', 5, 'th ah d z', 4], ['THUG', 4, 'th ah g', 3], ['THUGS', 5, 'th ah g z', 4], ['THUMBED', 7, 'th ah m d', 4], ['THUMP', 5, 'th ah m p', 4], ['THUMPS', 6, 'th ah m p s', 5], ['THUMPED', 7, 'th ah m p t', 5], ['THUMBS', 6, 'th ah m z', 4], ['THUNDERY', 8, 'th ah n', 3], ['THAWED', 6, 'th ao d', 3], ['THORNED', 7, 'th ao n d', 4], ['THORPE', 6, 'th ao p', 3], ['THORPS', 6, 'th ao p s', 4], ['THOUGHTS', 8, 'th ao t s', 4], ['THAWS', 5, 'th ao z', 3], ['METHOD', 6, 'th ax d', 3], ['METHODS', 7, 'th ax d z', 4], ['ZENITHAL', 8, 'th ax l', 3], ['ANTHEMED', 8, 'th ax m d', 4], ['NATHANS', 7, 'th ax n z', 4], ['PANTHER', 7, 'th ax r', 3], ['ETHERED', 7, 'th ax r d', 4], ['THIGHED', 7, 'th ay d', 3], ['ETHYL', 5, 'th ay l', 3], ["ETHYL'S", 7, 'th ay l z', 4], ['THIGHS', 6, 'th ay z', 3], ['THUMMIM', 7, 'th dh', 2], ['THEFT', 5, 'th eh f t', 4], ['THEFTS', 6, 'th eh f t s', 5], ['APOTHEGM', 8, 'th eh m', 3], ['SOUTHEND', 8, 'th eh n d', 4], ['THETFORD', 8, 'th eh t', 3], ['EPITHETS', 8, 'th eh t s', 4], ['THURSO', 6, 'th er', 2], ['THIRD', 5, 'th er d', 3], ['THIRDS', 6, 'th er d z', 4], ['THERMALS', 8, 'th er m', 3], ['THERMS', 6, 'th er m z', 4], ['THIRSK', 6, 'th er s k', 4], ['THIRST', 6, 'th er s t', 4], ['THIRSTS', 7, 'th er s t s', 5], ["THAYER'S", 8, 'th ey', 2], ['THANE', 5, 'th ey n', 3], ['THANES', 6, 'th ey n z', 4], ["CATHAY'S", 8, 'th ey z', 3], ['MOUTHFUL', 8, 'th f ah l', 4], ['PATHFIND', 8, 'th f ay n d', 5], ['PYTHIUM', 7, 'th ia m', 3], ['LITHIUMS', 8, 'th ia m z', 4], ['PYTHIAN', 7, 'th ia n', 3], ['WEALTHY', 7, 'th ih', 2], ['UNETHIC', 7, 'th ih k', 3], ['THICKS', 6, 'th ih k s', 4], ['THILL', 5, 'th ih l', 3], ['THILLS', 6, 'th ih l z', 4], ['THINNESS', 8, 'th ih n', 3], ['THINNED', 7, 'th ih n d', 4], ['THINS', 5, 'th ih n z', 4], ['WRATHING', 8, 'th ih ng', 3], ['UNTHINK', 7, 'th ih ng k', 4], ['THINKS', 6, 'th ih ng k s', 5], ["THINGS'", 7, 'th ih ng z', 4], ['TOOTHY', 6, 'th iy', 2], ['THIEF', 5, 'th iy f', 3], ['THIEFS', 6, 'th iy f s', 4], ['THEME', 5, 'th iy m', 3], ['THEMED', 6, 'th iy m d', 4], ['THEMES', 6, 'th iy m z', 4], ['RUTHENE', 7, 'th iy n', 3], ['ESTHETES', 8, 'th iy t s', 4], ['THIEVE', 6, 'th iy v', 3], ['THIEVED', 7, 'th iy v d', 4], ['THIEVES', 7, 'th iy v z', 4], ["KATHY'S", 7, 'th iy z', 3], ['LETHAL', 6, 'th l', 2], ['CATHOLIC', 8, 'th l ih k', 4], ['RUTHLESS', 8, 'th l ih s', 4], ['KATHLEEN', 8, 'th l iy n', 4], ['ATHLETES', 8, 'th l iy t s', 5], ['ATHLONE', 7, 'th l ow n', 4], ['LETHALS', 7, 'th l z', 3], ['MENTHOL', 7, 'th oh l', 3], ['MENTHOLS', 8, 'th oh l z', 4], ['THONG', 5, 'th oh ng', 3], ['THONGED', 7, 'th oh ng d', 4], ['THONGS', 6, 'th oh ng z', 4], ['THOR', 4, 'th oh r', 3], ['THORNTON', 8, 'th oh r n t', 5], ["THOR'S", 6, 'th oh r z', 4], ['PATHOS', 6, 'th oh s', 3], ['THOLER', 6, 'th ow', 2], ['CATHODE', 7, 'th ow d', 3], ['CATHODES', 8, 'th ow d z', 4], ['THOLED', 6, 'th ow l d', 4], ['THOLES', 6, 'th ow l z', 4], ['LITHOS', 6, 'th ow z', 3], ['THRALDOM', 8, 'th r aa l', 4], ['ANTHRAX', 7, 'th r ae k s', 5], ['THRASH', 6, 'th r ae sh', 4], ['THRASHED', 8, 'th r ae sh t', 5], ['THRUM', 5, 'th r ah m', 4], ['THRUMMED', 8, 'th r ah m d', 5], ['THRUMS', 6, 'th r ah m z', 5], ['UPTHRUST', 8, 'th r ah s t', 5], ['THRUSH', 6, 'th r ah sh', 4], ['UNTHRALL', 8, 'th r ao l', 4], ['THRALLS', 7, 'th r ao l z', 5], ['URETHRA', 7, 'th r ax', 3], ['URETHRAS', 8, 'th r ax z', 4], ['THRICE', 6, 'th r ay s', 4], ['THRIVE', 6, 'th r ay v', 4], ['THRIVED', 7, 'th r ay v d', 5], ['THRIVES', 7, 'th r ay v z', 5], ['UNTHREAD', 8, 'th r eh d', 4], ['THREADS', 7, 'th r eh d z', 5], ['THRESH', 6, 'th r eh sh', 4], ['THREATS', 7, 'th r eh t s', 5], ['THRACIAN', 8, 'th r ey', 3], ['THRIVEN', 7, 'th r ih', 3], ['UNTHRIFT', 8, 'th r ih f t', 5], ['THRILL', 6, 'th r ih l', 4], ['THRILLS', 7, 'th r ih l z', 5], ['KATHRYN', 7, 'th r ih n', 4], ['THREES', 6, 'th r iy z', 4], ['THROB', 5, 'th r oh b', 4], ['THROBBED', 8, 'th r oh b d', 5], ['THROBS', 6, 'th r oh b z', 5], ['THRONGED', 8, 'th r oh ng d', 5], ['THRONGS', 7, 'th r oh ng z', 5], ['NORTHROP', 8, 'th r oh p', 4], ['BATHROBE', 8, 'th r ow b', 4], ['THROWED', 7, 'th r ow d', 4], ['UNTHROWN', 8, 'th r ow n', 4], ['THRONES', 7, 'th r ow n z', 5], ['THROATS', 7, 'th r ow t s', 5], ['THROVE', 6, 'th r ow v', 4], ['THROWS', 6, 'th r ow z', 4], ['THRU', 4, 'th r uw', 3], ['BATHROOM', 8, 'th r uw m', 4], ['THROUGHS', 8, 'th r uw z', 4], ['BETHUNE', 7, 'th uw n', 3], ['THWACK', 6, 'th w ae k', 4], ['THWACKS', 7, 'th w ae k s', 5], ['THWACKED', 8, 'th w ae k t', 5], ['THWART', 6, 'th w ao t', 4], ['THWARTS', 7, 'th w ao t s', 5], ['ROTHWELL', 8, 'th w eh l', 4], ['PATHWAY', 7, 'th w ey', 3], ['THWAITE', 7, 'th w ey t', 4], ['THWAITES', 8, 'th w ey t s', 5], ['PATHWAYS', 8, 'th w ey z', 4], ['THEWS', 5, 'th y uw z', 4], ['URDU', 4, 'ua', 1], ["WELSH'S", 7, 'uh', 1], ['STEREOED', 8, 'uh d', 2], ['VARIOLE', 7, 'uh l', 2], ['AUREOLED', 8, 'uh l d', 3], ['ORIOLES', 7, 'uh l z', 3], ['UMLAUTS', 7, 'uh m', 2], ['OOMPH', 5, 'uh m f', 3], ['OOMPHS', 6, 'uh m f s', 4], ['CYPRIOTE', 8, 'uh t', 2], ['VIDEOS', 6, 'uh z', 2], ['UZI', 3, 'uw', 1], ['BAYOUD', 6, 'uw d', 2], ['OOF', 3, 'uw f', 2], ["PERU'S", 6, 'uw z', 2], ['OOZED', 5, 'uw z d', 3], ['VOYEURS', 7, 'v', 1], ['VIVACE', 6, 'v aa', 2], ['WAGNERS', 7, 'v aa g', 3], ['AARDVARK', 8, 'v aa k', 3], ['VALSES', 6, 'v aa l', 3], ['VALSE', 5, 'v aa l s', 4], ['YEREVAN', 7, 'v aa n', 3], ['SAMOVAR', 7, 'v aa r', 3], ['VASTNESS', 8, 'v aa s t', 4], ['VASE', 4, 'v aa z', 3], ['VACCINES', 8, 'v ae k', 3], ['VAX', 3, 'v ae k s', 4], ['VALVE', 5, 'v ae l v', 4], ['VALVED', 6, 'v ae l v d', 5], ['VALVES', 6, 'v ae l v z', 5], ['VAMPISH', 7, 'v ae m', 3], ['VAMP', 4, 'v ae m p', 4], ['VAMPS', 5, 'v ae m p s', 5], ['VAMPED', 6, 'v ae m p t', 5], ['VANCE', 5, 'v ae n s', 4], ['LEVANTS', 7, 'v ae n t s', 5], ['VANS', 4, 'v ae n z', 4], ['KVASS', 5, 'v ae s', 3], ['VIVAT', 5, 'v ae t', 3], ['VATS', 4, 'v ae t s', 4], ['VULVAS', 6, 'v ah l', 3], ['DIVULGE', 7, 'v ah l jh', 4], ['DIVULGED', 8, 'v ah l jh d', 5], ['CONVULSE', 8, 'v ah l s', 4], ['SULLIVAN', 8, 'v ah n', 3], ['RAVE-UP', 7, 'v ah p', 3], ['RAVE-UPS', 8, 'v ah p s', 4], ['JARVIS', 6, 'v ah s', 3], ['VORTICES', 8, 'v ao', 2], ['VAULT', 5, 'v ao l t', 4], ['VAULTS', 6, 'v ao l t s', 5], ['VAUNT', 5, 'v ao n t', 4], ['VAUNTS', 6, 'v ao n t s', 5], ['CAVORT', 6, 'v ao t', 3], ['CAVORTS', 7, 'v ao t s', 4], ['WALESAS', 7, 'v aw', 2], ['VOUCHED', 7, 'v aw ch t', 4], ['VOWED', 5, 'v aw d', 3], ['VOWS', 4, 'v aw z', 3], ['HAVOC', 5, 'v ax k', 3], ['HAVOCS', 6, 'v ax k s', 4], ['UPHEAVAL', 8, 'v ax l', 3], ['OVUM', 4, 'v ax m', 3], ['WOVEN', 5, 'v ax n', 3], ['SOLVENTS', 8, 'v ax n t s', 5], ['TAVERNS', 7, 'v ax n z', 4], ['WOLVER', 6, 'v ax r', 3], ['WAIVERED', 8, 'v ax r d', 4], ['PROVOST', 7, 'v ax s t', 4], ['PROVOSTS', 8, 'v ax s t s', 5], ['ULVERT', 6, 'v ax t', 3], ['PIVOTS', 6, 'v ax t s', 4], ['WOLVERS', 7, 'v ax z', 3], ['COVERSED', 8, 'v ax z d', 4], ['VYING', 5, 'v ay', 2], ['VIBES', 5, 'v ay b z', 4], ['VIED', 4, 'v ay d', 3], ['VILENESS', 8, 'v ay l', 3], ['REVILES', 7, 'v ay l z', 4], ['VINE', 4, 'v ay n', 3], ['VINES', 5, 'v ay n z', 4], ['VICE-', 5, 'v ay s', 3], ['UNINVITE', 8, 'v ay t', 3], ['SURVIVE', 7, 'v ay v', 3], ['SURVIVES', 8, 'v ay v z', 4], ['VIES', 4, 'v ay z', 3], ['WENDOVER', 8, 'v eh', 2], ['VETCH', 5, 'v eh ch', 3], ['VEXINGLY', 8, 'v eh k', 3], ['VEX', 3, 'v eh k s', 4], ['VEXED', 5, 'v eh k s t', 5], ['CONVECTS', 8, 'v eh k t s', 5], ['VELVETY', 7, 'v eh l', 3], ['VELDT', 5, 'v eh l t', 4], ['VELDTS', 6, 'v eh l t s', 5], ['VIVENDI', 7, 'v eh n', 3], ['VEND', 4, 'v eh n d', 4], ['VENDS', 5, 'v eh n d z', 5], ['VENGE', 5, 'v eh n jh', 4], ['VENGED', 6, 'v eh n jh d', 5], ['VENTNOR', 7, 'v eh n t', 4], ['VENTS', 5, 'v eh n t s', 5], ['WENDOVER', 8, 'v eh r', 3], ['VESTS', 5, 'v eh s t s', 5], ['VET', 3, 'v eh t', 3], ['VETS', 4, 'v eh t s', 4], ['VS.', 3, 'v er', 2], ['VERB', 4, 'v er b', 3], ['VERBS', 5, 'v er b z', 4], ['VERDANT', 7, 'v er d', 3], ['VERGE', 5, 'v er jh', 3], ['VERGED', 6, 'v er jh d', 4], ['WYVERN', 6, 'v er n', 3], ['WYVERNS', 7, 'v er n z', 4], ['VERSE', 5, 'v er s', 3], ['VERST', 5, 'v er s t', 4], ['SUBVERTS', 8, 'v er t s', 4], ['VERVE', 5, 'v er v', 3], ['VERVES', 6, 'v er v z', 4], ['PERVADES', 8, 'v ey d z', 4], ['VEIL', 4, 'v ey l', 3], ['VEILED', 6, 'v ey l d', 4], ['VEILS', 5, 'v ey l z', 4], ['VEINED', 6, 'v ey n d', 4], ['SURVEYS', 7, 'v ey z', 3], ['FIVEFOLD', 8, 'v f ow l d', 5], ['VEERED', 6, 'v ia d', 3], ['TRIVIAL', 7, 'v ia l', 3], ['TRIVIUM', 7, 'v ia m', 3], ['DEVIANTS', 8, 'v ia n t s', 5], ['WAVIER', 6, 'v ia r', 3], ['SOVIET', 6, 'v ia t', 3], ["SOVIETS'", 8, 'v ia t s', 4], ['SAVITCH', 7, 'v ih ch', 3], ['DAVIDS', 6, 'v ih d z', 4], ["LUDWIG'S", 8, 'v ih g z', 4], ['SELVEDGE', 8, 'v ih jh', 3], ['VIXENS', 6, 'v ih k', 3], ['YEOVIL', 6, 'v ih l', 3], ['WEEVILED', 8, 'v ih l d', 4], ['WEEVILS', 7, 'v ih l z', 4], ['VIM', 3, 'v ih m', 3], ['VINTRY', 6, 'v ih n', 3], ['SPAVINED', 8, 'v ih n d', 4], ['SCAVENGE', 8, 'v ih n jh', 4], ['VINCE', 5, 'v ih n s', 4], ['SPAVINS', 7, 'v ih n z', 4], ['WIVING', 6, 'v ih ng', 3], ['WEAVINGS', 8, 'v ih ng z', 4], ['VIS', 3, 'v ih s', 3], ['TAVIST', 6, 'v ih s t', 4], ['TWELVISH', 8, 'v ih sh', 3], ['VELVET', 6, 'v ih t', 3], ['VELVETS', 7, 'v ih t s', 4], ['VIV', 3, 'v ih v', 3], ['VIZ', 3, 'v ih z', 3], ['VISIONS', 7, 'v ih zh', 3], ['WIESER', 6, 'v iy', 2], ['VIEDMA', 6, 'v iy d', 3], ['VEAL', 4, 'v iy l', 3], ['REVEALS', 7, 'v iy l z', 4], ['VIVE', 4, 'v iy v', 3], ['AVIVES', 6, 'v iy v z', 4], ["V.'S", 4, 'v iy z', 3], ['LOVELORN', 8, 'v l ao n', 4], ['LOVELAND', 8, 'v l ax n d', 5], ['LOVELIER', 8, 'v l ia r', 4], ['VOTIVELY', 8, 'v l ih', 3], ['RAVELIN', 7, 'v l ih n', 4], ['JAVELINS', 8, 'v l ih n z', 5], ['LEVELEST', 8, 'v l ih s t', 5], ['WAVELET', 7, 'v l ih t', 4], ['WAVELETS', 8, 'v l ih t s', 5], ["LIVELY'S", 8, 'v l ih z', 4], ['REVLON', 6, 'v l oh n', 4], ["REVLON'S", 8, 'v l oh n z', 5], ['LIVELONG', 8, 'v l oh ng', 4], ['DEVILRY', 7, 'v l r ih', 4], ['SEVENISH', 8, 'v ng', 2], ['VOMITUS', 7, 'v oh', 2], ['VODKAS', 6, 'v oh d', 3], ['LVOV', 4, 'v oh f', 3], ["LVOV'S", 6, 'v oh f s', 4], ['VOX', 3, 'v oh k s', 4], ['VOLTES', 6, 'v oh l', 3], ['REVOLVES', 8, 'v oh l v z', 5], ['VOLS', 4, 'v oh l z', 4], ['YVONNE', 6, 'v oh n', 3], ['DAVOS', 5, 'v oh s', 3], ['GAVOTTE', 7, 'v oh t', 3], ['GAVOTTES', 8, 'v oh t s', 4], ['ZEMSTVO', 7, 'v ow', 2], ['SALVOED', 7, 'v ow d', 3], ['VOGUE', 5, 'v ow g', 3], ['VOGUES', 6, 'v ow g z', 4], ['REVOKES', 7, 'v ow k s', 4], ['VOLTS', 5, 'v ow l t s', 5], ['VOTE', 4, 'v ow t', 3], ['VOTES', 5, 'v ow t s', 4], ['ZEMSTVOS', 8, 'v ow z', 3], ['VOID', 4, 'v oy d', 3], ['VOIDS', 5, 'v oy d z', 4], ['VOILE', 5, 'v oy l', 3], ['VOILES', 6, 'v oy l z', 4], ['VOICE', 5, 'v oy s', 3], ['VOICED', 6, 'v oy s t', 4], ['WOJCIECH', 8, 'v oy y', 3], ['SAVOYS', 6, 'v oy z', 3], ['VIVRE', 5, 'v r ax', 3], ['SEVERALS', 8, 'v r ax l z', 5], ['SOVRANTY', 8, 'v r ax n', 4], ['SOVRANS', 7, 'v r ax n z', 5], ['BOVRIL', 6, 'v r ih l', 4], ['EVESHAM', 7, 'v sh ax m', 4], ['BRAVURAS', 8, 'v ua', 2], ['VOODOOS', 7, 'v uw', 2], ['PLUVIOUS', 8, 'v y ax s', 4], ['VIEWPORT', 8, 'v y uw', 3], ['VIEWED', 6, 'v y uw d', 4], ['OVULE', 5, 'v y uw l', 4], ['OVULES', 6, 'v y uw l z', 5], ['VIEWS', 5, 'v y uw z', 4], ["REEVES'S", 8, 'v z ih z', 4], ['VOYEURS', 7, 'w aa', 2], ['NAWAB', 5, 'w aa b', 3], ['TAIWAN', 6, 'w aa n', 3], ["TAIWAN'S", 8, 'w aa n z', 4], ['REVOIR', 6, 'w aa r', 3], ['WAGTAILS', 8, 'w ae g', 3], ['WAGGED', 6, 'w ae g d', 4], ['WAGS', 4, 'w ae g z', 4], ['WHACK', 5, 'w ae k', 3], ['WHACKS', 6, 'w ae k s', 4], ['WAXED', 5, 'w ae k s t', 5], ['WHACKED', 7, 'w ae k t', 4], ['WHANGING', 8, 'w ae ng', 3], ['WHANGED', 7, 'w ae ng d', 4], ['WANK', 4, 'w ae ng k', 4], ['WANKS', 5, 'w ae ng k s', 5], ['WANKED', 6, 'w ae ng k t', 5], ['WHANGS', 6, 'w ae ng z', 4], ['ONCE', 4, 'w ah n s', 4], ["SHUWA'S", 7, 'w ah z', 3], ['WORE', 4, 'w ao', 2], ['WARDS', 5, 'w ao d z', 4], ['WHARF', 5, 'w ao f', 3], ['WHARFS', 6, 'w ao f s', 4], ['WHARFED', 7, 'w ao f t', 4], ['WALK', 4, 'w ao k', 3], ['WALKS', 5, 'w ao k s', 4], ['WALKED', 6, 'w ao k t', 4], ['WAUL', 4, 'w ao l', 3], ['WALLED', 6, 'w ao l d', 4], ['WALTZ', 5, 'w ao l s', 4], ['WALTZED', 7, 'w ao l s t', 5], ['WALLS', 5, 'w ao l z', 4], ['WARMNESS', 8, 'w ao m', 3], ['WARMED', 6, 'w ao m d', 4], ['WARMTH', 6, 'w ao m th', 4], ['WARMTHS', 7, 'w ao m th s', 5], ['WARMS', 5, 'w ao m z', 4], ['WORN', 4, 'w ao n', 3], ['WARNED', 6, 'w ao n d', 4], ['WARNS', 5, 'w ao n z', 4], ['WONG', 4, 'w ao ng', 3], ["WONG'S", 6, 'w ao ng z', 4], ['WARP', 4, 'w ao p', 3], ['WARPS', 5, 'w ao p s', 4], ['WARPED', 6, 'w ao p t', 4], ['WORE', 4, 'w ao r', 3], ['WAUGHT', 6, 'w ao t', 3], ['WARTS', 5, 'w ao t s', 4], ['WHARVES', 7, 'w ao v z', 4], ['WARS', 4, 'w ao z', 3], ['WOWING', 6, 'w aw', 2], ['POWWOWED', 8, 'w aw d', 3], ['WOUND', 5, 'w aw n d', 4], ['WOWS', 4, 'w aw z', 3], ['NARWHAL', 7, 'w ax l', 3], ['NARWHALS', 8, 'w ax l z', 4], ['TAMWORTH', 8, 'w ax th', 3], ['OTTAWAS', 7, 'w ax z', 3], ["WIDE'S", 6, 'w ay d z', 4], ['WIFE', 4, 'w ay f', 3], ["WIFE'S", 6, 'w ay f s', 4], ["WILES'S", 7, 'w ay l', 3], ['WILDNESS', 8, 'w ay l d', 4], ['WILDES', 6, 'w ay l d z', 5], ['WHILST', 6, 'w ay l s t', 5], ['WILES', 5, 'w ay l z', 4], ['WINED', 5, 'w ay n d', 4], ['WINDS', 5, 'w ay n d z', 5], ['WINES', 5, 'w ay n z', 4], ['WIPE', 4, 'w ay p', 3], ['WIPES', 5, 'w ay p s', 4], ['WIPED', 5, 'w ay p t', 4], ['WIGHT', 5, 'w ay t', 3], ['WIGHTS', 6, 'w ay t s', 4], ['WIVE', 4, 'w ay v', 3], ['WIVED', 5, 'w ay v d', 4], ['WIVES', 5, 'w ay v z', 4], ["Y'S", 3, 'w ay z', 3], ['WHERED', 6, 'w ea d', 3], ['WHERE', 5, 'w ea r', 3], ['WHERED', 6, 'w ea r d', 4], ['WHERES', 6, 'w ea r z', 4], ['WHERES', 6, 'w ea z', 3], ['WHETTING', 8, 'w eh', 2], ['WEBSTERS', 8, 'w eh b', 3], ['WEBBED', 6, 'w eh b d', 4], ['WEBS', 4, 'w eh b z', 4], ['WEDD', 4, 'w eh d', 3], ['WEDS', 4, 'w eh d z', 4], ['WEFTED', 6, 'w eh f', 3], ['WEFT', 4, 'w eh f t', 4], ['WEFTS', 5, 'w eh f t s', 5], ['WEDGE', 5, 'w eh jh', 3], ['WEDGED', 6, 'w eh jh d', 4], ["WEXNER'S", 8, 'w eh k', 3], ['WEXFORD', 7, 'w eh k s', 4], ['WHELPING', 8, 'w eh l', 3], ['WELCH', 5, 'w eh l ch', 4], ['WELCHED', 7, 'w eh l ch t', 5], ['WELLED', 6, 'w eh l d', 4], ['WELDS', 5, 'w eh l d z', 5], ['WHELK', 5, 'w eh l k', 4], ['WHELKS', 6, 'w eh l k s', 5], ['WHELKED', 7, 'w eh l k t', 5], ['WHELM', 5, 'w eh l m', 4], ['WHELMED', 7, 'w eh l m d', 5], ['WHELMS', 6, 'w eh l m z', 5], ['WHELP', 5, 'w eh l p', 4], ['WHELPS', 6, 'w eh l p s', 5], ['WHELPED', 7, 'w eh l p t', 5], ['WELSHED', 7, 'w eh l sh t', 5], ['WELT', 4, 'w eh l t', 4], ['WELTS', 5, 'w eh l t s', 5], ['WEALTH', 6, 'w eh l th', 4], ['WEALTHS', 7, 'w eh l th s', 5], ['WELLS', 5, 'w eh l z', 4], ['WENCH', 5, 'w eh n ch', 4], ['WENCHED', 7, 'w eh n ch t', 5], ['WEND', 4, 'w eh n d', 4], ['WENDS', 5, 'w eh n d z', 5], ['WENT', 4, 'w eh n t', 4], ['WHENS', 5, 'w eh n z', 4], ['WEPT', 4, 'w eh p t', 4], ["WEST'S", 6, 'w eh s t s', 5], ['WHETS', 5, 'w eh t s', 4], ['WORTHY', 6, 'w er', 2], ['WORDS', 5, 'w er d z', 4], ["WORKS'", 6, 'w er k s', 4], ['WORKED', 6, 'w er k t', 4], ['WORLD', 5, 'w er l d', 4], ['WORLDS', 6, 'w er l d z', 5], ["WORL'S", 6, 'w er l z', 4], ['WORMED', 6, 'w er m d', 4], ["WORMS'", 6, 'w er m z', 4], ["WEREN'T", 7, 'w er n t', 4], ['WHIRR', 5, 'w er r', 3], ['WORSE', 5, 'w er s', 3], ['WORST', 5, 'w er s t', 4], ['WORSTS', 6, 'w er s t s', 5], ['WORT', 4, 'w er t', 3], ['WORTH', 5, 'w er th', 3], ['WORTHS', 6, 'w er th s', 4], ['WORTHED', 7, 'w er th t', 4], ['WHIRS', 5, 'w er z', 3], ['WHEY', 4, 'w ey', 2], ['WEIGHED', 7, 'w ey d', 3], ['WADES', 5, 'w ey d z', 4], ['WAIF', 4, 'w ey f', 3], ['WAIFS', 5, 'w ey f s', 4], ['WAGED', 5, 'w ey jh d', 4], ['WAKES', 5, 'w ey k s', 4], ['WAKED', 5, 'w ey k t', 4], ['REAWAKES', 8, 'w ey k z', 4], ['WHALED', 6, 'w ey l d', 4], ['WHALES', 6, 'w ey l z', 4], ['WAYNE', 5, 'w ey n', 3], ['WANED', 5, 'w ey n d', 4], ["WAYNE'S", 7, 'w ey n z', 4], ['ANYWHERE', 8, 'w ey r', 3], ['WASTES', 6, 'w ey s t s', 5], ['WT.', 3, 'w ey t', 3], ['WAVE', 4, 'w ey v', 3], ['WAVED', 5, 'w ey v d', 4], ['WAVES', 5, 'w ey v z', 4], ['WEIGHS', 6, 'w ey z', 3], ['WIER', 4, 'w ia', 2], ['WEIRED', 6, 'w ia d', 3], ['WEIRDS', 6, 'w ia d z', 4], ['WIER', 4, 'w ia r', 3], ['WEIRED', 6, 'w ia r d', 4], ["WEIR'S", 6, 'w ia r z', 4], ['WIERS', 5, 'w ia z', 3], ['ZIMBABWE', 8, 'w ih', 2], ['WYCH-', 5, 'w ih ch', 3], ['WITCHED', 7, 'w ih ch t', 4], ['WIDNES', 6, 'w ih d', 3], ['WITHED', 6, 'w ih dh d', 4], ['WHIFF', 5, 'w ih f', 3], ['WHIFFS', 6, 'w ih f s', 4], ['WHIFFED', 7, 'w ih f t', 4], ['WIGTAIL', 7, 'w ih g', 3], ['WIGGED', 6, 'w ih g d', 4], ["WIGTON'S", 8, 'w ih g t', 4], ['WIGS', 4, 'w ih g z', 4], ['WYK', 3, 'w ih k', 3], ['WICKS', 5, 'w ih k s', 4], ['WILLED', 6, 'w ih l d', 4], ['WILF', 4, 'w ih l f', 4], ["WILKES'S", 8, 'w ih l k', 4], ['WILKES', 6, 'w ih l k s', 5], ['WILMSLOW', 8, 'w ih l m', 4], ['WILMES', 6, 'w ih l m z', 5], ['WILT', 4, 'w ih l t', 4], ['WILTS', 5, 'w ih l t s', 5], ['WILLS', 5, 'w ih l z', 4], ['WIMPLING', 8, 'w ih m', 3], ['WIMP', 4, 'w ih m p', 4], ['WIMPS', 5, 'w ih m p s', 5], ['WIMPED', 6, 'w ih m p t', 5], ['WHIMS', 5, 'w ih m z', 4], ['WYNN', 4, 'w ih n', 3], ['WINCH', 5, 'w ih n ch', 4], ['WINCHED', 7, 'w ih n ch t', 5], ['WINNED', 6, 'w ih n d', 4], ['WINDS', 5, 'w ih n d z', 5], ['WINCE', 5, 'w ih n s', 4], ['WINCED', 6, 'w ih n s t', 5], ["WYNN'S", 6, 'w ih n z', 4], ['WINKLING', 8, 'w ih ng', 3], ['WINGED', 6, 'w ih ng d', 4], ['WINK', 4, 'w ih ng k', 4], ['WINKS', 5, 'w ih ng k s', 5], ['WINKED', 6, 'w ih ng k t', 5], ['WINGS', 5, 'w ih ng z', 4], ['WHIPS', 5, 'w ih p s', 4], ['WHIPPED', 7, 'w ih p t', 4], ['WYSS', 4, 'w ih s', 3], ['WHISK', 5, 'w ih s k', 4], ['WHISKS', 6, 'w ih s k s', 5], ['WHISKED', 7, 'w ih s k t', 5], ['WISP', 4, 'w ih s p', 4], ['WISPS', 5, 'w ih s p s', 5], ['WISPED', 6, 'w ih s p t', 5], ['WHISTS', 6, 'w ih s t s', 5], ['WISHED', 6, 'w ih sh t', 4], ['WITTEN', 6, 'w ih t', 3], ['WITS', 4, 'w ih t s', 4], ['WIDTH', 5, 'w ih t th', 4], ['WIDTHS', 6, 'w ih t th s', 5], ['WITHE', 5, 'w ih th', 3], ['WITHES', 6, 'w ih th s', 4], ['WITHED', 6, 'w ih th t', 4], ['WHIZZED', 7, 'w ih z d', 4], ['WEEWEED', 7, 'w iy d', 3], ['WEEDS', 5, 'w iy d z', 4], ['WK.', 3, 'w iy k', 3], ["WEEKS'", 6, 'w iy k s', 4], ['WEEKED', 6, 'w iy k t', 4], ['WIELDING', 8, 'w iy l', 3], ['WIELD', 5, 'w iy l d', 4], ['WIELDS', 6, 'w iy l d z', 5], ['WHEELS', 6, 'w iy l z', 4], ['WEEN', 4, 'w iy n', 3], ['WEENED', 6, 'w iy n d', 4], ['WEANS', 5, 'w iy n z', 4], ['WEEP', 4, 'w iy p', 3], ['WEEPS', 5, 'w iy p s', 4], ['WEEPED', 6, 'w iy p t', 4], ['WHEATEN', 7, 'w iy t', 3], ['WHEATS', 6, 'w iy t s', 4], ['WEAVE', 5, 'w iy v', 3], ['WEAVED', 6, 'w iy v d', 4], ['WEAVES', 6, 'w iy v z', 4], ['WHEEZE', 6, 'w iy z', 3], ['WHEEZED', 7, 'w iy z d', 4], ['WOTCHER', 7, 'w oh', 2], ['WATCHED', 7, 'w oh ch t', 4], ['WAD', 3, 'w oh d', 3], ['WADS', 4, 'w oh d z', 4], ['WAFTING', 7, 'w oh f', 3], ['WAFT', 4, 'w oh f t', 4], ['WAFTS', 5, 'w oh f t s', 5], ['GOLLIWOG', 8, 'w oh g', 3], ['WALDON', 6, 'w oh l d', 4], ['WALSH', 5, 'w oh l sh', 4], ['WALTONS', 7, 'w oh l t', 4], ["WALT'S", 6, 'w oh l t s', 5], ['WANTONS', 7, 'w oh n', 3], ['WAND', 4, 'w oh n d', 4], ['WANDS', 5, 'w oh n d z', 5], ['WANT', 4, 'w oh n t', 4], ['WANTS', 5, 'w oh n t s', 5], ['WONKY', 5, 'w oh ng', 3], ['WHOP', 4, 'w oh p', 3], ['WHOPS', 5, 'w oh p s', 4], ['WHOPPED', 7, 'w oh p t', 4], ['WASPS', 5, 'w oh s p s', 5], ['WAST', 4, 'w oh s t', 4], ['WASHTUBS', 8, 'w oh sh', 3], ['WASHED', 6, 'w oh sh t', 4], ['WOT', 3, 'w oh t', 3], ['WHATS', 5, 'w oh t s', 4], ["WASN'T", 6, 'w oh z', 3], ['WOVEN', 5, 'w ow', 2], ['WOAD', 4, 'w ow d', 3], ['WOKE', 4, 'w ow k', 3], ['WOLTERS', 7, 'w ow l', 3], ['WOLD', 4, 'w ow l d', 4], ['WOULDS', 6, 'w ow l d s', 5], ['WOULDS', 6, 'w ow l d z', 5], ['WONTING', 7, 'w ow n', 3], ['WONT', 4, 'w ow n t', 4], ['WOVE', 4, 'w ow v', 3], ['WOES', 4, 'w ow z', 3], ['WUSIH', 5, 'w uh', 2], ["WOULDN'T", 8, 'w uh d', 3], ['WOULDST', 7, 'w uh d s t', 5], ['WOOLED', 6, 'w uh l d', 4], ['WOLFS', 5, 'w uh l f s', 5], ['WOLFED', 6, 'w uh l f t', 5], ['WOLVES', 6, 'w uh l v z', 5], ['WOOLS', 5, 'w uh l z', 4], ['WU', 2, 'w uw', 2], ['WOOED', 5, 'w uw d', 3], ['WOOF', 4, 'w uw f', 3], ['WOOFS', 5, 'w uw f s', 4], ['WOOFED', 6, 'w uw f t', 4], ['WOMB', 4, 'w uw m', 3], ['WOMBED', 6, 'w uw m d', 4], ['WOMBS', 5, 'w uw m z', 4], ['WOUND', 5, 'w uw n d', 4], ['WOUNDS', 6, 'w uw n d z', 5], ['WOOS', 4, 'w uw z', 3], ['YARNING', 7, 'y aa', 2], ['YARDS', 5, 'y aa d z', 4], ['RIYALS', 6, 'y aa l z', 4], ['YOM', 3, 'y aa m', 3], ['YARN', 4, 'y aa n', 3], ['YARNED', 6, 'y aa n d', 4], ['YARNS', 5, 'y aa n z', 4], ['LOYANG', 6, 'y aa ng', 3], ['YATAGHAN', 8, 'y ae', 2], ['YAK', 3, 'y ae k', 3], ['YAKS', 4, 'y ae k s', 4], ['YAM', 3, 'y ae m', 3], ['YAMS', 4, 'y ae m z', 4], ['YANKING', 7, 'y ae ng', 3], ['YANK', 4, 'y ae ng k', 4], ["YANKS'", 6, 'y ae ng k s', 5], ['YANKED', 6, 'y ae ng k t', 5], ["YANG'S", 6, 'y ae ng z', 4], ['YAP', 3, 'y ae p', 3], ['YAPS', 4, 'y ae p s', 4], ['YAPPED', 6, 'y ae p t', 4], ['YUPPIES', 7, 'y ah', 2], ['YOUNKINS', 8, 'y ah ng', 3], ['YOUNGS', 6, 'y ah ng z', 4], ['YAWED', 5, 'y ao d', 3], ["YORK'S", 6, 'y ao k s', 4], ['YAWL', 4, 'y ao l', 3], ['YAWLED', 6, 'y ao l d', 4], ['YAWLS', 5, 'y ao l z', 4], ['YAWN', 4, 'y ao n', 3], ['YAWNED', 6, 'y ao n d', 4], ['YAWNS', 5, 'y ao n z', 4], ['YOUR', 4, 'y ao r', 3], ["YOUR'S", 6, 'y ao r z', 4], ['YOURS', 5, 'y ao z', 3], ['YOWLING', 7, 'y aw', 2], ['YOWL', 4, 'y aw l', 3], ['YOWLED', 6, 'y aw l d', 4], ['YOWLS', 5, 'y aw l z', 4], ['LAWYERED', 8, 'y ax d', 3], ['HUMIAN', 6, 'y ax n', 3], ['SAWYER', 6, 'y ax r', 3], ['LAWYERED', 8, 'y ax r d', 4], ["SAWYER'S", 8, 'y ax r z', 4], ['YEAH', 4, 'y ea', 2], ['YETIS', 5, 'y eh', 2], ['A._T._F.', 8, 'y eh f', 3], ['YELPING', 7, 'y eh l', 3], ['YELLED', 6, 'y eh l d', 4], ['YELK', 4, 'y eh l k', 4], ['YELP', 4, 'y eh l p', 4], ['YELPS', 5, 'y eh l p s', 5], ['YELPED', 6, 'y eh l p t', 5], ['YELTSINS', 8, 'y eh l t', 4], ['YELLS', 5, 'y eh l z', 4], ['YEN', 3, 'y eh n', 3], ['YENNED', 6, 'y eh n d', 4], ['YENS', 4, 'y eh n z', 4], ['YES', 3, 'y eh s', 3], ['OYEZ', 4, 'y eh z', 3], ['YEARN', 5, 'y er n', 3], ['YEARNED', 7, 'y er n d', 4], ['YEARNS', 6, 'y er n z', 4], ['YEA', 3, 'y ey', 2], ['GCHQ', 4, 'y ey ch', 3], ['YALE', 4, 'y ey l', 3], ["YALE'S", 6, 'y ey l z', 4], ["YATES'S", 7, 'y ey t', 3], ["YATES'", 6, 'y ey t s', 4], ['YEAS', 4, 'y ey z', 3], ['YR.', 3, 'y ia', 2], ['YR.', 3, 'y ia r', 3], ['YIPPING', 7, 'y ih', 2], ['YITZHAK', 7, 'y ih t', 3], ['YEE', 3, 'y iy', 2], ['YIELDING', 8, 'y iy l', 3], ['YIELD', 5, 'y iy l d', 4], ['YIELDS', 6, 'y iy l d z', 5], ['YEANLING', 8, 'y iy n', 3], ['YEAST', 5, 'y iy s t', 4], ['YEASTS', 6, 'y iy s t s', 5], ['YOB', 3, 'y oh b', 3], ['YOBS', 4, 'y oh b z', 4], ['YOD', 3, 'y oh d', 3], ['YONDER', 6, 'y oh n', 3], ['BEYOND', 6, 'y oh n d', 4], ['BEYONDS', 7, 'y oh n d z', 5], ['YACHTS', 6, 'y oh t s', 4], ['YOTIZE', 6, 'y ow', 2], ['YOG', 3, 'y ow g', 3], ['YOLK', 4, 'y ow k', 3], ['YOLKS', 5, 'y ow k s', 4], ['YOLKED', 6, 'y ow k t', 4], ['YO-YOS', 6, 'y ow z', 3], ['YOICK', 5, 'y oy k', 3], ['YOICKS', 6, 'y oy k s', 4], ['YURI', 4, 'y ua', 2], ['IMMURED', 7, 'y ua d', 3], ["YOU'RE", 6, 'y ua r', 3], ['IMMURES', 7, 'y ua z', 3], ['COMMUNAL', 8, 'y uh n', 3], ['JUNKERS', 7, 'y uh ng', 3], ["JUNG'S", 6, 'y uh ng z', 4], ['YULERY', 6, 'y uw', 2], ["YOU'D", 5, 'y uw d', 3], ['BERMUDES', 8, 'y uw d z', 4], ['YOUTHS', 6, 'y uw dh z', 4], ['MEWLED', 6, 'y uw l d', 4], ['MULES', 5, 'y uw l z', 4], ['TRIUNE', 6, 'y uw n', 3], ['COMMUNED', 8, 'y uw n d', 4], ['TRIUNES', 7, 'y uw n z', 4], ['UPSILONS', 8, 'y uw p', 3], ['USED', 4, 'y uw s t', 4], ['YOUTH', 5, 'y uw th', 3], ['YOUTHES', 7, 'y uw th s', 4], ["YOU'VE", 6, 'y uw v', 3], ['YEWS', 4, 'y uw z', 3], ['USED', 4, 'y uw z d', 4], ['SDEATH', 6, 'z', 1], ['ZAIRES', 6, 'z aa', 2], ['HUZZAED', 7, 'z aa d', 3], ['COSAQUE', 7, 'z aa k', 3], ['KURSAAL', 7, 'z aa l', 3], ['TZAR', 4, 'z aa r', 3], ["TSAR'S", 6, 'z aa r z', 4], ['TZARS', 5, 'z aa z', 3], ['ZIGZAG', 6, 'z ae g', 3], ['ZIGZAGS', 7, 'z ae g z', 4], ['YITZHAK', 7, 'z ae k', 3], ['ZACKS', 5, 'z ae k s', 4], ['ZAMBIANS', 8, 'z ae m', 3], ['EXAMS', 5, 'z ae m z', 4], ['TISANE', 6, 'z ae n', 3], ['PENZANCE', 8, 'z ae n s', 4], ['TISANES', 7, 'z ae n z', 4], ['ZAP', 3, 'z ae p', 3], ['ZAPS', 4, 'z ae p s', 4], ['ZAPPED', 6, 'z ae p t', 4], ['ERSATZES', 8, 'z ae t', 3], ['ERSATZ', 6, 'z ae t s', 4], ['PIZAZZ', 6, 'z ae z', 3], ['RESULT', 6, 'z ah l t', 4], ['RESULTS', 7, 'z ah l t s', 5], ['GAZUMPS', 7, 'z ah m p s', 5], ['GAZUMPED', 8, 'z ah m p t', 5], ["GINZA'S", 7, 'z ah z', 3], ['EXALT', 5, 'z ao l t', 4], ['EXALTS', 6, 'z ao l t s', 5], ['POSAUNE', 7, 'z ao n', 3], ['EXHAUSTS', 8, 'z ao s t s', 5], ['RESORT', 6, 'z ao t', 3], ["RESORTS'", 8, 'z ao t s', 4], ['DEVISORS', 8, 'z ao z', 3], ['RESOUND', 7, 'z aw n d', 4], ['RESOUNDS', 8, 'z aw n d z', 5], ['ZAREBA', 6, 'z ax', 2], ['WIZARD', 6, 'z ax d', 3], ['WIZARDS', 7, 'z ax d z', 4], ["ISAACS'S", 8, 'z ax k', 3], ['ISAACS', 6, 'z ax k s', 4], ['EXPOSALS', 8, 'z ax l z', 4], ['WEASAND', 7, 'z ax n d', 4], ['WEASANDS', 8, 'z ax n d z', 5], ['USANCE', 6, 'z ax n s', 4], ['REASONS', 7, 'z ax n z', 4], ['VISORED', 7, 'z ax r d', 4], ["LAZARD'S", 8, 'z ax r d z', 5], ["WISER'S", 7, 'z ax r z', 4], ['KANSAS', 6, 'z ax s', 3], ['DESERT', 6, 'z ax t', 3], ['DESERTS', 7, 'z ax t s', 4], ['RESIDE', 6, 'z ay d', 3], ['RESIDES', 7, 'z ay d z', 4], ['ENZYME', 6, 'z ay m', 3], ['ENZYMES', 7, 'z ay m z', 4], ['UNDESIGN', 8, 'z ay n', 3], ['RESIGNS', 7, 'z ay n z', 4], ['ROSARIUM', 8, 'z ea', 2], ['ZESTING', 7, 'z eh', 2], ['ZED', 3, 'z eh d', 3], ["Z.'S", 4, 'z eh d z', 4], ['ZELNICK', 7, 'z eh l', 3], ["ZELL'S", 6, 'z eh l z', 4], ['EXEMPT', 6, 'z eh m p t', 5], ['EXEMPTS', 7, 'z eh m p t s', 6], ['ZEMSTVOS', 8, 'z eh m s t', 5], ['ZENDIC', 6, 'z eh n', 3], ['WALLSEND', 8, 'z eh n d', 4], ['RESENDS', 7, 'z eh n d z', 5], ['RESENTS', 7, 'z eh n t s', 5], ['ROSETTE', 7, 'z eh t', 3], ['ROSETTES', 8, 'z eh t s', 4], ['CASERN', 6, 'z er n', 3], ['USURP', 5, 'z er p', 3], ['USURPS', 6, 'z er p s', 4], ['USURPED', 7, 'z er p t', 4], ['POSEUR', 6, 'z er r', 3], ['UNDESERT', 8, 'z er t', 3], ['RESERVES', 8, 'z er v z', 4], ['SELZERS', 7, 'z er z', 3], ["ZAYRE'S", 7, 'z ey', 2], ['LUCOZADE', 8, 'z ey d', 3], ['JEZAIL', 6, 'z ey l', 3], ['ZAYRE', 5, 'z ey r', 3], ['ZAYRES', 6, 'z ey r z', 4], ['ROSACE', 6, 'z ey s', 3], ["JOSE'S", 6, 'z ey z', 3], ['WINSFORD', 8, 'z f ax d', 4], ['GEMSHORN', 8, 'z hh ao n', 4], ['ZEROS', 5, 'z ia', 2], ['OSIERED', 7, 'z ia d', 3], ['TUNISIAN', 8, 'z ia n', 3], ['WHEEZIER', 8, 'z ia r', 3], ['OSIERED', 7, 'z ia r d', 4], ["ROSIER'S", 8, 'z ia r z', 4], ['ROSEATE', 7, 'z ia t', 3], ['VIZIERS', 7, 'z ia z', 3], ['ZITHERS', 7, 'z ih', 2], ['ROSIED', 6, 'z ih d', 3], ['JOSEPH', 6, 'z ih f', 3], ['JOSEPHS', 7, 'z ih f s', 4], ['ZIGZAGS', 7, 'z ih g', 3], ['VISAGE', 6, 'z ih jh', 3], ['VISAGED', 7, 'z ih jh d', 4], ['FUSIL', 5, 'z ih l', 3], ['FUSILS', 6, 'z ih l z', 4], ['ZINN', 4, 'z ih n', 3], ['ROSINNED', 8, 'z ih n d', 4], ['LOZENGE', 7, 'z ih n jh', 4], ['LOZENGED', 8, 'z ih n jh d', 5], ["ZINN'S", 6, 'z ih n z', 4], ['ZINKY', 5, 'z ih ng', 3], ['ZINGED', 6, 'z ih ng d', 4], ['ZINC', 4, 'z ih ng k', 4], ["ZINC'S", 6, 'z ih ng k s', 5], ['ZINCED', 6, 'z ih ng k t', 5], ['ZIPS', 4, 'z ih p s', 4], ['ZIPPED', 6, 'z ih p t', 4], ['WISEST', 6, 'z ih s t', 4], ['RESISTS', 7, 'z ih s t s', 5], ["ZIONS'S", 7, 'z ih z', 3], ['ZIEMIAN', 7, 'z iy', 2], ['PHYSIQUE', 8, 'z iy k', 3], ['ZEAL', 4, 'z iy l', 3], ['VISITE', 6, 'z iy t', 3], ['ZEES', 4, 'z iy z', 3], ['DISEASED', 8, 'z iy z d', 4], ['ISLAM', 5, 'z l aa m', 4], ["ISLAM'S", 7, 'z l aa m z', 5], ['ISLAMIC', 7, 'z l ae', 3], ['TUZLA', 5, 'z l ax', 3], ['MOSLEM', 6, 'z l ax m', 4], ["MOSLEMS'", 8, 'z l ax m z', 5], ['SIZZLER', 7, 'z l ax r', 4], ['SIZZLERS', 8, 'z l ax r z', 5], ['SIZZLERS', 8, 'z l ax z', 4], ['WEASELED', 8, 'z l d', 3], ['WESLEYAN', 8, 'z l ia n', 4], ['WISELY', 6, 'z l ih', 3], ['MUSLIM', 6, 'z l ih m', 4], ["MUSLIMS'", 8, 'z l ih m z', 5], ['ROSLYN', 6, 'z l ih n', 4], ['MUSLINED', 8, 'z l ih n d', 5], ['MUSLINS', 7, 'z l ih n z', 5], ['WISELING', 8, 'z l ih ng', 4], ['HASLETT', 7, 'z l ih t', 4], ["WESLEY'S", 8, 'z l ih z', 4], ['WESLEY', 6, 'z l iy', 3], ["WESLEY'S", 8, 'z l iy z', 4], ['ZLOTYS', 6, 'z l oh', 3], ['KOZLOFF', 7, 'z l oh f', 4], ['WILMSLOW', 8, 'z l ow', 3], ["OSLO'S", 6, 'z l ow z', 4], ['VIRAZOLE', 8, 'z oh l', 3], ['RESOLVES', 8, 'z oh l v z', 5], ['ZOMBIES', 7, 'z oh m', 3], ['RAISONS', 7, 'z oh n z', 4], ['ZOOTOMY', 7, 'z ow', 2], ['RHIZOME', 7, 'z ow m', 3], ['RHIZOMES', 8, 'z ow m z', 4], ['ZONE', 4, 'z ow n', 3], ['ZONED', 5, 'z ow n d', 4], ['ZONES', 5, 'z ow n z', 4], ['AZOTE', 5, 'z ow t', 3], ['BORZOI', 6, 'z oy', 2], ['PENNZOIL', 8, 'z oy l', 3], ['BORZOIS', 7, 'z oy z', 3], ['ROSE-RED', 8, 'z r eh d', 4], ['ISRAELIS', 8, 'z r ey', 3], ['ISRAEL', 6, 'z r ey l', 4], ['ISRAELS', 7, 'z r ey l z', 5], ['NEWSREEL', 8, 'z r iy l', 4], ['NEWSROOM', 8, 'z r uw m', 4], ['ZUCCHINO', 8, 'z uh', 2], ['ZULUS', 5, 'z uw', 2], ['ZOOKS', 5, 'z uw k s', 4], ['ZOOM', 4, 'z uw m', 3], ['ZOOMED', 6, 'z uw m d', 4], ['ZOOMS', 5, 'z uw m z', 4], ['ZOUCH', 5, 'z uw sh', 3], ['ZOOS', 4, 'z uw z', 3], ['ZVIAD', 5, 'z v iy', 3], ['BEESWAX', 7, 'z w ae k s', 5], ['OSWALD', 6, 'z w ax l d', 5], ["OSWALD'S", 8, 'z w ax l d z', 6], ['BEESWING', 8, 'z w ih ng', 4], ['ROSEWOOD', 8, 'z w uh d', 4], ['SILESIA', 7, 'z y ax', 3], ['MESIAL', 6, 'z y ax l', 4], ['CAESIUM', 7, 'z y ax m', 4], ['SILESIAN', 8, 'z y ax n', 4], ["ZURICH'S", 8, 'z y ua', 3], ['CYNOSURE', 8, 'z y ua r', 4], ['LAZULITE', 8, 'z y uh', 3], ['EXUDE', 5, 'z y uw d', 4], ['EXUDES', 6, 'z y uw d z', 5], ['ZEUGMA', 6, 'z y uw g', 4], ['RESUME', 6, 'z y uw m', 4], ['RESUMES', 7, 'z y uw m z', 5], ['JACQUES', 7, 'zh aa k', 3], ['GENRES', 6, 'zh aa n', 3], ['JACQUES', 7, 'zh ae k', 3], ['ZHAO', 4, 'zh aw', 2], ["ZHAO'S", 6, 'zh aw z', 3], ['NIGER', 5, 'zh ea r', 3], ["NIGER'S", 7, 'zh ea r z', 4], ["NIGER'S", 7, 'zh ea z', 3], ['MAJEURE', 7, 'zh er', 2], ['MAJEURE', 7, 'zh er r', 3], ["ASIA'S", 6, 'zh er z', 3], ['MOUJIK', 6, 'zh ih k', 3], ['MOUJIKS', 7, 'zh ih k s', 4], ['REGIER', 6, 'zh iy', 2], ['GIGUE', 5, 'zh iy g', 3], ['GIGUES', 6, 'zh iy g z', 4], ['BELGIQUE', 8, 'zh iy k', 3], ["R\\'EGIME", 8, 'zh iy m', 3], ['JEAN', 4, 'zh oh n', 3], ['JEANED', 6, 'zh oh n d', 4], ['JEANES', 6, 'zh oh n z', 4], ['DIJON', 5, 'zh oh ng', 3], ['PEUGEOT', 7, 'zh ow', 2], ['PEUGEOTS', 8, 'zh ow z', 3], ['VISUALLY', 8, 'zh ua', 2], ['VISUAL', 6, 'zh ua l', 3], ['VISUALS', 7, 'zh ua l z', 4], ['AZURITES', 8, 'zh uh', 2], ['JUPON', 5, 'zh uw', 2], ['JUPE', 4, 'zh uw p', 3], ['BIJOUS', 6, 'zh uw z', 3], ['ETESIAN', 7, 'zh y ax n', 4]]
########################################################

print('Syllables Search is ready! Enjoy! :)')

########################################################
#
# This is the end of SyllablesSearch module
#
########################################################