import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * A Firewall resource offers Palo Alto Networks next-generation firewall capabilities with built-in resiliency, scalability, and life-cycle management.
 *
 * @schema CfnNgfwProps
 */
export interface CfnNgfwProps {
    /**
     * @schema CfnNgfwProps#AccountId
     */
    readonly accountId: string;
    /**
     * @schema CfnNgfwProps#AppIdVersion
     */
    readonly appIdVersion?: string;
    /**
     * @schema CfnNgfwProps#AutomaticUpgradeAppIdVersion
     */
    readonly automaticUpgradeAppIdVersion?: boolean;
    /**
     * @schema CfnNgfwProps#Description
     */
    readonly description?: string;
    /**
     * @schema CfnNgfwProps#EndpointMode
     */
    readonly endpointMode?: EndpointMode;
    /**
     * @schema CfnNgfwProps#FirewallName
     */
    readonly firewallName: string;
    /**
     * @schema CfnNgfwProps#MultiVpcEnable
     */
    readonly multiVpcEnable?: boolean;
    /**
     * @schema CfnNgfwProps#Describe
     */
    readonly describe?: boolean;
    /**
     * @schema CfnNgfwProps#RuleStackName
     */
    readonly ruleStackName?: string;
    /**
     * @schema CfnNgfwProps#GlobalRuleStackName
     */
    readonly globalRuleStackName?: string;
    /**
     * @schema CfnNgfwProps#SubnetMappings
     */
    readonly subnetMappings?: SubnetMappings[];
    /**
     * @schema CfnNgfwProps#AssociateSubnetMappings
     */
    readonly associateSubnetMappings?: SubnetMappings[];
    /**
     * @schema CfnNgfwProps#DisassociateSubnetMappings
     */
    readonly disassociateSubnetMappings?: SubnetMappings[];
    /**
     * @schema CfnNgfwProps#VpcId
     */
    readonly vpcId?: string;
    /**
     * @schema CfnNgfwProps#LinkId
     */
    readonly linkId?: string;
    /**
     * @schema CfnNgfwProps#LogDestinationConfigs
     */
    readonly logDestinationConfigs?: LogProfileConfig[];
    /**
     * @schema CfnNgfwProps#CloudWatchMetricNamespace
     */
    readonly cloudWatchMetricNamespace?: string;
    /**
     * @schema CfnNgfwProps#Tags
     */
    readonly tags?: Tag[];
    /**
     * @schema CfnNgfwProps#VPCIds
     */
    readonly vpcIds?: string[];
    /**
     * @schema CfnNgfwProps#ReadFirewall
     */
    readonly readFirewall?: CfnNgfwPropsReadFirewall;
}
/**
 * Converts an object of type 'CfnNgfwProps' to JSON representation.
 */
export declare function toJson_CfnNgfwProps(obj: CfnNgfwProps | undefined): Record<string, any> | undefined;
/**
 * @schema EndpointMode
 */
export declare enum EndpointMode {
    /** ServiceManaged */
    SERVICE_MANAGED = "ServiceManaged",
    /** CustomerManaged */
    CUSTOMER_MANAGED = "CustomerManaged"
}
/**
 * @schema SubnetMappings
 */
export interface SubnetMappings {
    /**
     * @schema SubnetMappings#AvailabilityZone
     */
    readonly availabilityZone?: string;
    /**
     * @schema SubnetMappings#SubnetId
     */
    readonly subnetId?: string;
}
/**
 * Converts an object of type 'SubnetMappings' to JSON representation.
 */
export declare function toJson_SubnetMappings(obj: SubnetMappings | undefined): Record<string, any> | undefined;
/**
 * Add Log profile config
 *
 * @schema LogProfileConfig
 */
export interface LogProfileConfig {
    /**
     * @schema LogProfileConfig#LogDestination
     */
    readonly logDestination: string;
    /**
     * @schema LogProfileConfig#LogDestinationType
     */
    readonly logDestinationType: LogProfileConfigLogDestinationType;
    /**
     * @schema LogProfileConfig#LogType
     */
    readonly logType: LogProfileConfigLogType;
}
/**
 * Converts an object of type 'LogProfileConfig' to JSON representation.
 */
export declare function toJson_LogProfileConfig(obj: LogProfileConfig | undefined): Record<string, any> | undefined;
/**
 * @schema Tag
 */
export interface Tag {
    /**
     * @schema Tag#Key
     */
    readonly key: string;
    /**
     * @schema Tag#Value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'Tag' to JSON representation.
 */
export declare function toJson_Tag(obj: Tag | undefined): Record<string, any> | undefined;
/**
 * @schema CfnNgfwPropsReadFirewall
 */
export interface CfnNgfwPropsReadFirewall {
    /**
     * @schema CfnNgfwPropsReadFirewall#AccountId
     */
    readonly accountId?: string;
    /**
     * @schema CfnNgfwPropsReadFirewall#AppIdVersion
     */
    readonly appIdVersion?: string;
    /**
     * @schema CfnNgfwPropsReadFirewall#AutomaticUpgradeAppIdVersion
     */
    readonly automaticUpgradeAppIdVersion?: boolean;
    /**
     * @schema CfnNgfwPropsReadFirewall#EndpointMode
     */
    readonly endpointMode?: EndpointMode;
    /**
     * @schema CfnNgfwPropsReadFirewall#Description
     */
    readonly description?: string;
    /**
     * @schema CfnNgfwPropsReadFirewall#FirewallName
     */
    readonly firewallName?: string;
    /**
     * @schema CfnNgfwPropsReadFirewall#MultiVpcEnable
     */
    readonly multiVpcEnable?: boolean;
    /**
     * @schema CfnNgfwPropsReadFirewall#RuleStackName
     */
    readonly ruleStackName?: string;
    /**
     * @schema CfnNgfwPropsReadFirewall#GlobalRuleStackName
     */
    readonly globalRuleStackName?: string;
    /**
     * @schema CfnNgfwPropsReadFirewall#SubnetMappings
     */
    readonly subnetMappings?: SubnetMappings;
    /**
     * @schema CfnNgfwPropsReadFirewall#VpcId
     */
    readonly vpcId?: string;
    /**
     * @schema CfnNgfwPropsReadFirewall#LinkId
     */
    readonly linkId?: string;
    /**
     * @schema CfnNgfwPropsReadFirewall#LinkStatus
     */
    readonly linkStatus?: string;
    /**
     * @schema CfnNgfwPropsReadFirewall#EndpointServiceName
     */
    readonly endpointServiceName?: string;
    /**
     * @schema CfnNgfwPropsReadFirewall#Attachments
     */
    readonly attachments?: Attachment[];
    /**
     * @schema CfnNgfwPropsReadFirewall#FirewallStatus
     */
    readonly firewallStatus?: string;
    /**
     * @schema CfnNgfwPropsReadFirewall#RuleStackStatus
     */
    readonly ruleStackStatus?: string;
    /**
     * @schema CfnNgfwPropsReadFirewall#FailureReason
     */
    readonly failureReason?: string;
    /**
     * @schema CfnNgfwPropsReadFirewall#Tags
     */
    readonly tags?: Tag[];
}
/**
 * Converts an object of type 'CfnNgfwPropsReadFirewall' to JSON representation.
 */
export declare function toJson_CfnNgfwPropsReadFirewall(obj: CfnNgfwPropsReadFirewall | undefined): Record<string, any> | undefined;
/**
 * @schema LogProfileConfigLogDestinationType
 */
export declare enum LogProfileConfigLogDestinationType {
    /** S3 */
    S3 = "S3",
    /** CloudWatchLogs */
    CLOUD_WATCH_LOGS = "CloudWatchLogs",
    /** KinesisDataFirehose */
    KINESIS_DATA_FIREHOSE = "KinesisDataFirehose"
}
/**
 * @schema LogProfileConfigLogType
 */
export declare enum LogProfileConfigLogType {
    /** TRAFFIC */
    TRAFFIC = "TRAFFIC",
    /** DECRYPTION */
    DECRYPTION = "DECRYPTION",
    /** THREAT */
    THREAT = "THREAT"
}
/**
 * @schema Attachment
 */
export interface Attachment {
    /**
     * @schema Attachment#EndpointId
     */
    readonly endpointId?: string;
    /**
     * @schema Attachment#Status
     */
    readonly status?: string;
    /**
     * @schema Attachment#RejectedReason
     */
    readonly rejectedReason?: string;
    /**
     * @schema Attachment#SubnetId
     */
    readonly subnetId?: string;
    /**
     * @schema Attachment#AccountId
     */
    readonly accountId?: string;
    /**
     * @schema Attachment#VpcId
     */
    readonly vpcId?: string;
}
/**
 * Converts an object of type 'Attachment' to JSON representation.
 */
export declare function toJson_Attachment(obj: Attachment | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `PaloAltoNetworks::CloudNGFW::NGFW`
 *
 * @cloudformationResource PaloAltoNetworks::CloudNGFW::NGFW
 * @stability external
 * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
 */
export declare class CfnNgfw extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "PaloAltoNetworks::CloudNGFW::NGFW";
    /**
     * Resource props.
     */
    readonly props: CfnNgfwProps;
    /**
     * Create a new `PaloAltoNetworks::CloudNGFW::NGFW`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnNgfwProps);
}
