"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnNgfw = exports.toJson_Attachment = exports.LogProfileConfigLogType = exports.LogProfileConfigLogDestinationType = exports.toJson_CfnNgfwPropsReadFirewall = exports.toJson_Tag = exports.toJson_LogProfileConfig = exports.toJson_SubnetMappings = exports.EndpointMode = exports.toJson_CfnNgfwProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnNgfwProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnNgfwProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AccountId': obj.accountId,
        'AppIdVersion': obj.appIdVersion,
        'AutomaticUpgradeAppIdVersion': obj.automaticUpgradeAppIdVersion,
        'Description': obj.description,
        'EndpointMode': obj.endpointMode,
        'FirewallName': obj.firewallName,
        'MultiVpcEnable': obj.multiVpcEnable,
        'Describe': obj.describe,
        'RuleStackName': obj.ruleStackName,
        'GlobalRuleStackName': obj.globalRuleStackName,
        'SubnetMappings': obj.subnetMappings?.map(y => toJson_SubnetMappings(y)),
        'AssociateSubnetMappings': obj.associateSubnetMappings?.map(y => toJson_SubnetMappings(y)),
        'DisassociateSubnetMappings': obj.disassociateSubnetMappings?.map(y => toJson_SubnetMappings(y)),
        'VpcId': obj.vpcId,
        'LinkId': obj.linkId,
        'LogDestinationConfigs': obj.logDestinationConfigs?.map(y => toJson_LogProfileConfig(y)),
        'CloudWatchMetricNamespace': obj.cloudWatchMetricNamespace,
        'Tags': obj.tags?.map(y => toJson_Tag(y)),
        'VPCIds': obj.vpcIds?.map(y => y),
        'ReadFirewall': toJson_CfnNgfwPropsReadFirewall(obj.readFirewall),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnNgfwProps = toJson_CfnNgfwProps;
/* eslint-enable max-len, quote-props */
/**
 * @schema EndpointMode
 */
var EndpointMode;
(function (EndpointMode) {
    /** ServiceManaged */
    EndpointMode["SERVICE_MANAGED"] = "ServiceManaged";
    /** CustomerManaged */
    EndpointMode["CUSTOMER_MANAGED"] = "CustomerManaged";
})(EndpointMode = exports.EndpointMode || (exports.EndpointMode = {}));
/**
 * Converts an object of type 'SubnetMappings' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_SubnetMappings(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AvailabilityZone': obj.availabilityZone,
        'SubnetId': obj.subnetId,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_SubnetMappings = toJson_SubnetMappings;
/**
 * Converts an object of type 'LogProfileConfig' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_LogProfileConfig(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'LogDestination': obj.logDestination,
        'LogDestinationType': obj.logDestinationType,
        'LogType': obj.logType,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_LogProfileConfig = toJson_LogProfileConfig;
/**
 * Converts an object of type 'Tag' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Tag(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Key': obj.key,
        'Value': obj.value,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Tag = toJson_Tag;
/**
 * Converts an object of type 'CfnNgfwPropsReadFirewall' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnNgfwPropsReadFirewall(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AccountId': obj.accountId,
        'AppIdVersion': obj.appIdVersion,
        'AutomaticUpgradeAppIdVersion': obj.automaticUpgradeAppIdVersion,
        'EndpointMode': obj.endpointMode,
        'Description': obj.description,
        'FirewallName': obj.firewallName,
        'MultiVpcEnable': obj.multiVpcEnable,
        'RuleStackName': obj.ruleStackName,
        'GlobalRuleStackName': obj.globalRuleStackName,
        'SubnetMappings': toJson_SubnetMappings(obj.subnetMappings),
        'VpcId': obj.vpcId,
        'LinkId': obj.linkId,
        'LinkStatus': obj.linkStatus,
        'EndpointServiceName': obj.endpointServiceName,
        'Attachments': obj.attachments?.map(y => toJson_Attachment(y)),
        'FirewallStatus': obj.firewallStatus,
        'RuleStackStatus': obj.ruleStackStatus,
        'FailureReason': obj.failureReason,
        'Tags': obj.tags?.map(y => toJson_Tag(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnNgfwPropsReadFirewall = toJson_CfnNgfwPropsReadFirewall;
/* eslint-enable max-len, quote-props */
/**
 * @schema LogProfileConfigLogDestinationType
 */
var LogProfileConfigLogDestinationType;
(function (LogProfileConfigLogDestinationType) {
    /** S3 */
    LogProfileConfigLogDestinationType["S3"] = "S3";
    /** CloudWatchLogs */
    LogProfileConfigLogDestinationType["CLOUD_WATCH_LOGS"] = "CloudWatchLogs";
    /** KinesisDataFirehose */
    LogProfileConfigLogDestinationType["KINESIS_DATA_FIREHOSE"] = "KinesisDataFirehose";
})(LogProfileConfigLogDestinationType = exports.LogProfileConfigLogDestinationType || (exports.LogProfileConfigLogDestinationType = {}));
/**
 * @schema LogProfileConfigLogType
 */
var LogProfileConfigLogType;
(function (LogProfileConfigLogType) {
    /** TRAFFIC */
    LogProfileConfigLogType["TRAFFIC"] = "TRAFFIC";
    /** DECRYPTION */
    LogProfileConfigLogType["DECRYPTION"] = "DECRYPTION";
    /** THREAT */
    LogProfileConfigLogType["THREAT"] = "THREAT";
})(LogProfileConfigLogType = exports.LogProfileConfigLogType || (exports.LogProfileConfigLogType = {}));
/**
 * Converts an object of type 'Attachment' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Attachment(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'EndpointId': obj.endpointId,
        'Status': obj.status,
        'RejectedReason': obj.rejectedReason,
        'SubnetId': obj.subnetId,
        'AccountId': obj.accountId,
        'VpcId': obj.vpcId,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Attachment = toJson_Attachment;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `PaloAltoNetworks::CloudNGFW::NGFW`
 *
 * @cloudformationResource PaloAltoNetworks::CloudNGFW::NGFW
 * @stability external
 * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
 */
class CfnNgfw extends cdk.CfnResource {
    /**
     * Create a new `PaloAltoNetworks::CloudNGFW::NGFW`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnNgfw.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnNgfwProps(props) });
        this.props = props;
    }
}
exports.CfnNgfw = CfnNgfw;
_a = JSII_RTTI_SYMBOL_1;
CfnNgfw[_a] = { fqn: "@cdk-cloudformation/paloaltonetworks-cloudngfw-ngfw.CfnNgfw", version: "2.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnNgfw.CFN_RESOURCE_TYPE_NAME = "PaloAltoNetworks::CloudNGFW::NGFW";
//# sourceMappingURL=data:application/json;base64,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