from ..column import Column, VirtualColumn


class JoinColumn(VirtualColumn):
    def __init__(self, joiner=None, **kwds):
        super(JoinColumn, self).__init__(**kwds)

        # set standard properties
        self.setFlag(Column.Flags.ReadOnly)

        # define custom properties
        self.__joiner = joiner

    def joiner(self):
        return self.__joiner

    def setJoiner(self, joiner):
        """
        Sets the joiner query for this column to the inputted query.

        :param      query | (<orb.Column>, <orb.Query>) || <callable> || None
        """
        self.__joiner = joiner


# register the column type
Column.registerAddon('Join', JoinColumn)