from opcua_tools.ua_data_types import (
    UABoolean,
    UAByte,
    UAByteString,
    UADataValue,
    UADateTime,
    UADiagnosticInfo,
    UADouble,
    UAExpandedNodeId,
    UAExtensionObject,
    UAFloat,
    UAGuid,
    UAInt16,
    UAInt32,
    UAInt64,
    UALocalizedText,
    UANodeId,
    UAQualifiedName,
    UASByte,
    UAStatusCode,
    UAString,
    UAUInt16,
    UAUInt32,
    UAUInt64,
    UAVariant,
    UAXMLElement,
    VariantType,
)

DATA_TYPES_MAPPING = {
    UABoolean.__name__: VariantType.Boolean.name,
    UASByte.__name__: VariantType.SByte.name,
    UAByte.__name__: VariantType.Byte.name,
    UAInt16.__name__: VariantType.Int16.name,
    UAUInt16.__name__: VariantType.UInt16.name,
    UAInt32.__name__: VariantType.Int32.name,
    UAUInt32.__name__: VariantType.UInt32.name,
    UAInt64.__name__: VariantType.Int64.name,
    UAUInt64.__name__: VariantType.UInt64.name,
    UAFloat.__name__: VariantType.Float.name,
    UADouble.__name__: VariantType.Double.name,
    UAString.__name__: VariantType.String.name,
    UADateTime.__name__: VariantType.DateTime.name,
    UAGuid.__name__: VariantType.Guid.name,
    UAByteString.__name__: VariantType.ByteString.name,
    UAXMLElement.__name__: VariantType.XmlElement.name,
    UANodeId.__name__: VariantType.NodeId.name,
    UAExpandedNodeId.__name__: VariantType.ExpandedNodeId.name,
    UAStatusCode.__name__: VariantType.StatusCode.name,
    UAQualifiedName.__name__: VariantType.QualifiedName.name,
    UALocalizedText.__name__: VariantType.LocalizedText.name,
    UAExtensionObject.__name__: VariantType.ExtensionObject.name,
    UADataValue.__name__: VariantType.DataValue.name,
    UAVariant.__name__: VariantType.Variant.name,
    UADiagnosticInfo.__name__: VariantType.DiagnosticInfo.name,
}
