# This file was auto-generated by Fern from our API Definition.

import typing_extensions
import typing
from .tts_request_voice_specifier import TtsRequestVoiceSpecifierParams
import typing_extensions
from ..types.supported_language import SupportedLanguage
from .web_socket_raw_output_format import WebSocketRawOutputFormatParams
from ..types.context_id import ContextId
from ...core.serialization import FieldMetadata


class GenerationRequestParams(typing_extensions.TypedDict):
    model_id: str
    """
    The ID of the model to use for the generation. See [Models](/build-with-sonic/models) for available models.
    """

    transcript: typing.Optional[typing.Any]
    """
    The transcript to generate speech for. This can be a string or an iterator over strings.
    """

    voice: TtsRequestVoiceSpecifierParams
    language: typing_extensions.NotRequired[SupportedLanguage]
    output_format: WebSocketRawOutputFormatParams
    duration: typing_extensions.NotRequired[float]
    """
    The maximum duration of the audio in seconds. You do not usually need to specify this.
    If the duration is not appropriate for the length of the transcript, the output audio may be truncated.
    """

    context_id: typing_extensions.NotRequired[ContextId]
    continue_: typing_extensions.NotRequired[typing_extensions.Annotated[bool, FieldMetadata(alias="continue")]]
    """
    Whether this input may be followed by more inputs.
    If not specified, this defaults to `false`.
    """

    flush: typing_extensions.NotRequired[bool]
    """
    Whether to flush the context.
    """

    add_timestamps: typing_extensions.NotRequired[bool]
    """
    Whether to return word-level timestamps.
    """

    add_phoneme_timestamps: typing_extensions.NotRequired[bool]
    """
    Whether to return phoneme-level timestamps.
    """
