# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNgwafRedactionsResult',
    'AwaitableGetNgwafRedactionsResult',
    'get_ngwaf_redactions',
    'get_ngwaf_redactions_output',
]

@pulumi.output_type
class GetNgwafRedactionsResult:
    """
    A collection of values returned by getNgwafRedactions.
    """
    def __init__(__self__, id=None, redactions=None, workspace_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if redactions and not isinstance(redactions, list):
            raise TypeError("Expected argument 'redactions' to be a list")
        pulumi.set(__self__, "redactions", redactions)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def redactions(self) -> Sequence['outputs.GetNgwafRedactionsRedactionResult']:
        """
        List of all redactions for a workspace.
        """
        return pulumi.get(self, "redactions")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> _builtins.str:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")


class AwaitableGetNgwafRedactionsResult(GetNgwafRedactionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNgwafRedactionsResult(
            id=self.id,
            redactions=self.redactions,
            workspace_id=self.workspace_id)


def get_ngwaf_redactions(workspace_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNgwafRedactionsResult:
    """
    Use this data source to get a list of [Fastly Next-Gen WAF Redactions][1].

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    ngwaf_redactions = fastly.get_ngwaf_redactions(workspace_id=test_redactions_workspace["id"])
    pulumi.export("fastlyNgwafRedactionsAll", redactions)
    ```

    [1]: https://www.fastly.com/documentation/reference/api/ngwaf/redactions/


    :param _builtins.str workspace_id: The ID of the workspace.
    """
    __args__ = dict()
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('fastly:index/getNgwafRedactions:getNgwafRedactions', __args__, opts=opts, typ=GetNgwafRedactionsResult).value

    return AwaitableGetNgwafRedactionsResult(
        id=pulumi.get(__ret__, 'id'),
        redactions=pulumi.get(__ret__, 'redactions'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_ngwaf_redactions_output(workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNgwafRedactionsResult]:
    """
    Use this data source to get a list of [Fastly Next-Gen WAF Redactions][1].

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    ngwaf_redactions = fastly.get_ngwaf_redactions(workspace_id=test_redactions_workspace["id"])
    pulumi.export("fastlyNgwafRedactionsAll", redactions)
    ```

    [1]: https://www.fastly.com/documentation/reference/api/ngwaf/redactions/


    :param _builtins.str workspace_id: The ID of the workspace.
    """
    __args__ = dict()
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('fastly:index/getNgwafRedactions:getNgwafRedactions', __args__, opts=opts, typ=GetNgwafRedactionsResult)
    return __ret__.apply(lambda __response__: GetNgwafRedactionsResult(
        id=pulumi.get(__response__, 'id'),
        redactions=pulumi.get(__response__, 'redactions'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
