"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-lambda-kendra';
stack.node.setContext("@aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy", true);
const testBucket = defaults.CreateScrapBucket(stack, "scrapBucket");
const existingIamRole = new iam.Role(stack, 'existingRole', {
    assumedBy: new iam.ServicePrincipal('kendra.amazonaws.com')
});
const sourceProps = {
    urls: {
        seedUrlConfiguration: {
            seedUrls: ["https://aws.amazon.com"]
        }
    },
    crawlDepth: 1,
};
const webCrawlerSource = {
    name: "web-source",
    roleArn: existingIamRole.roleArn,
    type: "WEBCRAWLER",
    dataSourceConfiguration: {
        webCrawlerConfiguration: sourceProps
    }
};
new lib_1.LambdaToKendra(stack, 'minimal-arguments', {
    lambdaFunctionProps: {
        code: lambda.Code.fromAsset(`lambda`),
        runtime: defaults.COMMERCIAL_REGION_LAMBDA_NODE_RUNTIME,
        handler: 'index.handler',
    },
    kendraDataSourcesProps: [{
            type: 'S3',
            dataSourceConfiguration: {
                s3Configuration: {
                    bucketName: testBucket.bucketName,
                }
            }
        },
        webCrawlerSource],
});
core_1.suppressCustomHandlerCfnNagWarnings(stack, 'Custom::S3AutoDeleteObjectsCustomResourceProvider');
// Synth
new integ_tests_alpha_1.IntegTest(stack, 'Integ', { testCases: [
        stack
    ] });
//# sourceMappingURL=data:application/json;base64,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