/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Definitions                                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: LLVMIntrinsicOps.td                                                  *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_OP_LIST
#undef GET_OP_LIST

::mlir::LLVM::AbsOp,
::mlir::LLVM::Annotation,
::mlir::LLVM::AssumeOp,
::mlir::LLVM::BitReverseOp,
::mlir::LLVM::ByteSwapOp,
::mlir::LLVM::CopySignOp,
::mlir::LLVM::CoroAlignOp,
::mlir::LLVM::CoroBeginOp,
::mlir::LLVM::CoroEndOp,
::mlir::LLVM::CoroFreeOp,
::mlir::LLVM::CoroIdOp,
::mlir::LLVM::CoroResumeOp,
::mlir::LLVM::CoroSaveOp,
::mlir::LLVM::CoroSizeOp,
::mlir::LLVM::CoroSuspendOp,
::mlir::LLVM::CosOp,
::mlir::LLVM::CountLeadingZerosOp,
::mlir::LLVM::CountTrailingZerosOp,
::mlir::LLVM::CtPopOp,
::mlir::LLVM::DbgDeclareOp,
::mlir::LLVM::DbgLabelOp,
::mlir::LLVM::DbgValueOp,
::mlir::LLVM::DebugTrap,
::mlir::LLVM::EhTypeidForOp,
::mlir::LLVM::Exp2Op,
::mlir::LLVM::ExpOp,
::mlir::LLVM::ExpectOp,
::mlir::LLVM::ExpectWithProbabilityOp,
::mlir::LLVM::FAbsOp,
::mlir::LLVM::FCeilOp,
::mlir::LLVM::FFloorOp,
::mlir::LLVM::FMAOp,
::mlir::LLVM::FMulAddOp,
::mlir::LLVM::FTruncOp,
::mlir::LLVM::FshlOp,
::mlir::LLVM::FshrOp,
::mlir::LLVM::GetActiveLaneMaskOp,
::mlir::LLVM::IsConstantOp,
::mlir::LLVM::IsFPClass,
::mlir::LLVM::LifetimeEndOp,
::mlir::LLVM::LifetimeStartOp,
::mlir::LLVM::LlrintOp,
::mlir::LLVM::LlroundOp,
::mlir::LLVM::Log10Op,
::mlir::LLVM::Log2Op,
::mlir::LLVM::LogOp,
::mlir::LLVM::LrintOp,
::mlir::LLVM::LroundOp,
::mlir::LLVM::MaskedLoadOp,
::mlir::LLVM::MaskedStoreOp,
::mlir::LLVM::MatrixColumnMajorLoadOp,
::mlir::LLVM::MatrixColumnMajorStoreOp,
::mlir::LLVM::MatrixMultiplyOp,
::mlir::LLVM::MatrixTransposeOp,
::mlir::LLVM::MaxNumOp,
::mlir::LLVM::MaximumOp,
::mlir::LLVM::MemcpyInlineOp,
::mlir::LLVM::MemcpyOp,
::mlir::LLVM::MemmoveOp,
::mlir::LLVM::MemsetOp,
::mlir::LLVM::MinNumOp,
::mlir::LLVM::MinimumOp,
::mlir::LLVM::NearbyintOp,
::mlir::LLVM::NoAliasScopeDeclOp,
::mlir::LLVM::PowIOp,
::mlir::LLVM::PowOp,
::mlir::LLVM::Prefetch,
::mlir::LLVM::PtrAnnotation,
::mlir::LLVM::RintOp,
::mlir::LLVM::RoundEvenOp,
::mlir::LLVM::RoundOp,
::mlir::LLVM::SAddSat,
::mlir::LLVM::SAddWithOverflowOp,
::mlir::LLVM::SMaxOp,
::mlir::LLVM::SMinOp,
::mlir::LLVM::SMulWithOverflowOp,
::mlir::LLVM::SSACopyOp,
::mlir::LLVM::SSHLSat,
::mlir::LLVM::SSubSat,
::mlir::LLVM::SSubWithOverflowOp,
::mlir::LLVM::SinOp,
::mlir::LLVM::SqrtOp,
::mlir::LLVM::StackRestoreOp,
::mlir::LLVM::StackSaveOp,
::mlir::LLVM::StepVectorOp,
::mlir::LLVM::ThreadlocalAddressOp,
::mlir::LLVM::Trap,
::mlir::LLVM::UAddSat,
::mlir::LLVM::UAddWithOverflowOp,
::mlir::LLVM::UBSanTrap,
::mlir::LLVM::UMaxOp,
::mlir::LLVM::UMinOp,
::mlir::LLVM::UMulWithOverflowOp,
::mlir::LLVM::USHLSat,
::mlir::LLVM::USubSat,
::mlir::LLVM::USubWithOverflowOp,
::mlir::LLVM::VPAShrOp,
::mlir::LLVM::VPAddOp,
::mlir::LLVM::VPAndOp,
::mlir::LLVM::VPFAddOp,
::mlir::LLVM::VPFDivOp,
::mlir::LLVM::VPFMulAddOp,
::mlir::LLVM::VPFMulOp,
::mlir::LLVM::VPFNegOp,
::mlir::LLVM::VPFPExtOp,
::mlir::LLVM::VPFPToSIOp,
::mlir::LLVM::VPFPToUIOp,
::mlir::LLVM::VPFPTruncOp,
::mlir::LLVM::VPFRemOp,
::mlir::LLVM::VPFSubOp,
::mlir::LLVM::VPFmaOp,
::mlir::LLVM::VPIntToPtrOp,
::mlir::LLVM::VPLShrOp,
::mlir::LLVM::VPLoadOp,
::mlir::LLVM::VPMergeMinOp,
::mlir::LLVM::VPMulOp,
::mlir::LLVM::VPOrOp,
::mlir::LLVM::VPPtrToIntOp,
::mlir::LLVM::VPReduceAddOp,
::mlir::LLVM::VPReduceAndOp,
::mlir::LLVM::VPReduceFAddOp,
::mlir::LLVM::VPReduceFMaxOp,
::mlir::LLVM::VPReduceFMinOp,
::mlir::LLVM::VPReduceFMulOp,
::mlir::LLVM::VPReduceMulOp,
::mlir::LLVM::VPReduceOrOp,
::mlir::LLVM::VPReduceSMaxOp,
::mlir::LLVM::VPReduceSMinOp,
::mlir::LLVM::VPReduceUMaxOp,
::mlir::LLVM::VPReduceUMinOp,
::mlir::LLVM::VPReduceXorOp,
::mlir::LLVM::VPSDivOp,
::mlir::LLVM::VPSExtOp,
::mlir::LLVM::VPSIToFPOp,
::mlir::LLVM::VPSRemOp,
::mlir::LLVM::VPSelectMinOp,
::mlir::LLVM::VPShlOp,
::mlir::LLVM::VPStoreOp,
::mlir::LLVM::VPStridedLoadOp,
::mlir::LLVM::VPStridedStoreOp,
::mlir::LLVM::VPSubOp,
::mlir::LLVM::VPTruncOp,
::mlir::LLVM::VPUDivOp,
::mlir::LLVM::VPUIToFPOp,
::mlir::LLVM::VPURemOp,
::mlir::LLVM::VPXorOp,
::mlir::LLVM::VPZExtOp,
::mlir::LLVM::VaCopyOp,
::mlir::LLVM::VaEndOp,
::mlir::LLVM::VaStartOp,
::mlir::LLVM::VarAnnotation,
::mlir::LLVM::masked_compressstore,
::mlir::LLVM::masked_expandload,
::mlir::LLVM::masked_gather,
::mlir::LLVM::masked_scatter,
::mlir::LLVM::vector_extract,
::mlir::LLVM::vector_insert,
::mlir::LLVM::vector_reduce_add,
::mlir::LLVM::vector_reduce_and,
::mlir::LLVM::vector_reduce_fadd,
::mlir::LLVM::vector_reduce_fmax,
::mlir::LLVM::vector_reduce_fmaximum,
::mlir::LLVM::vector_reduce_fmin,
::mlir::LLVM::vector_reduce_fminimum,
::mlir::LLVM::vector_reduce_fmul,
::mlir::LLVM::vector_reduce_mul,
::mlir::LLVM::vector_reduce_or,
::mlir::LLVM::vector_reduce_smax,
::mlir::LLVM::vector_reduce_smin,
::mlir::LLVM::vector_reduce_umax,
::mlir::LLVM::vector_reduce_umin,
::mlir::LLVM::vector_reduce_xor,
::mlir::LLVM::vscale
#endif  // GET_OP_LIST

#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES


//===----------------------------------------------------------------------===//
// Local Utility Method Definitions
//===----------------------------------------------------------------------===//

namespace mlir {
namespace LLVM {

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps0(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((type.isSignlessInteger())) || (((::mlir::LLVM::isCompatibleVectorType(type))) && ((::mlir::LLVM::getVectorElementType(type).isSignlessInteger()))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be signless integer or LLVM dialect-compatible vector of signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps1(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::mlir::LLVM::isCompatibleOuterType(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be LLVM dialect-compatible type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps2(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isSignlessInteger()))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps3(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::LLVM::LLVMPointerType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be LLVM pointer type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps4(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isSignlessInteger(32)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be 32-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps5(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isSignlessInteger(1)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be 1-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps6(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::mlir::LLVM::isCompatibleFloatingPointType(type))) || (((::mlir::LLVM::isCompatibleVectorType(type))) && ((::mlir::LLVM::isCompatibleFloatingPointType(::mlir::LLVM::getVectorElementType(type))))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be floating point LLVM type or LLVM dialect-compatible vector of floating point LLVM type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps7(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::LLVM::LLVMTokenType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be LLVM token type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps8(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((::llvm::isa<::mlir::LLVM::LLVMPointerType>(type))) && ((((::llvm::isa<::mlir::LLVM::LLVMPointerType>(type))) && ((::llvm::cast<::mlir::LLVM::LLVMPointerType>(type).isOpaque()))) || ((::llvm::cast<::mlir::LLVM::LLVMPointerType>(type).getElementType().isSignlessInteger(8))))) && ((::llvm::cast<::mlir::LLVM::LLVMPointerType>(type).getAddressSpace() == 0)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be LLVM pointer to 8-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps9(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::mlir::LLVM::isCompatibleFloatingPointType(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be floating point LLVM type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps10(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::mlir::LLVM::isCompatibleVectorType(type))) && ((::mlir::LLVM::getVectorElementType(type).isSignlessInteger(1))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be LLVM dialect-compatible vector of 1-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps11(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::mlir::LLVM::isCompatibleVectorType(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be LLVM dialect-compatible vector type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps12(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isSignlessInteger(8)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be 8-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps13(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::llvm::isa<::mlir::LLVM::LLVMPointerType>(type))) && ((((::llvm::isa<::mlir::LLVM::LLVMPointerType>(type))) && ((::llvm::cast<::mlir::LLVM::LLVMPointerType>(type).isOpaque()))) || ((::llvm::cast<::mlir::LLVM::LLVMPointerType>(type).getElementType().isSignlessInteger()))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be LLVM pointer to signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps14(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((true))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be any type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps15(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::mlir::LLVM::isCompatibleVectorType(type))) && ((::mlir::LLVM::getVectorElementType(type).isSignlessInteger())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be LLVM dialect-compatible vector of signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps16(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::mlir::LLVM::isCompatibleVectorType(type))) && ((::llvm::isa<::mlir::FloatType>(::mlir::LLVM::getVectorElementType(type)))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be LLVM dialect-compatible vector of floating-point, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps17(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::mlir::LLVM::isCompatibleVectorType(type))) && ((::llvm::isa<::mlir::LLVM::LLVMPointerType>(::mlir::LLVM::getVectorElementType(type)))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be LLVM dialect-compatible vector of LLVM pointer type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_LLVMIntrinsicOps18(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::FloatType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be floating-point, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(1)))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 1-bit signless integer attribute";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: LLVM fastmath flags";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps2(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::LLVM::DILocalVariableAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: ";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps2(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_LLVMIntrinsicOps2(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps3(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::LLVM::DILabelAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: ";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps3(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_LLVMIntrinsicOps3(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps4(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::FloatAttr>(attr))) && ((::llvm::cast<::mlir::FloatAttr>(attr).getType().isF64()))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 64-bit float attribute";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps4(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_LLVMIntrinsicOps4(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 32-bit signless integer attribute";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps6(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(64)))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 64-bit signless integer attribute";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps6(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_LLVMIntrinsicOps6(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps7(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::IntegerAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: arbitrary integer attribute";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps7(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_LLVMIntrinsicOps7(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps8(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::ArrayAttr>(attr))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(attr), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::AccessGroupAttr>(attr))); }))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: LLVM dialect access group metadata array";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps8(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_LLVMIntrinsicOps8(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::ArrayAttr>(attr))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(attr), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::AliasScopeAttr>(attr))); }))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: LLVM dialect alias scope array";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps10(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::ArrayAttr>(attr))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(attr), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::TBAATagAttr>(attr))); }))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: LLVM dialect TBAA tag metadata array";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps10(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_LLVMIntrinsicOps10(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps11(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::LLVM::AliasScopeAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: LLVM dialect alias scope";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps11(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_LLVMIntrinsicOps11(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps12(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(8)))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 8-bit signless integer attribute";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_LLVMIntrinsicOps12(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_LLVMIntrinsicOps12(attr, attrName, [op]() {
    return op->emitOpError();
  });
}
} // namespace LLVM
} // namespace mlir
namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::AbsOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
AbsOpGenericAdaptorBase::AbsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.abs", odsAttrs.getContext());
}

AbsOpGenericAdaptorBase::AbsOpGenericAdaptorBase(AbsOp op) : AbsOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> AbsOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr AbsOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr AbsOpGenericAdaptorBase::getIsIntMinPoisonAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().is_int_min_poison);
  return attr;
}

bool AbsOpGenericAdaptorBase::getIsIntMinPoison() {
  auto attr = getIsIntMinPoisonAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
AbsOpAdaptor::AbsOpAdaptor(AbsOp op) : AbsOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult AbsOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_is_int_min_poison = getProperties().is_int_min_poison; (void)tblgen_is_int_min_poison;
  if (!tblgen_is_int_min_poison) return emitError(loc, "'llvm.intr.abs' op ""requires attribute 'is_int_min_poison'");

  if (tblgen_is_int_min_poison && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_is_int_min_poison))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_is_int_min_poison).getType().isSignlessInteger(1)))))
    return emitError(loc, "'llvm.intr.abs' op ""attribute 'is_int_min_poison' failed to satisfy constraint: 1-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> AbsOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range AbsOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value AbsOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &AbsOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> AbsOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range AbsOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value AbsOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult AbsOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.is_int_min_poison;
       auto attr = dict.get("is_int_min_poison");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for is_int_min_poison in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `is_int_min_poison` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute AbsOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.is_int_min_poison;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("is_int_min_poison",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code AbsOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.is_int_min_poison.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> AbsOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "is_int_min_poison")
      return prop.is_int_min_poison;
  return std::nullopt;
}

void AbsOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "is_int_min_poison") {
       prop.is_int_min_poison = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.is_int_min_poison)>>(value);
       return;
    }
}

void AbsOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.is_int_min_poison) attrs.append("is_int_min_poison", prop.is_int_min_poison);
}

::mlir::LogicalResult AbsOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getIsIntMinPoisonAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(attr, "is_int_min_poison", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult AbsOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.is_int_min_poison)))
    return ::mlir::failure();
  return ::mlir::success();
}

void AbsOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.is_int_min_poison);
}

::mlir::IntegerAttr AbsOp::getIsIntMinPoisonAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().is_int_min_poison);
}

bool AbsOp::getIsIntMinPoison() {
  auto attr = getIsIntMinPoisonAttr();
  return attr.getValue().getZExtValue();
}

void AbsOp::setIsIntMinPoisonAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getIsIntMinPoisonAttrName(), attr);
}

void AbsOp::setIsIntMinPoison(bool attrValue) {
  (*this)->setAttr(getIsIntMinPoisonAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(1), attrValue));
}

void AbsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::IntegerAttr is_int_min_poison) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().is_int_min_poison = is_int_min_poison;
  odsState.addTypes(res);
}

void AbsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::IntegerAttr is_int_min_poison) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().is_int_min_poison = is_int_min_poison;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AbsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, bool is_int_min_poison) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().is_int_min_poison = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), is_int_min_poison);
  odsState.addTypes(res);
}

void AbsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, bool is_int_min_poison) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().is_int_min_poison = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), is_int_min_poison);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AbsOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult AbsOp::verifyInvariantsImpl() {
  auto tblgen_is_int_min_poison = getProperties().is_int_min_poison; (void)tblgen_is_int_min_poison;
  if (!tblgen_is_int_min_poison) return emitOpError("requires attribute 'is_int_min_poison'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(*this, tblgen_is_int_min_poison, "is_int_min_poison")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult AbsOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

void AbsOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::AbsOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::Annotation definitions
//===----------------------------------------------------------------------===//

namespace detail {
AnnotationGenericAdaptorBase::AnnotationGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.annotation", odsAttrs.getContext());
}

AnnotationGenericAdaptorBase::AnnotationGenericAdaptorBase(Annotation op) : AnnotationGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> AnnotationGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr AnnotationGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
AnnotationAdaptor::AnnotationAdaptor(Annotation op) : AnnotationGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult AnnotationAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> Annotation::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range Annotation::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::IntegerType> Annotation::getInteger() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> Annotation::getAnnotation() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> Annotation::getFileName() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(2).begin());
}

::mlir::TypedValue<::mlir::IntegerType> Annotation::getLine() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(3).begin());
}

::mlir::OpOperand &Annotation::getIntegerMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &Annotation::getAnnotationMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &Annotation::getFileNameMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &Annotation::getLineMutable() {
  auto range = getODSOperandIndexAndLength(3);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> Annotation::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range Annotation::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::IntegerType> Annotation::getRes() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
}

void Annotation::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value integer, ::mlir::Value annotation, ::mlir::Value fileName, ::mlir::Value line) {
  odsState.addOperands(integer);
  odsState.addOperands(annotation);
  odsState.addOperands(fileName);
  odsState.addOperands(line);
  odsState.addTypes(res);
}

void Annotation::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value integer, ::mlir::Value annotation, ::mlir::Value fileName, ::mlir::Value line) {
  odsState.addOperands(integer);
  odsState.addOperands(annotation);
  odsState.addOperands(fileName);
  odsState.addOperands(line);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(Annotation::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void Annotation::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value integer, ::mlir::Value annotation, ::mlir::Value fileName, ::mlir::Value line) {
  odsState.addOperands(integer);
  odsState.addOperands(annotation);
  odsState.addOperands(fileName);
  odsState.addOperands(line);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void Annotation::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 4u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void Annotation::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 4u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(Annotation::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult Annotation::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  if (!((((*this->getODSResults(0).begin()).getType()) == ((*this->getODSOperands(0).begin()).getType()) && ((*this->getODSOperands(0).begin()).getType()) == ((*this->getODSResults(0).begin()).getType()))))
    return emitOpError("failed to verify that all of {res, integer} have same type");
  if (!((((*this->getODSOperands(1).begin()).getType()) == ((*this->getODSOperands(2).begin()).getType()) && ((*this->getODSOperands(2).begin()).getType()) == ((*this->getODSOperands(1).begin()).getType()))))
    return emitOpError("failed to verify that all of {annotation, fileName} have same type");
  return ::mlir::success();
}

::mlir::LogicalResult Annotation::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult Annotation::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::Annotation)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::AssumeOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
AssumeOpGenericAdaptorBase::AssumeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.assume", odsAttrs.getContext());
}

AssumeOpGenericAdaptorBase::AssumeOpGenericAdaptorBase(AssumeOp op) : AssumeOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> AssumeOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr AssumeOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
AssumeOpAdaptor::AssumeOpAdaptor(AssumeOp op) : AssumeOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult AssumeOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> AssumeOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range AssumeOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::IntegerType> AssumeOp::getCond() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
}

::mlir::OpOperand &AssumeOp::getCondMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> AssumeOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range AssumeOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void AssumeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value cond) {
  odsState.addOperands(cond);
}

void AssumeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value cond) {
  odsState.addOperands(cond);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AssumeOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult AssumeOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult AssumeOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::AssumeOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::BitReverseOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
BitReverseOpGenericAdaptorBase::BitReverseOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.bitreverse", odsAttrs.getContext());
}

BitReverseOpGenericAdaptorBase::BitReverseOpGenericAdaptorBase(BitReverseOp op) : BitReverseOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> BitReverseOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr BitReverseOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
BitReverseOpAdaptor::BitReverseOpAdaptor(BitReverseOp op) : BitReverseOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult BitReverseOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> BitReverseOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range BitReverseOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value BitReverseOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &BitReverseOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> BitReverseOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range BitReverseOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value BitReverseOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void BitReverseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in) {
  odsState.addOperands(in);
  odsState.addTypes(res);
}

void BitReverseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in) {
  odsState.addOperands(in);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(BitReverseOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void BitReverseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in) {
  odsState.addOperands(in);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void BitReverseOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void BitReverseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(BitReverseOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult BitReverseOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult BitReverseOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult BitReverseOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult BitReverseOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void BitReverseOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void BitReverseOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::BitReverseOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::ByteSwapOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ByteSwapOpGenericAdaptorBase::ByteSwapOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.bswap", odsAttrs.getContext());
}

ByteSwapOpGenericAdaptorBase::ByteSwapOpGenericAdaptorBase(ByteSwapOp op) : ByteSwapOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> ByteSwapOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr ByteSwapOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
ByteSwapOpAdaptor::ByteSwapOpAdaptor(ByteSwapOp op) : ByteSwapOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult ByteSwapOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ByteSwapOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range ByteSwapOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value ByteSwapOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &ByteSwapOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> ByteSwapOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range ByteSwapOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value ByteSwapOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void ByteSwapOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in) {
  odsState.addOperands(in);
  odsState.addTypes(res);
}

void ByteSwapOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in) {
  odsState.addOperands(in);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(ByteSwapOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void ByteSwapOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in) {
  odsState.addOperands(in);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ByteSwapOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void ByteSwapOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(ByteSwapOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult ByteSwapOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult ByteSwapOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult ByteSwapOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult ByteSwapOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ByteSwapOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void ByteSwapOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::ByteSwapOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CopySignOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CopySignOpGenericAdaptorBase::CopySignOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.copysign", odsAttrs.getContext());
}

CopySignOpGenericAdaptorBase::CopySignOpGenericAdaptorBase(CopySignOp op) : CopySignOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> CopySignOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr CopySignOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr CopySignOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags CopySignOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
CopySignOpAdaptor::CopySignOpAdaptor(CopySignOp op) : CopySignOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult CopySignOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.copysign' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CopySignOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range CopySignOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CopySignOp::getA() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value CopySignOp::getB() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::OpOperand &CopySignOp::getAMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &CopySignOp::getBMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> CopySignOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CopySignOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CopySignOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult CopySignOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute CopySignOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code CopySignOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> CopySignOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void CopySignOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void CopySignOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult CopySignOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult CopySignOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void CopySignOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr CopySignOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags CopySignOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void CopySignOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void CopySignOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void CopySignOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void CopySignOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(CopySignOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void CopySignOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CopySignOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void CopySignOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(CopySignOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void CopySignOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CopySignOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void CopySignOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(CopySignOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void CopySignOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult CopySignOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CopySignOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult CopySignOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult CopySignOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CopySignOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void CopySignOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::CopySignOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CoroAlignOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CoroAlignOpGenericAdaptorBase::CoroAlignOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.coro.align", odsAttrs.getContext());
}

CoroAlignOpGenericAdaptorBase::CoroAlignOpGenericAdaptorBase(CoroAlignOp op) : CoroAlignOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> CoroAlignOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr CoroAlignOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
CoroAlignOpAdaptor::CoroAlignOpAdaptor(CoroAlignOp op) : CoroAlignOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult CoroAlignOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CoroAlignOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range CoroAlignOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> CoroAlignOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CoroAlignOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CoroAlignOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void CoroAlignOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res) {
  odsState.addTypes(res);
}

void CoroAlignOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes) {
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CoroAlignOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult CoroAlignOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CoroAlignOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult CoroAlignOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::Type resRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> resTypes(resRawTypes);
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawTypes[0] = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void CoroAlignOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::CoroAlignOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CoroBeginOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CoroBeginOpGenericAdaptorBase::CoroBeginOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.coro.begin", odsAttrs.getContext());
}

CoroBeginOpGenericAdaptorBase::CoroBeginOpGenericAdaptorBase(CoroBeginOp op) : CoroBeginOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> CoroBeginOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr CoroBeginOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
CoroBeginOpAdaptor::CoroBeginOpAdaptor(CoroBeginOp op) : CoroBeginOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult CoroBeginOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CoroBeginOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range CoroBeginOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CoroBeginOp::getToken() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value CoroBeginOp::getMem() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::OpOperand &CoroBeginOp::getTokenMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &CoroBeginOp::getMemMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> CoroBeginOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CoroBeginOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CoroBeginOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void CoroBeginOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value token, ::mlir::Value mem) {
  odsState.addOperands(token);
  odsState.addOperands(mem);
  odsState.addTypes(res);
}

void CoroBeginOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value token, ::mlir::Value mem) {
  odsState.addOperands(token);
  odsState.addOperands(mem);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CoroBeginOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult CoroBeginOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CoroBeginOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult CoroBeginOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand tokenRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> tokenOperands(tokenRawOperands);  ::llvm::SMLoc tokenOperandsLoc;
  (void)tokenOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand memRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> memOperands(memRawOperands);  ::llvm::SMLoc memOperandsLoc;
  (void)memOperandsLoc;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  tokenOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(tokenRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  memOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(memRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::UnresolvedOperand>(tokenOperands, memOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CoroBeginOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getToken();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getMem();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::CoroBeginOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CoroEndOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CoroEndOpGenericAdaptorBase::CoroEndOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.coro.end", odsAttrs.getContext());
}

CoroEndOpGenericAdaptorBase::CoroEndOpGenericAdaptorBase(CoroEndOp op) : CoroEndOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> CoroEndOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr CoroEndOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
CoroEndOpAdaptor::CoroEndOpAdaptor(CoroEndOp op) : CoroEndOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult CoroEndOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CoroEndOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range CoroEndOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CoroEndOp::getHandle() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::IntegerType> CoroEndOp::getUnwind() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
}

::mlir::Value CoroEndOp::getRetvals() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(2).begin());
}

::mlir::OpOperand &CoroEndOp::getHandleMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &CoroEndOp::getUnwindMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &CoroEndOp::getRetvalsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> CoroEndOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CoroEndOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CoroEndOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void CoroEndOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value handle, ::mlir::Value unwind, ::mlir::Value retvals) {
  odsState.addOperands(handle);
  odsState.addOperands(unwind);
  odsState.addOperands(retvals);
  odsState.addTypes(res);
}

void CoroEndOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value handle, ::mlir::Value unwind, ::mlir::Value retvals) {
  odsState.addOperands(handle);
  odsState.addOperands(unwind);
  odsState.addOperands(retvals);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CoroEndOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult CoroEndOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CoroEndOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult CoroEndOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand handleRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> handleOperands(handleRawOperands);  ::llvm::SMLoc handleOperandsLoc;
  (void)handleOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand unwindRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> unwindOperands(unwindRawOperands);  ::llvm::SMLoc unwindOperandsLoc;
  (void)unwindOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand retvalsRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> retvalsOperands(retvalsRawOperands);  ::llvm::SMLoc retvalsOperandsLoc;
  (void)retvalsOperandsLoc;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  handleOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(handleRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  unwindOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(unwindRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  retvalsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(retvalsRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::UnresolvedOperand>(handleOperands, unwindOperands, retvalsOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CoroEndOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getHandle();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getUnwind();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getRetvals();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::CoroEndOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CoroFreeOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CoroFreeOpGenericAdaptorBase::CoroFreeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.coro.free", odsAttrs.getContext());
}

CoroFreeOpGenericAdaptorBase::CoroFreeOpGenericAdaptorBase(CoroFreeOp op) : CoroFreeOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> CoroFreeOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr CoroFreeOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
CoroFreeOpAdaptor::CoroFreeOpAdaptor(CoroFreeOp op) : CoroFreeOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult CoroFreeOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CoroFreeOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range CoroFreeOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CoroFreeOp::getId() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value CoroFreeOp::getHandle() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::OpOperand &CoroFreeOp::getIdMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &CoroFreeOp::getHandleMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> CoroFreeOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CoroFreeOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CoroFreeOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void CoroFreeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value id, ::mlir::Value handle) {
  odsState.addOperands(id);
  odsState.addOperands(handle);
  odsState.addTypes(res);
}

void CoroFreeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value id, ::mlir::Value handle) {
  odsState.addOperands(id);
  odsState.addOperands(handle);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CoroFreeOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult CoroFreeOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CoroFreeOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult CoroFreeOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand idRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> idOperands(idRawOperands);  ::llvm::SMLoc idOperandsLoc;
  (void)idOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand handleRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> handleOperands(handleRawOperands);  ::llvm::SMLoc handleOperandsLoc;
  (void)handleOperandsLoc;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  idOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(idRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  handleOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(handleRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::UnresolvedOperand>(idOperands, handleOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CoroFreeOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getId();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getHandle();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::CoroFreeOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CoroIdOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CoroIdOpGenericAdaptorBase::CoroIdOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.coro.id", odsAttrs.getContext());
}

CoroIdOpGenericAdaptorBase::CoroIdOpGenericAdaptorBase(CoroIdOp op) : CoroIdOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> CoroIdOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr CoroIdOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
CoroIdOpAdaptor::CoroIdOpAdaptor(CoroIdOp op) : CoroIdOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult CoroIdOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CoroIdOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range CoroIdOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::IntegerType> CoroIdOp::getAlign() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
}

::mlir::Value CoroIdOp::getPromise() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::Value CoroIdOp::getCoroaddr() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(2).begin());
}

::mlir::Value CoroIdOp::getFnaddrs() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(3).begin());
}

::mlir::OpOperand &CoroIdOp::getAlignMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &CoroIdOp::getPromiseMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &CoroIdOp::getCoroaddrMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &CoroIdOp::getFnaddrsMutable() {
  auto range = getODSOperandIndexAndLength(3);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> CoroIdOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CoroIdOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CoroIdOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void CoroIdOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value align, ::mlir::Value promise, ::mlir::Value coroaddr, ::mlir::Value fnaddrs) {
  odsState.addOperands(align);
  odsState.addOperands(promise);
  odsState.addOperands(coroaddr);
  odsState.addOperands(fnaddrs);
  odsState.addTypes(res);
}

void CoroIdOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value align, ::mlir::Value promise, ::mlir::Value coroaddr, ::mlir::Value fnaddrs) {
  odsState.addOperands(align);
  odsState.addOperands(promise);
  odsState.addOperands(coroaddr);
  odsState.addOperands(fnaddrs);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CoroIdOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 4u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult CoroIdOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CoroIdOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult CoroIdOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand alignRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> alignOperands(alignRawOperands);  ::llvm::SMLoc alignOperandsLoc;
  (void)alignOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand promiseRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> promiseOperands(promiseRawOperands);  ::llvm::SMLoc promiseOperandsLoc;
  (void)promiseOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand coroaddrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> coroaddrOperands(coroaddrRawOperands);  ::llvm::SMLoc coroaddrOperandsLoc;
  (void)coroaddrOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand fnaddrsRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> fnaddrsOperands(fnaddrsRawOperands);  ::llvm::SMLoc fnaddrsOperandsLoc;
  (void)fnaddrsOperandsLoc;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  alignOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(alignRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  promiseOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(promiseRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  coroaddrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(coroaddrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  fnaddrsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(fnaddrsRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::UnresolvedOperand>(alignOperands, promiseOperands, coroaddrOperands, fnaddrsOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CoroIdOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getAlign();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getPromise();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getCoroaddr();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getFnaddrs();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::CoroIdOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CoroResumeOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CoroResumeOpGenericAdaptorBase::CoroResumeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.coro.resume", odsAttrs.getContext());
}

CoroResumeOpGenericAdaptorBase::CoroResumeOpGenericAdaptorBase(CoroResumeOp op) : CoroResumeOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> CoroResumeOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr CoroResumeOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
CoroResumeOpAdaptor::CoroResumeOpAdaptor(CoroResumeOp op) : CoroResumeOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult CoroResumeOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CoroResumeOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range CoroResumeOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CoroResumeOp::getHandle() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &CoroResumeOp::getHandleMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> CoroResumeOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CoroResumeOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void CoroResumeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value handle) {
  odsState.addOperands(handle);
}

void CoroResumeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value handle) {
  odsState.addOperands(handle);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CoroResumeOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult CoroResumeOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CoroResumeOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult CoroResumeOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand handleRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> handleOperands(handleRawOperands);  ::llvm::SMLoc handleOperandsLoc;
  (void)handleOperandsLoc;
  ::mlir::Type handleRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> handleTypes(handleRawTypes);

  handleOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(handleRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(handleRawTypes[0]))
    return ::mlir::failure();
  if (parser.resolveOperands(handleOperands, handleTypes, handleOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CoroResumeOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getHandle();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getHandle().getType();
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::CoroResumeOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CoroSaveOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CoroSaveOpGenericAdaptorBase::CoroSaveOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.coro.save", odsAttrs.getContext());
}

CoroSaveOpGenericAdaptorBase::CoroSaveOpGenericAdaptorBase(CoroSaveOp op) : CoroSaveOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> CoroSaveOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr CoroSaveOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
CoroSaveOpAdaptor::CoroSaveOpAdaptor(CoroSaveOp op) : CoroSaveOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult CoroSaveOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CoroSaveOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range CoroSaveOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CoroSaveOp::getHandle() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &CoroSaveOp::getHandleMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> CoroSaveOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CoroSaveOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CoroSaveOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void CoroSaveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value handle) {
  odsState.addOperands(handle);
  odsState.addTypes(res);
}

void CoroSaveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value handle) {
  odsState.addOperands(handle);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CoroSaveOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult CoroSaveOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CoroSaveOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult CoroSaveOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand handleRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> handleOperands(handleRawOperands);  ::llvm::SMLoc handleOperandsLoc;
  (void)handleOperandsLoc;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  handleOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(handleRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(handleOperands, allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CoroSaveOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getHandle();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::CoroSaveOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CoroSizeOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CoroSizeOpGenericAdaptorBase::CoroSizeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.coro.size", odsAttrs.getContext());
}

CoroSizeOpGenericAdaptorBase::CoroSizeOpGenericAdaptorBase(CoroSizeOp op) : CoroSizeOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> CoroSizeOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr CoroSizeOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
CoroSizeOpAdaptor::CoroSizeOpAdaptor(CoroSizeOp op) : CoroSizeOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult CoroSizeOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CoroSizeOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range CoroSizeOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> CoroSizeOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CoroSizeOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CoroSizeOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void CoroSizeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res) {
  odsState.addTypes(res);
}

void CoroSizeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes) {
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CoroSizeOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult CoroSizeOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CoroSizeOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult CoroSizeOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::Type resRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> resTypes(resRawTypes);
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawTypes[0] = type;
  }
  result.addTypes(resTypes);
  return ::mlir::success();
}

void CoroSizeOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::CoroSizeOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CoroSuspendOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CoroSuspendOpGenericAdaptorBase::CoroSuspendOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.coro.suspend", odsAttrs.getContext());
}

CoroSuspendOpGenericAdaptorBase::CoroSuspendOpGenericAdaptorBase(CoroSuspendOp op) : CoroSuspendOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> CoroSuspendOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr CoroSuspendOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
CoroSuspendOpAdaptor::CoroSuspendOpAdaptor(CoroSuspendOp op) : CoroSuspendOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult CoroSuspendOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CoroSuspendOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range CoroSuspendOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CoroSuspendOp::getSave() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::IntegerType> CoroSuspendOp::getFinal() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
}

::mlir::OpOperand &CoroSuspendOp::getSaveMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &CoroSuspendOp::getFinalMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> CoroSuspendOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CoroSuspendOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CoroSuspendOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void CoroSuspendOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value save, ::mlir::Value final) {
  odsState.addOperands(save);
  odsState.addOperands(final);
  odsState.addTypes(res);
}

void CoroSuspendOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value save, ::mlir::Value final) {
  odsState.addOperands(save);
  odsState.addOperands(final);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CoroSuspendOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult CoroSuspendOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CoroSuspendOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult CoroSuspendOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand saveRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> saveOperands(saveRawOperands);  ::llvm::SMLoc saveOperandsLoc;
  (void)saveOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand finalRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> finalOperands(finalRawOperands);  ::llvm::SMLoc finalOperandsLoc;
  (void)finalOperandsLoc;
  ::mlir::Type resRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> resTypes(resRawTypes);

  saveOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(saveRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  finalOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(finalRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawTypes[0] = type;
  }
  ::mlir::Type odsBuildableType0 = ::mlir::LLVM::LLVMTokenType::get(parser.getBuilder().getContext());
  ::mlir::Type odsBuildableType1 = parser.getBuilder().getIntegerType(1);
  result.addTypes(resTypes);
  if (parser.resolveOperands(saveOperands, odsBuildableType0, saveOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(finalOperands, odsBuildableType1, finalOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CoroSuspendOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getSave();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getFinal();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::CoroSuspendOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CosOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CosOpGenericAdaptorBase::CosOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.cos", odsAttrs.getContext());
}

CosOpGenericAdaptorBase::CosOpGenericAdaptorBase(CosOp op) : CosOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> CosOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr CosOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr CosOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags CosOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
CosOpAdaptor::CosOpAdaptor(CosOp op) : CosOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult CosOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.cos' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CosOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range CosOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CosOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &CosOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> CosOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CosOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CosOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult CosOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute CosOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code CosOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> CosOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void CosOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void CosOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult CosOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult CosOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void CosOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr CosOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags CosOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void CosOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void CosOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void CosOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void CosOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(CosOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void CosOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CosOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void CosOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(CosOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void CosOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CosOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void CosOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(CosOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void CosOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult CosOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CosOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult CosOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult CosOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CosOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void CosOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::CosOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CountLeadingZerosOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CountLeadingZerosOpGenericAdaptorBase::CountLeadingZerosOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.ctlz", odsAttrs.getContext());
}

CountLeadingZerosOpGenericAdaptorBase::CountLeadingZerosOpGenericAdaptorBase(CountLeadingZerosOp op) : CountLeadingZerosOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> CountLeadingZerosOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr CountLeadingZerosOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr CountLeadingZerosOpGenericAdaptorBase::getIsZeroPoisonAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().is_zero_poison);
  return attr;
}

bool CountLeadingZerosOpGenericAdaptorBase::getIsZeroPoison() {
  auto attr = getIsZeroPoisonAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
CountLeadingZerosOpAdaptor::CountLeadingZerosOpAdaptor(CountLeadingZerosOp op) : CountLeadingZerosOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult CountLeadingZerosOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_is_zero_poison = getProperties().is_zero_poison; (void)tblgen_is_zero_poison;
  if (!tblgen_is_zero_poison) return emitError(loc, "'llvm.intr.ctlz' op ""requires attribute 'is_zero_poison'");

  if (tblgen_is_zero_poison && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_is_zero_poison))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_is_zero_poison).getType().isSignlessInteger(1)))))
    return emitError(loc, "'llvm.intr.ctlz' op ""attribute 'is_zero_poison' failed to satisfy constraint: 1-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CountLeadingZerosOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range CountLeadingZerosOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CountLeadingZerosOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &CountLeadingZerosOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> CountLeadingZerosOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CountLeadingZerosOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CountLeadingZerosOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult CountLeadingZerosOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.is_zero_poison;
       auto attr = dict.get("is_zero_poison");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for is_zero_poison in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `is_zero_poison` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute CountLeadingZerosOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.is_zero_poison;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("is_zero_poison",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code CountLeadingZerosOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.is_zero_poison.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> CountLeadingZerosOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "is_zero_poison")
      return prop.is_zero_poison;
  return std::nullopt;
}

void CountLeadingZerosOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "is_zero_poison") {
       prop.is_zero_poison = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.is_zero_poison)>>(value);
       return;
    }
}

void CountLeadingZerosOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.is_zero_poison) attrs.append("is_zero_poison", prop.is_zero_poison);
}

::mlir::LogicalResult CountLeadingZerosOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getIsZeroPoisonAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(attr, "is_zero_poison", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult CountLeadingZerosOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.is_zero_poison)))
    return ::mlir::failure();
  return ::mlir::success();
}

void CountLeadingZerosOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.is_zero_poison);
}

::mlir::IntegerAttr CountLeadingZerosOp::getIsZeroPoisonAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().is_zero_poison);
}

bool CountLeadingZerosOp::getIsZeroPoison() {
  auto attr = getIsZeroPoisonAttr();
  return attr.getValue().getZExtValue();
}

void CountLeadingZerosOp::setIsZeroPoisonAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getIsZeroPoisonAttrName(), attr);
}

void CountLeadingZerosOp::setIsZeroPoison(bool attrValue) {
  (*this)->setAttr(getIsZeroPoisonAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(1), attrValue));
}

void CountLeadingZerosOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::IntegerAttr is_zero_poison) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().is_zero_poison = is_zero_poison;
  odsState.addTypes(res);
}

void CountLeadingZerosOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::IntegerAttr is_zero_poison) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().is_zero_poison = is_zero_poison;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CountLeadingZerosOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, bool is_zero_poison) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().is_zero_poison = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), is_zero_poison);
  odsState.addTypes(res);
}

void CountLeadingZerosOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, bool is_zero_poison) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().is_zero_poison = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), is_zero_poison);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CountLeadingZerosOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult CountLeadingZerosOp::verifyInvariantsImpl() {
  auto tblgen_is_zero_poison = getProperties().is_zero_poison; (void)tblgen_is_zero_poison;
  if (!tblgen_is_zero_poison) return emitOpError("requires attribute 'is_zero_poison'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(*this, tblgen_is_zero_poison, "is_zero_poison")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CountLeadingZerosOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

void CountLeadingZerosOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::CountLeadingZerosOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CountTrailingZerosOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CountTrailingZerosOpGenericAdaptorBase::CountTrailingZerosOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.cttz", odsAttrs.getContext());
}

CountTrailingZerosOpGenericAdaptorBase::CountTrailingZerosOpGenericAdaptorBase(CountTrailingZerosOp op) : CountTrailingZerosOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> CountTrailingZerosOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr CountTrailingZerosOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr CountTrailingZerosOpGenericAdaptorBase::getIsZeroPoisonAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().is_zero_poison);
  return attr;
}

bool CountTrailingZerosOpGenericAdaptorBase::getIsZeroPoison() {
  auto attr = getIsZeroPoisonAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
CountTrailingZerosOpAdaptor::CountTrailingZerosOpAdaptor(CountTrailingZerosOp op) : CountTrailingZerosOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult CountTrailingZerosOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_is_zero_poison = getProperties().is_zero_poison; (void)tblgen_is_zero_poison;
  if (!tblgen_is_zero_poison) return emitError(loc, "'llvm.intr.cttz' op ""requires attribute 'is_zero_poison'");

  if (tblgen_is_zero_poison && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_is_zero_poison))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_is_zero_poison).getType().isSignlessInteger(1)))))
    return emitError(loc, "'llvm.intr.cttz' op ""attribute 'is_zero_poison' failed to satisfy constraint: 1-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CountTrailingZerosOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range CountTrailingZerosOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CountTrailingZerosOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &CountTrailingZerosOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> CountTrailingZerosOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CountTrailingZerosOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CountTrailingZerosOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult CountTrailingZerosOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.is_zero_poison;
       auto attr = dict.get("is_zero_poison");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for is_zero_poison in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `is_zero_poison` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute CountTrailingZerosOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.is_zero_poison;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("is_zero_poison",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code CountTrailingZerosOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.is_zero_poison.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> CountTrailingZerosOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "is_zero_poison")
      return prop.is_zero_poison;
  return std::nullopt;
}

void CountTrailingZerosOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "is_zero_poison") {
       prop.is_zero_poison = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.is_zero_poison)>>(value);
       return;
    }
}

void CountTrailingZerosOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.is_zero_poison) attrs.append("is_zero_poison", prop.is_zero_poison);
}

::mlir::LogicalResult CountTrailingZerosOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getIsZeroPoisonAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(attr, "is_zero_poison", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult CountTrailingZerosOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.is_zero_poison)))
    return ::mlir::failure();
  return ::mlir::success();
}

void CountTrailingZerosOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.is_zero_poison);
}

::mlir::IntegerAttr CountTrailingZerosOp::getIsZeroPoisonAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().is_zero_poison);
}

bool CountTrailingZerosOp::getIsZeroPoison() {
  auto attr = getIsZeroPoisonAttr();
  return attr.getValue().getZExtValue();
}

void CountTrailingZerosOp::setIsZeroPoisonAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getIsZeroPoisonAttrName(), attr);
}

void CountTrailingZerosOp::setIsZeroPoison(bool attrValue) {
  (*this)->setAttr(getIsZeroPoisonAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(1), attrValue));
}

void CountTrailingZerosOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::IntegerAttr is_zero_poison) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().is_zero_poison = is_zero_poison;
  odsState.addTypes(res);
}

void CountTrailingZerosOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::IntegerAttr is_zero_poison) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().is_zero_poison = is_zero_poison;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CountTrailingZerosOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, bool is_zero_poison) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().is_zero_poison = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), is_zero_poison);
  odsState.addTypes(res);
}

void CountTrailingZerosOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, bool is_zero_poison) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().is_zero_poison = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), is_zero_poison);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CountTrailingZerosOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult CountTrailingZerosOp::verifyInvariantsImpl() {
  auto tblgen_is_zero_poison = getProperties().is_zero_poison; (void)tblgen_is_zero_poison;
  if (!tblgen_is_zero_poison) return emitOpError("requires attribute 'is_zero_poison'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(*this, tblgen_is_zero_poison, "is_zero_poison")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CountTrailingZerosOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

void CountTrailingZerosOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::CountTrailingZerosOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::CtPopOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CtPopOpGenericAdaptorBase::CtPopOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.ctpop", odsAttrs.getContext());
}

CtPopOpGenericAdaptorBase::CtPopOpGenericAdaptorBase(CtPopOp op) : CtPopOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> CtPopOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr CtPopOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
CtPopOpAdaptor::CtPopOpAdaptor(CtPopOp op) : CtPopOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult CtPopOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CtPopOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range CtPopOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CtPopOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &CtPopOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> CtPopOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CtPopOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CtPopOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void CtPopOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in) {
  odsState.addOperands(in);
  odsState.addTypes(res);
}

void CtPopOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in) {
  odsState.addOperands(in);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(CtPopOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void CtPopOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in) {
  odsState.addOperands(in);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CtPopOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void CtPopOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(CtPopOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult CtPopOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CtPopOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult CtPopOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult CtPopOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CtPopOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void CtPopOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::CtPopOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::DbgDeclareOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DbgDeclareOpGenericAdaptorBase::DbgDeclareOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.dbg.declare", odsAttrs.getContext());
}

DbgDeclareOpGenericAdaptorBase::DbgDeclareOpGenericAdaptorBase(DbgDeclareOp op) : DbgDeclareOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> DbgDeclareOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr DbgDeclareOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::DILocalVariableAttr DbgDeclareOpGenericAdaptorBase::getVarInfoAttr() {
  auto attr = ::llvm::cast<::mlir::LLVM::DILocalVariableAttr>(getProperties().varInfo);
  return attr;
}

::mlir::LLVM::DILocalVariableAttr DbgDeclareOpGenericAdaptorBase::getVarInfo() {
  auto attr = getVarInfoAttr();
  return ::llvm::cast<::mlir::LLVM::DILocalVariableAttr>(attr);
}

} // namespace detail
DbgDeclareOpAdaptor::DbgDeclareOpAdaptor(DbgDeclareOp op) : DbgDeclareOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult DbgDeclareOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_varInfo = getProperties().varInfo; (void)tblgen_varInfo;
  if (!tblgen_varInfo) return emitError(loc, "'llvm.intr.dbg.declare' op ""requires attribute 'varInfo'");

  if (tblgen_varInfo && !((::llvm::isa<::mlir::LLVM::DILocalVariableAttr>(tblgen_varInfo))))
    return emitError(loc, "'llvm.intr.dbg.declare' op ""attribute 'varInfo' failed to satisfy constraint: ");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DbgDeclareOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range DbgDeclareOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> DbgDeclareOp::getAddr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
}

::mlir::OpOperand &DbgDeclareOp::getAddrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> DbgDeclareOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range DbgDeclareOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult DbgDeclareOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.varInfo;
       auto attr = dict.get("varInfo");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for varInfo in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `varInfo` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute DbgDeclareOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.varInfo;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("varInfo",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code DbgDeclareOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.varInfo.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> DbgDeclareOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "varInfo")
      return prop.varInfo;
  return std::nullopt;
}

void DbgDeclareOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "varInfo") {
       prop.varInfo = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.varInfo)>>(value);
       return;
    }
}

void DbgDeclareOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.varInfo) attrs.append("varInfo", prop.varInfo);
}

::mlir::LogicalResult DbgDeclareOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getVarInfoAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps2(attr, "varInfo", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult DbgDeclareOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.varInfo)))
    return ::mlir::failure();
  return ::mlir::success();
}

void DbgDeclareOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.varInfo);
}

::mlir::LLVM::DILocalVariableAttr DbgDeclareOp::getVarInfoAttr() {
  return ::llvm::cast<::mlir::LLVM::DILocalVariableAttr>(getProperties().varInfo);
}

::mlir::LLVM::DILocalVariableAttr DbgDeclareOp::getVarInfo() {
  auto attr = getVarInfoAttr();
  return ::llvm::cast<::mlir::LLVM::DILocalVariableAttr>(attr);
}

void DbgDeclareOp::setVarInfoAttr(::mlir::LLVM::DILocalVariableAttr attr) {
  (*this)->setAttr(getVarInfoAttrName(), attr);
}

void DbgDeclareOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value addr, ::mlir::LLVM::DILocalVariableAttr varInfo) {
  odsState.addOperands(addr);
  odsState.getOrAddProperties<Properties>().varInfo = varInfo;
}

void DbgDeclareOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value addr, ::mlir::LLVM::DILocalVariableAttr varInfo) {
  odsState.addOperands(addr);
  odsState.getOrAddProperties<Properties>().varInfo = varInfo;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DbgDeclareOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult DbgDeclareOp::verifyInvariantsImpl() {
  auto tblgen_varInfo = getProperties().varInfo; (void)tblgen_varInfo;
  if (!tblgen_varInfo) return emitOpError("requires attribute 'varInfo'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps2(*this, tblgen_varInfo, "varInfo")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult DbgDeclareOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult DbgDeclareOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::DILocalVariableAttr varInfoAttr;
  ::mlir::OpAsmParser::UnresolvedOperand addrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> addrOperands(addrRawOperands);  ::llvm::SMLoc addrOperandsLoc;
  (void)addrOperandsLoc;
  ::mlir::Type addrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> addrTypes(addrRawTypes);

  if (parser.parseAttribute(varInfoAttr, ::mlir::Type{}))
    return ::mlir::failure();
  if (varInfoAttr) result.getOrAddProperties<DbgDeclareOp::Properties>().varInfo = varInfoAttr;
  if (parser.parseEqual())
    return ::mlir::failure();

  addrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(addrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(addrRawTypes[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.resolveOperands(addrOperands, addrTypes, addrOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void DbgDeclareOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printAttribute(getVarInfoAttr());
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
  _odsPrinter << getAddr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getAddr().getType();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("varInfo");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::DbgDeclareOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::DbgLabelOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DbgLabelOpGenericAdaptorBase::DbgLabelOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.dbg.label", odsAttrs.getContext());
}

DbgLabelOpGenericAdaptorBase::DbgLabelOpGenericAdaptorBase(DbgLabelOp op) : DbgLabelOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> DbgLabelOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr DbgLabelOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::DILabelAttr DbgLabelOpGenericAdaptorBase::getLabelAttr() {
  auto attr = ::llvm::cast<::mlir::LLVM::DILabelAttr>(getProperties().label);
  return attr;
}

::mlir::LLVM::DILabelAttr DbgLabelOpGenericAdaptorBase::getLabel() {
  auto attr = getLabelAttr();
  return ::llvm::cast<::mlir::LLVM::DILabelAttr>(attr);
}

} // namespace detail
DbgLabelOpAdaptor::DbgLabelOpAdaptor(DbgLabelOp op) : DbgLabelOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult DbgLabelOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_label = getProperties().label; (void)tblgen_label;
  if (!tblgen_label) return emitError(loc, "'llvm.intr.dbg.label' op ""requires attribute 'label'");

  if (tblgen_label && !((::llvm::isa<::mlir::LLVM::DILabelAttr>(tblgen_label))))
    return emitError(loc, "'llvm.intr.dbg.label' op ""attribute 'label' failed to satisfy constraint: ");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DbgLabelOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range DbgLabelOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> DbgLabelOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range DbgLabelOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult DbgLabelOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.label;
       auto attr = dict.get("label");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for label in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `label` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute DbgLabelOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.label;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("label",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code DbgLabelOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.label.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> DbgLabelOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "label")
      return prop.label;
  return std::nullopt;
}

void DbgLabelOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "label") {
       prop.label = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.label)>>(value);
       return;
    }
}

void DbgLabelOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.label) attrs.append("label", prop.label);
}

::mlir::LogicalResult DbgLabelOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getLabelAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps3(attr, "label", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult DbgLabelOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.label)))
    return ::mlir::failure();
  return ::mlir::success();
}

void DbgLabelOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.label);
}

::mlir::LLVM::DILabelAttr DbgLabelOp::getLabelAttr() {
  return ::llvm::cast<::mlir::LLVM::DILabelAttr>(getProperties().label);
}

::mlir::LLVM::DILabelAttr DbgLabelOp::getLabel() {
  auto attr = getLabelAttr();
  return ::llvm::cast<::mlir::LLVM::DILabelAttr>(attr);
}

void DbgLabelOp::setLabelAttr(::mlir::LLVM::DILabelAttr attr) {
  (*this)->setAttr(getLabelAttrName(), attr);
}

void DbgLabelOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::LLVM::DILabelAttr label) {
  odsState.getOrAddProperties<Properties>().label = label;
}

void DbgLabelOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::LLVM::DILabelAttr label) {
  odsState.getOrAddProperties<Properties>().label = label;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DbgLabelOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult DbgLabelOp::verifyInvariantsImpl() {
  auto tblgen_label = getProperties().label; (void)tblgen_label;
  if (!tblgen_label) return emitOpError("requires attribute 'label'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps3(*this, tblgen_label, "label")))
    return ::mlir::failure();
  return ::mlir::success();
}

::mlir::LogicalResult DbgLabelOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult DbgLabelOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::DILabelAttr labelAttr;

  if (parser.parseCustomAttributeWithFallback(labelAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (labelAttr) result.getOrAddProperties<DbgLabelOp::Properties>().label = labelAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void DbgLabelOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
_odsPrinter.printStrippedAttrOrType(getLabelAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("label");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::DbgLabelOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::DbgValueOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DbgValueOpGenericAdaptorBase::DbgValueOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.dbg.value", odsAttrs.getContext());
}

DbgValueOpGenericAdaptorBase::DbgValueOpGenericAdaptorBase(DbgValueOp op) : DbgValueOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> DbgValueOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr DbgValueOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::DILocalVariableAttr DbgValueOpGenericAdaptorBase::getVarInfoAttr() {
  auto attr = ::llvm::cast<::mlir::LLVM::DILocalVariableAttr>(getProperties().varInfo);
  return attr;
}

::mlir::LLVM::DILocalVariableAttr DbgValueOpGenericAdaptorBase::getVarInfo() {
  auto attr = getVarInfoAttr();
  return ::llvm::cast<::mlir::LLVM::DILocalVariableAttr>(attr);
}

} // namespace detail
DbgValueOpAdaptor::DbgValueOpAdaptor(DbgValueOp op) : DbgValueOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult DbgValueOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_varInfo = getProperties().varInfo; (void)tblgen_varInfo;
  if (!tblgen_varInfo) return emitError(loc, "'llvm.intr.dbg.value' op ""requires attribute 'varInfo'");

  if (tblgen_varInfo && !((::llvm::isa<::mlir::LLVM::DILocalVariableAttr>(tblgen_varInfo))))
    return emitError(loc, "'llvm.intr.dbg.value' op ""attribute 'varInfo' failed to satisfy constraint: ");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DbgValueOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range DbgValueOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value DbgValueOp::getValue() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &DbgValueOp::getValueMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> DbgValueOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range DbgValueOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult DbgValueOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.varInfo;
       auto attr = dict.get("varInfo");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for varInfo in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `varInfo` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute DbgValueOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.varInfo;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("varInfo",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code DbgValueOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.varInfo.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> DbgValueOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "varInfo")
      return prop.varInfo;
  return std::nullopt;
}

void DbgValueOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "varInfo") {
       prop.varInfo = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.varInfo)>>(value);
       return;
    }
}

void DbgValueOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.varInfo) attrs.append("varInfo", prop.varInfo);
}

::mlir::LogicalResult DbgValueOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getVarInfoAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps2(attr, "varInfo", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult DbgValueOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.varInfo)))
    return ::mlir::failure();
  return ::mlir::success();
}

void DbgValueOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.varInfo);
}

::mlir::LLVM::DILocalVariableAttr DbgValueOp::getVarInfoAttr() {
  return ::llvm::cast<::mlir::LLVM::DILocalVariableAttr>(getProperties().varInfo);
}

::mlir::LLVM::DILocalVariableAttr DbgValueOp::getVarInfo() {
  auto attr = getVarInfoAttr();
  return ::llvm::cast<::mlir::LLVM::DILocalVariableAttr>(attr);
}

void DbgValueOp::setVarInfoAttr(::mlir::LLVM::DILocalVariableAttr attr) {
  (*this)->setAttr(getVarInfoAttrName(), attr);
}

void DbgValueOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::LLVM::DILocalVariableAttr varInfo) {
  odsState.addOperands(value);
  odsState.getOrAddProperties<Properties>().varInfo = varInfo;
}

void DbgValueOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::LLVM::DILocalVariableAttr varInfo) {
  odsState.addOperands(value);
  odsState.getOrAddProperties<Properties>().varInfo = varInfo;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DbgValueOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult DbgValueOp::verifyInvariantsImpl() {
  auto tblgen_varInfo = getProperties().varInfo; (void)tblgen_varInfo;
  if (!tblgen_varInfo) return emitOpError("requires attribute 'varInfo'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps2(*this, tblgen_varInfo, "varInfo")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult DbgValueOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult DbgValueOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::DILocalVariableAttr varInfoAttr;
  ::mlir::OpAsmParser::UnresolvedOperand valueRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> valueOperands(valueRawOperands);  ::llvm::SMLoc valueOperandsLoc;
  (void)valueOperandsLoc;
  ::mlir::Type valueRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> valueTypes(valueRawTypes);

  if (parser.parseAttribute(varInfoAttr, ::mlir::Type{}))
    return ::mlir::failure();
  if (varInfoAttr) result.getOrAddProperties<DbgValueOp::Properties>().varInfo = varInfoAttr;
  if (parser.parseEqual())
    return ::mlir::failure();

  valueOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(valueRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(valueRawTypes[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.resolveOperands(valueOperands, valueTypes, valueOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void DbgValueOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printAttribute(getVarInfoAttr());
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
  _odsPrinter << getValue();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getValue().getType();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("varInfo");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::DbgValueOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::DebugTrap definitions
//===----------------------------------------------------------------------===//

namespace detail {
DebugTrapGenericAdaptorBase::DebugTrapGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.debugtrap", odsAttrs.getContext());
}

DebugTrapGenericAdaptorBase::DebugTrapGenericAdaptorBase(DebugTrap op) : DebugTrapGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> DebugTrapGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr DebugTrapGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
DebugTrapAdaptor::DebugTrapAdaptor(DebugTrap op) : DebugTrapGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult DebugTrapAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DebugTrap::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range DebugTrap::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> DebugTrap::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range DebugTrap::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void DebugTrap::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState) {
}

void DebugTrap::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes) {
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DebugTrap::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult DebugTrap::verifyInvariantsImpl() {
  return ::mlir::success();
}

::mlir::LogicalResult DebugTrap::verifyInvariants() {
  return verifyInvariantsImpl();
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::DebugTrap)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::EhTypeidForOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
EhTypeidForOpGenericAdaptorBase::EhTypeidForOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.eh.typeid.for", odsAttrs.getContext());
}

EhTypeidForOpGenericAdaptorBase::EhTypeidForOpGenericAdaptorBase(EhTypeidForOp op) : EhTypeidForOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> EhTypeidForOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr EhTypeidForOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
EhTypeidForOpAdaptor::EhTypeidForOpAdaptor(EhTypeidForOp op) : EhTypeidForOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult EhTypeidForOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> EhTypeidForOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range EhTypeidForOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value EhTypeidForOp::getTypeInfo() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &EhTypeidForOp::getTypeInfoMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> EhTypeidForOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range EhTypeidForOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value EhTypeidForOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void EhTypeidForOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value type_info) {
  odsState.addOperands(type_info);
  odsState.addTypes(res);
}

void EhTypeidForOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value type_info) {
  odsState.addOperands(type_info);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void EhTypeidForOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult EhTypeidForOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult EhTypeidForOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult EhTypeidForOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand type_infoRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> type_infoOperands(type_infoRawOperands);  ::llvm::SMLoc type_infoOperandsLoc;
  (void)type_infoOperandsLoc;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  type_infoOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(type_infoRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(type_infoOperands, allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void EhTypeidForOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getTypeInfo();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::EhTypeidForOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::Exp2Op definitions
//===----------------------------------------------------------------------===//

namespace detail {
Exp2OpGenericAdaptorBase::Exp2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.exp2", odsAttrs.getContext());
}

Exp2OpGenericAdaptorBase::Exp2OpGenericAdaptorBase(Exp2Op op) : Exp2OpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> Exp2OpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr Exp2OpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr Exp2OpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags Exp2OpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
Exp2OpAdaptor::Exp2OpAdaptor(Exp2Op op) : Exp2OpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult Exp2OpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.exp2' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> Exp2Op::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range Exp2Op::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value Exp2Op::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &Exp2Op::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> Exp2Op::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range Exp2Op::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value Exp2Op::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult Exp2Op::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute Exp2Op::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code Exp2Op::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> Exp2Op::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void Exp2Op::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void Exp2Op::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult Exp2Op::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult Exp2Op::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void Exp2Op::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr Exp2Op::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags Exp2Op::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void Exp2Op::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void Exp2Op::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void Exp2Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void Exp2Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(Exp2Op::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void Exp2Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void Exp2Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void Exp2Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(Exp2Op::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void Exp2Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void Exp2Op::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void Exp2Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(Exp2Op::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void Exp2Op::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult Exp2Op::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult Exp2Op::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult Exp2Op::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult Exp2Op::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void Exp2Op::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void Exp2Op::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::Exp2Op)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::ExpOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExpOpGenericAdaptorBase::ExpOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.exp", odsAttrs.getContext());
}

ExpOpGenericAdaptorBase::ExpOpGenericAdaptorBase(ExpOp op) : ExpOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> ExpOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr ExpOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr ExpOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags ExpOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
ExpOpAdaptor::ExpOpAdaptor(ExpOp op) : ExpOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult ExpOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.exp' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExpOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range ExpOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value ExpOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &ExpOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> ExpOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range ExpOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value ExpOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult ExpOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExpOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExpOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExpOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void ExpOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void ExpOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult ExpOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult ExpOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExpOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr ExpOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags ExpOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void ExpOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void ExpOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void ExpOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void ExpOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(ExpOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void ExpOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ExpOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void ExpOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(ExpOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void ExpOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ExpOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void ExpOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(ExpOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void ExpOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult ExpOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult ExpOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult ExpOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult ExpOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExpOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void ExpOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::ExpOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::ExpectOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExpectOpGenericAdaptorBase::ExpectOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.expect", odsAttrs.getContext());
}

ExpectOpGenericAdaptorBase::ExpectOpGenericAdaptorBase(ExpectOp op) : ExpectOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> ExpectOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr ExpectOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
ExpectOpAdaptor::ExpectOpAdaptor(ExpectOp op) : ExpectOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult ExpectOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExpectOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range ExpectOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::IntegerType> ExpectOp::getVal() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::IntegerType> ExpectOp::getExpected() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
}

::mlir::OpOperand &ExpectOp::getValMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &ExpectOp::getExpectedMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> ExpectOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range ExpectOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value ExpectOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void ExpectOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value val, ::mlir::Value expected) {
  odsState.addOperands(val);
  odsState.addOperands(expected);
  odsState.addTypes(res);
}

void ExpectOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value val, ::mlir::Value expected) {
  odsState.addOperands(val);
  odsState.addOperands(expected);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(ExpectOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void ExpectOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val, ::mlir::Value expected) {
  odsState.addOperands(val);
  odsState.addOperands(expected);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ExpectOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void ExpectOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(ExpectOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult ExpectOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult ExpectOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult ExpectOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult ExpectOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand valRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> valOperands(valRawOperands);  ::llvm::SMLoc valOperandsLoc;
  (void)valOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand expectedRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> expectedOperands(expectedRawOperands);  ::llvm::SMLoc expectedOperandsLoc;
  (void)expectedOperandsLoc;
  ::mlir::Type valRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> valTypes(valRawTypes);

  valOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(valRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  expectedOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(expectedRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::IntegerType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    valRawTypes[0] = type;
  }
  result.addTypes(valTypes[0]);
  if (parser.resolveOperands(valOperands, valTypes, valOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(expectedOperands, valTypes[0], expectedOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExpectOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getVal();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getExpected();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getVal().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::IntegerType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExpectOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::ExpectOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::ExpectWithProbabilityOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExpectWithProbabilityOpGenericAdaptorBase::ExpectWithProbabilityOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.expect.with.probability", odsAttrs.getContext());
}

ExpectWithProbabilityOpGenericAdaptorBase::ExpectWithProbabilityOpGenericAdaptorBase(ExpectWithProbabilityOp op) : ExpectWithProbabilityOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> ExpectWithProbabilityOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr ExpectWithProbabilityOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::FloatAttr ExpectWithProbabilityOpGenericAdaptorBase::getProbAttr() {
  auto attr = ::llvm::cast<::mlir::FloatAttr>(getProperties().prob);
  return attr;
}

::llvm::APFloat ExpectWithProbabilityOpGenericAdaptorBase::getProb() {
  auto attr = getProbAttr();
  return attr.getValue();
}

} // namespace detail
ExpectWithProbabilityOpAdaptor::ExpectWithProbabilityOpAdaptor(ExpectWithProbabilityOp op) : ExpectWithProbabilityOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult ExpectWithProbabilityOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_prob = getProperties().prob; (void)tblgen_prob;
  if (!tblgen_prob) return emitError(loc, "'llvm.intr.expect.with.probability' op ""requires attribute 'prob'");

  if (tblgen_prob && !(((::llvm::isa<::mlir::FloatAttr>(tblgen_prob))) && ((::llvm::cast<::mlir::FloatAttr>(tblgen_prob).getType().isF64()))))
    return emitError(loc, "'llvm.intr.expect.with.probability' op ""attribute 'prob' failed to satisfy constraint: 64-bit float attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExpectWithProbabilityOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range ExpectWithProbabilityOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::IntegerType> ExpectWithProbabilityOp::getVal() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::IntegerType> ExpectWithProbabilityOp::getExpected() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
}

::mlir::OpOperand &ExpectWithProbabilityOp::getValMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &ExpectWithProbabilityOp::getExpectedMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> ExpectWithProbabilityOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range ExpectWithProbabilityOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value ExpectWithProbabilityOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult ExpectWithProbabilityOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.prob;
       auto attr = dict.get("prob");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for prob in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `prob` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ExpectWithProbabilityOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.prob;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("prob",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExpectWithProbabilityOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.prob.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ExpectWithProbabilityOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "prob")
      return prop.prob;
  return std::nullopt;
}

void ExpectWithProbabilityOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "prob") {
       prop.prob = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.prob)>>(value);
       return;
    }
}

void ExpectWithProbabilityOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.prob) attrs.append("prob", prop.prob);
}

::mlir::LogicalResult ExpectWithProbabilityOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getProbAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps4(attr, "prob", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult ExpectWithProbabilityOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.prob)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExpectWithProbabilityOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.prob);
}

::mlir::FloatAttr ExpectWithProbabilityOp::getProbAttr() {
  return ::llvm::cast<::mlir::FloatAttr>(getProperties().prob);
}

::llvm::APFloat ExpectWithProbabilityOp::getProb() {
  auto attr = getProbAttr();
  return attr.getValue();
}

void ExpectWithProbabilityOp::setProbAttr(::mlir::FloatAttr attr) {
  (*this)->setAttr(getProbAttrName(), attr);
}

void ExpectWithProbabilityOp::setProb(::llvm::APFloat attrValue) {
  (*this)->setAttr(getProbAttrName(), ::mlir::Builder((*this)->getContext()).getFloatAttr(::mlir::Builder((*this)->getContext()).getF64Type(), attrValue));
}

void ExpectWithProbabilityOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value val, ::mlir::Value expected, ::mlir::FloatAttr prob) {
  odsState.addOperands(val);
  odsState.addOperands(expected);
  odsState.getOrAddProperties<Properties>().prob = prob;
  odsState.addTypes(res);
}

void ExpectWithProbabilityOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value val, ::mlir::Value expected, ::mlir::FloatAttr prob) {
  odsState.addOperands(val);
  odsState.addOperands(expected);
  odsState.getOrAddProperties<Properties>().prob = prob;

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(ExpectWithProbabilityOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void ExpectWithProbabilityOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val, ::mlir::Value expected, ::mlir::FloatAttr prob) {
  odsState.addOperands(val);
  odsState.addOperands(expected);
  odsState.getOrAddProperties<Properties>().prob = prob;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ExpectWithProbabilityOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value val, ::mlir::Value expected, ::llvm::APFloat prob) {
  odsState.addOperands(val);
  odsState.addOperands(expected);
  odsState.getOrAddProperties<Properties>().prob = odsBuilder.getFloatAttr(odsBuilder.getF64Type(), prob);
  odsState.addTypes(res);
}

void ExpectWithProbabilityOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value val, ::mlir::Value expected, ::llvm::APFloat prob) {
  odsState.addOperands(val);
  odsState.addOperands(expected);
  odsState.getOrAddProperties<Properties>().prob = odsBuilder.getFloatAttr(odsBuilder.getF64Type(), prob);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(ExpectWithProbabilityOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void ExpectWithProbabilityOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val, ::mlir::Value expected, ::llvm::APFloat prob) {
  odsState.addOperands(val);
  odsState.addOperands(expected);
  odsState.getOrAddProperties<Properties>().prob = odsBuilder.getFloatAttr(odsBuilder.getF64Type(), prob);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ExpectWithProbabilityOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void ExpectWithProbabilityOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(ExpectWithProbabilityOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult ExpectWithProbabilityOp::verifyInvariantsImpl() {
  auto tblgen_prob = getProperties().prob; (void)tblgen_prob;
  if (!tblgen_prob) return emitOpError("requires attribute 'prob'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps4(*this, tblgen_prob, "prob")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  if (!((((*this->getODSOperands(0).begin()).getType()) == ((*this->getODSOperands(1).begin()).getType()) && ((*this->getODSOperands(1).begin()).getType()) == ((*this->getODSResults(0).begin()).getType()) && ((*this->getODSResults(0).begin()).getType()) == ((*this->getODSOperands(0).begin()).getType()))))
    return emitOpError("failed to verify that all of {val, expected, res} have same type");
  return ::mlir::success();
}

::mlir::LogicalResult ExpectWithProbabilityOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult ExpectWithProbabilityOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[1].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult ExpectWithProbabilityOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand valRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> valOperands(valRawOperands);  ::llvm::SMLoc valOperandsLoc;
  (void)valOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand expectedRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> expectedOperands(expectedRawOperands);  ::llvm::SMLoc expectedOperandsLoc;
  (void)expectedOperandsLoc;
  ::mlir::FloatAttr probAttr;
  ::mlir::Type valRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> valTypes(valRawTypes);

  valOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(valRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  expectedOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(expectedRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(probAttr, parser.getBuilder().getF64Type())) {
    return ::mlir::failure();
  }
  if (probAttr) result.getOrAddProperties<ExpectWithProbabilityOp::Properties>().prob = probAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::IntegerType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    valRawTypes[0] = type;
  }
  result.addTypes(valTypes[0]);
  if (parser.resolveOperands(valOperands, valTypes, valOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(expectedOperands, valTypes[0], expectedOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExpectWithProbabilityOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getVal();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getExpected();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getProbAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("prob");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getVal().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::IntegerType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ExpectWithProbabilityOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::ExpectWithProbabilityOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FAbsOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
FAbsOpGenericAdaptorBase::FAbsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.fabs", odsAttrs.getContext());
}

FAbsOpGenericAdaptorBase::FAbsOpGenericAdaptorBase(FAbsOp op) : FAbsOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> FAbsOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr FAbsOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr FAbsOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags FAbsOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
FAbsOpAdaptor::FAbsOpAdaptor(FAbsOp op) : FAbsOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult FAbsOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.fabs' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> FAbsOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range FAbsOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FAbsOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &FAbsOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> FAbsOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range FAbsOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FAbsOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult FAbsOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute FAbsOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code FAbsOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> FAbsOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void FAbsOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void FAbsOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult FAbsOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult FAbsOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void FAbsOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr FAbsOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags FAbsOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void FAbsOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void FAbsOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void FAbsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void FAbsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(FAbsOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void FAbsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FAbsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void FAbsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(FAbsOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void FAbsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FAbsOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FAbsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(FAbsOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void FAbsOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult FAbsOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult FAbsOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult FAbsOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult FAbsOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void FAbsOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void FAbsOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::FAbsOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FCeilOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
FCeilOpGenericAdaptorBase::FCeilOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.ceil", odsAttrs.getContext());
}

FCeilOpGenericAdaptorBase::FCeilOpGenericAdaptorBase(FCeilOp op) : FCeilOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> FCeilOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr FCeilOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr FCeilOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags FCeilOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
FCeilOpAdaptor::FCeilOpAdaptor(FCeilOp op) : FCeilOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult FCeilOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.ceil' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> FCeilOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range FCeilOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FCeilOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &FCeilOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> FCeilOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range FCeilOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FCeilOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult FCeilOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute FCeilOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code FCeilOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> FCeilOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void FCeilOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void FCeilOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult FCeilOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult FCeilOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void FCeilOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr FCeilOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags FCeilOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void FCeilOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void FCeilOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void FCeilOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void FCeilOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(FCeilOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void FCeilOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FCeilOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void FCeilOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(FCeilOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void FCeilOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FCeilOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FCeilOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(FCeilOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void FCeilOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult FCeilOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult FCeilOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult FCeilOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult FCeilOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void FCeilOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void FCeilOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::FCeilOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FFloorOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
FFloorOpGenericAdaptorBase::FFloorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.floor", odsAttrs.getContext());
}

FFloorOpGenericAdaptorBase::FFloorOpGenericAdaptorBase(FFloorOp op) : FFloorOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> FFloorOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr FFloorOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr FFloorOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags FFloorOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
FFloorOpAdaptor::FFloorOpAdaptor(FFloorOp op) : FFloorOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult FFloorOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.floor' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> FFloorOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range FFloorOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FFloorOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &FFloorOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> FFloorOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range FFloorOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FFloorOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult FFloorOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute FFloorOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code FFloorOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> FFloorOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void FFloorOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void FFloorOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult FFloorOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult FFloorOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void FFloorOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr FFloorOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags FFloorOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void FFloorOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void FFloorOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void FFloorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void FFloorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(FFloorOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void FFloorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FFloorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void FFloorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(FFloorOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void FFloorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FFloorOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FFloorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(FFloorOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void FFloorOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult FFloorOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult FFloorOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult FFloorOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult FFloorOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void FFloorOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void FFloorOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::FFloorOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FMAOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
FMAOpGenericAdaptorBase::FMAOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.fma", odsAttrs.getContext());
}

FMAOpGenericAdaptorBase::FMAOpGenericAdaptorBase(FMAOp op) : FMAOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> FMAOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr FMAOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr FMAOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags FMAOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
FMAOpAdaptor::FMAOpAdaptor(FMAOp op) : FMAOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult FMAOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.fma' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> FMAOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range FMAOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FMAOp::getA() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value FMAOp::getB() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::Value FMAOp::getC() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(2).begin());
}

::mlir::OpOperand &FMAOp::getAMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &FMAOp::getBMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &FMAOp::getCMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> FMAOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range FMAOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FMAOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult FMAOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute FMAOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code FMAOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> FMAOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void FMAOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void FMAOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult FMAOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult FMAOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void FMAOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr FMAOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags FMAOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void FMAOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void FMAOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void FMAOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void FMAOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(FMAOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void FMAOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FMAOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void FMAOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(FMAOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void FMAOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FMAOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FMAOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(FMAOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void FMAOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult FMAOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult FMAOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult FMAOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult FMAOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void FMAOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void FMAOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::FMAOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FMulAddOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
FMulAddOpGenericAdaptorBase::FMulAddOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.fmuladd", odsAttrs.getContext());
}

FMulAddOpGenericAdaptorBase::FMulAddOpGenericAdaptorBase(FMulAddOp op) : FMulAddOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> FMulAddOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr FMulAddOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr FMulAddOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags FMulAddOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
FMulAddOpAdaptor::FMulAddOpAdaptor(FMulAddOp op) : FMulAddOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult FMulAddOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.fmuladd' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> FMulAddOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range FMulAddOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FMulAddOp::getA() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value FMulAddOp::getB() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::Value FMulAddOp::getC() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(2).begin());
}

::mlir::OpOperand &FMulAddOp::getAMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &FMulAddOp::getBMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &FMulAddOp::getCMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> FMulAddOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range FMulAddOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FMulAddOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult FMulAddOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute FMulAddOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code FMulAddOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> FMulAddOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void FMulAddOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void FMulAddOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult FMulAddOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult FMulAddOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void FMulAddOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr FMulAddOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags FMulAddOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void FMulAddOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void FMulAddOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void FMulAddOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void FMulAddOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(FMulAddOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void FMulAddOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FMulAddOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void FMulAddOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(FMulAddOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void FMulAddOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FMulAddOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FMulAddOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(FMulAddOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void FMulAddOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult FMulAddOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult FMulAddOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult FMulAddOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult FMulAddOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void FMulAddOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void FMulAddOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::FMulAddOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FTruncOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
FTruncOpGenericAdaptorBase::FTruncOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.trunc", odsAttrs.getContext());
}

FTruncOpGenericAdaptorBase::FTruncOpGenericAdaptorBase(FTruncOp op) : FTruncOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> FTruncOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr FTruncOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr FTruncOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags FTruncOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
FTruncOpAdaptor::FTruncOpAdaptor(FTruncOp op) : FTruncOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult FTruncOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.trunc' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> FTruncOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range FTruncOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FTruncOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &FTruncOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> FTruncOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range FTruncOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FTruncOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult FTruncOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute FTruncOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code FTruncOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> FTruncOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void FTruncOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void FTruncOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult FTruncOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult FTruncOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void FTruncOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr FTruncOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags FTruncOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void FTruncOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void FTruncOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void FTruncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void FTruncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(FTruncOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void FTruncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FTruncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void FTruncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(FTruncOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void FTruncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FTruncOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FTruncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(FTruncOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void FTruncOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult FTruncOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult FTruncOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult FTruncOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult FTruncOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void FTruncOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void FTruncOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::FTruncOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FshlOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
FshlOpGenericAdaptorBase::FshlOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.fshl", odsAttrs.getContext());
}

FshlOpGenericAdaptorBase::FshlOpGenericAdaptorBase(FshlOp op) : FshlOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> FshlOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr FshlOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
FshlOpAdaptor::FshlOpAdaptor(FshlOp op) : FshlOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult FshlOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> FshlOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range FshlOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FshlOp::getA() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value FshlOp::getB() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::Value FshlOp::getC() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(2).begin());
}

::mlir::OpOperand &FshlOp::getAMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &FshlOp::getBMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &FshlOp::getCMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> FshlOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range FshlOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FshlOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void FshlOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  odsState.addTypes(res);
}

void FshlOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(FshlOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void FshlOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FshlOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FshlOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(FshlOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult FshlOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult FshlOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult FshlOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult FshlOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void FshlOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void FshlOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::FshlOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::FshrOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
FshrOpGenericAdaptorBase::FshrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.fshr", odsAttrs.getContext());
}

FshrOpGenericAdaptorBase::FshrOpGenericAdaptorBase(FshrOp op) : FshrOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> FshrOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr FshrOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
FshrOpAdaptor::FshrOpAdaptor(FshrOp op) : FshrOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult FshrOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> FshrOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range FshrOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FshrOp::getA() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value FshrOp::getB() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::Value FshrOp::getC() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(2).begin());
}

::mlir::OpOperand &FshrOp::getAMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &FshrOp::getBMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &FshrOp::getCMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> FshrOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range FshrOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value FshrOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void FshrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  odsState.addTypes(res);
}

void FshrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(FshrOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void FshrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addOperands(c);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FshrOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FshrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(FshrOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult FshrOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult FshrOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult FshrOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult FshrOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void FshrOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void FshrOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::FshrOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::GetActiveLaneMaskOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
GetActiveLaneMaskOpGenericAdaptorBase::GetActiveLaneMaskOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.get.active.lane.mask", odsAttrs.getContext());
}

GetActiveLaneMaskOpGenericAdaptorBase::GetActiveLaneMaskOpGenericAdaptorBase(GetActiveLaneMaskOp op) : GetActiveLaneMaskOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> GetActiveLaneMaskOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr GetActiveLaneMaskOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
GetActiveLaneMaskOpAdaptor::GetActiveLaneMaskOpAdaptor(GetActiveLaneMaskOp op) : GetActiveLaneMaskOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult GetActiveLaneMaskOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> GetActiveLaneMaskOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range GetActiveLaneMaskOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::IntegerType> GetActiveLaneMaskOp::getBase() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::IntegerType> GetActiveLaneMaskOp::getN() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
}

::mlir::OpOperand &GetActiveLaneMaskOp::getBaseMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &GetActiveLaneMaskOp::getNMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> GetActiveLaneMaskOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range GetActiveLaneMaskOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value GetActiveLaneMaskOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void GetActiveLaneMaskOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value base, ::mlir::Value n) {
  odsState.addOperands(base);
  odsState.addOperands(n);
  odsState.addTypes(res);
}

void GetActiveLaneMaskOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value base, ::mlir::Value n) {
  odsState.addOperands(base);
  odsState.addOperands(n);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GetActiveLaneMaskOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult GetActiveLaneMaskOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult GetActiveLaneMaskOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult GetActiveLaneMaskOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand baseRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> baseOperands(baseRawOperands);  ::llvm::SMLoc baseOperandsLoc;
  (void)baseOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand nRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> nOperands(nRawOperands);  ::llvm::SMLoc nOperandsLoc;
  (void)nOperandsLoc;
  ::mlir::Type baseRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> baseTypes(baseRawTypes);
  ::mlir::Type nRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> nTypes(nRawTypes);
  ::mlir::Type resRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> resTypes(resRawTypes);

  baseOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(baseRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  nOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(nRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::IntegerType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    baseRawTypes[0] = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::IntegerType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    nRawTypes[0] = type;
  }
  if (parser.parseKeyword("to"))
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawTypes[0] = type;
  }
  result.addTypes(resTypes);
  if (parser.resolveOperands(baseOperands, baseTypes, baseOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(nOperands, nTypes, nOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void GetActiveLaneMaskOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getBase();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getN();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getBase().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::IntegerType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getN().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::IntegerType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ' ' << "to";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void GetActiveLaneMaskOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::GetActiveLaneMaskOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::IsConstantOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
IsConstantOpGenericAdaptorBase::IsConstantOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.is.constant", odsAttrs.getContext());
}

IsConstantOpGenericAdaptorBase::IsConstantOpGenericAdaptorBase(IsConstantOp op) : IsConstantOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> IsConstantOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr IsConstantOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
IsConstantOpAdaptor::IsConstantOpAdaptor(IsConstantOp op) : IsConstantOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult IsConstantOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> IsConstantOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range IsConstantOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value IsConstantOp::getVal() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &IsConstantOp::getValMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> IsConstantOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range IsConstantOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::IntegerType> IsConstantOp::getRes() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSResults(0).begin());
}

void IsConstantOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value val) {
  odsState.addOperands(val);
  odsState.addTypes(res);
}

void IsConstantOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value val) {
  odsState.addOperands(val);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(IsConstantOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void IsConstantOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val) {
  odsState.addOperands(val);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void IsConstantOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void IsConstantOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(IsConstantOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult IsConstantOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult IsConstantOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult IsConstantOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = odsBuilder.getIntegerType(1);
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

void IsConstantOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::IsConstantOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::IsFPClass definitions
//===----------------------------------------------------------------------===//

namespace detail {
IsFPClassGenericAdaptorBase::IsFPClassGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.is.fpclass", odsAttrs.getContext());
}

IsFPClassGenericAdaptorBase::IsFPClassGenericAdaptorBase(IsFPClass op) : IsFPClassGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> IsFPClassGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr IsFPClassGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr IsFPClassGenericAdaptorBase::getBitAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().bit);
  return attr;
}

uint32_t IsFPClassGenericAdaptorBase::getBit() {
  auto attr = getBitAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
IsFPClassAdaptor::IsFPClassAdaptor(IsFPClass op) : IsFPClassGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult IsFPClassAdaptor::verify(::mlir::Location loc) {
  auto tblgen_bit = getProperties().bit; (void)tblgen_bit;
  if (!tblgen_bit) return emitError(loc, "'llvm.intr.is.fpclass' op ""requires attribute 'bit'");

  if (tblgen_bit && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_bit))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_bit).getType().isSignlessInteger(32)))))
    return emitError(loc, "'llvm.intr.is.fpclass' op ""attribute 'bit' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> IsFPClass::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range IsFPClass::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value IsFPClass::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &IsFPClass::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> IsFPClass::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range IsFPClass::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value IsFPClass::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult IsFPClass::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.bit;
       auto attr = dict.get("bit");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for bit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `bit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute IsFPClass::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.bit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("bit",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code IsFPClass::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.bit.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> IsFPClass::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "bit")
      return prop.bit;
  return std::nullopt;
}

void IsFPClass::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "bit") {
       prop.bit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.bit)>>(value);
       return;
    }
}

void IsFPClass::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.bit) attrs.append("bit", prop.bit);
}

::mlir::LogicalResult IsFPClass::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getBitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, "bit", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult IsFPClass::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.bit)))
    return ::mlir::failure();
  return ::mlir::success();
}

void IsFPClass::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.bit);
}

::mlir::IntegerAttr IsFPClass::getBitAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().bit);
}

uint32_t IsFPClass::getBit() {
  auto attr = getBitAttr();
  return attr.getValue().getZExtValue();
}

void IsFPClass::setBitAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getBitAttrName(), attr);
}

void IsFPClass::setBit(uint32_t attrValue) {
  (*this)->setAttr(getBitAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void IsFPClass::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::IntegerAttr bit) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().bit = bit;
  odsState.addTypes(res);
}

void IsFPClass::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::IntegerAttr bit) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().bit = bit;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void IsFPClass::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, uint32_t bit) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().bit = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), bit);
  odsState.addTypes(res);
}

void IsFPClass::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, uint32_t bit) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().bit = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), bit);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void IsFPClass::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult IsFPClass::verifyInvariantsImpl() {
  auto tblgen_bit = getProperties().bit; (void)tblgen_bit;
  if (!tblgen_bit) return emitOpError("requires attribute 'bit'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(*this, tblgen_bit, "bit")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult IsFPClass::verifyInvariants() {
  return verifyInvariantsImpl();
}

void IsFPClass::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::IsFPClass)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::LifetimeEndOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
LifetimeEndOpGenericAdaptorBase::LifetimeEndOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.lifetime.end", odsAttrs.getContext());
}

LifetimeEndOpGenericAdaptorBase::LifetimeEndOpGenericAdaptorBase(LifetimeEndOp op) : LifetimeEndOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> LifetimeEndOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr LifetimeEndOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr LifetimeEndOpGenericAdaptorBase::getSizeAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().size);
  return attr;
}

uint64_t LifetimeEndOpGenericAdaptorBase::getSize() {
  auto attr = getSizeAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
LifetimeEndOpAdaptor::LifetimeEndOpAdaptor(LifetimeEndOp op) : LifetimeEndOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult LifetimeEndOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_size = getProperties().size; (void)tblgen_size;
  if (!tblgen_size) return emitError(loc, "'llvm.intr.lifetime.end' op ""requires attribute 'size'");

  if (tblgen_size && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_size))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_size).getType().isSignlessInteger(64)))))
    return emitError(loc, "'llvm.intr.lifetime.end' op ""attribute 'size' failed to satisfy constraint: 64-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> LifetimeEndOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range LifetimeEndOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> LifetimeEndOp::getPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
}

::mlir::OpOperand &LifetimeEndOp::getPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> LifetimeEndOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range LifetimeEndOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult LifetimeEndOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.size;
       auto attr = dict.get("size");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for size in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `size` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute LifetimeEndOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.size;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("size",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code LifetimeEndOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.size.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> LifetimeEndOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "size")
      return prop.size;
  return std::nullopt;
}

void LifetimeEndOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "size") {
       prop.size = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.size)>>(value);
       return;
    }
}

void LifetimeEndOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.size) attrs.append("size", prop.size);
}

::mlir::LogicalResult LifetimeEndOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getSizeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps6(attr, "size", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult LifetimeEndOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.size)))
    return ::mlir::failure();
  return ::mlir::success();
}

void LifetimeEndOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.size);
}

::mlir::IntegerAttr LifetimeEndOp::getSizeAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().size);
}

uint64_t LifetimeEndOp::getSize() {
  auto attr = getSizeAttr();
  return attr.getValue().getZExtValue();
}

void LifetimeEndOp::setSizeAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getSizeAttrName(), attr);
}

void LifetimeEndOp::setSize(uint64_t attrValue) {
  (*this)->setAttr(getSizeAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(64), attrValue));
}

void LifetimeEndOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr size, ::mlir::Value ptr) {
  odsState.addOperands(ptr);
  odsState.getOrAddProperties<Properties>().size = size;
}

void LifetimeEndOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr size, ::mlir::Value ptr) {
  odsState.addOperands(ptr);
  odsState.getOrAddProperties<Properties>().size = size;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LifetimeEndOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint64_t size, ::mlir::Value ptr) {
  odsState.addOperands(ptr);
  odsState.getOrAddProperties<Properties>().size = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), size);
}

void LifetimeEndOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint64_t size, ::mlir::Value ptr) {
  odsState.addOperands(ptr);
  odsState.getOrAddProperties<Properties>().size = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), size);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LifetimeEndOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult LifetimeEndOp::verifyInvariantsImpl() {
  auto tblgen_size = getProperties().size; (void)tblgen_size;
  if (!tblgen_size) return emitOpError("requires attribute 'size'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps6(*this, tblgen_size, "size")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult LifetimeEndOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult LifetimeEndOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::IntegerAttr sizeAttr;
  ::mlir::OpAsmParser::UnresolvedOperand ptrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> ptrOperands(ptrRawOperands);  ::llvm::SMLoc ptrOperandsLoc;
  (void)ptrOperandsLoc;
  ::mlir::Type ptrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> ptrTypes(ptrRawTypes);

  if (parser.parseCustomAttributeWithFallback(sizeAttr, parser.getBuilder().getIntegerType(64))) {
    return ::mlir::failure();
  }
  if (sizeAttr) result.getOrAddProperties<LifetimeEndOp::Properties>().size = sizeAttr;
  if (parser.parseComma())
    return ::mlir::failure();

  ptrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(ptrRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(ptrRawTypes[0]))
    return ::mlir::failure();
  if (parser.resolveOperands(ptrOperands, ptrTypes, ptrOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void LifetimeEndOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getSizeAttr());
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getPtr();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("size");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getPtr().getType();
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::LifetimeEndOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::LifetimeStartOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
LifetimeStartOpGenericAdaptorBase::LifetimeStartOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.lifetime.start", odsAttrs.getContext());
}

LifetimeStartOpGenericAdaptorBase::LifetimeStartOpGenericAdaptorBase(LifetimeStartOp op) : LifetimeStartOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> LifetimeStartOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr LifetimeStartOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr LifetimeStartOpGenericAdaptorBase::getSizeAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().size);
  return attr;
}

uint64_t LifetimeStartOpGenericAdaptorBase::getSize() {
  auto attr = getSizeAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
LifetimeStartOpAdaptor::LifetimeStartOpAdaptor(LifetimeStartOp op) : LifetimeStartOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult LifetimeStartOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_size = getProperties().size; (void)tblgen_size;
  if (!tblgen_size) return emitError(loc, "'llvm.intr.lifetime.start' op ""requires attribute 'size'");

  if (tblgen_size && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_size))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_size).getType().isSignlessInteger(64)))))
    return emitError(loc, "'llvm.intr.lifetime.start' op ""attribute 'size' failed to satisfy constraint: 64-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> LifetimeStartOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range LifetimeStartOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> LifetimeStartOp::getPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
}

::mlir::OpOperand &LifetimeStartOp::getPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> LifetimeStartOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range LifetimeStartOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult LifetimeStartOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.size;
       auto attr = dict.get("size");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for size in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `size` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute LifetimeStartOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.size;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("size",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code LifetimeStartOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.size.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> LifetimeStartOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "size")
      return prop.size;
  return std::nullopt;
}

void LifetimeStartOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "size") {
       prop.size = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.size)>>(value);
       return;
    }
}

void LifetimeStartOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.size) attrs.append("size", prop.size);
}

::mlir::LogicalResult LifetimeStartOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getSizeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps6(attr, "size", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult LifetimeStartOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.size)))
    return ::mlir::failure();
  return ::mlir::success();
}

void LifetimeStartOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.size);
}

::mlir::IntegerAttr LifetimeStartOp::getSizeAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().size);
}

uint64_t LifetimeStartOp::getSize() {
  auto attr = getSizeAttr();
  return attr.getValue().getZExtValue();
}

void LifetimeStartOp::setSizeAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getSizeAttrName(), attr);
}

void LifetimeStartOp::setSize(uint64_t attrValue) {
  (*this)->setAttr(getSizeAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(64), attrValue));
}

void LifetimeStartOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr size, ::mlir::Value ptr) {
  odsState.addOperands(ptr);
  odsState.getOrAddProperties<Properties>().size = size;
}

void LifetimeStartOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr size, ::mlir::Value ptr) {
  odsState.addOperands(ptr);
  odsState.getOrAddProperties<Properties>().size = size;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LifetimeStartOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint64_t size, ::mlir::Value ptr) {
  odsState.addOperands(ptr);
  odsState.getOrAddProperties<Properties>().size = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), size);
}

void LifetimeStartOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint64_t size, ::mlir::Value ptr) {
  odsState.addOperands(ptr);
  odsState.getOrAddProperties<Properties>().size = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), size);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LifetimeStartOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult LifetimeStartOp::verifyInvariantsImpl() {
  auto tblgen_size = getProperties().size; (void)tblgen_size;
  if (!tblgen_size) return emitOpError("requires attribute 'size'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps6(*this, tblgen_size, "size")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult LifetimeStartOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult LifetimeStartOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::IntegerAttr sizeAttr;
  ::mlir::OpAsmParser::UnresolvedOperand ptrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> ptrOperands(ptrRawOperands);  ::llvm::SMLoc ptrOperandsLoc;
  (void)ptrOperandsLoc;
  ::mlir::Type ptrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> ptrTypes(ptrRawTypes);

  if (parser.parseCustomAttributeWithFallback(sizeAttr, parser.getBuilder().getIntegerType(64))) {
    return ::mlir::failure();
  }
  if (sizeAttr) result.getOrAddProperties<LifetimeStartOp::Properties>().size = sizeAttr;
  if (parser.parseComma())
    return ::mlir::failure();

  ptrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(ptrRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(ptrRawTypes[0]))
    return ::mlir::failure();
  if (parser.resolveOperands(ptrOperands, ptrTypes, ptrOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void LifetimeStartOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getSizeAttr());
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getPtr();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("size");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getPtr().getType();
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::LifetimeStartOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::LlrintOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
LlrintOpGenericAdaptorBase::LlrintOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.llrint", odsAttrs.getContext());
}

LlrintOpGenericAdaptorBase::LlrintOpGenericAdaptorBase(LlrintOp op) : LlrintOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> LlrintOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr LlrintOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
LlrintOpAdaptor::LlrintOpAdaptor(LlrintOp op) : LlrintOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult LlrintOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> LlrintOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range LlrintOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value LlrintOp::getVal() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &LlrintOp::getValMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> LlrintOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range LlrintOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value LlrintOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void LlrintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value val) {
  odsState.addOperands(val);
  odsState.addTypes(res);
}

void LlrintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val) {
  odsState.addOperands(val);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LlrintOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult LlrintOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps9(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult LlrintOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult LlrintOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void LlrintOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void LlrintOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::LlrintOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::LlroundOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
LlroundOpGenericAdaptorBase::LlroundOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.llround", odsAttrs.getContext());
}

LlroundOpGenericAdaptorBase::LlroundOpGenericAdaptorBase(LlroundOp op) : LlroundOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> LlroundOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr LlroundOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
LlroundOpAdaptor::LlroundOpAdaptor(LlroundOp op) : LlroundOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult LlroundOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> LlroundOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range LlroundOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value LlroundOp::getVal() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &LlroundOp::getValMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> LlroundOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range LlroundOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value LlroundOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void LlroundOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value val) {
  odsState.addOperands(val);
  odsState.addTypes(res);
}

void LlroundOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val) {
  odsState.addOperands(val);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LlroundOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult LlroundOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps9(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult LlroundOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult LlroundOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void LlroundOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void LlroundOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::LlroundOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::Log10Op definitions
//===----------------------------------------------------------------------===//

namespace detail {
Log10OpGenericAdaptorBase::Log10OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.log10", odsAttrs.getContext());
}

Log10OpGenericAdaptorBase::Log10OpGenericAdaptorBase(Log10Op op) : Log10OpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> Log10OpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr Log10OpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr Log10OpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags Log10OpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
Log10OpAdaptor::Log10OpAdaptor(Log10Op op) : Log10OpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult Log10OpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.log10' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> Log10Op::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range Log10Op::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value Log10Op::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &Log10Op::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> Log10Op::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range Log10Op::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value Log10Op::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult Log10Op::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute Log10Op::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code Log10Op::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> Log10Op::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void Log10Op::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void Log10Op::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult Log10Op::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult Log10Op::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void Log10Op::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr Log10Op::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags Log10Op::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void Log10Op::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void Log10Op::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void Log10Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void Log10Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(Log10Op::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void Log10Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void Log10Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void Log10Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(Log10Op::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void Log10Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void Log10Op::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void Log10Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(Log10Op::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void Log10Op::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult Log10Op::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult Log10Op::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult Log10Op::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult Log10Op::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void Log10Op::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void Log10Op::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::Log10Op)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::Log2Op definitions
//===----------------------------------------------------------------------===//

namespace detail {
Log2OpGenericAdaptorBase::Log2OpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.log2", odsAttrs.getContext());
}

Log2OpGenericAdaptorBase::Log2OpGenericAdaptorBase(Log2Op op) : Log2OpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> Log2OpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr Log2OpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr Log2OpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags Log2OpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
Log2OpAdaptor::Log2OpAdaptor(Log2Op op) : Log2OpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult Log2OpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.log2' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> Log2Op::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range Log2Op::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value Log2Op::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &Log2Op::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> Log2Op::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range Log2Op::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value Log2Op::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult Log2Op::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute Log2Op::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code Log2Op::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> Log2Op::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void Log2Op::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void Log2Op::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult Log2Op::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult Log2Op::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void Log2Op::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr Log2Op::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags Log2Op::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void Log2Op::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void Log2Op::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void Log2Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void Log2Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(Log2Op::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void Log2Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void Log2Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void Log2Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(Log2Op::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void Log2Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void Log2Op::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void Log2Op::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(Log2Op::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void Log2Op::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult Log2Op::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult Log2Op::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult Log2Op::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult Log2Op::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void Log2Op::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void Log2Op::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::Log2Op)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::LogOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
LogOpGenericAdaptorBase::LogOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.log", odsAttrs.getContext());
}

LogOpGenericAdaptorBase::LogOpGenericAdaptorBase(LogOp op) : LogOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> LogOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr LogOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr LogOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags LogOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
LogOpAdaptor::LogOpAdaptor(LogOp op) : LogOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult LogOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.log' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> LogOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range LogOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value LogOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &LogOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> LogOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range LogOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value LogOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult LogOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute LogOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code LogOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> LogOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void LogOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void LogOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult LogOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult LogOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void LogOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr LogOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags LogOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void LogOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void LogOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void LogOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void LogOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(LogOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void LogOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LogOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void LogOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(LogOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void LogOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LogOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void LogOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(LogOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void LogOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult LogOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult LogOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult LogOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult LogOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void LogOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void LogOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::LogOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::LrintOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
LrintOpGenericAdaptorBase::LrintOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.lrint", odsAttrs.getContext());
}

LrintOpGenericAdaptorBase::LrintOpGenericAdaptorBase(LrintOp op) : LrintOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> LrintOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr LrintOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
LrintOpAdaptor::LrintOpAdaptor(LrintOp op) : LrintOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult LrintOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> LrintOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range LrintOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value LrintOp::getVal() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &LrintOp::getValMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> LrintOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range LrintOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value LrintOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void LrintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value val) {
  odsState.addOperands(val);
  odsState.addTypes(res);
}

void LrintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val) {
  odsState.addOperands(val);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LrintOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult LrintOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps9(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult LrintOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult LrintOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void LrintOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void LrintOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::LrintOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::LroundOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
LroundOpGenericAdaptorBase::LroundOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.lround", odsAttrs.getContext());
}

LroundOpGenericAdaptorBase::LroundOpGenericAdaptorBase(LroundOp op) : LroundOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> LroundOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr LroundOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
LroundOpAdaptor::LroundOpAdaptor(LroundOp op) : LroundOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult LroundOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> LroundOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range LroundOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value LroundOp::getVal() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &LroundOp::getValMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> LroundOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range LroundOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value LroundOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void LroundOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value val) {
  odsState.addOperands(val);
  odsState.addTypes(res);
}

void LroundOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val) {
  odsState.addOperands(val);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LroundOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult LroundOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps9(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult LroundOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult LroundOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void LroundOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void LroundOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::LroundOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::MaskedLoadOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MaskedLoadOpGenericAdaptorBase::MaskedLoadOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.masked.load", odsAttrs.getContext());
}

MaskedLoadOpGenericAdaptorBase::MaskedLoadOpGenericAdaptorBase(MaskedLoadOp op) : MaskedLoadOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> MaskedLoadOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 2) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr MaskedLoadOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr MaskedLoadOpGenericAdaptorBase::getAlignmentAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().alignment);
  return attr;
}

uint32_t MaskedLoadOpGenericAdaptorBase::getAlignment() {
  auto attr = getAlignmentAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
MaskedLoadOpAdaptor::MaskedLoadOpAdaptor(MaskedLoadOp op) : MaskedLoadOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult MaskedLoadOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_alignment = getProperties().alignment; (void)tblgen_alignment;
  if (!tblgen_alignment) return emitError(loc, "'llvm.intr.masked.load' op ""requires attribute 'alignment'");

  if (tblgen_alignment && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_alignment))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_alignment).getType().isSignlessInteger(32)))))
    return emitError(loc, "'llvm.intr.masked.load' op ""attribute 'alignment' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> MaskedLoadOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 2) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range MaskedLoadOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> MaskedLoadOp::getData() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
}

::mlir::Value MaskedLoadOp::getMask() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::Operation::operand_range MaskedLoadOp::getPassThru() {
  return getODSOperands(2);
}

::mlir::OpOperand &MaskedLoadOp::getDataMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MaskedLoadOp::getMaskMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

::mlir::MutableOperandRange MaskedLoadOp::getPassThruMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> MaskedLoadOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range MaskedLoadOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MaskedLoadOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult MaskedLoadOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.alignment;
       auto attr = dict.get("alignment");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for alignment in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `alignment` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MaskedLoadOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.alignment;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("alignment",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MaskedLoadOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.alignment.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MaskedLoadOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "alignment")
      return prop.alignment;
  return std::nullopt;
}

void MaskedLoadOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "alignment") {
       prop.alignment = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.alignment)>>(value);
       return;
    }
}

void MaskedLoadOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.alignment) attrs.append("alignment", prop.alignment);
}

::mlir::LogicalResult MaskedLoadOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getAlignmentAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, "alignment", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult MaskedLoadOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.alignment)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MaskedLoadOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.alignment);
}

::mlir::IntegerAttr MaskedLoadOp::getAlignmentAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().alignment);
}

uint32_t MaskedLoadOp::getAlignment() {
  auto attr = getAlignmentAttr();
  return attr.getValue().getZExtValue();
}

void MaskedLoadOp::setAlignmentAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getAlignmentAttrName(), attr);
}

void MaskedLoadOp::setAlignment(uint32_t attrValue) {
  (*this)->setAttr(getAlignmentAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void MaskedLoadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value data, ::mlir::Value mask, ::mlir::ValueRange pass_thru, ::mlir::IntegerAttr alignment) {
  odsState.addOperands(data);
  odsState.addOperands(mask);
  odsState.addOperands(pass_thru);
  odsState.getOrAddProperties<Properties>().alignment = alignment;
  odsState.addTypes(res);
}

void MaskedLoadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value data, ::mlir::Value mask, ::mlir::ValueRange pass_thru, ::mlir::IntegerAttr alignment) {
  odsState.addOperands(data);
  odsState.addOperands(mask);
  odsState.addOperands(pass_thru);
  odsState.getOrAddProperties<Properties>().alignment = alignment;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MaskedLoadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value data, ::mlir::Value mask, ::mlir::ValueRange pass_thru, uint32_t alignment) {
  odsState.addOperands(data);
  odsState.addOperands(mask);
  odsState.addOperands(pass_thru);
  odsState.getOrAddProperties<Properties>().alignment = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), alignment);
  odsState.addTypes(res);
}

void MaskedLoadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value data, ::mlir::Value mask, ::mlir::ValueRange pass_thru, uint32_t alignment) {
  odsState.addOperands(data);
  odsState.addOperands(mask);
  odsState.addOperands(pass_thru);
  odsState.getOrAddProperties<Properties>().alignment = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), alignment);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MaskedLoadOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult MaskedLoadOp::verifyInvariantsImpl() {
  auto tblgen_alignment = getProperties().alignment; (void)tblgen_alignment;
  if (!tblgen_alignment) return emitOpError("requires attribute 'alignment'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(*this, tblgen_alignment, "alignment")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps10(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps11(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps11(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult MaskedLoadOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult MaskedLoadOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void MaskedLoadOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getOperation()->getOperands();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::MaskedLoadOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::MaskedStoreOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MaskedStoreOpGenericAdaptorBase::MaskedStoreOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.masked.store", odsAttrs.getContext());
}

MaskedStoreOpGenericAdaptorBase::MaskedStoreOpGenericAdaptorBase(MaskedStoreOp op) : MaskedStoreOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> MaskedStoreOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr MaskedStoreOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr MaskedStoreOpGenericAdaptorBase::getAlignmentAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().alignment);
  return attr;
}

uint32_t MaskedStoreOpGenericAdaptorBase::getAlignment() {
  auto attr = getAlignmentAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
MaskedStoreOpAdaptor::MaskedStoreOpAdaptor(MaskedStoreOp op) : MaskedStoreOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult MaskedStoreOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_alignment = getProperties().alignment; (void)tblgen_alignment;
  if (!tblgen_alignment) return emitError(loc, "'llvm.intr.masked.store' op ""requires attribute 'alignment'");

  if (tblgen_alignment && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_alignment))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_alignment).getType().isSignlessInteger(32)))))
    return emitError(loc, "'llvm.intr.masked.store' op ""attribute 'alignment' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> MaskedStoreOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range MaskedStoreOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MaskedStoreOp::getValue() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> MaskedStoreOp::getData() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
}

::mlir::Value MaskedStoreOp::getMask() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(2).begin());
}

::mlir::OpOperand &MaskedStoreOp::getValueMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MaskedStoreOp::getDataMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MaskedStoreOp::getMaskMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> MaskedStoreOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range MaskedStoreOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult MaskedStoreOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.alignment;
       auto attr = dict.get("alignment");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for alignment in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `alignment` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MaskedStoreOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.alignment;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("alignment",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MaskedStoreOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.alignment.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MaskedStoreOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "alignment")
      return prop.alignment;
  return std::nullopt;
}

void MaskedStoreOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "alignment") {
       prop.alignment = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.alignment)>>(value);
       return;
    }
}

void MaskedStoreOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.alignment) attrs.append("alignment", prop.alignment);
}

::mlir::LogicalResult MaskedStoreOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getAlignmentAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, "alignment", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult MaskedStoreOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.alignment)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MaskedStoreOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.alignment);
}

::mlir::IntegerAttr MaskedStoreOp::getAlignmentAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().alignment);
}

uint32_t MaskedStoreOp::getAlignment() {
  auto attr = getAlignmentAttr();
  return attr.getValue().getZExtValue();
}

void MaskedStoreOp::setAlignmentAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getAlignmentAttrName(), attr);
}

void MaskedStoreOp::setAlignment(uint32_t attrValue) {
  (*this)->setAttr(getAlignmentAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void MaskedStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
    assert(isCompatibleType(resultType) && "result must be an LLVM type");
    assert(::llvm::isa<LLVMVoidType>(resultType) &&
           "for zero-result operands, only 'void' is accepted as result type");
    build(odsBuilder, odsState, operands, attributes);
  
}

void MaskedStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
    odsState.addOperands(operands);
    for (auto namedAttr : attributes)
      odsState.addAttribute(namedAttr.getName(), namedAttr.getValue());
  
}

void MaskedStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::Value data, ::mlir::Value mask, ::mlir::IntegerAttr alignment) {
  odsState.addOperands(value);
  odsState.addOperands(data);
  odsState.addOperands(mask);
  odsState.getOrAddProperties<Properties>().alignment = alignment;
}

void MaskedStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value data, ::mlir::Value mask, ::mlir::IntegerAttr alignment) {
  odsState.addOperands(value);
  odsState.addOperands(data);
  odsState.addOperands(mask);
  odsState.getOrAddProperties<Properties>().alignment = alignment;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MaskedStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::Value data, ::mlir::Value mask, uint32_t alignment) {
  odsState.addOperands(value);
  odsState.addOperands(data);
  odsState.addOperands(mask);
  odsState.getOrAddProperties<Properties>().alignment = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), alignment);
}

void MaskedStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value data, ::mlir::Value mask, uint32_t alignment) {
  odsState.addOperands(value);
  odsState.addOperands(data);
  odsState.addOperands(mask);
  odsState.getOrAddProperties<Properties>().alignment = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), alignment);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MaskedStoreOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult MaskedStoreOp::verifyInvariantsImpl() {
  auto tblgen_alignment = getProperties().alignment; (void)tblgen_alignment;
  if (!tblgen_alignment) return emitOpError("requires attribute 'alignment'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(*this, tblgen_alignment, "alignment")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps11(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps10(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult MaskedStoreOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult MaskedStoreOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand valueRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> valueOperands(valueRawOperands);  ::llvm::SMLoc valueOperandsLoc;
  (void)valueOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand dataRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> dataOperands(dataRawOperands);  ::llvm::SMLoc dataOperandsLoc;
  (void)dataOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand maskRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> maskOperands(maskRawOperands);  ::llvm::SMLoc maskOperandsLoc;
  (void)maskOperandsLoc;
  ::mlir::Type valueRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> valueTypes(valueRawTypes);
  ::mlir::Type maskRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> maskTypes(maskRawTypes);
  ::mlir::Type dataRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> dataTypes(dataRawTypes);

  valueOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(valueRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  dataOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(dataRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  maskOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(maskRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    valueRawTypes[0] = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    maskRawTypes[0] = type;
  }
  if (parser.parseKeyword("into"))
    return ::mlir::failure();

  if (parser.parseType(dataRawTypes[0]))
    return ::mlir::failure();
  if (parser.resolveOperands(valueOperands, valueTypes, valueOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(dataOperands, dataTypes, dataOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(maskOperands, maskTypes, maskOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void MaskedStoreOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getValue();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getData();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getMask();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getValue().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getMask().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ' ' << "into";
  _odsPrinter << ' ';
   _odsPrinter << getData().getType();
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::MaskedStoreOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::MatrixColumnMajorLoadOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MatrixColumnMajorLoadOpGenericAdaptorBase::MatrixColumnMajorLoadOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.matrix.column.major.load", odsAttrs.getContext());
}

MatrixColumnMajorLoadOpGenericAdaptorBase::MatrixColumnMajorLoadOpGenericAdaptorBase(MatrixColumnMajorLoadOp op) : MatrixColumnMajorLoadOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> MatrixColumnMajorLoadOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr MatrixColumnMajorLoadOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr MatrixColumnMajorLoadOpGenericAdaptorBase::getIsVolatileAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().isVolatile);
  return attr;
}

bool MatrixColumnMajorLoadOpGenericAdaptorBase::getIsVolatile() {
  auto attr = getIsVolatileAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr MatrixColumnMajorLoadOpGenericAdaptorBase::getRowsAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().rows);
  return attr;
}

uint32_t MatrixColumnMajorLoadOpGenericAdaptorBase::getRows() {
  auto attr = getRowsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr MatrixColumnMajorLoadOpGenericAdaptorBase::getColumnsAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().columns);
  return attr;
}

uint32_t MatrixColumnMajorLoadOpGenericAdaptorBase::getColumns() {
  auto attr = getColumnsAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
MatrixColumnMajorLoadOpAdaptor::MatrixColumnMajorLoadOpAdaptor(MatrixColumnMajorLoadOp op) : MatrixColumnMajorLoadOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult MatrixColumnMajorLoadOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_columns = getProperties().columns; (void)tblgen_columns;
  if (!tblgen_columns) return emitError(loc, "'llvm.intr.matrix.column.major.load' op ""requires attribute 'columns'");
  auto tblgen_isVolatile = getProperties().isVolatile; (void)tblgen_isVolatile;
  if (!tblgen_isVolatile) return emitError(loc, "'llvm.intr.matrix.column.major.load' op ""requires attribute 'isVolatile'");
  auto tblgen_rows = getProperties().rows; (void)tblgen_rows;
  if (!tblgen_rows) return emitError(loc, "'llvm.intr.matrix.column.major.load' op ""requires attribute 'rows'");

  if (tblgen_isVolatile && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_isVolatile))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_isVolatile).getType().isSignlessInteger(1)))))
    return emitError(loc, "'llvm.intr.matrix.column.major.load' op ""attribute 'isVolatile' failed to satisfy constraint: 1-bit signless integer attribute");

  if (tblgen_rows && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_rows))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_rows).getType().isSignlessInteger(32)))))
    return emitError(loc, "'llvm.intr.matrix.column.major.load' op ""attribute 'rows' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_columns && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_columns))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_columns).getType().isSignlessInteger(32)))))
    return emitError(loc, "'llvm.intr.matrix.column.major.load' op ""attribute 'columns' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> MatrixColumnMajorLoadOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range MatrixColumnMajorLoadOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> MatrixColumnMajorLoadOp::getData() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::IntegerType> MatrixColumnMajorLoadOp::getStride() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
}

::mlir::OpOperand &MatrixColumnMajorLoadOp::getDataMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MatrixColumnMajorLoadOp::getStrideMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> MatrixColumnMajorLoadOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range MatrixColumnMajorLoadOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MatrixColumnMajorLoadOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult MatrixColumnMajorLoadOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.columns;
       auto attr = dict.get("columns");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for columns in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `columns` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.isVolatile;
       auto attr = dict.get("isVolatile");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for isVolatile in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `isVolatile` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.rows;
       auto attr = dict.get("rows");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for rows in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `rows` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MatrixColumnMajorLoadOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.columns;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("columns",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.isVolatile;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("isVolatile",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.rows;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("rows",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MatrixColumnMajorLoadOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.columns.getAsOpaquePointer()), 
    llvm::hash_value(prop.isVolatile.getAsOpaquePointer()), 
    llvm::hash_value(prop.rows.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MatrixColumnMajorLoadOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "columns")
      return prop.columns;

    if (name == "isVolatile")
      return prop.isVolatile;

    if (name == "rows")
      return prop.rows;
  return std::nullopt;
}

void MatrixColumnMajorLoadOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "columns") {
       prop.columns = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.columns)>>(value);
       return;
    }

    if (name == "isVolatile") {
       prop.isVolatile = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.isVolatile)>>(value);
       return;
    }

    if (name == "rows") {
       prop.rows = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.rows)>>(value);
       return;
    }
}

void MatrixColumnMajorLoadOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.columns) attrs.append("columns", prop.columns);

    if (prop.isVolatile) attrs.append("isVolatile", prop.isVolatile);

    if (prop.rows) attrs.append("rows", prop.rows);
}

::mlir::LogicalResult MatrixColumnMajorLoadOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getColumnsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, "columns", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getIsVolatileAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(attr, "isVolatile", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getRowsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, "rows", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult MatrixColumnMajorLoadOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.columns)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.isVolatile)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.rows)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MatrixColumnMajorLoadOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.columns);
  writer.writeAttribute(prop.isVolatile);
  writer.writeAttribute(prop.rows);
}

::mlir::IntegerAttr MatrixColumnMajorLoadOp::getIsVolatileAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().isVolatile);
}

bool MatrixColumnMajorLoadOp::getIsVolatile() {
  auto attr = getIsVolatileAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr MatrixColumnMajorLoadOp::getRowsAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().rows);
}

uint32_t MatrixColumnMajorLoadOp::getRows() {
  auto attr = getRowsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr MatrixColumnMajorLoadOp::getColumnsAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().columns);
}

uint32_t MatrixColumnMajorLoadOp::getColumns() {
  auto attr = getColumnsAttr();
  return attr.getValue().getZExtValue();
}

void MatrixColumnMajorLoadOp::setIsVolatileAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getIsVolatileAttrName(), attr);
}

void MatrixColumnMajorLoadOp::setIsVolatile(bool attrValue) {
  (*this)->setAttr(getIsVolatileAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(1), attrValue));
}

void MatrixColumnMajorLoadOp::setRowsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getRowsAttrName(), attr);
}

void MatrixColumnMajorLoadOp::setRows(uint32_t attrValue) {
  (*this)->setAttr(getRowsAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void MatrixColumnMajorLoadOp::setColumnsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getColumnsAttrName(), attr);
}

void MatrixColumnMajorLoadOp::setColumns(uint32_t attrValue) {
  (*this)->setAttr(getColumnsAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void MatrixColumnMajorLoadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
    if (resultType) odsState.addTypes(resultType);
    odsState.addOperands(operands);
    for (auto namedAttr : attributes)
      odsState.addAttribute(namedAttr.getName(), namedAttr.getValue());
  
}

void MatrixColumnMajorLoadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value data, ::mlir::Value stride, ::mlir::IntegerAttr isVolatile, ::mlir::IntegerAttr rows, ::mlir::IntegerAttr columns) {
  odsState.addOperands(data);
  odsState.addOperands(stride);
  odsState.getOrAddProperties<Properties>().isVolatile = isVolatile;
  odsState.getOrAddProperties<Properties>().rows = rows;
  odsState.getOrAddProperties<Properties>().columns = columns;
  odsState.addTypes(res);
}

void MatrixColumnMajorLoadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value data, ::mlir::Value stride, ::mlir::IntegerAttr isVolatile, ::mlir::IntegerAttr rows, ::mlir::IntegerAttr columns) {
  odsState.addOperands(data);
  odsState.addOperands(stride);
  odsState.getOrAddProperties<Properties>().isVolatile = isVolatile;
  odsState.getOrAddProperties<Properties>().rows = rows;
  odsState.getOrAddProperties<Properties>().columns = columns;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MatrixColumnMajorLoadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value data, ::mlir::Value stride, bool isVolatile, uint32_t rows, uint32_t columns) {
  odsState.addOperands(data);
  odsState.addOperands(stride);
  odsState.getOrAddProperties<Properties>().isVolatile = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), isVolatile);
  odsState.getOrAddProperties<Properties>().rows = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), rows);
  odsState.getOrAddProperties<Properties>().columns = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), columns);
  odsState.addTypes(res);
}

void MatrixColumnMajorLoadOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value data, ::mlir::Value stride, bool isVolatile, uint32_t rows, uint32_t columns) {
  odsState.addOperands(data);
  odsState.addOperands(stride);
  odsState.getOrAddProperties<Properties>().isVolatile = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), isVolatile);
  odsState.getOrAddProperties<Properties>().rows = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), rows);
  odsState.getOrAddProperties<Properties>().columns = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), columns);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MatrixColumnMajorLoadOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult MatrixColumnMajorLoadOp::verifyInvariantsImpl() {
  auto tblgen_columns = getProperties().columns; (void)tblgen_columns;
  if (!tblgen_columns) return emitOpError("requires attribute 'columns'");
  auto tblgen_isVolatile = getProperties().isVolatile; (void)tblgen_isVolatile;
  if (!tblgen_isVolatile) return emitOpError("requires attribute 'isVolatile'");
  auto tblgen_rows = getProperties().rows; (void)tblgen_rows;
  if (!tblgen_rows) return emitOpError("requires attribute 'rows'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(*this, tblgen_isVolatile, "isVolatile")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(*this, tblgen_rows, "rows")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(*this, tblgen_columns, "columns")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps11(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult MatrixColumnMajorLoadOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult MatrixColumnMajorLoadOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand dataRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> dataOperands(dataRawOperands);  ::llvm::SMLoc dataOperandsLoc;
  (void)dataOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand strideRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> strideOperands(strideRawOperands);  ::llvm::SMLoc strideOperandsLoc;
  (void)strideOperandsLoc;
  ::mlir::Type resRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> resTypes(resRawTypes);
  ::mlir::Type dataRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> dataTypes(dataRawTypes);
  ::mlir::Type strideRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> strideTypes(strideRawTypes);

  dataOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(dataRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();
  if (parser.parseLess())
    return ::mlir::failure();
  if (parser.parseKeyword("stride"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();

  strideOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(strideRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseGreater())
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawTypes[0] = type;
  }
  if (parser.parseKeyword("from"))
    return ::mlir::failure();

  if (parser.parseType(dataRawTypes[0]))
    return ::mlir::failure();
  if (parser.parseKeyword("stride"))
    return ::mlir::failure();

  {
    ::mlir::IntegerType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    strideRawTypes[0] = type;
  }
  result.addTypes(resTypes);
  if (parser.resolveOperands(dataOperands, dataTypes, dataOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(strideOperands, strideTypes, strideOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void MatrixColumnMajorLoadOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getData();
  _odsPrinter << ",";
  _odsPrinter << ' ' << "<";
  _odsPrinter << "stride";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
  _odsPrinter << getStride();
  _odsPrinter << ">";
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ' ' << "from";
  _odsPrinter << ' ';
   _odsPrinter << getData().getType();
  _odsPrinter << ' ' << "stride";
  _odsPrinter << ' ';
  {
    auto type = getStride().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::IntegerType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::MatrixColumnMajorLoadOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::MatrixColumnMajorStoreOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MatrixColumnMajorStoreOpGenericAdaptorBase::MatrixColumnMajorStoreOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.matrix.column.major.store", odsAttrs.getContext());
}

MatrixColumnMajorStoreOpGenericAdaptorBase::MatrixColumnMajorStoreOpGenericAdaptorBase(MatrixColumnMajorStoreOp op) : MatrixColumnMajorStoreOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> MatrixColumnMajorStoreOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr MatrixColumnMajorStoreOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr MatrixColumnMajorStoreOpGenericAdaptorBase::getIsVolatileAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().isVolatile);
  return attr;
}

bool MatrixColumnMajorStoreOpGenericAdaptorBase::getIsVolatile() {
  auto attr = getIsVolatileAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr MatrixColumnMajorStoreOpGenericAdaptorBase::getRowsAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().rows);
  return attr;
}

uint32_t MatrixColumnMajorStoreOpGenericAdaptorBase::getRows() {
  auto attr = getRowsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr MatrixColumnMajorStoreOpGenericAdaptorBase::getColumnsAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().columns);
  return attr;
}

uint32_t MatrixColumnMajorStoreOpGenericAdaptorBase::getColumns() {
  auto attr = getColumnsAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
MatrixColumnMajorStoreOpAdaptor::MatrixColumnMajorStoreOpAdaptor(MatrixColumnMajorStoreOp op) : MatrixColumnMajorStoreOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult MatrixColumnMajorStoreOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_columns = getProperties().columns; (void)tblgen_columns;
  if (!tblgen_columns) return emitError(loc, "'llvm.intr.matrix.column.major.store' op ""requires attribute 'columns'");
  auto tblgen_isVolatile = getProperties().isVolatile; (void)tblgen_isVolatile;
  if (!tblgen_isVolatile) return emitError(loc, "'llvm.intr.matrix.column.major.store' op ""requires attribute 'isVolatile'");
  auto tblgen_rows = getProperties().rows; (void)tblgen_rows;
  if (!tblgen_rows) return emitError(loc, "'llvm.intr.matrix.column.major.store' op ""requires attribute 'rows'");

  if (tblgen_isVolatile && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_isVolatile))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_isVolatile).getType().isSignlessInteger(1)))))
    return emitError(loc, "'llvm.intr.matrix.column.major.store' op ""attribute 'isVolatile' failed to satisfy constraint: 1-bit signless integer attribute");

  if (tblgen_rows && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_rows))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_rows).getType().isSignlessInteger(32)))))
    return emitError(loc, "'llvm.intr.matrix.column.major.store' op ""attribute 'rows' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_columns && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_columns))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_columns).getType().isSignlessInteger(32)))))
    return emitError(loc, "'llvm.intr.matrix.column.major.store' op ""attribute 'columns' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> MatrixColumnMajorStoreOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range MatrixColumnMajorStoreOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MatrixColumnMajorStoreOp::getMatrix() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> MatrixColumnMajorStoreOp::getData() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
}

::mlir::TypedValue<::mlir::IntegerType> MatrixColumnMajorStoreOp::getStride() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
}

::mlir::OpOperand &MatrixColumnMajorStoreOp::getMatrixMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MatrixColumnMajorStoreOp::getDataMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MatrixColumnMajorStoreOp::getStrideMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> MatrixColumnMajorStoreOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range MatrixColumnMajorStoreOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult MatrixColumnMajorStoreOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.columns;
       auto attr = dict.get("columns");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for columns in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `columns` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.isVolatile;
       auto attr = dict.get("isVolatile");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for isVolatile in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `isVolatile` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.rows;
       auto attr = dict.get("rows");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for rows in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `rows` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MatrixColumnMajorStoreOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.columns;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("columns",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.isVolatile;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("isVolatile",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.rows;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("rows",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MatrixColumnMajorStoreOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.columns.getAsOpaquePointer()), 
    llvm::hash_value(prop.isVolatile.getAsOpaquePointer()), 
    llvm::hash_value(prop.rows.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MatrixColumnMajorStoreOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "columns")
      return prop.columns;

    if (name == "isVolatile")
      return prop.isVolatile;

    if (name == "rows")
      return prop.rows;
  return std::nullopt;
}

void MatrixColumnMajorStoreOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "columns") {
       prop.columns = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.columns)>>(value);
       return;
    }

    if (name == "isVolatile") {
       prop.isVolatile = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.isVolatile)>>(value);
       return;
    }

    if (name == "rows") {
       prop.rows = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.rows)>>(value);
       return;
    }
}

void MatrixColumnMajorStoreOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.columns) attrs.append("columns", prop.columns);

    if (prop.isVolatile) attrs.append("isVolatile", prop.isVolatile);

    if (prop.rows) attrs.append("rows", prop.rows);
}

::mlir::LogicalResult MatrixColumnMajorStoreOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getColumnsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, "columns", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getIsVolatileAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(attr, "isVolatile", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getRowsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, "rows", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult MatrixColumnMajorStoreOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.columns)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.isVolatile)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.rows)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MatrixColumnMajorStoreOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.columns);
  writer.writeAttribute(prop.isVolatile);
  writer.writeAttribute(prop.rows);
}

::mlir::IntegerAttr MatrixColumnMajorStoreOp::getIsVolatileAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().isVolatile);
}

bool MatrixColumnMajorStoreOp::getIsVolatile() {
  auto attr = getIsVolatileAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr MatrixColumnMajorStoreOp::getRowsAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().rows);
}

uint32_t MatrixColumnMajorStoreOp::getRows() {
  auto attr = getRowsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr MatrixColumnMajorStoreOp::getColumnsAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().columns);
}

uint32_t MatrixColumnMajorStoreOp::getColumns() {
  auto attr = getColumnsAttr();
  return attr.getValue().getZExtValue();
}

void MatrixColumnMajorStoreOp::setIsVolatileAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getIsVolatileAttrName(), attr);
}

void MatrixColumnMajorStoreOp::setIsVolatile(bool attrValue) {
  (*this)->setAttr(getIsVolatileAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(1), attrValue));
}

void MatrixColumnMajorStoreOp::setRowsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getRowsAttrName(), attr);
}

void MatrixColumnMajorStoreOp::setRows(uint32_t attrValue) {
  (*this)->setAttr(getRowsAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void MatrixColumnMajorStoreOp::setColumnsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getColumnsAttrName(), attr);
}

void MatrixColumnMajorStoreOp::setColumns(uint32_t attrValue) {
  (*this)->setAttr(getColumnsAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void MatrixColumnMajorStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
    assert(isCompatibleType(resultType) && "result must be an LLVM type");
    assert(::llvm::isa<LLVMVoidType>(resultType) &&
           "for zero-result operands, only 'void' is accepted as result type");
    build(odsBuilder, odsState, operands, attributes);
  
}

void MatrixColumnMajorStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
    odsState.addOperands(operands);
    for (auto namedAttr : attributes)
      odsState.addAttribute(namedAttr.getName(), namedAttr.getValue());
  
}

void MatrixColumnMajorStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value matrix, ::mlir::Value data, ::mlir::Value stride, ::mlir::IntegerAttr isVolatile, ::mlir::IntegerAttr rows, ::mlir::IntegerAttr columns) {
  odsState.addOperands(matrix);
  odsState.addOperands(data);
  odsState.addOperands(stride);
  odsState.getOrAddProperties<Properties>().isVolatile = isVolatile;
  odsState.getOrAddProperties<Properties>().rows = rows;
  odsState.getOrAddProperties<Properties>().columns = columns;
}

void MatrixColumnMajorStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value matrix, ::mlir::Value data, ::mlir::Value stride, ::mlir::IntegerAttr isVolatile, ::mlir::IntegerAttr rows, ::mlir::IntegerAttr columns) {
  odsState.addOperands(matrix);
  odsState.addOperands(data);
  odsState.addOperands(stride);
  odsState.getOrAddProperties<Properties>().isVolatile = isVolatile;
  odsState.getOrAddProperties<Properties>().rows = rows;
  odsState.getOrAddProperties<Properties>().columns = columns;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MatrixColumnMajorStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value matrix, ::mlir::Value data, ::mlir::Value stride, bool isVolatile, uint32_t rows, uint32_t columns) {
  odsState.addOperands(matrix);
  odsState.addOperands(data);
  odsState.addOperands(stride);
  odsState.getOrAddProperties<Properties>().isVolatile = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), isVolatile);
  odsState.getOrAddProperties<Properties>().rows = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), rows);
  odsState.getOrAddProperties<Properties>().columns = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), columns);
}

void MatrixColumnMajorStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value matrix, ::mlir::Value data, ::mlir::Value stride, bool isVolatile, uint32_t rows, uint32_t columns) {
  odsState.addOperands(matrix);
  odsState.addOperands(data);
  odsState.addOperands(stride);
  odsState.getOrAddProperties<Properties>().isVolatile = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), isVolatile);
  odsState.getOrAddProperties<Properties>().rows = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), rows);
  odsState.getOrAddProperties<Properties>().columns = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), columns);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MatrixColumnMajorStoreOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult MatrixColumnMajorStoreOp::verifyInvariantsImpl() {
  auto tblgen_columns = getProperties().columns; (void)tblgen_columns;
  if (!tblgen_columns) return emitOpError("requires attribute 'columns'");
  auto tblgen_isVolatile = getProperties().isVolatile; (void)tblgen_isVolatile;
  if (!tblgen_isVolatile) return emitOpError("requires attribute 'isVolatile'");
  auto tblgen_rows = getProperties().rows; (void)tblgen_rows;
  if (!tblgen_rows) return emitOpError("requires attribute 'rows'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(*this, tblgen_isVolatile, "isVolatile")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(*this, tblgen_rows, "rows")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(*this, tblgen_columns, "columns")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps11(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult MatrixColumnMajorStoreOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult MatrixColumnMajorStoreOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand matrixRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> matrixOperands(matrixRawOperands);  ::llvm::SMLoc matrixOperandsLoc;
  (void)matrixOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand dataRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> dataOperands(dataRawOperands);  ::llvm::SMLoc dataOperandsLoc;
  (void)dataOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand strideRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> strideOperands(strideRawOperands);  ::llvm::SMLoc strideOperandsLoc;
  (void)strideOperandsLoc;
  ::mlir::Type matrixRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> matrixTypes(matrixRawTypes);
  ::mlir::Type dataRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> dataTypes(dataRawTypes);
  ::mlir::Type strideRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> strideTypes(strideRawTypes);

  matrixOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(matrixRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  dataOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(dataRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();
  if (parser.parseLess())
    return ::mlir::failure();
  if (parser.parseKeyword("stride"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();

  strideOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(strideRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseGreater())
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    matrixRawTypes[0] = type;
  }
  if (parser.parseKeyword("to"))
    return ::mlir::failure();

  if (parser.parseType(dataRawTypes[0]))
    return ::mlir::failure();
  if (parser.parseKeyword("stride"))
    return ::mlir::failure();

  {
    ::mlir::IntegerType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    strideRawTypes[0] = type;
  }
  if (parser.resolveOperands(matrixOperands, matrixTypes, matrixOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(dataOperands, dataTypes, dataOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(strideOperands, strideTypes, strideOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void MatrixColumnMajorStoreOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getMatrix();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getData();
  _odsPrinter << ",";
  _odsPrinter << ' ' << "<";
  _odsPrinter << "stride";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
  _odsPrinter << getStride();
  _odsPrinter << ">";
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getMatrix().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ' ' << "to";
  _odsPrinter << ' ';
   _odsPrinter << getData().getType();
  _odsPrinter << ' ' << "stride";
  _odsPrinter << ' ';
  {
    auto type = getStride().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::IntegerType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::MatrixColumnMajorStoreOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::MatrixMultiplyOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MatrixMultiplyOpGenericAdaptorBase::MatrixMultiplyOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.matrix.multiply", odsAttrs.getContext());
}

MatrixMultiplyOpGenericAdaptorBase::MatrixMultiplyOpGenericAdaptorBase(MatrixMultiplyOp op) : MatrixMultiplyOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> MatrixMultiplyOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr MatrixMultiplyOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr MatrixMultiplyOpGenericAdaptorBase::getLhsRowsAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().lhs_rows);
  return attr;
}

uint32_t MatrixMultiplyOpGenericAdaptorBase::getLhsRows() {
  auto attr = getLhsRowsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr MatrixMultiplyOpGenericAdaptorBase::getLhsColumnsAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().lhs_columns);
  return attr;
}

uint32_t MatrixMultiplyOpGenericAdaptorBase::getLhsColumns() {
  auto attr = getLhsColumnsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr MatrixMultiplyOpGenericAdaptorBase::getRhsColumnsAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().rhs_columns);
  return attr;
}

uint32_t MatrixMultiplyOpGenericAdaptorBase::getRhsColumns() {
  auto attr = getRhsColumnsAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
MatrixMultiplyOpAdaptor::MatrixMultiplyOpAdaptor(MatrixMultiplyOp op) : MatrixMultiplyOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult MatrixMultiplyOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_lhs_columns = getProperties().lhs_columns; (void)tblgen_lhs_columns;
  if (!tblgen_lhs_columns) return emitError(loc, "'llvm.intr.matrix.multiply' op ""requires attribute 'lhs_columns'");
  auto tblgen_lhs_rows = getProperties().lhs_rows; (void)tblgen_lhs_rows;
  if (!tblgen_lhs_rows) return emitError(loc, "'llvm.intr.matrix.multiply' op ""requires attribute 'lhs_rows'");
  auto tblgen_rhs_columns = getProperties().rhs_columns; (void)tblgen_rhs_columns;
  if (!tblgen_rhs_columns) return emitError(loc, "'llvm.intr.matrix.multiply' op ""requires attribute 'rhs_columns'");

  if (tblgen_lhs_rows && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_lhs_rows))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_lhs_rows).getType().isSignlessInteger(32)))))
    return emitError(loc, "'llvm.intr.matrix.multiply' op ""attribute 'lhs_rows' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_lhs_columns && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_lhs_columns))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_lhs_columns).getType().isSignlessInteger(32)))))
    return emitError(loc, "'llvm.intr.matrix.multiply' op ""attribute 'lhs_columns' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_rhs_columns && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_rhs_columns))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_rhs_columns).getType().isSignlessInteger(32)))))
    return emitError(loc, "'llvm.intr.matrix.multiply' op ""attribute 'rhs_columns' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> MatrixMultiplyOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range MatrixMultiplyOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MatrixMultiplyOp::getLhs() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value MatrixMultiplyOp::getRhs() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::OpOperand &MatrixMultiplyOp::getLhsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MatrixMultiplyOp::getRhsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> MatrixMultiplyOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range MatrixMultiplyOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MatrixMultiplyOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult MatrixMultiplyOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.lhs_columns;
       auto attr = dict.get("lhs_columns");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for lhs_columns in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `lhs_columns` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.lhs_rows;
       auto attr = dict.get("lhs_rows");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for lhs_rows in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `lhs_rows` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.rhs_columns;
       auto attr = dict.get("rhs_columns");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for rhs_columns in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `rhs_columns` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MatrixMultiplyOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.lhs_columns;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("lhs_columns",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.lhs_rows;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("lhs_rows",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.rhs_columns;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("rhs_columns",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MatrixMultiplyOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.lhs_columns.getAsOpaquePointer()), 
    llvm::hash_value(prop.lhs_rows.getAsOpaquePointer()), 
    llvm::hash_value(prop.rhs_columns.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MatrixMultiplyOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "lhs_columns")
      return prop.lhs_columns;

    if (name == "lhs_rows")
      return prop.lhs_rows;

    if (name == "rhs_columns")
      return prop.rhs_columns;
  return std::nullopt;
}

void MatrixMultiplyOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "lhs_columns") {
       prop.lhs_columns = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.lhs_columns)>>(value);
       return;
    }

    if (name == "lhs_rows") {
       prop.lhs_rows = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.lhs_rows)>>(value);
       return;
    }

    if (name == "rhs_columns") {
       prop.rhs_columns = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.rhs_columns)>>(value);
       return;
    }
}

void MatrixMultiplyOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.lhs_columns) attrs.append("lhs_columns", prop.lhs_columns);

    if (prop.lhs_rows) attrs.append("lhs_rows", prop.lhs_rows);

    if (prop.rhs_columns) attrs.append("rhs_columns", prop.rhs_columns);
}

::mlir::LogicalResult MatrixMultiplyOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getLhsColumnsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, "lhs_columns", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getLhsRowsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, "lhs_rows", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getRhsColumnsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, "rhs_columns", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult MatrixMultiplyOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.lhs_columns)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.lhs_rows)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.rhs_columns)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MatrixMultiplyOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.lhs_columns);
  writer.writeAttribute(prop.lhs_rows);
  writer.writeAttribute(prop.rhs_columns);
}

::mlir::IntegerAttr MatrixMultiplyOp::getLhsRowsAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().lhs_rows);
}

uint32_t MatrixMultiplyOp::getLhsRows() {
  auto attr = getLhsRowsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr MatrixMultiplyOp::getLhsColumnsAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().lhs_columns);
}

uint32_t MatrixMultiplyOp::getLhsColumns() {
  auto attr = getLhsColumnsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr MatrixMultiplyOp::getRhsColumnsAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().rhs_columns);
}

uint32_t MatrixMultiplyOp::getRhsColumns() {
  auto attr = getRhsColumnsAttr();
  return attr.getValue().getZExtValue();
}

void MatrixMultiplyOp::setLhsRowsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getLhsRowsAttrName(), attr);
}

void MatrixMultiplyOp::setLhsRows(uint32_t attrValue) {
  (*this)->setAttr(getLhsRowsAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void MatrixMultiplyOp::setLhsColumnsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getLhsColumnsAttrName(), attr);
}

void MatrixMultiplyOp::setLhsColumns(uint32_t attrValue) {
  (*this)->setAttr(getLhsColumnsAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void MatrixMultiplyOp::setRhsColumnsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getRhsColumnsAttrName(), attr);
}

void MatrixMultiplyOp::setRhsColumns(uint32_t attrValue) {
  (*this)->setAttr(getRhsColumnsAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void MatrixMultiplyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
    if (resultType) odsState.addTypes(resultType);
    odsState.addOperands(operands);
    for (auto namedAttr : attributes)
      odsState.addAttribute(namedAttr.getName(), namedAttr.getValue());
  
}

void MatrixMultiplyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::IntegerAttr lhs_rows, ::mlir::IntegerAttr lhs_columns, ::mlir::IntegerAttr rhs_columns) {
  odsState.addOperands(lhs);
  odsState.addOperands(rhs);
  odsState.getOrAddProperties<Properties>().lhs_rows = lhs_rows;
  odsState.getOrAddProperties<Properties>().lhs_columns = lhs_columns;
  odsState.getOrAddProperties<Properties>().rhs_columns = rhs_columns;
  odsState.addTypes(res);
}

void MatrixMultiplyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::IntegerAttr lhs_rows, ::mlir::IntegerAttr lhs_columns, ::mlir::IntegerAttr rhs_columns) {
  odsState.addOperands(lhs);
  odsState.addOperands(rhs);
  odsState.getOrAddProperties<Properties>().lhs_rows = lhs_rows;
  odsState.getOrAddProperties<Properties>().lhs_columns = lhs_columns;
  odsState.getOrAddProperties<Properties>().rhs_columns = rhs_columns;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MatrixMultiplyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value lhs, ::mlir::Value rhs, uint32_t lhs_rows, uint32_t lhs_columns, uint32_t rhs_columns) {
  odsState.addOperands(lhs);
  odsState.addOperands(rhs);
  odsState.getOrAddProperties<Properties>().lhs_rows = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), lhs_rows);
  odsState.getOrAddProperties<Properties>().lhs_columns = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), lhs_columns);
  odsState.getOrAddProperties<Properties>().rhs_columns = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), rhs_columns);
  odsState.addTypes(res);
}

void MatrixMultiplyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, uint32_t lhs_rows, uint32_t lhs_columns, uint32_t rhs_columns) {
  odsState.addOperands(lhs);
  odsState.addOperands(rhs);
  odsState.getOrAddProperties<Properties>().lhs_rows = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), lhs_rows);
  odsState.getOrAddProperties<Properties>().lhs_columns = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), lhs_columns);
  odsState.getOrAddProperties<Properties>().rhs_columns = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), rhs_columns);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MatrixMultiplyOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult MatrixMultiplyOp::verifyInvariantsImpl() {
  auto tblgen_lhs_columns = getProperties().lhs_columns; (void)tblgen_lhs_columns;
  if (!tblgen_lhs_columns) return emitOpError("requires attribute 'lhs_columns'");
  auto tblgen_lhs_rows = getProperties().lhs_rows; (void)tblgen_lhs_rows;
  if (!tblgen_lhs_rows) return emitOpError("requires attribute 'lhs_rows'");
  auto tblgen_rhs_columns = getProperties().rhs_columns; (void)tblgen_rhs_columns;
  if (!tblgen_rhs_columns) return emitOpError("requires attribute 'rhs_columns'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(*this, tblgen_lhs_rows, "lhs_rows")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(*this, tblgen_lhs_columns, "lhs_columns")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(*this, tblgen_rhs_columns, "rhs_columns")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps11(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps11(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps11(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult MatrixMultiplyOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult MatrixMultiplyOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand lhsRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> lhsOperands(lhsRawOperands);  ::llvm::SMLoc lhsOperandsLoc;
  (void)lhsOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand rhsRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> rhsOperands(rhsRawOperands);  ::llvm::SMLoc rhsOperandsLoc;
  (void)rhsOperandsLoc;
  ::mlir::Type lhsRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> lhsTypes(lhsRawTypes);
  ::mlir::Type rhsRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> rhsTypes(rhsRawTypes);
  ::mlir::Type resRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> resTypes(resRawTypes);

  lhsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(lhsRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  rhsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(rhsRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    lhsRawTypes[0] = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    rhsRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawTypes[0] = type;
  }
  result.addTypes(resTypes);
  if (parser.resolveOperands(lhsOperands, lhsTypes, lhsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(rhsOperands, rhsTypes, rhsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void MatrixMultiplyOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getLhs();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getRhs();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ' << "(";
  {
    auto type = getLhs().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getRhs().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::MatrixMultiplyOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::MatrixTransposeOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MatrixTransposeOpGenericAdaptorBase::MatrixTransposeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.matrix.transpose", odsAttrs.getContext());
}

MatrixTransposeOpGenericAdaptorBase::MatrixTransposeOpGenericAdaptorBase(MatrixTransposeOp op) : MatrixTransposeOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> MatrixTransposeOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr MatrixTransposeOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr MatrixTransposeOpGenericAdaptorBase::getRowsAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().rows);
  return attr;
}

uint32_t MatrixTransposeOpGenericAdaptorBase::getRows() {
  auto attr = getRowsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr MatrixTransposeOpGenericAdaptorBase::getColumnsAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().columns);
  return attr;
}

uint32_t MatrixTransposeOpGenericAdaptorBase::getColumns() {
  auto attr = getColumnsAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
MatrixTransposeOpAdaptor::MatrixTransposeOpAdaptor(MatrixTransposeOp op) : MatrixTransposeOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult MatrixTransposeOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_columns = getProperties().columns; (void)tblgen_columns;
  if (!tblgen_columns) return emitError(loc, "'llvm.intr.matrix.transpose' op ""requires attribute 'columns'");
  auto tblgen_rows = getProperties().rows; (void)tblgen_rows;
  if (!tblgen_rows) return emitError(loc, "'llvm.intr.matrix.transpose' op ""requires attribute 'rows'");

  if (tblgen_rows && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_rows))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_rows).getType().isSignlessInteger(32)))))
    return emitError(loc, "'llvm.intr.matrix.transpose' op ""attribute 'rows' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_columns && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_columns))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_columns).getType().isSignlessInteger(32)))))
    return emitError(loc, "'llvm.intr.matrix.transpose' op ""attribute 'columns' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> MatrixTransposeOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range MatrixTransposeOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MatrixTransposeOp::getMatrix() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &MatrixTransposeOp::getMatrixMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> MatrixTransposeOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range MatrixTransposeOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MatrixTransposeOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult MatrixTransposeOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.columns;
       auto attr = dict.get("columns");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for columns in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `columns` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.rows;
       auto attr = dict.get("rows");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for rows in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `rows` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MatrixTransposeOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.columns;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("columns",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.rows;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("rows",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MatrixTransposeOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.columns.getAsOpaquePointer()), 
    llvm::hash_value(prop.rows.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MatrixTransposeOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "columns")
      return prop.columns;

    if (name == "rows")
      return prop.rows;
  return std::nullopt;
}

void MatrixTransposeOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "columns") {
       prop.columns = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.columns)>>(value);
       return;
    }

    if (name == "rows") {
       prop.rows = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.rows)>>(value);
       return;
    }
}

void MatrixTransposeOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.columns) attrs.append("columns", prop.columns);

    if (prop.rows) attrs.append("rows", prop.rows);
}

::mlir::LogicalResult MatrixTransposeOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getColumnsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, "columns", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getRowsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, "rows", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult MatrixTransposeOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.columns)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.rows)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MatrixTransposeOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.columns);
  writer.writeAttribute(prop.rows);
}

::mlir::IntegerAttr MatrixTransposeOp::getRowsAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().rows);
}

uint32_t MatrixTransposeOp::getRows() {
  auto attr = getRowsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr MatrixTransposeOp::getColumnsAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().columns);
}

uint32_t MatrixTransposeOp::getColumns() {
  auto attr = getColumnsAttr();
  return attr.getValue().getZExtValue();
}

void MatrixTransposeOp::setRowsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getRowsAttrName(), attr);
}

void MatrixTransposeOp::setRows(uint32_t attrValue) {
  (*this)->setAttr(getRowsAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void MatrixTransposeOp::setColumnsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getColumnsAttrName(), attr);
}

void MatrixTransposeOp::setColumns(uint32_t attrValue) {
  (*this)->setAttr(getColumnsAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void MatrixTransposeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type resultType, ValueRange operands, ArrayRef<NamedAttribute> attributes) {
    if (resultType) odsState.addTypes(resultType);
    odsState.addOperands(operands);
    for (auto namedAttr : attributes)
      odsState.addAttribute(namedAttr.getName(), namedAttr.getValue());
  
}

void MatrixTransposeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value matrix, ::mlir::IntegerAttr rows, ::mlir::IntegerAttr columns) {
  odsState.addOperands(matrix);
  odsState.getOrAddProperties<Properties>().rows = rows;
  odsState.getOrAddProperties<Properties>().columns = columns;
  odsState.addTypes(res);
}

void MatrixTransposeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value matrix, ::mlir::IntegerAttr rows, ::mlir::IntegerAttr columns) {
  odsState.addOperands(matrix);
  odsState.getOrAddProperties<Properties>().rows = rows;
  odsState.getOrAddProperties<Properties>().columns = columns;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MatrixTransposeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value matrix, uint32_t rows, uint32_t columns) {
  odsState.addOperands(matrix);
  odsState.getOrAddProperties<Properties>().rows = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), rows);
  odsState.getOrAddProperties<Properties>().columns = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), columns);
  odsState.addTypes(res);
}

void MatrixTransposeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value matrix, uint32_t rows, uint32_t columns) {
  odsState.addOperands(matrix);
  odsState.getOrAddProperties<Properties>().rows = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), rows);
  odsState.getOrAddProperties<Properties>().columns = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), columns);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MatrixTransposeOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult MatrixTransposeOp::verifyInvariantsImpl() {
  auto tblgen_columns = getProperties().columns; (void)tblgen_columns;
  if (!tblgen_columns) return emitOpError("requires attribute 'columns'");
  auto tblgen_rows = getProperties().rows; (void)tblgen_rows;
  if (!tblgen_rows) return emitOpError("requires attribute 'rows'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(*this, tblgen_rows, "rows")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(*this, tblgen_columns, "columns")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps11(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps11(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult MatrixTransposeOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult MatrixTransposeOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand matrixRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> matrixOperands(matrixRawOperands);  ::llvm::SMLoc matrixOperandsLoc;
  (void)matrixOperandsLoc;
  ::mlir::Type matrixRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> matrixTypes(matrixRawTypes);
  ::mlir::Type resRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> resTypes(resRawTypes);

  matrixOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(matrixRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    matrixRawTypes[0] = type;
  }
  if (parser.parseKeyword("into"))
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resRawTypes[0] = type;
  }
  result.addTypes(resTypes);
  if (parser.resolveOperands(matrixOperands, matrixTypes, matrixOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void MatrixTransposeOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getMatrix();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getMatrix().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ' ' << "into";
  _odsPrinter << ' ';
  {
    auto type = getRes().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::MatrixTransposeOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::MaxNumOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MaxNumOpGenericAdaptorBase::MaxNumOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.maxnum", odsAttrs.getContext());
}

MaxNumOpGenericAdaptorBase::MaxNumOpGenericAdaptorBase(MaxNumOp op) : MaxNumOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> MaxNumOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr MaxNumOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr MaxNumOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags MaxNumOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
MaxNumOpAdaptor::MaxNumOpAdaptor(MaxNumOp op) : MaxNumOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult MaxNumOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.maxnum' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> MaxNumOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range MaxNumOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MaxNumOp::getA() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value MaxNumOp::getB() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::OpOperand &MaxNumOp::getAMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MaxNumOp::getBMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> MaxNumOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range MaxNumOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MaxNumOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult MaxNumOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MaxNumOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MaxNumOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MaxNumOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void MaxNumOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void MaxNumOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult MaxNumOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult MaxNumOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MaxNumOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr MaxNumOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags MaxNumOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void MaxNumOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void MaxNumOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void MaxNumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void MaxNumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(MaxNumOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void MaxNumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MaxNumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void MaxNumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(MaxNumOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void MaxNumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MaxNumOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void MaxNumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(MaxNumOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void MaxNumOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult MaxNumOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult MaxNumOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult MaxNumOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult MaxNumOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void MaxNumOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void MaxNumOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::MaxNumOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::MaximumOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MaximumOpGenericAdaptorBase::MaximumOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.maximum", odsAttrs.getContext());
}

MaximumOpGenericAdaptorBase::MaximumOpGenericAdaptorBase(MaximumOp op) : MaximumOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> MaximumOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr MaximumOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr MaximumOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags MaximumOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
MaximumOpAdaptor::MaximumOpAdaptor(MaximumOp op) : MaximumOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult MaximumOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.maximum' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> MaximumOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range MaximumOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MaximumOp::getA() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value MaximumOp::getB() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::OpOperand &MaximumOp::getAMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MaximumOp::getBMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> MaximumOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range MaximumOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MaximumOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult MaximumOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MaximumOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MaximumOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MaximumOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void MaximumOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void MaximumOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult MaximumOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult MaximumOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MaximumOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr MaximumOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags MaximumOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void MaximumOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void MaximumOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void MaximumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void MaximumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(MaximumOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void MaximumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MaximumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void MaximumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(MaximumOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void MaximumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MaximumOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void MaximumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(MaximumOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void MaximumOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult MaximumOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult MaximumOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult MaximumOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult MaximumOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void MaximumOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void MaximumOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::MaximumOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::MemcpyInlineOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MemcpyInlineOpGenericAdaptorBase::MemcpyInlineOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.memcpy.inline", odsAttrs.getContext());
}

MemcpyInlineOpGenericAdaptorBase::MemcpyInlineOpGenericAdaptorBase(MemcpyInlineOp op) : MemcpyInlineOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> MemcpyInlineOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr MemcpyInlineOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr MemcpyInlineOpGenericAdaptorBase::getLenAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().len);
  return attr;
}

::mlir::APInt MemcpyInlineOpGenericAdaptorBase::getLen() {
  auto attr = getLenAttr();
  return attr.getValue();
}

::mlir::IntegerAttr MemcpyInlineOpGenericAdaptorBase::getIsVolatileAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().isVolatile);
  return attr;
}

bool MemcpyInlineOpGenericAdaptorBase::getIsVolatile() {
  auto attr = getIsVolatileAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr MemcpyInlineOpGenericAdaptorBase::getAccessGroupsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemcpyInlineOpGenericAdaptorBase::getAccessGroups() {
  auto attr = getAccessGroupsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemcpyInlineOpGenericAdaptorBase::getAliasScopesAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemcpyInlineOpGenericAdaptorBase::getAliasScopes() {
  auto attr = getAliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemcpyInlineOpGenericAdaptorBase::getNoaliasScopesAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemcpyInlineOpGenericAdaptorBase::getNoaliasScopes() {
  auto attr = getNoaliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemcpyInlineOpGenericAdaptorBase::getTbaaAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemcpyInlineOpGenericAdaptorBase::getTbaa() {
  auto attr = getTbaaAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
MemcpyInlineOpAdaptor::MemcpyInlineOpAdaptor(MemcpyInlineOp op) : MemcpyInlineOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult MemcpyInlineOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_access_groups = getProperties().access_groups; (void)tblgen_access_groups;
  auto tblgen_alias_scopes = getProperties().alias_scopes; (void)tblgen_alias_scopes;
  auto tblgen_isVolatile = getProperties().isVolatile; (void)tblgen_isVolatile;
  if (!tblgen_isVolatile) return emitError(loc, "'llvm.intr.memcpy.inline' op ""requires attribute 'isVolatile'");
  auto tblgen_len = getProperties().len; (void)tblgen_len;
  if (!tblgen_len) return emitError(loc, "'llvm.intr.memcpy.inline' op ""requires attribute 'len'");
  auto tblgen_noalias_scopes = getProperties().noalias_scopes; (void)tblgen_noalias_scopes;
  auto tblgen_tbaa = getProperties().tbaa; (void)tblgen_tbaa;

  if (tblgen_len && !((::llvm::isa<::mlir::IntegerAttr>(tblgen_len))))
    return emitError(loc, "'llvm.intr.memcpy.inline' op ""attribute 'len' failed to satisfy constraint: arbitrary integer attribute");

  if (tblgen_isVolatile && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_isVolatile))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_isVolatile).getType().isSignlessInteger(1)))))
    return emitError(loc, "'llvm.intr.memcpy.inline' op ""attribute 'isVolatile' failed to satisfy constraint: 1-bit signless integer attribute");

  if (tblgen_access_groups && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_access_groups))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_access_groups), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::AccessGroupAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memcpy.inline' op ""attribute 'access_groups' failed to satisfy constraint: LLVM dialect access group metadata array");

  if (tblgen_alias_scopes && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_alias_scopes))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_alias_scopes), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::AliasScopeAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memcpy.inline' op ""attribute 'alias_scopes' failed to satisfy constraint: LLVM dialect alias scope array");

  if (tblgen_noalias_scopes && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_noalias_scopes))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_noalias_scopes), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::AliasScopeAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memcpy.inline' op ""attribute 'noalias_scopes' failed to satisfy constraint: LLVM dialect alias scope array");

  if (tblgen_tbaa && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_tbaa))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_tbaa), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::TBAATagAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memcpy.inline' op ""attribute 'tbaa' failed to satisfy constraint: LLVM dialect TBAA tag metadata array");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> MemcpyInlineOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range MemcpyInlineOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> MemcpyInlineOp::getDst() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> MemcpyInlineOp::getSrc() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
}

::mlir::OpOperand &MemcpyInlineOp::getDstMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MemcpyInlineOp::getSrcMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> MemcpyInlineOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range MemcpyInlineOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult MemcpyInlineOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.access_groups;
       auto attr = dict.get("access_groups");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for access_groups in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `access_groups` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.alias_scopes;
       auto attr = dict.get("alias_scopes");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for alias_scopes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `alias_scopes` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.isVolatile;
       auto attr = dict.get("isVolatile");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for isVolatile in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `isVolatile` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.len;
       auto attr = dict.get("len");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for len in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `len` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.noalias_scopes;
       auto attr = dict.get("noalias_scopes");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for noalias_scopes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `noalias_scopes` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.tbaa;
       auto attr = dict.get("tbaa");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for tbaa in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tbaa` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MemcpyInlineOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.access_groups;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("access_groups",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.alias_scopes;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("alias_scopes",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.isVolatile;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("isVolatile",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.len;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("len",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.noalias_scopes;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("noalias_scopes",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.tbaa;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("tbaa",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MemcpyInlineOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.access_groups.getAsOpaquePointer()), 
    llvm::hash_value(prop.alias_scopes.getAsOpaquePointer()), 
    llvm::hash_value(prop.isVolatile.getAsOpaquePointer()), 
    llvm::hash_value(prop.len.getAsOpaquePointer()), 
    llvm::hash_value(prop.noalias_scopes.getAsOpaquePointer()), 
    llvm::hash_value(prop.tbaa.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MemcpyInlineOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "access_groups")
      return prop.access_groups;

    if (name == "alias_scopes")
      return prop.alias_scopes;

    if (name == "isVolatile")
      return prop.isVolatile;

    if (name == "len")
      return prop.len;

    if (name == "noalias_scopes")
      return prop.noalias_scopes;

    if (name == "tbaa")
      return prop.tbaa;
  return std::nullopt;
}

void MemcpyInlineOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "access_groups") {
       prop.access_groups = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.access_groups)>>(value);
       return;
    }

    if (name == "alias_scopes") {
       prop.alias_scopes = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.alias_scopes)>>(value);
       return;
    }

    if (name == "isVolatile") {
       prop.isVolatile = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.isVolatile)>>(value);
       return;
    }

    if (name == "len") {
       prop.len = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.len)>>(value);
       return;
    }

    if (name == "noalias_scopes") {
       prop.noalias_scopes = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.noalias_scopes)>>(value);
       return;
    }

    if (name == "tbaa") {
       prop.tbaa = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.tbaa)>>(value);
       return;
    }
}

void MemcpyInlineOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.access_groups) attrs.append("access_groups", prop.access_groups);

    if (prop.alias_scopes) attrs.append("alias_scopes", prop.alias_scopes);

    if (prop.isVolatile) attrs.append("isVolatile", prop.isVolatile);

    if (prop.len) attrs.append("len", prop.len);

    if (prop.noalias_scopes) attrs.append("noalias_scopes", prop.noalias_scopes);

    if (prop.tbaa) attrs.append("tbaa", prop.tbaa);
}

::mlir::LogicalResult MemcpyInlineOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getAccessGroupsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps8(attr, "access_groups", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getAliasScopesAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(attr, "alias_scopes", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getIsVolatileAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(attr, "isVolatile", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getLenAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps7(attr, "len", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNoaliasScopesAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(attr, "noalias_scopes", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTbaaAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps10(attr, "tbaa", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult MemcpyInlineOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.access_groups)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.alias_scopes)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.isVolatile)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.len)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.noalias_scopes)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.tbaa)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MemcpyInlineOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.access_groups);

  writer.writeOptionalAttribute(prop.alias_scopes);
  writer.writeAttribute(prop.isVolatile);
  writer.writeAttribute(prop.len);

  writer.writeOptionalAttribute(prop.noalias_scopes);

  writer.writeOptionalAttribute(prop.tbaa);
}

::mlir::IntegerAttr MemcpyInlineOp::getLenAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().len);
}

::mlir::APInt MemcpyInlineOp::getLen() {
  auto attr = getLenAttr();
  return attr.getValue();
}

::mlir::IntegerAttr MemcpyInlineOp::getIsVolatileAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().isVolatile);
}

bool MemcpyInlineOp::getIsVolatile() {
  auto attr = getIsVolatileAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr MemcpyInlineOp::getAccessGroupsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
}

::std::optional< ::mlir::ArrayAttr > MemcpyInlineOp::getAccessGroups() {
  auto attr = getAccessGroupsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemcpyInlineOp::getAliasScopesAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
}

::std::optional< ::mlir::ArrayAttr > MemcpyInlineOp::getAliasScopes() {
  auto attr = getAliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemcpyInlineOp::getNoaliasScopesAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
}

::std::optional< ::mlir::ArrayAttr > MemcpyInlineOp::getNoaliasScopes() {
  auto attr = getNoaliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemcpyInlineOp::getTbaaAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
}

::std::optional< ::mlir::ArrayAttr > MemcpyInlineOp::getTbaa() {
  auto attr = getTbaaAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void MemcpyInlineOp::setLenAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getLenAttrName(), attr);
}

void MemcpyInlineOp::setIsVolatileAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getIsVolatileAttrName(), attr);
}

void MemcpyInlineOp::setIsVolatile(bool attrValue) {
  (*this)->setAttr(getIsVolatileAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(1), attrValue));
}

void MemcpyInlineOp::setAccessGroupsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getAccessGroupsAttrName(), attr);
}

void MemcpyInlineOp::setAliasScopesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getAliasScopesAttrName(), attr);
}

void MemcpyInlineOp::setNoaliasScopesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getNoaliasScopesAttrName(), attr);
}

void MemcpyInlineOp::setTbaaAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getTbaaAttrName(), attr);
}

::mlir::Attribute MemcpyInlineOp::removeAccessGroupsAttr() {
    auto &attr = getProperties().access_groups;
    attr = {};
    return attr;
}

::mlir::Attribute MemcpyInlineOp::removeAliasScopesAttr() {
    auto &attr = getProperties().alias_scopes;
    attr = {};
    return attr;
}

::mlir::Attribute MemcpyInlineOp::removeNoaliasScopesAttr() {
    auto &attr = getProperties().noalias_scopes;
    attr = {};
    return attr;
}

::mlir::Attribute MemcpyInlineOp::removeTbaaAttr() {
    auto &attr = getProperties().tbaa;
    attr = {};
    return attr;
}

void MemcpyInlineOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value dst, Value src, IntegerAttr len, bool isVolatile) {
      build(odsBuilder, odsState, dst, src, len,
            odsBuilder.getBoolAttr(isVolatile));
    
}

void MemcpyInlineOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value dst, Value src, IntegerAttr len, IntegerAttr isVolatile) {
      build(odsBuilder, odsState, dst, src, len, isVolatile,
            /*access_groups=*/nullptr, /*alias_scopes=*/nullptr,
            /*noalias_scopes=*/nullptr, /*tbaa=*/nullptr);
    
}

void MemcpyInlineOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value dst, ::mlir::Value src, ::mlir::IntegerAttr len, ::mlir::IntegerAttr isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(src);
  odsState.getOrAddProperties<Properties>().len = len;
  odsState.getOrAddProperties<Properties>().isVolatile = isVolatile;
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
}

void MemcpyInlineOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dst, ::mlir::Value src, ::mlir::IntegerAttr len, ::mlir::IntegerAttr isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(src);
  odsState.getOrAddProperties<Properties>().len = len;
  odsState.getOrAddProperties<Properties>().isVolatile = isVolatile;
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MemcpyInlineOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value dst, ::mlir::Value src, ::mlir::IntegerAttr len, bool isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(src);
  odsState.getOrAddProperties<Properties>().len = len;
  odsState.getOrAddProperties<Properties>().isVolatile = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), isVolatile);
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
}

void MemcpyInlineOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dst, ::mlir::Value src, ::mlir::IntegerAttr len, bool isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(src);
  odsState.getOrAddProperties<Properties>().len = len;
  odsState.getOrAddProperties<Properties>().isVolatile = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), isVolatile);
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MemcpyInlineOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult MemcpyInlineOp::verifyInvariantsImpl() {
  auto tblgen_access_groups = getProperties().access_groups; (void)tblgen_access_groups;
  auto tblgen_alias_scopes = getProperties().alias_scopes; (void)tblgen_alias_scopes;
  auto tblgen_isVolatile = getProperties().isVolatile; (void)tblgen_isVolatile;
  if (!tblgen_isVolatile) return emitOpError("requires attribute 'isVolatile'");
  auto tblgen_len = getProperties().len; (void)tblgen_len;
  if (!tblgen_len) return emitOpError("requires attribute 'len'");
  auto tblgen_noalias_scopes = getProperties().noalias_scopes; (void)tblgen_noalias_scopes;
  auto tblgen_tbaa = getProperties().tbaa; (void)tblgen_tbaa;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps7(*this, tblgen_len, "len")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(*this, tblgen_isVolatile, "isVolatile")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps8(*this, tblgen_access_groups, "access_groups")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(*this, tblgen_alias_scopes, "alias_scopes")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(*this, tblgen_noalias_scopes, "noalias_scopes")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps10(*this, tblgen_tbaa, "tbaa")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult MemcpyInlineOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

void MemcpyInlineOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  for (::mlir::Value value : getODSOperands(0))
    effects.emplace_back(::mlir::MemoryEffects::Write::get(), value, 0, false, ::mlir::SideEffects::DefaultResource::get());
  for (::mlir::Value value : getODSOperands(1))
    effects.emplace_back(::mlir::MemoryEffects::Read::get(), value, 0, false, ::mlir::SideEffects::DefaultResource::get());
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::MemcpyInlineOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::MemcpyOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MemcpyOpGenericAdaptorBase::MemcpyOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.memcpy", odsAttrs.getContext());
}

MemcpyOpGenericAdaptorBase::MemcpyOpGenericAdaptorBase(MemcpyOp op) : MemcpyOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> MemcpyOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr MemcpyOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr MemcpyOpGenericAdaptorBase::getIsVolatileAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().isVolatile);
  return attr;
}

bool MemcpyOpGenericAdaptorBase::getIsVolatile() {
  auto attr = getIsVolatileAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr MemcpyOpGenericAdaptorBase::getAccessGroupsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemcpyOpGenericAdaptorBase::getAccessGroups() {
  auto attr = getAccessGroupsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemcpyOpGenericAdaptorBase::getAliasScopesAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemcpyOpGenericAdaptorBase::getAliasScopes() {
  auto attr = getAliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemcpyOpGenericAdaptorBase::getNoaliasScopesAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemcpyOpGenericAdaptorBase::getNoaliasScopes() {
  auto attr = getNoaliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemcpyOpGenericAdaptorBase::getTbaaAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemcpyOpGenericAdaptorBase::getTbaa() {
  auto attr = getTbaaAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
MemcpyOpAdaptor::MemcpyOpAdaptor(MemcpyOp op) : MemcpyOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult MemcpyOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_access_groups = getProperties().access_groups; (void)tblgen_access_groups;
  auto tblgen_alias_scopes = getProperties().alias_scopes; (void)tblgen_alias_scopes;
  auto tblgen_isVolatile = getProperties().isVolatile; (void)tblgen_isVolatile;
  if (!tblgen_isVolatile) return emitError(loc, "'llvm.intr.memcpy' op ""requires attribute 'isVolatile'");
  auto tblgen_noalias_scopes = getProperties().noalias_scopes; (void)tblgen_noalias_scopes;
  auto tblgen_tbaa = getProperties().tbaa; (void)tblgen_tbaa;

  if (tblgen_isVolatile && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_isVolatile))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_isVolatile).getType().isSignlessInteger(1)))))
    return emitError(loc, "'llvm.intr.memcpy' op ""attribute 'isVolatile' failed to satisfy constraint: 1-bit signless integer attribute");

  if (tblgen_access_groups && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_access_groups))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_access_groups), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::AccessGroupAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memcpy' op ""attribute 'access_groups' failed to satisfy constraint: LLVM dialect access group metadata array");

  if (tblgen_alias_scopes && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_alias_scopes))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_alias_scopes), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::AliasScopeAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memcpy' op ""attribute 'alias_scopes' failed to satisfy constraint: LLVM dialect alias scope array");

  if (tblgen_noalias_scopes && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_noalias_scopes))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_noalias_scopes), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::AliasScopeAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memcpy' op ""attribute 'noalias_scopes' failed to satisfy constraint: LLVM dialect alias scope array");

  if (tblgen_tbaa && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_tbaa))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_tbaa), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::TBAATagAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memcpy' op ""attribute 'tbaa' failed to satisfy constraint: LLVM dialect TBAA tag metadata array");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> MemcpyOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range MemcpyOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> MemcpyOp::getDst() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> MemcpyOp::getSrc() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
}

::mlir::TypedValue<::mlir::IntegerType> MemcpyOp::getLen() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
}

::mlir::OpOperand &MemcpyOp::getDstMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MemcpyOp::getSrcMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MemcpyOp::getLenMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> MemcpyOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range MemcpyOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult MemcpyOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.access_groups;
       auto attr = dict.get("access_groups");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for access_groups in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `access_groups` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.alias_scopes;
       auto attr = dict.get("alias_scopes");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for alias_scopes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `alias_scopes` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.isVolatile;
       auto attr = dict.get("isVolatile");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for isVolatile in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `isVolatile` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.noalias_scopes;
       auto attr = dict.get("noalias_scopes");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for noalias_scopes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `noalias_scopes` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.tbaa;
       auto attr = dict.get("tbaa");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for tbaa in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tbaa` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MemcpyOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.access_groups;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("access_groups",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.alias_scopes;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("alias_scopes",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.isVolatile;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("isVolatile",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.noalias_scopes;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("noalias_scopes",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.tbaa;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("tbaa",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MemcpyOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.access_groups.getAsOpaquePointer()), 
    llvm::hash_value(prop.alias_scopes.getAsOpaquePointer()), 
    llvm::hash_value(prop.isVolatile.getAsOpaquePointer()), 
    llvm::hash_value(prop.noalias_scopes.getAsOpaquePointer()), 
    llvm::hash_value(prop.tbaa.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MemcpyOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "access_groups")
      return prop.access_groups;

    if (name == "alias_scopes")
      return prop.alias_scopes;

    if (name == "isVolatile")
      return prop.isVolatile;

    if (name == "noalias_scopes")
      return prop.noalias_scopes;

    if (name == "tbaa")
      return prop.tbaa;
  return std::nullopt;
}

void MemcpyOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "access_groups") {
       prop.access_groups = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.access_groups)>>(value);
       return;
    }

    if (name == "alias_scopes") {
       prop.alias_scopes = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.alias_scopes)>>(value);
       return;
    }

    if (name == "isVolatile") {
       prop.isVolatile = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.isVolatile)>>(value);
       return;
    }

    if (name == "noalias_scopes") {
       prop.noalias_scopes = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.noalias_scopes)>>(value);
       return;
    }

    if (name == "tbaa") {
       prop.tbaa = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.tbaa)>>(value);
       return;
    }
}

void MemcpyOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.access_groups) attrs.append("access_groups", prop.access_groups);

    if (prop.alias_scopes) attrs.append("alias_scopes", prop.alias_scopes);

    if (prop.isVolatile) attrs.append("isVolatile", prop.isVolatile);

    if (prop.noalias_scopes) attrs.append("noalias_scopes", prop.noalias_scopes);

    if (prop.tbaa) attrs.append("tbaa", prop.tbaa);
}

::mlir::LogicalResult MemcpyOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getAccessGroupsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps8(attr, "access_groups", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getAliasScopesAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(attr, "alias_scopes", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getIsVolatileAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(attr, "isVolatile", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNoaliasScopesAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(attr, "noalias_scopes", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTbaaAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps10(attr, "tbaa", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult MemcpyOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.access_groups)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.alias_scopes)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.isVolatile)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.noalias_scopes)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.tbaa)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MemcpyOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.access_groups);

  writer.writeOptionalAttribute(prop.alias_scopes);
  writer.writeAttribute(prop.isVolatile);

  writer.writeOptionalAttribute(prop.noalias_scopes);

  writer.writeOptionalAttribute(prop.tbaa);
}

::mlir::IntegerAttr MemcpyOp::getIsVolatileAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().isVolatile);
}

bool MemcpyOp::getIsVolatile() {
  auto attr = getIsVolatileAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr MemcpyOp::getAccessGroupsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
}

::std::optional< ::mlir::ArrayAttr > MemcpyOp::getAccessGroups() {
  auto attr = getAccessGroupsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemcpyOp::getAliasScopesAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
}

::std::optional< ::mlir::ArrayAttr > MemcpyOp::getAliasScopes() {
  auto attr = getAliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemcpyOp::getNoaliasScopesAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
}

::std::optional< ::mlir::ArrayAttr > MemcpyOp::getNoaliasScopes() {
  auto attr = getNoaliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemcpyOp::getTbaaAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
}

::std::optional< ::mlir::ArrayAttr > MemcpyOp::getTbaa() {
  auto attr = getTbaaAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void MemcpyOp::setIsVolatileAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getIsVolatileAttrName(), attr);
}

void MemcpyOp::setIsVolatile(bool attrValue) {
  (*this)->setAttr(getIsVolatileAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(1), attrValue));
}

void MemcpyOp::setAccessGroupsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getAccessGroupsAttrName(), attr);
}

void MemcpyOp::setAliasScopesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getAliasScopesAttrName(), attr);
}

void MemcpyOp::setNoaliasScopesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getNoaliasScopesAttrName(), attr);
}

void MemcpyOp::setTbaaAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getTbaaAttrName(), attr);
}

::mlir::Attribute MemcpyOp::removeAccessGroupsAttr() {
    auto &attr = getProperties().access_groups;
    attr = {};
    return attr;
}

::mlir::Attribute MemcpyOp::removeAliasScopesAttr() {
    auto &attr = getProperties().alias_scopes;
    attr = {};
    return attr;
}

::mlir::Attribute MemcpyOp::removeNoaliasScopesAttr() {
    auto &attr = getProperties().noalias_scopes;
    attr = {};
    return attr;
}

::mlir::Attribute MemcpyOp::removeTbaaAttr() {
    auto &attr = getProperties().tbaa;
    attr = {};
    return attr;
}

void MemcpyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value dst, Value src, Value len, bool isVolatile) {
      build(odsBuilder, odsState, dst, src, len,
            odsBuilder.getBoolAttr(isVolatile));
    
}

void MemcpyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value dst, Value src, Value len, IntegerAttr isVolatile) {
      build(odsBuilder, odsState, dst, src, len, isVolatile,
            /*access_groups=*/nullptr, /*alias_scopes=*/nullptr,
            /*noalias_scopes=*/nullptr, /*tbaa=*/nullptr);
    
}

void MemcpyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value dst, ::mlir::Value src, ::mlir::Value len, ::mlir::IntegerAttr isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(src);
  odsState.addOperands(len);
  odsState.getOrAddProperties<Properties>().isVolatile = isVolatile;
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
}

void MemcpyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dst, ::mlir::Value src, ::mlir::Value len, ::mlir::IntegerAttr isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(src);
  odsState.addOperands(len);
  odsState.getOrAddProperties<Properties>().isVolatile = isVolatile;
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MemcpyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value dst, ::mlir::Value src, ::mlir::Value len, bool isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(src);
  odsState.addOperands(len);
  odsState.getOrAddProperties<Properties>().isVolatile = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), isVolatile);
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
}

void MemcpyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dst, ::mlir::Value src, ::mlir::Value len, bool isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(src);
  odsState.addOperands(len);
  odsState.getOrAddProperties<Properties>().isVolatile = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), isVolatile);
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MemcpyOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult MemcpyOp::verifyInvariantsImpl() {
  auto tblgen_access_groups = getProperties().access_groups; (void)tblgen_access_groups;
  auto tblgen_alias_scopes = getProperties().alias_scopes; (void)tblgen_alias_scopes;
  auto tblgen_isVolatile = getProperties().isVolatile; (void)tblgen_isVolatile;
  if (!tblgen_isVolatile) return emitOpError("requires attribute 'isVolatile'");
  auto tblgen_noalias_scopes = getProperties().noalias_scopes; (void)tblgen_noalias_scopes;
  auto tblgen_tbaa = getProperties().tbaa; (void)tblgen_tbaa;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(*this, tblgen_isVolatile, "isVolatile")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps8(*this, tblgen_access_groups, "access_groups")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(*this, tblgen_alias_scopes, "alias_scopes")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(*this, tblgen_noalias_scopes, "noalias_scopes")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps10(*this, tblgen_tbaa, "tbaa")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult MemcpyOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

void MemcpyOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  for (::mlir::Value value : getODSOperands(0))
    effects.emplace_back(::mlir::MemoryEffects::Write::get(), value, 0, false, ::mlir::SideEffects::DefaultResource::get());
  for (::mlir::Value value : getODSOperands(1))
    effects.emplace_back(::mlir::MemoryEffects::Read::get(), value, 0, false, ::mlir::SideEffects::DefaultResource::get());
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::MemcpyOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::MemmoveOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MemmoveOpGenericAdaptorBase::MemmoveOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.memmove", odsAttrs.getContext());
}

MemmoveOpGenericAdaptorBase::MemmoveOpGenericAdaptorBase(MemmoveOp op) : MemmoveOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> MemmoveOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr MemmoveOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr MemmoveOpGenericAdaptorBase::getIsVolatileAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().isVolatile);
  return attr;
}

bool MemmoveOpGenericAdaptorBase::getIsVolatile() {
  auto attr = getIsVolatileAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr MemmoveOpGenericAdaptorBase::getAccessGroupsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemmoveOpGenericAdaptorBase::getAccessGroups() {
  auto attr = getAccessGroupsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemmoveOpGenericAdaptorBase::getAliasScopesAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemmoveOpGenericAdaptorBase::getAliasScopes() {
  auto attr = getAliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemmoveOpGenericAdaptorBase::getNoaliasScopesAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemmoveOpGenericAdaptorBase::getNoaliasScopes() {
  auto attr = getNoaliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemmoveOpGenericAdaptorBase::getTbaaAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemmoveOpGenericAdaptorBase::getTbaa() {
  auto attr = getTbaaAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
MemmoveOpAdaptor::MemmoveOpAdaptor(MemmoveOp op) : MemmoveOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult MemmoveOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_access_groups = getProperties().access_groups; (void)tblgen_access_groups;
  auto tblgen_alias_scopes = getProperties().alias_scopes; (void)tblgen_alias_scopes;
  auto tblgen_isVolatile = getProperties().isVolatile; (void)tblgen_isVolatile;
  if (!tblgen_isVolatile) return emitError(loc, "'llvm.intr.memmove' op ""requires attribute 'isVolatile'");
  auto tblgen_noalias_scopes = getProperties().noalias_scopes; (void)tblgen_noalias_scopes;
  auto tblgen_tbaa = getProperties().tbaa; (void)tblgen_tbaa;

  if (tblgen_isVolatile && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_isVolatile))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_isVolatile).getType().isSignlessInteger(1)))))
    return emitError(loc, "'llvm.intr.memmove' op ""attribute 'isVolatile' failed to satisfy constraint: 1-bit signless integer attribute");

  if (tblgen_access_groups && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_access_groups))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_access_groups), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::AccessGroupAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memmove' op ""attribute 'access_groups' failed to satisfy constraint: LLVM dialect access group metadata array");

  if (tblgen_alias_scopes && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_alias_scopes))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_alias_scopes), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::AliasScopeAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memmove' op ""attribute 'alias_scopes' failed to satisfy constraint: LLVM dialect alias scope array");

  if (tblgen_noalias_scopes && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_noalias_scopes))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_noalias_scopes), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::AliasScopeAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memmove' op ""attribute 'noalias_scopes' failed to satisfy constraint: LLVM dialect alias scope array");

  if (tblgen_tbaa && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_tbaa))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_tbaa), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::TBAATagAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memmove' op ""attribute 'tbaa' failed to satisfy constraint: LLVM dialect TBAA tag metadata array");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> MemmoveOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range MemmoveOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> MemmoveOp::getDst() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> MemmoveOp::getSrc() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
}

::mlir::TypedValue<::mlir::IntegerType> MemmoveOp::getLen() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
}

::mlir::OpOperand &MemmoveOp::getDstMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MemmoveOp::getSrcMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MemmoveOp::getLenMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> MemmoveOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range MemmoveOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult MemmoveOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.access_groups;
       auto attr = dict.get("access_groups");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for access_groups in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `access_groups` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.alias_scopes;
       auto attr = dict.get("alias_scopes");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for alias_scopes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `alias_scopes` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.isVolatile;
       auto attr = dict.get("isVolatile");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for isVolatile in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `isVolatile` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.noalias_scopes;
       auto attr = dict.get("noalias_scopes");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for noalias_scopes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `noalias_scopes` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.tbaa;
       auto attr = dict.get("tbaa");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for tbaa in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tbaa` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MemmoveOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.access_groups;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("access_groups",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.alias_scopes;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("alias_scopes",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.isVolatile;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("isVolatile",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.noalias_scopes;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("noalias_scopes",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.tbaa;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("tbaa",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MemmoveOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.access_groups.getAsOpaquePointer()), 
    llvm::hash_value(prop.alias_scopes.getAsOpaquePointer()), 
    llvm::hash_value(prop.isVolatile.getAsOpaquePointer()), 
    llvm::hash_value(prop.noalias_scopes.getAsOpaquePointer()), 
    llvm::hash_value(prop.tbaa.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MemmoveOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "access_groups")
      return prop.access_groups;

    if (name == "alias_scopes")
      return prop.alias_scopes;

    if (name == "isVolatile")
      return prop.isVolatile;

    if (name == "noalias_scopes")
      return prop.noalias_scopes;

    if (name == "tbaa")
      return prop.tbaa;
  return std::nullopt;
}

void MemmoveOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "access_groups") {
       prop.access_groups = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.access_groups)>>(value);
       return;
    }

    if (name == "alias_scopes") {
       prop.alias_scopes = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.alias_scopes)>>(value);
       return;
    }

    if (name == "isVolatile") {
       prop.isVolatile = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.isVolatile)>>(value);
       return;
    }

    if (name == "noalias_scopes") {
       prop.noalias_scopes = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.noalias_scopes)>>(value);
       return;
    }

    if (name == "tbaa") {
       prop.tbaa = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.tbaa)>>(value);
       return;
    }
}

void MemmoveOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.access_groups) attrs.append("access_groups", prop.access_groups);

    if (prop.alias_scopes) attrs.append("alias_scopes", prop.alias_scopes);

    if (prop.isVolatile) attrs.append("isVolatile", prop.isVolatile);

    if (prop.noalias_scopes) attrs.append("noalias_scopes", prop.noalias_scopes);

    if (prop.tbaa) attrs.append("tbaa", prop.tbaa);
}

::mlir::LogicalResult MemmoveOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getAccessGroupsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps8(attr, "access_groups", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getAliasScopesAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(attr, "alias_scopes", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getIsVolatileAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(attr, "isVolatile", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNoaliasScopesAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(attr, "noalias_scopes", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTbaaAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps10(attr, "tbaa", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult MemmoveOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.access_groups)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.alias_scopes)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.isVolatile)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.noalias_scopes)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.tbaa)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MemmoveOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.access_groups);

  writer.writeOptionalAttribute(prop.alias_scopes);
  writer.writeAttribute(prop.isVolatile);

  writer.writeOptionalAttribute(prop.noalias_scopes);

  writer.writeOptionalAttribute(prop.tbaa);
}

::mlir::IntegerAttr MemmoveOp::getIsVolatileAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().isVolatile);
}

bool MemmoveOp::getIsVolatile() {
  auto attr = getIsVolatileAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr MemmoveOp::getAccessGroupsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
}

::std::optional< ::mlir::ArrayAttr > MemmoveOp::getAccessGroups() {
  auto attr = getAccessGroupsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemmoveOp::getAliasScopesAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
}

::std::optional< ::mlir::ArrayAttr > MemmoveOp::getAliasScopes() {
  auto attr = getAliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemmoveOp::getNoaliasScopesAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
}

::std::optional< ::mlir::ArrayAttr > MemmoveOp::getNoaliasScopes() {
  auto attr = getNoaliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemmoveOp::getTbaaAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
}

::std::optional< ::mlir::ArrayAttr > MemmoveOp::getTbaa() {
  auto attr = getTbaaAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void MemmoveOp::setIsVolatileAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getIsVolatileAttrName(), attr);
}

void MemmoveOp::setIsVolatile(bool attrValue) {
  (*this)->setAttr(getIsVolatileAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(1), attrValue));
}

void MemmoveOp::setAccessGroupsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getAccessGroupsAttrName(), attr);
}

void MemmoveOp::setAliasScopesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getAliasScopesAttrName(), attr);
}

void MemmoveOp::setNoaliasScopesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getNoaliasScopesAttrName(), attr);
}

void MemmoveOp::setTbaaAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getTbaaAttrName(), attr);
}

::mlir::Attribute MemmoveOp::removeAccessGroupsAttr() {
    auto &attr = getProperties().access_groups;
    attr = {};
    return attr;
}

::mlir::Attribute MemmoveOp::removeAliasScopesAttr() {
    auto &attr = getProperties().alias_scopes;
    attr = {};
    return attr;
}

::mlir::Attribute MemmoveOp::removeNoaliasScopesAttr() {
    auto &attr = getProperties().noalias_scopes;
    attr = {};
    return attr;
}

::mlir::Attribute MemmoveOp::removeTbaaAttr() {
    auto &attr = getProperties().tbaa;
    attr = {};
    return attr;
}

void MemmoveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value dst, Value src, Value len, bool isVolatile) {
      build(odsBuilder, odsState, dst, src, len,
            odsBuilder.getBoolAttr(isVolatile));
    
}

void MemmoveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value dst, Value src, Value len, IntegerAttr isVolatile) {
      build(odsBuilder, odsState, dst, src, len, isVolatile,
            /*access_groups=*/nullptr, /*alias_scopes=*/nullptr,
            /*noalias_scopes=*/nullptr, /*tbaa=*/nullptr);
    
}

void MemmoveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value dst, ::mlir::Value src, ::mlir::Value len, ::mlir::IntegerAttr isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(src);
  odsState.addOperands(len);
  odsState.getOrAddProperties<Properties>().isVolatile = isVolatile;
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
}

void MemmoveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dst, ::mlir::Value src, ::mlir::Value len, ::mlir::IntegerAttr isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(src);
  odsState.addOperands(len);
  odsState.getOrAddProperties<Properties>().isVolatile = isVolatile;
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MemmoveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value dst, ::mlir::Value src, ::mlir::Value len, bool isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(src);
  odsState.addOperands(len);
  odsState.getOrAddProperties<Properties>().isVolatile = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), isVolatile);
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
}

void MemmoveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dst, ::mlir::Value src, ::mlir::Value len, bool isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(src);
  odsState.addOperands(len);
  odsState.getOrAddProperties<Properties>().isVolatile = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), isVolatile);
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MemmoveOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult MemmoveOp::verifyInvariantsImpl() {
  auto tblgen_access_groups = getProperties().access_groups; (void)tblgen_access_groups;
  auto tblgen_alias_scopes = getProperties().alias_scopes; (void)tblgen_alias_scopes;
  auto tblgen_isVolatile = getProperties().isVolatile; (void)tblgen_isVolatile;
  if (!tblgen_isVolatile) return emitOpError("requires attribute 'isVolatile'");
  auto tblgen_noalias_scopes = getProperties().noalias_scopes; (void)tblgen_noalias_scopes;
  auto tblgen_tbaa = getProperties().tbaa; (void)tblgen_tbaa;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(*this, tblgen_isVolatile, "isVolatile")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps8(*this, tblgen_access_groups, "access_groups")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(*this, tblgen_alias_scopes, "alias_scopes")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(*this, tblgen_noalias_scopes, "noalias_scopes")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps10(*this, tblgen_tbaa, "tbaa")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult MemmoveOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

void MemmoveOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  for (::mlir::Value value : getODSOperands(0))
    effects.emplace_back(::mlir::MemoryEffects::Write::get(), value, 0, false, ::mlir::SideEffects::DefaultResource::get());
  for (::mlir::Value value : getODSOperands(1))
    effects.emplace_back(::mlir::MemoryEffects::Read::get(), value, 0, false, ::mlir::SideEffects::DefaultResource::get());
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::MemmoveOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::MemsetOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MemsetOpGenericAdaptorBase::MemsetOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.memset", odsAttrs.getContext());
}

MemsetOpGenericAdaptorBase::MemsetOpGenericAdaptorBase(MemsetOp op) : MemsetOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> MemsetOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr MemsetOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr MemsetOpGenericAdaptorBase::getIsVolatileAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().isVolatile);
  return attr;
}

bool MemsetOpGenericAdaptorBase::getIsVolatile() {
  auto attr = getIsVolatileAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr MemsetOpGenericAdaptorBase::getAccessGroupsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemsetOpGenericAdaptorBase::getAccessGroups() {
  auto attr = getAccessGroupsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemsetOpGenericAdaptorBase::getAliasScopesAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemsetOpGenericAdaptorBase::getAliasScopes() {
  auto attr = getAliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemsetOpGenericAdaptorBase::getNoaliasScopesAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemsetOpGenericAdaptorBase::getNoaliasScopes() {
  auto attr = getNoaliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemsetOpGenericAdaptorBase::getTbaaAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > MemsetOpGenericAdaptorBase::getTbaa() {
  auto attr = getTbaaAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
MemsetOpAdaptor::MemsetOpAdaptor(MemsetOp op) : MemsetOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult MemsetOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_access_groups = getProperties().access_groups; (void)tblgen_access_groups;
  auto tblgen_alias_scopes = getProperties().alias_scopes; (void)tblgen_alias_scopes;
  auto tblgen_isVolatile = getProperties().isVolatile; (void)tblgen_isVolatile;
  if (!tblgen_isVolatile) return emitError(loc, "'llvm.intr.memset' op ""requires attribute 'isVolatile'");
  auto tblgen_noalias_scopes = getProperties().noalias_scopes; (void)tblgen_noalias_scopes;
  auto tblgen_tbaa = getProperties().tbaa; (void)tblgen_tbaa;

  if (tblgen_isVolatile && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_isVolatile))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_isVolatile).getType().isSignlessInteger(1)))))
    return emitError(loc, "'llvm.intr.memset' op ""attribute 'isVolatile' failed to satisfy constraint: 1-bit signless integer attribute");

  if (tblgen_access_groups && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_access_groups))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_access_groups), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::AccessGroupAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memset' op ""attribute 'access_groups' failed to satisfy constraint: LLVM dialect access group metadata array");

  if (tblgen_alias_scopes && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_alias_scopes))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_alias_scopes), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::AliasScopeAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memset' op ""attribute 'alias_scopes' failed to satisfy constraint: LLVM dialect alias scope array");

  if (tblgen_noalias_scopes && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_noalias_scopes))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_noalias_scopes), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::AliasScopeAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memset' op ""attribute 'noalias_scopes' failed to satisfy constraint: LLVM dialect alias scope array");

  if (tblgen_tbaa && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_tbaa))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_tbaa), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::LLVM::TBAATagAttr>(attr))); }))))
    return emitError(loc, "'llvm.intr.memset' op ""attribute 'tbaa' failed to satisfy constraint: LLVM dialect TBAA tag metadata array");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> MemsetOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range MemsetOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> MemsetOp::getDst() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::IntegerType> MemsetOp::getVal() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
}

::mlir::TypedValue<::mlir::IntegerType> MemsetOp::getLen() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
}

::mlir::OpOperand &MemsetOp::getDstMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MemsetOp::getValMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MemsetOp::getLenMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> MemsetOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range MemsetOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult MemsetOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.access_groups;
       auto attr = dict.get("access_groups");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for access_groups in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `access_groups` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.alias_scopes;
       auto attr = dict.get("alias_scopes");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for alias_scopes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `alias_scopes` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.isVolatile;
       auto attr = dict.get("isVolatile");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for isVolatile in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `isVolatile` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.noalias_scopes;
       auto attr = dict.get("noalias_scopes");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for noalias_scopes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `noalias_scopes` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.tbaa;
       auto attr = dict.get("tbaa");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for tbaa in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `tbaa` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MemsetOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.access_groups;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("access_groups",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.alias_scopes;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("alias_scopes",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.isVolatile;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("isVolatile",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.noalias_scopes;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("noalias_scopes",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.tbaa;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("tbaa",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MemsetOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.access_groups.getAsOpaquePointer()), 
    llvm::hash_value(prop.alias_scopes.getAsOpaquePointer()), 
    llvm::hash_value(prop.isVolatile.getAsOpaquePointer()), 
    llvm::hash_value(prop.noalias_scopes.getAsOpaquePointer()), 
    llvm::hash_value(prop.tbaa.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MemsetOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "access_groups")
      return prop.access_groups;

    if (name == "alias_scopes")
      return prop.alias_scopes;

    if (name == "isVolatile")
      return prop.isVolatile;

    if (name == "noalias_scopes")
      return prop.noalias_scopes;

    if (name == "tbaa")
      return prop.tbaa;
  return std::nullopt;
}

void MemsetOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "access_groups") {
       prop.access_groups = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.access_groups)>>(value);
       return;
    }

    if (name == "alias_scopes") {
       prop.alias_scopes = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.alias_scopes)>>(value);
       return;
    }

    if (name == "isVolatile") {
       prop.isVolatile = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.isVolatile)>>(value);
       return;
    }

    if (name == "noalias_scopes") {
       prop.noalias_scopes = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.noalias_scopes)>>(value);
       return;
    }

    if (name == "tbaa") {
       prop.tbaa = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.tbaa)>>(value);
       return;
    }
}

void MemsetOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.access_groups) attrs.append("access_groups", prop.access_groups);

    if (prop.alias_scopes) attrs.append("alias_scopes", prop.alias_scopes);

    if (prop.isVolatile) attrs.append("isVolatile", prop.isVolatile);

    if (prop.noalias_scopes) attrs.append("noalias_scopes", prop.noalias_scopes);

    if (prop.tbaa) attrs.append("tbaa", prop.tbaa);
}

::mlir::LogicalResult MemsetOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getAccessGroupsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps8(attr, "access_groups", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getAliasScopesAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(attr, "alias_scopes", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getIsVolatileAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(attr, "isVolatile", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNoaliasScopesAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(attr, "noalias_scopes", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTbaaAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps10(attr, "tbaa", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult MemsetOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.access_groups)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.alias_scopes)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.isVolatile)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.noalias_scopes)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.tbaa)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MemsetOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.access_groups);

  writer.writeOptionalAttribute(prop.alias_scopes);
  writer.writeAttribute(prop.isVolatile);

  writer.writeOptionalAttribute(prop.noalias_scopes);

  writer.writeOptionalAttribute(prop.tbaa);
}

::mlir::IntegerAttr MemsetOp::getIsVolatileAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().isVolatile);
}

bool MemsetOp::getIsVolatile() {
  auto attr = getIsVolatileAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr MemsetOp::getAccessGroupsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().access_groups);
}

::std::optional< ::mlir::ArrayAttr > MemsetOp::getAccessGroups() {
  auto attr = getAccessGroupsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemsetOp::getAliasScopesAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().alias_scopes);
}

::std::optional< ::mlir::ArrayAttr > MemsetOp::getAliasScopes() {
  auto attr = getAliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemsetOp::getNoaliasScopesAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().noalias_scopes);
}

::std::optional< ::mlir::ArrayAttr > MemsetOp::getNoaliasScopes() {
  auto attr = getNoaliasScopesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr MemsetOp::getTbaaAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
}

::std::optional< ::mlir::ArrayAttr > MemsetOp::getTbaa() {
  auto attr = getTbaaAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void MemsetOp::setIsVolatileAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getIsVolatileAttrName(), attr);
}

void MemsetOp::setIsVolatile(bool attrValue) {
  (*this)->setAttr(getIsVolatileAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(1), attrValue));
}

void MemsetOp::setAccessGroupsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getAccessGroupsAttrName(), attr);
}

void MemsetOp::setAliasScopesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getAliasScopesAttrName(), attr);
}

void MemsetOp::setNoaliasScopesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getNoaliasScopesAttrName(), attr);
}

void MemsetOp::setTbaaAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getTbaaAttrName(), attr);
}

::mlir::Attribute MemsetOp::removeAccessGroupsAttr() {
    auto &attr = getProperties().access_groups;
    attr = {};
    return attr;
}

::mlir::Attribute MemsetOp::removeAliasScopesAttr() {
    auto &attr = getProperties().alias_scopes;
    attr = {};
    return attr;
}

::mlir::Attribute MemsetOp::removeNoaliasScopesAttr() {
    auto &attr = getProperties().noalias_scopes;
    attr = {};
    return attr;
}

::mlir::Attribute MemsetOp::removeTbaaAttr() {
    auto &attr = getProperties().tbaa;
    attr = {};
    return attr;
}

void MemsetOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value dst, Value val, Value len, bool isVolatile) {
      build(odsBuilder, odsState, dst, val, len,
            odsBuilder.getBoolAttr(isVolatile));
    
}

void MemsetOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value dst, Value val, Value len, IntegerAttr isVolatile) {
      build(odsBuilder, odsState, dst, val, len, isVolatile,
            /*access_groups=*/nullptr, /*alias_scopes=*/nullptr,
            /*noalias_scopes=*/nullptr, /*tbaa=*/nullptr);
    
}

void MemsetOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value dst, ::mlir::Value val, ::mlir::Value len, ::mlir::IntegerAttr isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(val);
  odsState.addOperands(len);
  odsState.getOrAddProperties<Properties>().isVolatile = isVolatile;
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
}

void MemsetOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dst, ::mlir::Value val, ::mlir::Value len, ::mlir::IntegerAttr isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(val);
  odsState.addOperands(len);
  odsState.getOrAddProperties<Properties>().isVolatile = isVolatile;
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MemsetOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value dst, ::mlir::Value val, ::mlir::Value len, bool isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(val);
  odsState.addOperands(len);
  odsState.getOrAddProperties<Properties>().isVolatile = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), isVolatile);
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
}

void MemsetOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value dst, ::mlir::Value val, ::mlir::Value len, bool isVolatile, /*optional*/::mlir::ArrayAttr access_groups, /*optional*/::mlir::ArrayAttr alias_scopes, /*optional*/::mlir::ArrayAttr noalias_scopes, /*optional*/::mlir::ArrayAttr tbaa) {
  odsState.addOperands(dst);
  odsState.addOperands(val);
  odsState.addOperands(len);
  odsState.getOrAddProperties<Properties>().isVolatile = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(1), isVolatile);
  if (access_groups) {
    odsState.getOrAddProperties<Properties>().access_groups = access_groups;
  }
  if (alias_scopes) {
    odsState.getOrAddProperties<Properties>().alias_scopes = alias_scopes;
  }
  if (noalias_scopes) {
    odsState.getOrAddProperties<Properties>().noalias_scopes = noalias_scopes;
  }
  if (tbaa) {
    odsState.getOrAddProperties<Properties>().tbaa = tbaa;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MemsetOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult MemsetOp::verifyInvariantsImpl() {
  auto tblgen_access_groups = getProperties().access_groups; (void)tblgen_access_groups;
  auto tblgen_alias_scopes = getProperties().alias_scopes; (void)tblgen_alias_scopes;
  auto tblgen_isVolatile = getProperties().isVolatile; (void)tblgen_isVolatile;
  if (!tblgen_isVolatile) return emitOpError("requires attribute 'isVolatile'");
  auto tblgen_noalias_scopes = getProperties().noalias_scopes; (void)tblgen_noalias_scopes;
  auto tblgen_tbaa = getProperties().tbaa; (void)tblgen_tbaa;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps0(*this, tblgen_isVolatile, "isVolatile")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps8(*this, tblgen_access_groups, "access_groups")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(*this, tblgen_alias_scopes, "alias_scopes")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps9(*this, tblgen_noalias_scopes, "noalias_scopes")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps10(*this, tblgen_tbaa, "tbaa")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps12(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult MemsetOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

void MemsetOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  for (::mlir::Value value : getODSOperands(0))
    effects.emplace_back(::mlir::MemoryEffects::Write::get(), value, 0, false, ::mlir::SideEffects::DefaultResource::get());
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::MemsetOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::MinNumOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MinNumOpGenericAdaptorBase::MinNumOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.minnum", odsAttrs.getContext());
}

MinNumOpGenericAdaptorBase::MinNumOpGenericAdaptorBase(MinNumOp op) : MinNumOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> MinNumOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr MinNumOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr MinNumOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags MinNumOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
MinNumOpAdaptor::MinNumOpAdaptor(MinNumOp op) : MinNumOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult MinNumOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.minnum' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> MinNumOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range MinNumOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MinNumOp::getA() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value MinNumOp::getB() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::OpOperand &MinNumOp::getAMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MinNumOp::getBMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> MinNumOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range MinNumOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MinNumOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult MinNumOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MinNumOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MinNumOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MinNumOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void MinNumOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void MinNumOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult MinNumOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult MinNumOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MinNumOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr MinNumOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags MinNumOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void MinNumOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void MinNumOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void MinNumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void MinNumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(MinNumOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void MinNumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MinNumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void MinNumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(MinNumOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void MinNumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MinNumOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void MinNumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(MinNumOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void MinNumOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult MinNumOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult MinNumOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult MinNumOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult MinNumOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void MinNumOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void MinNumOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::MinNumOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::MinimumOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
MinimumOpGenericAdaptorBase::MinimumOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.minimum", odsAttrs.getContext());
}

MinimumOpGenericAdaptorBase::MinimumOpGenericAdaptorBase(MinimumOp op) : MinimumOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> MinimumOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr MinimumOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr MinimumOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags MinimumOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
MinimumOpAdaptor::MinimumOpAdaptor(MinimumOp op) : MinimumOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult MinimumOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.minimum' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> MinimumOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range MinimumOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MinimumOp::getA() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value MinimumOp::getB() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::OpOperand &MinimumOp::getAMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &MinimumOp::getBMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> MinimumOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range MinimumOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value MinimumOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult MinimumOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute MinimumOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code MinimumOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> MinimumOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void MinimumOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void MinimumOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult MinimumOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult MinimumOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void MinimumOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr MinimumOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags MinimumOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void MinimumOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void MinimumOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void MinimumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void MinimumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(MinimumOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void MinimumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MinimumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void MinimumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(MinimumOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void MinimumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void MinimumOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void MinimumOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(MinimumOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void MinimumOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult MinimumOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult MinimumOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult MinimumOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult MinimumOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void MinimumOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void MinimumOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::MinimumOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::NearbyintOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
NearbyintOpGenericAdaptorBase::NearbyintOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.nearbyint", odsAttrs.getContext());
}

NearbyintOpGenericAdaptorBase::NearbyintOpGenericAdaptorBase(NearbyintOp op) : NearbyintOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> NearbyintOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr NearbyintOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr NearbyintOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags NearbyintOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
NearbyintOpAdaptor::NearbyintOpAdaptor(NearbyintOp op) : NearbyintOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult NearbyintOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.nearbyint' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> NearbyintOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range NearbyintOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value NearbyintOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &NearbyintOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> NearbyintOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range NearbyintOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value NearbyintOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult NearbyintOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute NearbyintOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code NearbyintOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> NearbyintOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void NearbyintOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void NearbyintOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult NearbyintOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult NearbyintOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void NearbyintOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr NearbyintOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags NearbyintOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void NearbyintOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void NearbyintOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void NearbyintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void NearbyintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(NearbyintOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void NearbyintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void NearbyintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void NearbyintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(NearbyintOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void NearbyintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void NearbyintOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void NearbyintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(NearbyintOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void NearbyintOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult NearbyintOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult NearbyintOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult NearbyintOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult NearbyintOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void NearbyintOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void NearbyintOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::NearbyintOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::NoAliasScopeDeclOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
NoAliasScopeDeclOpGenericAdaptorBase::NoAliasScopeDeclOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.experimental.noalias.scope.decl", odsAttrs.getContext());
}

NoAliasScopeDeclOpGenericAdaptorBase::NoAliasScopeDeclOpGenericAdaptorBase(NoAliasScopeDeclOp op) : NoAliasScopeDeclOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> NoAliasScopeDeclOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr NoAliasScopeDeclOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::AliasScopeAttr NoAliasScopeDeclOpGenericAdaptorBase::getScopeAttr() {
  auto attr = ::llvm::cast<::mlir::LLVM::AliasScopeAttr>(getProperties().scope);
  return attr;
}

::mlir::LLVM::AliasScopeAttr NoAliasScopeDeclOpGenericAdaptorBase::getScope() {
  auto attr = getScopeAttr();
  return ::llvm::cast<::mlir::LLVM::AliasScopeAttr>(attr);
}

} // namespace detail
NoAliasScopeDeclOpAdaptor::NoAliasScopeDeclOpAdaptor(NoAliasScopeDeclOp op) : NoAliasScopeDeclOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult NoAliasScopeDeclOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_scope = getProperties().scope; (void)tblgen_scope;
  if (!tblgen_scope) return emitError(loc, "'llvm.intr.experimental.noalias.scope.decl' op ""requires attribute 'scope'");

  if (tblgen_scope && !((::llvm::isa<::mlir::LLVM::AliasScopeAttr>(tblgen_scope))))
    return emitError(loc, "'llvm.intr.experimental.noalias.scope.decl' op ""attribute 'scope' failed to satisfy constraint: LLVM dialect alias scope");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> NoAliasScopeDeclOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range NoAliasScopeDeclOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> NoAliasScopeDeclOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range NoAliasScopeDeclOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult NoAliasScopeDeclOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.scope;
       auto attr = dict.get("scope");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for scope in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `scope` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute NoAliasScopeDeclOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.scope;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("scope",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code NoAliasScopeDeclOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.scope.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> NoAliasScopeDeclOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "scope")
      return prop.scope;
  return std::nullopt;
}

void NoAliasScopeDeclOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "scope") {
       prop.scope = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.scope)>>(value);
       return;
    }
}

void NoAliasScopeDeclOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.scope) attrs.append("scope", prop.scope);
}

::mlir::LogicalResult NoAliasScopeDeclOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getScopeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps11(attr, "scope", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult NoAliasScopeDeclOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.scope)))
    return ::mlir::failure();
  return ::mlir::success();
}

void NoAliasScopeDeclOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.scope);
}

::mlir::LLVM::AliasScopeAttr NoAliasScopeDeclOp::getScopeAttr() {
  return ::llvm::cast<::mlir::LLVM::AliasScopeAttr>(getProperties().scope);
}

::mlir::LLVM::AliasScopeAttr NoAliasScopeDeclOp::getScope() {
  auto attr = getScopeAttr();
  return ::llvm::cast<::mlir::LLVM::AliasScopeAttr>(attr);
}

void NoAliasScopeDeclOp::setScopeAttr(::mlir::LLVM::AliasScopeAttr attr) {
  (*this)->setAttr(getScopeAttrName(), attr);
}

void NoAliasScopeDeclOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::LLVM::AliasScopeAttr scope) {
  odsState.getOrAddProperties<Properties>().scope = scope;
}

void NoAliasScopeDeclOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::LLVM::AliasScopeAttr scope) {
  odsState.getOrAddProperties<Properties>().scope = scope;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void NoAliasScopeDeclOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult NoAliasScopeDeclOp::verifyInvariantsImpl() {
  auto tblgen_scope = getProperties().scope; (void)tblgen_scope;
  if (!tblgen_scope) return emitOpError("requires attribute 'scope'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps11(*this, tblgen_scope, "scope")))
    return ::mlir::failure();
  return ::mlir::success();
}

::mlir::LogicalResult NoAliasScopeDeclOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult NoAliasScopeDeclOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::LLVM::AliasScopeAttr scopeAttr;

  if (parser.parseCustomAttributeWithFallback(scopeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (scopeAttr) result.getOrAddProperties<NoAliasScopeDeclOp::Properties>().scope = scopeAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void NoAliasScopeDeclOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
_odsPrinter.printStrippedAttrOrType(getScopeAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("scope");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::NoAliasScopeDeclOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::PowIOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
PowIOpGenericAdaptorBase::PowIOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.powi", odsAttrs.getContext());
}

PowIOpGenericAdaptorBase::PowIOpGenericAdaptorBase(PowIOp op) : PowIOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> PowIOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr PowIOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr PowIOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags PowIOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
PowIOpAdaptor::PowIOpAdaptor(PowIOp op) : PowIOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult PowIOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.powi' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> PowIOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range PowIOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value PowIOp::getVal() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::IntegerType> PowIOp::getPower() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
}

::mlir::OpOperand &PowIOp::getValMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &PowIOp::getPowerMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> PowIOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range PowIOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value PowIOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult PowIOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute PowIOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code PowIOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> PowIOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void PowIOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void PowIOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult PowIOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult PowIOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void PowIOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr PowIOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags PowIOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void PowIOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void PowIOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void PowIOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value val, ::mlir::Value power, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(val);
  odsState.addOperands(power);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void PowIOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val, ::mlir::Value power, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(val);
  odsState.addOperands(power);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void PowIOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value val, ::mlir::Value power, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(val);
  odsState.addOperands(power);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void PowIOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val, ::mlir::Value power, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(val);
  odsState.addOperands(power);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void PowIOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void PowIOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult PowIOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult PowIOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult PowIOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void PowIOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void PowIOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::PowIOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::PowOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
PowOpGenericAdaptorBase::PowOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.pow", odsAttrs.getContext());
}

PowOpGenericAdaptorBase::PowOpGenericAdaptorBase(PowOp op) : PowOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> PowOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr PowOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr PowOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags PowOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
PowOpAdaptor::PowOpAdaptor(PowOp op) : PowOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult PowOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.pow' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> PowOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range PowOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value PowOp::getA() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value PowOp::getB() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::OpOperand &PowOp::getAMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &PowOp::getBMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> PowOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range PowOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value PowOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult PowOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute PowOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code PowOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> PowOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void PowOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void PowOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult PowOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult PowOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void PowOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr PowOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags PowOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void PowOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void PowOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void PowOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void PowOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(PowOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void PowOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void PowOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void PowOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(PowOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void PowOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void PowOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void PowOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(PowOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void PowOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult PowOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult PowOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult PowOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult PowOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void PowOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void PowOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::PowOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::Prefetch definitions
//===----------------------------------------------------------------------===//

namespace detail {
PrefetchGenericAdaptorBase::PrefetchGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.prefetch", odsAttrs.getContext());
}

PrefetchGenericAdaptorBase::PrefetchGenericAdaptorBase(Prefetch op) : PrefetchGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> PrefetchGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr PrefetchGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr PrefetchGenericAdaptorBase::getRwAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().rw);
  return attr;
}

uint32_t PrefetchGenericAdaptorBase::getRw() {
  auto attr = getRwAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr PrefetchGenericAdaptorBase::getHintAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().hint);
  return attr;
}

uint32_t PrefetchGenericAdaptorBase::getHint() {
  auto attr = getHintAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr PrefetchGenericAdaptorBase::getCacheAttr() {
  auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().cache);
  return attr;
}

uint32_t PrefetchGenericAdaptorBase::getCache() {
  auto attr = getCacheAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
PrefetchAdaptor::PrefetchAdaptor(Prefetch op) : PrefetchGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult PrefetchAdaptor::verify(::mlir::Location loc) {
  auto tblgen_cache = getProperties().cache; (void)tblgen_cache;
  if (!tblgen_cache) return emitError(loc, "'llvm.intr.prefetch' op ""requires attribute 'cache'");
  auto tblgen_hint = getProperties().hint; (void)tblgen_hint;
  if (!tblgen_hint) return emitError(loc, "'llvm.intr.prefetch' op ""requires attribute 'hint'");
  auto tblgen_rw = getProperties().rw; (void)tblgen_rw;
  if (!tblgen_rw) return emitError(loc, "'llvm.intr.prefetch' op ""requires attribute 'rw'");

  if (tblgen_rw && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_rw))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_rw).getType().isSignlessInteger(32)))))
    return emitError(loc, "'llvm.intr.prefetch' op ""attribute 'rw' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_hint && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_hint))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_hint).getType().isSignlessInteger(32)))))
    return emitError(loc, "'llvm.intr.prefetch' op ""attribute 'hint' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_cache && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_cache))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_cache).getType().isSignlessInteger(32)))))
    return emitError(loc, "'llvm.intr.prefetch' op ""attribute 'cache' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> Prefetch::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range Prefetch::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> Prefetch::getAddr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
}

::mlir::OpOperand &Prefetch::getAddrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> Prefetch::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range Prefetch::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult Prefetch::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.cache;
       auto attr = dict.get("cache");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for cache in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `cache` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.hint;
       auto attr = dict.get("hint");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.rw;
       auto attr = dict.get("rw");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        emitError() << "expected key entry for rw in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `rw` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute Prefetch::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.cache;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("cache",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("hint",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.rw;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("rw",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code Prefetch::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.cache.getAsOpaquePointer()), 
    llvm::hash_value(prop.hint.getAsOpaquePointer()), 
    llvm::hash_value(prop.rw.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> Prefetch::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "cache")
      return prop.cache;

    if (name == "hint")
      return prop.hint;

    if (name == "rw")
      return prop.rw;
  return std::nullopt;
}

void Prefetch::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "cache") {
       prop.cache = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.cache)>>(value);
       return;
    }

    if (name == "hint") {
       prop.hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.hint)>>(value);
       return;
    }

    if (name == "rw") {
       prop.rw = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.rw)>>(value);
       return;
    }
}

void Prefetch::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.cache) attrs.append("cache", prop.cache);

    if (prop.hint) attrs.append("hint", prop.hint);

    if (prop.rw) attrs.append("rw", prop.rw);
}

::mlir::LogicalResult Prefetch::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getCacheAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, "cache", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getHintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, "hint", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getRwAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(attr, "rw", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult Prefetch::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.cache)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.hint)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.rw)))
    return ::mlir::failure();
  return ::mlir::success();
}

void Prefetch::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.cache);
  writer.writeAttribute(prop.hint);
  writer.writeAttribute(prop.rw);
}

::mlir::IntegerAttr Prefetch::getRwAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().rw);
}

uint32_t Prefetch::getRw() {
  auto attr = getRwAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr Prefetch::getHintAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().hint);
}

uint32_t Prefetch::getHint() {
  auto attr = getHintAttr();
  return attr.getValue().getZExtValue();
}

::mlir::IntegerAttr Prefetch::getCacheAttr() {
  return ::llvm::cast<::mlir::IntegerAttr>(getProperties().cache);
}

uint32_t Prefetch::getCache() {
  auto attr = getCacheAttr();
  return attr.getValue().getZExtValue();
}

void Prefetch::setRwAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getRwAttrName(), attr);
}

void Prefetch::setRw(uint32_t attrValue) {
  (*this)->setAttr(getRwAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void Prefetch::setHintAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getHintAttrName(), attr);
}

void Prefetch::setHint(uint32_t attrValue) {
  (*this)->setAttr(getHintAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void Prefetch::setCacheAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getCacheAttrName(), attr);
}

void Prefetch::setCache(uint32_t attrValue) {
  (*this)->setAttr(getCacheAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void Prefetch::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value addr, ::mlir::IntegerAttr rw, ::mlir::IntegerAttr hint, ::mlir::IntegerAttr cache) {
  odsState.addOperands(addr);
  odsState.getOrAddProperties<Properties>().rw = rw;
  odsState.getOrAddProperties<Properties>().hint = hint;
  odsState.getOrAddProperties<Properties>().cache = cache;
}

void Prefetch::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value addr, ::mlir::IntegerAttr rw, ::mlir::IntegerAttr hint, ::mlir::IntegerAttr cache) {
  odsState.addOperands(addr);
  odsState.getOrAddProperties<Properties>().rw = rw;
  odsState.getOrAddProperties<Properties>().hint = hint;
  odsState.getOrAddProperties<Properties>().cache = cache;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void Prefetch::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value addr, uint32_t rw, uint32_t hint, uint32_t cache) {
  odsState.addOperands(addr);
  odsState.getOrAddProperties<Properties>().rw = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), rw);
  odsState.getOrAddProperties<Properties>().hint = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), hint);
  odsState.getOrAddProperties<Properties>().cache = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), cache);
}

void Prefetch::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value addr, uint32_t rw, uint32_t hint, uint32_t cache) {
  odsState.addOperands(addr);
  odsState.getOrAddProperties<Properties>().rw = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), rw);
  odsState.getOrAddProperties<Properties>().hint = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), hint);
  odsState.getOrAddProperties<Properties>().cache = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), cache);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void Prefetch::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult Prefetch::verifyInvariantsImpl() {
  auto tblgen_cache = getProperties().cache; (void)tblgen_cache;
  if (!tblgen_cache) return emitOpError("requires attribute 'cache'");
  auto tblgen_hint = getProperties().hint; (void)tblgen_hint;
  if (!tblgen_hint) return emitOpError("requires attribute 'hint'");
  auto tblgen_rw = getProperties().rw; (void)tblgen_rw;
  if (!tblgen_rw) return emitOpError("requires attribute 'rw'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(*this, tblgen_rw, "rw")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(*this, tblgen_hint, "hint")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps5(*this, tblgen_cache, "cache")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult Prefetch::verifyInvariants() {
  return verifyInvariantsImpl();
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::Prefetch)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::PtrAnnotation definitions
//===----------------------------------------------------------------------===//

namespace detail {
PtrAnnotationGenericAdaptorBase::PtrAnnotationGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.ptr.annotation", odsAttrs.getContext());
}

PtrAnnotationGenericAdaptorBase::PtrAnnotationGenericAdaptorBase(PtrAnnotation op) : PtrAnnotationGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> PtrAnnotationGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr PtrAnnotationGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
PtrAnnotationAdaptor::PtrAnnotationAdaptor(PtrAnnotation op) : PtrAnnotationGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult PtrAnnotationAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> PtrAnnotation::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range PtrAnnotation::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> PtrAnnotation::getPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> PtrAnnotation::getAnnotation() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(1).begin());
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> PtrAnnotation::getFileName() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(2).begin());
}

::mlir::TypedValue<::mlir::IntegerType> PtrAnnotation::getLine() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(3).begin());
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> PtrAnnotation::getAttr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSOperands(4).begin());
}

::mlir::OpOperand &PtrAnnotation::getPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &PtrAnnotation::getAnnotationMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &PtrAnnotation::getFileNameMutable() {
  auto range = getODSOperandIndexAndLength(2);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &PtrAnnotation::getLineMutable() {
  auto range = getODSOperandIndexAndLength(3);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &PtrAnnotation::getAttrMutable() {
  auto range = getODSOperandIndexAndLength(4);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> PtrAnnotation::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range PtrAnnotation::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::LLVM::LLVMPointerType> PtrAnnotation::getRes() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::LLVM::LLVMPointerType>>(*getODSResults(0).begin());
}

void PtrAnnotation::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value ptr, ::mlir::Value annotation, ::mlir::Value fileName, ::mlir::Value line, ::mlir::Value attr) {
  odsState.addOperands(ptr);
  odsState.addOperands(annotation);
  odsState.addOperands(fileName);
  odsState.addOperands(line);
  odsState.addOperands(attr);
  odsState.addTypes(res);
}

void PtrAnnotation::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value ptr, ::mlir::Value annotation, ::mlir::Value fileName, ::mlir::Value line, ::mlir::Value attr) {
  odsState.addOperands(ptr);
  odsState.addOperands(annotation);
  odsState.addOperands(fileName);
  odsState.addOperands(line);
  odsState.addOperands(attr);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(PtrAnnotation::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void PtrAnnotation::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ptr, ::mlir::Value annotation, ::mlir::Value fileName, ::mlir::Value line, ::mlir::Value attr) {
  odsState.addOperands(ptr);
  odsState.addOperands(annotation);
  odsState.addOperands(fileName);
  odsState.addOperands(line);
  odsState.addOperands(attr);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void PtrAnnotation::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 5u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void PtrAnnotation::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 5u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(PtrAnnotation::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult PtrAnnotation::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps13(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps13(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  if (!((((*this->getODSResults(0).begin()).getType()) == ((*this->getODSOperands(0).begin()).getType()) && ((*this->getODSOperands(0).begin()).getType()) == ((*this->getODSResults(0).begin()).getType()))))
    return emitOpError("failed to verify that all of {res, ptr} have same type");
  if (!((((*this->getODSOperands(1).begin()).getType()) == ((*this->getODSOperands(2).begin()).getType()) && ((*this->getODSOperands(2).begin()).getType()) == ((*this->getODSOperands(4).begin()).getType()) && ((*this->getODSOperands(4).begin()).getType()) == ((*this->getODSOperands(1).begin()).getType()))))
    return emitOpError("failed to verify that all of {annotation, fileName, attr} have same type");
  return ::mlir::success();
}

::mlir::LogicalResult PtrAnnotation::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult PtrAnnotation::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::PtrAnnotation)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::RintOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
RintOpGenericAdaptorBase::RintOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.rint", odsAttrs.getContext());
}

RintOpGenericAdaptorBase::RintOpGenericAdaptorBase(RintOp op) : RintOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> RintOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr RintOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr RintOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags RintOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
RintOpAdaptor::RintOpAdaptor(RintOp op) : RintOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult RintOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.rint' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> RintOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range RintOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value RintOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &RintOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> RintOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range RintOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value RintOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult RintOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute RintOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code RintOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> RintOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void RintOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void RintOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult RintOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult RintOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void RintOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr RintOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags RintOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void RintOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void RintOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void RintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void RintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(RintOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void RintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void RintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void RintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(RintOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void RintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void RintOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void RintOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(RintOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void RintOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult RintOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult RintOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult RintOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult RintOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void RintOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void RintOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::RintOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::RoundEvenOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
RoundEvenOpGenericAdaptorBase::RoundEvenOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.roundeven", odsAttrs.getContext());
}

RoundEvenOpGenericAdaptorBase::RoundEvenOpGenericAdaptorBase(RoundEvenOp op) : RoundEvenOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> RoundEvenOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr RoundEvenOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr RoundEvenOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags RoundEvenOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
RoundEvenOpAdaptor::RoundEvenOpAdaptor(RoundEvenOp op) : RoundEvenOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult RoundEvenOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.roundeven' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> RoundEvenOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range RoundEvenOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value RoundEvenOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &RoundEvenOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> RoundEvenOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range RoundEvenOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value RoundEvenOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult RoundEvenOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute RoundEvenOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code RoundEvenOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> RoundEvenOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void RoundEvenOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void RoundEvenOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult RoundEvenOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult RoundEvenOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void RoundEvenOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr RoundEvenOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags RoundEvenOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void RoundEvenOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void RoundEvenOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void RoundEvenOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void RoundEvenOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(RoundEvenOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void RoundEvenOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void RoundEvenOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void RoundEvenOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(RoundEvenOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void RoundEvenOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void RoundEvenOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void RoundEvenOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(RoundEvenOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void RoundEvenOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult RoundEvenOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult RoundEvenOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult RoundEvenOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult RoundEvenOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void RoundEvenOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void RoundEvenOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::RoundEvenOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::RoundOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
RoundOpGenericAdaptorBase::RoundOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.round", odsAttrs.getContext());
}

RoundOpGenericAdaptorBase::RoundOpGenericAdaptorBase(RoundOp op) : RoundOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> RoundOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr RoundOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr RoundOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags RoundOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
RoundOpAdaptor::RoundOpAdaptor(RoundOp op) : RoundOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult RoundOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.round' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> RoundOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range RoundOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value RoundOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &RoundOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> RoundOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range RoundOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value RoundOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult RoundOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute RoundOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code RoundOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> RoundOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void RoundOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void RoundOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult RoundOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult RoundOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void RoundOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr RoundOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags RoundOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void RoundOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void RoundOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void RoundOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void RoundOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(RoundOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void RoundOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void RoundOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void RoundOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(RoundOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void RoundOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void RoundOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void RoundOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(RoundOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void RoundOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult RoundOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult RoundOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult RoundOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult RoundOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void RoundOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void RoundOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::RoundOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::SAddSat definitions
//===----------------------------------------------------------------------===//

namespace detail {
SAddSatGenericAdaptorBase::SAddSatGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.sadd.sat", odsAttrs.getContext());
}

SAddSatGenericAdaptorBase::SAddSatGenericAdaptorBase(SAddSat op) : SAddSatGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> SAddSatGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr SAddSatGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
SAddSatAdaptor::SAddSatAdaptor(SAddSat op) : SAddSatGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult SAddSatAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> SAddSat::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range SAddSat::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SAddSat::getA() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value SAddSat::getB() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::OpOperand &SAddSat::getAMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &SAddSat::getBMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> SAddSat::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range SAddSat::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SAddSat::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void SAddSat::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addTypes(res);
}

void SAddSat::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b) {
  odsState.addOperands(a);
  odsState.addOperands(b);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(SAddSat::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void SAddSat::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SAddSat::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void SAddSat::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(SAddSat::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult SAddSat::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult SAddSat::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult SAddSat::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult SAddSat::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void SAddSat::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void SAddSat::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::SAddSat)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::SAddWithOverflowOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
SAddWithOverflowOpGenericAdaptorBase::SAddWithOverflowOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.sadd.with.overflow", odsAttrs.getContext());
}

SAddWithOverflowOpGenericAdaptorBase::SAddWithOverflowOpGenericAdaptorBase(SAddWithOverflowOp op) : SAddWithOverflowOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> SAddWithOverflowOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr SAddWithOverflowOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
SAddWithOverflowOpAdaptor::SAddWithOverflowOpAdaptor(SAddWithOverflowOp op) : SAddWithOverflowOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult SAddWithOverflowOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> SAddWithOverflowOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range SAddWithOverflowOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> SAddWithOverflowOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range SAddWithOverflowOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SAddWithOverflowOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void SAddWithOverflowOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value odsArg_0, ::mlir::Value odsArg_1) {
  odsState.addOperands(odsArg_0);
  odsState.addOperands(odsArg_1);
  odsState.addTypes(res);
}

void SAddWithOverflowOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value odsArg_0, ::mlir::Value odsArg_1) {
  odsState.addOperands(odsArg_0);
  odsState.addOperands(odsArg_1);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SAddWithOverflowOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult SAddWithOverflowOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult SAddWithOverflowOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

void SAddWithOverflowOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::SAddWithOverflowOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::SMaxOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
SMaxOpGenericAdaptorBase::SMaxOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.smax", odsAttrs.getContext());
}

SMaxOpGenericAdaptorBase::SMaxOpGenericAdaptorBase(SMaxOp op) : SMaxOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> SMaxOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr SMaxOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
SMaxOpAdaptor::SMaxOpAdaptor(SMaxOp op) : SMaxOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult SMaxOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> SMaxOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range SMaxOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SMaxOp::getA() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value SMaxOp::getB() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::OpOperand &SMaxOp::getAMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &SMaxOp::getBMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> SMaxOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range SMaxOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SMaxOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void SMaxOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addTypes(res);
}

void SMaxOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b) {
  odsState.addOperands(a);
  odsState.addOperands(b);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(SMaxOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void SMaxOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SMaxOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void SMaxOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(SMaxOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult SMaxOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult SMaxOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult SMaxOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult SMaxOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void SMaxOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void SMaxOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::SMaxOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::SMinOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
SMinOpGenericAdaptorBase::SMinOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.smin", odsAttrs.getContext());
}

SMinOpGenericAdaptorBase::SMinOpGenericAdaptorBase(SMinOp op) : SMinOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> SMinOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr SMinOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
SMinOpAdaptor::SMinOpAdaptor(SMinOp op) : SMinOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult SMinOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> SMinOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range SMinOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SMinOp::getA() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value SMinOp::getB() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::OpOperand &SMinOp::getAMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &SMinOp::getBMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> SMinOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range SMinOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SMinOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void SMinOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addTypes(res);
}

void SMinOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b) {
  odsState.addOperands(a);
  odsState.addOperands(b);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(SMinOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void SMinOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SMinOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void SMinOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(SMinOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult SMinOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult SMinOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult SMinOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult SMinOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void SMinOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void SMinOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::SMinOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::SMulWithOverflowOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
SMulWithOverflowOpGenericAdaptorBase::SMulWithOverflowOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.smul.with.overflow", odsAttrs.getContext());
}

SMulWithOverflowOpGenericAdaptorBase::SMulWithOverflowOpGenericAdaptorBase(SMulWithOverflowOp op) : SMulWithOverflowOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> SMulWithOverflowOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr SMulWithOverflowOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
SMulWithOverflowOpAdaptor::SMulWithOverflowOpAdaptor(SMulWithOverflowOp op) : SMulWithOverflowOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult SMulWithOverflowOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> SMulWithOverflowOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range SMulWithOverflowOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> SMulWithOverflowOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range SMulWithOverflowOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SMulWithOverflowOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void SMulWithOverflowOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value odsArg_0, ::mlir::Value odsArg_1) {
  odsState.addOperands(odsArg_0);
  odsState.addOperands(odsArg_1);
  odsState.addTypes(res);
}

void SMulWithOverflowOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value odsArg_0, ::mlir::Value odsArg_1) {
  odsState.addOperands(odsArg_0);
  odsState.addOperands(odsArg_1);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SMulWithOverflowOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult SMulWithOverflowOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult SMulWithOverflowOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

void SMulWithOverflowOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::SMulWithOverflowOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::SSACopyOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
SSACopyOpGenericAdaptorBase::SSACopyOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.ssa.copy", odsAttrs.getContext());
}

SSACopyOpGenericAdaptorBase::SSACopyOpGenericAdaptorBase(SSACopyOp op) : SSACopyOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> SSACopyOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr SSACopyOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
SSACopyOpAdaptor::SSACopyOpAdaptor(SSACopyOp op) : SSACopyOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult SSACopyOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> SSACopyOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range SSACopyOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SSACopyOp::getOperand() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &SSACopyOp::getOperandMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> SSACopyOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range SSACopyOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SSACopyOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void SSACopyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value operand) {
  odsState.addOperands(operand);
  odsState.addTypes(res);
}

void SSACopyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand) {
  odsState.addOperands(operand);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(SSACopyOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void SSACopyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand) {
  odsState.addOperands(operand);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SSACopyOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void SSACopyOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(SSACopyOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult SSACopyOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps14(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult SSACopyOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult SSACopyOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult SSACopyOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand operandRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> operandOperands(operandRawOperands);  ::llvm::SMLoc operandOperandsLoc;
  (void)operandOperandsLoc;
  ::mlir::Type operandRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> operandTypes(operandRawTypes);

  operandOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(operandRawOperands[0]))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    operandRawTypes[0] = type;
  }
  result.addTypes(operandTypes[0]);
  if (parser.resolveOperands(operandOperands, operandTypes, operandOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void SSACopyOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getOperand();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getOperand().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void SSACopyOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::SSACopyOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::SSHLSat definitions
//===----------------------------------------------------------------------===//

namespace detail {
SSHLSatGenericAdaptorBase::SSHLSatGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.sshl.sat", odsAttrs.getContext());
}

SSHLSatGenericAdaptorBase::SSHLSatGenericAdaptorBase(SSHLSat op) : SSHLSatGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> SSHLSatGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr SSHLSatGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
SSHLSatAdaptor::SSHLSatAdaptor(SSHLSat op) : SSHLSatGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult SSHLSatAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> SSHLSat::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range SSHLSat::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SSHLSat::getA() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value SSHLSat::getB() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::OpOperand &SSHLSat::getAMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &SSHLSat::getBMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> SSHLSat::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range SSHLSat::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SSHLSat::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void SSHLSat::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addTypes(res);
}

void SSHLSat::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b) {
  odsState.addOperands(a);
  odsState.addOperands(b);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(SSHLSat::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void SSHLSat::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SSHLSat::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void SSHLSat::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(SSHLSat::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult SSHLSat::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult SSHLSat::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult SSHLSat::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult SSHLSat::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void SSHLSat::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void SSHLSat::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::SSHLSat)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::SSubSat definitions
//===----------------------------------------------------------------------===//

namespace detail {
SSubSatGenericAdaptorBase::SSubSatGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.ssub.sat", odsAttrs.getContext());
}

SSubSatGenericAdaptorBase::SSubSatGenericAdaptorBase(SSubSat op) : SSubSatGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> SSubSatGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr SSubSatGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
SSubSatAdaptor::SSubSatAdaptor(SSubSat op) : SSubSatGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult SSubSatAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> SSubSat::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range SSubSat::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SSubSat::getA() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value SSubSat::getB() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::OpOperand &SSubSat::getAMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

::mlir::OpOperand &SSubSat::getBMutable() {
  auto range = getODSOperandIndexAndLength(1);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> SSubSat::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range SSubSat::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SSubSat::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void SSubSat::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value a, ::mlir::Value b) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  odsState.addTypes(res);
}

void SSubSat::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b) {
  odsState.addOperands(a);
  odsState.addOperands(b);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(SSubSat::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void SSubSat::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b) {
  odsState.addOperands(a);
  odsState.addOperands(b);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SSubSat::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void SSubSat::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(SSubSat::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult SSubSat::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult SSubSat::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult SSubSat::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult SSubSat::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void SSubSat::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getOperation()->getOperands();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  printLLVMOpAttrs(_odsPrinter, *this, getOperation()->getAttrDictionary());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

void SSubSat::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::SSubSat)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::SSubWithOverflowOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
SSubWithOverflowOpGenericAdaptorBase::SSubWithOverflowOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.ssub.with.overflow", odsAttrs.getContext());
}

SSubWithOverflowOpGenericAdaptorBase::SSubWithOverflowOpGenericAdaptorBase(SSubWithOverflowOp op) : SSubWithOverflowOpGenericAdaptorBase(op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> SSubWithOverflowOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr SSubWithOverflowOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
SSubWithOverflowOpAdaptor::SSubWithOverflowOpAdaptor(SSubWithOverflowOp op) : SSubWithOverflowOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult SSubWithOverflowOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> SSubWithOverflowOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range SSubWithOverflowOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> SSubWithOverflowOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range SSubWithOverflowOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SSubWithOverflowOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

void SSubWithOverflowOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value odsArg_0, ::mlir::Value odsArg_1) {
  odsState.addOperands(odsArg_0);
  odsState.addOperands(odsArg_1);
  odsState.addTypes(res);
}

void SSubWithOverflowOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value odsArg_0, ::mlir::Value odsArg_1) {
  odsState.addOperands(odsArg_0);
  odsState.addOperands(odsArg_1);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SSubWithOverflowOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult SSubWithOverflowOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult SSubWithOverflowOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

void SSubWithOverflowOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace LLVM
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::LLVM::SSubWithOverflowOp)

namespace mlir {
namespace LLVM {

//===----------------------------------------------------------------------===//
// ::mlir::LLVM::SinOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
SinOpGenericAdaptorBase::SinOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("llvm.intr.sin", odsAttrs.getContext());
}

SinOpGenericAdaptorBase::SinOpGenericAdaptorBase(SinOp op) : SinOpGenericAdaptorBase(op->getDiscardableAttrDictionary(), op.getProperties(), op->getRegions()) {}

std::pair<unsigned, unsigned> SinOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr SinOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::LLVM::FastmathFlagsAttr SinOpGenericAdaptorBase::getFastmathFlagsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
  return attr;
}

::mlir::LLVM::FastmathFlags SinOpGenericAdaptorBase::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

} // namespace detail
SinOpAdaptor::SinOpAdaptor(SinOp op) : SinOpGenericAdaptor(op->getOperands(), op) {}

::mlir::LogicalResult SinOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (tblgen_fastmathFlags && !((::llvm::isa<::mlir::LLVM::FastmathFlagsAttr>(tblgen_fastmathFlags))))
    return emitError(loc, "'llvm.intr.sin' op ""attribute 'fastmathFlags' failed to satisfy constraint: LLVM fastmath flags");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> SinOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range SinOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SinOp::getIn() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::OpOperand &SinOp::getInMutable() {
  auto range = getODSOperandIndexAndLength(0);
  return getOperation()->getOpOperand(range.first);
}

std::pair<unsigned, unsigned> SinOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range SinOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SinOp::getRes() {
  return ::llvm::cast<::mlir::Value>(*getODSResults(0).begin());
}

::mlir::LogicalResult SinOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fastmathFlags;
       auto attr = dict.get("fastmathFlags");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for fastmathFlags in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fastmathFlags` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute SinOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fastmathFlags;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fastmathFlags",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code SinOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.fastmathFlags.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> SinOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fastmathFlags")
      return prop.fastmathFlags;
  return std::nullopt;
}

void SinOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fastmathFlags") {
       prop.fastmathFlags = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fastmathFlags)>>(value);
       return;
    }
}

void SinOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fastmathFlags) attrs.append("fastmathFlags", prop.fastmathFlags);
}

::mlir::LogicalResult SinOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFastmathFlagsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(attr, "fastmathFlags", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult SinOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.fastmathFlags)))
    return ::mlir::failure();
  return ::mlir::success();
}

void SinOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.fastmathFlags);
}

::mlir::LLVM::FastmathFlagsAttr SinOp::getFastmathFlagsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::LLVM::FastmathFlagsAttr>(getProperties().fastmathFlags);
}

::mlir::LLVM::FastmathFlags SinOp::getFastmathFlags() {
  auto attr = getFastmathFlagsAttr();
  return attr.getValue();
}

void SinOp::setFastmathFlagsAttr(::mlir::LLVM::FastmathFlagsAttr attr) {
  (*this)->setAttr(getFastmathFlagsAttrName(), attr);
}

void SinOp::setFastmathFlags(::mlir::LLVM::FastmathFlags attrValue) {
  (*this)->setAttr(getFastmathFlagsAttrName(), ::mlir::LLVM::FastmathFlagsAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void SinOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  odsState.addTypes(res);
}

void SinOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(SinOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void SinOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlagsAttr fastmathFlags) {
  odsState.addOperands(in);
  if (fastmathFlags) {
    odsState.getOrAddProperties<Properties>().fastmathFlags = fastmathFlags;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SinOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  odsState.addTypes(res);
}

void SinOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(SinOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.getRawProperties(),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void SinOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::LLVM::FastmathFlags fastmathFlags) {
  odsState.addOperands(in);
  odsState.getOrAddProperties<Properties>().fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), fastmathFlags);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void SinOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void SinOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(SinOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.getRawProperties(),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

void SinOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.fastmathFlags)
    properties.fastmathFlags = ::mlir::LLVM::FastmathFlagsAttr::get(odsBuilder.getContext(), {});
}

::mlir::LogicalResult SinOp::verifyInvariantsImpl() {
  auto tblgen_fastmathFlags = getProperties().fastmathFlags; (void)tblgen_fastmathFlags;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_LLVMIntrinsicOps1(*this, tblgen_fastmathFlags, "fastmathFlags")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_LLVMIntrinsicOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult SinOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult SinOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = operands[0].getType();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult SinOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> allOperands;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;
  if (parser.parseLParen())
    return ::mlir::failure();
  ::llvm::SMLoc allOperandLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(allOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  {
    auto odsResult = parseLLVMOpAttrs(parser, result.attributes);
    if (odsResult) return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(allOperands, allOperandTypes, allOperandLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void SinOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(