#include "sysconfig.h"
#include "sysdeps.h"
#include "options.h"
#include "memory.h"
#include "custom.h"
#include "readcpu.h"
#include "newcpu.h"
#include "compiler.h"
#include "cputbl.h"

#if !defined(PART_1) && !defined(PART_2) && !defined(PART_3) && !defined(PART_4) && !defined(PART_5) && !defined(PART_6) && !defined(PART_7) && !defined(PART_8)
#define PART_1 1
#define PART_2 1
#define PART_3 1
#define PART_4 1
#define PART_5 1
#define PART_6 1
#define PART_7 1
#define PART_8 1
#endif

#ifdef PART_1
unsigned long REGPARAM2 op_0_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_10_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_18_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_20_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_28_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_30_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 8;
}
unsigned long REGPARAM2 op_38_0(uae_u32 opcode) /* OR */
{
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_39_0(uae_u32 opcode) /* OR */
{
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s8 dst = get_byte(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_3c_0(uae_u32 opcode) /* ORSR */
{
{	MakeSR();
{	uae_s16 src = get_iword(2);
	src &= 0xFF;
	regs.sr |= src;
	MakeFromSR();
}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_40_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_50_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_58_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_60_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_68_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s16 dst = get_word(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_70_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s16 dst = get_word(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 8;
}
unsigned long REGPARAM2 op_78_0(uae_u32 opcode) /* OR */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s16 dst = get_word(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_79_0(uae_u32 opcode) /* OR */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s16 dst = get_word(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_7c_0(uae_u32 opcode) /* ORSR */
{
{if (!regs.s) { Exception(8,0); goto endlabel18; }
{	MakeSR();
{	uae_s16 src = get_iword(2);
	regs.sr |= src;
	MakeFromSR();
}}}m68k_incpc(4);
endlabel18: ;
return 4;
}
unsigned long REGPARAM2 op_80_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_90_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_98_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_a0_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_a8_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(6);
{	uae_s32 dst = get_long(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_b0_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{m68k_incpc(6);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 14;
}
unsigned long REGPARAM2 op_b8_0(uae_u32 opcode) /* OR */
{
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(6);
{	uae_s32 dst = get_long(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_b9_0(uae_u32 opcode) /* OR */
{
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = get_ilong(6);
{	uae_s32 dst = get_long(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(10);
return 18;
}
unsigned long REGPARAM2 op_d0_0(uae_u32 opcode) /* CHK2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s8)get_byte(dsta); upper = (uae_s32)(uae_s8)get_byte(dsta+1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel27; }
}
}}}m68k_incpc(4);
endlabel27: ;
return 4;
}
unsigned long REGPARAM2 op_e8_0(uae_u32 opcode) /* CHK2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s8)get_byte(dsta); upper = (uae_s32)(uae_s8)get_byte(dsta+1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel28; }
}
}}}m68k_incpc(6);
endlabel28: ;
return 6;
}
unsigned long REGPARAM2 op_f0_0(uae_u32 opcode) /* CHK2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s8)get_byte(dsta); upper = (uae_s32)(uae_s8)get_byte(dsta+1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel29; }
}
}}}}endlabel29: ;
return 4;
}
unsigned long REGPARAM2 op_f8_0(uae_u32 opcode) /* CHK2 */
{
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s8)get_byte(dsta); upper = (uae_s32)(uae_s8)get_byte(dsta+1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel30; }
}
}}}m68k_incpc(6);
endlabel30: ;
return 6;
}
unsigned long REGPARAM2 op_f9_0(uae_u32 opcode) /* CHK2 */
{
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = get_ilong(4);
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s8)get_byte(dsta); upper = (uae_s32)(uae_s8)get_byte(dsta+1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel31; }
}
}}}m68k_incpc(8);
endlabel31: ;
return 8;
}
unsigned long REGPARAM2 op_fa_0(uae_u32 opcode) /* CHK2 */
{
	uae_u32 dstreg = 2;
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_getpc () + 4;
	dsta += (uae_s32)(uae_s16)get_iword(4);
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s8)get_byte(dsta); upper = (uae_s32)(uae_s8)get_byte(dsta+1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel32; }
}
}}}m68k_incpc(6);
endlabel32: ;
return 6;
}
unsigned long REGPARAM2 op_fb_0(uae_u32 opcode) /* CHK2 */
{
	uae_u32 dstreg = 3;
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s8)get_byte(dsta); upper = (uae_s32)(uae_s8)get_byte(dsta+1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel33; }
}
}}}}endlabel33: ;
return 4;
}
unsigned long REGPARAM2 op_100_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_108_0(uae_u32 opcode) /* MVPMR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr memp = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_u16 val = (get_byte(memp) << 8) + get_byte(memp + 2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_110_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_118_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_120_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_128_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_130_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}}return 4;
}
unsigned long REGPARAM2 op_138_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_139_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_13a_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
	uae_u32 dstreg = 2;
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_getpc () + 2;
	dsta += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_13b_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}}return 4;
}
unsigned long REGPARAM2 op_13c_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uae_s8 dst = get_ibyte(2);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_140_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	m68k_dreg(regs, dstreg) = (dst);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_148_0(uae_u32 opcode) /* MVPMR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr memp = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_u32 val = (get_byte(memp) << 24) + (get_byte(memp + 2) << 16)
              + (get_byte(memp + 4) << 8) + get_byte(memp + 6);
	m68k_dreg(regs, dstreg) = (val);
}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_150_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_158_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_160_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_168_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_170_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}}return 6;
}
unsigned long REGPARAM2 op_178_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_179_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_17a_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
	uae_u32 dstreg = 2;
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_getpc () + 2;
	dsta += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_17b_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}}return 6;
}
unsigned long REGPARAM2 op_180_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg(regs, dstreg) = (dst);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_188_0(uae_u32 opcode) /* MVPRM */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr memp = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	put_byte(memp, src >> 8); put_byte(memp + 2, src);
}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_190_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_198_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_1a0_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_1a8_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1b0_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}}return 6;
}
unsigned long REGPARAM2 op_1b8_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1b9_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_1ba_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
	uae_u32 dstreg = 2;
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_getpc () + 2;
	dsta += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1bb_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}}return 6;
}
unsigned long REGPARAM2 op_1c0_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg(regs, dstreg) = (dst);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_1c8_0(uae_u32 opcode) /* MVPRM */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr memp = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	put_byte(memp, src >> 24); put_byte(memp + 2, src >> 16);
	put_byte(memp + 4, src >> 8); put_byte(memp + 6, src);
}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_1d0_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_1d8_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_1e0_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_1e8_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1f0_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}}return 6;
}
unsigned long REGPARAM2 op_1f8_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1f9_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_1fa_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
	uae_u32 dstreg = 2;
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_getpc () + 2;
	dsta += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1fb_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}}return 6;
}
unsigned long REGPARAM2 op_200_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_210_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_218_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_220_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_228_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_230_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 8;
}
unsigned long REGPARAM2 op_238_0(uae_u32 opcode) /* AND */
{
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_239_0(uae_u32 opcode) /* AND */
{
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s8 dst = get_byte(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_23c_0(uae_u32 opcode) /* ANDSR */
{
{	MakeSR();
{	uae_s16 src = get_iword(2);
	src |= 0xFF00;
	regs.sr &= src;
	MakeFromSR();
}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_240_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_250_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_258_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_260_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_268_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s16 dst = get_word(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_270_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s16 dst = get_word(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 8;
}
unsigned long REGPARAM2 op_278_0(uae_u32 opcode) /* AND */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s16 dst = get_word(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_279_0(uae_u32 opcode) /* AND */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s16 dst = get_word(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_27c_0(uae_u32 opcode) /* ANDSR */
{
{if (!regs.s) { Exception(8,0); goto endlabel96; }
{	MakeSR();
{	uae_s16 src = get_iword(2);
	regs.sr &= src;
	MakeFromSR();
}}}m68k_incpc(4);
endlabel96: ;
return 4;
}
unsigned long REGPARAM2 op_280_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_290_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_298_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_2a0_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_2a8_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(6);
{	uae_s32 dst = get_long(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_2b0_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{m68k_incpc(6);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 14;
}
unsigned long REGPARAM2 op_2b8_0(uae_u32 opcode) /* AND */
{
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(6);
{	uae_s32 dst = get_long(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_2b9_0(uae_u32 opcode) /* AND */
{
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = get_ilong(6);
{	uae_s32 dst = get_long(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(10);
return 18;
}
unsigned long REGPARAM2 op_2d0_0(uae_u32 opcode) /* CHK2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s16)get_word(dsta); upper = (uae_s32)(uae_s16)get_word(dsta+2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel105; }
}
}}}m68k_incpc(4);
endlabel105: ;
return 4;
}
unsigned long REGPARAM2 op_2e8_0(uae_u32 opcode) /* CHK2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s16)get_word(dsta); upper = (uae_s32)(uae_s16)get_word(dsta+2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel106; }
}
}}}m68k_incpc(6);
endlabel106: ;
return 6;
}
unsigned long REGPARAM2 op_2f0_0(uae_u32 opcode) /* CHK2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s16)get_word(dsta); upper = (uae_s32)(uae_s16)get_word(dsta+2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel107; }
}
}}}}endlabel107: ;
return 4;
}
unsigned long REGPARAM2 op_2f8_0(uae_u32 opcode) /* CHK2 */
{
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s16)get_word(dsta); upper = (uae_s32)(uae_s16)get_word(dsta+2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel108; }
}
}}}m68k_incpc(6);
endlabel108: ;
return 6;
}
unsigned long REGPARAM2 op_2f9_0(uae_u32 opcode) /* CHK2 */
{
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = get_ilong(4);
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s16)get_word(dsta); upper = (uae_s32)(uae_s16)get_word(dsta+2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel109; }
}
}}}m68k_incpc(8);
endlabel109: ;
return 8;
}
unsigned long REGPARAM2 op_2fa_0(uae_u32 opcode) /* CHK2 */
{
	uae_u32 dstreg = 2;
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_getpc () + 4;
	dsta += (uae_s32)(uae_s16)get_iword(4);
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s16)get_word(dsta); upper = (uae_s32)(uae_s16)get_word(dsta+2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel110; }
}
}}}m68k_incpc(6);
endlabel110: ;
return 6;
}
unsigned long REGPARAM2 op_2fb_0(uae_u32 opcode) /* CHK2 */
{
	uae_u32 dstreg = 3;
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=(uae_s32)(uae_s16)get_word(dsta); upper = (uae_s32)(uae_s16)get_word(dsta+2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel111; }
}
}}}}endlabel111: ;
return 4;
}
unsigned long REGPARAM2 op_400_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_410_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_418_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_420_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_428_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_430_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}}return 8;
}
unsigned long REGPARAM2 op_438_0(uae_u32 opcode) /* SUB */
{
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_439_0(uae_u32 opcode) /* SUB */
{
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_440_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_450_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_458_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_460_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_468_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_470_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}}return 8;
}
unsigned long REGPARAM2 op_478_0(uae_u32 opcode) /* SUB */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_479_0(uae_u32 opcode) /* SUB */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_480_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_490_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_498_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_4a0_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_4a8_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(6);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_4b0_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{m68k_incpc(6);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}}return 14;
}
unsigned long REGPARAM2 op_4b8_0(uae_u32 opcode) /* SUB */
{
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(6);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_4b9_0(uae_u32 opcode) /* SUB */
{
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = get_ilong(6);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(10);
return 18;
}
unsigned long REGPARAM2 op_4d0_0(uae_u32 opcode) /* CHK2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=get_long(dsta); upper = get_long(dsta+4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel136; }
}
}}}m68k_incpc(4);
endlabel136: ;
return 4;
}
unsigned long REGPARAM2 op_4e8_0(uae_u32 opcode) /* CHK2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=get_long(dsta); upper = get_long(dsta+4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel137; }
}
}}}m68k_incpc(6);
endlabel137: ;
return 6;
}
unsigned long REGPARAM2 op_4f0_0(uae_u32 opcode) /* CHK2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=get_long(dsta); upper = get_long(dsta+4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel138; }
}
}}}}endlabel138: ;
return 4;
}
unsigned long REGPARAM2 op_4f8_0(uae_u32 opcode) /* CHK2 */
{
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=get_long(dsta); upper = get_long(dsta+4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel139; }
}
}}}m68k_incpc(6);
endlabel139: ;
return 6;
}
unsigned long REGPARAM2 op_4f9_0(uae_u32 opcode) /* CHK2 */
{
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = get_ilong(4);
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=get_long(dsta); upper = get_long(dsta+4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel140; }
}
}}}m68k_incpc(8);
endlabel140: ;
return 8;
}
unsigned long REGPARAM2 op_4fa_0(uae_u32 opcode) /* CHK2 */
{
	uae_u32 dstreg = 2;
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_getpc () + 4;
	dsta += (uae_s32)(uae_s16)get_iword(4);
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=get_long(dsta); upper = get_long(dsta+4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel141; }
}
}}}m68k_incpc(6);
endlabel141: ;
return 6;
}
unsigned long REGPARAM2 op_4fb_0(uae_u32 opcode) /* CHK2 */
{
	uae_u32 dstreg = 3;
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower=get_long(dsta); upper = get_long(dsta+4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG) { Exception(6,oldpc); goto endlabel142; }
}
}}}}endlabel142: ;
return 4;
}
unsigned long REGPARAM2 op_600_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_610_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_618_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_620_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_628_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_630_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}}return 8;
}
unsigned long REGPARAM2 op_638_0(uae_u32 opcode) /* ADD */
{
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_639_0(uae_u32 opcode) /* ADD */
{
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_640_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_650_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_658_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_660_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_668_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_670_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}}return 8;
}
unsigned long REGPARAM2 op_678_0(uae_u32 opcode) /* ADD */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_679_0(uae_u32 opcode) /* ADD */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_680_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_690_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_698_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_6a0_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_6a8_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(6);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_6b0_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{m68k_incpc(6);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}}return 14;
}
unsigned long REGPARAM2 op_6b8_0(uae_u32 opcode) /* ADD */
{
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(6);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_6b9_0(uae_u32 opcode) /* ADD */
{
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = get_ilong(6);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(10);
return 18;
}
unsigned long REGPARAM2 op_6c0_0(uae_u32 opcode) /* RTM */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{m68k_incpc(2);
	op_illg(opcode);
}return 2;
}
unsigned long REGPARAM2 op_6c8_0(uae_u32 opcode) /* RTM */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{m68k_incpc(2);
	op_illg(opcode);
}return 2;
}
unsigned long REGPARAM2 op_6d0_0(uae_u32 opcode) /* CALLM */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{m68k_incpc(2);
	op_illg(opcode);
}return 2;
}
unsigned long REGPARAM2 op_6e8_0(uae_u32 opcode) /* CALLM */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{m68k_incpc(2);
	op_illg(opcode);
}return 2;
}
unsigned long REGPARAM2 op_6f0_0(uae_u32 opcode) /* CALLM */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{m68k_incpc(2);
	op_illg(opcode);
}return 2;
}
unsigned long REGPARAM2 op_6f8_0(uae_u32 opcode) /* CALLM */
{
{m68k_incpc(2);
	op_illg(opcode);
}return 2;
}
unsigned long REGPARAM2 op_6f9_0(uae_u32 opcode) /* CALLM */
{
{m68k_incpc(2);
	op_illg(opcode);
}return 2;
}
unsigned long REGPARAM2 op_6fa_0(uae_u32 opcode) /* CALLM */
{
{m68k_incpc(2);
	op_illg(opcode);
}return 2;
}
unsigned long REGPARAM2 op_6fb_0(uae_u32 opcode) /* CALLM */
{
{m68k_incpc(2);
	op_illg(opcode);
}return 2;
}
unsigned long REGPARAM2 op_800_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_810_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_818_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_820_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_828_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_830_0(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}}return 6;
}
unsigned long REGPARAM2 op_838_0(uae_u32 opcode) /* BTST */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_839_0(uae_u32 opcode) /* BTST */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(8);
return 10;
}
unsigned long REGPARAM2 op_83a_0(uae_u32 opcode) /* BTST */
{
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_getpc () + 4;
	dsta += (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_83b_0(uae_u32 opcode) /* BTST */
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}}return 6;
}
unsigned long REGPARAM2 op_83c_0(uae_u32 opcode) /* BTST */
{
{{	uae_s16 src = get_iword(2);
{	uae_s8 dst = get_ibyte(4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_840_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	m68k_dreg(regs, dstreg) = (dst);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_850_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_858_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_860_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_868_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_870_0(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}}return 8;
}
unsigned long REGPARAM2 op_878_0(uae_u32 opcode) /* BCHG */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_879_0(uae_u32 opcode) /* BCHG */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_87a_0(uae_u32 opcode) /* BCHG */
{
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_getpc () + 4;
	dsta += (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_87b_0(uae_u32 opcode) /* BCHG */
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}}return 8;
}
unsigned long REGPARAM2 op_880_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg(regs, dstreg) = (dst);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_890_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_898_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_8a0_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_8a8_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_8b0_0(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}}return 8;
}
unsigned long REGPARAM2 op_8b8_0(uae_u32 opcode) /* BCLR */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_8b9_0(uae_u32 opcode) /* BCLR */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_8ba_0(uae_u32 opcode) /* BCLR */
{
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_getpc () + 4;
	dsta += (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_8bb_0(uae_u32 opcode) /* BCLR */
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}}return 8;
}
unsigned long REGPARAM2 op_8c0_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg(regs, dstreg) = (dst);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_8d0_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_8d8_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_8e0_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_8e8_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_8f0_0(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}}return 8;
}
unsigned long REGPARAM2 op_8f8_0(uae_u32 opcode) /* BSET */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_8f9_0(uae_u32 opcode) /* BSET */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_8fa_0(uae_u32 opcode) /* BSET */
{
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_getpc () + 4;
	dsta += (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_8fb_0(uae_u32 opcode) /* BSET */
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}}return 8;
}
unsigned long REGPARAM2 op_a00_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_a10_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_a18_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_a20_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_a28_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_a30_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 8;
}
unsigned long REGPARAM2 op_a38_0(uae_u32 opcode) /* EOR */
{
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_a39_0(uae_u32 opcode) /* EOR */
{
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s8 dst = get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_a3c_0(uae_u32 opcode) /* EORSR */
{
{	MakeSR();
{	uae_s16 src = get_iword(2);
	src &= 0xFF;
	regs.sr ^= src;
	MakeFromSR();
}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_a40_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_a50_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_a58_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_a60_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_a68_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s16 dst = get_word(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_a70_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s16 dst = get_word(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 8;
}
#endif

#ifdef PART_2
unsigned long REGPARAM2 op_a78_0(uae_u32 opcode) /* EOR */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s16 dst = get_word(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_a79_0(uae_u32 opcode) /* EOR */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s16 dst = get_word(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_a7c_0(uae_u32 opcode) /* EORSR */
{
{if (!regs.s) { Exception(8,0); goto endlabel234; }
{	MakeSR();
{	uae_s16 src = get_iword(2);
	regs.sr ^= src;
	MakeFromSR();
}}}m68k_incpc(4);
endlabel234: ;
return 4;
}
unsigned long REGPARAM2 op_a80_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_a90_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_a98_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_aa0_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_aa8_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(6);
{	uae_s32 dst = get_long(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_ab0_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{m68k_incpc(6);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 14;
}
unsigned long REGPARAM2 op_ab8_0(uae_u32 opcode) /* EOR */
{
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(6);
{	uae_s32 dst = get_long(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_ab9_0(uae_u32 opcode) /* EOR */
{
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = get_ilong(6);
{	uae_s32 dst = get_long(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(10);
return 18;
}
unsigned long REGPARAM2 op_ad0_0(uae_u32 opcode) /* CAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_byte(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_ad8_0(uae_u32 opcode) /* CAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_byte(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_ae0_0(uae_u32 opcode) /* CAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_byte(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_ae8_0(uae_u32 opcode) /* CAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_byte(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_af0_0(uae_u32 opcode) /* CAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_byte(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}}return 8;
}
unsigned long REGPARAM2 op_af8_0(uae_u32 opcode) /* CAS */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_byte(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_af9_0(uae_u32 opcode) /* CAS */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s8 dst = get_byte(dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_byte(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_c00_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_c10_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_c18_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_c20_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_c28_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_c30_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_c38_0(uae_u32 opcode) /* CMP */
{
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_c39_0(uae_u32 opcode) /* CMP */
{
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(8);
return 10;
}
unsigned long REGPARAM2 op_c3a_0(uae_u32 opcode) /* CMP */
{
	uae_u32 dstreg = 2;
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_getpc () + 4;
	dsta += (uae_s32)(uae_s16)get_iword(4);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_c3b_0(uae_u32 opcode) /* CMP */
{
	uae_u32 dstreg = 3;
{{	uae_s8 src = get_ibyte(2);
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_c40_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_c50_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_c58_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_c60_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_c68_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_c70_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_c78_0(uae_u32 opcode) /* CMP */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_c79_0(uae_u32 opcode) /* CMP */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(8);
return 10;
}
unsigned long REGPARAM2 op_c7a_0(uae_u32 opcode) /* CMP */
{
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_getpc () + 4;
	dsta += (uae_s32)(uae_s16)get_iword(4);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_c7b_0(uae_u32 opcode) /* CMP */
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_c80_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_c90_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_c98_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_ca0_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_ca8_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(6);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_cb0_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{m68k_incpc(6);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 10;
}
unsigned long REGPARAM2 op_cb8_0(uae_u32 opcode) /* CMP */
{
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(6);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_cb9_0(uae_u32 opcode) /* CMP */
{
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = get_ilong(6);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(10);
return 14;
}
unsigned long REGPARAM2 op_cba_0(uae_u32 opcode) /* CMP */
{
	uae_u32 dstreg = 2;
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_getpc () + 6;
	dsta += (uae_s32)(uae_s16)get_iword(6);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_cbb_0(uae_u32 opcode) /* CMP */
{
	uae_u32 dstreg = 3;
{{	uae_s32 src = get_ilong(2);
{m68k_incpc(6);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 10;
}
unsigned long REGPARAM2 op_cd0_0(uae_u32 opcode) /* CAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_word(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_cd8_0(uae_u32 opcode) /* CAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_word(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_ce0_0(uae_u32 opcode) /* CAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_word(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_ce8_0(uae_u32 opcode) /* CAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s16 dst = get_word(dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_word(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_cf0_0(uae_u32 opcode) /* CAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s16 dst = get_word(dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_word(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}}return 8;
}
unsigned long REGPARAM2 op_cf8_0(uae_u32 opcode) /* CAS */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s16 dst = get_word(dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_word(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_cf9_0(uae_u32 opcode) /* CAS */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s16 dst = get_word(dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_word(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_cfc_0(uae_u32 opcode) /* CAS2 */
{
{{	uae_s32 extra = get_ilong(2);
	uae_u32 rn1 = regs.regs[(extra >> 28) & 7];
	uae_u32 rn2 = regs.regs[(extra >> 12) & 7];
	uae_u16 dst1 = get_word(rn1), dst2 = get_word(rn2);
{uae_u32 newv = ((uae_s16)(dst1)) - ((uae_s16)(m68k_dreg(regs, (extra >> 16) & 7)));
{	int flgs = ((uae_s16)(m68k_dreg(regs, (extra >> 16) & 7))) < 0;
	int flgo = ((uae_s16)(dst1)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg(regs, (extra >> 16) & 7))) > ((uae_u16)(dst1)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG) {
{uae_u32 newv = ((uae_s16)(dst2)) - ((uae_s16)(m68k_dreg(regs, extra & 7)));
{	int flgs = ((uae_s16)(m68k_dreg(regs, extra & 7))) < 0;
	int flgo = ((uae_s16)(dst2)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg(regs, extra & 7))) > ((uae_u16)(dst2)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG) {
	put_word(rn1, m68k_dreg(regs, (extra >> 22) & 7));
	put_word(rn1, m68k_dreg(regs, (extra >> 6) & 7));
	}}
}}}}	if (! GET_ZFLG) {
	m68k_dreg(regs, (extra >> 22) & 7) = (m68k_dreg(regs, (extra >> 22) & 7) & ~0xffff) | (dst1 & 0xffff);
	m68k_dreg(regs, (extra >> 6) & 7) = (m68k_dreg(regs, (extra >> 6) & 7) & ~0xffff) | (dst2 & 0xffff);
	}
}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_e10_0(uae_u32 opcode) /* MOVES */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{if (!regs.s) { Exception(8,0); goto endlabel288; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg(regs, dstreg);
	put_byte(dsta,src);
}}else{{	uaecptr srca = m68k_areg(regs, dstreg);
{	uae_s8 src = get_byte(srca);
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}}}m68k_incpc(4);
endlabel288: ;
return 8;
}
unsigned long REGPARAM2 op_e18_0(uae_u32 opcode) /* MOVES */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{if (!regs.s) { Exception(8,0); goto endlabel289; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	put_byte(dsta,src);
}}else{{	uaecptr srca = m68k_areg(regs, dstreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}}}m68k_incpc(4);
endlabel289: ;
return 8;
}
unsigned long REGPARAM2 op_e20_0(uae_u32 opcode) /* MOVES */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{if (!regs.s) { Exception(8,0); goto endlabel290; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	put_byte(dsta,src);
}}else{{	uaecptr srca = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, dstreg) = srca;
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}}}m68k_incpc(4);
endlabel290: ;
return 8;
}
unsigned long REGPARAM2 op_e28_0(uae_u32 opcode) /* MOVES */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{if (!regs.s) { Exception(8,0); goto endlabel291; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	put_byte(dsta,src);
}}else{{	uaecptr srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(6);
{	uae_s8 src = get_byte(srca);
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}}}m68k_incpc(8);
endlabel291: ;
return 12;
}
unsigned long REGPARAM2 op_e30_0(uae_u32 opcode) /* MOVES */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{if (!regs.s) { Exception(8,0); goto endlabel292; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	put_byte(dsta,src);
}}}else{{{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 src = get_byte(srca);
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}}}}endlabel292: ;
return 8;
}
unsigned long REGPARAM2 op_e38_0(uae_u32 opcode) /* MOVES */
{
{if (!regs.s) { Exception(8,0); goto endlabel293; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	put_byte(dsta,src);
}}else{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(6);
{	uae_s8 src = get_byte(srca);
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}}}m68k_incpc(8);
endlabel293: ;
return 12;
}
unsigned long REGPARAM2 op_e39_0(uae_u32 opcode) /* MOVES */
{
{if (!regs.s) { Exception(8,0); goto endlabel294; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = get_ilong(4);
	put_byte(dsta,src);
}}else{{	uaecptr srca = get_ilong(8);
{	uae_s8 src = get_byte(srca);
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}}}m68k_incpc(12);
endlabel294: ;
return 16;
}
unsigned long REGPARAM2 op_e50_0(uae_u32 opcode) /* MOVES */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{if (!regs.s) { Exception(8,0); goto endlabel295; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg(regs, dstreg);
	put_word(dsta,src);
}}else{{	uaecptr srca = m68k_areg(regs, dstreg);
{	uae_s16 src = get_word(srca);
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}}}m68k_incpc(4);
endlabel295: ;
return 8;
}
unsigned long REGPARAM2 op_e58_0(uae_u32 opcode) /* MOVES */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{if (!regs.s) { Exception(8,0); goto endlabel296; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	put_word(dsta,src);
}}else{{	uaecptr srca = m68k_areg(regs, dstreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, dstreg) += 2;
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}}}m68k_incpc(4);
endlabel296: ;
return 8;
}
unsigned long REGPARAM2 op_e60_0(uae_u32 opcode) /* MOVES */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{if (!regs.s) { Exception(8,0); goto endlabel297; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	put_word(dsta,src);
}}else{{	uaecptr srca = m68k_areg(regs, dstreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, dstreg) = srca;
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}}}m68k_incpc(4);
endlabel297: ;
return 8;
}
unsigned long REGPARAM2 op_e68_0(uae_u32 opcode) /* MOVES */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{if (!regs.s) { Exception(8,0); goto endlabel298; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	put_word(dsta,src);
}}else{{	uaecptr srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(6);
{	uae_s16 src = get_word(srca);
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}}}m68k_incpc(8);
endlabel298: ;
return 12;
}
unsigned long REGPARAM2 op_e70_0(uae_u32 opcode) /* MOVES */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{if (!regs.s) { Exception(8,0); goto endlabel299; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	put_word(dsta,src);
}}}else{{{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s16 src = get_word(srca);
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}}}}endlabel299: ;
return 8;
}
unsigned long REGPARAM2 op_e78_0(uae_u32 opcode) /* MOVES */
{
{if (!regs.s) { Exception(8,0); goto endlabel300; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	put_word(dsta,src);
}}else{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(6);
{	uae_s16 src = get_word(srca);
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}}}m68k_incpc(8);
endlabel300: ;
return 12;
}
unsigned long REGPARAM2 op_e79_0(uae_u32 opcode) /* MOVES */
{
{if (!regs.s) { Exception(8,0); goto endlabel301; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = get_ilong(4);
	put_word(dsta,src);
}}else{{	uaecptr srca = get_ilong(8);
{	uae_s16 src = get_word(srca);
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}}}m68k_incpc(12);
endlabel301: ;
return 16;
}
unsigned long REGPARAM2 op_e90_0(uae_u32 opcode) /* MOVES */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{if (!regs.s) { Exception(8,0); goto endlabel302; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg(regs, dstreg);
	put_long(dsta,src);
}}else{{	uaecptr srca = m68k_areg(regs, dstreg);
{	uae_s32 src = get_long(srca);
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (src);
	}
}}}}}}m68k_incpc(4);
endlabel302: ;
return 12;
}
unsigned long REGPARAM2 op_e98_0(uae_u32 opcode) /* MOVES */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{if (!regs.s) { Exception(8,0); goto endlabel303; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	put_long(dsta,src);
}}else{{	uaecptr srca = m68k_areg(regs, dstreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, dstreg) += 4;
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (src);
	}
}}}}}}m68k_incpc(4);
endlabel303: ;
return 12;
}
unsigned long REGPARAM2 op_ea0_0(uae_u32 opcode) /* MOVES */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{if (!regs.s) { Exception(8,0); goto endlabel304; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	put_long(dsta,src);
}}else{{	uaecptr srca = m68k_areg(regs, dstreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, dstreg) = srca;
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (src);
	}
}}}}}}m68k_incpc(4);
endlabel304: ;
return 12;
}
unsigned long REGPARAM2 op_ea8_0(uae_u32 opcode) /* MOVES */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{if (!regs.s) { Exception(8,0); goto endlabel305; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	put_long(dsta,src);
}}else{{	uaecptr srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(6);
{	uae_s32 src = get_long(srca);
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (src);
	}
}}}}}}m68k_incpc(8);
endlabel305: ;
return 16;
}
unsigned long REGPARAM2 op_eb0_0(uae_u32 opcode) /* MOVES */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{if (!regs.s) { Exception(8,0); goto endlabel306; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	put_long(dsta,src);
}}}else{{{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 src = get_long(srca);
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (src);
	}
}}}}}}}endlabel306: ;
return 12;
}
unsigned long REGPARAM2 op_eb8_0(uae_u32 opcode) /* MOVES */
{
{if (!regs.s) { Exception(8,0); goto endlabel307; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	put_long(dsta,src);
}}else{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(6);
{	uae_s32 src = get_long(srca);
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (src);
	}
}}}}}}m68k_incpc(8);
endlabel307: ;
return 16;
}
unsigned long REGPARAM2 op_eb9_0(uae_u32 opcode) /* MOVES */
{
{if (!regs.s) { Exception(8,0); goto endlabel308; }
{{	uae_s16 extra = get_iword(2);
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta = get_ilong(4);
	put_long(dsta,src);
}}else{{	uaecptr srca = get_ilong(8);
{	uae_s32 src = get_long(srca);
	if (extra & 0x8000) {
	m68k_areg(regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg(regs, (extra >> 12) & 7) = (src);
	}
}}}}}}m68k_incpc(12);
endlabel308: ;
return 20;
}
unsigned long REGPARAM2 op_ed0_0(uae_u32 opcode) /* CAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_long(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_ed8_0(uae_u32 opcode) /* CAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_long(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_ee0_0(uae_u32 opcode) /* CAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_long(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_ee8_0(uae_u32 opcode) /* CAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 dst = get_long(dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_long(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_ef0_0(uae_u32 opcode) /* CAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_long(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}}return 12;
}
unsigned long REGPARAM2 op_ef8_0(uae_u32 opcode) /* CAS */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 dst = get_long(dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_long(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_ef9_0(uae_u32 opcode) /* CAS */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s32 dst = get_long(dsta);
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(m68k_dreg(regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG){	put_long(dsta,(m68k_dreg(regs, ru)));
}else{m68k_dreg(regs, rc) = dst;
}}}}}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_efc_0(uae_u32 opcode) /* CAS2 */
{
{{	uae_s32 extra = get_ilong(2);
	uae_u32 rn1 = regs.regs[(extra >> 28) & 7];
	uae_u32 rn2 = regs.regs[(extra >> 12) & 7];
	uae_u32 dst1 = get_long(rn1), dst2 = get_long(rn2);
{uae_u32 newv = ((uae_s32)(dst1)) - ((uae_s32)(m68k_dreg(regs, (extra >> 16) & 7)));
{	int flgs = ((uae_s32)(m68k_dreg(regs, (extra >> 16) & 7))) < 0;
	int flgo = ((uae_s32)(dst1)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg(regs, (extra >> 16) & 7))) > ((uae_u32)(dst1)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG) {
{uae_u32 newv = ((uae_s32)(dst2)) - ((uae_s32)(m68k_dreg(regs, extra & 7)));
{	int flgs = ((uae_s32)(m68k_dreg(regs, extra & 7))) < 0;
	int flgo = ((uae_s32)(dst2)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg(regs, extra & 7))) > ((uae_u32)(dst2)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG) {
	put_long(rn1, m68k_dreg(regs, (extra >> 22) & 7));
	put_long(rn1, m68k_dreg(regs, (extra >> 6) & 7));
	}}
}}}}	if (! GET_ZFLG) {
	m68k_dreg(regs, (extra >> 22) & 7) = dst1;
	m68k_dreg(regs, (extra >> 6) & 7) = dst2;
	}
}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_1000_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_1010_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_1018_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_1020_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_1028_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_1030_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return 4;
}
unsigned long REGPARAM2 op_1038_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_1039_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_103a_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_103b_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 src = get_byte(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return 4;
}
unsigned long REGPARAM2 op_103c_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_1080_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_1090_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_1098_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_10a0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_10a8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_10b0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_10b8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_10b9_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_10ba_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_10bb_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_10bc_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_10c0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_10d0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_10d8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_10e0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_10e8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_10f0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_10f8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_10f9_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_10fa_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_10fb_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_10fc_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_1100_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_1110_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_1118_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_1120_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_1128_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1130_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_1138_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1139_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_113a_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_113b_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_113c_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_1140_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_1150_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1158_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1160_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1168_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_1170_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}m68k_incpc(2);
return 8;
}
unsigned long REGPARAM2 op_1178_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_1179_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_117a_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_117b_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}m68k_incpc(2);
return 8;
}
unsigned long REGPARAM2 op_117c_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_1180_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}return 4;
}
unsigned long REGPARAM2 op_1190_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_1198_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_11a0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_11a8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 8;
}
unsigned long REGPARAM2 op_11b0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}}return 6;
}
unsigned long REGPARAM2 op_11b8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 8;
}
unsigned long REGPARAM2 op_11b9_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{m68k_incpc(6);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 10;
}
unsigned long REGPARAM2 op_11ba_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 8;
}
unsigned long REGPARAM2 op_11bb_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 src = get_byte(srca);
{{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}}return 6;
}
unsigned long REGPARAM2 op_11bc_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}return 6;
}
unsigned long REGPARAM2 op_11c0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_11d0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_11d8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_11e0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_11e8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_11f0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}m68k_incpc(2);
return 8;
}
unsigned long REGPARAM2 op_11f8_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_11f9_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_11fa_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_11fb_0(uae_u32 opcode) /* MOVE */
{
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}m68k_incpc(2);
return 8;
}
unsigned long REGPARAM2 op_11fc_0(uae_u32 opcode) /* MOVE */
{
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_13c0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_13d0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_13d8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_13e0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_13e8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_13f0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = get_ilong(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}m68k_incpc(4);
return 10;
}
unsigned long REGPARAM2 op_13f8_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_13f9_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = get_ilong(6);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(10);
return 14;
}
unsigned long REGPARAM2 op_13fa_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_13fb_0(uae_u32 opcode) /* MOVE */
{
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = get_ilong(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}m68k_incpc(4);
return 10;
}
unsigned long REGPARAM2 op_13fc_0(uae_u32 opcode) /* MOVE */
{
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}m68k_incpc(8);
return 10;
}
unsigned long REGPARAM2 op_2000_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_2008_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_2010_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_2018_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_2020_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_2028_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_2030_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_2038_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_2039_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_203a_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_203b_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_203c_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_2040_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_u32 val = src;
	m68k_areg(regs, dstreg) = (val);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_2048_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{	uae_u32 val = src;
	m68k_areg(regs, dstreg) = (val);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_2050_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uae_u32 val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_2058_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uae_u32 val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_2060_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u32 val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_2068_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_u32 val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_2070_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uae_u32 val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}}return 6;
}
unsigned long REGPARAM2 op_2078_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_u32 val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_2079_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uae_u32 val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_207a_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_u32 val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_207b_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uae_u32 val = src;
	m68k_areg(regs, dstreg) = (val);
}}}}}return 6;
}
unsigned long REGPARAM2 op_207c_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uae_u32 val = src;
	m68k_areg(regs, dstreg) = (val);
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_2080_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_2088_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_2090_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_2098_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_20a0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_20a8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_20b0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 10;
}
unsigned long REGPARAM2 op_20b8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_20b9_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_20ba_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_20bb_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 10;
}
unsigned long REGPARAM2 op_20bc_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_20c0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_20c8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_20d0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_20d8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_20e0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_20e8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_20f0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 10;
}
unsigned long REGPARAM2 op_20f8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_20f9_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_20fa_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_20fb_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 10;
}
unsigned long REGPARAM2 op_20fc_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_2100_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_2108_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_2110_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_2118_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_2120_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_2128_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_2130_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 10;
}
unsigned long REGPARAM2 op_2138_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_2139_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_213a_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_213b_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 10;
}
#endif

#ifdef PART_3
unsigned long REGPARAM2 op_213c_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_2140_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_2148_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_2150_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_2158_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_2160_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_2168_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_2170_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}m68k_incpc(2);
return 12;
}
unsigned long REGPARAM2 op_2178_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_2179_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_217a_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_217b_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}m68k_incpc(2);
return 12;
}
unsigned long REGPARAM2 op_217c_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_2180_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}return 6;
}
unsigned long REGPARAM2 op_2188_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}return 6;
}
unsigned long REGPARAM2 op_2190_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 10;
}
unsigned long REGPARAM2 op_2198_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 10;
}
unsigned long REGPARAM2 op_21a0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 10;
}
unsigned long REGPARAM2 op_21a8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 12;
}
unsigned long REGPARAM2 op_21b0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}}return 10;
}
unsigned long REGPARAM2 op_21b8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 12;
}
unsigned long REGPARAM2 op_21b9_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{m68k_incpc(6);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 14;
}
unsigned long REGPARAM2 op_21ba_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 12;
}
unsigned long REGPARAM2 op_21bb_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}}return 10;
}
unsigned long REGPARAM2 op_21bc_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{m68k_incpc(6);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}return 10;
}
unsigned long REGPARAM2 op_21c0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_21c8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_21d0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_21d8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_21e0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_21e8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_21f0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}m68k_incpc(2);
return 12;
}
unsigned long REGPARAM2 op_21f8_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_21f9_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_21fa_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_21fb_0(uae_u32 opcode) /* MOVE */
{
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}m68k_incpc(2);
return 12;
}
unsigned long REGPARAM2 op_21fc_0(uae_u32 opcode) /* MOVE */
{
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_23c0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_23c8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_23d0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_23d8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uaecptr dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_23e0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_23e8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_23f0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = get_ilong(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}m68k_incpc(4);
return 14;
}
unsigned long REGPARAM2 op_23f8_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_23f9_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = get_ilong(6);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(10);
return 18;
}
unsigned long REGPARAM2 op_23fa_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_23fb_0(uae_u32 opcode) /* MOVE */
{
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uaecptr dsta = get_ilong(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}m68k_incpc(4);
return 14;
}
unsigned long REGPARAM2 op_23fc_0(uae_u32 opcode) /* MOVE */
{
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = get_ilong(6);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}m68k_incpc(10);
return 14;
}
unsigned long REGPARAM2 op_3000_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_3008_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_3010_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_3018_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_3020_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_3028_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_3030_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return 4;
}
unsigned long REGPARAM2 op_3038_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_3039_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_303a_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_303b_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return 4;
}
unsigned long REGPARAM2 op_303c_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_3040_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_u32 val = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (val);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_3048_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
{	uae_u32 val = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (val);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_3050_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_u32 val = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_3058_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_u32 val = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_3060_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u32 val = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_3068_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_u32 val = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_3070_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_u32 val = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (val);
}}}}}return 4;
}
unsigned long REGPARAM2 op_3078_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_u32 val = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_3079_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_u32 val = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_307a_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_u32 val = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (val);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_307b_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uae_u32 val = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (val);
}}}}}return 4;
}
unsigned long REGPARAM2 op_307c_0(uae_u32 opcode) /* MOVEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_u32 val = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (val);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_3080_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_3088_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_3090_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_3098_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_30a0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_30a8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_30b0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_30b8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_30b9_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_30ba_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_30bb_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_30bc_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_30c0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_30c8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_30d0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_30d8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_30e0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_30e8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_30f0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_30f8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_30f9_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_30fa_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_30fb_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_30fc_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_3100_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_3108_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_3110_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_3118_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_3120_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_3128_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_3130_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_3138_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_3139_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_313a_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_313b_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_313c_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_3140_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_3148_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_3150_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_3158_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_3160_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_3168_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_3170_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}m68k_incpc(2);
return 8;
}
unsigned long REGPARAM2 op_3178_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_3179_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_317a_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_317b_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}m68k_incpc(2);
return 8;
}
unsigned long REGPARAM2 op_317c_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_3180_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}return 4;
}
unsigned long REGPARAM2 op_3188_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}return 4;
}
unsigned long REGPARAM2 op_3190_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_3198_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_31a0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_31a8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 8;
}
unsigned long REGPARAM2 op_31b0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}}return 6;
}
unsigned long REGPARAM2 op_31b8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 8;
}
unsigned long REGPARAM2 op_31b9_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{m68k_incpc(6);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 10;
}
unsigned long REGPARAM2 op_31ba_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 8;
}
unsigned long REGPARAM2 op_31bb_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}}return 6;
}
unsigned long REGPARAM2 op_31bc_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}return 6;
}
unsigned long REGPARAM2 op_31c0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_31c8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_31d0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_31d8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_31e0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_31e8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_31f0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}m68k_incpc(2);
return 8;
}
unsigned long REGPARAM2 op_31f8_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_31f9_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(6);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_31fa_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_31fb_0(uae_u32 opcode) /* MOVE */
{
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}m68k_incpc(2);
return 8;
}
unsigned long REGPARAM2 op_31fc_0(uae_u32 opcode) /* MOVE */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_33c0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_33c8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_33d0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_33d8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uaecptr dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_33e0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_33e8_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_33f0_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = get_ilong(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}m68k_incpc(4);
return 10;
}
unsigned long REGPARAM2 op_33f8_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_33f9_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = get_ilong(6);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(10);
return 14;
}
unsigned long REGPARAM2 op_33fa_0(uae_u32 opcode) /* MOVE */
{
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_33fb_0(uae_u32 opcode) /* MOVE */
{
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uaecptr dsta = get_ilong(0);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}m68k_incpc(4);
return 10;
}
unsigned long REGPARAM2 op_33fc_0(uae_u32 opcode) /* MOVE */
{
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_ilong(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}m68k_incpc(8);
return 10;
}
unsigned long REGPARAM2 op_4000_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4010_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(srca,newv);
}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4018_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(srca,newv);
}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4020_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(srca,newv);
}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4028_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(srca,newv);
}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4030_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(srca,newv);
}}}}}}return 6;
}
unsigned long REGPARAM2 op_4038_0(uae_u32 opcode) /* NEGX */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(srca,newv);
}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4039_0(uae_u32 opcode) /* NEGX */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(srca,newv);
}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_4040_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((newv) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4050_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word(srca,newv);
}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4058_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word(srca,newv);
}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4060_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word(srca,newv);
}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4068_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word(srca,newv);
}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4070_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word(srca,newv);
}}}}}}return 6;
}
unsigned long REGPARAM2 op_4078_0(uae_u32 opcode) /* NEGX */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word(srca,newv);
}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4079_0(uae_u32 opcode) /* NEGX */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word(srca,newv);
}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_4080_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, srcreg) = (newv);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4090_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_long(srca,newv);
}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_4098_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_long(srca,newv);
}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_40a0_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_long(srca,newv);
}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_40a8_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_long(srca,newv);
}}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_40b0_0(uae_u32 opcode) /* NEGX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_long(srca,newv);
}}}}}}return 10;
}
unsigned long REGPARAM2 op_40b8_0(uae_u32 opcode) /* NEGX */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_long(srca,newv);
}}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_40b9_0(uae_u32 opcode) /* NEGX */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uae_u32 newv = 0 - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_long(srca,newv);
}}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_40c0_0(uae_u32 opcode) /* MVSR2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel645; }
{{	MakeSR();
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((regs.sr) & 0xffff);
}}}m68k_incpc(2);
endlabel645: ;
return 2;
}
unsigned long REGPARAM2 op_40d0_0(uae_u32 opcode) /* MVSR2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel646; }
{{	uaecptr srca = m68k_areg(regs, srcreg);
	MakeSR();
	put_word(srca,regs.sr);
}}}m68k_incpc(2);
endlabel646: ;
return 4;
}
unsigned long REGPARAM2 op_40d8_0(uae_u32 opcode) /* MVSR2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel647; }
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	MakeSR();
	put_word(srca,regs.sr);
}}}m68k_incpc(2);
endlabel647: ;
return 4;
}
unsigned long REGPARAM2 op_40e0_0(uae_u32 opcode) /* MVSR2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel648; }
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
	m68k_areg (regs, srcreg) = srca;
	MakeSR();
	put_word(srca,regs.sr);
}}}m68k_incpc(2);
endlabel648: ;
return 4;
}
unsigned long REGPARAM2 op_40e8_0(uae_u32 opcode) /* MVSR2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel649; }
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
	MakeSR();
	put_word(srca,regs.sr);
}}}m68k_incpc(4);
endlabel649: ;
return 6;
}
unsigned long REGPARAM2 op_40f0_0(uae_u32 opcode) /* MVSR2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel650; }
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
	MakeSR();
	put_word(srca,regs.sr);
}}}}endlabel650: ;
return 4;
}
unsigned long REGPARAM2 op_40f8_0(uae_u32 opcode) /* MVSR2 */
{
{if (!regs.s) { Exception(8,0); goto endlabel651; }
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
	MakeSR();
	put_word(srca,regs.sr);
}}}m68k_incpc(4);
endlabel651: ;
return 6;
}
unsigned long REGPARAM2 op_40f9_0(uae_u32 opcode) /* MVSR2 */
{
{if (!regs.s) { Exception(8,0); goto endlabel652; }
{{	uaecptr srca = get_ilong(2);
	MakeSR();
	put_word(srca,regs.sr);
}}}m68k_incpc(6);
endlabel652: ;
return 8;
}
unsigned long REGPARAM2 op_4100_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel653; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel653; }
}}}m68k_incpc(2);
endlabel653: ;
return 2;
}
unsigned long REGPARAM2 op_4110_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel654; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel654; }
}}}}m68k_incpc(2);
endlabel654: ;
return 6;
}
unsigned long REGPARAM2 op_4118_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel655; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel655; }
}}}}m68k_incpc(2);
endlabel655: ;
return 6;
}
unsigned long REGPARAM2 op_4120_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel656; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel656; }
}}}}m68k_incpc(2);
endlabel656: ;
return 6;
}
unsigned long REGPARAM2 op_4128_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel657; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel657; }
}}}}m68k_incpc(4);
endlabel657: ;
return 8;
}
unsigned long REGPARAM2 op_4130_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel658; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel658; }
}}}}}endlabel658: ;
return 6;
}
unsigned long REGPARAM2 op_4138_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel659; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel659; }
}}}}m68k_incpc(4);
endlabel659: ;
return 8;
}
unsigned long REGPARAM2 op_4139_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel660; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel660; }
}}}}m68k_incpc(6);
endlabel660: ;
return 10;
}
unsigned long REGPARAM2 op_413a_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel661; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel661; }
}}}}m68k_incpc(4);
endlabel661: ;
return 8;
}
unsigned long REGPARAM2 op_413b_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel662; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel662; }
}}}}}endlabel662: ;
return 6;
}
unsigned long REGPARAM2 op_413c_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s32 src = get_ilong(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel663; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel663; }
}}}m68k_incpc(6);
endlabel663: ;
return 6;
}
unsigned long REGPARAM2 op_4180_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel664; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel664; }
}}}m68k_incpc(2);
endlabel664: ;
return 2;
}
unsigned long REGPARAM2 op_4190_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel665; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel665; }
}}}}m68k_incpc(2);
endlabel665: ;
return 4;
}
unsigned long REGPARAM2 op_4198_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel666; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel666; }
}}}}m68k_incpc(2);
endlabel666: ;
return 4;
}
unsigned long REGPARAM2 op_41a0_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel667; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel667; }
}}}}m68k_incpc(2);
endlabel667: ;
return 4;
}
unsigned long REGPARAM2 op_41a8_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel668; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel668; }
}}}}m68k_incpc(4);
endlabel668: ;
return 6;
}
unsigned long REGPARAM2 op_41b0_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel669; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel669; }
}}}}}endlabel669: ;
return 4;
}
unsigned long REGPARAM2 op_41b8_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel670; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel670; }
}}}}m68k_incpc(4);
endlabel670: ;
return 6;
}
unsigned long REGPARAM2 op_41b9_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel671; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel671; }
}}}}m68k_incpc(6);
endlabel671: ;
return 8;
}
unsigned long REGPARAM2 op_41ba_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel672; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel672; }
}}}}m68k_incpc(4);
endlabel672: ;
return 6;
}
unsigned long REGPARAM2 op_41bb_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel673; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel673; }
}}}}}endlabel673: ;
return 4;
}
unsigned long REGPARAM2 op_41bc_0(uae_u32 opcode) /* CHK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 src = get_iword(2);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	if ((uae_s32)dst < 0) { SET_NFLG (1); Exception(6,oldpc); goto endlabel674; }
	else if (dst > src) { SET_NFLG (0); Exception(6,oldpc); goto endlabel674; }
}}}m68k_incpc(4);
endlabel674: ;
return 4;
}
unsigned long REGPARAM2 op_41d0_0(uae_u32 opcode) /* LEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	m68k_areg(regs, dstreg) = (srca);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_41e8_0(uae_u32 opcode) /* LEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	m68k_areg(regs, dstreg) = (srca);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_41f0_0(uae_u32 opcode) /* LEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	m68k_areg(regs, dstreg) = (srca);
}}}}return 2;
}
unsigned long REGPARAM2 op_41f8_0(uae_u32 opcode) /* LEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	m68k_areg(regs, dstreg) = (srca);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_41f9_0(uae_u32 opcode) /* LEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	m68k_areg(regs, dstreg) = (srca);
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_41fa_0(uae_u32 opcode) /* LEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	m68k_areg(regs, dstreg) = (srca);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_41fb_0(uae_u32 opcode) /* LEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	m68k_areg(regs, dstreg) = (srca);
}}}}return 2;
}
unsigned long REGPARAM2 op_4200_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((0) & 0xff);
}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4210_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	put_byte(srca,0);
}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_4218_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	put_byte(srca,0);
}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_4220_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	put_byte(srca,0);
}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_4228_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	put_byte(srca,0);
}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_4230_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	put_byte(srca,0);
}}}return 4;
}
unsigned long REGPARAM2 op_4238_0(uae_u32 opcode) /* CLR */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	put_byte(srca,0);
}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_4239_0(uae_u32 opcode) /* CLR */
{
{{	uaecptr srca = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	put_byte(srca,0);
}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_4240_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((0) & 0xffff);
}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4250_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	put_word(srca,0);
}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_4258_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	put_word(srca,0);
}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_4260_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	put_word(srca,0);
}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_4268_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	put_word(srca,0);
}}m68k_incpc(4);
return 6;
}
#endif

#ifdef PART_4
unsigned long REGPARAM2 op_4270_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	put_word(srca,0);
}}}return 4;
}
unsigned long REGPARAM2 op_4278_0(uae_u32 opcode) /* CLR */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	put_word(srca,0);
}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_4279_0(uae_u32 opcode) /* CLR */
{
{{	uaecptr srca = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	put_word(srca,0);
}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_4280_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	m68k_dreg(regs, srcreg) = (0);
}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4290_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	put_long(srca,0);
}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4298_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	put_long(srca,0);
}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_42a0_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	put_long(srca,0);
}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_42a8_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	put_long(srca,0);
}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_42b0_0(uae_u32 opcode) /* CLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	put_long(srca,0);
}}}return 6;
}
unsigned long REGPARAM2 op_42b8_0(uae_u32 opcode) /* CLR */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	put_long(srca,0);
}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_42b9_0(uae_u32 opcode) /* CLR */
{
{{	uaecptr srca = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	put_long(srca,0);
}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_42c0_0(uae_u32 opcode) /* MVSR2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	MakeSR();
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((regs.sr & 0xff) & 0xffff);
}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_42d0_0(uae_u32 opcode) /* MVSR2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	MakeSR();
	put_word(srca,regs.sr & 0xff);
}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_42d8_0(uae_u32 opcode) /* MVSR2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	MakeSR();
	put_word(srca,regs.sr & 0xff);
}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_42e0_0(uae_u32 opcode) /* MVSR2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
	m68k_areg (regs, srcreg) = srca;
	MakeSR();
	put_word(srca,regs.sr & 0xff);
}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_42e8_0(uae_u32 opcode) /* MVSR2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
	MakeSR();
	put_word(srca,regs.sr & 0xff);
}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_42f0_0(uae_u32 opcode) /* MVSR2 */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
	MakeSR();
	put_word(srca,regs.sr & 0xff);
}}}return 4;
}
unsigned long REGPARAM2 op_42f8_0(uae_u32 opcode) /* MVSR2 */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
	MakeSR();
	put_word(srca,regs.sr & 0xff);
}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_42f9_0(uae_u32 opcode) /* MVSR2 */
{
{{	uaecptr srca = get_ilong(2);
	MakeSR();
	put_word(srca,regs.sr & 0xff);
}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_4400_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4410_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	SET_NFLG (flgn != 0);
	put_byte(srca,dst);
}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4418_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	SET_NFLG (flgn != 0);
	put_byte(srca,dst);
}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4420_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	SET_NFLG (flgn != 0);
	put_byte(srca,dst);
}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4428_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	SET_NFLG (flgn != 0);
	put_byte(srca,dst);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4430_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	SET_NFLG (flgn != 0);
	put_byte(srca,dst);
}}}}}}}return 6;
}
unsigned long REGPARAM2 op_4438_0(uae_u32 opcode) /* NEG */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	SET_NFLG (flgn != 0);
	put_byte(srca,dst);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4439_0(uae_u32 opcode) /* NEG */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{{uae_u32 dst = ((uae_s8)(0)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	SET_NFLG (flgn != 0);
	put_byte(srca,dst);
}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_4440_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4450_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	SET_NFLG (flgn != 0);
	put_word(srca,dst);
}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4458_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	SET_NFLG (flgn != 0);
	put_word(srca,dst);
}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4460_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	SET_NFLG (flgn != 0);
	put_word(srca,dst);
}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4468_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	SET_NFLG (flgn != 0);
	put_word(srca,dst);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4470_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	SET_NFLG (flgn != 0);
	put_word(srca,dst);
}}}}}}}return 6;
}
unsigned long REGPARAM2 op_4478_0(uae_u32 opcode) /* NEG */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	SET_NFLG (flgn != 0);
	put_word(srca,dst);
}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4479_0(uae_u32 opcode) /* NEG */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{{uae_u32 dst = ((uae_s16)(0)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	SET_NFLG (flgn != 0);
	put_word(srca,dst);
}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_4480_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, srcreg) = (dst);
}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4490_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	SET_NFLG (flgn != 0);
	put_long(srca,dst);
}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_4498_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	SET_NFLG (flgn != 0);
	put_long(srca,dst);
}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_44a0_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	SET_NFLG (flgn != 0);
	put_long(srca,dst);
}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_44a8_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	SET_NFLG (flgn != 0);
	put_long(srca,dst);
}}}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_44b0_0(uae_u32 opcode) /* NEG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	SET_NFLG (flgn != 0);
	put_long(srca,dst);
}}}}}}}return 10;
}
unsigned long REGPARAM2 op_44b8_0(uae_u32 opcode) /* NEG */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	SET_NFLG (flgn != 0);
	put_long(srca,dst);
}}}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_44b9_0(uae_u32 opcode) /* NEG */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{{uae_u32 dst = ((uae_s32)(0)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	SET_NFLG (flgn != 0);
	put_long(srca,dst);
}}}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_44c0_0(uae_u32 opcode) /* MV2SR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_44d0_0(uae_u32 opcode) /* MV2SR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_44d8_0(uae_u32 opcode) /* MV2SR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_44e0_0(uae_u32 opcode) /* MV2SR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_44e8_0(uae_u32 opcode) /* MV2SR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_44f0_0(uae_u32 opcode) /* MV2SR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}}return 4;
}
unsigned long REGPARAM2 op_44f8_0(uae_u32 opcode) /* MV2SR */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_44f9_0(uae_u32 opcode) /* MV2SR */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_44fa_0(uae_u32 opcode) /* MV2SR */
{
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_44fb_0(uae_u32 opcode) /* MV2SR */
{
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}}}return 4;
}
unsigned long REGPARAM2 op_44fc_0(uae_u32 opcode) /* MV2SR */
{
{{	uae_s16 src = get_iword(2);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_4600_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4610_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	put_byte(srca,dst);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4618_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	put_byte(srca,dst);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4620_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	put_byte(srca,dst);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4628_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	put_byte(srca,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4630_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	put_byte(srca,dst);
}}}}}return 6;
}
unsigned long REGPARAM2 op_4638_0(uae_u32 opcode) /* NOT */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	put_byte(srca,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4639_0(uae_u32 opcode) /* NOT */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	put_byte(srca,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_4640_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4650_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	put_word(srca,dst);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4658_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	put_word(srca,dst);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4660_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	put_word(srca,dst);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4668_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	put_word(srca,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4670_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	put_word(srca,dst);
}}}}}return 6;
}
unsigned long REGPARAM2 op_4678_0(uae_u32 opcode) /* NOT */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	put_word(srca,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4679_0(uae_u32 opcode) /* NOT */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	put_word(srca,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_4680_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (dst);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4690_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	put_long(srca,dst);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_4698_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	put_long(srca,dst);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_46a0_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	put_long(srca,dst);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_46a8_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	put_long(srca,dst);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_46b0_0(uae_u32 opcode) /* NOT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	put_long(srca,dst);
}}}}}return 10;
}
unsigned long REGPARAM2 op_46b8_0(uae_u32 opcode) /* NOT */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	put_long(srca,dst);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_46b9_0(uae_u32 opcode) /* NOT */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uae_u32 dst = ~src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	put_long(srca,dst);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_46c0_0(uae_u32 opcode) /* MV2SR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel773; }
{{	uae_s16 src = m68k_dreg(regs, srcreg);
	regs.sr = src;
	MakeFromSR();
}}}m68k_incpc(2);
endlabel773: ;
return 2;
}
unsigned long REGPARAM2 op_46d0_0(uae_u32 opcode) /* MV2SR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel774; }
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(2);
endlabel774: ;
return 4;
}
unsigned long REGPARAM2 op_46d8_0(uae_u32 opcode) /* MV2SR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel775; }
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(2);
endlabel775: ;
return 4;
}
unsigned long REGPARAM2 op_46e0_0(uae_u32 opcode) /* MV2SR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel776; }
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(2);
endlabel776: ;
return 4;
}
unsigned long REGPARAM2 op_46e8_0(uae_u32 opcode) /* MV2SR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel777; }
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(4);
endlabel777: ;
return 6;
}
unsigned long REGPARAM2 op_46f0_0(uae_u32 opcode) /* MV2SR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel778; }
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
	regs.sr = src;
	MakeFromSR();
}}}}}endlabel778: ;
return 4;
}
unsigned long REGPARAM2 op_46f8_0(uae_u32 opcode) /* MV2SR */
{
{if (!regs.s) { Exception(8,0); goto endlabel779; }
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(4);
endlabel779: ;
return 6;
}
unsigned long REGPARAM2 op_46f9_0(uae_u32 opcode) /* MV2SR */
{
{if (!regs.s) { Exception(8,0); goto endlabel780; }
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(6);
endlabel780: ;
return 8;
}
unsigned long REGPARAM2 op_46fa_0(uae_u32 opcode) /* MV2SR */
{
{if (!regs.s) { Exception(8,0); goto endlabel781; }
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
	regs.sr = src;
	MakeFromSR();
}}}}m68k_incpc(4);
endlabel781: ;
return 6;
}
unsigned long REGPARAM2 op_46fb_0(uae_u32 opcode) /* MV2SR */
{
{if (!regs.s) { Exception(8,0); goto endlabel782; }
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
	regs.sr = src;
	MakeFromSR();
}}}}}endlabel782: ;
return 4;
}
unsigned long REGPARAM2 op_46fc_0(uae_u32 opcode) /* MV2SR */
{
{if (!regs.s) { Exception(8,0); goto endlabel783; }
{{	uae_s16 src = get_iword(2);
	regs.sr = src;
	MakeFromSR();
}}}m68k_incpc(4);
endlabel783: ;
return 4;
}
unsigned long REGPARAM2 op_4800_0(uae_u32 opcode) /* NBCD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo-=6; newv_hi-=0x10; }
	newv = newv_hi + (newv_lo & 0xF);	SET_CFLG (cflg = (newv_hi & 0x1F0) > 0x90);
	if (cflg) newv -= 0x60;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4808_0(uae_u32 opcode) /* LINK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr olda = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = olda;
{	uae_s32 src = m68k_areg(regs, srcreg);
	put_long(olda,src);
	m68k_areg(regs, srcreg) = (m68k_areg(regs, 7));
{	uae_s32 offs = get_ilong(2);
	m68k_areg(regs, 7) += offs;
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_4810_0(uae_u32 opcode) /* NBCD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo-=6; newv_hi-=0x10; }
	newv = newv_hi + (newv_lo & 0xF);	SET_CFLG (cflg = (newv_hi & 0x1F0) > 0x90);
	if (cflg) newv -= 0x60;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(srca,newv);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4818_0(uae_u32 opcode) /* NBCD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo-=6; newv_hi-=0x10; }
	newv = newv_hi + (newv_lo & 0xF);	SET_CFLG (cflg = (newv_hi & 0x1F0) > 0x90);
	if (cflg) newv -= 0x60;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(srca,newv);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4820_0(uae_u32 opcode) /* NBCD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo-=6; newv_hi-=0x10; }
	newv = newv_hi + (newv_lo & 0xF);	SET_CFLG (cflg = (newv_hi & 0x1F0) > 0x90);
	if (cflg) newv -= 0x60;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(srca,newv);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4828_0(uae_u32 opcode) /* NBCD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo-=6; newv_hi-=0x10; }
	newv = newv_hi + (newv_lo & 0xF);	SET_CFLG (cflg = (newv_hi & 0x1F0) > 0x90);
	if (cflg) newv -= 0x60;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(srca,newv);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4830_0(uae_u32 opcode) /* NBCD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo-=6; newv_hi-=0x10; }
	newv = newv_hi + (newv_lo & 0xF);	SET_CFLG (cflg = (newv_hi & 0x1F0) > 0x90);
	if (cflg) newv -= 0x60;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(srca,newv);
}}}}}return 6;
}
unsigned long REGPARAM2 op_4838_0(uae_u32 opcode) /* NBCD */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo-=6; newv_hi-=0x10; }
	newv = newv_hi + (newv_lo & 0xF);	SET_CFLG (cflg = (newv_hi & 0x1F0) > 0x90);
	if (cflg) newv -= 0x60;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(srca,newv);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4839_0(uae_u32 opcode) /* NBCD */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo-=6; newv_hi-=0x10; }
	newv = newv_hi + (newv_lo & 0xF);	SET_CFLG (cflg = (newv_hi & 0x1F0) > 0x90);
	if (cflg) newv -= 0x60;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(srca,newv);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_4840_0(uae_u32 opcode) /* SWAP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_u32 dst = ((src >> 16)&0xFFFF) | ((src&0xFFFF)<<16);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (dst);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4848_0(uae_u32 opcode) /* BKPT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{m68k_incpc(2);
	op_illg(opcode);
}return 2;
}
unsigned long REGPARAM2 op_4850_0(uae_u32 opcode) /* PEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	put_long(dsta,srca);
}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4868_0(uae_u32 opcode) /* PEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uaecptr dsta = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	put_long(dsta,srca);
}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4870_0(uae_u32 opcode) /* PEA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uaecptr dsta = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	put_long(dsta,srca);
}}}}return 6;
}
unsigned long REGPARAM2 op_4878_0(uae_u32 opcode) /* PEA */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uaecptr dsta = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	put_long(dsta,srca);
}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4879_0(uae_u32 opcode) /* PEA */
{
{{	uaecptr srca = get_ilong(2);
{	uaecptr dsta = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	put_long(dsta,srca);
}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_487a_0(uae_u32 opcode) /* PEA */
{
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uaecptr dsta = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	put_long(dsta,srca);
}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_487b_0(uae_u32 opcode) /* PEA */
{
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uaecptr dsta = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	put_long(dsta,srca);
}}}}return 6;
}
unsigned long REGPARAM2 op_4880_0(uae_u32 opcode) /* EXT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_u16 dst = (uae_s16)(uae_s8)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4890_0(uae_u32 opcode) /* MVMLE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
{	uaecptr srca = m68k_areg(regs, dstreg);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { put_word(srca, m68k_areg(regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_48a0_0(uae_u32 opcode) /* MVMLE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
{	uaecptr srca = m68k_areg(regs, dstreg) - 0;
{	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	while (amask) { srca -= 2; put_word(srca, m68k_areg(regs, movem_index2[amask])); amask = movem_next[amask]; }
	while (dmask) { srca -= 2; put_word(srca, m68k_dreg(regs, movem_index2[dmask])); dmask = movem_next[dmask]; }
	m68k_areg(regs, dstreg) = srca;
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_48a8_0(uae_u32 opcode) /* MVMLE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
{	uaecptr srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { put_word(srca, m68k_areg(regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_48b0_0(uae_u32 opcode) /* MVMLE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
{m68k_incpc(4);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { put_word(srca, m68k_areg(regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
}}}}return 4;
}
unsigned long REGPARAM2 op_48b8_0(uae_u32 opcode) /* MVMLE */
{
{	uae_u16 mask = get_iword(2);
{	uaecptr srca = (uae_s32)(uae_s16)get_iword(4);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { put_word(srca, m68k_areg(regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_48b9_0(uae_u32 opcode) /* MVMLE */
{
{	uae_u16 mask = get_iword(2);
{	uaecptr srca = get_ilong(4);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_word(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { put_word(srca, m68k_areg(regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
}}}m68k_incpc(8);
return 8;
}
unsigned long REGPARAM2 op_48c0_0(uae_u32 opcode) /* EXT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_u32 dst = (uae_s32)(uae_s16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (dst);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_48d0_0(uae_u32 opcode) /* MVMLE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
{	uaecptr srca = m68k_areg(regs, dstreg);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_long(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { put_long(srca, m68k_areg(regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_48e0_0(uae_u32 opcode) /* MVMLE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
{	uaecptr srca = m68k_areg(regs, dstreg) - 0;
{	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	while (amask) { srca -= 4; put_long(srca, m68k_areg(regs, movem_index2[amask])); amask = movem_next[amask]; }
	while (dmask) { srca -= 4; put_long(srca, m68k_dreg(regs, movem_index2[dmask])); dmask = movem_next[dmask]; }
	m68k_areg(regs, dstreg) = srca;
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_48e8_0(uae_u32 opcode) /* MVMLE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
{	uaecptr srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_long(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { put_long(srca, m68k_areg(regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_48f0_0(uae_u32 opcode) /* MVMLE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
{m68k_incpc(4);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_long(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { put_long(srca, m68k_areg(regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
}}}}return 4;
}
unsigned long REGPARAM2 op_48f8_0(uae_u32 opcode) /* MVMLE */
{
{	uae_u16 mask = get_iword(2);
{	uaecptr srca = (uae_s32)(uae_s16)get_iword(4);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_long(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { put_long(srca, m68k_areg(regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_48f9_0(uae_u32 opcode) /* MVMLE */
{
{	uae_u16 mask = get_iword(2);
{	uaecptr srca = get_ilong(4);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { put_long(srca, m68k_dreg(regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { put_long(srca, m68k_areg(regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
}}}m68k_incpc(8);
return 8;
}
unsigned long REGPARAM2 op_49c0_0(uae_u32 opcode) /* EXT */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_u32 dst = (uae_s32)(uae_s8)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (dst);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4a00_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4a10_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_4a18_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_4a20_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_4a28_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_4a30_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}}return 4;
}
unsigned long REGPARAM2 op_4a38_0(uae_u32 opcode) /* TST */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_4a39_0(uae_u32 opcode) /* TST */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_4a3a_0(uae_u32 opcode) /* TST */
{
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_4a3b_0(uae_u32 opcode) /* TST */
{
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 src = get_byte(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}}return 4;
}
unsigned long REGPARAM2 op_4a3c_0(uae_u32 opcode) /* TST */
{
{{	uae_s8 src = get_ibyte(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_4a40_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4a48_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4a50_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_4a58_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_4a60_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_4a68_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_4a70_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}return 4;
}
unsigned long REGPARAM2 op_4a78_0(uae_u32 opcode) /* TST */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_4a79_0(uae_u32 opcode) /* TST */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_4a7a_0(uae_u32 opcode) /* TST */
{
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_4a7b_0(uae_u32 opcode) /* TST */
{
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}return 4;
}
unsigned long REGPARAM2 op_4a7c_0(uae_u32 opcode) /* TST */
{
{{	uae_s16 src = get_iword(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_4a80_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4a88_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4a90_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4a98_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4aa0_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4aa8_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4ab0_0(uae_u32 opcode) /* TST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}return 6;
}
unsigned long REGPARAM2 op_4ab8_0(uae_u32 opcode) /* TST */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4ab9_0(uae_u32 opcode) /* TST */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_4aba_0(uae_u32 opcode) /* TST */
{
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4abb_0(uae_u32 opcode) /* TST */
{
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}return 6;
}
unsigned long REGPARAM2 op_4abc_0(uae_u32 opcode) /* TST */
{
{{	uae_s32 src = get_ilong(2);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_4ac0_0(uae_u32 opcode) /* TAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((src) & 0xff);
}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4ad0_0(uae_u32 opcode) /* TAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	put_byte(srca,src);
}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4ad8_0(uae_u32 opcode) /* TAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	put_byte(srca,src);
}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4ae0_0(uae_u32 opcode) /* TAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	put_byte(srca,src);
}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4ae8_0(uae_u32 opcode) /* TAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	put_byte(srca,src);
}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4af0_0(uae_u32 opcode) /* TAS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	put_byte(srca,src);
}}}}return 6;
}
unsigned long REGPARAM2 op_4af8_0(uae_u32 opcode) /* TAS */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	put_byte(srca,src);
}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4af9_0(uae_u32 opcode) /* TAS */
{
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	put_byte(srca,src);
}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_4c00_0(uae_u32 opcode) /* MULL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
m68k_incpc(4);
	m68k_mull(opcode, dst, extra);
}}}return 4;
}
unsigned long REGPARAM2 op_4c10_0(uae_u32 opcode) /* MULL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
m68k_incpc(4);
	m68k_mull(opcode, dst, extra);
}}}}return 8;
}
unsigned long REGPARAM2 op_4c18_0(uae_u32 opcode) /* MULL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
m68k_incpc(4);
	m68k_mull(opcode, dst, extra);
}}}}return 8;
}
unsigned long REGPARAM2 op_4c20_0(uae_u32 opcode) /* MULL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
m68k_incpc(4);
	m68k_mull(opcode, dst, extra);
}}}}return 8;
}
unsigned long REGPARAM2 op_4c28_0(uae_u32 opcode) /* MULL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 dst = get_long(dsta);
m68k_incpc(6);
	m68k_mull(opcode, dst, extra);
}}}}return 10;
}
unsigned long REGPARAM2 op_4c30_0(uae_u32 opcode) /* MULL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
	m68k_mull(opcode, dst, extra);
}}}}}return 8;
}
unsigned long REGPARAM2 op_4c38_0(uae_u32 opcode) /* MULL */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 dst = get_long(dsta);
m68k_incpc(6);
	m68k_mull(opcode, dst, extra);
}}}}return 10;
}
unsigned long REGPARAM2 op_4c39_0(uae_u32 opcode) /* MULL */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s32 dst = get_long(dsta);
m68k_incpc(8);
	m68k_mull(opcode, dst, extra);
}}}}return 12;
}
unsigned long REGPARAM2 op_4c3a_0(uae_u32 opcode) /* MULL */
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_getpc () + 4;
	dsta += (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 dst = get_long(dsta);
m68k_incpc(6);
	m68k_mull(opcode, dst, extra);
}}}}return 10;
}
unsigned long REGPARAM2 op_4c3b_0(uae_u32 opcode) /* MULL */
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 dst = get_long(dsta);
	m68k_mull(opcode, dst, extra);
}}}}}return 8;
}
unsigned long REGPARAM2 op_4c3c_0(uae_u32 opcode) /* MULL */
{
{{	uae_s16 extra = get_iword(2);
{	uae_s32 dst = get_ilong(4);
m68k_incpc(8);
	m68k_mull(opcode, dst, extra);
}}}return 8;
}
unsigned long REGPARAM2 op_4c40_0(uae_u32 opcode) /* DIVL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{m68k_incpc(2);
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(0);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
m68k_incpc(2);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}return 4;
}
unsigned long REGPARAM2 op_4c50_0(uae_u32 opcode) /* DIVL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{m68k_incpc(2);
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(0);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
m68k_incpc(2);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}return 8;
}
unsigned long REGPARAM2 op_4c58_0(uae_u32 opcode) /* DIVL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{m68k_incpc(2);
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(0);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
m68k_incpc(2);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}return 8;
}
unsigned long REGPARAM2 op_4c60_0(uae_u32 opcode) /* DIVL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{m68k_incpc(2);
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(0);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
m68k_incpc(2);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}return 8;
}
unsigned long REGPARAM2 op_4c68_0(uae_u32 opcode) /* DIVL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{m68k_incpc(2);
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(0);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
m68k_incpc(4);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}return 10;
}
unsigned long REGPARAM2 op_4c70_0(uae_u32 opcode) /* DIVL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{m68k_incpc(2);
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(0);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}}return 8;
}
unsigned long REGPARAM2 op_4c78_0(uae_u32 opcode) /* DIVL */
{
{m68k_incpc(2);
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(0);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
m68k_incpc(4);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}return 10;
}
unsigned long REGPARAM2 op_4c79_0(uae_u32 opcode) /* DIVL */
{
{m68k_incpc(2);
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(0);
{	uaecptr dsta = get_ilong(2);
{	uae_s32 dst = get_long(dsta);
m68k_incpc(6);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}return 12;
}
unsigned long REGPARAM2 op_4c7a_0(uae_u32 opcode) /* DIVL */
{
	uae_u32 dstreg = 2;
{m68k_incpc(2);
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(0);
{	uaecptr dsta = m68k_getpc () + 2;
	dsta += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
m68k_incpc(4);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}return 10;
}
unsigned long REGPARAM2 op_4c7b_0(uae_u32 opcode) /* DIVL */
{
	uae_u32 dstreg = 3;
{m68k_incpc(2);
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(0);
{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 dst = get_long(dsta);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}}}return 8;
}
unsigned long REGPARAM2 op_4c7c_0(uae_u32 opcode) /* DIVL */
{
{m68k_incpc(2);
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 extra = get_iword(0);
{	uae_s32 dst = get_ilong(2);
m68k_incpc(6);
	m68k_divl(opcode, dst, extra, oldpc);
}}}}return 8;
}
unsigned long REGPARAM2 op_4c90_0(uae_u32 opcode) /* MVMEL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_areg(regs, dstreg);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; amask = movem_next[amask]; }
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_4c98_0(uae_u32 opcode) /* MVMEL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_areg(regs, dstreg);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; amask = movem_next[amask]; }
	m68k_areg(regs, dstreg) = srca;
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_4ca8_0(uae_u32 opcode) /* MVMEL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; amask = movem_next[amask]; }
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_4cb0_0(uae_u32 opcode) /* MVMEL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{m68k_incpc(4);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; amask = movem_next[amask]; }
}}}}return 4;
}
unsigned long REGPARAM2 op_4cb8_0(uae_u32 opcode) /* MVMEL */
{
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = (uae_s32)(uae_s16)get_iword(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; amask = movem_next[amask]; }
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_4cb9_0(uae_u32 opcode) /* MVMEL */
{
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = get_ilong(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; amask = movem_next[amask]; }
}}}m68k_incpc(8);
return 8;
}
unsigned long REGPARAM2 op_4cba_0(uae_u32 opcode) /* MVMEL */
{
	uae_u32 dstreg = 2;
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_getpc () + 4;
	srca += (uae_s32)(uae_s16)get_iword(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; amask = movem_next[amask]; }
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_4cbb_0(uae_u32 opcode) /* MVMEL */
{
	uae_u32 dstreg = 3;
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word(srca); srca += 2; amask = movem_next[amask]; }
}}}}return 4;
}
unsigned long REGPARAM2 op_4cd0_0(uae_u32 opcode) /* MVMEL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_areg(regs, dstreg);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = get_long(srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = get_long(srca); srca += 4; amask = movem_next[amask]; }
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_4cd8_0(uae_u32 opcode) /* MVMEL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_areg(regs, dstreg);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = get_long(srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = get_long(srca); srca += 4; amask = movem_next[amask]; }
	m68k_areg(regs, dstreg) = srca;
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_4ce8_0(uae_u32 opcode) /* MVMEL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = get_long(srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = get_long(srca); srca += 4; amask = movem_next[amask]; }
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_4cf0_0(uae_u32 opcode) /* MVMEL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{m68k_incpc(4);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = get_long(srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = get_long(srca); srca += 4; amask = movem_next[amask]; }
}}}}return 4;
}
unsigned long REGPARAM2 op_4cf8_0(uae_u32 opcode) /* MVMEL */
{
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = (uae_s32)(uae_s16)get_iword(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = get_long(srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = get_long(srca); srca += 4; amask = movem_next[amask]; }
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_4cf9_0(uae_u32 opcode) /* MVMEL */
{
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = get_ilong(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = get_long(srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = get_long(srca); srca += 4; amask = movem_next[amask]; }
}}}m68k_incpc(8);
return 8;
}
unsigned long REGPARAM2 op_4cfa_0(uae_u32 opcode) /* MVMEL */
{
	uae_u32 dstreg = 2;
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca = m68k_getpc () + 4;
	srca += (uae_s32)(uae_s16)get_iword(4);
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = get_long(srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = get_long(srca); srca += 4; amask = movem_next[amask]; }
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_4cfb_0(uae_u32 opcode) /* MVMEL */
{
	uae_u32 dstreg = 3;
{	uae_u16 mask = get_iword(2);
	unsigned int dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	while (dmask) { m68k_dreg(regs, movem_index1[dmask]) = get_long(srca); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { m68k_areg(regs, movem_index1[amask]) = get_long(srca); srca += 4; amask = movem_next[amask]; }
}}}}return 4;
}
unsigned long REGPARAM2 op_4e40_0(uae_u32 opcode) /* TRAP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 15);
#else
	uae_u32 srcreg = (opcode & 15);
#endif
{{	uae_u32 src = srcreg;
m68k_incpc(2);
	Exception(src+32,0);
}}return 2;
}
unsigned long REGPARAM2 op_4e50_0(uae_u32 opcode) /* LINK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr olda = m68k_areg(regs, 7) - 4;
	m68k_areg (regs, 7) = olda;
{	uae_s32 src = m68k_areg(regs, srcreg);
	put_long(olda,src);
	m68k_areg(regs, srcreg) = (m68k_areg(regs, 7));
{	uae_s16 offs = get_iword(2);
	m68k_areg(regs, 7) += offs;
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_4e58_0(uae_u32 opcode) /* UNLK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
	m68k_areg(regs, 7) = src;
{	uaecptr olda = m68k_areg(regs, 7);
{	uae_s32 old = get_long(olda);
	m68k_areg(regs, 7) += 4;
	m68k_areg(regs, srcreg) = (old);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_4e60_0(uae_u32 opcode) /* MVR2USP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel901; }
{{	uae_s32 src = m68k_areg(regs, srcreg);
	regs.usp = src;
}}}m68k_incpc(2);
endlabel901: ;
return 2;
}
unsigned long REGPARAM2 op_4e68_0(uae_u32 opcode) /* MVUSP2R */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel902; }
{{	m68k_areg(regs, srcreg) = (regs.usp);
}}}m68k_incpc(2);
endlabel902: ;
return 2;
}
unsigned long REGPARAM2 op_4e70_0(uae_u32 opcode) /* RESET */
{
{if (!regs.s) { Exception(8,0); goto endlabel903; }
{	customreset();
}}m68k_incpc(2);
endlabel903: ;
return 2;
}
unsigned long REGPARAM2 op_4e71_0(uae_u32 opcode) /* NOP */
{
{}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_4e72_0(uae_u32 opcode) /* STOP */
{
{if (!regs.s) { Exception(8,0); goto endlabel905; }
{{	uae_s16 src = get_iword(2);
	regs.sr = src;
	MakeFromSR();
	m68k_setstopped(1);
}}}m68k_incpc(4);
endlabel905: ;
return 4;
}
unsigned long REGPARAM2 op_4e73_0(uae_u32 opcode) /* RTE */
{
{if (!regs.s) { Exception(8,0); goto endlabel906; }
{	uae_u16 newsr; uae_u32 newpc; for (;;) {
{	uaecptr sra = m68k_areg(regs, 7);
{	uae_s16 sr = get_word(sra);
	m68k_areg(regs, 7) += 2;
{	uaecptr pca = m68k_areg(regs, 7);
{	uae_s32 pc = get_long(pca);
	m68k_areg(regs, 7) += 4;
{	uaecptr formata = m68k_areg(regs, 7);
{	uae_s16 format = get_word(formata);
	m68k_areg(regs, 7) += 2;
	newsr = sr; newpc = pc;
	if ((format & 0xF000) == 0x0000) { break; }
	else if ((format & 0xF000) == 0x1000) { ; }
	else if ((format & 0xF000) == 0x2000) { m68k_areg(regs, 7) += 4; break; }
	else if ((format & 0xF000) == 0x8000) { m68k_areg(regs, 7) += 50; break; }
	else if ((format & 0xF000) == 0x9000) { m68k_areg(regs, 7) += 12; break; }
	else if ((format & 0xF000) == 0xa000) { m68k_areg(regs, 7) += 24; break; }
	else if ((format & 0xF000) == 0xb000) { m68k_areg(regs, 7) += 84; break; }
	else { Exception(14,0); goto endlabel906; }
	regs.sr = newsr; MakeFromSR();
}
}}}}}}	regs.sr = newsr; MakeFromSR();
	m68k_setpc_rte(newpc);
}}endlabel906: ;
return 10;
}
unsigned long REGPARAM2 op_4e74_0(uae_u32 opcode) /* RTD */
{
{	compiler_flush_jsr_stack();
{	uaecptr pca = m68k_areg(regs, 7);
{	uae_s32 pc = get_long(pca);
	m68k_areg(regs, 7) += 4;
{	uae_s16 offs = get_iword(2);
	m68k_areg(regs, 7) += offs;
	m68k_setpc_rte(pc);
}}}}return 8;
}
unsigned long REGPARAM2 op_4e75_0(uae_u32 opcode) /* RTS */
{
{	m68k_do_rts();
}return 2;
}
unsigned long REGPARAM2 op_4e76_0(uae_u32 opcode) /* TRAPV */
{
{m68k_incpc(2);
	if (GET_VFLG) { Exception(7,m68k_getpc()); goto endlabel909; }
}endlabel909: ;
return 2;
}
unsigned long REGPARAM2 op_4e77_0(uae_u32 opcode) /* RTR */
{
{	compiler_flush_jsr_stack();
	MakeSR();
{	uaecptr sra = m68k_areg(regs, 7);
{	uae_s16 sr = get_word(sra);
	m68k_areg(regs, 7) += 2;
{	uaecptr pca = m68k_areg(regs, 7);
{	uae_s32 pc = get_long(pca);
	m68k_areg(regs, 7) += 4;
	regs.sr &= 0xFF00; sr &= 0xFF;
	regs.sr |= sr; m68k_setpc(pc);
	MakeFromSR();
}}}}}return 8;
}
unsigned long REGPARAM2 op_4e7a_0(uae_u32 opcode) /* MOVEC2 */
{
{if (!regs.s) { Exception(8,0); goto endlabel911; }
{{	uae_s16 src = get_iword(2);
{	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	m68k_movec2(src & 0xFFF, regp);
}}}}m68k_incpc(4);
endlabel911: ;
return 4;
}
unsigned long REGPARAM2 op_4e7b_0(uae_u32 opcode) /* MOVE2C */
{
{if (!regs.s) { Exception(8,0); goto endlabel912; }
{{	uae_s16 src = get_iword(2);
{	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	m68k_move2c(src & 0xFFF, regp);
}}}}m68k_incpc(4);
endlabel912: ;
return 4;
}
unsigned long REGPARAM2 op_4e90_0(uae_u32 opcode) /* JSR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_do_jsr(m68k_getpc() + 2, srca);
}}return 2;
}
unsigned long REGPARAM2 op_4ea8_0(uae_u32 opcode) /* JSR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
	m68k_do_jsr(m68k_getpc() + 4, srca);
}}return 4;
}
unsigned long REGPARAM2 op_4eb0_0(uae_u32 opcode) /* JSR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
	m68k_do_jsr(m68k_getpc() + 0, srca);
}}}return 2;
}
unsigned long REGPARAM2 op_4eb8_0(uae_u32 opcode) /* JSR */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
	m68k_do_jsr(m68k_getpc() + 4, srca);
}}return 4;
}
unsigned long REGPARAM2 op_4eb9_0(uae_u32 opcode) /* JSR */
{
{{	uaecptr srca = get_ilong(2);
	m68k_do_jsr(m68k_getpc() + 6, srca);
}}return 6;
}
unsigned long REGPARAM2 op_4eba_0(uae_u32 opcode) /* JSR */
{
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
	m68k_do_jsr(m68k_getpc() + 4, srca);
}}return 4;
}
unsigned long REGPARAM2 op_4ebb_0(uae_u32 opcode) /* JSR */
{
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
	m68k_do_jsr(m68k_getpc() + 0, srca);
}}}return 2;
}
unsigned long REGPARAM2 op_4ed0_0(uae_u32 opcode) /* JMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_setpc(srca);
}}return 2;
}
unsigned long REGPARAM2 op_4ee8_0(uae_u32 opcode) /* JMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
	m68k_setpc(srca);
}}return 4;
}
unsigned long REGPARAM2 op_4ef0_0(uae_u32 opcode) /* JMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
	m68k_setpc(srca);
}}}return 2;
}
unsigned long REGPARAM2 op_4ef8_0(uae_u32 opcode) /* JMP */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
	m68k_setpc(srca);
}}return 4;
}
unsigned long REGPARAM2 op_4ef9_0(uae_u32 opcode) /* JMP */
{
{{	uaecptr srca = get_ilong(2);
	m68k_setpc(srca);
}}return 6;
}
unsigned long REGPARAM2 op_4efa_0(uae_u32 opcode) /* JMP */
{
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
	m68k_setpc(srca);
}}return 4;
}
unsigned long REGPARAM2 op_4efb_0(uae_u32 opcode) /* JMP */
{
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
	m68k_setpc(srca);
}}}return 2;
}
#endif

#ifdef PART_5
unsigned long REGPARAM2 op_5000_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5010_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_5018_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_5020_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_5028_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_5030_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_5038_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_5039_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = get_ilong(2);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_5040_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5048_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5050_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_5058_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_5060_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_5068_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_5070_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_5078_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_5079_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = get_ilong(2);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_5080_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5088_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5090_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_5098_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_50a0_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_50a8_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_50b0_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}}return 10;
}
unsigned long REGPARAM2 op_50b8_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_50b9_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = get_ilong(2);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_50c0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(0) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_50c8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(0)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel954;
		}
	}
}}}m68k_incpc(4);
endlabel954: ;
return 4;
}
unsigned long REGPARAM2 op_50d0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(0) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_50d8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(0) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_50e0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(0) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_50e8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(0) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_50f0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(0) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_50f8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(0) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_50f9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(0) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_50fa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(0)) { Exception(7,m68k_getpc()); goto endlabel962; }
}}m68k_incpc(4);
endlabel962: ;
return 4;
}
unsigned long REGPARAM2 op_50fb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(0)) { Exception(7,m68k_getpc()); goto endlabel963; }
}}m68k_incpc(6);
endlabel963: ;
return 6;
}
unsigned long REGPARAM2 op_50fc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(0)) { Exception(7,m68k_getpc()); goto endlabel964; }
}m68k_incpc(2);
endlabel964: ;
return 2;
}
unsigned long REGPARAM2 op_5100_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5110_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_5118_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_5120_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_5128_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_5130_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_5138_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_5139_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = get_ilong(2);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_5140_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5148_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5150_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_5158_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_5160_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_5168_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_5170_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_5178_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_5179_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = get_ilong(2);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_5180_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5188_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5190_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_5198_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_51a0_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_51a8_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_51b0_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 src = srcreg;
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}}return 10;
}
unsigned long REGPARAM2 op_51b8_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_51b9_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
{{	uae_u32 src = srcreg;
{	uaecptr dsta = get_ilong(2);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_51c0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(1) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_51c8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(1)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel992;
		}
	}
}}}m68k_incpc(4);
endlabel992: ;
return 4;
}
unsigned long REGPARAM2 op_51d0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(1) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_51d8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(1) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_51e0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(1) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_51e8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(1) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_51f0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(1) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_51f8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(1) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_51f9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(1) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_51fa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(1)) { Exception(7,m68k_getpc()); goto endlabel1000; }
}}m68k_incpc(4);
endlabel1000: ;
return 4;
}
unsigned long REGPARAM2 op_51fb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(1)) { Exception(7,m68k_getpc()); goto endlabel1001; }
}}m68k_incpc(6);
endlabel1001: ;
return 6;
}
unsigned long REGPARAM2 op_51fc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(1)) { Exception(7,m68k_getpc()); goto endlabel1002; }
}m68k_incpc(2);
endlabel1002: ;
return 2;
}
unsigned long REGPARAM2 op_52c0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(2) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_52c8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(2)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel1004;
		}
	}
}}}m68k_incpc(4);
endlabel1004: ;
return 4;
}
unsigned long REGPARAM2 op_52d0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(2) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_52d8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(2) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_52e0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(2) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_52e8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(2) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_52f0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(2) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_52f8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(2) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_52f9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(2) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_52fa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(2)) { Exception(7,m68k_getpc()); goto endlabel1012; }
}}m68k_incpc(4);
endlabel1012: ;
return 4;
}
unsigned long REGPARAM2 op_52fb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(2)) { Exception(7,m68k_getpc()); goto endlabel1013; }
}}m68k_incpc(6);
endlabel1013: ;
return 6;
}
unsigned long REGPARAM2 op_52fc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(2)) { Exception(7,m68k_getpc()); goto endlabel1014; }
}m68k_incpc(2);
endlabel1014: ;
return 2;
}
unsigned long REGPARAM2 op_53c0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(3) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_53c8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(3)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel1016;
		}
	}
}}}m68k_incpc(4);
endlabel1016: ;
return 4;
}
unsigned long REGPARAM2 op_53d0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(3) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_53d8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(3) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_53e0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(3) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_53e8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(3) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_53f0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(3) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_53f8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(3) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_53f9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(3) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_53fa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(3)) { Exception(7,m68k_getpc()); goto endlabel1024; }
}}m68k_incpc(4);
endlabel1024: ;
return 4;
}
unsigned long REGPARAM2 op_53fb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(3)) { Exception(7,m68k_getpc()); goto endlabel1025; }
}}m68k_incpc(6);
endlabel1025: ;
return 6;
}
unsigned long REGPARAM2 op_53fc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(3)) { Exception(7,m68k_getpc()); goto endlabel1026; }
}m68k_incpc(2);
endlabel1026: ;
return 2;
}
unsigned long REGPARAM2 op_54c0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(4) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_54c8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(4)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel1028;
		}
	}
}}}m68k_incpc(4);
endlabel1028: ;
return 4;
}
unsigned long REGPARAM2 op_54d0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(4) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_54d8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(4) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_54e0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(4) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_54e8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(4) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_54f0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(4) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_54f8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(4) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_54f9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(4) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_54fa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(4)) { Exception(7,m68k_getpc()); goto endlabel1036; }
}}m68k_incpc(4);
endlabel1036: ;
return 4;
}
unsigned long REGPARAM2 op_54fb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(4)) { Exception(7,m68k_getpc()); goto endlabel1037; }
}}m68k_incpc(6);
endlabel1037: ;
return 6;
}
unsigned long REGPARAM2 op_54fc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(4)) { Exception(7,m68k_getpc()); goto endlabel1038; }
}m68k_incpc(2);
endlabel1038: ;
return 2;
}
unsigned long REGPARAM2 op_55c0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(5) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_55c8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(5)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel1040;
		}
	}
}}}m68k_incpc(4);
endlabel1040: ;
return 4;
}
unsigned long REGPARAM2 op_55d0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(5) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_55d8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(5) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_55e0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(5) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_55e8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(5) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_55f0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(5) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_55f8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(5) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_55f9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(5) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_55fa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(5)) { Exception(7,m68k_getpc()); goto endlabel1048; }
}}m68k_incpc(4);
endlabel1048: ;
return 4;
}
unsigned long REGPARAM2 op_55fb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(5)) { Exception(7,m68k_getpc()); goto endlabel1049; }
}}m68k_incpc(6);
endlabel1049: ;
return 6;
}
unsigned long REGPARAM2 op_55fc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(5)) { Exception(7,m68k_getpc()); goto endlabel1050; }
}m68k_incpc(2);
endlabel1050: ;
return 2;
}
unsigned long REGPARAM2 op_56c0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(6) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_56c8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(6)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel1052;
		}
	}
}}}m68k_incpc(4);
endlabel1052: ;
return 4;
}
unsigned long REGPARAM2 op_56d0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(6) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_56d8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(6) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_56e0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(6) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_56e8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(6) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_56f0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(6) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_56f8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(6) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_56f9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(6) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_56fa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(6)) { Exception(7,m68k_getpc()); goto endlabel1060; }
}}m68k_incpc(4);
endlabel1060: ;
return 4;
}
unsigned long REGPARAM2 op_56fb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(6)) { Exception(7,m68k_getpc()); goto endlabel1061; }
}}m68k_incpc(6);
endlabel1061: ;
return 6;
}
unsigned long REGPARAM2 op_56fc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(6)) { Exception(7,m68k_getpc()); goto endlabel1062; }
}m68k_incpc(2);
endlabel1062: ;
return 2;
}
unsigned long REGPARAM2 op_57c0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(7) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_57c8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(7)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel1064;
		}
	}
}}}m68k_incpc(4);
endlabel1064: ;
return 4;
}
unsigned long REGPARAM2 op_57d0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(7) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_57d8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(7) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_57e0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(7) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_57e8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(7) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_57f0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(7) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_57f8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(7) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_57f9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(7) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_57fa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(7)) { Exception(7,m68k_getpc()); goto endlabel1072; }
}}m68k_incpc(4);
endlabel1072: ;
return 4;
}
unsigned long REGPARAM2 op_57fb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(7)) { Exception(7,m68k_getpc()); goto endlabel1073; }
}}m68k_incpc(6);
endlabel1073: ;
return 6;
}
unsigned long REGPARAM2 op_57fc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(7)) { Exception(7,m68k_getpc()); goto endlabel1074; }
}m68k_incpc(2);
endlabel1074: ;
return 2;
}
unsigned long REGPARAM2 op_58c0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(8) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_58c8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(8)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel1076;
		}
	}
}}}m68k_incpc(4);
endlabel1076: ;
return 4;
}
unsigned long REGPARAM2 op_58d0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(8) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_58d8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(8) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_58e0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(8) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_58e8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(8) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_58f0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(8) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_58f8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(8) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_58f9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(8) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_58fa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(8)) { Exception(7,m68k_getpc()); goto endlabel1084; }
}}m68k_incpc(4);
endlabel1084: ;
return 4;
}
unsigned long REGPARAM2 op_58fb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(8)) { Exception(7,m68k_getpc()); goto endlabel1085; }
}}m68k_incpc(6);
endlabel1085: ;
return 6;
}
unsigned long REGPARAM2 op_58fc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(8)) { Exception(7,m68k_getpc()); goto endlabel1086; }
}m68k_incpc(2);
endlabel1086: ;
return 2;
}
unsigned long REGPARAM2 op_59c0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(9) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_59c8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(9)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel1088;
		}
	}
}}}m68k_incpc(4);
endlabel1088: ;
return 4;
}
unsigned long REGPARAM2 op_59d0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(9) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_59d8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(9) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_59e0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(9) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_59e8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(9) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_59f0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(9) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_59f8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(9) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_59f9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(9) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_59fa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(9)) { Exception(7,m68k_getpc()); goto endlabel1096; }
}}m68k_incpc(4);
endlabel1096: ;
return 4;
}
unsigned long REGPARAM2 op_59fb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(9)) { Exception(7,m68k_getpc()); goto endlabel1097; }
}}m68k_incpc(6);
endlabel1097: ;
return 6;
}
unsigned long REGPARAM2 op_59fc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(9)) { Exception(7,m68k_getpc()); goto endlabel1098; }
}m68k_incpc(2);
endlabel1098: ;
return 2;
}
unsigned long REGPARAM2 op_5ac0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(10) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5ac8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(10)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel1100;
		}
	}
}}}m68k_incpc(4);
endlabel1100: ;
return 4;
}
unsigned long REGPARAM2 op_5ad0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(10) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5ad8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(10) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5ae0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(10) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5ae8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(10) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_5af0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(10) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_5af8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(10) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_5af9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(10) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_5afa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(10)) { Exception(7,m68k_getpc()); goto endlabel1108; }
}}m68k_incpc(4);
endlabel1108: ;
return 4;
}
unsigned long REGPARAM2 op_5afb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(10)) { Exception(7,m68k_getpc()); goto endlabel1109; }
}}m68k_incpc(6);
endlabel1109: ;
return 6;
}
unsigned long REGPARAM2 op_5afc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(10)) { Exception(7,m68k_getpc()); goto endlabel1110; }
}m68k_incpc(2);
endlabel1110: ;
return 2;
}
unsigned long REGPARAM2 op_5bc0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(11) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5bc8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(11)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel1112;
		}
	}
}}}m68k_incpc(4);
endlabel1112: ;
return 4;
}
unsigned long REGPARAM2 op_5bd0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(11) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5bd8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(11) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5be0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(11) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5be8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(11) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_5bf0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(11) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_5bf8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(11) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_5bf9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(11) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_5bfa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(11)) { Exception(7,m68k_getpc()); goto endlabel1120; }
}}m68k_incpc(4);
endlabel1120: ;
return 4;
}
unsigned long REGPARAM2 op_5bfb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(11)) { Exception(7,m68k_getpc()); goto endlabel1121; }
}}m68k_incpc(6);
endlabel1121: ;
return 6;
}
unsigned long REGPARAM2 op_5bfc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(11)) { Exception(7,m68k_getpc()); goto endlabel1122; }
}m68k_incpc(2);
endlabel1122: ;
return 2;
}
unsigned long REGPARAM2 op_5cc0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(12) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5cc8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(12)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel1124;
		}
	}
}}}m68k_incpc(4);
endlabel1124: ;
return 4;
}
unsigned long REGPARAM2 op_5cd0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(12) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5cd8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(12) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5ce0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(12) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5ce8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(12) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_5cf0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(12) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_5cf8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(12) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_5cf9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(12) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_5cfa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(12)) { Exception(7,m68k_getpc()); goto endlabel1132; }
}}m68k_incpc(4);
endlabel1132: ;
return 4;
}
unsigned long REGPARAM2 op_5cfb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(12)) { Exception(7,m68k_getpc()); goto endlabel1133; }
}}m68k_incpc(6);
endlabel1133: ;
return 6;
}
unsigned long REGPARAM2 op_5cfc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(12)) { Exception(7,m68k_getpc()); goto endlabel1134; }
}m68k_incpc(2);
endlabel1134: ;
return 2;
}
unsigned long REGPARAM2 op_5dc0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(13) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5dc8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(13)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel1136;
		}
	}
}}}m68k_incpc(4);
endlabel1136: ;
return 4;
}
unsigned long REGPARAM2 op_5dd0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(13) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5dd8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(13) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5de0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(13) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5de8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(13) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_5df0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(13) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_5df8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(13) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_5df9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(13) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_5dfa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(13)) { Exception(7,m68k_getpc()); goto endlabel1144; }
}}m68k_incpc(4);
endlabel1144: ;
return 4;
}
unsigned long REGPARAM2 op_5dfb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(13)) { Exception(7,m68k_getpc()); goto endlabel1145; }
}}m68k_incpc(6);
endlabel1145: ;
return 6;
}
unsigned long REGPARAM2 op_5dfc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(13)) { Exception(7,m68k_getpc()); goto endlabel1146; }
}m68k_incpc(2);
endlabel1146: ;
return 2;
}
unsigned long REGPARAM2 op_5ec0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(14) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5ec8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(14)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel1148;
		}
	}
}}}m68k_incpc(4);
endlabel1148: ;
return 4;
}
unsigned long REGPARAM2 op_5ed0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(14) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5ed8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(14) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5ee0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(14) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5ee8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(14) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_5ef0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(14) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_5ef8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(14) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_5ef9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(14) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_5efa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(14)) { Exception(7,m68k_getpc()); goto endlabel1156; }
}}m68k_incpc(4);
endlabel1156: ;
return 4;
}
unsigned long REGPARAM2 op_5efb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(14)) { Exception(7,m68k_getpc()); goto endlabel1157; }
}}m68k_incpc(6);
endlabel1157: ;
return 6;
}
#endif

#ifdef PART_6
unsigned long REGPARAM2 op_5efc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(14)) { Exception(7,m68k_getpc()); goto endlabel1158; }
}m68k_incpc(2);
endlabel1158: ;
return 2;
}
unsigned long REGPARAM2 op_5fc0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{{	int val = cctrue(15) ? 0xff : 0;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_5fc8_0(uae_u32 opcode) /* DBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 offs = get_iword(2);
	if (!cctrue(15)) {
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src-1)) & 0xffff);
		if (src) {
			m68k_incpc((uae_s32)offs + 2);
		goto endlabel1160;
		}
	}
}}}m68k_incpc(4);
endlabel1160: ;
return 4;
}
unsigned long REGPARAM2 op_5fd0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	int val = cctrue(15) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5fd8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	int val = cctrue(15) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5fe0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	int val = cctrue(15) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_5fe8_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(15) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_5ff0_0(uae_u32 opcode) /* Scc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	int val = cctrue(15) ? 0xff : 0;
	put_byte(srca,val);
}}}}return 4;
}
unsigned long REGPARAM2 op_5ff8_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	int val = cctrue(15) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_5ff9_0(uae_u32 opcode) /* Scc */
{
{{	uaecptr srca = get_ilong(2);
{	int val = cctrue(15) ? 0xff : 0;
	put_byte(srca,val);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_5ffa_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s16 dummy = get_iword(2);
	if (cctrue(15)) { Exception(7,m68k_getpc()); goto endlabel1168; }
}}m68k_incpc(4);
endlabel1168: ;
return 4;
}
unsigned long REGPARAM2 op_5ffb_0(uae_u32 opcode) /* TRAPcc */
{
{{	uae_s32 dummy = get_ilong(2);
	if (cctrue(15)) { Exception(7,m68k_getpc()); goto endlabel1169; }
}}m68k_incpc(6);
endlabel1169: ;
return 6;
}
unsigned long REGPARAM2 op_5ffc_0(uae_u32 opcode) /* TRAPcc */
{
{	if (cctrue(15)) { Exception(7,m68k_getpc()); goto endlabel1170; }
}m68k_incpc(2);
endlabel1170: ;
return 2;
}
unsigned long REGPARAM2 op_6000_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s16 src = get_iword(2);
	if (!cctrue(0)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1171;
didnt_jump:;
}}m68k_incpc(4);
endlabel1171: ;
return 4;
}
unsigned long REGPARAM2 op_6001_0(uae_u32 opcode) /* Bcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	if (!cctrue(0)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1172;
didnt_jump:;
}}m68k_incpc(2);
endlabel1172: ;
return 2;
}
unsigned long REGPARAM2 op_60ff_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s32 src = get_ilong(2);
	if (!cctrue(0)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1173;
didnt_jump:;
}}m68k_incpc(6);
endlabel1173: ;
return 6;
}
unsigned long REGPARAM2 op_6100_0(uae_u32 opcode) /* BSR */
{
{{	uae_s16 src = get_iword(2);
	uae_s32 s = (uae_s32)src + 2;
	m68k_do_bsr(m68k_getpc() + 4, s);
}}return 4;
}
unsigned long REGPARAM2 op_6101_0(uae_u32 opcode) /* BSR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	uae_s32 s = (uae_s32)src + 2;
	m68k_do_bsr(m68k_getpc() + 2, s);
}}return 2;
}
unsigned long REGPARAM2 op_61ff_0(uae_u32 opcode) /* BSR */
{
{{	uae_s32 src = get_ilong(2);
	uae_s32 s = (uae_s32)src + 2;
	m68k_do_bsr(m68k_getpc() + 6, s);
}}return 6;
}
unsigned long REGPARAM2 op_6200_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s16 src = get_iword(2);
	if (!cctrue(2)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1177;
didnt_jump:;
}}m68k_incpc(4);
endlabel1177: ;
return 4;
}
unsigned long REGPARAM2 op_6201_0(uae_u32 opcode) /* Bcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	if (!cctrue(2)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1178;
didnt_jump:;
}}m68k_incpc(2);
endlabel1178: ;
return 2;
}
unsigned long REGPARAM2 op_62ff_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s32 src = get_ilong(2);
	if (!cctrue(2)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1179;
didnt_jump:;
}}m68k_incpc(6);
endlabel1179: ;
return 6;
}
unsigned long REGPARAM2 op_6300_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s16 src = get_iword(2);
	if (!cctrue(3)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1180;
didnt_jump:;
}}m68k_incpc(4);
endlabel1180: ;
return 4;
}
unsigned long REGPARAM2 op_6301_0(uae_u32 opcode) /* Bcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	if (!cctrue(3)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1181;
didnt_jump:;
}}m68k_incpc(2);
endlabel1181: ;
return 2;
}
unsigned long REGPARAM2 op_63ff_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s32 src = get_ilong(2);
	if (!cctrue(3)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1182;
didnt_jump:;
}}m68k_incpc(6);
endlabel1182: ;
return 6;
}
unsigned long REGPARAM2 op_6400_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s16 src = get_iword(2);
	if (!cctrue(4)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1183;
didnt_jump:;
}}m68k_incpc(4);
endlabel1183: ;
return 4;
}
unsigned long REGPARAM2 op_6401_0(uae_u32 opcode) /* Bcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	if (!cctrue(4)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1184;
didnt_jump:;
}}m68k_incpc(2);
endlabel1184: ;
return 2;
}
unsigned long REGPARAM2 op_64ff_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s32 src = get_ilong(2);
	if (!cctrue(4)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1185;
didnt_jump:;
}}m68k_incpc(6);
endlabel1185: ;
return 6;
}
unsigned long REGPARAM2 op_6500_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s16 src = get_iword(2);
	if (!cctrue(5)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1186;
didnt_jump:;
}}m68k_incpc(4);
endlabel1186: ;
return 4;
}
unsigned long REGPARAM2 op_6501_0(uae_u32 opcode) /* Bcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	if (!cctrue(5)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1187;
didnt_jump:;
}}m68k_incpc(2);
endlabel1187: ;
return 2;
}
unsigned long REGPARAM2 op_65ff_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s32 src = get_ilong(2);
	if (!cctrue(5)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1188;
didnt_jump:;
}}m68k_incpc(6);
endlabel1188: ;
return 6;
}
unsigned long REGPARAM2 op_6600_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s16 src = get_iword(2);
	if (!cctrue(6)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1189;
didnt_jump:;
}}m68k_incpc(4);
endlabel1189: ;
return 4;
}
unsigned long REGPARAM2 op_6601_0(uae_u32 opcode) /* Bcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	if (!cctrue(6)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1190;
didnt_jump:;
}}m68k_incpc(2);
endlabel1190: ;
return 2;
}
unsigned long REGPARAM2 op_66ff_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s32 src = get_ilong(2);
	if (!cctrue(6)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1191;
didnt_jump:;
}}m68k_incpc(6);
endlabel1191: ;
return 6;
}
unsigned long REGPARAM2 op_6700_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s16 src = get_iword(2);
	if (!cctrue(7)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1192;
didnt_jump:;
}}m68k_incpc(4);
endlabel1192: ;
return 4;
}
unsigned long REGPARAM2 op_6701_0(uae_u32 opcode) /* Bcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	if (!cctrue(7)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1193;
didnt_jump:;
}}m68k_incpc(2);
endlabel1193: ;
return 2;
}
unsigned long REGPARAM2 op_67ff_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s32 src = get_ilong(2);
	if (!cctrue(7)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1194;
didnt_jump:;
}}m68k_incpc(6);
endlabel1194: ;
return 6;
}
unsigned long REGPARAM2 op_6800_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s16 src = get_iword(2);
	if (!cctrue(8)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1195;
didnt_jump:;
}}m68k_incpc(4);
endlabel1195: ;
return 4;
}
unsigned long REGPARAM2 op_6801_0(uae_u32 opcode) /* Bcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	if (!cctrue(8)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1196;
didnt_jump:;
}}m68k_incpc(2);
endlabel1196: ;
return 2;
}
unsigned long REGPARAM2 op_68ff_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s32 src = get_ilong(2);
	if (!cctrue(8)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1197;
didnt_jump:;
}}m68k_incpc(6);
endlabel1197: ;
return 6;
}
unsigned long REGPARAM2 op_6900_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s16 src = get_iword(2);
	if (!cctrue(9)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1198;
didnt_jump:;
}}m68k_incpc(4);
endlabel1198: ;
return 4;
}
unsigned long REGPARAM2 op_6901_0(uae_u32 opcode) /* Bcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	if (!cctrue(9)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1199;
didnt_jump:;
}}m68k_incpc(2);
endlabel1199: ;
return 2;
}
unsigned long REGPARAM2 op_69ff_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s32 src = get_ilong(2);
	if (!cctrue(9)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1200;
didnt_jump:;
}}m68k_incpc(6);
endlabel1200: ;
return 6;
}
unsigned long REGPARAM2 op_6a00_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s16 src = get_iword(2);
	if (!cctrue(10)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1201;
didnt_jump:;
}}m68k_incpc(4);
endlabel1201: ;
return 4;
}
unsigned long REGPARAM2 op_6a01_0(uae_u32 opcode) /* Bcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	if (!cctrue(10)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1202;
didnt_jump:;
}}m68k_incpc(2);
endlabel1202: ;
return 2;
}
unsigned long REGPARAM2 op_6aff_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s32 src = get_ilong(2);
	if (!cctrue(10)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1203;
didnt_jump:;
}}m68k_incpc(6);
endlabel1203: ;
return 6;
}
unsigned long REGPARAM2 op_6b00_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s16 src = get_iword(2);
	if (!cctrue(11)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1204;
didnt_jump:;
}}m68k_incpc(4);
endlabel1204: ;
return 4;
}
unsigned long REGPARAM2 op_6b01_0(uae_u32 opcode) /* Bcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	if (!cctrue(11)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1205;
didnt_jump:;
}}m68k_incpc(2);
endlabel1205: ;
return 2;
}
unsigned long REGPARAM2 op_6bff_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s32 src = get_ilong(2);
	if (!cctrue(11)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1206;
didnt_jump:;
}}m68k_incpc(6);
endlabel1206: ;
return 6;
}
unsigned long REGPARAM2 op_6c00_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s16 src = get_iword(2);
	if (!cctrue(12)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1207;
didnt_jump:;
}}m68k_incpc(4);
endlabel1207: ;
return 4;
}
unsigned long REGPARAM2 op_6c01_0(uae_u32 opcode) /* Bcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	if (!cctrue(12)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1208;
didnt_jump:;
}}m68k_incpc(2);
endlabel1208: ;
return 2;
}
unsigned long REGPARAM2 op_6cff_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s32 src = get_ilong(2);
	if (!cctrue(12)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1209;
didnt_jump:;
}}m68k_incpc(6);
endlabel1209: ;
return 6;
}
unsigned long REGPARAM2 op_6d00_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s16 src = get_iword(2);
	if (!cctrue(13)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1210;
didnt_jump:;
}}m68k_incpc(4);
endlabel1210: ;
return 4;
}
unsigned long REGPARAM2 op_6d01_0(uae_u32 opcode) /* Bcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	if (!cctrue(13)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1211;
didnt_jump:;
}}m68k_incpc(2);
endlabel1211: ;
return 2;
}
unsigned long REGPARAM2 op_6dff_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s32 src = get_ilong(2);
	if (!cctrue(13)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1212;
didnt_jump:;
}}m68k_incpc(6);
endlabel1212: ;
return 6;
}
unsigned long REGPARAM2 op_6e00_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s16 src = get_iword(2);
	if (!cctrue(14)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1213;
didnt_jump:;
}}m68k_incpc(4);
endlabel1213: ;
return 4;
}
unsigned long REGPARAM2 op_6e01_0(uae_u32 opcode) /* Bcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	if (!cctrue(14)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1214;
didnt_jump:;
}}m68k_incpc(2);
endlabel1214: ;
return 2;
}
unsigned long REGPARAM2 op_6eff_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s32 src = get_ilong(2);
	if (!cctrue(14)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1215;
didnt_jump:;
}}m68k_incpc(6);
endlabel1215: ;
return 6;
}
unsigned long REGPARAM2 op_6f00_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s16 src = get_iword(2);
	if (!cctrue(15)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1216;
didnt_jump:;
}}m68k_incpc(4);
endlabel1216: ;
return 4;
}
unsigned long REGPARAM2 op_6f01_0(uae_u32 opcode) /* Bcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
{{	uae_u32 src = srcreg;
	if (!cctrue(15)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1217;
didnt_jump:;
}}m68k_incpc(2);
endlabel1217: ;
return 2;
}
unsigned long REGPARAM2 op_6fff_0(uae_u32 opcode) /* Bcc */
{
{{	uae_s32 src = get_ilong(2);
	if (!cctrue(15)) goto didnt_jump;
	m68k_incpc ((uae_s32)src + 2);
	goto endlabel1218;
didnt_jump:;
}}m68k_incpc(6);
endlabel1218: ;
return 6;
}
unsigned long REGPARAM2 op_7000_0(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = (uae_s32)(uae_s8)((opcode >> 8) & 255);
#else
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_u32 src = srcreg;
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_8000_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_8010_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_8018_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_8020_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_8028_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_8030_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return 4;
}
unsigned long REGPARAM2 op_8038_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_8039_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_803a_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_803b_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return 4;
}
unsigned long REGPARAM2 op_803c_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_8040_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_8050_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_8058_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_8060_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_8068_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_8070_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return 4;
}
unsigned long REGPARAM2 op_8078_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_8079_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_807a_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_807b_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return 4;
}
unsigned long REGPARAM2 op_807c_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_8080_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_8090_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_8098_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_80a0_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_80a8_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_80b0_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_80b8_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_80b9_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_80ba_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_80bb_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_80bc_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_80c0_0(uae_u32 opcode) /* DIVU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1253; } else {
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}m68k_incpc(2);
endlabel1253: ;
return 70;
}
unsigned long REGPARAM2 op_80d0_0(uae_u32 opcode) /* DIVU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1254; } else {
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}m68k_incpc(2);
endlabel1254: ;
return 72;
}
unsigned long REGPARAM2 op_80d8_0(uae_u32 opcode) /* DIVU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1255; } else {
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}m68k_incpc(2);
endlabel1255: ;
return 72;
}
unsigned long REGPARAM2 op_80e0_0(uae_u32 opcode) /* DIVU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1256; } else {
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}m68k_incpc(2);
endlabel1256: ;
return 72;
}
unsigned long REGPARAM2 op_80e8_0(uae_u32 opcode) /* DIVU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1257; } else {
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}m68k_incpc(4);
endlabel1257: ;
return 74;
}
unsigned long REGPARAM2 op_80f0_0(uae_u32 opcode) /* DIVU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1258; } else {
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}}endlabel1258: ;
return 72;
}
unsigned long REGPARAM2 op_80f8_0(uae_u32 opcode) /* DIVU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1259; } else {
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}m68k_incpc(4);
endlabel1259: ;
return 74;
}
unsigned long REGPARAM2 op_80f9_0(uae_u32 opcode) /* DIVU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1260; } else {
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}m68k_incpc(6);
endlabel1260: ;
return 76;
}
unsigned long REGPARAM2 op_80fa_0(uae_u32 opcode) /* DIVU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1261; } else {
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}m68k_incpc(4);
endlabel1261: ;
return 74;
}
unsigned long REGPARAM2 op_80fb_0(uae_u32 opcode) /* DIVU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1262; } else {
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}}endlabel1262: ;
return 72;
}
unsigned long REGPARAM2 op_80fc_0(uae_u32 opcode) /* DIVU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 src = get_iword(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1263; } else {
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}m68k_incpc(4);
endlabel1263: ;
return 72;
}
unsigned long REGPARAM2 op_8100_0(uae_u32 opcode) /* SBCD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo-=6; newv_hi-=0x10; }
	newv = newv_hi + (newv_lo & 0xF);	SET_CFLG (cflg = (newv_hi & 0x1F0) > 0x90);
	COPY_CARRY;
	if (cflg) newv -= 0x60;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_8108_0(uae_u32 opcode) /* SBCD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo-=6; newv_hi-=0x10; }
	newv = newv_hi + (newv_lo & 0xF);	SET_CFLG (cflg = (newv_hi & 0x1F0) > 0x90);
	COPY_CARRY;
	if (cflg) newv -= 0x60;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long REGPARAM2 op_8110_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_8118_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_8120_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_8128_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_8130_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_8138_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_8139_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s8 dst = get_byte(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_8140_0(uae_u32 opcode) /* PACK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uae_u16 val = m68k_dreg(regs, srcreg) + get_iword(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & 0xffffff00) | ((val >> 4) & 0xf0) | (val & 0xf);
}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_8148_0(uae_u32 opcode) /* PACK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uae_u16 val;
	m68k_areg(regs, srcreg) -= areg_byteinc[srcreg];
	val = (uae_u16)get_byte(m68k_areg(regs, srcreg));
	m68k_areg(regs, srcreg) -= areg_byteinc[srcreg];
	val = (val | ((uae_u16)get_byte(m68k_areg(regs, srcreg)) << 8)) + get_iword(2);
	m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
	put_byte(m68k_areg(regs, dstreg),((val >> 4) & 0xf0) | (val & 0xf));
}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_8150_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_8158_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_8160_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_8168_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 dst = get_word(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_8170_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s16 dst = get_word(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_8178_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 dst = get_word(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_8179_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s16 dst = get_word(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_8180_0(uae_u32 opcode) /* UNPK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uae_u16 val = m68k_dreg(regs, srcreg);
	val = (((val << 4) & 0xf00) | (val & 0xf)) + get_iword(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & 0xffff0000) | (val & 0xffff);
}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_8188_0(uae_u32 opcode) /* UNPK */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uae_u16 val;
	m68k_areg(regs, srcreg) -= areg_byteinc[srcreg];
	val = (uae_u16)get_byte(m68k_areg(regs, srcreg));
	val = (((val << 4) & 0xf00) | (val & 0xf)) + get_iword(2);
	m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
	put_byte(m68k_areg(regs, dstreg),val);
	m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
	put_byte(m68k_areg(regs, dstreg),val >> 8);
}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_8190_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_8198_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_81a0_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_81a8_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_81b0_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 10;
}
unsigned long REGPARAM2 op_81b8_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_81b9_0(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s32 dst = get_long(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_81c0_0(uae_u32 opcode) /* DIVS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1291; } else {
	uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
	uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}m68k_incpc(2);
endlabel1291: ;
return 74;
}
unsigned long REGPARAM2 op_81d0_0(uae_u32 opcode) /* DIVS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1292; } else {
	uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
	uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}m68k_incpc(2);
endlabel1292: ;
return 76;
}
unsigned long REGPARAM2 op_81d8_0(uae_u32 opcode) /* DIVS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1293; } else {
	uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
	uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}m68k_incpc(2);
endlabel1293: ;
return 76;
}
unsigned long REGPARAM2 op_81e0_0(uae_u32 opcode) /* DIVS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1294; } else {
	uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
	uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}m68k_incpc(2);
endlabel1294: ;
return 76;
}
unsigned long REGPARAM2 op_81e8_0(uae_u32 opcode) /* DIVS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1295; } else {
	uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
	uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}m68k_incpc(4);
endlabel1295: ;
return 78;
}
unsigned long REGPARAM2 op_81f0_0(uae_u32 opcode) /* DIVS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1296; } else {
	uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
	uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}}endlabel1296: ;
return 76;
}
unsigned long REGPARAM2 op_81f8_0(uae_u32 opcode) /* DIVS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1297; } else {
	uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
	uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}m68k_incpc(4);
endlabel1297: ;
return 78;
}
unsigned long REGPARAM2 op_81f9_0(uae_u32 opcode) /* DIVS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1298; } else {
	uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
	uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}m68k_incpc(6);
endlabel1298: ;
return 80;
}
unsigned long REGPARAM2 op_81fa_0(uae_u32 opcode) /* DIVS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1299; } else {
	uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
	uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}m68k_incpc(4);
endlabel1299: ;
return 78;
}
unsigned long REGPARAM2 op_81fb_0(uae_u32 opcode) /* DIVS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1300; } else {
	uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
	uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}}}endlabel1300: ;
return 76;
}
unsigned long REGPARAM2 op_81fc_0(uae_u32 opcode) /* DIVS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 src = get_iword(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	if(src == 0) { Exception(5,oldpc); goto endlabel1301; } else {
	uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
	uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
	if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) { SET_VFLG (1); SET_NFLG (1); SET_CFLG (0); } else
	{
	if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
	newv = (newv & 0xffff) | ((uae_u32)rem << 16);
	m68k_dreg(regs, dstreg) = (newv);
	}
	}
}}}m68k_incpc(4);
endlabel1301: ;
return 76;
}
unsigned long REGPARAM2 op_9000_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_9010_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_9018_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_9020_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_9028_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_9030_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}}return 4;
}
unsigned long REGPARAM2 op_9038_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_9039_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_903a_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_903b_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}}return 4;
}
unsigned long REGPARAM2 op_903c_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_9040_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_9048_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_9050_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_9058_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_9060_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_9068_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_9070_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}return 4;
}
unsigned long REGPARAM2 op_9078_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_9079_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_907a_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_907b_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}return 4;
}
unsigned long REGPARAM2 op_907c_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_9080_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_9088_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_9090_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_9098_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_90a0_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_90a8_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_90b0_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_90b8_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_90b9_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_90ba_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_90bb_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_90bc_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_90c0_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_90c8_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_90d0_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_90d8_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_90e0_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_90e8_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_90f0_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}}return 4;
}
unsigned long REGPARAM2 op_90f8_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_90f9_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_90fa_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_90fb_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}}return 4;
}
unsigned long REGPARAM2 op_90fc_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_9100_0(uae_u32 opcode) /* SUBX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = dst - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_9108_0(uae_u32 opcode) /* SUBX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u32 newv = dst - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long REGPARAM2 op_9110_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_9118_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_9120_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_9128_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_9130_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_9138_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_9139_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_9140_0(uae_u32 opcode) /* SUBX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = dst - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_9148_0(uae_u32 opcode) /* SUBX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u32 newv = dst - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long REGPARAM2 op_9150_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_9158_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_9160_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_9168_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_9170_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_9178_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_9179_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_9180_0(uae_u32 opcode) /* SUBX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = dst - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_9188_0(uae_u32 opcode) /* SUBX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u32 newv = dst - src - (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long REGPARAM2 op_9190_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_9198_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_91a0_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_91a8_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_91b0_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}}return 10;
}
unsigned long REGPARAM2 op_91b8_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_91b9_0(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_91c0_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_91c8_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_91d0_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_91d8_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_91e0_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_91e8_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_91f0_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}}return 6;
}
unsigned long REGPARAM2 op_91f8_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_91f9_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_91fa_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_91fb_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}}return 6;
}
unsigned long REGPARAM2 op_91fc_0(uae_u32 opcode) /* SUBA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_b000_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_b010_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 4;
}
#endif

#ifdef PART_7
unsigned long REGPARAM2 op_b018_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_b020_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_b028_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_b030_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 4;
}
unsigned long REGPARAM2 op_b038_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_b039_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_b03a_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_b03b_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 4;
}
unsigned long REGPARAM2 op_b03c_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_b040_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_b048_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_b050_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_b058_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_b060_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_b068_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_b070_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 4;
}
unsigned long REGPARAM2 op_b078_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_b079_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_b07a_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_b07b_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 4;
}
unsigned long REGPARAM2 op_b07c_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_b080_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_b088_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_b090_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_b098_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_b0a0_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_b0a8_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_b0b0_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_b0b8_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_b0b9_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_b0ba_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_b0bb_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_b0bc_0(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_b0c0_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_b0c8_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_b0d0_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_b0d8_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_b0e0_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_b0e8_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_b0f0_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 4;
}
unsigned long REGPARAM2 op_b0f8_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_b0f9_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_b0fa_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_b0fb_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 4;
}
unsigned long REGPARAM2 op_b0fc_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_b100_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_b108_0(uae_u32 opcode) /* CMPM */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_b110_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_b118_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_b120_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_b128_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_b130_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_b138_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_b139_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s8 dst = get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_b140_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_b148_0(uae_u32 opcode) /* CMPM */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_b150_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_b158_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_b160_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_b168_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 dst = get_word(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_b170_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s16 dst = get_word(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_b178_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 dst = get_word(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_b179_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s16 dst = get_word(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_b180_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_b188_0(uae_u32 opcode) /* CMPM */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_b190_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_b198_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_b1a0_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_b1a8_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_b1b0_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 10;
}
unsigned long REGPARAM2 op_b1b8_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_b1b9_0(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s32 dst = get_long(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_b1c0_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_b1c8_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_b1d0_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_b1d8_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_b1e0_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_b1e8_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_b1f0_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_b1f8_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_b1f9_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_b1fa_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_b1fb_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_b1fc_0(uae_u32 opcode) /* CMPA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_c000_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_c010_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_c018_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_c020_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_c028_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_c030_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return 4;
}
unsigned long REGPARAM2 op_c038_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_c039_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_c03a_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_c03b_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return 4;
}
unsigned long REGPARAM2 op_c03c_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_c040_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_c050_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_c058_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_c060_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_c068_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_c070_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return 4;
}
unsigned long REGPARAM2 op_c078_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_c079_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_c07a_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_c07b_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return 4;
}
unsigned long REGPARAM2 op_c07c_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_c080_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_c090_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_c098_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_c0a0_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_c0a8_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_c0b0_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_c0b8_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_c0b9_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_c0ba_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_c0bb_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_c0bc_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_c0c0_0(uae_u32 opcode) /* MULU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 34;
}
unsigned long REGPARAM2 op_c0d0_0(uae_u32 opcode) /* MULU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 36;
}
unsigned long REGPARAM2 op_c0d8_0(uae_u32 opcode) /* MULU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 36;
}
unsigned long REGPARAM2 op_c0e0_0(uae_u32 opcode) /* MULU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 36;
}
unsigned long REGPARAM2 op_c0e8_0(uae_u32 opcode) /* MULU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 38;
}
unsigned long REGPARAM2 op_c0f0_0(uae_u32 opcode) /* MULU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}return 36;
}
unsigned long REGPARAM2 op_c0f8_0(uae_u32 opcode) /* MULU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 38;
}
unsigned long REGPARAM2 op_c0f9_0(uae_u32 opcode) /* MULU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(6);
return 40;
}
unsigned long REGPARAM2 op_c0fa_0(uae_u32 opcode) /* MULU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 38;
}
unsigned long REGPARAM2 op_c0fb_0(uae_u32 opcode) /* MULU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}return 36;
}
unsigned long REGPARAM2 op_c0fc_0(uae_u32 opcode) /* MULU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}m68k_incpc(4);
return 36;
}
unsigned long REGPARAM2 op_c100_0(uae_u32 opcode) /* ABCD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG ? 1 : 0);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo +=6; }
	newv = newv_hi + newv_lo;	SET_CFLG (cflg = (newv & 0x1F0) > 0x90);
	COPY_CARRY;
	if (cflg) newv += 0x60;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_c108_0(uae_u32 opcode) /* ABCD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG ? 1 : 0);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv;
	int cflg;
	if (newv_lo > 9) { newv_lo +=6; }
	newv = newv_hi + newv_lo;	SET_CFLG (cflg = (newv & 0x1F0) > 0x90);
	COPY_CARRY;
	if (cflg) newv += 0x60;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long REGPARAM2 op_c110_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_c118_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_c120_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_c128_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_c130_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_c138_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_c139_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s8 dst = get_byte(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_c140_0(uae_u32 opcode) /* EXG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_dreg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_c148_0(uae_u32 opcode) /* EXG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{	uae_s32 dst = m68k_areg(regs, dstreg);
	m68k_areg(regs, srcreg) = (dst);
	m68k_areg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_c150_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_c158_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_c160_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_c168_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 dst = get_word(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_c170_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s16 dst = get_word(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}}return 6;
}
unsigned long REGPARAM2 op_c178_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 dst = get_word(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_c179_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s16 dst = get_word(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_c188_0(uae_u32 opcode) /* EXG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_areg(regs, dstreg);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_areg(regs, dstreg) = (src);
}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_c190_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_c198_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_c1a0_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_c1a8_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_c1b0_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}}return 10;
}
unsigned long REGPARAM2 op_c1b8_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_c1b9_0(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s32 dst = get_long(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_c1c0_0(uae_u32 opcode) /* MULS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 34;
}
unsigned long REGPARAM2 op_c1d0_0(uae_u32 opcode) /* MULS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 36;
}
unsigned long REGPARAM2 op_c1d8_0(uae_u32 opcode) /* MULS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 36;
}
unsigned long REGPARAM2 op_c1e0_0(uae_u32 opcode) /* MULS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 36;
}
unsigned long REGPARAM2 op_c1e8_0(uae_u32 opcode) /* MULS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 38;
}
unsigned long REGPARAM2 op_c1f0_0(uae_u32 opcode) /* MULS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}return 36;
}
unsigned long REGPARAM2 op_c1f8_0(uae_u32 opcode) /* MULS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 38;
}
unsigned long REGPARAM2 op_c1f9_0(uae_u32 opcode) /* MULS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(6);
return 40;
}
unsigned long REGPARAM2 op_c1fa_0(uae_u32 opcode) /* MULS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 38;
}
unsigned long REGPARAM2 op_c1fb_0(uae_u32 opcode) /* MULS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}return 36;
}
unsigned long REGPARAM2 op_c1fc_0(uae_u32 opcode) /* MULS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}m68k_incpc(4);
return 36;
}
unsigned long REGPARAM2 op_d000_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_d010_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_d018_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_d020_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_d028_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_d030_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}}return 4;
}
unsigned long REGPARAM2 op_d038_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_d039_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_d03a_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_d03b_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s8 src = get_byte(srca);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}}return 4;
}
unsigned long REGPARAM2 op_d03c_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_d040_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_d048_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_d050_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_d058_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_d060_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_d068_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_d070_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}return 4;
}
unsigned long REGPARAM2 op_d078_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_d079_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_d07a_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_d07b_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}return 4;
}
unsigned long REGPARAM2 op_d07c_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_d080_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_d088_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_d090_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_d098_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_d0a0_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_d0a8_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_d0b0_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_d0b8_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_d0b9_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_d0ba_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_d0bb_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_d0bc_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_d0c0_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_d0c8_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_areg(regs, srcreg);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_d0d0_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_d0d8_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s16 src = get_word(srca);
	m68k_areg(regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_d0e0_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 4;
}
unsigned long REGPARAM2 op_d0e8_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_d0f0_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}}return 4;
}
unsigned long REGPARAM2 op_d0f8_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_d0f9_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_d0fa_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_d0fb_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s16 src = get_word(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}}return 4;
}
unsigned long REGPARAM2 op_d0fc_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_d100_0(uae_u32 opcode) /* ADDX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uae_s8 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = dst + src + (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_d108_0(uae_u32 opcode) /* ADDX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u32 newv = dst + src + (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long REGPARAM2 op_d110_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_d118_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s8 dst = get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_d120_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_d128_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_d130_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_d138_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_d139_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_d140_0(uae_u32 opcode) /* ADDX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uae_s16 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = dst + src + (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_d148_0(uae_u32 opcode) /* ADDX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 2;
{	uae_s16 src = get_word(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u32 newv = dst + src + (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(2);
return 8;
}
unsigned long REGPARAM2 op_d150_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_d158_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s16 dst = get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_d160_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 2;
{	uae_s16 dst = get_word(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_d168_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_d170_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}}return 6;
}
unsigned long REGPARAM2 op_d178_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_d179_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s16 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_d180_0(uae_u32 opcode) /* ADDX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_dreg(regs, dstreg);
{	uae_u32 newv = dst + src + (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 2;
}
#endif

#ifdef PART_8
unsigned long REGPARAM2 op_d188_0(uae_u32 opcode) /* ADDX */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
{	uae_u32 newv = dst + src + (GET_XFLG ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY;
	SET_ZFLG (GET_ZFLG & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(2);
return 14;
}
unsigned long REGPARAM2 op_d190_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_d198_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 dst = get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_d1a0_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) - 4;
{	uae_s32 dst = get_long(dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(2);
return 10;
}
unsigned long REGPARAM2 op_d1a8_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_d1b0_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{m68k_incpc(2);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}}return 10;
}
unsigned long REGPARAM2 op_d1b8_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(4);
return 12;
}
unsigned long REGPARAM2 op_d1b9_0(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_ilong(2);
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(6);
return 14;
}
unsigned long REGPARAM2 op_d1c0_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_dreg(regs, srcreg);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_d1c8_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = m68k_areg(regs, srcreg);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_d1d0_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_d1d8_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s32 src = get_long(srca);
	m68k_areg(regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_d1e0_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - 4;
{	uae_s32 src = get_long(srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_d1e8_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_d1f0_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr srca = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}}return 6;
}
unsigned long REGPARAM2 op_d1f8_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_d1f9_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_d1fa_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_d1fb_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{m68k_incpc(2);
{	uaecptr tmppc = m68k_getpc();
	uaecptr srca = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 src = get_long(srca);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}}}return 6;
}
unsigned long REGPARAM2 op_d1fc_0(uae_u32 opcode) /* ADDA */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uae_s32 dst = m68k_areg(regs, dstreg);
{	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_e000_0(uae_u32 opcode) /* ASR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	uae_u32 sign = (0x80 & val) >> 7;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 8) {
		val = 0xff & (uae_u32)-sign;
		SET_CFLG (sign);
	COPY_CARRY;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
		val |= (0xff << (8 - cnt)) & (uae_u32)-sign;
		val &= 0xff;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e008_0(uae_u32 opcode) /* LSR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 8) {
		SET_CFLG ((cnt == 8) & (val >> 7));
	COPY_CARRY;
		val = 0;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e010_0(uae_u32 opcode) /* ROXR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	cnt &= 63;
	CLEAR_CZNV;
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG;
	hival <<= (7 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e018_0(uae_u32 opcode) /* ROR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	cnt &= 63;
	CLEAR_CZNV;
{	uae_u32 hival;
	cnt &= 7;
	hival = val << (8 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xff;
	SET_CFLG ((val & 0x80) >> 7);
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e020_0(uae_u32 opcode) /* ASR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 cnt = m68k_dreg(regs, srcreg);
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	uae_u32 sign = (0x80 & val) >> 7;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 8) {
		val = 0xff & (uae_u32)-sign;
		SET_CFLG (sign);
	COPY_CARRY;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
		val |= (0xff << (8 - cnt)) & (uae_u32)-sign;
		val &= 0xff;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e028_0(uae_u32 opcode) /* LSR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 cnt = m68k_dreg(regs, srcreg);
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 8) {
		SET_CFLG ((cnt == 8) & (val >> 7));
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e030_0(uae_u32 opcode) /* ROXR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 cnt = m68k_dreg(regs, srcreg);
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 36) cnt -= 36;
	if (cnt >= 18) cnt -= 18;
	if (cnt >= 9) cnt -= 9;
	if (cnt > 0) {
	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG;
	hival <<= (7 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e038_0(uae_u32 opcode) /* ROR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 cnt = m68k_dreg(regs, srcreg);
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt > 0) {	uae_u32 hival;
	cnt &= 7;
	hival = val << (8 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xff;
	SET_CFLG ((val & 0x80) >> 7);
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e040_0(uae_u32 opcode) /* ASR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = (0x8000 & val) >> 15;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 16) {
		val = 0xffff & (uae_u32)-sign;
		SET_CFLG (sign);
	COPY_CARRY;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
		val |= (0xffff << (16 - cnt)) & (uae_u32)-sign;
		val &= 0xffff;
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e048_0(uae_u32 opcode) /* LSR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 16) {
		SET_CFLG ((cnt == 16) & (val >> 15));
	COPY_CARRY;
		val = 0;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e050_0(uae_u32 opcode) /* ROXR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	cnt &= 63;
	CLEAR_CZNV;
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG;
	hival <<= (15 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e058_0(uae_u32 opcode) /* ROR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	cnt &= 63;
	CLEAR_CZNV;
{	uae_u32 hival;
	cnt &= 15;
	hival = val << (16 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffff;
	SET_CFLG ((val & 0x8000) >> 15);
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e060_0(uae_u32 opcode) /* ASR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 cnt = m68k_dreg(regs, srcreg);
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = (0x8000 & val) >> 15;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 16) {
		val = 0xffff & (uae_u32)-sign;
		SET_CFLG (sign);
	COPY_CARRY;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
		val |= (0xffff << (16 - cnt)) & (uae_u32)-sign;
		val &= 0xffff;
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e068_0(uae_u32 opcode) /* LSR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 cnt = m68k_dreg(regs, srcreg);
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 16) {
		SET_CFLG ((cnt == 16) & (val >> 15));
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e070_0(uae_u32 opcode) /* ROXR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 cnt = m68k_dreg(regs, srcreg);
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 34) cnt -= 34;
	if (cnt >= 17) cnt -= 17;
	if (cnt > 0) {
	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG;
	hival <<= (15 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e078_0(uae_u32 opcode) /* ROR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 cnt = m68k_dreg(regs, srcreg);
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt > 0) {	uae_u32 hival;
	cnt &= 15;
	hival = val << (16 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffff;
	SET_CFLG ((val & 0x8000) >> 15);
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e080_0(uae_u32 opcode) /* ASR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	uae_u32 sign = (0x80000000 & val) >> 31;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 32) {
		val = 0xffffffff & (uae_u32)-sign;
		SET_CFLG (sign);
	COPY_CARRY;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
		val |= (0xffffffff << (32 - cnt)) & (uae_u32)-sign;
		val &= 0xffffffff;
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e088_0(uae_u32 opcode) /* LSR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 32) {
		SET_CFLG ((cnt == 32) & (val >> 31));
	COPY_CARRY;
		val = 0;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e090_0(uae_u32 opcode) /* ROXR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	cnt &= 63;
	CLEAR_CZNV;
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG;
	hival <<= (31 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xffffffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e098_0(uae_u32 opcode) /* ROR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	cnt &= 63;
	CLEAR_CZNV;
{	uae_u32 hival;
	cnt &= 31;
	hival = val << (32 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffffffff;
	SET_CFLG ((val & 0x80000000) >> 31);
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e0a0_0(uae_u32 opcode) /* ASR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 cnt = m68k_dreg(regs, srcreg);
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	uae_u32 sign = (0x80000000 & val) >> 31;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 32) {
		val = 0xffffffff & (uae_u32)-sign;
		SET_CFLG (sign);
	COPY_CARRY;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
		val |= (0xffffffff << (32 - cnt)) & (uae_u32)-sign;
		val &= 0xffffffff;
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e0a8_0(uae_u32 opcode) /* LSR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 cnt = m68k_dreg(regs, srcreg);
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 32) {
		SET_CFLG ((cnt == 32) & (val >> 31));
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
	COPY_CARRY;
		val >>= 1;
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e0b0_0(uae_u32 opcode) /* ROXR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 cnt = m68k_dreg(regs, srcreg);
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 33) cnt -= 33;
	if (cnt > 0) {
	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG;
	hival <<= (31 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xffffffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e0b8_0(uae_u32 opcode) /* ROR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 cnt = m68k_dreg(regs, srcreg);
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt > 0) {	uae_u32 hival;
	cnt &= 31;
	hival = val << (32 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xffffffff;
	SET_CFLG ((val & 0x80000000) >> 31);
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e0d0_0(uae_u32 opcode) /* ASRW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e0d8_0(uae_u32 opcode) /* ASRW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e0e0_0(uae_u32 opcode) /* ASRW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) - 2;
{	uae_s16 data = get_word(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e0e8_0(uae_u32 opcode) /* ASRW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e0f0_0(uae_u32 opcode) /* ASRW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr dataa = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 data = get_word(dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY;
	put_word(dataa,val);
}}}}}return 6;
}
unsigned long REGPARAM2 op_e0f8_0(uae_u32 opcode) /* ASRW */
{
{{	uaecptr dataa = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e0f9_0(uae_u32 opcode) /* ASRW */
{
{{	uaecptr dataa = get_ilong(2);
{	uae_s16 data = get_word(dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 cflg = val & 1;
	val = (val >> 1) | sign;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	SET_CFLG (cflg);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_e100_0(uae_u32 opcode) /* ASL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 8) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 8 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else {
		uae_u32 mask = (0xff << (7 - cnt)) & 0xff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x80) >> 7);
	COPY_CARRY;
		val <<= 1;
		val &= 0xff;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e108_0(uae_u32 opcode) /* LSL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 8) {
		SET_CFLG (cnt == 8 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else {
		val <<= (cnt - 1);
		SET_CFLG ((val & 0x80) >> 7);
	COPY_CARRY;
		val <<= 1;
	val &= 0xff;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e110_0(uae_u32 opcode) /* ROXL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	cnt &= 63;
	CLEAR_CZNV;
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 loval = val >> (7 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG) << cnt) | (loval >> 1);
	SET_XFLG (carry);
	val &= 0xff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e118_0(uae_u32 opcode) /* ROL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	cnt &= 63;
	CLEAR_CZNV;
{	uae_u32 loval;
	cnt &= 7;
	loval = val >> (8 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xff;
	SET_CFLG (val & 1);
}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e120_0(uae_u32 opcode) /* ASL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 cnt = m68k_dreg(regs, srcreg);
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 8) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 8 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		uae_u32 mask = (0xff << (7 - cnt)) & 0xff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x80) >> 7);
	COPY_CARRY;
		val <<= 1;
		val &= 0xff;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e128_0(uae_u32 opcode) /* LSL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 cnt = m68k_dreg(regs, srcreg);
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 8) {
		SET_CFLG (cnt == 8 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		val <<= (cnt - 1);
		SET_CFLG ((val & 0x80) >> 7);
	COPY_CARRY;
		val <<= 1;
	val &= 0xff;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e130_0(uae_u32 opcode) /* ROXL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 cnt = m68k_dreg(regs, srcreg);
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 36) cnt -= 36;
	if (cnt >= 18) cnt -= 18;
	if (cnt >= 9) cnt -= 9;
	if (cnt > 0) {
	cnt--;
	{
	uae_u32 carry;
	uae_u32 loval = val >> (7 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG) << cnt) | (loval >> 1);
	SET_XFLG (carry);
	val &= 0xff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e138_0(uae_u32 opcode) /* ROL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 cnt = m68k_dreg(regs, srcreg);
{	uae_s8 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u8)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt > 0) {
	uae_u32 loval;
	cnt &= 7;
	loval = val >> (8 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xff;
	SET_CFLG (val & 1);
}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e140_0(uae_u32 opcode) /* ASL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 16) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 16 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else {
		uae_u32 mask = (0xffff << (15 - cnt)) & 0xffff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x8000) >> 15);
	COPY_CARRY;
		val <<= 1;
		val &= 0xffff;
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e148_0(uae_u32 opcode) /* LSL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 16) {
		SET_CFLG (cnt == 16 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else {
		val <<= (cnt - 1);
		SET_CFLG ((val & 0x8000) >> 15);
	COPY_CARRY;
		val <<= 1;
	val &= 0xffff;
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e150_0(uae_u32 opcode) /* ROXL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	cnt &= 63;
	CLEAR_CZNV;
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 loval = val >> (15 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG) << cnt) | (loval >> 1);
	SET_XFLG (carry);
	val &= 0xffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e158_0(uae_u32 opcode) /* ROL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	cnt &= 63;
	CLEAR_CZNV;
{	uae_u32 loval;
	cnt &= 15;
	loval = val >> (16 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xffff;
	SET_CFLG (val & 1);
}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e160_0(uae_u32 opcode) /* ASL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 cnt = m68k_dreg(regs, srcreg);
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 16) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 16 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		uae_u32 mask = (0xffff << (15 - cnt)) & 0xffff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x8000) >> 15);
	COPY_CARRY;
		val <<= 1;
		val &= 0xffff;
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e168_0(uae_u32 opcode) /* LSL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 cnt = m68k_dreg(regs, srcreg);
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 16) {
		SET_CFLG (cnt == 16 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		val <<= (cnt - 1);
		SET_CFLG ((val & 0x8000) >> 15);
	COPY_CARRY;
		val <<= 1;
	val &= 0xffff;
	}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e170_0(uae_u32 opcode) /* ROXL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 cnt = m68k_dreg(regs, srcreg);
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 34) cnt -= 34;
	if (cnt >= 17) cnt -= 17;
	if (cnt > 0) {
	cnt--;
	{
	uae_u32 carry;
	uae_u32 loval = val >> (15 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG) << cnt) | (loval >> 1);
	SET_XFLG (carry);
	val &= 0xffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e178_0(uae_u32 opcode) /* ROL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 cnt = m68k_dreg(regs, srcreg);
{	uae_s16 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = (uae_u16)data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt > 0) {
	uae_u32 loval;
	cnt &= 15;
	loval = val >> (16 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xffff;
	SET_CFLG (val & 1);
}
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e180_0(uae_u32 opcode) /* ASL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 32) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 32 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else {
		uae_u32 mask = (0xffffffff << (31 - cnt)) & 0xffffffff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x80000000) >> 31);
	COPY_CARRY;
		val <<= 1;
		val &= 0xffffffff;
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e188_0(uae_u32 opcode) /* LSL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 32) {
		SET_CFLG (cnt == 32 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else {
		val <<= (cnt - 1);
		SET_CFLG ((val & 0x80000000) >> 31);
	COPY_CARRY;
		val <<= 1;
	val &= 0xffffffff;
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e190_0(uae_u32 opcode) /* ROXL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	cnt &= 63;
	CLEAR_CZNV;
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 loval = val >> (31 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG) << cnt) | (loval >> 1);
	SET_XFLG (carry);
	val &= 0xffffffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e198_0(uae_u32 opcode) /* ROL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = imm8_table[((opcode >> 1) & 7)];
#else
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_u32 cnt = srcreg;
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	cnt &= 63;
	CLEAR_CZNV;
{	uae_u32 loval;
	cnt &= 31;
	loval = val >> (32 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xffffffff;
	SET_CFLG (val & 1);
}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e1a0_0(uae_u32 opcode) /* ASL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 cnt = m68k_dreg(regs, srcreg);
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 32) {
		SET_VFLG (val != 0);
		SET_CFLG (cnt == 32 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		uae_u32 mask = (0xffffffff << (31 - cnt)) & 0xffffffff;
		SET_VFLG ((val & mask) != mask && (val & mask) != 0);
		val <<= cnt - 1;
		SET_CFLG ((val & 0x80000000) >> 31);
	COPY_CARRY;
		val <<= 1;
		val &= 0xffffffff;
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e1a8_0(uae_u32 opcode) /* LSL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 cnt = m68k_dreg(regs, srcreg);
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 32) {
		SET_CFLG (cnt == 32 ? val & 1 : 0);
	COPY_CARRY;
		val = 0;
	} else if (cnt > 0) {
		val <<= (cnt - 1);
		SET_CFLG ((val & 0x80000000) >> 31);
	COPY_CARRY;
		val <<= 1;
	val &= 0xffffffff;
	}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e1b0_0(uae_u32 opcode) /* ROXL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 cnt = m68k_dreg(regs, srcreg);
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt >= 33) cnt -= 33;
	if (cnt > 0) {
	cnt--;
	{
	uae_u32 carry;
	uae_u32 loval = val >> (31 - cnt);
	carry = loval & 1;
	val = (((val << 1) | GET_XFLG) << cnt) | (loval >> 1);
	SET_XFLG (carry);
	val &= 0xffffffff;
	} }
	SET_CFLG (GET_XFLG);
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e1b8_0(uae_u32 opcode) /* ROL */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 cnt = m68k_dreg(regs, srcreg);
{	uae_s32 data = m68k_dreg(regs, dstreg);
{	uae_u32 val = data;
	cnt &= 63;
	CLEAR_CZNV;
	if (cnt > 0) {
	uae_u32 loval;
	cnt &= 31;
	loval = val >> (32 - cnt);
	val <<= cnt;
	val |= loval;
	val &= 0xffffffff;
	SET_CFLG (val & 1);
}
	SET_ZFLG (((uae_s32)(val)) == 0);
	SET_NFLG (((uae_s32)(val)) < 0);
	m68k_dreg(regs, dstreg) = (val);
}}}}m68k_incpc(2);
return 2;
}
unsigned long REGPARAM2 op_e1d0_0(uae_u32 opcode) /* ASLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 sign2;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	sign2 = 0x8000 & val;
	SET_CFLG (sign != 0);
	COPY_CARRY;
	SET_VFLG (GET_VFLG | (sign2 != sign));
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e1d8_0(uae_u32 opcode) /* ASLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 sign2;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	sign2 = 0x8000 & val;
	SET_CFLG (sign != 0);
	COPY_CARRY;
	SET_VFLG (GET_VFLG | (sign2 != sign));
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e1e0_0(uae_u32 opcode) /* ASLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) - 2;
{	uae_s16 data = get_word(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 sign2;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	sign2 = 0x8000 & val;
	SET_CFLG (sign != 0);
	COPY_CARRY;
	SET_VFLG (GET_VFLG | (sign2 != sign));
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e1e8_0(uae_u32 opcode) /* ASLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 sign2;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	sign2 = 0x8000 & val;
	SET_CFLG (sign != 0);
	COPY_CARRY;
	SET_VFLG (GET_VFLG | (sign2 != sign));
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e1f0_0(uae_u32 opcode) /* ASLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr dataa = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 data = get_word(dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 sign2;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	sign2 = 0x8000 & val;
	SET_CFLG (sign != 0);
	COPY_CARRY;
	SET_VFLG (GET_VFLG | (sign2 != sign));
	put_word(dataa,val);
}}}}}return 6;
}
unsigned long REGPARAM2 op_e1f8_0(uae_u32 opcode) /* ASLW */
{
{{	uaecptr dataa = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 sign2;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	sign2 = 0x8000 & val;
	SET_CFLG (sign != 0);
	COPY_CARRY;
	SET_VFLG (GET_VFLG | (sign2 != sign));
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e1f9_0(uae_u32 opcode) /* ASLW */
{
{{	uaecptr dataa = get_ilong(2);
{	uae_s16 data = get_word(dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 sign = 0x8000 & val;
	uae_u32 sign2;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
	sign2 = 0x8000 & val;
	SET_CFLG (sign != 0);
	COPY_CARRY;
	SET_VFLG (GET_VFLG | (sign2 != sign));
	put_word(dataa,val);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_e2d0_0(uae_u32 opcode) /* LSRW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 carry = val & 1;
	val >>= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e2d8_0(uae_u32 opcode) /* LSRW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uae_u32 val = (uae_u16)data;
	uae_u32 carry = val & 1;
	val >>= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e2e0_0(uae_u32 opcode) /* LSRW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) - 2;
{	uae_s16 data = get_word(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uae_u32 val = (uae_u16)data;
	uae_u32 carry = val & 1;
	val >>= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e2e8_0(uae_u32 opcode) /* LSRW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 carry = val & 1;
	val >>= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e2f0_0(uae_u32 opcode) /* LSRW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr dataa = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 data = get_word(dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 carry = val & 1;
	val >>= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	put_word(dataa,val);
}}}}}return 6;
}
unsigned long REGPARAM2 op_e2f8_0(uae_u32 opcode) /* LSRW */
{
{{	uaecptr dataa = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 carry = val & 1;
	val >>= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e2f9_0(uae_u32 opcode) /* LSRW */
{
{{	uaecptr dataa = get_ilong(2);
{	uae_s16 data = get_word(dataa);
{	uae_u32 val = (uae_u16)data;
	uae_u32 carry = val & 1;
	val >>= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_e3d0_0(uae_u32 opcode) /* LSLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e3d8_0(uae_u32 opcode) /* LSLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e3e0_0(uae_u32 opcode) /* LSLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) - 2;
{	uae_s16 data = get_word(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e3e8_0(uae_u32 opcode) /* LSLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e3f0_0(uae_u32 opcode) /* LSLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr dataa = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	put_word(dataa,val);
}}}}}return 6;
}
unsigned long REGPARAM2 op_e3f8_0(uae_u32 opcode) /* LSLW */
{
{{	uaecptr dataa = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e3f9_0(uae_u32 opcode) /* LSLW */
{
{{	uaecptr dataa = get_ilong(2);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_e4d0_0(uae_u32 opcode) /* ROXRW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 1;
	val >>= 1;
	if (GET_XFLG) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e4d8_0(uae_u32 opcode) /* ROXRW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uae_u16 val = data;
	uae_u32 carry = val & 1;
	val >>= 1;
	if (GET_XFLG) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e4e0_0(uae_u32 opcode) /* ROXRW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) - 2;
{	uae_s16 data = get_word(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uae_u16 val = data;
	uae_u32 carry = val & 1;
	val >>= 1;
	if (GET_XFLG) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e4e8_0(uae_u32 opcode) /* ROXRW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 1;
	val >>= 1;
	if (GET_XFLG) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e4f0_0(uae_u32 opcode) /* ROXRW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr dataa = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 1;
	val >>= 1;
	if (GET_XFLG) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	put_word(dataa,val);
}}}}}return 6;
}
unsigned long REGPARAM2 op_e4f8_0(uae_u32 opcode) /* ROXRW */
{
{{	uaecptr dataa = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 1;
	val >>= 1;
	if (GET_XFLG) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e4f9_0(uae_u32 opcode) /* ROXRW */
{
{{	uaecptr dataa = get_ilong(2);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 1;
	val >>= 1;
	if (GET_XFLG) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_e5d0_0(uae_u32 opcode) /* ROXLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	if (GET_XFLG) val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e5d8_0(uae_u32 opcode) /* ROXLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	if (GET_XFLG) val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e5e0_0(uae_u32 opcode) /* ROXLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) - 2;
{	uae_s16 data = get_word(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	if (GET_XFLG) val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e5e8_0(uae_u32 opcode) /* ROXLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	if (GET_XFLG) val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e5f0_0(uae_u32 opcode) /* ROXLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr dataa = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	if (GET_XFLG) val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	put_word(dataa,val);
}}}}}return 6;
}
unsigned long REGPARAM2 op_e5f8_0(uae_u32 opcode) /* ROXLW */
{
{{	uaecptr dataa = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	if (GET_XFLG) val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e5f9_0(uae_u32 opcode) /* ROXLW */
{
{{	uaecptr dataa = get_ilong(2);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	if (GET_XFLG) val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	COPY_CARRY;
	put_word(dataa,val);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_e6d0_0(uae_u32 opcode) /* RORW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 1;
	val >>= 1;
	if (carry) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e6d8_0(uae_u32 opcode) /* RORW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uae_u16 val = data;
	uae_u32 carry = val & 1;
	val >>= 1;
	if (carry) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e6e0_0(uae_u32 opcode) /* RORW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) - 2;
{	uae_s16 data = get_word(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uae_u16 val = data;
	uae_u32 carry = val & 1;
	val >>= 1;
	if (carry) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e6e8_0(uae_u32 opcode) /* RORW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 1;
	val >>= 1;
	if (carry) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e6f0_0(uae_u32 opcode) /* RORW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr dataa = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 1;
	val >>= 1;
	if (carry) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	put_word(dataa,val);
}}}}}return 6;
}
unsigned long REGPARAM2 op_e6f8_0(uae_u32 opcode) /* RORW */
{
{{	uaecptr dataa = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 1;
	val >>= 1;
	if (carry) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e6f9_0(uae_u32 opcode) /* RORW */
{
{{	uaecptr dataa = get_ilong(2);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 1;
	val >>= 1;
	if (carry) val |= 0x8000;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry);
	put_word(dataa,val);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_e7d0_0(uae_u32 opcode) /* ROLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	if (carry)  val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e7d8_0(uae_u32 opcode) /* ROLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg);
{	uae_s16 data = get_word(dataa);
	m68k_areg(regs, srcreg) += 2;
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	if (carry)  val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e7e0_0(uae_u32 opcode) /* ROLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) - 2;
{	uae_s16 data = get_word(dataa);
	m68k_areg (regs, srcreg) = dataa;
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	if (carry)  val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	put_word(dataa,val);
}}}}m68k_incpc(2);
return 6;
}
unsigned long REGPARAM2 op_e7e8_0(uae_u32 opcode) /* ROLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr dataa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	if (carry)  val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e7f0_0(uae_u32 opcode) /* ROLW */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{m68k_incpc(2);
{	uaecptr dataa = get_disp_ea_020(m68k_areg(regs, srcreg), next_iword());
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	if (carry)  val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	put_word(dataa,val);
}}}}}return 6;
}
unsigned long REGPARAM2 op_e7f8_0(uae_u32 opcode) /* ROLW */
{
{{	uaecptr dataa = (uae_s32)(uae_s16)get_iword(2);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	if (carry)  val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	put_word(dataa,val);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_e7f9_0(uae_u32 opcode) /* ROLW */
{
{{	uaecptr dataa = get_ilong(2);
{	uae_s16 data = get_word(dataa);
{	uae_u16 val = data;
	uae_u32 carry = val & 0x8000;
	val <<= 1;
	if (carry)  val |= 1;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(val)) == 0);
	SET_NFLG (((uae_s16)(val)) < 0);
SET_CFLG (carry >> 15);
	put_word(dataa,val);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_e8c0_0(uae_u32 opcode) /* BFTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp = m68k_dreg(regs, dstreg) << (offset & 0x1f);
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_e8d0_0(uae_u32 opcode) /* BFTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_e8e8_0(uae_u32 opcode) /* BFTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_e8f0_0(uae_u32 opcode) /* BFTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
}}}}}return 4;
}
unsigned long REGPARAM2 op_e8f8_0(uae_u32 opcode) /* BFTST */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_e8f9_0(uae_u32 opcode) /* BFTST */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
}}}}m68k_incpc(8);
return 8;
}
unsigned long REGPARAM2 op_e8fa_0(uae_u32 opcode) /* BFTST */
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_getpc () + 4;
	dsta += (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_e8fb_0(uae_u32 opcode) /* BFTST */
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
}}}}}return 4;
}
unsigned long REGPARAM2 op_e9c0_0(uae_u32 opcode) /* BFEXTU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp = m68k_dreg(regs, dstreg) << (offset & 0x1f);
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_e9d0_0(uae_u32 opcode) /* BFEXTU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_e9e8_0(uae_u32 opcode) /* BFEXTU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_e9f0_0(uae_u32 opcode) /* BFEXTU */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}}return 4;
}
unsigned long REGPARAM2 op_e9f8_0(uae_u32 opcode) /* BFEXTU */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_e9f9_0(uae_u32 opcode) /* BFEXTU */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}m68k_incpc(8);
return 8;
}
unsigned long REGPARAM2 op_e9fa_0(uae_u32 opcode) /* BFEXTU */
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_getpc () + 4;
	dsta += (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_e9fb_0(uae_u32 opcode) /* BFEXTU */
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}}return 4;
}
unsigned long REGPARAM2 op_eac0_0(uae_u32 opcode) /* BFCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp = m68k_dreg(regs, dstreg) << (offset & 0x1f);
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = ~tmp;
	tmp <<= (32 - width);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ((offset & 0x1f) == 0 ? 0 :
		(0xffffffff << (32 - (offset & 0x1f))))) |
		(tmp >> (offset & 0x1f)) |
		(((offset & 0x1f) + width) >= 32 ? 0 :
 (m68k_dreg(regs, dstreg) & ((uae_u32)0xffffffff >> ((offset & 0x1f) + width))));
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_ead0_0(uae_u32 opcode) /* BFCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = ~tmp;
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_eae8_0(uae_u32 opcode) /* BFCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = ~tmp;
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_eaf0_0(uae_u32 opcode) /* BFCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = ~tmp;
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}}return 4;
}
unsigned long REGPARAM2 op_eaf8_0(uae_u32 opcode) /* BFCHG */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = ~tmp;
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_eaf9_0(uae_u32 opcode) /* BFCHG */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = ~tmp;
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(8);
return 8;
}
unsigned long REGPARAM2 op_ebc0_0(uae_u32 opcode) /* BFEXTS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp = m68k_dreg(regs, dstreg) << (offset & 0x1f);
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	if (GET_NFLG) tmp |= width == 32 ? 0 : (-1 << width);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_ebd0_0(uae_u32 opcode) /* BFEXTS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	if (GET_NFLG) tmp |= width == 32 ? 0 : (-1 << width);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_ebe8_0(uae_u32 opcode) /* BFEXTS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	if (GET_NFLG) tmp |= width == 32 ? 0 : (-1 << width);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_ebf0_0(uae_u32 opcode) /* BFEXTS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	if (GET_NFLG) tmp |= width == 32 ? 0 : (-1 << width);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}}return 4;
}
unsigned long REGPARAM2 op_ebf8_0(uae_u32 opcode) /* BFEXTS */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	if (GET_NFLG) tmp |= width == 32 ? 0 : (-1 << width);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_ebf9_0(uae_u32 opcode) /* BFEXTS */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	if (GET_NFLG) tmp |= width == 32 ? 0 : (-1 << width);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}m68k_incpc(8);
return 8;
}
unsigned long REGPARAM2 op_ebfa_0(uae_u32 opcode) /* BFEXTS */
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_getpc () + 4;
	dsta += (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	if (GET_NFLG) tmp |= width == 32 ? 0 : (-1 << width);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_ebfb_0(uae_u32 opcode) /* BFEXTS */
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	if (GET_NFLG) tmp |= width == 32 ? 0 : (-1 << width);
	m68k_dreg(regs, (extra >> 12) & 7) = tmp;
}}}}}return 4;
}
unsigned long REGPARAM2 op_ecc0_0(uae_u32 opcode) /* BFCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp = m68k_dreg(regs, dstreg) << (offset & 0x1f);
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = 0;
	tmp <<= (32 - width);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ((offset & 0x1f) == 0 ? 0 :
		(0xffffffff << (32 - (offset & 0x1f))))) |
		(tmp >> (offset & 0x1f)) |
		(((offset & 0x1f) + width) >= 32 ? 0 :
 (m68k_dreg(regs, dstreg) & ((uae_u32)0xffffffff >> ((offset & 0x1f) + width))));
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_ecd0_0(uae_u32 opcode) /* BFCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = 0;
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_ece8_0(uae_u32 opcode) /* BFCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = 0;
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_ecf0_0(uae_u32 opcode) /* BFCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = 0;
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}}return 4;
}
unsigned long REGPARAM2 op_ecf8_0(uae_u32 opcode) /* BFCLR */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = 0;
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_ecf9_0(uae_u32 opcode) /* BFCLR */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = 0;
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(8);
return 8;
}
unsigned long REGPARAM2 op_edc0_0(uae_u32 opcode) /* BFFFO */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp = m68k_dreg(regs, dstreg) << (offset & 0x1f);
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	{ uae_u32 mask = 1 << (width-1);
	while (mask) { if (tmp & mask) break; mask >>= 1; offset++; }}
	m68k_dreg(regs, (extra >> 12) & 7) = offset;
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_edd0_0(uae_u32 opcode) /* BFFFO */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	{ uae_u32 mask = 1 << (width-1);
	while (mask) { if (tmp & mask) break; mask >>= 1; offset++; }}
	m68k_dreg(regs, (extra >> 12) & 7) = offset;
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_ede8_0(uae_u32 opcode) /* BFFFO */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	{ uae_u32 mask = 1 << (width-1);
	while (mask) { if (tmp & mask) break; mask >>= 1; offset++; }}
	m68k_dreg(regs, (extra >> 12) & 7) = offset;
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_edf0_0(uae_u32 opcode) /* BFFFO */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	{ uae_u32 mask = 1 << (width-1);
	while (mask) { if (tmp & mask) break; mask >>= 1; offset++; }}
	m68k_dreg(regs, (extra >> 12) & 7) = offset;
}}}}}return 4;
}
unsigned long REGPARAM2 op_edf8_0(uae_u32 opcode) /* BFFFO */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	{ uae_u32 mask = 1 << (width-1);
	while (mask) { if (tmp & mask) break; mask >>= 1; offset++; }}
	m68k_dreg(regs, (extra >> 12) & 7) = offset;
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_edf9_0(uae_u32 opcode) /* BFFFO */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	{ uae_u32 mask = 1 << (width-1);
	while (mask) { if (tmp & mask) break; mask >>= 1; offset++; }}
	m68k_dreg(regs, (extra >> 12) & 7) = offset;
}}}}m68k_incpc(8);
return 8;
}
unsigned long REGPARAM2 op_edfa_0(uae_u32 opcode) /* BFFFO */
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_getpc () + 4;
	dsta += (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	{ uae_u32 mask = 1 << (width-1);
	while (mask) { if (tmp & mask) break; mask >>= 1; offset++; }}
	m68k_dreg(regs, (extra >> 12) & 7) = offset;
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_edfb_0(uae_u32 opcode) /* BFFFO */
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr tmppc = m68k_getpc();
	uaecptr dsta = get_disp_ea_020(tmppc, next_iword());
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	{ uae_u32 mask = 1 << (width-1);
	while (mask) { if (tmp & mask) break; mask >>= 1; offset++; }}
	m68k_dreg(regs, (extra >> 12) & 7) = offset;
}}}}}return 4;
}
unsigned long REGPARAM2 op_eec0_0(uae_u32 opcode) /* BFSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp = m68k_dreg(regs, dstreg) << (offset & 0x1f);
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = 0xffffffff;
	tmp <<= (32 - width);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ((offset & 0x1f) == 0 ? 0 :
		(0xffffffff << (32 - (offset & 0x1f))))) |
		(tmp >> (offset & 0x1f)) |
		(((offset & 0x1f) + width) >= 32 ? 0 :
 (m68k_dreg(regs, dstreg) & ((uae_u32)0xffffffff >> ((offset & 0x1f) + width))));
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_eed0_0(uae_u32 opcode) /* BFSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = 0xffffffff;
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_eee8_0(uae_u32 opcode) /* BFSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = 0xffffffff;
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_eef0_0(uae_u32 opcode) /* BFSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = 0xffffffff;
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}}return 4;
}
unsigned long REGPARAM2 op_eef8_0(uae_u32 opcode) /* BFSET */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = 0xffffffff;
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_eef9_0(uae_u32 opcode) /* BFSET */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = 0xffffffff;
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(8);
return 8;
}
unsigned long REGPARAM2 op_efc0_0(uae_u32 opcode) /* BFINS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp = m68k_dreg(regs, dstreg) << (offset & 0x1f);
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = m68k_dreg(regs, (extra >> 12) & 7);
	tmp <<= (32 - width);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ((offset & 0x1f) == 0 ? 0 :
		(0xffffffff << (32 - (offset & 0x1f))))) |
		(tmp >> (offset & 0x1f)) |
		(((offset & 0x1f) + width) >= 32 ? 0 :
 (m68k_dreg(regs, dstreg) & ((uae_u32)0xffffffff >> ((offset & 0x1f) + width))));
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_efd0_0(uae_u32 opcode) /* BFINS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = m68k_dreg(regs, (extra >> 12) & 7);
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(4);
return 4;
}
unsigned long REGPARAM2 op_efe8_0(uae_u32 opcode) /* BFINS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = m68k_dreg(regs, (extra >> 12) & 7);
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_eff0_0(uae_u32 opcode) /* BFINS */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
{m68k_incpc(4);
{	uaecptr dsta = get_disp_ea_020(m68k_areg(regs, dstreg), next_iword());
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = m68k_dreg(regs, (extra >> 12) & 7);
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}}return 4;
}
unsigned long REGPARAM2 op_eff8_0(uae_u32 opcode) /* BFINS */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = m68k_dreg(regs, (extra >> 12) & 7);
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(6);
return 6;
}
unsigned long REGPARAM2 op_eff9_0(uae_u32 opcode) /* BFINS */
{
{{	uae_s16 extra = get_iword(2);
{	uaecptr dsta = get_ilong(4);
{	uae_s32 offset = extra & 0x800 ? m68k_dreg(regs, (extra >> 6) & 7) : (extra >> 6) & 0x1f;
	int width = (((extra & 0x20 ? m68k_dreg(regs, extra & 7) : extra) -1) & 0x1f) +1;
	uae_u32 tmp,bf0,bf1;
	dsta += (offset >> 3) | (offset & 0x80000000 ? ~0x1fffffff : 0);
	bf0 = get_long(dsta);bf1 = get_byte(dsta+4) & 0xff;
	tmp = (bf0 << (offset & 7)) | (bf1 >> (8 - (offset & 7)));
	tmp >>= (32 - width);
	SET_NFLG (tmp & (1 << (width-1)) ? 1 : 0);
	SET_ZFLG (tmp == 0); SET_VFLG (0); SET_CFLG (0);
	tmp = m68k_dreg(regs, (extra >> 12) & 7);
	tmp <<= (32 - width);
	bf0 = (bf0 & (0xff000000 << (8 - (offset & 7)))) |
		(tmp >> (offset & 7)) |
		(((offset & 7) + width) >= 32 ? 0 :
		 (bf0 & ((uae_u32)0xffffffff >> ((offset & 7) + width))));
	put_long(dsta,bf0 );
	if (((offset & 7) + width) > 32) {
		bf1 = (bf1 & (0xff >> (width - 32 + (offset & 7)))) |
			(tmp << (8 - (offset & 7)));
		put_byte(dsta+4,bf1);
	}
}}}}m68k_incpc(8);
return 8;
}
unsigned long REGPARAM2 op_f200_0(uae_u32 opcode) /* FPP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fpp_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f208_0(uae_u32 opcode) /* FPP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fpp_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f210_0(uae_u32 opcode) /* FPP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fpp_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f218_0(uae_u32 opcode) /* FPP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fpp_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f220_0(uae_u32 opcode) /* FPP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fpp_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f228_0(uae_u32 opcode) /* FPP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fpp_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f230_0(uae_u32 opcode) /* FPP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fpp_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f238_0(uae_u32 opcode) /* FPP */
{
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fpp_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f239_0(uae_u32 opcode) /* FPP */
{
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fpp_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f23a_0(uae_u32 opcode) /* FPP */
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fpp_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f23b_0(uae_u32 opcode) /* FPP */
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fpp_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f23c_0(uae_u32 opcode) /* FPP */
{
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fpp_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f240_0(uae_u32 opcode) /* FScc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fscc_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f248_0(uae_u32 opcode) /* FDBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fdbcc_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f250_0(uae_u32 opcode) /* FScc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fscc_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f258_0(uae_u32 opcode) /* FScc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fscc_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f260_0(uae_u32 opcode) /* FScc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fscc_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f268_0(uae_u32 opcode) /* FScc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fscc_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f270_0(uae_u32 opcode) /* FScc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fscc_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f278_0(uae_u32 opcode) /* FScc */
{
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fscc_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f279_0(uae_u32 opcode) /* FScc */
{
{{	uae_s16 extra = get_iword(2);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fscc_opp(opcode,extra);
}}return 4;
}
unsigned long REGPARAM2 op_f27a_0(uae_u32 opcode) /* FTRAPcc */
{
{m68k_incpc(2);
{	uaecptr oldpc = m68k_getpc();
{	uae_s16 dummy = get_iword(0);
m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	ftrapcc_opp(opcode,oldpc);
}}}return 4;
}
unsigned long REGPARAM2 op_f27b_0(uae_u32 opcode) /* FTRAPcc */
{
{m68k_incpc(2);
{	uaecptr oldpc = m68k_getpc();
{	uae_s32 dummy = get_ilong(0);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	ftrapcc_opp(opcode,oldpc);
}}}return 6;
}
unsigned long REGPARAM2 op_f27c_0(uae_u32 opcode) /* FTRAPcc */
{
{m68k_incpc(2);
{	uaecptr oldpc = m68k_getpc();
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	ftrapcc_opp(opcode,oldpc);
}}return 2;
}
unsigned long REGPARAM2 op_f280_0(uae_u32 opcode) /* FBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 63);
#else
	uae_u32 srcreg = (opcode & 63);
#endif
{m68k_incpc(2);
{	uaecptr pc = m68k_getpc();
{	uae_s16 extra = get_iword(0);
m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fbcc_opp(opcode,pc,extra);
}}}return 4;
}
unsigned long REGPARAM2 op_f2c0_0(uae_u32 opcode) /* FBcc */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 63);
#else
	uae_u32 srcreg = (opcode & 63);
#endif
{m68k_incpc(2);
{	uaecptr pc = m68k_getpc();
{	uae_s32 extra = get_ilong(0);
m68k_incpc(4);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fbcc_opp(opcode,pc,extra);
}}}return 6;
}
unsigned long REGPARAM2 op_f310_0(uae_u32 opcode) /* FSAVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel1827; }
{m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fsave_opp(opcode);
}}endlabel1827: ;
return 2;
}
unsigned long REGPARAM2 op_f320_0(uae_u32 opcode) /* FSAVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel1828; }
{m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fsave_opp(opcode);
}}endlabel1828: ;
return 2;
}
unsigned long REGPARAM2 op_f328_0(uae_u32 opcode) /* FSAVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel1829; }
{m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fsave_opp(opcode);
}}endlabel1829: ;
return 2;
}
unsigned long REGPARAM2 op_f330_0(uae_u32 opcode) /* FSAVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel1830; }
{m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fsave_opp(opcode);
}}endlabel1830: ;
return 2;
}
unsigned long REGPARAM2 op_f338_0(uae_u32 opcode) /* FSAVE */
{
{if (!regs.s) { Exception(8,0); goto endlabel1831; }
{m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fsave_opp(opcode);
}}endlabel1831: ;
return 2;
}
unsigned long REGPARAM2 op_f339_0(uae_u32 opcode) /* FSAVE */
{
{if (!regs.s) { Exception(8,0); goto endlabel1832; }
{m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	fsave_opp(opcode);
}}endlabel1832: ;
return 2;
}
unsigned long REGPARAM2 op_f350_0(uae_u32 opcode) /* FRESTORE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel1833; }
{m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	frestore_opp(opcode);
}}endlabel1833: ;
return 2;
}
unsigned long REGPARAM2 op_f358_0(uae_u32 opcode) /* FRESTORE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel1834; }
{m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	frestore_opp(opcode);
}}endlabel1834: ;
return 2;
}
unsigned long REGPARAM2 op_f368_0(uae_u32 opcode) /* FRESTORE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel1835; }
{m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	frestore_opp(opcode);
}}endlabel1835: ;
return 2;
}
unsigned long REGPARAM2 op_f370_0(uae_u32 opcode) /* FRESTORE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{if (!regs.s) { Exception(8,0); goto endlabel1836; }
{m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	frestore_opp(opcode);
}}endlabel1836: ;
return 2;
}
unsigned long REGPARAM2 op_f378_0(uae_u32 opcode) /* FRESTORE */
{
{if (!regs.s) { Exception(8,0); goto endlabel1837; }
{m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	frestore_opp(opcode);
}}endlabel1837: ;
return 2;
}
unsigned long REGPARAM2 op_f379_0(uae_u32 opcode) /* FRESTORE */
{
{if (!regs.s) { Exception(8,0); goto endlabel1838; }
{m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	frestore_opp(opcode);
}}endlabel1838: ;
return 2;
}
unsigned long REGPARAM2 op_f37a_0(uae_u32 opcode) /* FRESTORE */
{
{if (!regs.s) { Exception(8,0); goto endlabel1839; }
{m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	frestore_opp(opcode);
}}endlabel1839: ;
return 2;
}
unsigned long REGPARAM2 op_f37b_0(uae_u32 opcode) /* FRESTORE */
{
{if (!regs.s) { Exception(8,0); goto endlabel1840; }
{m68k_incpc(2);
#ifdef HAVE_GET_WORD_UNSWAPPED
	opcode = ((opcode << 8) & 0xFF00) | ((opcode >> 8) & 0xFF);
#endif
	frestore_opp(opcode);
}}endlabel1840: ;
return 2;
}
#endif


#if !defined(PART_1) && !defined(PART_2) && !defined(PART_3) && !defined(PART_4) && !defined(PART_5) && !defined(PART_6) && !defined(PART_7) && !defined(PART_8)
#define PART_1 1
#define PART_2 1
#define PART_3 1
#define PART_4 1
#define PART_5 1
#define PART_6 1
#define PART_7 1
#define PART_8 1
#endif

#ifdef PART_1
#endif

#ifdef PART_2
#endif

#ifdef PART_3
#endif

#ifdef PART_4
#endif

#ifdef PART_5
#endif

#ifdef PART_6
#endif

#ifdef PART_7
#endif

#ifdef PART_8
#endif


#if !defined(PART_1) && !defined(PART_2) && !defined(PART_3) && !defined(PART_4) && !defined(PART_5) && !defined(PART_6) && !defined(PART_7) && !defined(PART_8)
#define PART_1 1
#define PART_2 1
#define PART_3 1
#define PART_4 1
#define PART_5 1
#define PART_6 1
#define PART_7 1
#define PART_8 1
#endif

#ifdef PART_1
unsigned long REGPARAM2 op_30_2(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s8 dst = get_byte(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_70_2(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s16 dst = get_word(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_b0_2(uae_u32 opcode) /* OR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
{	uae_s32 dst = get_long(dsta);
	src |= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_130_2(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_13b_2(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr tmppc = m68k_getpc() + 2;
	uaecptr dsta = get_disp_ea_000(tmppc, get_iword(2));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_170_2(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_17b_2(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr tmppc = m68k_getpc() + 2;
	uaecptr dsta = get_disp_ea_000(tmppc, get_iword(2));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1b0_2(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1bb_2(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr tmppc = m68k_getpc() + 2;
	uaecptr dsta = get_disp_ea_000(tmppc, get_iword(2));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1f0_2(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1fb_2(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 1) & 7);
#else
	uae_u32 srcreg = ((opcode >> 9) & 7);
#endif
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr tmppc = m68k_getpc() + 2;
	uaecptr dsta = get_disp_ea_000(tmppc, get_iword(2));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_230_2(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s8 dst = get_byte(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_270_2(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s16 dst = get_word(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_2b0_2(uae_u32 opcode) /* AND */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
{	uae_s32 dst = get_long(dsta);
	src &= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_430_2(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_470_2(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_4b0_2(uae_u32 opcode) /* SUB */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_630_2(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) + ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_byte(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_670_2(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) + ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_word(dsta,newv);
}}}}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_6b0_2(uae_u32 opcode) /* ADD */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) + ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY;
	SET_NFLG (flgn != 0);
	put_long(dsta,newv);
}}}}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_830_2(uae_u32 opcode) /* BTST */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_83b_2(uae_u32 opcode) /* BTST */
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_iword(2);
{	uaecptr tmppc = m68k_getpc() + 4;
	uaecptr dsta = get_disp_ea_000(tmppc, get_iword(4));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_870_2(uae_u32 opcode) /* BCHG */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_87b_2(uae_u32 opcode) /* BCHG */
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_iword(2);
{	uaecptr tmppc = m68k_getpc() + 4;
	uaecptr dsta = get_disp_ea_000(tmppc, get_iword(4));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG ((dst & (1 << src)) >> src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_8b0_2(uae_u32 opcode) /* BCLR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_8bb_2(uae_u32 opcode) /* BCLR */
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_iword(2);
{	uaecptr tmppc = m68k_getpc() + 4;
	uaecptr dsta = get_disp_ea_000(tmppc, get_iword(4));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_8f0_2(uae_u32 opcode) /* BSET */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_8fb_2(uae_u32 opcode) /* BSET */
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_iword(2);
{	uaecptr tmppc = m68k_getpc() + 4;
	uaecptr dsta = get_disp_ea_000(tmppc, get_iword(4));
{	uae_s8 dst = get_byte(dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte(dsta,dst);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_a30_2(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s8 dst = get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_a70_2(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s16 dst = get_word(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
#endif

#ifdef PART_2
unsigned long REGPARAM2 op_ab0_2(uae_u32 opcode) /* EOR */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
{	uae_s32 dst = get_long(dsta);
	src ^= dst;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_long(dsta,src);
}}}}m68k_incpc(8);
return 16;
}
unsigned long REGPARAM2 op_c30_2(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_c3b_2(uae_u32 opcode) /* CMP */
{
	uae_u32 dstreg = 3;
{{	uae_s8 src = get_ibyte(2);
{	uaecptr tmppc = m68k_getpc() + 4;
	uaecptr dsta = get_disp_ea_000(tmppc, get_iword(4));
{	uae_s8 dst = get_byte(dsta);
{{uae_u32 newv = ((uae_s8)(dst)) - ((uae_s8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_c70_2(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s16 src = get_iword(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_c7b_2(uae_u32 opcode) /* CMP */
{
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_iword(2);
{	uaecptr tmppc = m68k_getpc() + 4;
	uaecptr dsta = get_disp_ea_000(tmppc, get_iword(4));
{	uae_s16 dst = get_word(dsta);
{{uae_u32 newv = ((uae_s16)(dst)) - ((uae_s16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_cb0_2(uae_u32 opcode) /* CMP */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 8) & 7;
#else
	uae_u32 dstreg = opcode & 7;
#endif
{{	uae_s32 src = get_ilong(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_cbb_2(uae_u32 opcode) /* CMP */
{
	uae_u32 dstreg = 3;
{{	uae_s32 src = get_ilong(2);
{	uaecptr tmppc = m68k_getpc() + 6;
	uaecptr dsta = get_disp_ea_000(tmppc, get_iword(6));
{	uae_s32 dst = get_long(dsta);
{{uae_u32 newv = ((uae_s32)(dst)) - ((uae_s32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_1030_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
{	uae_s8 src = get_byte(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_103b_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr tmppc = m68k_getpc() + 2;
	uaecptr srca = get_disp_ea_000(tmppc, get_iword(2));
{	uae_s8 src = get_byte(srca);
{	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_10b0_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_10bb_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr tmppc = m68k_getpc() + 2;
	uaecptr srca = get_disp_ea_000(tmppc, get_iword(2));
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_10f0_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_10fb_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr tmppc = m68k_getpc() + 2;
	uaecptr srca = get_disp_ea_000(tmppc, get_iword(2));
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1130_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_113b_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr tmppc = m68k_getpc() + 2;
	uaecptr srca = get_disp_ea_000(tmppc, get_iword(2));
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1170_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_117b_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr tmppc = m68k_getpc() + 2;
	uaecptr srca = get_disp_ea_000(tmppc, get_iword(2));
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_1180_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = m68k_dreg(regs, srcreg);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}m68k_incpc(4);
return 6;
}
unsigned long REGPARAM2 op_1190_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_1198_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg);
{	uae_s8 src = get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_11a0_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte(srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(2));
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(4);
return 8;
}
unsigned long REGPARAM2 op_11a8_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_11b0_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_11b8_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_11b9_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = get_ilong(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(6));
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(8);
return 12;
}
unsigned long REGPARAM2 op_11ba_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr srca = m68k_getpc () + 2;
	srca += (uae_s32)(uae_s16)get_iword(2);
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_11bb_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uaecptr tmppc = m68k_getpc() + 2;
	uaecptr srca = get_disp_ea_000(tmppc, get_iword(2));
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_11bc_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 dstreg = (opcode >> 1) & 7;
#else
	uae_u32 dstreg = (opcode >> 9) & 7;
#endif
{{	uae_s8 src = get_ibyte(2);
{	uaecptr dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_iword(4));
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}m68k_incpc(6);
return 8;
}
unsigned long REGPARAM2 op_11f0_2(uae_u32 opcode) /* MOVE */
{
#ifdef HAVE_GET_WORD_UNSWAPPED
	uae_u32 srcreg = ((opcode >> 8) & 7);
#else
	uae_u32 srcreg = (opcode & 7);
#endif
{{	uaecptr srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_iword(2));
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_11fb_2(uae_u32 opcode) /* MOVE */
{
{{	uaecptr tmppc = m68k_getpc() + 2;
	uaecptr srca = get_disp_ea_000(tmppc, get_iword(2));
{	uae_s8 src = get_byte(srca);
{	uaecptr dsta = (uae_s32)(uae_s16)get_iword(4);
	CLEAR_CZNV;
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte(dsta,src);
}}}}m68k_incpc(6);
return 10;
}
unsigned long REGPARAM2 op_13f0_2(uae_u32 op