/**
 * @file Cosa/Canvas/Icon/arduino_icon_34x32.h
 * @version 1.0
 *
 * @section License
 * Copyright (C) 2012-2014, Mikael Patel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * This file is part of the Arduino Che Cosa project.
 */

#ifndef COSA_CANVAS_ICON_ARDUINO_34X32_H
#define COSA_CANVAS_ICON_ARDUINO_34X32_H

/**
 * Arduino icon 34x32.
 *
 * @section Acknowledgements
 * Originates from the GLCD library and adapted for Cosa Canvas.
 * The GLCD library was created by Michael Margolis and improved 
 * by Bill Perry.
 */
const uint8_t arduino_icon_34x32[] __PROGMEM = {
  34,32,
  0x00,0xc0,0x20,0x10,0x08,0xc8,0x88,0x08,0x08,0x10,0x20,0xc0,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0xc0,0xf0,0xf8,0xf8,0xf8,0xf0,0xc0,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,
  0x07,0x18,0x20,0x40,0x80,0x9f,0x8f,0x87,0x82,0x40,0x20,0x18,0x7,0x00,0x00,0x00,
  0x00,0x80,0xf0,0xfe,0xff,0xff,0x1f,0x03,0x1f,0xff,0xff,0xfe,0xf0,0x80,0x00,0x00,
  0x00,0x00,
  0xc0,0x30,0x08,0x04,0xe2,0x22,0x22,0x22,0xe2,0x04,0x08,0x30,0xc0,0x00,0x00,0xe0,
  0xfc,0xff,0xff,0x7f,0x7f,0x78,0x78,0x78,0x78,0x78,0x7f,0x7f,0xff,0xff,0xfc,0xe0,
  0x00,0x00,
  0x01,0x06,0x08,0x10,0x23,0x22,0x22,0x22,0x23,0x10,0x08,0x06,0x01,0x18,0x3f,0x3f,
  0x3f,0x0f,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x0f,0x3f,0x3f,
  0x3f,0x18
};

#endif
