/**
 * @file Cosa/Canvas/Icon/arduino_icon_64x64.h
 * @version 1.0
 *
 * @section License
 * Copyright (C) 2012-2014, Mikael Patel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * This file is part of the Arduino Che Cosa project.
 */

#ifndef COSA_CANVAS_ICON_ARDUINO_64X64_H
#define COSA_CANVAS_ICON_ARDUINO_64X64_H

/**
 * Arduino icon 64x64.
 *
 * @section Acknowledgements
 * Originates from the GLCD library and adapted for Cosa Canvas.
 * The GLCD library was created by Michael Margolis and improved 
 * by Bill Perry.
 */
const uint8_t arduino_icon_64x64[] __PROGMEM = {
  64,64,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x40,0x20,0x20,0x20,0x20,0x20,0x40,
  0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xe0,0xe0,0xe0,
  0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x63,0x80,0x00,0x00,0x7f,0x3e,0x1c,0x08,0x00,
  0x80,0x63,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xf8,0xff,0xff,0x7f,0x0f,0x7f,
  0xff,0xff,0xf8,0xc0,0x00,0x00,0x00,0x00,0x00,0x80,0x40,0x20,0x3f,0x20,0x40,0x80,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x20,0x11,0x8a,0x8a,0x8a,0x8a,0x8a,0x11,
  0x20,0xc0,0x00,0x00,0x00,0x00,0x80,0xf0,0xfe,0xff,0xff,0xff,0xe3,0xe0,0xe0,0xe0,
  0xe3,0xff,0xff,0xff,0xfe,0xf0,0x80,0x00,0x00,0x81,0x42,0x24,0x24,0x24,0x42,0x85,
  0x28,0x20,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x18,0x20,0x40,0x8f,0x88,0x88,0x88,0x8f,0x40,
  0x20,0x18,0x07,0x00,0x60,0xfc,0xff,0xff,0x3f,0x07,0x01,0x01,0x01,0x01,0x01,0x01,
  0x01,0x01,0x01,0x07,0x3f,0xff,0xff,0xfc,0x60,0x01,0x02,0x04,0xfc,0x24,0x22,0x21,
  0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
  0x40,0x40,0x40,0x40,0x40,0x70,0x0c,0x30,0xc0,0x00,0xc0,0x30,0x0c,0x30,0xc0,0x00,
  0xc0,0x30,0x08,0x08,0x88,0x48,0x28,0x28,0x38,0x20,0x20,0x40,0x80,0x40,0x20,0x10,
  0x20,0x98,0x18,0xc0,0xc0,0x00,0x00,0x00,0x20,0x30,0x50,0x48,0x8f,0x80,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x01,
  0x00,0x00,0x1c,0x63,0x80,0x46,0x4a,0x52,0x62,0x52,0x4a,0x46,0x80,0x63,0x1c,0x02,
  0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x08,0x08,0x14,0x14,0xa2,0xa2,0x41,0x41,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x02,0xfe,0x02,0x02,0x01,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x02,0x05,0xfd,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x02,0x0a,0x0a,0x2b,0x0a,0x0a,0x02,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x02,0x0a,0x2b,0x0a,0x02,0x02,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

#endif
