"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from friendli.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from friendli.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, NotRequired, TypedDict


class ResponseFormatJSONObjectTypedDict(TypedDict):
    type: Literal["json_object"]
    r"""The type of the response format: `json_object`"""
    schema_: NotRequired[Nullable[str]]
    r"""The serialized JSON schema string to enforce as the response format.
    Note that recursive definitions are not supported. Optional properties are also unsupported; all properties defined under `{ \"type\": \"object\" }` will be generated, regardless of their inclusion in the required field.

    """


class ResponseFormatJSONObject(BaseModel):
    TYPE: Annotated[
        Annotated[
            Literal["json_object"], AfterValidator(validate_const("json_object"))
        ],
        pydantic.Field(alias="type"),
    ] = "json_object"
    r"""The type of the response format: `json_object`"""

    schema_: Annotated[
        OptionalNullable[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible.",
            alias="schema",
        ),
    ] = UNSET
    r"""The serialized JSON schema string to enforce as the response format.
    Note that recursive definitions are not supported. Optional properties are also unsupported; all properties defined under `{ \"type\": \"object\" }` will be generated, regardless of their inclusion in the required field.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["schema"]
        nullable_fields = ["schema"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
