"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from friendli.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from friendli.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, NotRequired, TypedDict


class ToolMessageTypedDict(TypedDict):
    content: str
    r"""The content of tool message that contains the result of tool calling."""
    tool_call_id: str
    r"""The ID of tool call corresponding to this message."""
    role: Literal["tool"]
    r"""The role of the messages author."""
    name: NotRequired[Nullable[str]]
    r"""An optional name of the tool call corresponding to this message."""


class ToolMessage(BaseModel):
    content: str
    r"""The content of tool message that contains the result of tool calling."""

    tool_call_id: str
    r"""The ID of tool call corresponding to this message."""

    ROLE: Annotated[
        Annotated[Literal["tool"], AfterValidator(validate_const("tool"))],
        pydantic.Field(alias="role"),
    ] = "tool"
    r"""The role of the messages author."""

    name: OptionalNullable[str] = UNSET
    r"""An optional name of the tool call corresponding to this message."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["name"]
        nullable_fields = ["name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
